//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for DMA
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __DMA_REG_BLOCK_SV__
`define __DMA_REG_BLOCK_SV__

//--------------------------------------------------------------------
// CH_LLI_ROOT0
//--------------------------------------------------------------------
class CH_LLI_ROOT0 extends uvm_reg;
    `uvm_object_utils(CH_LLI_ROOT0)
    rand uvm_reg_field CH_LLI_ROOT0;

    //---build------------------------------------------------------------
    virtual function void build();
        CH_LLI_ROOT0 = uvm_reg_field::type_id::create("CH_LLI_ROOT0");

        CH_LLI_ROOT0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_CH_LLI_ROOT0_wr_cg";
        CH_LLI_ROOT0_wr : coverpoint CH_LLI_ROOT0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_CH_LLI_ROOT0_rd_cg";
        CH_LLI_ROOT0_rd : coverpoint CH_LLI_ROOT0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CH_LLI_ROOT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CH_LLI_ROOT1
//--------------------------------------------------------------------
class CH_LLI_ROOT1 extends uvm_reg;
    `uvm_object_utils(CH_LLI_ROOT1)
    rand uvm_reg_field CH_LLI_ROOT1;

    //---build------------------------------------------------------------
    virtual function void build();
        CH_LLI_ROOT1 = uvm_reg_field::type_id::create("CH_LLI_ROOT1");

        CH_LLI_ROOT1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_CH_LLI_ROOT1_wr_cg";
        CH_LLI_ROOT1_wr : coverpoint CH_LLI_ROOT1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_CH_LLI_ROOT1_rd_cg";
        CH_LLI_ROOT1_rd : coverpoint CH_LLI_ROOT1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CH_LLI_ROOT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CH_LLI_ROOT2
//--------------------------------------------------------------------
class CH_LLI_ROOT2 extends uvm_reg;
    `uvm_object_utils(CH_LLI_ROOT2)
    rand uvm_reg_field CH_LLI_ROOT2;

    //---build------------------------------------------------------------
    virtual function void build();
        CH_LLI_ROOT2 = uvm_reg_field::type_id::create("CH_LLI_ROOT2");

        CH_LLI_ROOT2.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_CH_LLI_ROOT2_wr_cg";
        CH_LLI_ROOT2_wr : coverpoint CH_LLI_ROOT2.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_CH_LLI_ROOT2_rd_cg";
        CH_LLI_ROOT2_rd : coverpoint CH_LLI_ROOT2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CH_LLI_ROOT2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CH_LLI_ROOT3
//--------------------------------------------------------------------
class CH_LLI_ROOT3 extends uvm_reg;
    `uvm_object_utils(CH_LLI_ROOT3)
    rand uvm_reg_field CH_LLI_ROOT3;

    //---build------------------------------------------------------------
    virtual function void build();
        CH_LLI_ROOT3 = uvm_reg_field::type_id::create("CH_LLI_ROOT3");

        CH_LLI_ROOT3.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_CH_LLI_ROOT3_wr_cg";
        CH_LLI_ROOT3_wr : coverpoint CH_LLI_ROOT3.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_CH_LLI_ROOT3_rd_cg";
        CH_LLI_ROOT3_rd : coverpoint CH_LLI_ROOT3.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CH_LLI_ROOT3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DMA_STATUS
//--------------------------------------------------------------------
class DMA_STATUS extends uvm_reg;
    `uvm_object_utils(DMA_STATUS)
    rand uvm_reg_field CH4_STOPPED;
    rand uvm_reg_field MID_STREAM_BSY;
    rand uvm_reg_field DOWN_STREAM_BSY;
    rand uvm_reg_field UP_STREAM_BSY;
    rand uvm_reg_field ARB_Q4_VALID;
    rand uvm_reg_field ARB_Q3_VALID;
    rand uvm_reg_field ARB_Q2_VALID;
    rand uvm_reg_field ARB_Q1_VALID;
    rand uvm_reg_field ARB_Q0_VALID;
    rand uvm_reg_field REQUEST_STATE;
    rand uvm_reg_field CH3_STOPPED;
    rand uvm_reg_field CH2_STOPPED;
    rand uvm_reg_field CH1_STOPPED;
    rand uvm_reg_field CH0_STOPPED;
    rand uvm_reg_field OFT_FREE;

    //---build------------------------------------------------------------
    virtual function void build();
        CH4_STOPPED = uvm_reg_field::type_id::create("CH4_STOPPED");
        MID_STREAM_BSY = uvm_reg_field::type_id::create("MID_STREAM_BSY");
        DOWN_STREAM_BSY = uvm_reg_field::type_id::create("DOWN_STREAM_BSY");
        UP_STREAM_BSY = uvm_reg_field::type_id::create("UP_STREAM_BSY");
        ARB_Q4_VALID = uvm_reg_field::type_id::create("ARB_Q4_VALID");
        ARB_Q3_VALID = uvm_reg_field::type_id::create("ARB_Q3_VALID");
        ARB_Q2_VALID = uvm_reg_field::type_id::create("ARB_Q2_VALID");
        ARB_Q1_VALID = uvm_reg_field::type_id::create("ARB_Q1_VALID");
        ARB_Q0_VALID = uvm_reg_field::type_id::create("ARB_Q0_VALID");
        REQUEST_STATE = uvm_reg_field::type_id::create("REQUEST_STATE");
        CH3_STOPPED = uvm_reg_field::type_id::create("CH3_STOPPED");
        CH2_STOPPED = uvm_reg_field::type_id::create("CH2_STOPPED");
        CH1_STOPPED = uvm_reg_field::type_id::create("CH1_STOPPED");
        CH0_STOPPED = uvm_reg_field::type_id::create("CH0_STOPPED");
        OFT_FREE = uvm_reg_field::type_id::create("OFT_FREE");

        CH4_STOPPED.configure(this, 1, 31, "RO", 1, 'b0, 1, 1, 1);
        MID_STREAM_BSY.configure(this, 1, 30, "RO", 1, 'b0, 1, 1, 1);
        DOWN_STREAM_BSY.configure(this, 1, 29, "RO", 1, 'b0, 1, 1, 1);
        UP_STREAM_BSY.configure(this, 1, 28, "RO", 1, 'b0, 1, 1, 1);
        ARB_Q4_VALID.configure(this, 1, 27, "RO", 1, 'b0, 1, 1, 1);
        ARB_Q3_VALID.configure(this, 1, 26, "RO", 1, 'b0, 1, 1, 1);
        ARB_Q2_VALID.configure(this, 1, 25, "RO", 1, 'b0, 1, 1, 1);
        ARB_Q1_VALID.configure(this, 1, 24, "RO", 1, 'b0, 1, 1, 1);
        ARB_Q0_VALID.configure(this, 1, 23, "RO", 1, 'b0, 1, 1, 1);
        REQUEST_STATE.configure(this, 3, 20, "RO", 1, 'b00, 1, 1, 1);
        CH3_STOPPED.configure(this, 1, 19, "RO", 1, 'b0, 1, 1, 1);
        CH2_STOPPED.configure(this, 1, 18, "RO", 1, 'b0, 1, 1, 1);
        CH1_STOPPED.configure(this, 1, 17, "RO", 1, 'b0, 1, 1, 1);
        CH0_STOPPED.configure(this, 1, 16, "RO", 1, 'b0, 1, 1, 1);
        OFT_FREE.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_DMA_STATUS_rd_cg";
        CH4_STOPPED_rd : coverpoint CH4_STOPPED.value[0:0];
        MID_STREAM_BSY_rd : coverpoint MID_STREAM_BSY.value[0:0];
        DOWN_STREAM_BSY_rd : coverpoint DOWN_STREAM_BSY.value[0:0];
        UP_STREAM_BSY_rd : coverpoint UP_STREAM_BSY.value[0:0];
        ARB_Q4_VALID_rd : coverpoint ARB_Q4_VALID.value[0:0];
        ARB_Q3_VALID_rd : coverpoint ARB_Q3_VALID.value[0:0];
        ARB_Q2_VALID_rd : coverpoint ARB_Q2_VALID.value[0:0];
        ARB_Q1_VALID_rd : coverpoint ARB_Q1_VALID.value[0:0];
        ARB_Q0_VALID_rd : coverpoint ARB_Q0_VALID.value[0:0];
        REQUEST_STATE_rd : coverpoint REQUEST_STATE.value[2:0];
        CH3_STOPPED_rd : coverpoint CH3_STOPPED.value[0:0];
        CH2_STOPPED_rd : coverpoint CH2_STOPPED.value[0:0];
        CH1_STOPPED_rd : coverpoint CH1_STOPPED.value[0:0];
        CH0_STOPPED_rd : coverpoint CH0_STOPPED.value[0:0];
        OFT_FREE_rd : coverpoint OFT_FREE.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DMA_STATUS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_RAWSTATUS
//--------------------------------------------------------------------
class INT_RAWSTATUS extends uvm_reg;
    `uvm_object_utils(INT_RAWSTATUS)
    rand uvm_reg_field CH4_EOT;
    rand uvm_reg_field CH3_EOT;
    rand uvm_reg_field CH2_EOT;
    rand uvm_reg_field CH1_EOT;
    rand uvm_reg_field CH0_EOT;
    rand uvm_reg_field ERROR;
    rand uvm_reg_field LLI_IRQ;

    //---build------------------------------------------------------------
    virtual function void build();
        CH4_EOT = uvm_reg_field::type_id::create("CH4_EOT");
        CH3_EOT = uvm_reg_field::type_id::create("CH3_EOT");
        CH2_EOT = uvm_reg_field::type_id::create("CH2_EOT");
        CH1_EOT = uvm_reg_field::type_id::create("CH1_EOT");
        CH0_EOT = uvm_reg_field::type_id::create("CH0_EOT");
        ERROR = uvm_reg_field::type_id::create("ERROR");
        LLI_IRQ = uvm_reg_field::type_id::create("LLI_IRQ");

        CH4_EOT.configure(this, 1, 24, "RO", 1, 'b0, 1, 1, 1);
        CH3_EOT.configure(this, 1, 23, "RO", 1, 'b0, 1, 1, 1);
        CH2_EOT.configure(this, 1, 22, "RO", 1, 'b0, 1, 1, 1);
        CH1_EOT.configure(this, 1, 21, "RO", 1, 'b0, 1, 1, 1);
        CH0_EOT.configure(this, 1, 20, "RO", 1, 'b0, 1, 1, 1);
        ERROR.configure(this, 1, 16, "RO", 1, 'b0, 1, 1, 1);
        LLI_IRQ.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_INT_RAWSTATUS_rd_cg";
        CH4_EOT_rd : coverpoint CH4_EOT.value[0:0];
        CH3_EOT_rd : coverpoint CH3_EOT.value[0:0];
        CH2_EOT_rd : coverpoint CH2_EOT.value[0:0];
        CH1_EOT_rd : coverpoint CH1_EOT.value[0:0];
        CH0_EOT_rd : coverpoint CH0_EOT.value[0:0];
        ERROR_rd : coverpoint ERROR.value[0:0];
        LLI_IRQ_rd : coverpoint LLI_IRQ.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_RAWSTATUS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_UNMASK_SET
//--------------------------------------------------------------------
class INT_UNMASK_SET extends uvm_reg;
    `uvm_object_utils(INT_UNMASK_SET)
    rand uvm_reg_field CH4_EOT;
    rand uvm_reg_field CH3_EOT;
    rand uvm_reg_field CH2_EOT;
    rand uvm_reg_field CH1_EOT;
    rand uvm_reg_field CH0_EOT;
    rand uvm_reg_field ERROR;
    rand uvm_reg_field LLI_IRQ;

    //---build------------------------------------------------------------
    virtual function void build();
        CH4_EOT = uvm_reg_field::type_id::create("CH4_EOT");
        CH3_EOT = uvm_reg_field::type_id::create("CH3_EOT");
        CH2_EOT = uvm_reg_field::type_id::create("CH2_EOT");
        CH1_EOT = uvm_reg_field::type_id::create("CH1_EOT");
        CH0_EOT = uvm_reg_field::type_id::create("CH0_EOT");
        ERROR = uvm_reg_field::type_id::create("ERROR");
        LLI_IRQ = uvm_reg_field::type_id::create("LLI_IRQ");

        CH4_EOT.configure(this, 1, 24, "W1S", 1, 'b0, 1, 1, 1);
        CH3_EOT.configure(this, 1, 23, "W1S", 1, 'b0, 1, 1, 1);
        CH2_EOT.configure(this, 1, 22, "W1S", 1, 'b0, 1, 1, 1);
        CH1_EOT.configure(this, 1, 21, "W1S", 1, 'b0, 1, 1, 1);
        CH0_EOT.configure(this, 1, 20, "W1S", 1, 'b0, 1, 1, 1);
        ERROR.configure(this, 1, 16, "W1S", 1, 'b0, 1, 1, 1);
        LLI_IRQ.configure(this, 16, 0, "W1S", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_INT_UNMASK_SET_wr_cg";
        CH4_EOT_wr : coverpoint CH4_EOT.value[0:0];
        CH3_EOT_wr : coverpoint CH3_EOT.value[0:0];
        CH2_EOT_wr : coverpoint CH2_EOT.value[0:0];
        CH1_EOT_wr : coverpoint CH1_EOT.value[0:0];
        CH0_EOT_wr : coverpoint CH0_EOT.value[0:0];
        ERROR_wr : coverpoint ERROR.value[0:0];
        LLI_IRQ_wr : coverpoint LLI_IRQ.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_UNMASK_SET");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_UNMASK_CLEAR
//--------------------------------------------------------------------
class INT_UNMASK_CLEAR extends uvm_reg;
    `uvm_object_utils(INT_UNMASK_CLEAR)
    rand uvm_reg_field CH4_EOT;
    rand uvm_reg_field CH3_EOT;
    rand uvm_reg_field CH2_EOT;
    rand uvm_reg_field CH1_EOT;
    rand uvm_reg_field CH0_EOT;
    rand uvm_reg_field ERROR;
    rand uvm_reg_field LLI_IRQ;

    //---build------------------------------------------------------------
    virtual function void build();
        CH4_EOT = uvm_reg_field::type_id::create("CH4_EOT");
        CH3_EOT = uvm_reg_field::type_id::create("CH3_EOT");
        CH2_EOT = uvm_reg_field::type_id::create("CH2_EOT");
        CH1_EOT = uvm_reg_field::type_id::create("CH1_EOT");
        CH0_EOT = uvm_reg_field::type_id::create("CH0_EOT");
        ERROR = uvm_reg_field::type_id::create("ERROR");
        LLI_IRQ = uvm_reg_field::type_id::create("LLI_IRQ");

        CH4_EOT.configure(this, 1, 24, "W1C", 1, 'b0, 1, 1, 1);
        CH3_EOT.configure(this, 1, 23, "W1C", 1, 'b0, 1, 1, 1);
        CH2_EOT.configure(this, 1, 22, "W1C", 1, 'b0, 1, 1, 1);
        CH1_EOT.configure(this, 1, 21, "W1C", 1, 'b0, 1, 1, 1);
        CH0_EOT.configure(this, 1, 20, "W1C", 1, 'b0, 1, 1, 1);
        ERROR.configure(this, 1, 16, "W1C", 1, 'b0, 1, 1, 1);
        LLI_IRQ.configure(this, 16, 0, "W1C", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_INT_UNMASK_CLEAR_wr_cg";
        CH4_EOT_wr : coverpoint CH4_EOT.value[0:0];
        CH3_EOT_wr : coverpoint CH3_EOT.value[0:0];
        CH2_EOT_wr : coverpoint CH2_EOT.value[0:0];
        CH1_EOT_wr : coverpoint CH1_EOT.value[0:0];
        CH0_EOT_wr : coverpoint CH0_EOT.value[0:0];
        ERROR_wr : coverpoint ERROR.value[0:0];
        LLI_IRQ_wr : coverpoint LLI_IRQ.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_UNMASK_CLEAR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_ACK
//--------------------------------------------------------------------
class INT_ACK extends uvm_reg;
    `uvm_object_utils(INT_ACK)
    rand uvm_reg_field CH4_EOT;
    rand uvm_reg_field CH3_EOT;
    rand uvm_reg_field CH2_EOT;
    rand uvm_reg_field CH1_EOT;
    rand uvm_reg_field CH0_EOT;
    rand uvm_reg_field ERROR;
    rand uvm_reg_field LLI_IRQ;

    //---build------------------------------------------------------------
    virtual function void build();
        CH4_EOT = uvm_reg_field::type_id::create("CH4_EOT");
        CH3_EOT = uvm_reg_field::type_id::create("CH3_EOT");
        CH2_EOT = uvm_reg_field::type_id::create("CH2_EOT");
        CH1_EOT = uvm_reg_field::type_id::create("CH1_EOT");
        CH0_EOT = uvm_reg_field::type_id::create("CH0_EOT");
        ERROR = uvm_reg_field::type_id::create("ERROR");
        LLI_IRQ = uvm_reg_field::type_id::create("LLI_IRQ");

        CH4_EOT.configure(this, 1, 24, "W1C", 1, 'b0, 1, 1, 1);
        CH3_EOT.configure(this, 1, 23, "W1C", 1, 'b0, 1, 1, 1);
        CH2_EOT.configure(this, 1, 22, "W1C", 1, 'b0, 1, 1, 1);
        CH1_EOT.configure(this, 1, 21, "W1C", 1, 'b0, 1, 1, 1);
        CH0_EOT.configure(this, 1, 20, "W1C", 1, 'b0, 1, 1, 1);
        ERROR.configure(this, 1, 16, "W1C", 1, 'b0, 1, 1, 1);
        LLI_IRQ.configure(this, 16, 0, "W1C", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_INT_ACK_wr_cg";
        CH4_EOT_wr : coverpoint CH4_EOT.value[0:0];
        CH3_EOT_wr : coverpoint CH3_EOT.value[0:0];
        CH2_EOT_wr : coverpoint CH2_EOT.value[0:0];
        CH1_EOT_wr : coverpoint CH1_EOT.value[0:0];
        CH0_EOT_wr : coverpoint CH0_EOT.value[0:0];
        ERROR_wr : coverpoint ERROR.value[0:0];
        LLI_IRQ_wr : coverpoint LLI_IRQ.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_ACK");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_STATUS
//--------------------------------------------------------------------
class INT_STATUS extends uvm_reg;
    `uvm_object_utils(INT_STATUS)
    rand uvm_reg_field CH4_EOT;
    rand uvm_reg_field CH3_EOT;
    rand uvm_reg_field CH2_EOT;
    rand uvm_reg_field CH1_EOT;
    rand uvm_reg_field CH0_EOT;
    rand uvm_reg_field ERROR;
    rand uvm_reg_field LLI_IRQ;

    //---build------------------------------------------------------------
    virtual function void build();
        CH4_EOT = uvm_reg_field::type_id::create("CH4_EOT");
        CH3_EOT = uvm_reg_field::type_id::create("CH3_EOT");
        CH2_EOT = uvm_reg_field::type_id::create("CH2_EOT");
        CH1_EOT = uvm_reg_field::type_id::create("CH1_EOT");
        CH0_EOT = uvm_reg_field::type_id::create("CH0_EOT");
        ERROR = uvm_reg_field::type_id::create("ERROR");
        LLI_IRQ = uvm_reg_field::type_id::create("LLI_IRQ");

        CH4_EOT.configure(this, 1, 24, "RO", 1, 'b0, 1, 1, 1);
        CH3_EOT.configure(this, 1, 23, "RO", 1, 'b0, 1, 1, 1);
        CH2_EOT.configure(this, 1, 22, "RO", 1, 'b0, 1, 1, 1);
        CH1_EOT.configure(this, 1, 21, "RO", 1, 'b0, 1, 1, 1);
        CH0_EOT.configure(this, 1, 20, "RO", 1, 'b0, 1, 1, 1);
        ERROR.configure(this, 1, 16, "RO", 1, 'b0, 1, 1, 1);
        LLI_IRQ.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_INT_STATUS_rd_cg";
        CH4_EOT_rd : coverpoint CH4_EOT.value[0:0];
        CH3_EOT_rd : coverpoint CH3_EOT.value[0:0];
        CH2_EOT_rd : coverpoint CH2_EOT.value[0:0];
        CH1_EOT_rd : coverpoint CH1_EOT.value[0:0];
        CH0_EOT_rd : coverpoint CH0_EOT.value[0:0];
        ERROR_rd : coverpoint ERROR.value[0:0];
        LLI_IRQ_rd : coverpoint LLI_IRQ.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_STATUS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ARBITRATION
//--------------------------------------------------------------------
class ARBITRATION extends uvm_reg;
    `uvm_object_utils(ARBITRATION)
    rand uvm_reg_field DOWNSTREAM_TAG_USAGE;

    //---build------------------------------------------------------------
    virtual function void build();
        DOWNSTREAM_TAG_USAGE = uvm_reg_field::type_id::create("DOWNSTREAM_TAG_USAGE");

        DOWNSTREAM_TAG_USAGE.configure(this, 4, 0, "RW", 1, 'b1100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_ARBITRATION_wr_cg";
        DOWNSTREAM_TAG_USAGE_wr : coverpoint DOWNSTREAM_TAG_USAGE.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_ARBITRATION_rd_cg";
        DOWNSTREAM_TAG_USAGE_rd : coverpoint DOWNSTREAM_TAG_USAGE.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ARBITRATION");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CHANNEL_MUTEX_SET
//--------------------------------------------------------------------
class CHANNEL_MUTEX_SET extends uvm_reg;
    `uvm_object_utils(CHANNEL_MUTEX_SET)
    rand uvm_reg_field CH4_MUTEX;
    rand uvm_reg_field CH3_MUTEX;
    rand uvm_reg_field CH2_MUTEX;
    rand uvm_reg_field CH1_MUTEX;
    rand uvm_reg_field CH0_MUTEX;

    //---build------------------------------------------------------------
    virtual function void build();
        CH4_MUTEX = uvm_reg_field::type_id::create("CH4_MUTEX");
        CH3_MUTEX = uvm_reg_field::type_id::create("CH3_MUTEX");
        CH2_MUTEX = uvm_reg_field::type_id::create("CH2_MUTEX");
        CH1_MUTEX = uvm_reg_field::type_id::create("CH1_MUTEX");
        CH0_MUTEX = uvm_reg_field::type_id::create("CH0_MUTEX");

        CH4_MUTEX.configure(this, 1, 4, "W1S", 1, 'b0, 1, 1, 1);
        CH3_MUTEX.configure(this, 1, 3, "W1S", 1, 'b0, 1, 1, 1);
        CH2_MUTEX.configure(this, 1, 2, "W1S", 1, 'b0, 1, 1, 1);
        CH1_MUTEX.configure(this, 1, 1, "W1S", 1, 'b0, 1, 1, 1);
        CH0_MUTEX.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_CHANNEL_MUTEX_SET_wr_cg";
        CH4_MUTEX_wr : coverpoint CH4_MUTEX.value[0:0];
        CH3_MUTEX_wr : coverpoint CH3_MUTEX.value[0:0];
        CH2_MUTEX_wr : coverpoint CH2_MUTEX.value[0:0];
        CH1_MUTEX_wr : coverpoint CH1_MUTEX.value[0:0];
        CH0_MUTEX_wr : coverpoint CH0_MUTEX.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CHANNEL_MUTEX_SET");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CHANNEL_MUTEX_CLEAR
//--------------------------------------------------------------------
class CHANNEL_MUTEX_CLEAR extends uvm_reg;
    `uvm_object_utils(CHANNEL_MUTEX_CLEAR)
    rand uvm_reg_field CH4_MUTEX;
    rand uvm_reg_field CH3_MUTEX;
    rand uvm_reg_field CH2_MUTEX;
    rand uvm_reg_field CH1_MUTEX;
    rand uvm_reg_field CH0_MUTEX;

    //---build------------------------------------------------------------
    virtual function void build();
        CH4_MUTEX = uvm_reg_field::type_id::create("CH4_MUTEX");
        CH3_MUTEX = uvm_reg_field::type_id::create("CH3_MUTEX");
        CH2_MUTEX = uvm_reg_field::type_id::create("CH2_MUTEX");
        CH1_MUTEX = uvm_reg_field::type_id::create("CH1_MUTEX");
        CH0_MUTEX = uvm_reg_field::type_id::create("CH0_MUTEX");

        CH4_MUTEX.configure(this, 1, 4, "W1C", 1, 'b0, 1, 1, 1);
        CH3_MUTEX.configure(this, 1, 3, "W1C", 1, 'b0, 1, 1, 1);
        CH2_MUTEX.configure(this, 1, 2, "W1C", 1, 'b0, 1, 1, 1);
        CH1_MUTEX.configure(this, 1, 1, "W1C", 1, 'b0, 1, 1, 1);
        CH0_MUTEX.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_CHANNEL_MUTEX_CLEAR_wr_cg";
        CH4_MUTEX_wr : coverpoint CH4_MUTEX.value[0:0];
        CH3_MUTEX_wr : coverpoint CH3_MUTEX.value[0:0];
        CH2_MUTEX_wr : coverpoint CH2_MUTEX.value[0:0];
        CH1_MUTEX_wr : coverpoint CH1_MUTEX.value[0:0];
        CH0_MUTEX_wr : coverpoint CH0_MUTEX.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CHANNEL_MUTEX_CLEAR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CH_LLI_ROOT4
//--------------------------------------------------------------------
class CH_LLI_ROOT4 extends uvm_reg;
    `uvm_object_utils(CH_LLI_ROOT4)
    rand uvm_reg_field CH_LLI_ROOT4;

    //---build------------------------------------------------------------
    virtual function void build();
        CH_LLI_ROOT4 = uvm_reg_field::type_id::create("CH_LLI_ROOT4");

        CH_LLI_ROOT4.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_CH_LLI_ROOT4_wr_cg";
        CH_LLI_ROOT4_wr : coverpoint CH_LLI_ROOT4.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_CH_LLI_ROOT4_rd_cg";
        CH_LLI_ROOT4_rd : coverpoint CH_LLI_ROOT4.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CH_LLI_ROOT4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// AXI_BURST_LENGTH_LIMIT
//--------------------------------------------------------------------
class AXI_BURST_LENGTH_LIMIT extends uvm_reg;
    `uvm_object_utils(AXI_BURST_LENGTH_LIMIT)
    rand uvm_reg_field AXI_BURST_LENGTH_LIMIT;

    //---build------------------------------------------------------------
    virtual function void build();
        AXI_BURST_LENGTH_LIMIT = uvm_reg_field::type_id::create("AXI_BURST_LENGTH_LIMIT");

        AXI_BURST_LENGTH_LIMIT.configure(this, 4, 0, "RW", 1, 'b1000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="DMA_AXI_BURST_LENGTH_LIMIT_wr_cg";
        AXI_BURST_LENGTH_LIMIT_wr : coverpoint AXI_BURST_LENGTH_LIMIT.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_AXI_BURST_LENGTH_LIMIT_rd_cg";
        AXI_BURST_LENGTH_LIMIT_rd : coverpoint AXI_BURST_LENGTH_LIMIT.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "AXI_BURST_LENGTH_LIMIT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER0
//--------------------------------------------------------------------
class LLI_COUNTER0 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER0)
    rand uvm_reg_field COUNTER0;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER0 = uvm_reg_field::type_id::create("COUNTER0");

        COUNTER0.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER0_rd_cg";
        COUNTER0_rd : coverpoint COUNTER0.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER1
//--------------------------------------------------------------------
class LLI_COUNTER1 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER1)
    rand uvm_reg_field COUNTER1;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER1 = uvm_reg_field::type_id::create("COUNTER1");

        COUNTER1.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER1_rd_cg";
        COUNTER1_rd : coverpoint COUNTER1.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER2
//--------------------------------------------------------------------
class LLI_COUNTER2 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER2)
    rand uvm_reg_field COUNTER2;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER2 = uvm_reg_field::type_id::create("COUNTER2");

        COUNTER2.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER2_rd_cg";
        COUNTER2_rd : coverpoint COUNTER2.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER3
//--------------------------------------------------------------------
class LLI_COUNTER3 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER3)
    rand uvm_reg_field COUNTER3;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER3 = uvm_reg_field::type_id::create("COUNTER3");

        COUNTER3.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER3_rd_cg";
        COUNTER3_rd : coverpoint COUNTER3.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER4
//--------------------------------------------------------------------
class LLI_COUNTER4 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER4)
    rand uvm_reg_field COUNTER4;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER4 = uvm_reg_field::type_id::create("COUNTER4");

        COUNTER4.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER4_rd_cg";
        COUNTER4_rd : coverpoint COUNTER4.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER5
//--------------------------------------------------------------------
class LLI_COUNTER5 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER5)
    rand uvm_reg_field COUNTER5;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER5 = uvm_reg_field::type_id::create("COUNTER5");

        COUNTER5.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER5_rd_cg";
        COUNTER5_rd : coverpoint COUNTER5.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER5");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER6
//--------------------------------------------------------------------
class LLI_COUNTER6 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER6)
    rand uvm_reg_field COUNTER6;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER6 = uvm_reg_field::type_id::create("COUNTER6");

        COUNTER6.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER6_rd_cg";
        COUNTER6_rd : coverpoint COUNTER6.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER6");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER7
//--------------------------------------------------------------------
class LLI_COUNTER7 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER7)
    rand uvm_reg_field COUNTER7;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER7 = uvm_reg_field::type_id::create("COUNTER7");

        COUNTER7.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER7_rd_cg";
        COUNTER7_rd : coverpoint COUNTER7.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER7");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER8
//--------------------------------------------------------------------
class LLI_COUNTER8 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER8)
    rand uvm_reg_field COUNTER8;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER8 = uvm_reg_field::type_id::create("COUNTER8");

        COUNTER8.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER8_rd_cg";
        COUNTER8_rd : coverpoint COUNTER8.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER8");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER9
//--------------------------------------------------------------------
class LLI_COUNTER9 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER9)
    rand uvm_reg_field COUNTER9;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER9 = uvm_reg_field::type_id::create("COUNTER9");

        COUNTER9.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER9_rd_cg";
        COUNTER9_rd : coverpoint COUNTER9.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER9");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER10
//--------------------------------------------------------------------
class LLI_COUNTER10 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER10)
    rand uvm_reg_field COUNTER10;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER10 = uvm_reg_field::type_id::create("COUNTER10");

        COUNTER10.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER10_rd_cg";
        COUNTER10_rd : coverpoint COUNTER10.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER10");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER11
//--------------------------------------------------------------------
class LLI_COUNTER11 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER11)
    rand uvm_reg_field COUNTER11;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER11 = uvm_reg_field::type_id::create("COUNTER11");

        COUNTER11.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER11_rd_cg";
        COUNTER11_rd : coverpoint COUNTER11.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER11");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER12
//--------------------------------------------------------------------
class LLI_COUNTER12 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER12)
    rand uvm_reg_field COUNTER12;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER12 = uvm_reg_field::type_id::create("COUNTER12");

        COUNTER12.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER12_rd_cg";
        COUNTER12_rd : coverpoint COUNTER12.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER12");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER13
//--------------------------------------------------------------------
class LLI_COUNTER13 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER13)
    rand uvm_reg_field COUNTER13;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER13 = uvm_reg_field::type_id::create("COUNTER13");

        COUNTER13.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER13_rd_cg";
        COUNTER13_rd : coverpoint COUNTER13.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER13");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER14
//--------------------------------------------------------------------
class LLI_COUNTER14 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER14)
    rand uvm_reg_field COUNTER14;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER14 = uvm_reg_field::type_id::create("COUNTER14");

        COUNTER14.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER14_rd_cg";
        COUNTER14_rd : coverpoint COUNTER14.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER14");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LLI_COUNTER15
//--------------------------------------------------------------------
class LLI_COUNTER15 extends uvm_reg;
    `uvm_object_utils(LLI_COUNTER15)
    rand uvm_reg_field COUNTER15;

    //---build------------------------------------------------------------
    virtual function void build();
        COUNTER15 = uvm_reg_field::type_id::create("COUNTER15");

        COUNTER15.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="DMA_LLI_COUNTER15_rd_cg";
        COUNTER15_rd : coverpoint COUNTER15.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LLI_COUNTER15");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class DMA_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(DMA_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins CH_LLI_ROOT0              = {'h0};
        bins CH_LLI_ROOT1              = {'h4};
        bins CH_LLI_ROOT2              = {'h8};
        bins CH_LLI_ROOT3              = {'hC};
        bins DMA_STATUS              = {'h10};
        bins INT_RAWSTATUS              = {'h14};
        bins INT_UNMASK_SET              = {'h18};
        bins INT_UNMASK_CLEAR              = {'h1C};
        bins INT_ACK              = {'h20};
        bins INT_STATUS              = {'h24};
        bins ARBITRATION              = {'h34};
        bins CHANNEL_MUTEX_SET              = {'h38};
        bins CHANNEL_MUTEX_CLEAR              = {'h3C};
        bins CH_LLI_ROOT4              = {'h40};
        bins AXI_BURST_LENGTH_LIMIT              = {'h44};
        bins LLI_COUNTER0              = {'h80};
        bins LLI_COUNTER1              = {'h84};
        bins LLI_COUNTER2              = {'h88};
        bins LLI_COUNTER3              = {'h8C};
        bins LLI_COUNTER4              = {'h90};
        bins LLI_COUNTER5              = {'h94};
        bins LLI_COUNTER6              = {'h98};
        bins LLI_COUNTER7              = {'h9C};
        bins LLI_COUNTER8              = {'hA0};
        bins LLI_COUNTER9              = {'hA4};
        bins LLI_COUNTER10              = {'hA8};
        bins LLI_COUNTER11              = {'hAC};
        bins LLI_COUNTER12              = {'hB0};
        bins LLI_COUNTER13              = {'hB4};
        bins LLI_COUNTER14              = {'hB8};
        bins LLI_COUNTER15              = {'hBC};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "DMA_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: DMA_reg_access_wrapper

//-------------------------------------------------------------------
// DMA_register_block
//--------------------------------------------------------------------
class DMA_register_block extends uvm_reg_block;
    `uvm_object_utils(DMA_register_block)

    rand CH_LLI_ROOT0 CH_LLI_ROOT0_reg;
    rand CH_LLI_ROOT1 CH_LLI_ROOT1_reg;
    rand CH_LLI_ROOT2 CH_LLI_ROOT2_reg;
    rand CH_LLI_ROOT3 CH_LLI_ROOT3_reg;
    rand DMA_STATUS DMA_STATUS_reg;
    rand INT_RAWSTATUS INT_RAWSTATUS_reg;
    rand INT_UNMASK_SET INT_UNMASK_SET_reg;
    rand INT_UNMASK_CLEAR INT_UNMASK_CLEAR_reg;
    rand INT_ACK INT_ACK_reg;
    rand INT_STATUS INT_STATUS_reg;
    rand ARBITRATION ARBITRATION_reg;
    rand CHANNEL_MUTEX_SET CHANNEL_MUTEX_SET_reg;
    rand CHANNEL_MUTEX_CLEAR CHANNEL_MUTEX_CLEAR_reg;
    rand CH_LLI_ROOT4 CH_LLI_ROOT4_reg;
    rand AXI_BURST_LENGTH_LIMIT AXI_BURST_LENGTH_LIMIT_reg;
    rand LLI_COUNTER0 LLI_COUNTER0_reg;
    rand LLI_COUNTER1 LLI_COUNTER1_reg;
    rand LLI_COUNTER2 LLI_COUNTER2_reg;
    rand LLI_COUNTER3 LLI_COUNTER3_reg;
    rand LLI_COUNTER4 LLI_COUNTER4_reg;
    rand LLI_COUNTER5 LLI_COUNTER5_reg;
    rand LLI_COUNTER6 LLI_COUNTER6_reg;
    rand LLI_COUNTER7 LLI_COUNTER7_reg;
    rand LLI_COUNTER8 LLI_COUNTER8_reg;
    rand LLI_COUNTER9 LLI_COUNTER9_reg;
    rand LLI_COUNTER10 LLI_COUNTER10_reg;
    rand LLI_COUNTER11 LLI_COUNTER11_reg;
    rand LLI_COUNTER12 LLI_COUNTER12_reg;
    rand LLI_COUNTER13 LLI_COUNTER13_reg;
    rand LLI_COUNTER14 LLI_COUNTER14_reg;
    rand LLI_COUNTER15 LLI_COUNTER15_reg;

    uvm_reg_map DMA_register_map; // Block map
    DMA_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "DMA_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = DMA_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        CH_LLI_ROOT0_reg = CH_LLI_ROOT0::type_id::create("CH_LLI_ROOT0");
        CH_LLI_ROOT0_reg.configure(this);
        CH_LLI_ROOT0_reg.build();

        CH_LLI_ROOT1_reg = CH_LLI_ROOT1::type_id::create("CH_LLI_ROOT1");
        CH_LLI_ROOT1_reg.configure(this);
        CH_LLI_ROOT1_reg.build();

        CH_LLI_ROOT2_reg = CH_LLI_ROOT2::type_id::create("CH_LLI_ROOT2");
        CH_LLI_ROOT2_reg.configure(this);
        CH_LLI_ROOT2_reg.build();

        CH_LLI_ROOT3_reg = CH_LLI_ROOT3::type_id::create("CH_LLI_ROOT3");
        CH_LLI_ROOT3_reg.configure(this);
        CH_LLI_ROOT3_reg.build();

        DMA_STATUS_reg = DMA_STATUS::type_id::create("DMA_STATUS");
        DMA_STATUS_reg.configure(this);
        DMA_STATUS_reg.build();

        INT_RAWSTATUS_reg = INT_RAWSTATUS::type_id::create("INT_RAWSTATUS");
        INT_RAWSTATUS_reg.configure(this);
        INT_RAWSTATUS_reg.build();

        INT_UNMASK_SET_reg = INT_UNMASK_SET::type_id::create("INT_UNMASK_SET");
        INT_UNMASK_SET_reg.configure(this);
        INT_UNMASK_SET_reg.build();

        INT_UNMASK_CLEAR_reg = INT_UNMASK_CLEAR::type_id::create("INT_UNMASK_CLEAR");
        INT_UNMASK_CLEAR_reg.configure(this);
        INT_UNMASK_CLEAR_reg.build();

        INT_ACK_reg = INT_ACK::type_id::create("INT_ACK");
        INT_ACK_reg.configure(this);
        INT_ACK_reg.build();

        INT_STATUS_reg = INT_STATUS::type_id::create("INT_STATUS");
        INT_STATUS_reg.configure(this);
        INT_STATUS_reg.build();

        ARBITRATION_reg = ARBITRATION::type_id::create("ARBITRATION");
        ARBITRATION_reg.configure(this);
        ARBITRATION_reg.build();

        CHANNEL_MUTEX_SET_reg = CHANNEL_MUTEX_SET::type_id::create("CHANNEL_MUTEX_SET");
        CHANNEL_MUTEX_SET_reg.configure(this);
        CHANNEL_MUTEX_SET_reg.build();

        CHANNEL_MUTEX_CLEAR_reg = CHANNEL_MUTEX_CLEAR::type_id::create("CHANNEL_MUTEX_CLEAR");
        CHANNEL_MUTEX_CLEAR_reg.configure(this);
        CHANNEL_MUTEX_CLEAR_reg.build();

        CH_LLI_ROOT4_reg = CH_LLI_ROOT4::type_id::create("CH_LLI_ROOT4");
        CH_LLI_ROOT4_reg.configure(this);
        CH_LLI_ROOT4_reg.build();

        AXI_BURST_LENGTH_LIMIT_reg = AXI_BURST_LENGTH_LIMIT::type_id::create("AXI_BURST_LENGTH_LIMIT");
        AXI_BURST_LENGTH_LIMIT_reg.configure(this);
        AXI_BURST_LENGTH_LIMIT_reg.build();

        LLI_COUNTER0_reg = LLI_COUNTER0::type_id::create("LLI_COUNTER0");
        LLI_COUNTER0_reg.configure(this);
        LLI_COUNTER0_reg.build();

        LLI_COUNTER1_reg = LLI_COUNTER1::type_id::create("LLI_COUNTER1");
        LLI_COUNTER1_reg.configure(this);
        LLI_COUNTER1_reg.build();

        LLI_COUNTER2_reg = LLI_COUNTER2::type_id::create("LLI_COUNTER2");
        LLI_COUNTER2_reg.configure(this);
        LLI_COUNTER2_reg.build();

        LLI_COUNTER3_reg = LLI_COUNTER3::type_id::create("LLI_COUNTER3");
        LLI_COUNTER3_reg.configure(this);
        LLI_COUNTER3_reg.build();

        LLI_COUNTER4_reg = LLI_COUNTER4::type_id::create("LLI_COUNTER4");
        LLI_COUNTER4_reg.configure(this);
        LLI_COUNTER4_reg.build();

        LLI_COUNTER5_reg = LLI_COUNTER5::type_id::create("LLI_COUNTER5");
        LLI_COUNTER5_reg.configure(this);
        LLI_COUNTER5_reg.build();

        LLI_COUNTER6_reg = LLI_COUNTER6::type_id::create("LLI_COUNTER6");
        LLI_COUNTER6_reg.configure(this);
        LLI_COUNTER6_reg.build();

        LLI_COUNTER7_reg = LLI_COUNTER7::type_id::create("LLI_COUNTER7");
        LLI_COUNTER7_reg.configure(this);
        LLI_COUNTER7_reg.build();

        LLI_COUNTER8_reg = LLI_COUNTER8::type_id::create("LLI_COUNTER8");
        LLI_COUNTER8_reg.configure(this);
        LLI_COUNTER8_reg.build();

        LLI_COUNTER9_reg = LLI_COUNTER9::type_id::create("LLI_COUNTER9");
        LLI_COUNTER9_reg.configure(this);
        LLI_COUNTER9_reg.build();

        LLI_COUNTER10_reg = LLI_COUNTER10::type_id::create("LLI_COUNTER10");
        LLI_COUNTER10_reg.configure(this);
        LLI_COUNTER10_reg.build();

        LLI_COUNTER11_reg = LLI_COUNTER11::type_id::create("LLI_COUNTER11");
        LLI_COUNTER11_reg.configure(this);
        LLI_COUNTER11_reg.build();

        LLI_COUNTER12_reg = LLI_COUNTER12::type_id::create("LLI_COUNTER12");
        LLI_COUNTER12_reg.configure(this);
        LLI_COUNTER12_reg.build();

        LLI_COUNTER13_reg = LLI_COUNTER13::type_id::create("LLI_COUNTER13");
        LLI_COUNTER13_reg.configure(this);
        LLI_COUNTER13_reg.build();

        LLI_COUNTER14_reg = LLI_COUNTER14::type_id::create("LLI_COUNTER14");
        LLI_COUNTER14_reg.configure(this);
        LLI_COUNTER14_reg.build();

        LLI_COUNTER15_reg = LLI_COUNTER15::type_id::create("LLI_COUNTER15");
        LLI_COUNTER15_reg.configure(this);
        LLI_COUNTER15_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        DMA_register_map = create_map("DMA_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        DMA_register_map.add_reg(CH_LLI_ROOT0_reg, 'h0, "RW");
        DMA_register_map.add_reg(CH_LLI_ROOT1_reg, 'h4, "RW");
        DMA_register_map.add_reg(CH_LLI_ROOT2_reg, 'h8, "RW");
        DMA_register_map.add_reg(CH_LLI_ROOT3_reg, 'hC, "RW");
        DMA_register_map.add_reg(DMA_STATUS_reg, 'h10, "RO");
        DMA_register_map.add_reg(INT_RAWSTATUS_reg, 'h14, "RO");
        DMA_register_map.add_reg(INT_UNMASK_SET_reg, 'h18, "RW");
        DMA_register_map.add_reg(INT_UNMASK_CLEAR_reg, 'h1C, "RW");
        DMA_register_map.add_reg(INT_ACK_reg, 'h20, "RW");
        DMA_register_map.add_reg(INT_STATUS_reg, 'h24, "RO");
        DMA_register_map.add_reg(ARBITRATION_reg, 'h34, "RW");
        DMA_register_map.add_reg(CHANNEL_MUTEX_SET_reg, 'h38, "RW");
        DMA_register_map.add_reg(CHANNEL_MUTEX_CLEAR_reg, 'h3C, "RW");
        DMA_register_map.add_reg(CH_LLI_ROOT4_reg, 'h40, "RW");
        DMA_register_map.add_reg(AXI_BURST_LENGTH_LIMIT_reg, 'h44, "RW");
        DMA_register_map.add_reg(LLI_COUNTER0_reg, 'h80, "RO");
        DMA_register_map.add_reg(LLI_COUNTER1_reg, 'h84, "RO");
        DMA_register_map.add_reg(LLI_COUNTER2_reg, 'h88, "RO");
        DMA_register_map.add_reg(LLI_COUNTER3_reg, 'h8C, "RO");
        DMA_register_map.add_reg(LLI_COUNTER4_reg, 'h90, "RO");
        DMA_register_map.add_reg(LLI_COUNTER5_reg, 'h94, "RO");
        DMA_register_map.add_reg(LLI_COUNTER6_reg, 'h98, "RO");
        DMA_register_map.add_reg(LLI_COUNTER7_reg, 'h9C, "RO");
        DMA_register_map.add_reg(LLI_COUNTER8_reg, 'hA0, "RO");
        DMA_register_map.add_reg(LLI_COUNTER9_reg, 'hA4, "RO");
        DMA_register_map.add_reg(LLI_COUNTER10_reg, 'hA8, "RO");
        DMA_register_map.add_reg(LLI_COUNTER11_reg, 'hAC, "RO");
        DMA_register_map.add_reg(LLI_COUNTER12_reg, 'hB0, "RO");
        DMA_register_map.add_reg(LLI_COUNTER13_reg, 'hB4, "RO");
        DMA_register_map.add_reg(LLI_COUNTER14_reg, 'hB8, "RO");
        DMA_register_map.add_reg(LLI_COUNTER15_reg, 'hBC, "RO");

        // Lock the register model and build the map
        lock_model();
        DMA_register_map.set_check_on_read();
    endfunction

endclass
`endif // __DMA_REG_BLOCK_SV__
