//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for HSU
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __HSU_REG_BLOCK_SV__
`define __HSU_REG_BLOCK_SV__

//--------------------------------------------------------------------
// REVISION
//--------------------------------------------------------------------
class REVISION extends uvm_reg;
    `uvm_object_utils(REVISION)
    rand uvm_reg_field RSA_4096;
    rand uvm_reg_field RSA_2048;
    rand uvm_reg_field RSA_1024;
    rand uvm_reg_field HMAC_SHA512_SHA384;
    rand uvm_reg_field HMAC_SHA256_SHA224;
    rand uvm_reg_field HMAC_SHA1;
    rand uvm_reg_field SHA_512_384;
    rand uvm_reg_field SHA_256_224;
    rand uvm_reg_field SHA_1;
    rand uvm_reg_field IP_CHK;
    rand uvm_reg_field AES_128_CMAC;
    rand uvm_reg_field TKIP_MIC;
    rand uvm_reg_field VERSION;

    //---build------------------------------------------------------------
    virtual function void build();
        RSA_4096 = uvm_reg_field::type_id::create("RSA_4096");
        RSA_2048 = uvm_reg_field::type_id::create("RSA_2048");
        RSA_1024 = uvm_reg_field::type_id::create("RSA_1024");
        HMAC_SHA512_SHA384 = uvm_reg_field::type_id::create("HMAC_SHA512_SHA384");
        HMAC_SHA256_SHA224 = uvm_reg_field::type_id::create("HMAC_SHA256_SHA224");
        HMAC_SHA1 = uvm_reg_field::type_id::create("HMAC_SHA1");
        SHA_512_384 = uvm_reg_field::type_id::create("SHA_512_384");
        SHA_256_224 = uvm_reg_field::type_id::create("SHA_256_224");
        SHA_1 = uvm_reg_field::type_id::create("SHA_1");
        IP_CHK = uvm_reg_field::type_id::create("IP_CHK");
        AES_128_CMAC = uvm_reg_field::type_id::create("AES_128_CMAC");
        TKIP_MIC = uvm_reg_field::type_id::create("TKIP_MIC");
        VERSION = uvm_reg_field::type_id::create("VERSION");

        RSA_4096.configure(this, 1, 27, "RO", 1, 'b1, 1, 1, 1);
        RSA_2048.configure(this, 1, 26, "RO", 1, 'b1, 1, 1, 1);
        RSA_1024.configure(this, 1, 25, "RO", 1, 'b1, 1, 1, 1);
        HMAC_SHA512_SHA384.configure(this, 1, 24, "RO", 1, 'b1, 1, 1, 1);
        HMAC_SHA256_SHA224.configure(this, 1, 23, "RO", 1, 'b1, 1, 1, 1);
        HMAC_SHA1.configure(this, 1, 22, "RO", 1, 'b1, 1, 1, 1);
        SHA_512_384.configure(this, 1, 21, "RO", 1, 'b1, 1, 1, 1);
        SHA_256_224.configure(this, 1, 20, "RO", 1, 'b1, 1, 1, 1);
        SHA_1.configure(this, 1, 19, "RO", 1, 'b1, 1, 1, 1);
        IP_CHK.configure(this, 1, 18, "RO", 1, 'b1, 1, 1, 1);
        AES_128_CMAC.configure(this, 1, 17, "RO", 1, 'b1, 1, 1, 1);
        TKIP_MIC.configure(this, 1, 16, "RO", 1, 'b1, 1, 1, 1);
        VERSION.configure(this, 16, 0, "RO", 1, 'b000000000001000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_REVISION_rd_cg";
        RSA_4096_rd : coverpoint RSA_4096.value[0:0];
        RSA_2048_rd : coverpoint RSA_2048.value[0:0];
        RSA_1024_rd : coverpoint RSA_1024.value[0:0];
        HMAC_SHA512_SHA384_rd : coverpoint HMAC_SHA512_SHA384.value[0:0];
        HMAC_SHA256_SHA224_rd : coverpoint HMAC_SHA256_SHA224.value[0:0];
        HMAC_SHA1_rd : coverpoint HMAC_SHA1.value[0:0];
        SHA_512_384_rd : coverpoint SHA_512_384.value[0:0];
        SHA_256_224_rd : coverpoint SHA_256_224.value[0:0];
        SHA_1_rd : coverpoint SHA_1.value[0:0];
        IP_CHK_rd : coverpoint IP_CHK.value[0:0];
        AES_128_CMAC_rd : coverpoint AES_128_CMAC.value[0:0];
        TKIP_MIC_rd : coverpoint TKIP_MIC.value[0:0];
        VERSION_rd : coverpoint VERSION.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "REVISION");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CONTROL
//--------------------------------------------------------------------
class CONTROL extends uvm_reg;
    `uvm_object_utils(CONTROL)
    rand uvm_reg_field MODE;
    rand uvm_reg_field LAST_BUFFER;
    rand uvm_reg_field FIRST_BUFFER;
    rand uvm_reg_field START;

    //---build------------------------------------------------------------
    virtual function void build();
        MODE = uvm_reg_field::type_id::create("MODE");
        LAST_BUFFER = uvm_reg_field::type_id::create("LAST_BUFFER");
        FIRST_BUFFER = uvm_reg_field::type_id::create("FIRST_BUFFER");
        START = uvm_reg_field::type_id::create("START");

        MODE.configure(this, 5, 8, "RW", 1, 'b0000, 1, 1, 1);
        LAST_BUFFER.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        FIRST_BUFFER.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        START.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_CONTROL_wr_cg";
        MODE_wr : coverpoint MODE.value[4:0];
        LAST_BUFFER_wr : coverpoint LAST_BUFFER.value[0:0];
        FIRST_BUFFER_wr : coverpoint FIRST_BUFFER.value[0:0];
        START_wr : coverpoint START.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_CONTROL_rd_cg";
        MODE_rd : coverpoint MODE.value[4:0];
        LAST_BUFFER_rd : coverpoint LAST_BUFFER.value[0:0];
        FIRST_BUFFER_rd : coverpoint FIRST_BUFFER.value[0:0];
        START_rd : coverpoint START.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CONTROL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STATUS_SET
//--------------------------------------------------------------------
class STATUS_SET extends uvm_reg;
    `uvm_object_utils(STATUS_SET)
    rand uvm_reg_field DONE_SET;

    //---build------------------------------------------------------------
    virtual function void build();
        DONE_SET = uvm_reg_field::type_id::create("DONE_SET");

        DONE_SET.configure(this, 1, 0, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_STATUS_SET_rd_cg";
        DONE_SET_rd : coverpoint DONE_SET.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STATUS_SET");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STATUS_CLEAR
//--------------------------------------------------------------------
class STATUS_CLEAR extends uvm_reg;
    `uvm_object_utils(STATUS_CLEAR)
    rand uvm_reg_field DONE_CLEAR;

    //---build------------------------------------------------------------
    virtual function void build();
        DONE_CLEAR = uvm_reg_field::type_id::create("DONE_CLEAR");

        DONE_CLEAR.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_STATUS_CLEAR_wr_cg";
        DONE_CLEAR_wr : coverpoint DONE_CLEAR.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_STATUS_CLEAR_rd_cg";
        DONE_CLEAR_rd : coverpoint DONE_CLEAR.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STATUS_CLEAR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// KEY_TAB0
//--------------------------------------------------------------------
class KEY_TAB0 extends uvm_reg;
    `uvm_object_utils(KEY_TAB0)
    rand uvm_reg_field KEY0;

    //---build------------------------------------------------------------
    virtual function void build();
        KEY0 = uvm_reg_field::type_id::create("KEY0");

        KEY0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_KEY_TAB0_wr_cg";
        KEY0_wr : coverpoint KEY0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_KEY_TAB0_rd_cg";
        KEY0_rd : coverpoint KEY0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "KEY_TAB0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// KEY_TAB1
//--------------------------------------------------------------------
class KEY_TAB1 extends uvm_reg;
    `uvm_object_utils(KEY_TAB1)
    rand uvm_reg_field KEY1;

    //---build------------------------------------------------------------
    virtual function void build();
        KEY1 = uvm_reg_field::type_id::create("KEY1");

        KEY1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_KEY_TAB1_wr_cg";
        KEY1_wr : coverpoint KEY1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_KEY_TAB1_rd_cg";
        KEY1_rd : coverpoint KEY1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "KEY_TAB1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// KEY_TAB2
//--------------------------------------------------------------------
class KEY_TAB2 extends uvm_reg;
    `uvm_object_utils(KEY_TAB2)
    rand uvm_reg_field KEY2;

    //---build------------------------------------------------------------
    virtual function void build();
        KEY2 = uvm_reg_field::type_id::create("KEY2");

        KEY2.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_KEY_TAB2_wr_cg";
        KEY2_wr : coverpoint KEY2.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_KEY_TAB2_rd_cg";
        KEY2_rd : coverpoint KEY2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "KEY_TAB2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// KEY_TAB3
//--------------------------------------------------------------------
class KEY_TAB3 extends uvm_reg;
    `uvm_object_utils(KEY_TAB3)
    rand uvm_reg_field KEY3;

    //---build------------------------------------------------------------
    virtual function void build();
        KEY3 = uvm_reg_field::type_id::create("KEY3");

        KEY3.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_KEY_TAB3_wr_cg";
        KEY3_wr : coverpoint KEY3.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_KEY_TAB3_rd_cg";
        KEY3_rd : coverpoint KEY3.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "KEY_TAB3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SOURCE_ADDR
//--------------------------------------------------------------------
class SOURCE_ADDR extends uvm_reg;
    `uvm_object_utils(SOURCE_ADDR)
    rand uvm_reg_field SOURCE_ADDR;

    //---build------------------------------------------------------------
    virtual function void build();
        SOURCE_ADDR = uvm_reg_field::type_id::create("SOURCE_ADDR");

        SOURCE_ADDR.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_SOURCE_ADDR_wr_cg";
        SOURCE_ADDR_wr : coverpoint SOURCE_ADDR.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SOURCE_ADDR_rd_cg";
        SOURCE_ADDR_rd : coverpoint SOURCE_ADDR.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SOURCE_ADDR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LENGTH
//--------------------------------------------------------------------
class LENGTH extends uvm_reg;
    `uvm_object_utils(LENGTH)
    rand uvm_reg_field LENGTH;

    //---build------------------------------------------------------------
    virtual function void build();
        LENGTH = uvm_reg_field::type_id::create("LENGTH");

        LENGTH.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_LENGTH_wr_cg";
        LENGTH_wr : coverpoint LENGTH.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_LENGTH_rd_cg";
        LENGTH_rd : coverpoint LENGTH.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LENGTH");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MIC_TAB0
//--------------------------------------------------------------------
class MIC_TAB0 extends uvm_reg;
    `uvm_object_utils(MIC_TAB0)
    rand uvm_reg_field MIC0;

    //---build------------------------------------------------------------
    virtual function void build();
        MIC0 = uvm_reg_field::type_id::create("MIC0");

        MIC0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_MIC_TAB0_wr_cg";
        MIC0_wr : coverpoint MIC0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_MIC_TAB0_rd_cg";
        MIC0_rd : coverpoint MIC0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MIC_TAB0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MIC_TAB1
//--------------------------------------------------------------------
class MIC_TAB1 extends uvm_reg;
    `uvm_object_utils(MIC_TAB1)
    rand uvm_reg_field MIC1;

    //---build------------------------------------------------------------
    virtual function void build();
        MIC1 = uvm_reg_field::type_id::create("MIC1");

        MIC1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_MIC_TAB1_wr_cg";
        MIC1_wr : coverpoint MIC1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_MIC_TAB1_rd_cg";
        MIC1_rd : coverpoint MIC1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MIC_TAB1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// REMAINING
//--------------------------------------------------------------------
class REMAINING extends uvm_reg;
    `uvm_object_utils(REMAINING)
    rand uvm_reg_field REMAINING_LENGTH;
    rand uvm_reg_field REMAINING_BYTE2;
    rand uvm_reg_field REMAINING_BYTE1;
    rand uvm_reg_field REMAINING_BYTE0;

    //---build------------------------------------------------------------
    virtual function void build();
        REMAINING_LENGTH = uvm_reg_field::type_id::create("REMAINING_LENGTH");
        REMAINING_BYTE2 = uvm_reg_field::type_id::create("REMAINING_BYTE2");
        REMAINING_BYTE1 = uvm_reg_field::type_id::create("REMAINING_BYTE1");
        REMAINING_BYTE0 = uvm_reg_field::type_id::create("REMAINING_BYTE0");

        REMAINING_LENGTH.configure(this, 2, 24, "RW", 1, 'b0, 1, 1, 1);
        REMAINING_BYTE2.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        REMAINING_BYTE1.configure(this, 8, 8, "RW", 1, 'b0000000, 1, 1, 1);
        REMAINING_BYTE0.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_REMAINING_wr_cg";
        REMAINING_LENGTH_wr : coverpoint REMAINING_LENGTH.value[1:0];
        REMAINING_BYTE2_wr : coverpoint REMAINING_BYTE2.value[7:0];
        REMAINING_BYTE1_wr : coverpoint REMAINING_BYTE1.value[7:0];
        REMAINING_BYTE0_wr : coverpoint REMAINING_BYTE0.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_REMAINING_rd_cg";
        REMAINING_LENGTH_rd : coverpoint REMAINING_LENGTH.value[1:0];
        REMAINING_BYTE2_rd : coverpoint REMAINING_BYTE2.value[7:0];
        REMAINING_BYTE1_rd : coverpoint REMAINING_BYTE1.value[7:0];
        REMAINING_BYTE0_rd : coverpoint REMAINING_BYTE0.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "REMAINING");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB0
//--------------------------------------------------------------------
class SHA_TAB0 extends uvm_reg;
    `uvm_object_utils(SHA_TAB0)
    rand uvm_reg_field SHA0;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA0 = uvm_reg_field::type_id::create("SHA0");

        SHA0.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB0_rd_cg";
        SHA0_rd : coverpoint SHA0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB1
//--------------------------------------------------------------------
class SHA_TAB1 extends uvm_reg;
    `uvm_object_utils(SHA_TAB1)
    rand uvm_reg_field SHA1;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA1 = uvm_reg_field::type_id::create("SHA1");

        SHA1.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB1_rd_cg";
        SHA1_rd : coverpoint SHA1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB2
//--------------------------------------------------------------------
class SHA_TAB2 extends uvm_reg;
    `uvm_object_utils(SHA_TAB2)
    rand uvm_reg_field SHA2;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA2 = uvm_reg_field::type_id::create("SHA2");

        SHA2.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB2_rd_cg";
        SHA2_rd : coverpoint SHA2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB3
//--------------------------------------------------------------------
class SHA_TAB3 extends uvm_reg;
    `uvm_object_utils(SHA_TAB3)
    rand uvm_reg_field SHA3;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA3 = uvm_reg_field::type_id::create("SHA3");

        SHA3.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB3_rd_cg";
        SHA3_rd : coverpoint SHA3.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB4
//--------------------------------------------------------------------
class SHA_TAB4 extends uvm_reg;
    `uvm_object_utils(SHA_TAB4)
    rand uvm_reg_field SHA4;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA4 = uvm_reg_field::type_id::create("SHA4");

        SHA4.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB4_rd_cg";
        SHA4_rd : coverpoint SHA4.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB5
//--------------------------------------------------------------------
class SHA_TAB5 extends uvm_reg;
    `uvm_object_utils(SHA_TAB5)
    rand uvm_reg_field SHA5;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA5 = uvm_reg_field::type_id::create("SHA5");

        SHA5.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB5_rd_cg";
        SHA5_rd : coverpoint SHA5.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB5");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB6
//--------------------------------------------------------------------
class SHA_TAB6 extends uvm_reg;
    `uvm_object_utils(SHA_TAB6)
    rand uvm_reg_field SHA6;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA6 = uvm_reg_field::type_id::create("SHA6");

        SHA6.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB6_rd_cg";
        SHA6_rd : coverpoint SHA6.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB6");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB7
//--------------------------------------------------------------------
class SHA_TAB7 extends uvm_reg;
    `uvm_object_utils(SHA_TAB7)
    rand uvm_reg_field SHA7;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA7 = uvm_reg_field::type_id::create("SHA7");

        SHA7.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB7_rd_cg";
        SHA7_rd : coverpoint SHA7.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB7");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB8
//--------------------------------------------------------------------
class SHA_TAB8 extends uvm_reg;
    `uvm_object_utils(SHA_TAB8)
    rand uvm_reg_field SHA8;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA8 = uvm_reg_field::type_id::create("SHA8");

        SHA8.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB8_rd_cg";
        SHA8_rd : coverpoint SHA8.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB8");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB9
//--------------------------------------------------------------------
class SHA_TAB9 extends uvm_reg;
    `uvm_object_utils(SHA_TAB9)
    rand uvm_reg_field SHA9;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA9 = uvm_reg_field::type_id::create("SHA9");

        SHA9.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB9_rd_cg";
        SHA9_rd : coverpoint SHA9.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB9");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB10
//--------------------------------------------------------------------
class SHA_TAB10 extends uvm_reg;
    `uvm_object_utils(SHA_TAB10)
    rand uvm_reg_field SHA10;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA10 = uvm_reg_field::type_id::create("SHA10");

        SHA10.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB10_rd_cg";
        SHA10_rd : coverpoint SHA10.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB10");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB11
//--------------------------------------------------------------------
class SHA_TAB11 extends uvm_reg;
    `uvm_object_utils(SHA_TAB11)
    rand uvm_reg_field SHA11;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA11 = uvm_reg_field::type_id::create("SHA11");

        SHA11.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB11_rd_cg";
        SHA11_rd : coverpoint SHA11.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB11");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB12
//--------------------------------------------------------------------
class SHA_TAB12 extends uvm_reg;
    `uvm_object_utils(SHA_TAB12)
    rand uvm_reg_field SHA12;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA12 = uvm_reg_field::type_id::create("SHA12");

        SHA12.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB12_rd_cg";
        SHA12_rd : coverpoint SHA12.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB12");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB13
//--------------------------------------------------------------------
class SHA_TAB13 extends uvm_reg;
    `uvm_object_utils(SHA_TAB13)
    rand uvm_reg_field SHA13;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA13 = uvm_reg_field::type_id::create("SHA13");

        SHA13.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB13_rd_cg";
        SHA13_rd : coverpoint SHA13.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB13");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB14
//--------------------------------------------------------------------
class SHA_TAB14 extends uvm_reg;
    `uvm_object_utils(SHA_TAB14)
    rand uvm_reg_field SHA14;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA14 = uvm_reg_field::type_id::create("SHA14");

        SHA14.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB14_rd_cg";
        SHA14_rd : coverpoint SHA14.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB14");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SHA_TAB15
//--------------------------------------------------------------------
class SHA_TAB15 extends uvm_reg;
    `uvm_object_utils(SHA_TAB15)
    rand uvm_reg_field SHA15;

    //---build------------------------------------------------------------
    virtual function void build();
        SHA15 = uvm_reg_field::type_id::create("SHA15");

        SHA15.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_SHA_TAB15_rd_cg";
        SHA15_rd : coverpoint SHA15.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SHA_TAB15");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DESTINATION_ADDR
//--------------------------------------------------------------------
class DESTINATION_ADDR extends uvm_reg;
    `uvm_object_utils(DESTINATION_ADDR)
    rand uvm_reg_field DEST_ADDR;

    //---build------------------------------------------------------------
    virtual function void build();
        DEST_ADDR = uvm_reg_field::type_id::create("DEST_ADDR");

        DEST_ADDR.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="HSU_DESTINATION_ADDR_wr_cg";
        DEST_ADDR_wr : coverpoint DEST_ADDR.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="HSU_DESTINATION_ADDR_rd_cg";
        DEST_ADDR_rd : coverpoint DEST_ADDR.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DESTINATION_ADDR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class HSU_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(HSU_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins REVISION              = {'h0};
        bins CONTROL              = {'h4};
        bins STATUS_SET              = {'h8};
        bins STATUS_CLEAR              = {'hC};
        bins KEY_TAB0              = {'h10};
        bins KEY_TAB1              = {'h14};
        bins KEY_TAB2              = {'h18};
        bins KEY_TAB3              = {'h1C};
        bins SOURCE_ADDR              = {'h20};
        bins LENGTH              = {'h24};
        bins MIC_TAB0              = {'h28};
        bins MIC_TAB1              = {'h2C};
        bins REMAINING              = {'h30};
        bins SHA_TAB0              = {'h34};
        bins SHA_TAB1              = {'h38};
        bins SHA_TAB2              = {'h3C};
        bins SHA_TAB3              = {'h40};
        bins SHA_TAB4              = {'h44};
        bins SHA_TAB5              = {'h48};
        bins SHA_TAB6              = {'h4C};
        bins SHA_TAB7              = {'h50};
        bins SHA_TAB8              = {'h54};
        bins SHA_TAB9              = {'h58};
        bins SHA_TAB10              = {'h5C};
        bins SHA_TAB11              = {'h60};
        bins SHA_TAB12              = {'h64};
        bins SHA_TAB13              = {'h68};
        bins SHA_TAB14              = {'h6C};
        bins SHA_TAB15              = {'h70};
        bins DESTINATION_ADDR              = {'h74};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "HSU_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: HSU_reg_access_wrapper

//-------------------------------------------------------------------
// HSU_register_block
//--------------------------------------------------------------------
class HSU_register_block extends uvm_reg_block;
    `uvm_object_utils(HSU_register_block)

    rand REVISION REVISION_reg;
    rand CONTROL CONTROL_reg;
    rand STATUS_SET STATUS_SET_reg;
    rand STATUS_CLEAR STATUS_CLEAR_reg;
    rand KEY_TAB0 KEY_TAB0_reg;
    rand KEY_TAB1 KEY_TAB1_reg;
    rand KEY_TAB2 KEY_TAB2_reg;
    rand KEY_TAB3 KEY_TAB3_reg;
    rand SOURCE_ADDR SOURCE_ADDR_reg;
    rand LENGTH LENGTH_reg;
    rand MIC_TAB0 MIC_TAB0_reg;
    rand MIC_TAB1 MIC_TAB1_reg;
    rand REMAINING REMAINING_reg;
    rand SHA_TAB0 SHA_TAB0_reg;
    rand SHA_TAB1 SHA_TAB1_reg;
    rand SHA_TAB2 SHA_TAB2_reg;
    rand SHA_TAB3 SHA_TAB3_reg;
    rand SHA_TAB4 SHA_TAB4_reg;
    rand SHA_TAB5 SHA_TAB5_reg;
    rand SHA_TAB6 SHA_TAB6_reg;
    rand SHA_TAB7 SHA_TAB7_reg;
    rand SHA_TAB8 SHA_TAB8_reg;
    rand SHA_TAB9 SHA_TAB9_reg;
    rand SHA_TAB10 SHA_TAB10_reg;
    rand SHA_TAB11 SHA_TAB11_reg;
    rand SHA_TAB12 SHA_TAB12_reg;
    rand SHA_TAB13 SHA_TAB13_reg;
    rand SHA_TAB14 SHA_TAB14_reg;
    rand SHA_TAB15 SHA_TAB15_reg;
    rand DESTINATION_ADDR DESTINATION_ADDR_reg;

    uvm_reg_map HSU_register_map; // Block map
    HSU_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "HSU_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = HSU_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        REVISION_reg = REVISION::type_id::create("REVISION");
        REVISION_reg.configure(this);
        REVISION_reg.build();

        CONTROL_reg = CONTROL::type_id::create("CONTROL");
        CONTROL_reg.configure(this);
        CONTROL_reg.build();

        STATUS_SET_reg = STATUS_SET::type_id::create("STATUS_SET");
        STATUS_SET_reg.configure(this);
        STATUS_SET_reg.build();

        STATUS_CLEAR_reg = STATUS_CLEAR::type_id::create("STATUS_CLEAR");
        STATUS_CLEAR_reg.configure(this);
        STATUS_CLEAR_reg.build();

        KEY_TAB0_reg = KEY_TAB0::type_id::create("KEY_TAB0");
        KEY_TAB0_reg.configure(this);
        KEY_TAB0_reg.build();

        KEY_TAB1_reg = KEY_TAB1::type_id::create("KEY_TAB1");
        KEY_TAB1_reg.configure(this);
        KEY_TAB1_reg.build();

        KEY_TAB2_reg = KEY_TAB2::type_id::create("KEY_TAB2");
        KEY_TAB2_reg.configure(this);
        KEY_TAB2_reg.build();

        KEY_TAB3_reg = KEY_TAB3::type_id::create("KEY_TAB3");
        KEY_TAB3_reg.configure(this);
        KEY_TAB3_reg.build();

        SOURCE_ADDR_reg = SOURCE_ADDR::type_id::create("SOURCE_ADDR");
        SOURCE_ADDR_reg.configure(this);
        SOURCE_ADDR_reg.build();

        LENGTH_reg = LENGTH::type_id::create("LENGTH");
        LENGTH_reg.configure(this);
        LENGTH_reg.build();

        MIC_TAB0_reg = MIC_TAB0::type_id::create("MIC_TAB0");
        MIC_TAB0_reg.configure(this);
        MIC_TAB0_reg.build();

        MIC_TAB1_reg = MIC_TAB1::type_id::create("MIC_TAB1");
        MIC_TAB1_reg.configure(this);
        MIC_TAB1_reg.build();

        REMAINING_reg = REMAINING::type_id::create("REMAINING");
        REMAINING_reg.configure(this);
        REMAINING_reg.build();

        SHA_TAB0_reg = SHA_TAB0::type_id::create("SHA_TAB0");
        SHA_TAB0_reg.configure(this);
        SHA_TAB0_reg.build();

        SHA_TAB1_reg = SHA_TAB1::type_id::create("SHA_TAB1");
        SHA_TAB1_reg.configure(this);
        SHA_TAB1_reg.build();

        SHA_TAB2_reg = SHA_TAB2::type_id::create("SHA_TAB2");
        SHA_TAB2_reg.configure(this);
        SHA_TAB2_reg.build();

        SHA_TAB3_reg = SHA_TAB3::type_id::create("SHA_TAB3");
        SHA_TAB3_reg.configure(this);
        SHA_TAB3_reg.build();

        SHA_TAB4_reg = SHA_TAB4::type_id::create("SHA_TAB4");
        SHA_TAB4_reg.configure(this);
        SHA_TAB4_reg.build();

        SHA_TAB5_reg = SHA_TAB5::type_id::create("SHA_TAB5");
        SHA_TAB5_reg.configure(this);
        SHA_TAB5_reg.build();

        SHA_TAB6_reg = SHA_TAB6::type_id::create("SHA_TAB6");
        SHA_TAB6_reg.configure(this);
        SHA_TAB6_reg.build();

        SHA_TAB7_reg = SHA_TAB7::type_id::create("SHA_TAB7");
        SHA_TAB7_reg.configure(this);
        SHA_TAB7_reg.build();

        SHA_TAB8_reg = SHA_TAB8::type_id::create("SHA_TAB8");
        SHA_TAB8_reg.configure(this);
        SHA_TAB8_reg.build();

        SHA_TAB9_reg = SHA_TAB9::type_id::create("SHA_TAB9");
        SHA_TAB9_reg.configure(this);
        SHA_TAB9_reg.build();

        SHA_TAB10_reg = SHA_TAB10::type_id::create("SHA_TAB10");
        SHA_TAB10_reg.configure(this);
        SHA_TAB10_reg.build();

        SHA_TAB11_reg = SHA_TAB11::type_id::create("SHA_TAB11");
        SHA_TAB11_reg.configure(this);
        SHA_TAB11_reg.build();

        SHA_TAB12_reg = SHA_TAB12::type_id::create("SHA_TAB12");
        SHA_TAB12_reg.configure(this);
        SHA_TAB12_reg.build();

        SHA_TAB13_reg = SHA_TAB13::type_id::create("SHA_TAB13");
        SHA_TAB13_reg.configure(this);
        SHA_TAB13_reg.build();

        SHA_TAB14_reg = SHA_TAB14::type_id::create("SHA_TAB14");
        SHA_TAB14_reg.configure(this);
        SHA_TAB14_reg.build();

        SHA_TAB15_reg = SHA_TAB15::type_id::create("SHA_TAB15");
        SHA_TAB15_reg.configure(this);
        SHA_TAB15_reg.build();

        DESTINATION_ADDR_reg = DESTINATION_ADDR::type_id::create("DESTINATION_ADDR");
        DESTINATION_ADDR_reg.configure(this);
        DESTINATION_ADDR_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        HSU_register_map = create_map("HSU_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        HSU_register_map.add_reg(REVISION_reg, 'h0, "RO");
        HSU_register_map.add_reg(CONTROL_reg, 'h4, "RW");
        HSU_register_map.add_reg(STATUS_SET_reg, 'h8, "RW");
        HSU_register_map.add_reg(STATUS_CLEAR_reg, 'hC, "RW");
        HSU_register_map.add_reg(KEY_TAB0_reg, 'h10, "RW");
        HSU_register_map.add_reg(KEY_TAB1_reg, 'h14, "RW");
        HSU_register_map.add_reg(KEY_TAB2_reg, 'h18, "RW");
        HSU_register_map.add_reg(KEY_TAB3_reg, 'h1C, "RW");
        HSU_register_map.add_reg(SOURCE_ADDR_reg, 'h20, "RW");
        HSU_register_map.add_reg(LENGTH_reg, 'h24, "RW");
        HSU_register_map.add_reg(MIC_TAB0_reg, 'h28, "RW");
        HSU_register_map.add_reg(MIC_TAB1_reg, 'h2C, "RW");
        HSU_register_map.add_reg(REMAINING_reg, 'h30, "RW");
        HSU_register_map.add_reg(SHA_TAB0_reg, 'h34, "RO");
        HSU_register_map.add_reg(SHA_TAB1_reg, 'h38, "RO");
        HSU_register_map.add_reg(SHA_TAB2_reg, 'h3C, "RO");
        HSU_register_map.add_reg(SHA_TAB3_reg, 'h40, "RO");
        HSU_register_map.add_reg(SHA_TAB4_reg, 'h44, "RO");
        HSU_register_map.add_reg(SHA_TAB5_reg, 'h48, "RO");
        HSU_register_map.add_reg(SHA_TAB6_reg, 'h4C, "RO");
        HSU_register_map.add_reg(SHA_TAB7_reg, 'h50, "RO");
        HSU_register_map.add_reg(SHA_TAB8_reg, 'h54, "RO");
        HSU_register_map.add_reg(SHA_TAB9_reg, 'h58, "RO");
        HSU_register_map.add_reg(SHA_TAB10_reg, 'h5C, "RO");
        HSU_register_map.add_reg(SHA_TAB11_reg, 'h60, "RO");
        HSU_register_map.add_reg(SHA_TAB12_reg, 'h64, "RO");
        HSU_register_map.add_reg(SHA_TAB13_reg, 'h68, "RO");
        HSU_register_map.add_reg(SHA_TAB14_reg, 'h6C, "RO");
        HSU_register_map.add_reg(SHA_TAB15_reg, 'h70, "RO");
        HSU_register_map.add_reg(DESTINATION_ADDR_reg, 'h74, "RW");

        // Lock the register model and build the map
        lock_model();
        HSU_register_map.set_check_on_read();
    endfunction

endclass
`endif // __HSU_REG_BLOCK_SV__
