//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for INTC
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __INTC_REG_BLOCK_SV__
`define __INTC_REG_BLOCK_SV__

//--------------------------------------------------------------------
// IRQ_STATUS0
//--------------------------------------------------------------------
class IRQ_STATUS0 extends uvm_reg;
    `uvm_object_utils(IRQ_STATUS0)
    rand uvm_reg_field IRQ_STATUS0;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_STATUS0 = uvm_reg_field::type_id::create("IRQ_STATUS0");

        IRQ_STATUS0.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_STATUS0_rd_cg";
        IRQ_STATUS0_rd : coverpoint IRQ_STATUS0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_STATUS0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// IRQ_STATUS1
//--------------------------------------------------------------------
class IRQ_STATUS1 extends uvm_reg;
    `uvm_object_utils(IRQ_STATUS1)
    rand uvm_reg_field IRQ_STATUS1;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_STATUS1 = uvm_reg_field::type_id::create("IRQ_STATUS1");

        IRQ_STATUS1.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_STATUS1_rd_cg";
        IRQ_STATUS1_rd : coverpoint IRQ_STATUS1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_STATUS1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// IRQ_RAW_STATUS0
//--------------------------------------------------------------------
class IRQ_RAW_STATUS0 extends uvm_reg;
    `uvm_object_utils(IRQ_RAW_STATUS0)
    rand uvm_reg_field IRQ_RAW_STATUS0;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_RAW_STATUS0 = uvm_reg_field::type_id::create("IRQ_RAW_STATUS0");

        IRQ_RAW_STATUS0.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_RAW_STATUS0_rd_cg";
        IRQ_RAW_STATUS0_rd : coverpoint IRQ_RAW_STATUS0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_RAW_STATUS0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// IRQ_RAW_STATUS1
//--------------------------------------------------------------------
class IRQ_RAW_STATUS1 extends uvm_reg;
    `uvm_object_utils(IRQ_RAW_STATUS1)
    rand uvm_reg_field IRQ_RAW_STATUS1;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_RAW_STATUS1 = uvm_reg_field::type_id::create("IRQ_RAW_STATUS1");

        IRQ_RAW_STATUS1.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_RAW_STATUS1_rd_cg";
        IRQ_RAW_STATUS1_rd : coverpoint IRQ_RAW_STATUS1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_RAW_STATUS1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// IRQ_UNMASK_SET0
//--------------------------------------------------------------------
class IRQ_UNMASK_SET0 extends uvm_reg;
    `uvm_object_utils(IRQ_UNMASK_SET0)
    rand uvm_reg_field IRQ_UNMASK_SET0;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_UNMASK_SET0 = uvm_reg_field::type_id::create("IRQ_UNMASK_SET0");

        IRQ_UNMASK_SET0.configure(this, 32, 0, "W1S", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_UNMASK_SET0_wr_cg";
        IRQ_UNMASK_SET0_wr : coverpoint IRQ_UNMASK_SET0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_UNMASK_SET0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// IRQ_UNMASK_SET1
//--------------------------------------------------------------------
class IRQ_UNMASK_SET1 extends uvm_reg;
    `uvm_object_utils(IRQ_UNMASK_SET1)
    rand uvm_reg_field IRQ_UNMASK_SET1;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_UNMASK_SET1 = uvm_reg_field::type_id::create("IRQ_UNMASK_SET1");

        IRQ_UNMASK_SET1.configure(this, 32, 0, "W1S", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_UNMASK_SET1_wr_cg";
        IRQ_UNMASK_SET1_wr : coverpoint IRQ_UNMASK_SET1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_UNMASK_SET1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// IRQ_UNMASK_CLEAR0
//--------------------------------------------------------------------
class IRQ_UNMASK_CLEAR0 extends uvm_reg;
    `uvm_object_utils(IRQ_UNMASK_CLEAR0)
    rand uvm_reg_field IRQ_UNMASK_CLEAR0;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_UNMASK_CLEAR0 = uvm_reg_field::type_id::create("IRQ_UNMASK_CLEAR0");

        IRQ_UNMASK_CLEAR0.configure(this, 32, 0, "W1C", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_UNMASK_CLEAR0_wr_cg";
        IRQ_UNMASK_CLEAR0_wr : coverpoint IRQ_UNMASK_CLEAR0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_UNMASK_CLEAR0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// IRQ_UNMASK_CLEAR1
//--------------------------------------------------------------------
class IRQ_UNMASK_CLEAR1 extends uvm_reg;
    `uvm_object_utils(IRQ_UNMASK_CLEAR1)
    rand uvm_reg_field IRQ_UNMASK_CLEAR1;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_UNMASK_CLEAR1 = uvm_reg_field::type_id::create("IRQ_UNMASK_CLEAR1");

        IRQ_UNMASK_CLEAR1.configure(this, 32, 0, "W1C", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_UNMASK_CLEAR1_wr_cg";
        IRQ_UNMASK_CLEAR1_wr : coverpoint IRQ_UNMASK_CLEAR1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_UNMASK_CLEAR1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// IRQ_POLARITY0
//--------------------------------------------------------------------
class IRQ_POLARITY0 extends uvm_reg;
    `uvm_object_utils(IRQ_POLARITY0)
    rand uvm_reg_field IRQ_POLARITY0;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_POLARITY0 = uvm_reg_field::type_id::create("IRQ_POLARITY0");

        IRQ_POLARITY0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_POLARITY0_wr_cg";
        IRQ_POLARITY0_wr : coverpoint IRQ_POLARITY0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_POLARITY0_rd_cg";
        IRQ_POLARITY0_rd : coverpoint IRQ_POLARITY0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_POLARITY0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// IRQ_POLARITY1
//--------------------------------------------------------------------
class IRQ_POLARITY1 extends uvm_reg;
    `uvm_object_utils(IRQ_POLARITY1)
    rand uvm_reg_field IRQ_POLARITY1;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_POLARITY1 = uvm_reg_field::type_id::create("IRQ_POLARITY1");

        IRQ_POLARITY1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_POLARITY1_wr_cg";
        IRQ_POLARITY1_wr : coverpoint IRQ_POLARITY1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_POLARITY1_rd_cg";
        IRQ_POLARITY1_rd : coverpoint IRQ_POLARITY1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_POLARITY1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// IRQ_INDEX
//--------------------------------------------------------------------
class IRQ_INDEX extends uvm_reg;
    `uvm_object_utils(IRQ_INDEX)
    rand uvm_reg_field IRQ_INDEX;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQ_INDEX = uvm_reg_field::type_id::create("IRQ_INDEX");

        IRQ_INDEX.configure(this, 6, 0, "RO", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="INTC_IRQ_INDEX_rd_cg";
        IRQ_INDEX_rd : coverpoint IRQ_INDEX.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "IRQ_INDEX");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class INTC_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(INTC_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins IRQ_STATUS0              = {'h0};
        bins IRQ_STATUS1              = {'h4};
        bins IRQ_RAW_STATUS0              = {'h8};
        bins IRQ_RAW_STATUS1              = {'hC};
        bins IRQ_UNMASK_SET0              = {'h10};
        bins IRQ_UNMASK_SET1              = {'h14};
        bins IRQ_UNMASK_CLEAR0              = {'h18};
        bins IRQ_UNMASK_CLEAR1              = {'h1C};
        bins IRQ_POLARITY0              = {'h20};
        bins IRQ_POLARITY1              = {'h24};
        bins IRQ_INDEX              = {'h40};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "INTC_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: INTC_reg_access_wrapper

//-------------------------------------------------------------------
// INTC_register_block
//--------------------------------------------------------------------
class INTC_register_block extends uvm_reg_block;
    `uvm_object_utils(INTC_register_block)

    rand IRQ_STATUS0 IRQ_STATUS0_reg;
    rand IRQ_STATUS1 IRQ_STATUS1_reg;
    rand IRQ_RAW_STATUS0 IRQ_RAW_STATUS0_reg;
    rand IRQ_RAW_STATUS1 IRQ_RAW_STATUS1_reg;
    rand IRQ_UNMASK_SET0 IRQ_UNMASK_SET0_reg;
    rand IRQ_UNMASK_SET1 IRQ_UNMASK_SET1_reg;
    rand IRQ_UNMASK_CLEAR0 IRQ_UNMASK_CLEAR0_reg;
    rand IRQ_UNMASK_CLEAR1 IRQ_UNMASK_CLEAR1_reg;
    rand IRQ_POLARITY0 IRQ_POLARITY0_reg;
    rand IRQ_POLARITY1 IRQ_POLARITY1_reg;
    rand IRQ_INDEX IRQ_INDEX_reg;

    uvm_reg_map INTC_register_map; // Block map
    INTC_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "INTC_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = INTC_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        IRQ_STATUS0_reg = IRQ_STATUS0::type_id::create("IRQ_STATUS0");
        IRQ_STATUS0_reg.configure(this);
        IRQ_STATUS0_reg.build();

        IRQ_STATUS1_reg = IRQ_STATUS1::type_id::create("IRQ_STATUS1");
        IRQ_STATUS1_reg.configure(this);
        IRQ_STATUS1_reg.build();

        IRQ_RAW_STATUS0_reg = IRQ_RAW_STATUS0::type_id::create("IRQ_RAW_STATUS0");
        IRQ_RAW_STATUS0_reg.configure(this);
        IRQ_RAW_STATUS0_reg.build();

        IRQ_RAW_STATUS1_reg = IRQ_RAW_STATUS1::type_id::create("IRQ_RAW_STATUS1");
        IRQ_RAW_STATUS1_reg.configure(this);
        IRQ_RAW_STATUS1_reg.build();

        IRQ_UNMASK_SET0_reg = IRQ_UNMASK_SET0::type_id::create("IRQ_UNMASK_SET0");
        IRQ_UNMASK_SET0_reg.configure(this);
        IRQ_UNMASK_SET0_reg.build();

        IRQ_UNMASK_SET1_reg = IRQ_UNMASK_SET1::type_id::create("IRQ_UNMASK_SET1");
        IRQ_UNMASK_SET1_reg.configure(this);
        IRQ_UNMASK_SET1_reg.build();

        IRQ_UNMASK_CLEAR0_reg = IRQ_UNMASK_CLEAR0::type_id::create("IRQ_UNMASK_CLEAR0");
        IRQ_UNMASK_CLEAR0_reg.configure(this);
        IRQ_UNMASK_CLEAR0_reg.build();

        IRQ_UNMASK_CLEAR1_reg = IRQ_UNMASK_CLEAR1::type_id::create("IRQ_UNMASK_CLEAR1");
        IRQ_UNMASK_CLEAR1_reg.configure(this);
        IRQ_UNMASK_CLEAR1_reg.build();

        IRQ_POLARITY0_reg = IRQ_POLARITY0::type_id::create("IRQ_POLARITY0");
        IRQ_POLARITY0_reg.configure(this);
        IRQ_POLARITY0_reg.build();

        IRQ_POLARITY1_reg = IRQ_POLARITY1::type_id::create("IRQ_POLARITY1");
        IRQ_POLARITY1_reg.configure(this);
        IRQ_POLARITY1_reg.build();

        IRQ_INDEX_reg = IRQ_INDEX::type_id::create("IRQ_INDEX");
        IRQ_INDEX_reg.configure(this);
        IRQ_INDEX_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        INTC_register_map = create_map("INTC_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        INTC_register_map.add_reg(IRQ_STATUS0_reg, 'h0, "RO");
        INTC_register_map.add_reg(IRQ_STATUS1_reg, 'h4, "RO");
        INTC_register_map.add_reg(IRQ_RAW_STATUS0_reg, 'h8, "RO");
        INTC_register_map.add_reg(IRQ_RAW_STATUS1_reg, 'hC, "RO");
        INTC_register_map.add_reg(IRQ_UNMASK_SET0_reg, 'h10, "RW");
        INTC_register_map.add_reg(IRQ_UNMASK_SET1_reg, 'h14, "RW");
        INTC_register_map.add_reg(IRQ_UNMASK_CLEAR0_reg, 'h18, "RW");
        INTC_register_map.add_reg(IRQ_UNMASK_CLEAR1_reg, 'h1C, "RW");
        INTC_register_map.add_reg(IRQ_POLARITY0_reg, 'h20, "RW");
        INTC_register_map.add_reg(IRQ_POLARITY1_reg, 'h24, "RW");
        INTC_register_map.add_reg(IRQ_INDEX_reg, 'h40, "RO");

        // Lock the register model and build the map
        lock_model();
        INTC_register_map.set_check_on_read();
    endfunction

endclass
`endif // __INTC_REG_BLOCK_SV__
