//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for IPCAPP
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __IPCAPP_REG_BLOCK_SV__
`define __IPCAPP_REG_BLOCK_SV__

//--------------------------------------------------------------------
// APP2EMB_TRIGGER
//--------------------------------------------------------------------
class APP2EMB_TRIGGER extends uvm_reg;
    `uvm_object_utils(APP2EMB_TRIGGER)
    rand uvm_reg_field APP2EMB_TRIGGER;

    //---build------------------------------------------------------------
    virtual function void build();
        APP2EMB_TRIGGER = uvm_reg_field::type_id::create("APP2EMB_TRIGGER");

        APP2EMB_TRIGGER.configure(this, 32, 0, "W1S", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="IPCAPP_APP2EMB_TRIGGER_wr_cg";
        APP2EMB_TRIGGER_wr : coverpoint APP2EMB_TRIGGER.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "APP2EMB_TRIGGER");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EMB2APP_RAWSTATUS
//--------------------------------------------------------------------
class EMB2APP_RAWSTATUS extends uvm_reg;
    `uvm_object_utils(EMB2APP_RAWSTATUS)
    rand uvm_reg_field EMB2APP_RAWSTATUS;

    //---build------------------------------------------------------------
    virtual function void build();
        EMB2APP_RAWSTATUS = uvm_reg_field::type_id::create("EMB2APP_RAWSTATUS");

        EMB2APP_RAWSTATUS.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="IPCAPP_EMB2APP_RAWSTATUS_rd_cg";
        EMB2APP_RAWSTATUS_rd : coverpoint EMB2APP_RAWSTATUS.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EMB2APP_RAWSTATUS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EMB2APP_ACK
//--------------------------------------------------------------------
class EMB2APP_ACK extends uvm_reg;
    `uvm_object_utils(EMB2APP_ACK)
    rand uvm_reg_field EMB2APP_ACK;

    //---build------------------------------------------------------------
    virtual function void build();
        EMB2APP_ACK = uvm_reg_field::type_id::create("EMB2APP_ACK");

        EMB2APP_ACK.configure(this, 32, 0, "W1C", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="IPCAPP_EMB2APP_ACK_wr_cg";
        EMB2APP_ACK_wr : coverpoint EMB2APP_ACK.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EMB2APP_ACK");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EMB2APP_UNMASK_SET
//--------------------------------------------------------------------
class EMB2APP_UNMASK_SET extends uvm_reg;
    `uvm_object_utils(EMB2APP_UNMASK_SET)
    rand uvm_reg_field EMB2APP_UNMASK_SET;

    //---build------------------------------------------------------------
    virtual function void build();
        EMB2APP_UNMASK_SET = uvm_reg_field::type_id::create("EMB2APP_UNMASK_SET");

        EMB2APP_UNMASK_SET.configure(this, 32, 0, "W1S", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="IPCAPP_EMB2APP_UNMASK_SET_wr_cg";
        EMB2APP_UNMASK_SET_wr : coverpoint EMB2APP_UNMASK_SET.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EMB2APP_UNMASK_SET");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EMB2APP_UNMASK_CLEAR
//--------------------------------------------------------------------
class EMB2APP_UNMASK_CLEAR extends uvm_reg;
    `uvm_object_utils(EMB2APP_UNMASK_CLEAR)
    rand uvm_reg_field EMB2APP_UNMASK_CLEAR;

    //---build------------------------------------------------------------
    virtual function void build();
        EMB2APP_UNMASK_CLEAR = uvm_reg_field::type_id::create("EMB2APP_UNMASK_CLEAR");

        EMB2APP_UNMASK_CLEAR.configure(this, 32, 0, "W1C", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="IPCAPP_EMB2APP_UNMASK_CLEAR_wr_cg";
        EMB2APP_UNMASK_CLEAR_wr : coverpoint EMB2APP_UNMASK_CLEAR.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EMB2APP_UNMASK_CLEAR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EMB2APP_STATUS
//--------------------------------------------------------------------
class EMB2APP_STATUS extends uvm_reg;
    `uvm_object_utils(EMB2APP_STATUS)
    rand uvm_reg_field EMB2APP_STATUS;

    //---build------------------------------------------------------------
    virtual function void build();
        EMB2APP_STATUS = uvm_reg_field::type_id::create("EMB2APP_STATUS");

        EMB2APP_STATUS.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="IPCAPP_EMB2APP_STATUS_rd_cg";
        EMB2APP_STATUS_rd : coverpoint EMB2APP_STATUS.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EMB2APP_STATUS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// APP_SIGNATURE
//--------------------------------------------------------------------
class APP_SIGNATURE extends uvm_reg;
    `uvm_object_utils(APP_SIGNATURE)
    rand uvm_reg_field SIGNATURE;

    //---build------------------------------------------------------------
    virtual function void build();
        SIGNATURE = uvm_reg_field::type_id::create("SIGNATURE");

        SIGNATURE.configure(this, 32, 0, "RO", 1, 'b1001001010100000100001100110010, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="IPCAPP_APP_SIGNATURE_rd_cg";
        SIGNATURE_rd : coverpoint SIGNATURE.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "APP_SIGNATURE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class IPCAPP_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(IPCAPP_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins APP2EMB_TRIGGER              = {'h0};
        bins EMB2APP_RAWSTATUS              = {'h4};
        bins EMB2APP_ACK              = {'h8};
        bins EMB2APP_UNMASK_SET              = {'hC};
        bins EMB2APP_UNMASK_CLEAR              = {'h10};
        bins EMB2APP_STATUS              = {'h1C};
        bins APP_SIGNATURE              = {'h40};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "IPCAPP_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: IPCAPP_reg_access_wrapper

//-------------------------------------------------------------------
// IPCAPP_register_block
//--------------------------------------------------------------------
class IPCAPP_register_block extends uvm_reg_block;
    `uvm_object_utils(IPCAPP_register_block)

    rand APP2EMB_TRIGGER APP2EMB_TRIGGER_reg;
    rand EMB2APP_RAWSTATUS EMB2APP_RAWSTATUS_reg;
    rand EMB2APP_ACK EMB2APP_ACK_reg;
    rand EMB2APP_UNMASK_SET EMB2APP_UNMASK_SET_reg;
    rand EMB2APP_UNMASK_CLEAR EMB2APP_UNMASK_CLEAR_reg;
    rand EMB2APP_STATUS EMB2APP_STATUS_reg;
    rand APP_SIGNATURE APP_SIGNATURE_reg;

    uvm_reg_map IPCAPP_register_map; // Block map
    IPCAPP_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "IPCAPP_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = IPCAPP_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        APP2EMB_TRIGGER_reg = APP2EMB_TRIGGER::type_id::create("APP2EMB_TRIGGER");
        APP2EMB_TRIGGER_reg.configure(this);
        APP2EMB_TRIGGER_reg.build();

        EMB2APP_RAWSTATUS_reg = EMB2APP_RAWSTATUS::type_id::create("EMB2APP_RAWSTATUS");
        EMB2APP_RAWSTATUS_reg.configure(this);
        EMB2APP_RAWSTATUS_reg.build();

        EMB2APP_ACK_reg = EMB2APP_ACK::type_id::create("EMB2APP_ACK");
        EMB2APP_ACK_reg.configure(this);
        EMB2APP_ACK_reg.build();

        EMB2APP_UNMASK_SET_reg = EMB2APP_UNMASK_SET::type_id::create("EMB2APP_UNMASK_SET");
        EMB2APP_UNMASK_SET_reg.configure(this);
        EMB2APP_UNMASK_SET_reg.build();

        EMB2APP_UNMASK_CLEAR_reg = EMB2APP_UNMASK_CLEAR::type_id::create("EMB2APP_UNMASK_CLEAR");
        EMB2APP_UNMASK_CLEAR_reg.configure(this);
        EMB2APP_UNMASK_CLEAR_reg.build();

        EMB2APP_STATUS_reg = EMB2APP_STATUS::type_id::create("EMB2APP_STATUS");
        EMB2APP_STATUS_reg.configure(this);
        EMB2APP_STATUS_reg.build();

        APP_SIGNATURE_reg = APP_SIGNATURE::type_id::create("APP_SIGNATURE");
        APP_SIGNATURE_reg.configure(this);
        APP_SIGNATURE_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        IPCAPP_register_map = create_map("IPCAPP_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        IPCAPP_register_map.add_reg(APP2EMB_TRIGGER_reg, 'h0, "RW");
        IPCAPP_register_map.add_reg(EMB2APP_RAWSTATUS_reg, 'h4, "RO");
        IPCAPP_register_map.add_reg(EMB2APP_ACK_reg, 'h8, "RW");
        IPCAPP_register_map.add_reg(EMB2APP_UNMASK_SET_reg, 'hC, "RW");
        IPCAPP_register_map.add_reg(EMB2APP_UNMASK_CLEAR_reg, 'h10, "RW");
        IPCAPP_register_map.add_reg(EMB2APP_STATUS_reg, 'h1C, "RO");
        IPCAPP_register_map.add_reg(APP_SIGNATURE_reg, 'h40, "RO");

        // Lock the register model and build the map
        lock_model();
        IPCAPP_register_map.set_check_on_read();
    endfunction

endclass
`endif // __IPCAPP_REG_BLOCK_SV__
