//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for IPCEMB
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __IPCEMB_REG_BLOCK_SV__
`define __IPCEMB_REG_BLOCK_SV__

//--------------------------------------------------------------------
// EMB2APP_TRIGGER
//--------------------------------------------------------------------
class EMB2APP_TRIGGER extends uvm_reg;
    `uvm_object_utils(EMB2APP_TRIGGER)
    rand uvm_reg_field EMB2APP_TRIGGER;

    //---build------------------------------------------------------------
    virtual function void build();
        EMB2APP_TRIGGER = uvm_reg_field::type_id::create("EMB2APP_TRIGGER");

        EMB2APP_TRIGGER.configure(this, 32, 0, "W1S", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="IPCEMB_EMB2APP_TRIGGER_wr_cg";
        EMB2APP_TRIGGER_wr : coverpoint EMB2APP_TRIGGER.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EMB2APP_TRIGGER");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// APP2EMB_RAWSTATUS
//--------------------------------------------------------------------
class APP2EMB_RAWSTATUS extends uvm_reg;
    `uvm_object_utils(APP2EMB_RAWSTATUS)
    rand uvm_reg_field APP2EMB_RAWSTATUS;

    //---build------------------------------------------------------------
    virtual function void build();
        APP2EMB_RAWSTATUS = uvm_reg_field::type_id::create("APP2EMB_RAWSTATUS");

        APP2EMB_RAWSTATUS.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="IPCEMB_APP2EMB_RAWSTATUS_rd_cg";
        APP2EMB_RAWSTATUS_rd : coverpoint APP2EMB_RAWSTATUS.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "APP2EMB_RAWSTATUS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// APP2EMB_ACK
//--------------------------------------------------------------------
class APP2EMB_ACK extends uvm_reg;
    `uvm_object_utils(APP2EMB_ACK)
    rand uvm_reg_field APP2EMB_ACK;

    //---build------------------------------------------------------------
    virtual function void build();
        APP2EMB_ACK = uvm_reg_field::type_id::create("APP2EMB_ACK");

        APP2EMB_ACK.configure(this, 32, 0, "W1C", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="IPCEMB_APP2EMB_ACK_wr_cg";
        APP2EMB_ACK_wr : coverpoint APP2EMB_ACK.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "APP2EMB_ACK");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// APP2EMB_UNMASK_SET
//--------------------------------------------------------------------
class APP2EMB_UNMASK_SET extends uvm_reg;
    `uvm_object_utils(APP2EMB_UNMASK_SET)
    rand uvm_reg_field APP2EMB_UNMASK_SET;

    //---build------------------------------------------------------------
    virtual function void build();
        APP2EMB_UNMASK_SET = uvm_reg_field::type_id::create("APP2EMB_UNMASK_SET");

        APP2EMB_UNMASK_SET.configure(this, 32, 0, "W1S", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="IPCEMB_APP2EMB_UNMASK_SET_wr_cg";
        APP2EMB_UNMASK_SET_wr : coverpoint APP2EMB_UNMASK_SET.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "APP2EMB_UNMASK_SET");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// APP2EMB_UNMASK_CLEAR
//--------------------------------------------------------------------
class APP2EMB_UNMASK_CLEAR extends uvm_reg;
    `uvm_object_utils(APP2EMB_UNMASK_CLEAR)
    rand uvm_reg_field APP2EMB_UNMASK_CLEAR;

    //---build------------------------------------------------------------
    virtual function void build();
        APP2EMB_UNMASK_CLEAR = uvm_reg_field::type_id::create("APP2EMB_UNMASK_CLEAR");

        APP2EMB_UNMASK_CLEAR.configure(this, 32, 0, "W1C", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="IPCEMB_APP2EMB_UNMASK_CLEAR_wr_cg";
        APP2EMB_UNMASK_CLEAR_wr : coverpoint APP2EMB_UNMASK_CLEAR.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "APP2EMB_UNMASK_CLEAR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// APP2EMB_LINE_SEL_LOW
//--------------------------------------------------------------------
class APP2EMB_LINE_SEL_LOW extends uvm_reg;
    `uvm_object_utils(APP2EMB_LINE_SEL_LOW)
    rand uvm_reg_field APP2EMB15_SEL;
    rand uvm_reg_field APP2EMB14_SEL;
    rand uvm_reg_field APP2EMB13_SEL;
    rand uvm_reg_field APP2EMB12_SEL;
    rand uvm_reg_field APP2EMB11_SEL;
    rand uvm_reg_field APP2EMB10_SEL;
    rand uvm_reg_field APP2EMB9_SEL;
    rand uvm_reg_field APP2EMB8_SEL;
    rand uvm_reg_field APP2EMB7_SEL;
    rand uvm_reg_field APP2EMB6_SEL;
    rand uvm_reg_field APP2EMB5_SEL;
    rand uvm_reg_field APP2EMB4_SEL;
    rand uvm_reg_field APP2EMB3_SEL;
    rand uvm_reg_field APP2EMB2_SEL;
    rand uvm_reg_field APP2EMB1_SEL;
    rand uvm_reg_field APP2EMB0_SEL;

    //---build------------------------------------------------------------
    virtual function void build();
        APP2EMB15_SEL = uvm_reg_field::type_id::create("APP2EMB15_SEL");
        APP2EMB14_SEL = uvm_reg_field::type_id::create("APP2EMB14_SEL");
        APP2EMB13_SEL = uvm_reg_field::type_id::create("APP2EMB13_SEL");
        APP2EMB12_SEL = uvm_reg_field::type_id::create("APP2EMB12_SEL");
        APP2EMB11_SEL = uvm_reg_field::type_id::create("APP2EMB11_SEL");
        APP2EMB10_SEL = uvm_reg_field::type_id::create("APP2EMB10_SEL");
        APP2EMB9_SEL = uvm_reg_field::type_id::create("APP2EMB9_SEL");
        APP2EMB8_SEL = uvm_reg_field::type_id::create("APP2EMB8_SEL");
        APP2EMB7_SEL = uvm_reg_field::type_id::create("APP2EMB7_SEL");
        APP2EMB6_SEL = uvm_reg_field::type_id::create("APP2EMB6_SEL");
        APP2EMB5_SEL = uvm_reg_field::type_id::create("APP2EMB5_SEL");
        APP2EMB4_SEL = uvm_reg_field::type_id::create("APP2EMB4_SEL");
        APP2EMB3_SEL = uvm_reg_field::type_id::create("APP2EMB3_SEL");
        APP2EMB2_SEL = uvm_reg_field::type_id::create("APP2EMB2_SEL");
        APP2EMB1_SEL = uvm_reg_field::type_id::create("APP2EMB1_SEL");
        APP2EMB0_SEL = uvm_reg_field::type_id::create("APP2EMB0_SEL");

        APP2EMB15_SEL.configure(this, 2, 30, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB14_SEL.configure(this, 2, 28, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB13_SEL.configure(this, 2, 26, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB12_SEL.configure(this, 2, 24, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB11_SEL.configure(this, 2, 22, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB10_SEL.configure(this, 2, 20, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB9_SEL.configure(this, 2, 18, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB8_SEL.configure(this, 2, 16, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB7_SEL.configure(this, 2, 14, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB6_SEL.configure(this, 2, 12, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB5_SEL.configure(this, 2, 10, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB4_SEL.configure(this, 2, 8, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB3_SEL.configure(this, 2, 6, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB2_SEL.configure(this, 2, 4, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB1_SEL.configure(this, 2, 2, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB0_SEL.configure(this, 2, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="IPCEMB_APP2EMB_LINE_SEL_LOW_wr_cg";
        APP2EMB15_SEL_wr : coverpoint APP2EMB15_SEL.value[1:0];
        APP2EMB14_SEL_wr : coverpoint APP2EMB14_SEL.value[1:0];
        APP2EMB13_SEL_wr : coverpoint APP2EMB13_SEL.value[1:0];
        APP2EMB12_SEL_wr : coverpoint APP2EMB12_SEL.value[1:0];
        APP2EMB11_SEL_wr : coverpoint APP2EMB11_SEL.value[1:0];
        APP2EMB10_SEL_wr : coverpoint APP2EMB10_SEL.value[1:0];
        APP2EMB9_SEL_wr : coverpoint APP2EMB9_SEL.value[1:0];
        APP2EMB8_SEL_wr : coverpoint APP2EMB8_SEL.value[1:0];
        APP2EMB7_SEL_wr : coverpoint APP2EMB7_SEL.value[1:0];
        APP2EMB6_SEL_wr : coverpoint APP2EMB6_SEL.value[1:0];
        APP2EMB5_SEL_wr : coverpoint APP2EMB5_SEL.value[1:0];
        APP2EMB4_SEL_wr : coverpoint APP2EMB4_SEL.value[1:0];
        APP2EMB3_SEL_wr : coverpoint APP2EMB3_SEL.value[1:0];
        APP2EMB2_SEL_wr : coverpoint APP2EMB2_SEL.value[1:0];
        APP2EMB1_SEL_wr : coverpoint APP2EMB1_SEL.value[1:0];
        APP2EMB0_SEL_wr : coverpoint APP2EMB0_SEL.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="IPCEMB_APP2EMB_LINE_SEL_LOW_rd_cg";
        APP2EMB15_SEL_rd : coverpoint APP2EMB15_SEL.value[1:0];
        APP2EMB14_SEL_rd : coverpoint APP2EMB14_SEL.value[1:0];
        APP2EMB13_SEL_rd : coverpoint APP2EMB13_SEL.value[1:0];
        APP2EMB12_SEL_rd : coverpoint APP2EMB12_SEL.value[1:0];
        APP2EMB11_SEL_rd : coverpoint APP2EMB11_SEL.value[1:0];
        APP2EMB10_SEL_rd : coverpoint APP2EMB10_SEL.value[1:0];
        APP2EMB9_SEL_rd : coverpoint APP2EMB9_SEL.value[1:0];
        APP2EMB8_SEL_rd : coverpoint APP2EMB8_SEL.value[1:0];
        APP2EMB7_SEL_rd : coverpoint APP2EMB7_SEL.value[1:0];
        APP2EMB6_SEL_rd : coverpoint APP2EMB6_SEL.value[1:0];
        APP2EMB5_SEL_rd : coverpoint APP2EMB5_SEL.value[1:0];
        APP2EMB4_SEL_rd : coverpoint APP2EMB4_SEL.value[1:0];
        APP2EMB3_SEL_rd : coverpoint APP2EMB3_SEL.value[1:0];
        APP2EMB2_SEL_rd : coverpoint APP2EMB2_SEL.value[1:0];
        APP2EMB1_SEL_rd : coverpoint APP2EMB1_SEL.value[1:0];
        APP2EMB0_SEL_rd : coverpoint APP2EMB0_SEL.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "APP2EMB_LINE_SEL_LOW");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// APP2EMB_LINE_SEL_HIGH
//--------------------------------------------------------------------
class APP2EMB_LINE_SEL_HIGH extends uvm_reg;
    `uvm_object_utils(APP2EMB_LINE_SEL_HIGH)
    rand uvm_reg_field APP2EMB31_SEL;
    rand uvm_reg_field APP2EMB30_SEL;
    rand uvm_reg_field APP2EMB29_SEL;
    rand uvm_reg_field APP2EMB28_SEL;
    rand uvm_reg_field APP2EMB27_SEL;
    rand uvm_reg_field APP2EMB26_SEL;
    rand uvm_reg_field APP2EMB25_SEL;
    rand uvm_reg_field APP2EMB24_SEL;
    rand uvm_reg_field APP2EMB23_SEL;
    rand uvm_reg_field APP2EMB22_SEL;
    rand uvm_reg_field APP2EMB21_SEL;
    rand uvm_reg_field APP2EMB20_SEL;
    rand uvm_reg_field APP2EMB19_SEL;
    rand uvm_reg_field APP2EMB18_SEL;
    rand uvm_reg_field APP2EMB17_SEL;
    rand uvm_reg_field APP2EMB16_SEL;

    //---build------------------------------------------------------------
    virtual function void build();
        APP2EMB31_SEL = uvm_reg_field::type_id::create("APP2EMB31_SEL");
        APP2EMB30_SEL = uvm_reg_field::type_id::create("APP2EMB30_SEL");
        APP2EMB29_SEL = uvm_reg_field::type_id::create("APP2EMB29_SEL");
        APP2EMB28_SEL = uvm_reg_field::type_id::create("APP2EMB28_SEL");
        APP2EMB27_SEL = uvm_reg_field::type_id::create("APP2EMB27_SEL");
        APP2EMB26_SEL = uvm_reg_field::type_id::create("APP2EMB26_SEL");
        APP2EMB25_SEL = uvm_reg_field::type_id::create("APP2EMB25_SEL");
        APP2EMB24_SEL = uvm_reg_field::type_id::create("APP2EMB24_SEL");
        APP2EMB23_SEL = uvm_reg_field::type_id::create("APP2EMB23_SEL");
        APP2EMB22_SEL = uvm_reg_field::type_id::create("APP2EMB22_SEL");
        APP2EMB21_SEL = uvm_reg_field::type_id::create("APP2EMB21_SEL");
        APP2EMB20_SEL = uvm_reg_field::type_id::create("APP2EMB20_SEL");
        APP2EMB19_SEL = uvm_reg_field::type_id::create("APP2EMB19_SEL");
        APP2EMB18_SEL = uvm_reg_field::type_id::create("APP2EMB18_SEL");
        APP2EMB17_SEL = uvm_reg_field::type_id::create("APP2EMB17_SEL");
        APP2EMB16_SEL = uvm_reg_field::type_id::create("APP2EMB16_SEL");

        APP2EMB31_SEL.configure(this, 2, 30, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB30_SEL.configure(this, 2, 28, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB29_SEL.configure(this, 2, 26, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB28_SEL.configure(this, 2, 24, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB27_SEL.configure(this, 2, 22, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB26_SEL.configure(this, 2, 20, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB25_SEL.configure(this, 2, 18, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB24_SEL.configure(this, 2, 16, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB23_SEL.configure(this, 2, 14, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB22_SEL.configure(this, 2, 12, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB21_SEL.configure(this, 2, 10, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB20_SEL.configure(this, 2, 8, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB19_SEL.configure(this, 2, 6, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB18_SEL.configure(this, 2, 4, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB17_SEL.configure(this, 2, 2, "RW", 1, 'b0, 1, 1, 1);
        APP2EMB16_SEL.configure(this, 2, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="IPCEMB_APP2EMB_LINE_SEL_HIGH_wr_cg";
        APP2EMB31_SEL_wr : coverpoint APP2EMB31_SEL.value[1:0];
        APP2EMB30_SEL_wr : coverpoint APP2EMB30_SEL.value[1:0];
        APP2EMB29_SEL_wr : coverpoint APP2EMB29_SEL.value[1:0];
        APP2EMB28_SEL_wr : coverpoint APP2EMB28_SEL.value[1:0];
        APP2EMB27_SEL_wr : coverpoint APP2EMB27_SEL.value[1:0];
        APP2EMB26_SEL_wr : coverpoint APP2EMB26_SEL.value[1:0];
        APP2EMB25_SEL_wr : coverpoint APP2EMB25_SEL.value[1:0];
        APP2EMB24_SEL_wr : coverpoint APP2EMB24_SEL.value[1:0];
        APP2EMB23_SEL_wr : coverpoint APP2EMB23_SEL.value[1:0];
        APP2EMB22_SEL_wr : coverpoint APP2EMB22_SEL.value[1:0];
        APP2EMB21_SEL_wr : coverpoint APP2EMB21_SEL.value[1:0];
        APP2EMB20_SEL_wr : coverpoint APP2EMB20_SEL.value[1:0];
        APP2EMB19_SEL_wr : coverpoint APP2EMB19_SEL.value[1:0];
        APP2EMB18_SEL_wr : coverpoint APP2EMB18_SEL.value[1:0];
        APP2EMB17_SEL_wr : coverpoint APP2EMB17_SEL.value[1:0];
        APP2EMB16_SEL_wr : coverpoint APP2EMB16_SEL.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="IPCEMB_APP2EMB_LINE_SEL_HIGH_rd_cg";
        APP2EMB31_SEL_rd : coverpoint APP2EMB31_SEL.value[1:0];
        APP2EMB30_SEL_rd : coverpoint APP2EMB30_SEL.value[1:0];
        APP2EMB29_SEL_rd : coverpoint APP2EMB29_SEL.value[1:0];
        APP2EMB28_SEL_rd : coverpoint APP2EMB28_SEL.value[1:0];
        APP2EMB27_SEL_rd : coverpoint APP2EMB27_SEL.value[1:0];
        APP2EMB26_SEL_rd : coverpoint APP2EMB26_SEL.value[1:0];
        APP2EMB25_SEL_rd : coverpoint APP2EMB25_SEL.value[1:0];
        APP2EMB24_SEL_rd : coverpoint APP2EMB24_SEL.value[1:0];
        APP2EMB23_SEL_rd : coverpoint APP2EMB23_SEL.value[1:0];
        APP2EMB22_SEL_rd : coverpoint APP2EMB22_SEL.value[1:0];
        APP2EMB21_SEL_rd : coverpoint APP2EMB21_SEL.value[1:0];
        APP2EMB20_SEL_rd : coverpoint APP2EMB20_SEL.value[1:0];
        APP2EMB19_SEL_rd : coverpoint APP2EMB19_SEL.value[1:0];
        APP2EMB18_SEL_rd : coverpoint APP2EMB18_SEL.value[1:0];
        APP2EMB17_SEL_rd : coverpoint APP2EMB17_SEL.value[1:0];
        APP2EMB16_SEL_rd : coverpoint APP2EMB16_SEL.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "APP2EMB_LINE_SEL_HIGH");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// APP2EMB_STATUS
//--------------------------------------------------------------------
class APP2EMB_STATUS extends uvm_reg;
    `uvm_object_utils(APP2EMB_STATUS)
    rand uvm_reg_field APP2EMB_STATUS;

    //---build------------------------------------------------------------
    virtual function void build();
        APP2EMB_STATUS = uvm_reg_field::type_id::create("APP2EMB_STATUS");

        APP2EMB_STATUS.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="IPCEMB_APP2EMB_STATUS_rd_cg";
        APP2EMB_STATUS_rd : coverpoint APP2EMB_STATUS.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "APP2EMB_STATUS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EMB_SIGNATURE
//--------------------------------------------------------------------
class EMB_SIGNATURE extends uvm_reg;
    `uvm_object_utils(EMB_SIGNATURE)
    rand uvm_reg_field SIGNATURE;

    //---build------------------------------------------------------------
    virtual function void build();
        SIGNATURE = uvm_reg_field::type_id::create("SIGNATURE");

        SIGNATURE.configure(this, 32, 0, "RO", 1, 'b1001001010100000100001100110010, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="IPCEMB_EMB_SIGNATURE_rd_cg";
        SIGNATURE_rd : coverpoint SIGNATURE.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EMB_SIGNATURE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class IPCEMB_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(IPCEMB_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins EMB2APP_TRIGGER              = {'h0};
        bins APP2EMB_RAWSTATUS              = {'h4};
        bins APP2EMB_ACK              = {'h8};
        bins APP2EMB_UNMASK_SET              = {'hC};
        bins APP2EMB_UNMASK_CLEAR              = {'h10};
        bins APP2EMB_LINE_SEL_LOW              = {'h14};
        bins APP2EMB_LINE_SEL_HIGH              = {'h18};
        bins APP2EMB_STATUS              = {'h1C};
        bins EMB_SIGNATURE              = {'h40};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "IPCEMB_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: IPCEMB_reg_access_wrapper

//-------------------------------------------------------------------
// IPCEMB_register_block
//--------------------------------------------------------------------
class IPCEMB_register_block extends uvm_reg_block;
    `uvm_object_utils(IPCEMB_register_block)

    rand EMB2APP_TRIGGER EMB2APP_TRIGGER_reg;
    rand APP2EMB_RAWSTATUS APP2EMB_RAWSTATUS_reg;
    rand APP2EMB_ACK APP2EMB_ACK_reg;
    rand APP2EMB_UNMASK_SET APP2EMB_UNMASK_SET_reg;
    rand APP2EMB_UNMASK_CLEAR APP2EMB_UNMASK_CLEAR_reg;
    rand APP2EMB_LINE_SEL_LOW APP2EMB_LINE_SEL_LOW_reg;
    rand APP2EMB_LINE_SEL_HIGH APP2EMB_LINE_SEL_HIGH_reg;
    rand APP2EMB_STATUS APP2EMB_STATUS_reg;
    rand EMB_SIGNATURE EMB_SIGNATURE_reg;

    uvm_reg_map IPCEMB_register_map; // Block map
    IPCEMB_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "IPCEMB_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = IPCEMB_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        EMB2APP_TRIGGER_reg = EMB2APP_TRIGGER::type_id::create("EMB2APP_TRIGGER");
        EMB2APP_TRIGGER_reg.configure(this);
        EMB2APP_TRIGGER_reg.build();

        APP2EMB_RAWSTATUS_reg = APP2EMB_RAWSTATUS::type_id::create("APP2EMB_RAWSTATUS");
        APP2EMB_RAWSTATUS_reg.configure(this);
        APP2EMB_RAWSTATUS_reg.build();

        APP2EMB_ACK_reg = APP2EMB_ACK::type_id::create("APP2EMB_ACK");
        APP2EMB_ACK_reg.configure(this);
        APP2EMB_ACK_reg.build();

        APP2EMB_UNMASK_SET_reg = APP2EMB_UNMASK_SET::type_id::create("APP2EMB_UNMASK_SET");
        APP2EMB_UNMASK_SET_reg.configure(this);
        APP2EMB_UNMASK_SET_reg.build();

        APP2EMB_UNMASK_CLEAR_reg = APP2EMB_UNMASK_CLEAR::type_id::create("APP2EMB_UNMASK_CLEAR");
        APP2EMB_UNMASK_CLEAR_reg.configure(this);
        APP2EMB_UNMASK_CLEAR_reg.build();

        APP2EMB_LINE_SEL_LOW_reg = APP2EMB_LINE_SEL_LOW::type_id::create("APP2EMB_LINE_SEL_LOW");
        APP2EMB_LINE_SEL_LOW_reg.configure(this);
        APP2EMB_LINE_SEL_LOW_reg.build();

        APP2EMB_LINE_SEL_HIGH_reg = APP2EMB_LINE_SEL_HIGH::type_id::create("APP2EMB_LINE_SEL_HIGH");
        APP2EMB_LINE_SEL_HIGH_reg.configure(this);
        APP2EMB_LINE_SEL_HIGH_reg.build();

        APP2EMB_STATUS_reg = APP2EMB_STATUS::type_id::create("APP2EMB_STATUS");
        APP2EMB_STATUS_reg.configure(this);
        APP2EMB_STATUS_reg.build();

        EMB_SIGNATURE_reg = EMB_SIGNATURE::type_id::create("EMB_SIGNATURE");
        EMB_SIGNATURE_reg.configure(this);
        EMB_SIGNATURE_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        IPCEMB_register_map = create_map("IPCEMB_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        IPCEMB_register_map.add_reg(EMB2APP_TRIGGER_reg, 'h0, "RW");
        IPCEMB_register_map.add_reg(APP2EMB_RAWSTATUS_reg, 'h4, "RO");
        IPCEMB_register_map.add_reg(APP2EMB_ACK_reg, 'h8, "RW");
        IPCEMB_register_map.add_reg(APP2EMB_UNMASK_SET_reg, 'hC, "RW");
        IPCEMB_register_map.add_reg(APP2EMB_UNMASK_CLEAR_reg, 'h10, "RW");
        IPCEMB_register_map.add_reg(APP2EMB_LINE_SEL_LOW_reg, 'h14, "RW");
        IPCEMB_register_map.add_reg(APP2EMB_LINE_SEL_HIGH_reg, 'h18, "RW");
        IPCEMB_register_map.add_reg(APP2EMB_STATUS_reg, 'h1C, "RO");
        IPCEMB_register_map.add_reg(EMB_SIGNATURE_reg, 'h40, "RO");

        // Lock the register model and build the map
        lock_model();
        IPCEMB_register_map.set_check_on_read();
    endfunction

endclass
`endif // __IPCEMB_REG_BLOCK_SV__
