//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for LA
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __LA_REG_BLOCK_SV__
`define __LA_REG_BLOCK_SV__

//--------------------------------------------------------------------
// ID_LOW
//--------------------------------------------------------------------
class ID_LOW extends uvm_reg;
    `uvm_object_utils(ID_LOW)
    rand uvm_reg_field id_low;

    //---build------------------------------------------------------------
    virtual function void build();
        id_low = uvm_reg_field::type_id::create("id_low");

        id_low.configure(this, 32, 0, "RO", 1, 'b1100101011011100110010101100010, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_ID_LOW_rd_cg";
        id_low_rd : coverpoint id_low.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ID_LOW");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ID_HIGH
//--------------------------------------------------------------------
class ID_HIGH extends uvm_reg;
    `uvm_object_utils(ID_HIGH)
    rand uvm_reg_field la_width;
    rand uvm_reg_field la_depth;

    //---build------------------------------------------------------------
    virtual function void build();
        la_width = uvm_reg_field::type_id::create("la_width");
        la_depth = uvm_reg_field::type_id::create("la_depth");

        la_width.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        la_depth.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_ID_HIGH_rd_cg";
        la_width_rd : coverpoint la_width.value[7:0];
        la_depth_rd : coverpoint la_depth.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ID_HIGH");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// VERSION
//--------------------------------------------------------------------
class VERSION extends uvm_reg;
    `uvm_object_utils(VERSION)
    rand uvm_reg_field samplingFreq;
    rand uvm_reg_field la_version;

    //---build------------------------------------------------------------
    virtual function void build();
        samplingFreq = uvm_reg_field::type_id::create("samplingFreq");
        la_version = uvm_reg_field::type_id::create("la_version");

        samplingFreq.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        la_version.configure(this, 24, 0, "RO", 1, 'b00001010000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_VERSION_rd_cg";
        samplingFreq_rd : coverpoint samplingFreq.value[7:0];
        la_version_rd : coverpoint la_version.value[23:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "VERSION");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CNTRL
//--------------------------------------------------------------------
class CNTRL extends uvm_reg;
    `uvm_object_utils(CNTRL)
    rand uvm_reg_field trigger_int_en;
    rand uvm_reg_field trigger_int_clear;
    rand uvm_reg_field trigger_int_set;
    rand uvm_reg_field ext_trigger_en;
    rand uvm_reg_field sw_trigger;
    rand uvm_reg_field reset;
    rand uvm_reg_field stop;
    rand uvm_reg_field start;

    //---build------------------------------------------------------------
    virtual function void build();
        trigger_int_en = uvm_reg_field::type_id::create("trigger_int_en");
        trigger_int_clear = uvm_reg_field::type_id::create("trigger_int_clear");
        trigger_int_set = uvm_reg_field::type_id::create("trigger_int_set");
        ext_trigger_en = uvm_reg_field::type_id::create("ext_trigger_en");
        sw_trigger = uvm_reg_field::type_id::create("sw_trigger");
        reset = uvm_reg_field::type_id::create("reset");
        stop = uvm_reg_field::type_id::create("stop");
        start = uvm_reg_field::type_id::create("start");

        trigger_int_en.configure(this, 1, 14, "RW", 1, 'b0, 1, 1, 1);
        trigger_int_clear.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        trigger_int_set.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        ext_trigger_en.configure(this, 4, 4, "RW", 1, 'b1111, 1, 1, 1);
        sw_trigger.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        reset.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        stop.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        start.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_CNTRL_wr_cg";
        trigger_int_en_wr : coverpoint trigger_int_en.value[0:0];
        trigger_int_clear_wr : coverpoint trigger_int_clear.value[0:0];
        trigger_int_set_wr : coverpoint trigger_int_set.value[0:0];
        ext_trigger_en_wr : coverpoint ext_trigger_en.value[3:0];
        sw_trigger_wr : coverpoint sw_trigger.value[0:0];
        reset_wr : coverpoint reset.value[0:0];
        stop_wr : coverpoint stop.value[0:0];
        start_wr : coverpoint start.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_CNTRL_rd_cg";
        trigger_int_en_rd : coverpoint trigger_int_en.value[0:0];
        trigger_int_clear_rd : coverpoint trigger_int_clear.value[0:0];
        trigger_int_set_rd : coverpoint trigger_int_set.value[0:0];
        ext_trigger_en_rd : coverpoint ext_trigger_en.value[3:0];
        sw_trigger_rd : coverpoint sw_trigger.value[0:0];
        reset_rd : coverpoint reset.value[0:0];
        stop_rd : coverpoint stop.value[0:0];
        start_rd : coverpoint start.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CNTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STATUS
//--------------------------------------------------------------------
class STATUS extends uvm_reg;
    `uvm_object_utils(STATUS)
    rand uvm_reg_field writeaddr;
    rand uvm_reg_field ext_trigger_status;
    rand uvm_reg_field sw_trigger_status;
    rand uvm_reg_field internal_trigger_status;
    rand uvm_reg_field triggered;
    rand uvm_reg_field started;

    //---build------------------------------------------------------------
    virtual function void build();
        writeaddr = uvm_reg_field::type_id::create("writeaddr");
        ext_trigger_status = uvm_reg_field::type_id::create("ext_trigger_status");
        sw_trigger_status = uvm_reg_field::type_id::create("sw_trigger_status");
        internal_trigger_status = uvm_reg_field::type_id::create("internal_trigger_status");
        triggered = uvm_reg_field::type_id::create("triggered");
        started = uvm_reg_field::type_id::create("started");

        writeaddr.configure(this, 16, 8, "RO", 1, 'b000000000000000, 1, 1, 1);
        ext_trigger_status.configure(this, 4, 4, "RO", 1, 'b000, 1, 1, 1);
        sw_trigger_status.configure(this, 1, 3, "RO", 1, 'b0, 1, 1, 1);
        internal_trigger_status.configure(this, 1, 2, "RO", 1, 'b0, 1, 1, 1);
        triggered.configure(this, 1, 1, "RO", 1, 'b0, 1, 1, 1);
        started.configure(this, 1, 0, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_STATUS_rd_cg";
        writeaddr_rd : coverpoint writeaddr.value[15:0];
        ext_trigger_status_rd : coverpoint ext_trigger_status.value[3:0];
        sw_trigger_status_rd : coverpoint sw_trigger_status.value[0:0];
        internal_trigger_status_rd : coverpoint internal_trigger_status.value[0:0];
        triggered_rd : coverpoint triggered.value[0:0];
        started_rd : coverpoint started.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STATUS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SAMPLING_MASK0
//--------------------------------------------------------------------
class SAMPLING_MASK0 extends uvm_reg;
    `uvm_object_utils(SAMPLING_MASK0)
    rand uvm_reg_field sampling_mask0;

    //---build------------------------------------------------------------
    virtual function void build();
        sampling_mask0 = uvm_reg_field::type_id::create("sampling_mask0");

        sampling_mask0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_SAMPLING_MASK0_wr_cg";
        sampling_mask0_wr : coverpoint sampling_mask0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_SAMPLING_MASK0_rd_cg";
        sampling_mask0_rd : coverpoint sampling_mask0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SAMPLING_MASK0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SAMPLING_MASK1
//--------------------------------------------------------------------
class SAMPLING_MASK1 extends uvm_reg;
    `uvm_object_utils(SAMPLING_MASK1)
    rand uvm_reg_field sampling_mask1;

    //---build------------------------------------------------------------
    virtual function void build();
        sampling_mask1 = uvm_reg_field::type_id::create("sampling_mask1");

        sampling_mask1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_SAMPLING_MASK1_wr_cg";
        sampling_mask1_wr : coverpoint sampling_mask1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_SAMPLING_MASK1_rd_cg";
        sampling_mask1_rd : coverpoint sampling_mask1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SAMPLING_MASK1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SAMPLING_MASK2
//--------------------------------------------------------------------
class SAMPLING_MASK2 extends uvm_reg;
    `uvm_object_utils(SAMPLING_MASK2)
    rand uvm_reg_field sampling_mask2;

    //---build------------------------------------------------------------
    virtual function void build();
        sampling_mask2 = uvm_reg_field::type_id::create("sampling_mask2");

        sampling_mask2.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_SAMPLING_MASK2_wr_cg";
        sampling_mask2_wr : coverpoint sampling_mask2.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_SAMPLING_MASK2_rd_cg";
        sampling_mask2_rd : coverpoint sampling_mask2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SAMPLING_MASK2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGER_MASK0
//--------------------------------------------------------------------
class TRIGGER_MASK0 extends uvm_reg;
    `uvm_object_utils(TRIGGER_MASK0)
    rand uvm_reg_field trigger_mask0;

    //---build------------------------------------------------------------
    virtual function void build();
        trigger_mask0 = uvm_reg_field::type_id::create("trigger_mask0");

        trigger_mask0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_MASK0_wr_cg";
        trigger_mask0_wr : coverpoint trigger_mask0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_MASK0_rd_cg";
        trigger_mask0_rd : coverpoint trigger_mask0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGER_MASK0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGER_MASK1
//--------------------------------------------------------------------
class TRIGGER_MASK1 extends uvm_reg;
    `uvm_object_utils(TRIGGER_MASK1)
    rand uvm_reg_field trigger_mask1;

    //---build------------------------------------------------------------
    virtual function void build();
        trigger_mask1 = uvm_reg_field::type_id::create("trigger_mask1");

        trigger_mask1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_MASK1_wr_cg";
        trigger_mask1_wr : coverpoint trigger_mask1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_MASK1_rd_cg";
        trigger_mask1_rd : coverpoint trigger_mask1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGER_MASK1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGER_MASK2
//--------------------------------------------------------------------
class TRIGGER_MASK2 extends uvm_reg;
    `uvm_object_utils(TRIGGER_MASK2)
    rand uvm_reg_field trigger_mask2;

    //---build------------------------------------------------------------
    virtual function void build();
        trigger_mask2 = uvm_reg_field::type_id::create("trigger_mask2");

        trigger_mask2.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_MASK2_wr_cg";
        trigger_mask2_wr : coverpoint trigger_mask2.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_MASK2_rd_cg";
        trigger_mask2_rd : coverpoint trigger_mask2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGER_MASK2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGER_VALUE0
//--------------------------------------------------------------------
class TRIGGER_VALUE0 extends uvm_reg;
    `uvm_object_utils(TRIGGER_VALUE0)
    rand uvm_reg_field trigger_value0;

    //---build------------------------------------------------------------
    virtual function void build();
        trigger_value0 = uvm_reg_field::type_id::create("trigger_value0");

        trigger_value0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_VALUE0_wr_cg";
        trigger_value0_wr : coverpoint trigger_value0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_VALUE0_rd_cg";
        trigger_value0_rd : coverpoint trigger_value0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGER_VALUE0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGER_VALUE1
//--------------------------------------------------------------------
class TRIGGER_VALUE1 extends uvm_reg;
    `uvm_object_utils(TRIGGER_VALUE1)
    rand uvm_reg_field trigger_value1;

    //---build------------------------------------------------------------
    virtual function void build();
        trigger_value1 = uvm_reg_field::type_id::create("trigger_value1");

        trigger_value1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_VALUE1_wr_cg";
        trigger_value1_wr : coverpoint trigger_value1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_VALUE1_rd_cg";
        trigger_value1_rd : coverpoint trigger_value1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGER_VALUE1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGER_VALUE2
//--------------------------------------------------------------------
class TRIGGER_VALUE2 extends uvm_reg;
    `uvm_object_utils(TRIGGER_VALUE2)
    rand uvm_reg_field trigger_value2;

    //---build------------------------------------------------------------
    virtual function void build();
        trigger_value2 = uvm_reg_field::type_id::create("trigger_value2");

        trigger_value2.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_VALUE2_wr_cg";
        trigger_value2_wr : coverpoint trigger_value2.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_VALUE2_rd_cg";
        trigger_value2_rd : coverpoint trigger_value2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGER_VALUE2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGER_POINT
//--------------------------------------------------------------------
class TRIGGER_POINT extends uvm_reg;
    `uvm_object_utils(TRIGGER_POINT)
    rand uvm_reg_field trigger_point;

    //---build------------------------------------------------------------
    virtual function void build();
        trigger_point = uvm_reg_field::type_id::create("trigger_point");

        trigger_point.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_POINT_wr_cg";
        trigger_point_wr : coverpoint trigger_point.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_POINT_rd_cg";
        trigger_point_rd : coverpoint trigger_point.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGER_POINT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FIRSTSAMPLE
//--------------------------------------------------------------------
class FIRSTSAMPLE extends uvm_reg;
    `uvm_object_utils(FIRSTSAMPLE)
    rand uvm_reg_field firstsample;

    //---build------------------------------------------------------------
    virtual function void build();
        firstsample = uvm_reg_field::type_id::create("firstsample");

        firstsample.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_FIRSTSAMPLE_rd_cg";
        firstsample_rd : coverpoint firstsample.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FIRSTSAMPLE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SAMPLING_MASK3
//--------------------------------------------------------------------
class SAMPLING_MASK3 extends uvm_reg;
    `uvm_object_utils(SAMPLING_MASK3)
    rand uvm_reg_field sampling_mask3;

    //---build------------------------------------------------------------
    virtual function void build();
        sampling_mask3 = uvm_reg_field::type_id::create("sampling_mask3");

        sampling_mask3.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_SAMPLING_MASK3_wr_cg";
        sampling_mask3_wr : coverpoint sampling_mask3.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_SAMPLING_MASK3_rd_cg";
        sampling_mask3_rd : coverpoint sampling_mask3.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SAMPLING_MASK3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGER_MASK3
//--------------------------------------------------------------------
class TRIGGER_MASK3 extends uvm_reg;
    `uvm_object_utils(TRIGGER_MASK3)
    rand uvm_reg_field trigger_mask3;

    //---build------------------------------------------------------------
    virtual function void build();
        trigger_mask3 = uvm_reg_field::type_id::create("trigger_mask3");

        trigger_mask3.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_MASK3_wr_cg";
        trigger_mask3_wr : coverpoint trigger_mask3.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_MASK3_rd_cg";
        trigger_mask3_rd : coverpoint trigger_mask3.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGER_MASK3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGER_VALUE3
//--------------------------------------------------------------------
class TRIGGER_VALUE3 extends uvm_reg;
    `uvm_object_utils(TRIGGER_VALUE3)
    rand uvm_reg_field trigger_value3;

    //---build------------------------------------------------------------
    virtual function void build();
        trigger_value3 = uvm_reg_field::type_id::create("trigger_value3");

        trigger_value3.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_VALUE3_wr_cg";
        trigger_value3_wr : coverpoint trigger_value3.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="LA_TRIGGER_VALUE3_rd_cg";
        trigger_value3_rd : coverpoint trigger_value3.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGER_VALUE3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class LA_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(LA_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins ID_LOW              = {'h0};
        bins ID_HIGH              = {'h4};
        bins VERSION              = {'h8};
        bins CNTRL              = {'hC};
        bins STATUS              = {'h10};
        bins SAMPLING_MASK0              = {'h14};
        bins SAMPLING_MASK1              = {'h18};
        bins SAMPLING_MASK2              = {'h1C};
        bins TRIGGER_MASK0              = {'h20};
        bins TRIGGER_MASK1              = {'h24};
        bins TRIGGER_MASK2              = {'h28};
        bins TRIGGER_VALUE0              = {'h2C};
        bins TRIGGER_VALUE1              = {'h30};
        bins TRIGGER_VALUE2              = {'h34};
        bins TRIGGER_POINT              = {'h38};
        bins FIRSTSAMPLE              = {'h3C};
        bins SAMPLING_MASK3              = {'h40};
        bins TRIGGER_MASK3              = {'h44};
        bins TRIGGER_VALUE3              = {'h48};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "LA_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: LA_reg_access_wrapper

//-------------------------------------------------------------------
// LA_register_block
//--------------------------------------------------------------------
class LA_register_block extends uvm_reg_block;
    `uvm_object_utils(LA_register_block)

    rand ID_LOW ID_LOW_reg;
    rand ID_HIGH ID_HIGH_reg;
    rand VERSION VERSION_reg;
    rand CNTRL CNTRL_reg;
    rand STATUS STATUS_reg;
    rand SAMPLING_MASK0 SAMPLING_MASK0_reg;
    rand SAMPLING_MASK1 SAMPLING_MASK1_reg;
    rand SAMPLING_MASK2 SAMPLING_MASK2_reg;
    rand TRIGGER_MASK0 TRIGGER_MASK0_reg;
    rand TRIGGER_MASK1 TRIGGER_MASK1_reg;
    rand TRIGGER_MASK2 TRIGGER_MASK2_reg;
    rand TRIGGER_VALUE0 TRIGGER_VALUE0_reg;
    rand TRIGGER_VALUE1 TRIGGER_VALUE1_reg;
    rand TRIGGER_VALUE2 TRIGGER_VALUE2_reg;
    rand TRIGGER_POINT TRIGGER_POINT_reg;
    rand FIRSTSAMPLE FIRSTSAMPLE_reg;
    rand SAMPLING_MASK3 SAMPLING_MASK3_reg;
    rand TRIGGER_MASK3 TRIGGER_MASK3_reg;
    rand TRIGGER_VALUE3 TRIGGER_VALUE3_reg;

    uvm_reg_map LA_register_map; // Block map
    LA_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "LA_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = LA_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        ID_LOW_reg = ID_LOW::type_id::create("ID_LOW");
        ID_LOW_reg.configure(this);
        ID_LOW_reg.build();

        ID_HIGH_reg = ID_HIGH::type_id::create("ID_HIGH");
        ID_HIGH_reg.configure(this);
        ID_HIGH_reg.build();

        VERSION_reg = VERSION::type_id::create("VERSION");
        VERSION_reg.configure(this);
        VERSION_reg.build();

        CNTRL_reg = CNTRL::type_id::create("CNTRL");
        CNTRL_reg.configure(this);
        CNTRL_reg.build();

        STATUS_reg = STATUS::type_id::create("STATUS");
        STATUS_reg.configure(this);
        STATUS_reg.build();

        SAMPLING_MASK0_reg = SAMPLING_MASK0::type_id::create("SAMPLING_MASK0");
        SAMPLING_MASK0_reg.configure(this);
        SAMPLING_MASK0_reg.build();

        SAMPLING_MASK1_reg = SAMPLING_MASK1::type_id::create("SAMPLING_MASK1");
        SAMPLING_MASK1_reg.configure(this);
        SAMPLING_MASK1_reg.build();

        SAMPLING_MASK2_reg = SAMPLING_MASK2::type_id::create("SAMPLING_MASK2");
        SAMPLING_MASK2_reg.configure(this);
        SAMPLING_MASK2_reg.build();

        TRIGGER_MASK0_reg = TRIGGER_MASK0::type_id::create("TRIGGER_MASK0");
        TRIGGER_MASK0_reg.configure(this);
        TRIGGER_MASK0_reg.build();

        TRIGGER_MASK1_reg = TRIGGER_MASK1::type_id::create("TRIGGER_MASK1");
        TRIGGER_MASK1_reg.configure(this);
        TRIGGER_MASK1_reg.build();

        TRIGGER_MASK2_reg = TRIGGER_MASK2::type_id::create("TRIGGER_MASK2");
        TRIGGER_MASK2_reg.configure(this);
        TRIGGER_MASK2_reg.build();

        TRIGGER_VALUE0_reg = TRIGGER_VALUE0::type_id::create("TRIGGER_VALUE0");
        TRIGGER_VALUE0_reg.configure(this);
        TRIGGER_VALUE0_reg.build();

        TRIGGER_VALUE1_reg = TRIGGER_VALUE1::type_id::create("TRIGGER_VALUE1");
        TRIGGER_VALUE1_reg.configure(this);
        TRIGGER_VALUE1_reg.build();

        TRIGGER_VALUE2_reg = TRIGGER_VALUE2::type_id::create("TRIGGER_VALUE2");
        TRIGGER_VALUE2_reg.configure(this);
        TRIGGER_VALUE2_reg.build();

        TRIGGER_POINT_reg = TRIGGER_POINT::type_id::create("TRIGGER_POINT");
        TRIGGER_POINT_reg.configure(this);
        TRIGGER_POINT_reg.build();

        FIRSTSAMPLE_reg = FIRSTSAMPLE::type_id::create("FIRSTSAMPLE");
        FIRSTSAMPLE_reg.configure(this);
        FIRSTSAMPLE_reg.build();

        SAMPLING_MASK3_reg = SAMPLING_MASK3::type_id::create("SAMPLING_MASK3");
        SAMPLING_MASK3_reg.configure(this);
        SAMPLING_MASK3_reg.build();

        TRIGGER_MASK3_reg = TRIGGER_MASK3::type_id::create("TRIGGER_MASK3");
        TRIGGER_MASK3_reg.configure(this);
        TRIGGER_MASK3_reg.build();

        TRIGGER_VALUE3_reg = TRIGGER_VALUE3::type_id::create("TRIGGER_VALUE3");
        TRIGGER_VALUE3_reg.configure(this);
        TRIGGER_VALUE3_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        LA_register_map = create_map("LA_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        LA_register_map.add_reg(ID_LOW_reg, 'h0, "RO");
        LA_register_map.add_reg(ID_HIGH_reg, 'h4, "RO");
        LA_register_map.add_reg(VERSION_reg, 'h8, "RO");
        LA_register_map.add_reg(CNTRL_reg, 'hC, "RW");
        LA_register_map.add_reg(STATUS_reg, 'h10, "RO");
        LA_register_map.add_reg(SAMPLING_MASK0_reg, 'h14, "RW");
        LA_register_map.add_reg(SAMPLING_MASK1_reg, 'h18, "RW");
        LA_register_map.add_reg(SAMPLING_MASK2_reg, 'h1C, "RW");
        LA_register_map.add_reg(TRIGGER_MASK0_reg, 'h20, "RW");
        LA_register_map.add_reg(TRIGGER_MASK1_reg, 'h24, "RW");
        LA_register_map.add_reg(TRIGGER_MASK2_reg, 'h28, "RW");
        LA_register_map.add_reg(TRIGGER_VALUE0_reg, 'h2C, "RW");
        LA_register_map.add_reg(TRIGGER_VALUE1_reg, 'h30, "RW");
        LA_register_map.add_reg(TRIGGER_VALUE2_reg, 'h34, "RW");
        LA_register_map.add_reg(TRIGGER_POINT_reg, 'h38, "RW");
        LA_register_map.add_reg(FIRSTSAMPLE_reg, 'h3C, "RO");
        LA_register_map.add_reg(SAMPLING_MASK3_reg, 'h40, "RW");
        LA_register_map.add_reg(TRIGGER_MASK3_reg, 'h44, "RW");
        LA_register_map.add_reg(TRIGGER_VALUE3_reg, 'h48, "RW");

        // Lock the register model and build the map
        lock_model();
        LA_register_map.set_check_on_read();
    endfunction

endclass
`endif // __LA_REG_BLOCK_SV__
