//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for MACBYPASS
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __MACBYPASS_REG_BLOCK_SV__
`define __MACBYPASS_REG_BLOCK_SV__

//--------------------------------------------------------------------
// CTRL
//--------------------------------------------------------------------
class CTRL extends uvm_reg;
    `uvm_object_utils(CTRL)
    rand uvm_reg_field TX_DONE;
    rand uvm_reg_field MODE;
    rand uvm_reg_field CLEAR_STAT;
    rand uvm_reg_field DEFKEEPRFON;
    rand uvm_reg_field DEFRXREQ;
    rand uvm_reg_field BYPASS;

    //---build------------------------------------------------------------
    virtual function void build();
        TX_DONE = uvm_reg_field::type_id::create("TX_DONE");
        MODE = uvm_reg_field::type_id::create("MODE");
        CLEAR_STAT = uvm_reg_field::type_id::create("CLEAR_STAT");
        DEFKEEPRFON = uvm_reg_field::type_id::create("DEFKEEPRFON");
        DEFRXREQ = uvm_reg_field::type_id::create("DEFRXREQ");
        BYPASS = uvm_reg_field::type_id::create("BYPASS");

        TX_DONE.configure(this, 1, 31, "RO", 1, 'b0, 1, 1, 1);
        MODE.configure(this, 2, 8, "RW", 1, 'b0, 1, 1, 1);
        CLEAR_STAT.configure(this, 1, 4, "W1C", 1, 'b0, 1, 1, 1);
        DEFKEEPRFON.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        DEFRXREQ.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        BYPASS.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_CTRL_wr_cg";
        MODE_wr : coverpoint MODE.value[1:0];
        CLEAR_STAT_wr : coverpoint CLEAR_STAT.value[0:0];
        DEFKEEPRFON_wr : coverpoint DEFKEEPRFON.value[0:0];
        DEFRXREQ_wr : coverpoint DEFRXREQ.value[0:0];
        BYPASS_wr : coverpoint BYPASS.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_CTRL_rd_cg";
        TX_DONE_rd : coverpoint TX_DONE.value[0:0];
        MODE_rd : coverpoint MODE.value[1:0];
        DEFKEEPRFON_rd : coverpoint DEFKEEPRFON.value[0:0];
        DEFRXREQ_rd : coverpoint DEFRXREQ.value[0:0];
        BYPASS_rd : coverpoint BYPASS.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// PAYLOAD
//--------------------------------------------------------------------
class PAYLOAD extends uvm_reg;
    `uvm_object_utils(PAYLOAD)
    rand uvm_reg_field PAYLOAD_TX;
    rand uvm_reg_field PAYLOAD_RX;

    //---build------------------------------------------------------------
    virtual function void build();
        PAYLOAD_TX = uvm_reg_field::type_id::create("PAYLOAD_TX");
        PAYLOAD_RX = uvm_reg_field::type_id::create("PAYLOAD_RX");

        PAYLOAD_TX.configure(this, 4, 16, "RW", 1, 'b000, 1, 1, 1);
        PAYLOAD_RX.configure(this, 4, 0, "RW", 1, 'b000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_PAYLOAD_wr_cg";
        PAYLOAD_TX_wr : coverpoint PAYLOAD_TX.value[3:0];
        PAYLOAD_RX_wr : coverpoint PAYLOAD_RX.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_PAYLOAD_rd_cg";
        PAYLOAD_TX_rd : coverpoint PAYLOAD_TX.value[3:0];
        PAYLOAD_RX_rd : coverpoint PAYLOAD_RX.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "PAYLOAD");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGER
//--------------------------------------------------------------------
class TRIGGER extends uvm_reg;
    `uvm_object_utils(TRIGGER)
    rand uvm_reg_field TRIGGER1;
    rand uvm_reg_field TRIGGER0;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIGGER1 = uvm_reg_field::type_id::create("TRIGGER1");
        TRIGGER0 = uvm_reg_field::type_id::create("TRIGGER0");

        TRIGGER1.configure(this, 4, 4, "RW", 1, 'b000, 1, 1, 1);
        TRIGGER0.configure(this, 4, 0, "RW", 1, 'b000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGGER_wr_cg";
        TRIGGER1_wr : coverpoint TRIGGER1.value[3:0];
        TRIGGER0_wr : coverpoint TRIGGER0.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGGER_rd_cg";
        TRIGGER1_rd : coverpoint TRIGGER1.value[3:0];
        TRIGGER0_rd : coverpoint TRIGGER0.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGER");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CLKEN
//--------------------------------------------------------------------
class CLKEN extends uvm_reg;
    `uvm_object_utils(CLKEN)
    rand uvm_reg_field CLKEN;

    //---build------------------------------------------------------------
    virtual function void build();
        CLKEN = uvm_reg_field::type_id::create("CLKEN");

        CLKEN.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_CLKEN_wr_cg";
        CLKEN_wr : coverpoint CLKEN.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_CLKEN_rd_cg";
        CLKEN_rd : coverpoint CLKEN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CLKEN");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FRAMEPERBURST
//--------------------------------------------------------------------
class FRAMEPERBURST extends uvm_reg;
    `uvm_object_utils(FRAMEPERBURST)
    rand uvm_reg_field NFRAME;

    //---build------------------------------------------------------------
    virtual function void build();
        NFRAME = uvm_reg_field::type_id::create("NFRAME");

        NFRAME.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_FRAMEPERBURST_wr_cg";
        NFRAME_wr : coverpoint NFRAME.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_FRAMEPERBURST_rd_cg";
        NFRAME_rd : coverpoint NFRAME.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FRAMEPERBURST");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INTERFRAME_DELAY
//--------------------------------------------------------------------
class INTERFRAME_DELAY extends uvm_reg;
    `uvm_object_utils(INTERFRAME_DELAY)
    rand uvm_reg_field INTERFRAME_DELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        INTERFRAME_DELAY = uvm_reg_field::type_id::create("INTERFRAME_DELAY");

        INTERFRAME_DELAY.configure(this, 20, 0, "RW", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INTERFRAME_DELAY_wr_cg";
        INTERFRAME_DELAY_wr : coverpoint INTERFRAME_DELAY.value[19:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INTERFRAME_DELAY_rd_cg";
        INTERFRAME_DELAY_rd : coverpoint INTERFRAME_DELAY.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INTERFRAME_DELAY");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_FRAME_OK
//--------------------------------------------------------------------
class STAT_FRAME_OK extends uvm_reg;
    `uvm_object_utils(STAT_FRAME_OK)
    rand uvm_reg_field STAT_FRAME_OK;

    //---build------------------------------------------------------------
    virtual function void build();
        STAT_FRAME_OK = uvm_reg_field::type_id::create("STAT_FRAME_OK");

        STAT_FRAME_OK.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_STAT_FRAME_OK_rd_cg";
        STAT_FRAME_OK_rd : coverpoint STAT_FRAME_OK.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_FRAME_OK");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_FRAME_BAD
//--------------------------------------------------------------------
class STAT_FRAME_BAD extends uvm_reg;
    `uvm_object_utils(STAT_FRAME_BAD)
    rand uvm_reg_field STAT_FRAME_BAD;

    //---build------------------------------------------------------------
    virtual function void build();
        STAT_FRAME_BAD = uvm_reg_field::type_id::create("STAT_FRAME_BAD");

        STAT_FRAME_BAD.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_STAT_FRAME_BAD_rd_cg";
        STAT_FRAME_BAD_rd : coverpoint STAT_FRAME_BAD.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_FRAME_BAD");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_RXEND
//--------------------------------------------------------------------
class STAT_RXEND extends uvm_reg;
    `uvm_object_utils(STAT_RXEND)
    rand uvm_reg_field STAT_FRAME_RXEND;

    //---build------------------------------------------------------------
    virtual function void build();
        STAT_FRAME_RXEND = uvm_reg_field::type_id::create("STAT_FRAME_RXEND");

        STAT_FRAME_RXEND.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_STAT_RXEND_rd_cg";
        STAT_FRAME_RXEND_rd : coverpoint STAT_FRAME_RXEND.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_RXEND");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_RXERROR
//--------------------------------------------------------------------
class STAT_RXERROR extends uvm_reg;
    `uvm_object_utils(STAT_RXERROR)
    rand uvm_reg_field STAT_FRAME_RXERROR;

    //---build------------------------------------------------------------
    virtual function void build();
        STAT_FRAME_RXERROR = uvm_reg_field::type_id::create("STAT_FRAME_RXERROR");

        STAT_FRAME_RXERROR.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_STAT_RXERROR_rd_cg";
        STAT_FRAME_RXERROR_rd : coverpoint STAT_FRAME_RXERROR.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_RXERROR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_EVM
//--------------------------------------------------------------------
class STAT_EVM extends uvm_reg;
    `uvm_object_utils(STAT_EVM)
    rand uvm_reg_field EVM3;
    rand uvm_reg_field EVM2;
    rand uvm_reg_field EVM1;
    rand uvm_reg_field EVM0;

    //---build------------------------------------------------------------
    virtual function void build();
        EVM3 = uvm_reg_field::type_id::create("EVM3");
        EVM2 = uvm_reg_field::type_id::create("EVM2");
        EVM1 = uvm_reg_field::type_id::create("EVM1");
        EVM0 = uvm_reg_field::type_id::create("EVM0");

        EVM3.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        EVM2.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        EVM1.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        EVM0.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_STAT_EVM_rd_cg";
        EVM3_rd : coverpoint EVM3.value[7:0];
        EVM2_rd : coverpoint EVM2.value[7:0];
        EVM1_rd : coverpoint EVM1.value[7:0];
        EVM0_rd : coverpoint EVM0.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_EVM");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_RSSI
//--------------------------------------------------------------------
class STAT_RSSI extends uvm_reg;
    `uvm_object_utils(STAT_RSSI)
    rand uvm_reg_field RSSI;
    rand uvm_reg_field LEG_RSSI;

    //---build------------------------------------------------------------
    virtual function void build();
        RSSI = uvm_reg_field::type_id::create("RSSI");
        LEG_RSSI = uvm_reg_field::type_id::create("LEG_RSSI");

        RSSI.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        LEG_RSSI.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_STAT_RSSI_rd_cg";
        RSSI_rd : coverpoint RSSI.value[7:0];
        LEG_RSSI_rd : coverpoint LEG_RSSI.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_RSSI");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_PHYERR
//--------------------------------------------------------------------
class STAT_PHYERR extends uvm_reg;
    `uvm_object_utils(STAT_PHYERR)
    rand uvm_reg_field STAT_PHYERR;

    //---build------------------------------------------------------------
    virtual function void build();
        STAT_PHYERR = uvm_reg_field::type_id::create("STAT_PHYERR");

        STAT_PHYERR.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_STAT_PHYERR_rd_cg";
        STAT_PHYERR_rd : coverpoint STAT_PHYERR.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_PHYERR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_CTRL
//--------------------------------------------------------------------
class INT_CTRL extends uvm_reg;
    `uvm_object_utils(INT_CTRL)
    rand uvm_reg_field RXV_LOCK_EN;
    rand uvm_reg_field INTERRUPT3_EN;
    rand uvm_reg_field INTERRUPT2_EN;
    rand uvm_reg_field INTERRUPT1_EN;
    rand uvm_reg_field INTERRUPT0_EN;

    //---build------------------------------------------------------------
    virtual function void build();
        RXV_LOCK_EN = uvm_reg_field::type_id::create("RXV_LOCK_EN");
        INTERRUPT3_EN = uvm_reg_field::type_id::create("INTERRUPT3_EN");
        INTERRUPT2_EN = uvm_reg_field::type_id::create("INTERRUPT2_EN");
        INTERRUPT1_EN = uvm_reg_field::type_id::create("INTERRUPT1_EN");
        INTERRUPT0_EN = uvm_reg_field::type_id::create("INTERRUPT0_EN");

        RXV_LOCK_EN.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        INTERRUPT3_EN.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        INTERRUPT2_EN.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        INTERRUPT1_EN.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        INTERRUPT0_EN.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INT_CTRL_wr_cg";
        RXV_LOCK_EN_wr : coverpoint RXV_LOCK_EN.value[0:0];
        INTERRUPT3_EN_wr : coverpoint INTERRUPT3_EN.value[0:0];
        INTERRUPT2_EN_wr : coverpoint INTERRUPT2_EN.value[0:0];
        INTERRUPT1_EN_wr : coverpoint INTERRUPT1_EN.value[0:0];
        INTERRUPT0_EN_wr : coverpoint INTERRUPT0_EN.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INT_CTRL_rd_cg";
        RXV_LOCK_EN_rd : coverpoint RXV_LOCK_EN.value[0:0];
        INTERRUPT3_EN_rd : coverpoint INTERRUPT3_EN.value[0:0];
        INTERRUPT2_EN_rd : coverpoint INTERRUPT2_EN.value[0:0];
        INTERRUPT1_EN_rd : coverpoint INTERRUPT1_EN.value[0:0];
        INTERRUPT0_EN_rd : coverpoint INTERRUPT0_EN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_CTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_GENERATION
//--------------------------------------------------------------------
class INT_GENERATION extends uvm_reg;
    `uvm_object_utils(INT_GENERATION)
    rand uvm_reg_field INT3_GEN;
    rand uvm_reg_field INT2_GEN;
    rand uvm_reg_field INT1_GEN;
    rand uvm_reg_field INT0_GEN;

    //---build------------------------------------------------------------
    virtual function void build();
        INT3_GEN = uvm_reg_field::type_id::create("INT3_GEN");
        INT2_GEN = uvm_reg_field::type_id::create("INT2_GEN");
        INT1_GEN = uvm_reg_field::type_id::create("INT1_GEN");
        INT0_GEN = uvm_reg_field::type_id::create("INT0_GEN");

        INT3_GEN.configure(this, 8, 24, "RW", 1, 'b0000000, 1, 1, 1);
        INT2_GEN.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        INT1_GEN.configure(this, 8, 8, "RW", 1, 'b0000000, 1, 1, 1);
        INT0_GEN.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INT_GENERATION_wr_cg";
        INT3_GEN_wr : coverpoint INT3_GEN.value[7:0];
        INT2_GEN_wr : coverpoint INT2_GEN.value[7:0];
        INT1_GEN_wr : coverpoint INT1_GEN.value[7:0];
        INT0_GEN_wr : coverpoint INT0_GEN.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INT_GENERATION_rd_cg";
        INT3_GEN_rd : coverpoint INT3_GEN.value[7:0];
        INT2_GEN_rd : coverpoint INT2_GEN.value[7:0];
        INT1_GEN_rd : coverpoint INT1_GEN.value[7:0];
        INT0_GEN_rd : coverpoint INT0_GEN.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_GENERATION");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_STAT_RAW
//--------------------------------------------------------------------
class INT_STAT_RAW extends uvm_reg;
    `uvm_object_utils(INT_STAT_RAW)
    rand uvm_reg_field RXV_LOCK_STATE;
    rand uvm_reg_field INT3_STATE;
    rand uvm_reg_field INT2_STATE;
    rand uvm_reg_field INT1_STATE;
    rand uvm_reg_field INT0_STATE;

    //---build------------------------------------------------------------
    virtual function void build();
        RXV_LOCK_STATE = uvm_reg_field::type_id::create("RXV_LOCK_STATE");
        INT3_STATE = uvm_reg_field::type_id::create("INT3_STATE");
        INT2_STATE = uvm_reg_field::type_id::create("INT2_STATE");
        INT1_STATE = uvm_reg_field::type_id::create("INT1_STATE");
        INT0_STATE = uvm_reg_field::type_id::create("INT0_STATE");

        RXV_LOCK_STATE.configure(this, 1, 16, "RO", 1, 'b0, 1, 1, 1);
        INT3_STATE.configure(this, 1, 3, "RO", 1, 'b0, 1, 1, 1);
        INT2_STATE.configure(this, 1, 2, "RO", 1, 'b0, 1, 1, 1);
        INT1_STATE.configure(this, 1, 1, "RO", 1, 'b0, 1, 1, 1);
        INT0_STATE.configure(this, 1, 0, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INT_STAT_RAW_rd_cg";
        RXV_LOCK_STATE_rd : coverpoint RXV_LOCK_STATE.value[0:0];
        INT3_STATE_rd : coverpoint INT3_STATE.value[0:0];
        INT2_STATE_rd : coverpoint INT2_STATE.value[0:0];
        INT1_STATE_rd : coverpoint INT1_STATE.value[0:0];
        INT0_STATE_rd : coverpoint INT0_STATE.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_STAT_RAW");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_STAT_ACK
//--------------------------------------------------------------------
class INT_STAT_ACK extends uvm_reg;
    `uvm_object_utils(INT_STAT_ACK)
    rand uvm_reg_field RXV_LOCK_RELEASE;
    rand uvm_reg_field INT3_ACK;
    rand uvm_reg_field INT2_ACK;
    rand uvm_reg_field INT1_ACK;
    rand uvm_reg_field INT0_ACK;

    //---build------------------------------------------------------------
    virtual function void build();
        RXV_LOCK_RELEASE = uvm_reg_field::type_id::create("RXV_LOCK_RELEASE");
        INT3_ACK = uvm_reg_field::type_id::create("INT3_ACK");
        INT2_ACK = uvm_reg_field::type_id::create("INT2_ACK");
        INT1_ACK = uvm_reg_field::type_id::create("INT1_ACK");
        INT0_ACK = uvm_reg_field::type_id::create("INT0_ACK");

        RXV_LOCK_RELEASE.configure(this, 1, 16, "W1C", 1, 'b0, 1, 1, 1);
        INT3_ACK.configure(this, 1, 3, "W1C", 1, 'b0, 1, 1, 1);
        INT2_ACK.configure(this, 1, 2, "W1C", 1, 'b0, 1, 1, 1);
        INT1_ACK.configure(this, 1, 1, "W1C", 1, 'b0, 1, 1, 1);
        INT0_ACK.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INT_STAT_ACK_wr_cg";
        RXV_LOCK_RELEASE_wr : coverpoint RXV_LOCK_RELEASE.value[0:0];
        INT3_ACK_wr : coverpoint INT3_ACK.value[0:0];
        INT2_ACK_wr : coverpoint INT2_ACK.value[0:0];
        INT1_ACK_wr : coverpoint INT1_ACK.value[0:0];
        INT0_ACK_wr : coverpoint INT0_ACK.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_STAT_ACK");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_RXV0
//--------------------------------------------------------------------
class INT_RXV0 extends uvm_reg;
    `uvm_object_utils(INT_RXV0)
    rand uvm_reg_field RXV3;
    rand uvm_reg_field RXV2;
    rand uvm_reg_field RXV1;
    rand uvm_reg_field RXV0;

    //---build------------------------------------------------------------
    virtual function void build();
        RXV3 = uvm_reg_field::type_id::create("RXV3");
        RXV2 = uvm_reg_field::type_id::create("RXV2");
        RXV1 = uvm_reg_field::type_id::create("RXV1");
        RXV0 = uvm_reg_field::type_id::create("RXV0");

        RXV3.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        RXV2.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        RXV1.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        RXV0.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INT_RXV0_rd_cg";
        RXV3_rd : coverpoint RXV3.value[7:0];
        RXV2_rd : coverpoint RXV2.value[7:0];
        RXV1_rd : coverpoint RXV1.value[7:0];
        RXV0_rd : coverpoint RXV0.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_RXV0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_RXV4
//--------------------------------------------------------------------
class INT_RXV4 extends uvm_reg;
    `uvm_object_utils(INT_RXV4)
    rand uvm_reg_field RXV7;
    rand uvm_reg_field RXV6;
    rand uvm_reg_field RXV5;
    rand uvm_reg_field RXV4;

    //---build------------------------------------------------------------
    virtual function void build();
        RXV7 = uvm_reg_field::type_id::create("RXV7");
        RXV6 = uvm_reg_field::type_id::create("RXV6");
        RXV5 = uvm_reg_field::type_id::create("RXV5");
        RXV4 = uvm_reg_field::type_id::create("RXV4");

        RXV7.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        RXV6.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        RXV5.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        RXV4.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INT_RXV4_rd_cg";
        RXV7_rd : coverpoint RXV7.value[7:0];
        RXV6_rd : coverpoint RXV6.value[7:0];
        RXV5_rd : coverpoint RXV5.value[7:0];
        RXV4_rd : coverpoint RXV4.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_RXV4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// INT_RXV8
//--------------------------------------------------------------------
class INT_RXV8 extends uvm_reg;
    `uvm_object_utils(INT_RXV8)
    rand uvm_reg_field RXV11;
    rand uvm_reg_field RXV10;
    rand uvm_reg_field RXV9;
    rand uvm_reg_field RXV8;

    //---build------------------------------------------------------------
    virtual function void build();
        RXV11 = uvm_reg_field::type_id::create("RXV11");
        RXV10 = uvm_reg_field::type_id::create("RXV10");
        RXV9 = uvm_reg_field::type_id::create("RXV9");
        RXV8 = uvm_reg_field::type_id::create("RXV8");

        RXV11.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        RXV10.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        RXV9.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        RXV8.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_INT_RXV8_rd_cg";
        RXV11_rd : coverpoint RXV11.value[7:0];
        RXV10_rd : coverpoint RXV10.value[7:0];
        RXV9_rd : coverpoint RXV9.value[7:0];
        RXV8_rd : coverpoint RXV8.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "INT_RXV8");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXV12
//--------------------------------------------------------------------
class RXV12 extends uvm_reg;
    `uvm_object_utils(RXV12)
    rand uvm_reg_field RXV15;
    rand uvm_reg_field RXV14;
    rand uvm_reg_field RXV13;
    rand uvm_reg_field RXV12;

    //---build------------------------------------------------------------
    virtual function void build();
        RXV15 = uvm_reg_field::type_id::create("RXV15");
        RXV14 = uvm_reg_field::type_id::create("RXV14");
        RXV13 = uvm_reg_field::type_id::create("RXV13");
        RXV12 = uvm_reg_field::type_id::create("RXV12");

        RXV15.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        RXV14.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        RXV13.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        RXV12.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_RXV12_rd_cg";
        RXV15_rd : coverpoint RXV15.value[7:0];
        RXV14_rd : coverpoint RXV14.value[7:0];
        RXV13_rd : coverpoint RXV13.value[7:0];
        RXV12_rd : coverpoint RXV12.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXV12");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGFORMATMOD
//--------------------------------------------------------------------
class TRIGFORMATMOD extends uvm_reg;
    `uvm_object_utils(TRIGFORMATMOD)
    rand uvm_reg_field TRIG_FORMATMOD_EN;
    rand uvm_reg_field TRIG_FORMATMOD;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_FORMATMOD_EN = uvm_reg_field::type_id::create("TRIG_FORMATMOD_EN");
        TRIG_FORMATMOD = uvm_reg_field::type_id::create("TRIG_FORMATMOD");

        TRIG_FORMATMOD_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_FORMATMOD.configure(this, 4, 0, "RW", 1, 'b000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGFORMATMOD_wr_cg";
        TRIG_FORMATMOD_EN_wr : coverpoint TRIG_FORMATMOD_EN.value[0:0];
        TRIG_FORMATMOD_wr : coverpoint TRIG_FORMATMOD.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGFORMATMOD_rd_cg";
        TRIG_FORMATMOD_EN_rd : coverpoint TRIG_FORMATMOD_EN.value[0:0];
        TRIG_FORMATMOD_rd : coverpoint TRIG_FORMATMOD.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGFORMATMOD");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGMCS
//--------------------------------------------------------------------
class TRIGMCS extends uvm_reg;
    `uvm_object_utils(TRIGMCS)
    rand uvm_reg_field TRIG_MCS_EN;
    rand uvm_reg_field TRIG_MCS;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_MCS_EN = uvm_reg_field::type_id::create("TRIG_MCS_EN");
        TRIG_MCS = uvm_reg_field::type_id::create("TRIG_MCS");

        TRIG_MCS_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_MCS.configure(this, 7, 0, "RW", 1, 'b000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGMCS_wr_cg";
        TRIG_MCS_EN_wr : coverpoint TRIG_MCS_EN.value[0:0];
        TRIG_MCS_wr : coverpoint TRIG_MCS.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGMCS_rd_cg";
        TRIG_MCS_EN_rd : coverpoint TRIG_MCS_EN.value[0:0];
        TRIG_MCS_rd : coverpoint TRIG_MCS.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGMCS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGSGI
//--------------------------------------------------------------------
class TRIGSGI extends uvm_reg;
    `uvm_object_utils(TRIGSGI)
    rand uvm_reg_field TRIG_SGI_EN;
    rand uvm_reg_field TRIG_SGI;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_SGI_EN = uvm_reg_field::type_id::create("TRIG_SGI_EN");
        TRIG_SGI = uvm_reg_field::type_id::create("TRIG_SGI");

        TRIG_SGI_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_SGI.configure(this, 2, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGSGI_wr_cg";
        TRIG_SGI_EN_wr : coverpoint TRIG_SGI_EN.value[0:0];
        TRIG_SGI_wr : coverpoint TRIG_SGI.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGSGI_rd_cg";
        TRIG_SGI_EN_rd : coverpoint TRIG_SGI_EN.value[0:0];
        TRIG_SGI_rd : coverpoint TRIG_SGI.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGSGI");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGFEC
//--------------------------------------------------------------------
class TRIGFEC extends uvm_reg;
    `uvm_object_utils(TRIGFEC)
    rand uvm_reg_field TRIG_FEC_EN;
    rand uvm_reg_field TRIG_FEC;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_FEC_EN = uvm_reg_field::type_id::create("TRIG_FEC_EN");
        TRIG_FEC = uvm_reg_field::type_id::create("TRIG_FEC");

        TRIG_FEC_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_FEC.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGFEC_wr_cg";
        TRIG_FEC_EN_wr : coverpoint TRIG_FEC_EN.value[0:0];
        TRIG_FEC_wr : coverpoint TRIG_FEC.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGFEC_rd_cg";
        TRIG_FEC_EN_rd : coverpoint TRIG_FEC_EN.value[0:0];
        TRIG_FEC_rd : coverpoint TRIG_FEC.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGFEC");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGSTBC
//--------------------------------------------------------------------
class TRIGSTBC extends uvm_reg;
    `uvm_object_utils(TRIGSTBC)
    rand uvm_reg_field TRIG_STBC_EN;
    rand uvm_reg_field TRIG_STBC;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_STBC_EN = uvm_reg_field::type_id::create("TRIG_STBC_EN");
        TRIG_STBC = uvm_reg_field::type_id::create("TRIG_STBC");

        TRIG_STBC_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_STBC.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGSTBC_wr_cg";
        TRIG_STBC_EN_wr : coverpoint TRIG_STBC_EN.value[0:0];
        TRIG_STBC_wr : coverpoint TRIG_STBC.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGSTBC_rd_cg";
        TRIG_STBC_EN_rd : coverpoint TRIG_STBC_EN.value[0:0];
        TRIG_STBC_rd : coverpoint TRIG_STBC.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGSTBC");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGCHBW
//--------------------------------------------------------------------
class TRIGCHBW extends uvm_reg;
    `uvm_object_utils(TRIGCHBW)
    rand uvm_reg_field TRIG_CHBW_EN;
    rand uvm_reg_field TRIG_CHBW;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_CHBW_EN = uvm_reg_field::type_id::create("TRIG_CHBW_EN");
        TRIG_CHBW = uvm_reg_field::type_id::create("TRIG_CHBW");

        TRIG_CHBW_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_CHBW.configure(this, 3, 0, "RW", 1, 'b00, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGCHBW_wr_cg";
        TRIG_CHBW_EN_wr : coverpoint TRIG_CHBW_EN.value[0:0];
        TRIG_CHBW_wr : coverpoint TRIG_CHBW.value[2:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGCHBW_rd_cg";
        TRIG_CHBW_EN_rd : coverpoint TRIG_CHBW_EN.value[0:0];
        TRIG_CHBW_rd : coverpoint TRIG_CHBW.value[2:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGCHBW");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGNSTS
//--------------------------------------------------------------------
class TRIGNSTS extends uvm_reg;
    `uvm_object_utils(TRIGNSTS)
    rand uvm_reg_field TRIG_NSTS_EN;
    rand uvm_reg_field TRIG_NSTS;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_NSTS_EN = uvm_reg_field::type_id::create("TRIG_NSTS_EN");
        TRIG_NSTS = uvm_reg_field::type_id::create("TRIG_NSTS");

        TRIG_NSTS_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_NSTS.configure(this, 3, 0, "RW", 1, 'b00, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGNSTS_wr_cg";
        TRIG_NSTS_EN_wr : coverpoint TRIG_NSTS_EN.value[0:0];
        TRIG_NSTS_wr : coverpoint TRIG_NSTS.value[2:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGNSTS_rd_cg";
        TRIG_NSTS_EN_rd : coverpoint TRIG_NSTS_EN.value[0:0];
        TRIG_NSTS_rd : coverpoint TRIG_NSTS.value[2:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGNSTS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGSOUNDING
//--------------------------------------------------------------------
class TRIGSOUNDING extends uvm_reg;
    `uvm_object_utils(TRIGSOUNDING)
    rand uvm_reg_field TRIG_SOUNDING_EN;
    rand uvm_reg_field TRIG_SOUNDING;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_SOUNDING_EN = uvm_reg_field::type_id::create("TRIG_SOUNDING_EN");
        TRIG_SOUNDING = uvm_reg_field::type_id::create("TRIG_SOUNDING");

        TRIG_SOUNDING_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_SOUNDING.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGSOUNDING_wr_cg";
        TRIG_SOUNDING_EN_wr : coverpoint TRIG_SOUNDING_EN.value[0:0];
        TRIG_SOUNDING_wr : coverpoint TRIG_SOUNDING.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGSOUNDING_rd_cg";
        TRIG_SOUNDING_EN_rd : coverpoint TRIG_SOUNDING_EN.value[0:0];
        TRIG_SOUNDING_rd : coverpoint TRIG_SOUNDING.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGSOUNDING");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGPARTIALAID
//--------------------------------------------------------------------
class TRIGPARTIALAID extends uvm_reg;
    `uvm_object_utils(TRIGPARTIALAID)
    rand uvm_reg_field TRIG_PARTIALAID_EN;
    rand uvm_reg_field TRIG_PARTIALAID;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_PARTIALAID_EN = uvm_reg_field::type_id::create("TRIG_PARTIALAID_EN");
        TRIG_PARTIALAID = uvm_reg_field::type_id::create("TRIG_PARTIALAID");

        TRIG_PARTIALAID_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_PARTIALAID.configure(this, 9, 0, "RW", 1, 'b00000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGPARTIALAID_wr_cg";
        TRIG_PARTIALAID_EN_wr : coverpoint TRIG_PARTIALAID_EN.value[0:0];
        TRIG_PARTIALAID_wr : coverpoint TRIG_PARTIALAID.value[8:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGPARTIALAID_rd_cg";
        TRIG_PARTIALAID_EN_rd : coverpoint TRIG_PARTIALAID_EN.value[0:0];
        TRIG_PARTIALAID_rd : coverpoint TRIG_PARTIALAID.value[8:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGPARTIALAID");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGGROUPID
//--------------------------------------------------------------------
class TRIGGROUPID extends uvm_reg;
    `uvm_object_utils(TRIGGROUPID)
    rand uvm_reg_field TRIG_GROUPID_EN;
    rand uvm_reg_field TRIG_GROUPID;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_GROUPID_EN = uvm_reg_field::type_id::create("TRIG_GROUPID_EN");
        TRIG_GROUPID = uvm_reg_field::type_id::create("TRIG_GROUPID");

        TRIG_GROUPID_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_GROUPID.configure(this, 6, 0, "RW", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGGROUPID_wr_cg";
        TRIG_GROUPID_EN_wr : coverpoint TRIG_GROUPID_EN.value[0:0];
        TRIG_GROUPID_wr : coverpoint TRIG_GROUPID.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGGROUPID_rd_cg";
        TRIG_GROUPID_EN_rd : coverpoint TRIG_GROUPID_EN.value[0:0];
        TRIG_GROUPID_rd : coverpoint TRIG_GROUPID.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGGROUPID");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TRIGSMOOTHING
//--------------------------------------------------------------------
class TRIGSMOOTHING extends uvm_reg;
    `uvm_object_utils(TRIGSMOOTHING)
    rand uvm_reg_field TRIG_SMOOTHING_EN;
    rand uvm_reg_field TRIG_SMOOTHING;

    //---build------------------------------------------------------------
    virtual function void build();
        TRIG_SMOOTHING_EN = uvm_reg_field::type_id::create("TRIG_SMOOTHING_EN");
        TRIG_SMOOTHING = uvm_reg_field::type_id::create("TRIG_SMOOTHING");

        TRIG_SMOOTHING_EN.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        TRIG_SMOOTHING.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGSMOOTHING_wr_cg";
        TRIG_SMOOTHING_EN_wr : coverpoint TRIG_SMOOTHING_EN.value[0:0];
        TRIG_SMOOTHING_wr : coverpoint TRIG_SMOOTHING.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TRIGSMOOTHING_rd_cg";
        TRIG_SMOOTHING_EN_rd : coverpoint TRIG_SMOOTHING_EN.value[0:0];
        TRIG_SMOOTHING_rd : coverpoint TRIG_SMOOTHING.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TRIGSMOOTHING");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV0
//--------------------------------------------------------------------
class TXV0 extends uvm_reg;
    `uvm_object_utils(TXV0)
    rand uvm_reg_field TXV_BYTE0;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE0 = uvm_reg_field::type_id::create("TXV_BYTE0");

        TXV_BYTE0.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV0_wr_cg";
        TXV_BYTE0_wr : coverpoint TXV_BYTE0.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV0_rd_cg";
        TXV_BYTE0_rd : coverpoint TXV_BYTE0.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV1
//--------------------------------------------------------------------
class TXV1 extends uvm_reg;
    `uvm_object_utils(TXV1)
    rand uvm_reg_field TXV_BYTE1;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE1 = uvm_reg_field::type_id::create("TXV_BYTE1");

        TXV_BYTE1.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV1_wr_cg";
        TXV_BYTE1_wr : coverpoint TXV_BYTE1.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV1_rd_cg";
        TXV_BYTE1_rd : coverpoint TXV_BYTE1.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV2
//--------------------------------------------------------------------
class TXV2 extends uvm_reg;
    `uvm_object_utils(TXV2)
    rand uvm_reg_field TXV_BYTE2;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE2 = uvm_reg_field::type_id::create("TXV_BYTE2");

        TXV_BYTE2.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV2_wr_cg";
        TXV_BYTE2_wr : coverpoint TXV_BYTE2.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV2_rd_cg";
        TXV_BYTE2_rd : coverpoint TXV_BYTE2.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV3
//--------------------------------------------------------------------
class TXV3 extends uvm_reg;
    `uvm_object_utils(TXV3)
    rand uvm_reg_field TXV_BYTE3;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE3 = uvm_reg_field::type_id::create("TXV_BYTE3");

        TXV_BYTE3.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV3_wr_cg";
        TXV_BYTE3_wr : coverpoint TXV_BYTE3.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV3_rd_cg";
        TXV_BYTE3_rd : coverpoint TXV_BYTE3.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV4
//--------------------------------------------------------------------
class TXV4 extends uvm_reg;
    `uvm_object_utils(TXV4)
    rand uvm_reg_field TXV_BYTE4;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE4 = uvm_reg_field::type_id::create("TXV_BYTE4");

        TXV_BYTE4.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV4_wr_cg";
        TXV_BYTE4_wr : coverpoint TXV_BYTE4.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV4_rd_cg";
        TXV_BYTE4_rd : coverpoint TXV_BYTE4.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV5
//--------------------------------------------------------------------
class TXV5 extends uvm_reg;
    `uvm_object_utils(TXV5)
    rand uvm_reg_field TXV_BYTE5;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE5 = uvm_reg_field::type_id::create("TXV_BYTE5");

        TXV_BYTE5.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV5_wr_cg";
        TXV_BYTE5_wr : coverpoint TXV_BYTE5.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV5_rd_cg";
        TXV_BYTE5_rd : coverpoint TXV_BYTE5.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV5");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV6
//--------------------------------------------------------------------
class TXV6 extends uvm_reg;
    `uvm_object_utils(TXV6)
    rand uvm_reg_field TXV_BYTE6;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE6 = uvm_reg_field::type_id::create("TXV_BYTE6");

        TXV_BYTE6.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV6_wr_cg";
        TXV_BYTE6_wr : coverpoint TXV_BYTE6.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV6_rd_cg";
        TXV_BYTE6_rd : coverpoint TXV_BYTE6.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV6");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV7
//--------------------------------------------------------------------
class TXV7 extends uvm_reg;
    `uvm_object_utils(TXV7)
    rand uvm_reg_field TXV_BYTE7;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE7 = uvm_reg_field::type_id::create("TXV_BYTE7");

        TXV_BYTE7.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV7_wr_cg";
        TXV_BYTE7_wr : coverpoint TXV_BYTE7.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV7_rd_cg";
        TXV_BYTE7_rd : coverpoint TXV_BYTE7.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV7");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV8
//--------------------------------------------------------------------
class TXV8 extends uvm_reg;
    `uvm_object_utils(TXV8)
    rand uvm_reg_field TXV_BYTE8;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE8 = uvm_reg_field::type_id::create("TXV_BYTE8");

        TXV_BYTE8.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV8_wr_cg";
        TXV_BYTE8_wr : coverpoint TXV_BYTE8.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV8_rd_cg";
        TXV_BYTE8_rd : coverpoint TXV_BYTE8.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV8");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV9
//--------------------------------------------------------------------
class TXV9 extends uvm_reg;
    `uvm_object_utils(TXV9)
    rand uvm_reg_field TXV_BYTE9;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE9 = uvm_reg_field::type_id::create("TXV_BYTE9");

        TXV_BYTE9.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV9_wr_cg";
        TXV_BYTE9_wr : coverpoint TXV_BYTE9.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV9_rd_cg";
        TXV_BYTE9_rd : coverpoint TXV_BYTE9.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV9");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV10
//--------------------------------------------------------------------
class TXV10 extends uvm_reg;
    `uvm_object_utils(TXV10)
    rand uvm_reg_field TXV_BYTE10;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE10 = uvm_reg_field::type_id::create("TXV_BYTE10");

        TXV_BYTE10.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV10_wr_cg";
        TXV_BYTE10_wr : coverpoint TXV_BYTE10.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV10_rd_cg";
        TXV_BYTE10_rd : coverpoint TXV_BYTE10.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV10");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV11
//--------------------------------------------------------------------
class TXV11 extends uvm_reg;
    `uvm_object_utils(TXV11)
    rand uvm_reg_field TXV_BYTE11;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE11 = uvm_reg_field::type_id::create("TXV_BYTE11");

        TXV_BYTE11.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV11_wr_cg";
        TXV_BYTE11_wr : coverpoint TXV_BYTE11.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV11_rd_cg";
        TXV_BYTE11_rd : coverpoint TXV_BYTE11.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV11");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV12
//--------------------------------------------------------------------
class TXV12 extends uvm_reg;
    `uvm_object_utils(TXV12)
    rand uvm_reg_field TXV_BYTE12;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE12 = uvm_reg_field::type_id::create("TXV_BYTE12");

        TXV_BYTE12.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV12_wr_cg";
        TXV_BYTE12_wr : coverpoint TXV_BYTE12.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV12_rd_cg";
        TXV_BYTE12_rd : coverpoint TXV_BYTE12.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV12");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV13
//--------------------------------------------------------------------
class TXV13 extends uvm_reg;
    `uvm_object_utils(TXV13)
    rand uvm_reg_field TXV_BYTE13;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE13 = uvm_reg_field::type_id::create("TXV_BYTE13");

        TXV_BYTE13.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV13_wr_cg";
        TXV_BYTE13_wr : coverpoint TXV_BYTE13.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV13_rd_cg";
        TXV_BYTE13_rd : coverpoint TXV_BYTE13.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV13");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV14
//--------------------------------------------------------------------
class TXV14 extends uvm_reg;
    `uvm_object_utils(TXV14)
    rand uvm_reg_field TXV_BYTE14;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE14 = uvm_reg_field::type_id::create("TXV_BYTE14");

        TXV_BYTE14.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV14_wr_cg";
        TXV_BYTE14_wr : coverpoint TXV_BYTE14.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV14_rd_cg";
        TXV_BYTE14_rd : coverpoint TXV_BYTE14.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV14");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV15
//--------------------------------------------------------------------
class TXV15 extends uvm_reg;
    `uvm_object_utils(TXV15)
    rand uvm_reg_field TXV_BYTE15;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE15 = uvm_reg_field::type_id::create("TXV_BYTE15");

        TXV_BYTE15.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV15_wr_cg";
        TXV_BYTE15_wr : coverpoint TXV_BYTE15.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV15_rd_cg";
        TXV_BYTE15_rd : coverpoint TXV_BYTE15.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV15");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV16
//--------------------------------------------------------------------
class TXV16 extends uvm_reg;
    `uvm_object_utils(TXV16)
    rand uvm_reg_field TXV_BYTE16;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE16 = uvm_reg_field::type_id::create("TXV_BYTE16");

        TXV_BYTE16.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV16_wr_cg";
        TXV_BYTE16_wr : coverpoint TXV_BYTE16.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV16_rd_cg";
        TXV_BYTE16_rd : coverpoint TXV_BYTE16.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV16");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV17
//--------------------------------------------------------------------
class TXV17 extends uvm_reg;
    `uvm_object_utils(TXV17)
    rand uvm_reg_field TXV_BYTE17;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE17 = uvm_reg_field::type_id::create("TXV_BYTE17");

        TXV_BYTE17.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV17_wr_cg";
        TXV_BYTE17_wr : coverpoint TXV_BYTE17.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV17_rd_cg";
        TXV_BYTE17_rd : coverpoint TXV_BYTE17.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV17");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV18
//--------------------------------------------------------------------
class TXV18 extends uvm_reg;
    `uvm_object_utils(TXV18)
    rand uvm_reg_field TXV_BYTE18;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE18 = uvm_reg_field::type_id::create("TXV_BYTE18");

        TXV_BYTE18.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV18_wr_cg";
        TXV_BYTE18_wr : coverpoint TXV_BYTE18.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV18_rd_cg";
        TXV_BYTE18_rd : coverpoint TXV_BYTE18.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV18");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV19
//--------------------------------------------------------------------
class TXV19 extends uvm_reg;
    `uvm_object_utils(TXV19)
    rand uvm_reg_field TXV_BYTE19;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE19 = uvm_reg_field::type_id::create("TXV_BYTE19");

        TXV_BYTE19.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV19_wr_cg";
        TXV_BYTE19_wr : coverpoint TXV_BYTE19.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV19_rd_cg";
        TXV_BYTE19_rd : coverpoint TXV_BYTE19.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV19");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV20
//--------------------------------------------------------------------
class TXV20 extends uvm_reg;
    `uvm_object_utils(TXV20)
    rand uvm_reg_field TXV_BYTE20;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE20 = uvm_reg_field::type_id::create("TXV_BYTE20");

        TXV_BYTE20.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV20_wr_cg";
        TXV_BYTE20_wr : coverpoint TXV_BYTE20.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV20_rd_cg";
        TXV_BYTE20_rd : coverpoint TXV_BYTE20.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV20");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV21
//--------------------------------------------------------------------
class TXV21 extends uvm_reg;
    `uvm_object_utils(TXV21)
    rand uvm_reg_field TXV_BYTE21;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE21 = uvm_reg_field::type_id::create("TXV_BYTE21");

        TXV_BYTE21.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV21_wr_cg";
        TXV_BYTE21_wr : coverpoint TXV_BYTE21.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV21_rd_cg";
        TXV_BYTE21_rd : coverpoint TXV_BYTE21.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV21");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV22
//--------------------------------------------------------------------
class TXV22 extends uvm_reg;
    `uvm_object_utils(TXV22)
    rand uvm_reg_field TXV_BYTE22;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE22 = uvm_reg_field::type_id::create("TXV_BYTE22");

        TXV_BYTE22.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV22_wr_cg";
        TXV_BYTE22_wr : coverpoint TXV_BYTE22.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV22_rd_cg";
        TXV_BYTE22_rd : coverpoint TXV_BYTE22.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV22");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV23
//--------------------------------------------------------------------
class TXV23 extends uvm_reg;
    `uvm_object_utils(TXV23)
    rand uvm_reg_field TXV_BYTE23;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE23 = uvm_reg_field::type_id::create("TXV_BYTE23");

        TXV_BYTE23.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV23_wr_cg";
        TXV_BYTE23_wr : coverpoint TXV_BYTE23.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV23_rd_cg";
        TXV_BYTE23_rd : coverpoint TXV_BYTE23.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV23");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV24
//--------------------------------------------------------------------
class TXV24 extends uvm_reg;
    `uvm_object_utils(TXV24)
    rand uvm_reg_field TXV_BYTE24;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE24 = uvm_reg_field::type_id::create("TXV_BYTE24");

        TXV_BYTE24.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV24_wr_cg";
        TXV_BYTE24_wr : coverpoint TXV_BYTE24.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV24_rd_cg";
        TXV_BYTE24_rd : coverpoint TXV_BYTE24.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV24");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXV25
//--------------------------------------------------------------------
class TXV25 extends uvm_reg;
    `uvm_object_utils(TXV25)
    rand uvm_reg_field TXV_BYTE25;

    //---build------------------------------------------------------------
    virtual function void build();
        TXV_BYTE25 = uvm_reg_field::type_id::create("TXV_BYTE25");

        TXV_BYTE25.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV25_wr_cg";
        TXV_BYTE25_wr : coverpoint TXV_BYTE25.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_TXV25_rd_cg";
        TXV_BYTE25_rd : coverpoint TXV_BYTE25.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXV25");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// VERSION
//--------------------------------------------------------------------
class VERSION extends uvm_reg;
    `uvm_object_utils(VERSION)
    rand uvm_reg_field VERSION;

    //---build------------------------------------------------------------
    virtual function void build();
        VERSION = uvm_reg_field::type_id::create("VERSION");

        VERSION.configure(this, 32, 0, "RO", 1, 'b0000000000000010000000000000011, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACBYPASS_VERSION_rd_cg";
        VERSION_rd : coverpoint VERSION.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "VERSION");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class MACBYPASS_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(MACBYPASS_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins CTRL              = {'h0};
        bins PAYLOAD              = {'h4};
        bins TRIGGER              = {'h8};
        bins CLKEN              = {'hC};
        bins FRAMEPERBURST              = {'h10};
        bins INTERFRAME_DELAY              = {'h48};
        bins STAT_FRAME_OK              = {'h80};
        bins STAT_FRAME_BAD              = {'h84};
        bins STAT_RXEND              = {'h88};
        bins STAT_RXERROR              = {'h8C};
        bins STAT_EVM              = {'h90};
        bins STAT_RSSI              = {'h94};
        bins STAT_PHYERR              = {'h98};
        bins INT_CTRL              = {'hA0};
        bins INT_GENERATION              = {'hA4};
        bins INT_STAT_RAW              = {'hA8};
        bins INT_STAT_ACK              = {'hAC};
        bins INT_RXV0              = {'hB0};
        bins INT_RXV4              = {'hB4};
        bins INT_RXV8              = {'hB8};
        bins RXV12              = {'hBC};
        bins TRIGFORMATMOD              = {'h100};
        bins TRIGMCS              = {'h104};
        bins TRIGSGI              = {'h108};
        bins TRIGFEC              = {'h10C};
        bins TRIGSTBC              = {'h110};
        bins TRIGCHBW              = {'h114};
        bins TRIGNSTS              = {'h118};
        bins TRIGSOUNDING              = {'h11C};
        bins TRIGPARTIALAID              = {'h120};
        bins TRIGGROUPID              = {'h124};
        bins TRIGSMOOTHING              = {'h128};
        bins TXV0              = {'h200};
        bins TXV1              = {'h204};
        bins TXV2              = {'h208};
        bins TXV3              = {'h20C};
        bins TXV4              = {'h210};
        bins TXV5              = {'h214};
        bins TXV6              = {'h218};
        bins TXV7              = {'h21C};
        bins TXV8              = {'h220};
        bins TXV9              = {'h224};
        bins TXV10              = {'h228};
        bins TXV11              = {'h22C};
        bins TXV12              = {'h230};
        bins TXV13              = {'h234};
        bins TXV14              = {'h238};
        bins TXV15              = {'h23C};
        bins TXV16              = {'h240};
        bins TXV17              = {'h244};
        bins TXV18              = {'h248};
        bins TXV19              = {'h24C};
        bins TXV20              = {'h250};
        bins TXV21              = {'h254};
        bins TXV22              = {'h258};
        bins TXV23              = {'h25C};
        bins TXV24              = {'h260};
        bins TXV25              = {'h264};
        bins VERSION              = {'h424};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "MACBYPASS_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: MACBYPASS_reg_access_wrapper

//-------------------------------------------------------------------
// MACBYPASS_register_block
//--------------------------------------------------------------------
class MACBYPASS_register_block extends uvm_reg_block;
    `uvm_object_utils(MACBYPASS_register_block)

    rand CTRL CTRL_reg;
    rand PAYLOAD PAYLOAD_reg;
    rand TRIGGER TRIGGER_reg;
    rand CLKEN CLKEN_reg;
    rand FRAMEPERBURST FRAMEPERBURST_reg;
    rand INTERFRAME_DELAY INTERFRAME_DELAY_reg;
    rand STAT_FRAME_OK STAT_FRAME_OK_reg;
    rand STAT_FRAME_BAD STAT_FRAME_BAD_reg;
    rand STAT_RXEND STAT_RXEND_reg;
    rand STAT_RXERROR STAT_RXERROR_reg;
    rand STAT_EVM STAT_EVM_reg;
    rand STAT_RSSI STAT_RSSI_reg;
    rand STAT_PHYERR STAT_PHYERR_reg;
    rand INT_CTRL INT_CTRL_reg;
    rand INT_GENERATION INT_GENERATION_reg;
    rand INT_STAT_RAW INT_STAT_RAW_reg;
    rand INT_STAT_ACK INT_STAT_ACK_reg;
    rand INT_RXV0 INT_RXV0_reg;
    rand INT_RXV4 INT_RXV4_reg;
    rand INT_RXV8 INT_RXV8_reg;
    rand RXV12 RXV12_reg;
    rand TRIGFORMATMOD TRIGFORMATMOD_reg;
    rand TRIGMCS TRIGMCS_reg;
    rand TRIGSGI TRIGSGI_reg;
    rand TRIGFEC TRIGFEC_reg;
    rand TRIGSTBC TRIGSTBC_reg;
    rand TRIGCHBW TRIGCHBW_reg;
    rand TRIGNSTS TRIGNSTS_reg;
    rand TRIGSOUNDING TRIGSOUNDING_reg;
    rand TRIGPARTIALAID TRIGPARTIALAID_reg;
    rand TRIGGROUPID TRIGGROUPID_reg;
    rand TRIGSMOOTHING TRIGSMOOTHING_reg;
    rand TXV0 TXV0_reg;
    rand TXV1 TXV1_reg;
    rand TXV2 TXV2_reg;
    rand TXV3 TXV3_reg;
    rand TXV4 TXV4_reg;
    rand TXV5 TXV5_reg;
    rand TXV6 TXV6_reg;
    rand TXV7 TXV7_reg;
    rand TXV8 TXV8_reg;
    rand TXV9 TXV9_reg;
    rand TXV10 TXV10_reg;
    rand TXV11 TXV11_reg;
    rand TXV12 TXV12_reg;
    rand TXV13 TXV13_reg;
    rand TXV14 TXV14_reg;
    rand TXV15 TXV15_reg;
    rand TXV16 TXV16_reg;
    rand TXV17 TXV17_reg;
    rand TXV18 TXV18_reg;
    rand TXV19 TXV19_reg;
    rand TXV20 TXV20_reg;
    rand TXV21 TXV21_reg;
    rand TXV22 TXV22_reg;
    rand TXV23 TXV23_reg;
    rand TXV24 TXV24_reg;
    rand TXV25 TXV25_reg;
    rand VERSION VERSION_reg;

    uvm_reg_map MACBYPASS_register_map; // Block map
    MACBYPASS_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "MACBYPASS_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = MACBYPASS_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        CTRL_reg = CTRL::type_id::create("CTRL");
        CTRL_reg.configure(this);
        CTRL_reg.build();

        PAYLOAD_reg = PAYLOAD::type_id::create("PAYLOAD");
        PAYLOAD_reg.configure(this);
        PAYLOAD_reg.build();

        TRIGGER_reg = TRIGGER::type_id::create("TRIGGER");
        TRIGGER_reg.configure(this);
        TRIGGER_reg.build();

        CLKEN_reg = CLKEN::type_id::create("CLKEN");
        CLKEN_reg.configure(this);
        CLKEN_reg.build();

        FRAMEPERBURST_reg = FRAMEPERBURST::type_id::create("FRAMEPERBURST");
        FRAMEPERBURST_reg.configure(this);
        FRAMEPERBURST_reg.build();

        INTERFRAME_DELAY_reg = INTERFRAME_DELAY::type_id::create("INTERFRAME_DELAY");
        INTERFRAME_DELAY_reg.configure(this);
        INTERFRAME_DELAY_reg.build();

        STAT_FRAME_OK_reg = STAT_FRAME_OK::type_id::create("STAT_FRAME_OK");
        STAT_FRAME_OK_reg.configure(this);
        STAT_FRAME_OK_reg.build();

        STAT_FRAME_BAD_reg = STAT_FRAME_BAD::type_id::create("STAT_FRAME_BAD");
        STAT_FRAME_BAD_reg.configure(this);
        STAT_FRAME_BAD_reg.build();

        STAT_RXEND_reg = STAT_RXEND::type_id::create("STAT_RXEND");
        STAT_RXEND_reg.configure(this);
        STAT_RXEND_reg.build();

        STAT_RXERROR_reg = STAT_RXERROR::type_id::create("STAT_RXERROR");
        STAT_RXERROR_reg.configure(this);
        STAT_RXERROR_reg.build();

        STAT_EVM_reg = STAT_EVM::type_id::create("STAT_EVM");
        STAT_EVM_reg.configure(this);
        STAT_EVM_reg.build();

        STAT_RSSI_reg = STAT_RSSI::type_id::create("STAT_RSSI");
        STAT_RSSI_reg.configure(this);
        STAT_RSSI_reg.build();

        STAT_PHYERR_reg = STAT_PHYERR::type_id::create("STAT_PHYERR");
        STAT_PHYERR_reg.configure(this);
        STAT_PHYERR_reg.build();

        INT_CTRL_reg = INT_CTRL::type_id::create("INT_CTRL");
        INT_CTRL_reg.configure(this);
        INT_CTRL_reg.build();

        INT_GENERATION_reg = INT_GENERATION::type_id::create("INT_GENERATION");
        INT_GENERATION_reg.configure(this);
        INT_GENERATION_reg.build();

        INT_STAT_RAW_reg = INT_STAT_RAW::type_id::create("INT_STAT_RAW");
        INT_STAT_RAW_reg.configure(this);
        INT_STAT_RAW_reg.build();

        INT_STAT_ACK_reg = INT_STAT_ACK::type_id::create("INT_STAT_ACK");
        INT_STAT_ACK_reg.configure(this);
        INT_STAT_ACK_reg.build();

        INT_RXV0_reg = INT_RXV0::type_id::create("INT_RXV0");
        INT_RXV0_reg.configure(this);
        INT_RXV0_reg.build();

        INT_RXV4_reg = INT_RXV4::type_id::create("INT_RXV4");
        INT_RXV4_reg.configure(this);
        INT_RXV4_reg.build();

        INT_RXV8_reg = INT_RXV8::type_id::create("INT_RXV8");
        INT_RXV8_reg.configure(this);
        INT_RXV8_reg.build();

        RXV12_reg = RXV12::type_id::create("RXV12");
        RXV12_reg.configure(this);
        RXV12_reg.build();

        TRIGFORMATMOD_reg = TRIGFORMATMOD::type_id::create("TRIGFORMATMOD");
        TRIGFORMATMOD_reg.configure(this);
        TRIGFORMATMOD_reg.build();

        TRIGMCS_reg = TRIGMCS::type_id::create("TRIGMCS");
        TRIGMCS_reg.configure(this);
        TRIGMCS_reg.build();

        TRIGSGI_reg = TRIGSGI::type_id::create("TRIGSGI");
        TRIGSGI_reg.configure(this);
        TRIGSGI_reg.build();

        TRIGFEC_reg = TRIGFEC::type_id::create("TRIGFEC");
        TRIGFEC_reg.configure(this);
        TRIGFEC_reg.build();

        TRIGSTBC_reg = TRIGSTBC::type_id::create("TRIGSTBC");
        TRIGSTBC_reg.configure(this);
        TRIGSTBC_reg.build();

        TRIGCHBW_reg = TRIGCHBW::type_id::create("TRIGCHBW");
        TRIGCHBW_reg.configure(this);
        TRIGCHBW_reg.build();

        TRIGNSTS_reg = TRIGNSTS::type_id::create("TRIGNSTS");
        TRIGNSTS_reg.configure(this);
        TRIGNSTS_reg.build();

        TRIGSOUNDING_reg = TRIGSOUNDING::type_id::create("TRIGSOUNDING");
        TRIGSOUNDING_reg.configure(this);
        TRIGSOUNDING_reg.build();

        TRIGPARTIALAID_reg = TRIGPARTIALAID::type_id::create("TRIGPARTIALAID");
        TRIGPARTIALAID_reg.configure(this);
        TRIGPARTIALAID_reg.build();

        TRIGGROUPID_reg = TRIGGROUPID::type_id::create("TRIGGROUPID");
        TRIGGROUPID_reg.configure(this);
        TRIGGROUPID_reg.build();

        TRIGSMOOTHING_reg = TRIGSMOOTHING::type_id::create("TRIGSMOOTHING");
        TRIGSMOOTHING_reg.configure(this);
        TRIGSMOOTHING_reg.build();

        TXV0_reg = TXV0::type_id::create("TXV0");
        TXV0_reg.configure(this);
        TXV0_reg.build();

        TXV1_reg = TXV1::type_id::create("TXV1");
        TXV1_reg.configure(this);
        TXV1_reg.build();

        TXV2_reg = TXV2::type_id::create("TXV2");
        TXV2_reg.configure(this);
        TXV2_reg.build();

        TXV3_reg = TXV3::type_id::create("TXV3");
        TXV3_reg.configure(this);
        TXV3_reg.build();

        TXV4_reg = TXV4::type_id::create("TXV4");
        TXV4_reg.configure(this);
        TXV4_reg.build();

        TXV5_reg = TXV5::type_id::create("TXV5");
        TXV5_reg.configure(this);
        TXV5_reg.build();

        TXV6_reg = TXV6::type_id::create("TXV6");
        TXV6_reg.configure(this);
        TXV6_reg.build();

        TXV7_reg = TXV7::type_id::create("TXV7");
        TXV7_reg.configure(this);
        TXV7_reg.build();

        TXV8_reg = TXV8::type_id::create("TXV8");
        TXV8_reg.configure(this);
        TXV8_reg.build();

        TXV9_reg = TXV9::type_id::create("TXV9");
        TXV9_reg.configure(this);
        TXV9_reg.build();

        TXV10_reg = TXV10::type_id::create("TXV10");
        TXV10_reg.configure(this);
        TXV10_reg.build();

        TXV11_reg = TXV11::type_id::create("TXV11");
        TXV11_reg.configure(this);
        TXV11_reg.build();

        TXV12_reg = TXV12::type_id::create("TXV12");
        TXV12_reg.configure(this);
        TXV12_reg.build();

        TXV13_reg = TXV13::type_id::create("TXV13");
        TXV13_reg.configure(this);
        TXV13_reg.build();

        TXV14_reg = TXV14::type_id::create("TXV14");
        TXV14_reg.configure(this);
        TXV14_reg.build();

        TXV15_reg = TXV15::type_id::create("TXV15");
        TXV15_reg.configure(this);
        TXV15_reg.build();

        TXV16_reg = TXV16::type_id::create("TXV16");
        TXV16_reg.configure(this);
        TXV16_reg.build();

        TXV17_reg = TXV17::type_id::create("TXV17");
        TXV17_reg.configure(this);
        TXV17_reg.build();

        TXV18_reg = TXV18::type_id::create("TXV18");
        TXV18_reg.configure(this);
        TXV18_reg.build();

        TXV19_reg = TXV19::type_id::create("TXV19");
        TXV19_reg.configure(this);
        TXV19_reg.build();

        TXV20_reg = TXV20::type_id::create("TXV20");
        TXV20_reg.configure(this);
        TXV20_reg.build();

        TXV21_reg = TXV21::type_id::create("TXV21");
        TXV21_reg.configure(this);
        TXV21_reg.build();

        TXV22_reg = TXV22::type_id::create("TXV22");
        TXV22_reg.configure(this);
        TXV22_reg.build();

        TXV23_reg = TXV23::type_id::create("TXV23");
        TXV23_reg.configure(this);
        TXV23_reg.build();

        TXV24_reg = TXV24::type_id::create("TXV24");
        TXV24_reg.configure(this);
        TXV24_reg.build();

        TXV25_reg = TXV25::type_id::create("TXV25");
        TXV25_reg.configure(this);
        TXV25_reg.build();

        VERSION_reg = VERSION::type_id::create("VERSION");
        VERSION_reg.configure(this);
        VERSION_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        MACBYPASS_register_map = create_map("MACBYPASS_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        MACBYPASS_register_map.add_reg(CTRL_reg, 'h0, "RW");
        MACBYPASS_register_map.add_reg(PAYLOAD_reg, 'h4, "RW");
        MACBYPASS_register_map.add_reg(TRIGGER_reg, 'h8, "RW");
        MACBYPASS_register_map.add_reg(CLKEN_reg, 'hC, "RW");
        MACBYPASS_register_map.add_reg(FRAMEPERBURST_reg, 'h10, "RW");
        MACBYPASS_register_map.add_reg(INTERFRAME_DELAY_reg, 'h48, "RW");
        MACBYPASS_register_map.add_reg(STAT_FRAME_OK_reg, 'h80, "RO");
        MACBYPASS_register_map.add_reg(STAT_FRAME_BAD_reg, 'h84, "RO");
        MACBYPASS_register_map.add_reg(STAT_RXEND_reg, 'h88, "RO");
        MACBYPASS_register_map.add_reg(STAT_RXERROR_reg, 'h8C, "RO");
        MACBYPASS_register_map.add_reg(STAT_EVM_reg, 'h90, "RO");
        MACBYPASS_register_map.add_reg(STAT_RSSI_reg, 'h94, "RO");
        MACBYPASS_register_map.add_reg(STAT_PHYERR_reg, 'h98, "RW");
        MACBYPASS_register_map.add_reg(INT_CTRL_reg, 'hA0, "RW");
        MACBYPASS_register_map.add_reg(INT_GENERATION_reg, 'hA4, "RW");
        MACBYPASS_register_map.add_reg(INT_STAT_RAW_reg, 'hA8, "RO");
        MACBYPASS_register_map.add_reg(INT_STAT_ACK_reg, 'hAC, "RW");
        MACBYPASS_register_map.add_reg(INT_RXV0_reg, 'hB0, "RO");
        MACBYPASS_register_map.add_reg(INT_RXV4_reg, 'hB4, "RO");
        MACBYPASS_register_map.add_reg(INT_RXV8_reg, 'hB8, "RO");
        MACBYPASS_register_map.add_reg(RXV12_reg, 'hBC, "RO");
        MACBYPASS_register_map.add_reg(TRIGFORMATMOD_reg, 'h100, "RW");
        MACBYPASS_register_map.add_reg(TRIGMCS_reg, 'h104, "RW");
        MACBYPASS_register_map.add_reg(TRIGSGI_reg, 'h108, "RW");
        MACBYPASS_register_map.add_reg(TRIGFEC_reg, 'h10C, "RW");
        MACBYPASS_register_map.add_reg(TRIGSTBC_reg, 'h110, "RW");
        MACBYPASS_register_map.add_reg(TRIGCHBW_reg, 'h114, "RW");
        MACBYPASS_register_map.add_reg(TRIGNSTS_reg, 'h118, "RW");
        MACBYPASS_register_map.add_reg(TRIGSOUNDING_reg, 'h11C, "RW");
        MACBYPASS_register_map.add_reg(TRIGPARTIALAID_reg, 'h120, "RW");
        MACBYPASS_register_map.add_reg(TRIGGROUPID_reg, 'h124, "RW");
        MACBYPASS_register_map.add_reg(TRIGSMOOTHING_reg, 'h128, "RW");
        MACBYPASS_register_map.add_reg(TXV0_reg, 'h200, "RW");
        MACBYPASS_register_map.add_reg(TXV1_reg, 'h204, "RW");
        MACBYPASS_register_map.add_reg(TXV2_reg, 'h208, "RW");
        MACBYPASS_register_map.add_reg(TXV3_reg, 'h20C, "RW");
        MACBYPASS_register_map.add_reg(TXV4_reg, 'h210, "RW");
        MACBYPASS_register_map.add_reg(TXV5_reg, 'h214, "RW");
        MACBYPASS_register_map.add_reg(TXV6_reg, 'h218, "RW");
        MACBYPASS_register_map.add_reg(TXV7_reg, 'h21C, "RW");
        MACBYPASS_register_map.add_reg(TXV8_reg, 'h220, "RW");
        MACBYPASS_register_map.add_reg(TXV9_reg, 'h224, "RW");
        MACBYPASS_register_map.add_reg(TXV10_reg, 'h228, "RW");
        MACBYPASS_register_map.add_reg(TXV11_reg, 'h22C, "RW");
        MACBYPASS_register_map.add_reg(TXV12_reg, 'h230, "RW");
        MACBYPASS_register_map.add_reg(TXV13_reg, 'h234, "RW");
        MACBYPASS_register_map.add_reg(TXV14_reg, 'h238, "RW");
        MACBYPASS_register_map.add_reg(TXV15_reg, 'h23C, "RW");
        MACBYPASS_register_map.add_reg(TXV16_reg, 'h240, "RW");
        MACBYPASS_register_map.add_reg(TXV17_reg, 'h244, "RW");
        MACBYPASS_register_map.add_reg(TXV18_reg, 'h248, "RW");
        MACBYPASS_register_map.add_reg(TXV19_reg, 'h24C, "RW");
        MACBYPASS_register_map.add_reg(TXV20_reg, 'h250, "RW");
        MACBYPASS_register_map.add_reg(TXV21_reg, 'h254, "RW");
        MACBYPASS_register_map.add_reg(TXV22_reg, 'h258, "RW");
        MACBYPASS_register_map.add_reg(TXV23_reg, 'h25C, "RW");
        MACBYPASS_register_map.add_reg(TXV24_reg, 'h260, "RW");
        MACBYPASS_register_map.add_reg(TXV25_reg, 'h264, "RW");
        MACBYPASS_register_map.add_reg(VERSION_reg, 'h424, "RO");

        // Lock the register model and build the map
        lock_model();
        MACBYPASS_register_map.set_check_on_read();
    endfunction

endclass
`endif // __MACBYPASS_REG_BLOCK_SV__
