//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for MACCORE
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __MACCORE_REG_BLOCK_SV__
`define __MACCORE_REG_BLOCK_SV__

//--------------------------------------------------------------------
// SIGNATUREREG
//--------------------------------------------------------------------
class SIGNATUREREG extends uvm_reg;
    `uvm_object_utils(SIGNATUREREG)
    rand uvm_reg_field signature;

    //---build------------------------------------------------------------
    virtual function void build();
        signature = uvm_reg_field::type_id::create("signature");

        signature.configure(this, 32, 0, "RO", 1, `MACHW_SIGNATURE, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_SIGNATUREREG_rd_cg";
        signature_rd : coverpoint signature.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SIGNATUREREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// VERSION1REG
//--------------------------------------------------------------------
class VERSION1REG extends uvm_reg;
    `uvm_object_utils(VERSION1REG)
    rand uvm_reg_field muMIMOTx;
    rand uvm_reg_field bfmer;
    rand uvm_reg_field bfmee;
    rand uvm_reg_field he;
    rand uvm_reg_field coex;
    rand uvm_reg_field wapi;
    rand uvm_reg_field tpc;
    rand uvm_reg_field vht;
    rand uvm_reg_field ht;
    rand uvm_reg_field gcmp;
    rand uvm_reg_field rce;
    rand uvm_reg_field ccmp;
    rand uvm_reg_field tkip;
    rand uvm_reg_field wep;
    rand uvm_reg_field security;
    rand uvm_reg_field sme;
    rand uvm_reg_field edca;
    rand uvm_reg_field qos;

    //---build------------------------------------------------------------
    virtual function void build();
        muMIMOTx = uvm_reg_field::type_id::create("muMIMOTx");
        bfmer = uvm_reg_field::type_id::create("bfmer");
        bfmee = uvm_reg_field::type_id::create("bfmee");
        he = uvm_reg_field::type_id::create("he");
        coex = uvm_reg_field::type_id::create("coex");
        wapi = uvm_reg_field::type_id::create("wapi");
        tpc = uvm_reg_field::type_id::create("tpc");
        vht = uvm_reg_field::type_id::create("vht");
        ht = uvm_reg_field::type_id::create("ht");
        gcmp = uvm_reg_field::type_id::create("gcmp");
        rce = uvm_reg_field::type_id::create("rce");
        ccmp = uvm_reg_field::type_id::create("ccmp");
        tkip = uvm_reg_field::type_id::create("tkip");
        wep = uvm_reg_field::type_id::create("wep");
        security = uvm_reg_field::type_id::create("security");
        sme = uvm_reg_field::type_id::create("sme");
        edca = uvm_reg_field::type_id::create("edca");
        qos = uvm_reg_field::type_id::create("qos");

        muMIMOTx.configure(this, 1, 19, "RO", 1, `MACHW_MUMIMOTX, 1, 1, 1);
        bfmer.configure(this, 1, 18, "RO", 1, `MACHW_BFMER, 1, 1, 1);
        bfmee.configure(this, 1, 17, "RO", 1, `MACHW_BFMEE, 1, 1, 1);
        he.configure(this, 1, 15, "RO", 1, 'b1, 1, 1, 1);
        coex.configure(this, 1, 14, "RO", 1, `MACHW_COEX, 1, 1, 1);
        wapi.configure(this, 1, 13, "RO", 1, `MACHW_WAPI, 1, 1, 1);
        tpc.configure(this, 1, 12, "RO", 1, 'b1, 1, 1, 1);
        vht.configure(this, 1, 11, "RO", 1, 'b1, 1, 1, 1);
        ht.configure(this, 1, 10, "RO", 1, 'b1, 1, 1, 1);
        gcmp.configure(this, 1, 9, "RO", 1, `MACHW_GCMP, 1, 1, 1);
        rce.configure(this, 1, 8, "RO", 1, `MACHW_RCE, 1, 1, 1);
        ccmp.configure(this, 1, 7, "RO", 1, `MACHW_CCMP, 1, 1, 1);
        tkip.configure(this, 1, 6, "RO", 1, `MACHW_TKIP, 1, 1, 1);
        wep.configure(this, 1, 5, "RO", 1, `MACHW_WEP, 1, 1, 1);
        security.configure(this, 1, 4, "RO", 1, `MACHW_SECURITY, 1, 1, 1);
        sme.configure(this, 1, 3, "RO", 1, `MACHW_SME, 1, 1, 1);
        edca.configure(this, 1, 1, "RO", 1, 'b1, 1, 1, 1);
        qos.configure(this, 1, 0, "RO", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_VERSION1REG_rd_cg";
        muMIMOTx_rd : coverpoint muMIMOTx.value[0:0];
        bfmer_rd : coverpoint bfmer.value[0:0];
        bfmee_rd : coverpoint bfmee.value[0:0];
        he_rd : coverpoint he.value[0:0];
        coex_rd : coverpoint coex.value[0:0];
        wapi_rd : coverpoint wapi.value[0:0];
        tpc_rd : coverpoint tpc.value[0:0];
        vht_rd : coverpoint vht.value[0:0];
        ht_rd : coverpoint ht.value[0:0];
        gcmp_rd : coverpoint gcmp.value[0:0];
        rce_rd : coverpoint rce.value[0:0];
        ccmp_rd : coverpoint ccmp.value[0:0];
        tkip_rd : coverpoint tkip.value[0:0];
        wep_rd : coverpoint wep.value[0:0];
        security_rd : coverpoint security.value[0:0];
        sme_rd : coverpoint sme.value[0:0];
        edca_rd : coverpoint edca.value[0:0];
        qos_rd : coverpoint qos.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "VERSION1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// VERSION2REG
//--------------------------------------------------------------------
class VERSION2REG extends uvm_reg;
    `uvm_object_utils(VERSION2REG)
    rand uvm_reg_field phaseNumber;
    rand uvm_reg_field releaseNumber;
    rand uvm_reg_field ieRelease;
    rand uvm_reg_field umVersion;

    //---build------------------------------------------------------------
    virtual function void build();
        phaseNumber = uvm_reg_field::type_id::create("phaseNumber");
        releaseNumber = uvm_reg_field::type_id::create("releaseNumber");
        ieRelease = uvm_reg_field::type_id::create("ieRelease");
        umVersion = uvm_reg_field::type_id::create("umVersion");

        phaseNumber.configure(this, 3, 14, "RO", 1, `MACHW_PHASENUMBER, 1, 1, 1);
        releaseNumber.configure(this, 6, 8, "RO", 1, `MACHW_RELEASENUMBER, 1, 1, 1);
        ieRelease.configure(this, 1, 7, "RO", 1, `MACHW_IERELEASE, 1, 1, 1);
        umVersion.configure(this, 7, 0, "RO", 1, `MACHW_UMVERSION, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_VERSION2REG_rd_cg";
        phaseNumber_rd : coverpoint phaseNumber.value[2:0];
        releaseNumber_rd : coverpoint releaseNumber.value[5:0];
        ieRelease_rd : coverpoint ieRelease.value[0:0];
        umVersion_rd : coverpoint umVersion.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "VERSION2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BITMAPCNTREG
//--------------------------------------------------------------------
class BITMAPCNTREG extends uvm_reg;
    `uvm_object_utils(BITMAPCNTREG)
    rand uvm_reg_field bitmapCnt;

    //---build------------------------------------------------------------
    virtual function void build();
        bitmapCnt = uvm_reg_field::type_id::create("bitmapCnt");

        bitmapCnt.configure(this, 16, 0, "RO", 1, `MACHW_BITMAPCNT, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_BITMAPCNTREG_rd_cg";
        bitmapCnt_rd : coverpoint bitmapCnt.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BITMAPCNTREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MACADDRLOWREG
//--------------------------------------------------------------------
class MACADDRLOWREG extends uvm_reg;
    `uvm_object_utils(MACADDRLOWREG)
    rand uvm_reg_field macAddrLow;

    //---build------------------------------------------------------------
    virtual function void build();
        macAddrLow = uvm_reg_field::type_id::create("macAddrLow");

        macAddrLow.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MACADDRLOWREG_wr_cg";
        macAddrLow_wr : coverpoint macAddrLow.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MACADDRLOWREG_rd_cg";
        macAddrLow_rd : coverpoint macAddrLow.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MACADDRLOWREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MACADDRHIREG
//--------------------------------------------------------------------
class MACADDRHIREG extends uvm_reg;
    `uvm_object_utils(MACADDRHIREG)
    rand uvm_reg_field macAddrHigh;

    //---build------------------------------------------------------------
    virtual function void build();
        macAddrHigh = uvm_reg_field::type_id::create("macAddrHigh");

        macAddrHigh.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MACADDRHIREG_wr_cg";
        macAddrHigh_wr : coverpoint macAddrHigh.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MACADDRHIREG_rd_cg";
        macAddrHigh_rd : coverpoint macAddrHigh.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MACADDRHIREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MACADDRLOWMASKREG
//--------------------------------------------------------------------
class MACADDRLOWMASKREG extends uvm_reg;
    `uvm_object_utils(MACADDRLOWMASKREG)
    rand uvm_reg_field macAddrLowMask;

    //---build------------------------------------------------------------
    virtual function void build();
        macAddrLowMask = uvm_reg_field::type_id::create("macAddrLowMask");

        macAddrLowMask.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MACADDRLOWMASKREG_wr_cg";
        macAddrLowMask_wr : coverpoint macAddrLowMask.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MACADDRLOWMASKREG_rd_cg";
        macAddrLowMask_rd : coverpoint macAddrLowMask.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MACADDRLOWMASKREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MACADDRHIMASKREG
//--------------------------------------------------------------------
class MACADDRHIMASKREG extends uvm_reg;
    `uvm_object_utils(MACADDRHIMASKREG)
    rand uvm_reg_field macAddrHighMask;

    //---build------------------------------------------------------------
    virtual function void build();
        macAddrHighMask = uvm_reg_field::type_id::create("macAddrHighMask");

        macAddrHighMask.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MACADDRHIMASKREG_wr_cg";
        macAddrHighMask_wr : coverpoint macAddrHighMask.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MACADDRHIMASKREG_rd_cg";
        macAddrHighMask_rd : coverpoint macAddrHighMask.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MACADDRHIMASKREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BSSIDLOWREG
//--------------------------------------------------------------------
class BSSIDLOWREG extends uvm_reg;
    `uvm_object_utils(BSSIDLOWREG)
    rand uvm_reg_field bssIDLow;

    //---build------------------------------------------------------------
    virtual function void build();
        bssIDLow = uvm_reg_field::type_id::create("bssIDLow");

        bssIDLow.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_BSSIDLOWREG_wr_cg";
        bssIDLow_wr : coverpoint bssIDLow.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_BSSIDLOWREG_rd_cg";
        bssIDLow_rd : coverpoint bssIDLow.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BSSIDLOWREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BSSIDHIREG
//--------------------------------------------------------------------
class BSSIDHIREG extends uvm_reg;
    `uvm_object_utils(BSSIDHIREG)
    rand uvm_reg_field bssIDHigh;

    //---build------------------------------------------------------------
    virtual function void build();
        bssIDHigh = uvm_reg_field::type_id::create("bssIDHigh");

        bssIDHigh.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_BSSIDHIREG_wr_cg";
        bssIDHigh_wr : coverpoint bssIDHigh.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_BSSIDHIREG_rd_cg";
        bssIDHigh_rd : coverpoint bssIDHigh.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BSSIDHIREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BSSIDLOWMASKREG
//--------------------------------------------------------------------
class BSSIDLOWMASKREG extends uvm_reg;
    `uvm_object_utils(BSSIDLOWMASKREG)
    rand uvm_reg_field bssIDLowMask;

    //---build------------------------------------------------------------
    virtual function void build();
        bssIDLowMask = uvm_reg_field::type_id::create("bssIDLowMask");

        bssIDLowMask.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_BSSIDLOWMASKREG_wr_cg";
        bssIDLowMask_wr : coverpoint bssIDLowMask.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_BSSIDLOWMASKREG_rd_cg";
        bssIDLowMask_rd : coverpoint bssIDLowMask.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BSSIDLOWMASKREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BSSIDHIMASKREG
//--------------------------------------------------------------------
class BSSIDHIMASKREG extends uvm_reg;
    `uvm_object_utils(BSSIDHIMASKREG)
    rand uvm_reg_field bssIDHighMask;

    //---build------------------------------------------------------------
    virtual function void build();
        bssIDHighMask = uvm_reg_field::type_id::create("bssIDHighMask");

        bssIDHighMask.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_BSSIDHIMASKREG_wr_cg";
        bssIDHighMask_wr : coverpoint bssIDHighMask.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_BSSIDHIMASKREG_rd_cg";
        bssIDHighMask_rd : coverpoint bssIDHighMask.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BSSIDHIMASKREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BSSCOLORREG
//--------------------------------------------------------------------
class BSSCOLORREG extends uvm_reg;
    `uvm_object_utils(BSSCOLORREG)
    rand uvm_reg_field partialBSSColorEn;
    rand uvm_reg_field bssColorEn;
    rand uvm_reg_field bssColor;

    //---build------------------------------------------------------------
    virtual function void build();
        partialBSSColorEn = uvm_reg_field::type_id::create("partialBSSColorEn");
        bssColorEn = uvm_reg_field::type_id::create("bssColorEn");
        bssColor = uvm_reg_field::type_id::create("bssColor");

        partialBSSColorEn.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        bssColorEn.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        bssColor.configure(this, 6, 0, "RW", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_BSSCOLORREG_wr_cg";
        partialBSSColorEn_wr : coverpoint partialBSSColorEn.value[0:0];
        bssColorEn_wr : coverpoint bssColorEn.value[0:0];
        bssColor_wr : coverpoint bssColor.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_BSSCOLORREG_rd_cg";
        partialBSSColorEn_rd : coverpoint partialBSSColorEn.value[0:0];
        bssColorEn_rd : coverpoint bssColorEn.value[0:0];
        bssColor_rd : coverpoint bssColor.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BSSCOLORREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STATECNTRLREG
//--------------------------------------------------------------------
class STATECNTRLREG extends uvm_reg;
    `uvm_object_utils(STATECNTRLREG)
    rand uvm_reg_field nextState;
    rand uvm_reg_field currentState;

    //---build------------------------------------------------------------
    virtual function void build();
        nextState = uvm_reg_field::type_id::create("nextState");
        currentState = uvm_reg_field::type_id::create("currentState");

        nextState.configure(this, 4, 4, "RW", 1, 'b000, 1, 1, 1);
        currentState.configure(this, 4, 0, "RO", 1, 'b000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_STATECNTRLREG_wr_cg";
        nextState_wr : coverpoint nextState.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_STATECNTRLREG_rd_cg";
        nextState_rd : coverpoint nextState.value[3:0];
        currentState_rd : coverpoint currentState.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STATECNTRLREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SCANCNTRLREG
//--------------------------------------------------------------------
class SCANCNTRLREG extends uvm_reg;
    `uvm_object_utils(SCANCNTRLREG)
    rand uvm_reg_field primaryChPosition;
    rand uvm_reg_field probeDelay;

    //---build------------------------------------------------------------
    virtual function void build();
        primaryChPosition = uvm_reg_field::type_id::create("primaryChPosition");
        probeDelay = uvm_reg_field::type_id::create("probeDelay");

        primaryChPosition.configure(this, 3, 20, "RW", 1, 'b00, 1, 1, 1);
        probeDelay.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_SCANCNTRLREG_wr_cg";
        primaryChPosition_wr : coverpoint primaryChPosition.value[2:0];
        probeDelay_wr : coverpoint probeDelay.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_SCANCNTRLREG_rd_cg";
        primaryChPosition_rd : coverpoint primaryChPosition.value[2:0];
        probeDelay_rd : coverpoint probeDelay.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SCANCNTRLREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DOZECNTRL1REG
//--------------------------------------------------------------------
class DOZECNTRL1REG extends uvm_reg;
    `uvm_object_utils(DOZECNTRL1REG)
    rand uvm_reg_field wakeupDTIM;
    rand uvm_reg_field listenInterval;

    //---build------------------------------------------------------------
    virtual function void build();
        wakeupDTIM = uvm_reg_field::type_id::create("wakeupDTIM");
        listenInterval = uvm_reg_field::type_id::create("listenInterval");

        wakeupDTIM.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        listenInterval.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_DOZECNTRL1REG_wr_cg";
        wakeupDTIM_wr : coverpoint wakeupDTIM.value[0:0];
        listenInterval_wr : coverpoint listenInterval.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DOZECNTRL1REG_rd_cg";
        wakeupDTIM_rd : coverpoint wakeupDTIM.value[0:0];
        listenInterval_rd : coverpoint listenInterval.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DOZECNTRL1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MACCNTRL1REG
//--------------------------------------------------------------------
class MACCNTRL1REG extends uvm_reg;
    `uvm_object_utils(MACCNTRL1REG)
    rand uvm_reg_field rxRIFSEn;
    rand uvm_reg_field tsfMgtDisable;
    rand uvm_reg_field tsfUpdatedBySW;
    rand uvm_reg_field disableSVDRxPause;
    rand uvm_reg_field disableBQRResp;
    rand uvm_reg_field abgnMode;
    rand uvm_reg_field keyStoRAMReset;
    rand uvm_reg_field mibTableReset;
    rand uvm_reg_field rateControllerMPIF;
    rand uvm_reg_field disableBAResp;
    rand uvm_reg_field disableCTSResp;
    rand uvm_reg_field disableACKResp;
    rand uvm_reg_field activeClkGating;
    rand uvm_reg_field enableLPClkSwitch;
    rand uvm_reg_field lpClk32786Hz;
    rand uvm_reg_field pwrMgt;
    rand uvm_reg_field ap;
    rand uvm_reg_field bssType;

    //---build------------------------------------------------------------
    virtual function void build();
        rxRIFSEn = uvm_reg_field::type_id::create("rxRIFSEn");
        tsfMgtDisable = uvm_reg_field::type_id::create("tsfMgtDisable");
        tsfUpdatedBySW = uvm_reg_field::type_id::create("tsfUpdatedBySW");
        disableSVDRxPause = uvm_reg_field::type_id::create("disableSVDRxPause");
        disableBQRResp = uvm_reg_field::type_id::create("disableBQRResp");
        abgnMode = uvm_reg_field::type_id::create("abgnMode");
        keyStoRAMReset = uvm_reg_field::type_id::create("keyStoRAMReset");
        mibTableReset = uvm_reg_field::type_id::create("mibTableReset");
        rateControllerMPIF = uvm_reg_field::type_id::create("rateControllerMPIF");
        disableBAResp = uvm_reg_field::type_id::create("disableBAResp");
        disableCTSResp = uvm_reg_field::type_id::create("disableCTSResp");
        disableACKResp = uvm_reg_field::type_id::create("disableACKResp");
        activeClkGating = uvm_reg_field::type_id::create("activeClkGating");
        enableLPClkSwitch = uvm_reg_field::type_id::create("enableLPClkSwitch");
        lpClk32786Hz = uvm_reg_field::type_id::create("lpClk32786Hz");
        pwrMgt = uvm_reg_field::type_id::create("pwrMgt");
        ap = uvm_reg_field::type_id::create("ap");
        bssType = uvm_reg_field::type_id::create("bssType");

        rxRIFSEn.configure(this, 1, 26, "RW", 1, 'b0, 1, 1, 1);
        tsfMgtDisable.configure(this, 1, 25, "RW", 1, 'b0, 1, 1, 1);
        tsfUpdatedBySW.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        disableSVDRxPause.configure(this, 1, 19, "RW", 1, 'b0, 1, 1, 1);
        disableBQRResp.configure(this, 1, 18, "RW", 1, 'b0, 1, 1, 1);
        abgnMode.configure(this, 3, 14, "RW", 1, 'b11, 1, 1, 1);
        keyStoRAMReset.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        mibTableReset.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        rateControllerMPIF.configure(this, 1, 11, "RW", 1, 'b1, 1, 1, 1);
        disableBAResp.configure(this, 1, 10, "RW", 1, 'b0, 1, 1, 1);
        disableCTSResp.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        disableACKResp.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        activeClkGating.configure(this, 1, 7, "RW", 1, 'b1, 1, 1, 1);
        enableLPClkSwitch.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        lpClk32786Hz.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        pwrMgt.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        ap.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        bssType.configure(this, 1, 0, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MACCNTRL1REG_wr_cg";
        rxRIFSEn_wr : coverpoint rxRIFSEn.value[0:0];
        tsfMgtDisable_wr : coverpoint tsfMgtDisable.value[0:0];
        tsfUpdatedBySW_wr : coverpoint tsfUpdatedBySW.value[0:0];
        disableSVDRxPause_wr : coverpoint disableSVDRxPause.value[0:0];
        disableBQRResp_wr : coverpoint disableBQRResp.value[0:0];
        abgnMode_wr : coverpoint abgnMode.value[2:0];
        keyStoRAMReset_wr : coverpoint keyStoRAMReset.value[0:0];
        mibTableReset_wr : coverpoint mibTableReset.value[0:0];
        rateControllerMPIF_wr : coverpoint rateControllerMPIF.value[0:0];
        disableBAResp_wr : coverpoint disableBAResp.value[0:0];
        disableCTSResp_wr : coverpoint disableCTSResp.value[0:0];
        disableACKResp_wr : coverpoint disableACKResp.value[0:0];
        activeClkGating_wr : coverpoint activeClkGating.value[0:0];
        enableLPClkSwitch_wr : coverpoint enableLPClkSwitch.value[0:0];
        lpClk32786Hz_wr : coverpoint lpClk32786Hz.value[0:0];
        pwrMgt_wr : coverpoint pwrMgt.value[0:0];
        ap_wr : coverpoint ap.value[0:0];
        bssType_wr : coverpoint bssType.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MACCNTRL1REG_rd_cg";
        rxRIFSEn_rd : coverpoint rxRIFSEn.value[0:0];
        tsfMgtDisable_rd : coverpoint tsfMgtDisable.value[0:0];
        tsfUpdatedBySW_rd : coverpoint tsfUpdatedBySW.value[0:0];
        disableSVDRxPause_rd : coverpoint disableSVDRxPause.value[0:0];
        disableBQRResp_rd : coverpoint disableBQRResp.value[0:0];
        abgnMode_rd : coverpoint abgnMode.value[2:0];
        keyStoRAMReset_rd : coverpoint keyStoRAMReset.value[0:0];
        mibTableReset_rd : coverpoint mibTableReset.value[0:0];
        rateControllerMPIF_rd : coverpoint rateControllerMPIF.value[0:0];
        disableBAResp_rd : coverpoint disableBAResp.value[0:0];
        disableCTSResp_rd : coverpoint disableCTSResp.value[0:0];
        disableACKResp_rd : coverpoint disableACKResp.value[0:0];
        activeClkGating_rd : coverpoint activeClkGating.value[0:0];
        enableLPClkSwitch_rd : coverpoint enableLPClkSwitch.value[0:0];
        lpClk32786Hz_rd : coverpoint lpClk32786Hz.value[0:0];
        pwrMgt_rd : coverpoint pwrMgt.value[0:0];
        ap_rd : coverpoint ap.value[0:0];
        bssType_rd : coverpoint bssType.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MACCNTRL1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MACERRRECCNTRLREG
//--------------------------------------------------------------------
class MACERRRECCNTRLREG extends uvm_reg;
    `uvm_object_utils(MACERRRECCNTRLREG)
    rand uvm_reg_field rxFlowCntrlEn;
    rand uvm_reg_field baPSBitmapReset;
    rand uvm_reg_field macPHYIFFIFOReset;
    rand uvm_reg_field txFIFOReset;
    rand uvm_reg_field rxFIFOReset;
    rand uvm_reg_field hwFSMReset;
    rand uvm_reg_field useErrDet;
    rand uvm_reg_field useErrRec;

    //---build------------------------------------------------------------
    virtual function void build();
        rxFlowCntrlEn = uvm_reg_field::type_id::create("rxFlowCntrlEn");
        baPSBitmapReset = uvm_reg_field::type_id::create("baPSBitmapReset");
        macPHYIFFIFOReset = uvm_reg_field::type_id::create("macPHYIFFIFOReset");
        txFIFOReset = uvm_reg_field::type_id::create("txFIFOReset");
        rxFIFOReset = uvm_reg_field::type_id::create("rxFIFOReset");
        hwFSMReset = uvm_reg_field::type_id::create("hwFSMReset");
        useErrDet = uvm_reg_field::type_id::create("useErrDet");
        useErrRec = uvm_reg_field::type_id::create("useErrRec");

        rxFlowCntrlEn.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        baPSBitmapReset.configure(this, 1, 7, "RW", 1, 'b0, 1, 1, 1);
        macPHYIFFIFOReset.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        txFIFOReset.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        rxFIFOReset.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        hwFSMReset.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        useErrDet.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        useErrRec.configure(this, 1, 0, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MACERRRECCNTRLREG_wr_cg";
        rxFlowCntrlEn_wr : coverpoint rxFlowCntrlEn.value[0:0];
        baPSBitmapReset_wr : coverpoint baPSBitmapReset.value[0:0];
        macPHYIFFIFOReset_wr : coverpoint macPHYIFFIFOReset.value[0:0];
        txFIFOReset_wr : coverpoint txFIFOReset.value[0:0];
        rxFIFOReset_wr : coverpoint rxFIFOReset.value[0:0];
        hwFSMReset_wr : coverpoint hwFSMReset.value[0:0];
        useErrDet_wr : coverpoint useErrDet.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MACERRRECCNTRLREG_rd_cg";
        rxFlowCntrlEn_rd : coverpoint rxFlowCntrlEn.value[0:0];
        baPSBitmapReset_rd : coverpoint baPSBitmapReset.value[0:0];
        macPHYIFFIFOReset_rd : coverpoint macPHYIFFIFOReset.value[0:0];
        txFIFOReset_rd : coverpoint txFIFOReset.value[0:0];
        rxFIFOReset_rd : coverpoint rxFIFOReset.value[0:0];
        hwFSMReset_rd : coverpoint hwFSMReset.value[0:0];
        useErrDet_rd : coverpoint useErrDet.value[0:0];
        useErrRec_rd : coverpoint useErrRec.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MACERRRECCNTRLREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MACERRSETSTATUSREG
//--------------------------------------------------------------------
class MACERRSETSTATUSREG extends uvm_reg;
    `uvm_object_utils(MACERRSETSTATUSREG)
    rand uvm_reg_field errInHWLevel3;
    rand uvm_reg_field errInTxRxLevel2;
    rand uvm_reg_field errInRxLevel1;
    rand uvm_reg_field errInTxLevel1;

    //---build------------------------------------------------------------
    virtual function void build();
        errInHWLevel3 = uvm_reg_field::type_id::create("errInHWLevel3");
        errInTxRxLevel2 = uvm_reg_field::type_id::create("errInTxRxLevel2");
        errInRxLevel1 = uvm_reg_field::type_id::create("errInRxLevel1");
        errInTxLevel1 = uvm_reg_field::type_id::create("errInTxLevel1");

        errInHWLevel3.configure(this, 1, 3, "W1S", 1, 'b0, 1, 1, 1);
        errInTxRxLevel2.configure(this, 1, 2, "W1S", 1, 'b0, 1, 1, 1);
        errInRxLevel1.configure(this, 1, 1, "W1S", 1, 'b0, 1, 1, 1);
        errInTxLevel1.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MACERRSETSTATUSREG_wr_cg";
        errInHWLevel3_wr : coverpoint errInHWLevel3.value[0:0];
        errInTxRxLevel2_wr : coverpoint errInTxRxLevel2.value[0:0];
        errInRxLevel1_wr : coverpoint errInRxLevel1.value[0:0];
        errInTxLevel1_wr : coverpoint errInTxLevel1.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MACERRSETSTATUSREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MACERRCLEARSTATUSREG
//--------------------------------------------------------------------
class MACERRCLEARSTATUSREG extends uvm_reg;
    `uvm_object_utils(MACERRCLEARSTATUSREG)
    rand uvm_reg_field clearErrInHWLevel3;
    rand uvm_reg_field clearErrInTxRxLevel2;
    rand uvm_reg_field clearErrInRxLevel1;
    rand uvm_reg_field clearErrInTxLevel1;

    //---build------------------------------------------------------------
    virtual function void build();
        clearErrInHWLevel3 = uvm_reg_field::type_id::create("clearErrInHWLevel3");
        clearErrInTxRxLevel2 = uvm_reg_field::type_id::create("clearErrInTxRxLevel2");
        clearErrInRxLevel1 = uvm_reg_field::type_id::create("clearErrInRxLevel1");
        clearErrInTxLevel1 = uvm_reg_field::type_id::create("clearErrInTxLevel1");

        clearErrInHWLevel3.configure(this, 1, 3, "W1C", 1, 'b0, 1, 1, 1);
        clearErrInTxRxLevel2.configure(this, 1, 2, "W1C", 1, 'b0, 1, 1, 1);
        clearErrInRxLevel1.configure(this, 1, 1, "W1C", 1, 'b0, 1, 1, 1);
        clearErrInTxLevel1.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MACERRCLEARSTATUSREG_wr_cg";
        clearErrInHWLevel3_wr : coverpoint clearErrInHWLevel3.value[0:0];
        clearErrInTxRxLevel2_wr : coverpoint clearErrInTxRxLevel2.value[0:0];
        clearErrInRxLevel1_wr : coverpoint clearErrInRxLevel1.value[0:0];
        clearErrInTxLevel1_wr : coverpoint clearErrInTxLevel1.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MACERRCLEARSTATUSREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXCNTRLREG
//--------------------------------------------------------------------
class RXCNTRLREG extends uvm_reg;
    `uvm_object_utils(RXCNTRLREG)
    rand uvm_reg_field enDuplicateDetection;
    rand uvm_reg_field acceptUnknown;
    rand uvm_reg_field acceptOtherDataFrames;
    rand uvm_reg_field acceptQoSNull;
    rand uvm_reg_field acceptQCFWOData;
    rand uvm_reg_field acceptQData;
    rand uvm_reg_field acceptCFWOData;
    rand uvm_reg_field acceptData;
    rand uvm_reg_field acceptOtherCntrlFrames;
    rand uvm_reg_field acceptCFEnd;
    rand uvm_reg_field acceptACK;
    rand uvm_reg_field acceptCTS;
    rand uvm_reg_field acceptRTS;
    rand uvm_reg_field acceptPSPoll;
    rand uvm_reg_field acceptBA;
    rand uvm_reg_field acceptBAR;
    rand uvm_reg_field acceptOtherMgmtFrames;
    rand uvm_reg_field acceptBfmeeFrames;
    rand uvm_reg_field acceptAllBeacon;
    rand uvm_reg_field acceptNotExpectedBA;
    rand uvm_reg_field acceptDecryptErrorFrames;
    rand uvm_reg_field acceptBeacon;
    rand uvm_reg_field acceptProbeResp;
    rand uvm_reg_field acceptProbeReq;
    rand uvm_reg_field acceptMyUnicast;
    rand uvm_reg_field acceptUnicast;
    rand uvm_reg_field acceptErrorFrames;
    rand uvm_reg_field acceptOtherBSSID;
    rand uvm_reg_field acceptBroadcast;
    rand uvm_reg_field acceptMulticast;
    rand uvm_reg_field dontDecrypt;
    rand uvm_reg_field excUnencrypted;

    //---build------------------------------------------------------------
    virtual function void build();
        enDuplicateDetection = uvm_reg_field::type_id::create("enDuplicateDetection");
        acceptUnknown = uvm_reg_field::type_id::create("acceptUnknown");
        acceptOtherDataFrames = uvm_reg_field::type_id::create("acceptOtherDataFrames");
        acceptQoSNull = uvm_reg_field::type_id::create("acceptQoSNull");
        acceptQCFWOData = uvm_reg_field::type_id::create("acceptQCFWOData");
        acceptQData = uvm_reg_field::type_id::create("acceptQData");
        acceptCFWOData = uvm_reg_field::type_id::create("acceptCFWOData");
        acceptData = uvm_reg_field::type_id::create("acceptData");
        acceptOtherCntrlFrames = uvm_reg_field::type_id::create("acceptOtherCntrlFrames");
        acceptCFEnd = uvm_reg_field::type_id::create("acceptCFEnd");
        acceptACK = uvm_reg_field::type_id::create("acceptACK");
        acceptCTS = uvm_reg_field::type_id::create("acceptCTS");
        acceptRTS = uvm_reg_field::type_id::create("acceptRTS");
        acceptPSPoll = uvm_reg_field::type_id::create("acceptPSPoll");
        acceptBA = uvm_reg_field::type_id::create("acceptBA");
        acceptBAR = uvm_reg_field::type_id::create("acceptBAR");
        acceptOtherMgmtFrames = uvm_reg_field::type_id::create("acceptOtherMgmtFrames");
        acceptBfmeeFrames = uvm_reg_field::type_id::create("acceptBfmeeFrames");
        acceptAllBeacon = uvm_reg_field::type_id::create("acceptAllBeacon");
        acceptNotExpectedBA = uvm_reg_field::type_id::create("acceptNotExpectedBA");
        acceptDecryptErrorFrames = uvm_reg_field::type_id::create("acceptDecryptErrorFrames");
        acceptBeacon = uvm_reg_field::type_id::create("acceptBeacon");
        acceptProbeResp = uvm_reg_field::type_id::create("acceptProbeResp");
        acceptProbeReq = uvm_reg_field::type_id::create("acceptProbeReq");
        acceptMyUnicast = uvm_reg_field::type_id::create("acceptMyUnicast");
        acceptUnicast = uvm_reg_field::type_id::create("acceptUnicast");
        acceptErrorFrames = uvm_reg_field::type_id::create("acceptErrorFrames");
        acceptOtherBSSID = uvm_reg_field::type_id::create("acceptOtherBSSID");
        acceptBroadcast = uvm_reg_field::type_id::create("acceptBroadcast");
        acceptMulticast = uvm_reg_field::type_id::create("acceptMulticast");
        dontDecrypt = uvm_reg_field::type_id::create("dontDecrypt");
        excUnencrypted = uvm_reg_field::type_id::create("excUnencrypted");

        enDuplicateDetection.configure(this, 1, 31, "RO", 1, 'b0, 1, 1, 1);
        acceptUnknown.configure(this, 1, 30, "RW", 1, 'b0, 1, 1, 1);
        acceptOtherDataFrames.configure(this, 1, 29, "RW", 1, 'b0, 1, 1, 1);
        acceptQoSNull.configure(this, 1, 28, "RW", 1, 'b1, 1, 1, 1);
        acceptQCFWOData.configure(this, 1, 27, "RW", 1, 'b0, 1, 1, 1);
        acceptQData.configure(this, 1, 26, "RW", 1, 'b1, 1, 1, 1);
        acceptCFWOData.configure(this, 1, 25, "RW", 1, 'b0, 1, 1, 1);
        acceptData.configure(this, 1, 24, "RW", 1, 'b1, 1, 1, 1);
        acceptOtherCntrlFrames.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        acceptCFEnd.configure(this, 1, 22, "RW", 1, 'b0, 1, 1, 1);
        acceptACK.configure(this, 1, 21, "RW", 1, 'b0, 1, 1, 1);
        acceptCTS.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        acceptRTS.configure(this, 1, 19, "RW", 1, 'b0, 1, 1, 1);
        acceptPSPoll.configure(this, 1, 18, "RW", 1, 'b1, 1, 1, 1);
        acceptBA.configure(this, 1, 17, "RW", 1, 'b1, 1, 1, 1);
        acceptBAR.configure(this, 1, 16, "RW", 1, 'b1, 1, 1, 1);
        acceptOtherMgmtFrames.configure(this, 1, 15, "RW", 1, 'b1, 1, 1, 1);
        acceptBfmeeFrames.configure(this, 1, 14, "RW", 1, 'b0, 1, 1, 1);
        acceptAllBeacon.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        acceptNotExpectedBA.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        acceptDecryptErrorFrames.configure(this, 1, 11, "RW", 1, 'b0, 1, 1, 1);
        acceptBeacon.configure(this, 1, 10, "RW", 1, 'b1, 1, 1, 1);
        acceptProbeResp.configure(this, 1, 9, "RW", 1, 'b1, 1, 1, 1);
        acceptProbeReq.configure(this, 1, 8, "RW", 1, 'b1, 1, 1, 1);
        acceptMyUnicast.configure(this, 1, 7, "RW", 1, 'b1, 1, 1, 1);
        acceptUnicast.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        acceptErrorFrames.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        acceptOtherBSSID.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        acceptBroadcast.configure(this, 1, 3, "RW", 1, 'b1, 1, 1, 1);
        acceptMulticast.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        dontDecrypt.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        excUnencrypted.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_RXCNTRLREG_wr_cg";
        acceptUnknown_wr : coverpoint acceptUnknown.value[0:0];
        acceptOtherDataFrames_wr : coverpoint acceptOtherDataFrames.value[0:0];
        acceptQoSNull_wr : coverpoint acceptQoSNull.value[0:0];
        acceptQCFWOData_wr : coverpoint acceptQCFWOData.value[0:0];
        acceptQData_wr : coverpoint acceptQData.value[0:0];
        acceptCFWOData_wr : coverpoint acceptCFWOData.value[0:0];
        acceptData_wr : coverpoint acceptData.value[0:0];
        acceptOtherCntrlFrames_wr : coverpoint acceptOtherCntrlFrames.value[0:0];
        acceptCFEnd_wr : coverpoint acceptCFEnd.value[0:0];
        acceptACK_wr : coverpoint acceptACK.value[0:0];
        acceptCTS_wr : coverpoint acceptCTS.value[0:0];
        acceptRTS_wr : coverpoint acceptRTS.value[0:0];
        acceptPSPoll_wr : coverpoint acceptPSPoll.value[0:0];
        acceptBA_wr : coverpoint acceptBA.value[0:0];
        acceptBAR_wr : coverpoint acceptBAR.value[0:0];
        acceptOtherMgmtFrames_wr : coverpoint acceptOtherMgmtFrames.value[0:0];
        acceptBfmeeFrames_wr : coverpoint acceptBfmeeFrames.value[0:0];
        acceptAllBeacon_wr : coverpoint acceptAllBeacon.value[0:0];
        acceptNotExpectedBA_wr : coverpoint acceptNotExpectedBA.value[0:0];
        acceptDecryptErrorFrames_wr : coverpoint acceptDecryptErrorFrames.value[0:0];
        acceptBeacon_wr : coverpoint acceptBeacon.value[0:0];
        acceptProbeResp_wr : coverpoint acceptProbeResp.value[0:0];
        acceptProbeReq_wr : coverpoint acceptProbeReq.value[0:0];
        acceptMyUnicast_wr : coverpoint acceptMyUnicast.value[0:0];
        acceptUnicast_wr : coverpoint acceptUnicast.value[0:0];
        acceptErrorFrames_wr : coverpoint acceptErrorFrames.value[0:0];
        acceptOtherBSSID_wr : coverpoint acceptOtherBSSID.value[0:0];
        acceptBroadcast_wr : coverpoint acceptBroadcast.value[0:0];
        acceptMulticast_wr : coverpoint acceptMulticast.value[0:0];
        dontDecrypt_wr : coverpoint dontDecrypt.value[0:0];
        excUnencrypted_wr : coverpoint excUnencrypted.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_RXCNTRLREG_rd_cg";
        enDuplicateDetection_rd : coverpoint enDuplicateDetection.value[0:0];
        acceptUnknown_rd : coverpoint acceptUnknown.value[0:0];
        acceptOtherDataFrames_rd : coverpoint acceptOtherDataFrames.value[0:0];
        acceptQoSNull_rd : coverpoint acceptQoSNull.value[0:0];
        acceptQCFWOData_rd : coverpoint acceptQCFWOData.value[0:0];
        acceptQData_rd : coverpoint acceptQData.value[0:0];
        acceptCFWOData_rd : coverpoint acceptCFWOData.value[0:0];
        acceptData_rd : coverpoint acceptData.value[0:0];
        acceptOtherCntrlFrames_rd : coverpoint acceptOtherCntrlFrames.value[0:0];
        acceptCFEnd_rd : coverpoint acceptCFEnd.value[0:0];
        acceptACK_rd : coverpoint acceptACK.value[0:0];
        acceptCTS_rd : coverpoint acceptCTS.value[0:0];
        acceptRTS_rd : coverpoint acceptRTS.value[0:0];
        acceptPSPoll_rd : coverpoint acceptPSPoll.value[0:0];
        acceptBA_rd : coverpoint acceptBA.value[0:0];
        acceptBAR_rd : coverpoint acceptBAR.value[0:0];
        acceptOtherMgmtFrames_rd : coverpoint acceptOtherMgmtFrames.value[0:0];
        acceptBfmeeFrames_rd : coverpoint acceptBfmeeFrames.value[0:0];
        acceptAllBeacon_rd : coverpoint acceptAllBeacon.value[0:0];
        acceptNotExpectedBA_rd : coverpoint acceptNotExpectedBA.value[0:0];
        acceptDecryptErrorFrames_rd : coverpoint acceptDecryptErrorFrames.value[0:0];
        acceptBeacon_rd : coverpoint acceptBeacon.value[0:0];
        acceptProbeResp_rd : coverpoint acceptProbeResp.value[0:0];
        acceptProbeReq_rd : coverpoint acceptProbeReq.value[0:0];
        acceptMyUnicast_rd : coverpoint acceptMyUnicast.value[0:0];
        acceptUnicast_rd : coverpoint acceptUnicast.value[0:0];
        acceptErrorFrames_rd : coverpoint acceptErrorFrames.value[0:0];
        acceptOtherBSSID_rd : coverpoint acceptOtherBSSID.value[0:0];
        acceptBroadcast_rd : coverpoint acceptBroadcast.value[0:0];
        acceptMulticast_rd : coverpoint acceptMulticast.value[0:0];
        dontDecrypt_rd : coverpoint dontDecrypt.value[0:0];
        excUnencrypted_rd : coverpoint excUnencrypted.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXCNTRLREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BCNCNTRL1REG
//--------------------------------------------------------------------
class BCNCNTRL1REG extends uvm_reg;
    `uvm_object_utils(BCNCNTRL1REG)
    rand uvm_reg_field noBcnTxTime;
    rand uvm_reg_field impTBTTIn128Us;
    rand uvm_reg_field impTBTTPeriod;
    rand uvm_reg_field beaconInt;

    //---build------------------------------------------------------------
    virtual function void build();
        noBcnTxTime = uvm_reg_field::type_id::create("noBcnTxTime");
        impTBTTIn128Us = uvm_reg_field::type_id::create("impTBTTIn128Us");
        impTBTTPeriod = uvm_reg_field::type_id::create("impTBTTPeriod");
        beaconInt = uvm_reg_field::type_id::create("beaconInt");

        noBcnTxTime.configure(this, 8, 24, "RW", 1, `NO_BCN_TX_TIME, 1, 1, 1);
        impTBTTIn128Us.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        impTBTTPeriod.configure(this, 7, 16, "RW", 1, `IMP_TBTT_TIME, 1, 1, 1);
        beaconInt.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_BCNCNTRL1REG_wr_cg";
        noBcnTxTime_wr : coverpoint noBcnTxTime.value[7:0];
        impTBTTIn128Us_wr : coverpoint impTBTTIn128Us.value[0:0];
        impTBTTPeriod_wr : coverpoint impTBTTPeriod.value[6:0];
        beaconInt_wr : coverpoint beaconInt.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_BCNCNTRL1REG_rd_cg";
        noBcnTxTime_rd : coverpoint noBcnTxTime.value[7:0];
        impTBTTIn128Us_rd : coverpoint impTBTTIn128Us.value[0:0];
        impTBTTPeriod_rd : coverpoint impTBTTPeriod.value[6:0];
        beaconInt_rd : coverpoint beaconInt.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BCNCNTRL1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BCNCNTRL2REG
//--------------------------------------------------------------------
class BCNCNTRL2REG extends uvm_reg;
    `uvm_object_utils(BCNCNTRL2REG)
    rand uvm_reg_field aid;
    rand uvm_reg_field timOffset;
    rand uvm_reg_field bcnUpdateOffset;

    //---build------------------------------------------------------------
    virtual function void build();
        aid = uvm_reg_field::type_id::create("aid");
        timOffset = uvm_reg_field::type_id::create("timOffset");
        bcnUpdateOffset = uvm_reg_field::type_id::create("bcnUpdateOffset");

        aid.configure(this, 16, 16, "RW", 1, 'b000000000000000, 1, 1, 1);
        timOffset.configure(this, 8, 8, "RW", 1, 'b0000000, 1, 1, 1);
        bcnUpdateOffset.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_BCNCNTRL2REG_wr_cg";
        aid_wr : coverpoint aid.value[15:0];
        timOffset_wr : coverpoint timOffset.value[7:0];
        bcnUpdateOffset_wr : coverpoint bcnUpdateOffset.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_BCNCNTRL2REG_rd_cg";
        aid_rd : coverpoint aid.value[15:0];
        timOffset_rd : coverpoint timOffset.value[7:0];
        bcnUpdateOffset_rd : coverpoint bcnUpdateOffset.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BCNCNTRL2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DTIM1REG
//--------------------------------------------------------------------
class DTIM1REG extends uvm_reg;
    `uvm_object_utils(DTIM1REG)
    rand uvm_reg_field dtimUpdatedBySW;
    rand uvm_reg_field dtimPeriod;

    //---build------------------------------------------------------------
    virtual function void build();
        dtimUpdatedBySW = uvm_reg_field::type_id::create("dtimUpdatedBySW");
        dtimPeriod = uvm_reg_field::type_id::create("dtimPeriod");

        dtimUpdatedBySW.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        dtimPeriod.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_DTIM1REG_wr_cg";
        dtimUpdatedBySW_wr : coverpoint dtimUpdatedBySW.value[0:0];
        dtimPeriod_wr : coverpoint dtimPeriod.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DTIM1REG_rd_cg";
        dtimUpdatedBySW_rd : coverpoint dtimUpdatedBySW.value[0:0];
        dtimPeriod_rd : coverpoint dtimPeriod.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DTIM1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RETRYLIMITSREG
//--------------------------------------------------------------------
class RETRYLIMITSREG extends uvm_reg;
    `uvm_object_utils(RETRYLIMITSREG)
    rand uvm_reg_field dot11LongRetryLimit;
    rand uvm_reg_field dot11ShortRetryLimit;

    //---build------------------------------------------------------------
    virtual function void build();
        dot11LongRetryLimit = uvm_reg_field::type_id::create("dot11LongRetryLimit");
        dot11ShortRetryLimit = uvm_reg_field::type_id::create("dot11ShortRetryLimit");

        dot11LongRetryLimit.configure(this, 8, 8, "RW", 1, 'b0000100, 1, 1, 1);
        dot11ShortRetryLimit.configure(this, 8, 0, "RW", 1, 'b0000111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_RETRYLIMITSREG_wr_cg";
        dot11LongRetryLimit_wr : coverpoint dot11LongRetryLimit.value[7:0];
        dot11ShortRetryLimit_wr : coverpoint dot11ShortRetryLimit.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_RETRYLIMITSREG_rd_cg";
        dot11LongRetryLimit_rd : coverpoint dot11LongRetryLimit.value[7:0];
        dot11ShortRetryLimit_rd : coverpoint dot11ShortRetryLimit.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RETRYLIMITSREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BBSERVICEREG
//--------------------------------------------------------------------
class BBSERVICEREG extends uvm_reg;
    `uvm_object_utils(BBSERVICEREG)
    rand uvm_reg_field maxPHYNtx;
    rand uvm_reg_field bbServiceB;
    rand uvm_reg_field bbServiceA;

    //---build------------------------------------------------------------
    virtual function void build();
        maxPHYNtx = uvm_reg_field::type_id::create("maxPHYNtx");
        bbServiceB = uvm_reg_field::type_id::create("bbServiceB");
        bbServiceA = uvm_reg_field::type_id::create("bbServiceA");

        maxPHYNtx.configure(this, 3, 26, "RW", 1, 'b01, 1, 1, 1);
        bbServiceB.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        bbServiceA.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_BBSERVICEREG_wr_cg";
        maxPHYNtx_wr : coverpoint maxPHYNtx.value[2:0];
        bbServiceB_wr : coverpoint bbServiceB.value[7:0];
        bbServiceA_wr : coverpoint bbServiceA.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_BBSERVICEREG_rd_cg";
        maxPHYNtx_rd : coverpoint maxPHYNtx.value[2:0];
        bbServiceB_rd : coverpoint bbServiceB.value[7:0];
        bbServiceA_rd : coverpoint bbServiceA.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BBSERVICEREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MAXPOWERLEVELREG
//--------------------------------------------------------------------
class MAXPOWERLEVELREG extends uvm_reg;
    `uvm_object_utils(MAXPOWERLEVELREG)
    rand uvm_reg_field ofdmMinPwrLevel;
    rand uvm_reg_field dsssMaxPwrLevel;
    rand uvm_reg_field ofdmMaxPwrLevel;

    //---build------------------------------------------------------------
    virtual function void build();
        ofdmMinPwrLevel = uvm_reg_field::type_id::create("ofdmMinPwrLevel");
        dsssMaxPwrLevel = uvm_reg_field::type_id::create("dsssMaxPwrLevel");
        ofdmMaxPwrLevel = uvm_reg_field::type_id::create("ofdmMaxPwrLevel");

        ofdmMinPwrLevel.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        dsssMaxPwrLevel.configure(this, 8, 8, "RW", 1, 'b0001111, 1, 1, 1);
        ofdmMaxPwrLevel.configure(this, 8, 0, "RW", 1, 'b0001111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MAXPOWERLEVELREG_wr_cg";
        ofdmMinPwrLevel_wr : coverpoint ofdmMinPwrLevel.value[7:0];
        dsssMaxPwrLevel_wr : coverpoint dsssMaxPwrLevel.value[7:0];
        ofdmMaxPwrLevel_wr : coverpoint ofdmMaxPwrLevel.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MAXPOWERLEVELREG_rd_cg";
        ofdmMinPwrLevel_rd : coverpoint ofdmMinPwrLevel.value[7:0];
        dsssMaxPwrLevel_rd : coverpoint dsssMaxPwrLevel.value[7:0];
        ofdmMaxPwrLevel_rd : coverpoint ofdmMaxPwrLevel.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MAXPOWERLEVELREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRKEY0REG
//--------------------------------------------------------------------
class ENCRKEY0REG extends uvm_reg;
    `uvm_object_utils(ENCRKEY0REG)
    rand uvm_reg_field encrKeyRAMWord0;

    //---build------------------------------------------------------------
    virtual function void build();
        encrKeyRAMWord0 = uvm_reg_field::type_id::create("encrKeyRAMWord0");

        encrKeyRAMWord0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRKEY0REG_wr_cg";
        encrKeyRAMWord0_wr : coverpoint encrKeyRAMWord0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRKEY0REG_rd_cg";
        encrKeyRAMWord0_rd : coverpoint encrKeyRAMWord0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRKEY0REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRKEY1REG
//--------------------------------------------------------------------
class ENCRKEY1REG extends uvm_reg;
    `uvm_object_utils(ENCRKEY1REG)
    rand uvm_reg_field encrKeyRAMWord1;

    //---build------------------------------------------------------------
    virtual function void build();
        encrKeyRAMWord1 = uvm_reg_field::type_id::create("encrKeyRAMWord1");

        encrKeyRAMWord1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRKEY1REG_wr_cg";
        encrKeyRAMWord1_wr : coverpoint encrKeyRAMWord1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRKEY1REG_rd_cg";
        encrKeyRAMWord1_rd : coverpoint encrKeyRAMWord1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRKEY1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRKEY2REG
//--------------------------------------------------------------------
class ENCRKEY2REG extends uvm_reg;
    `uvm_object_utils(ENCRKEY2REG)
    rand uvm_reg_field encrKeyRAMWord2;

    //---build------------------------------------------------------------
    virtual function void build();
        encrKeyRAMWord2 = uvm_reg_field::type_id::create("encrKeyRAMWord2");

        encrKeyRAMWord2.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRKEY2REG_wr_cg";
        encrKeyRAMWord2_wr : coverpoint encrKeyRAMWord2.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRKEY2REG_rd_cg";
        encrKeyRAMWord2_rd : coverpoint encrKeyRAMWord2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRKEY2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRKEY3REG
//--------------------------------------------------------------------
class ENCRKEY3REG extends uvm_reg;
    `uvm_object_utils(ENCRKEY3REG)
    rand uvm_reg_field encrKeyRAMWord3;

    //---build------------------------------------------------------------
    virtual function void build();
        encrKeyRAMWord3 = uvm_reg_field::type_id::create("encrKeyRAMWord3");

        encrKeyRAMWord3.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRKEY3REG_wr_cg";
        encrKeyRAMWord3_wr : coverpoint encrKeyRAMWord3.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRKEY3REG_rd_cg";
        encrKeyRAMWord3_rd : coverpoint encrKeyRAMWord3.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRKEY3REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRMACADDRLOWREG
//--------------------------------------------------------------------
class ENCRMACADDRLOWREG extends uvm_reg;
    `uvm_object_utils(ENCRMACADDRLOWREG)
    rand uvm_reg_field macAddrRAMLow;

    //---build------------------------------------------------------------
    virtual function void build();
        macAddrRAMLow = uvm_reg_field::type_id::create("macAddrRAMLow");

        macAddrRAMLow.configure(this, 32, 0, "RW", 1, 'b11111111111111111111111111111111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRMACADDRLOWREG_wr_cg";
        macAddrRAMLow_wr : coverpoint macAddrRAMLow.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRMACADDRLOWREG_rd_cg";
        macAddrRAMLow_rd : coverpoint macAddrRAMLow.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRMACADDRLOWREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRMACADDRHIGHREG
//--------------------------------------------------------------------
class ENCRMACADDRHIGHREG extends uvm_reg;
    `uvm_object_utils(ENCRMACADDRHIGHREG)
    rand uvm_reg_field macAddrRAMHigh;

    //---build------------------------------------------------------------
    virtual function void build();
        macAddrRAMHigh = uvm_reg_field::type_id::create("macAddrRAMHigh");

        macAddrRAMHigh.configure(this, 16, 0, "RW", 1, 'b1111111111111111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRMACADDRHIGHREG_wr_cg";
        macAddrRAMHigh_wr : coverpoint macAddrRAMHigh.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRMACADDRHIGHREG_rd_cg";
        macAddrRAMHigh_rd : coverpoint macAddrRAMHigh.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRMACADDRHIGHREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRCNTRLREG
//--------------------------------------------------------------------
class ENCRCNTRLREG extends uvm_reg;
    `uvm_object_utils(ENCRCNTRLREG)
    rand uvm_reg_field newRead;
    rand uvm_reg_field newWrite;
    rand uvm_reg_field newSearch;
    rand uvm_reg_field searchError;
    rand uvm_reg_field keyIndexRAM;
    rand uvm_reg_field cLenRAM;
    rand uvm_reg_field cTypeRAM;
    rand uvm_reg_field vlanIDRAM;
    rand uvm_reg_field sppRAM;
    rand uvm_reg_field useDefKeyRAM;

    //---build------------------------------------------------------------
    virtual function void build();
        newRead = uvm_reg_field::type_id::create("newRead");
        newWrite = uvm_reg_field::type_id::create("newWrite");
        newSearch = uvm_reg_field::type_id::create("newSearch");
        searchError = uvm_reg_field::type_id::create("searchError");
        keyIndexRAM = uvm_reg_field::type_id::create("keyIndexRAM");
        cLenRAM = uvm_reg_field::type_id::create("cLenRAM");
        cTypeRAM = uvm_reg_field::type_id::create("cTypeRAM");
        vlanIDRAM = uvm_reg_field::type_id::create("vlanIDRAM");
        sppRAM = uvm_reg_field::type_id::create("sppRAM");
        useDefKeyRAM = uvm_reg_field::type_id::create("useDefKeyRAM");

        newRead.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        newWrite.configure(this, 1, 30, "RW", 1, 'b0, 1, 1, 1);
        newSearch.configure(this, 1, 29, "RW", 1, 'b0, 1, 1, 1);
        searchError.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        keyIndexRAM.configure(this, 10, 16, "RW", 1, 'b000000000, 1, 1, 1);
        cLenRAM.configure(this, 2, 12, "RW", 1, 'b0, 1, 1, 1);
        cTypeRAM.configure(this, 3, 8, "RW", 1, 'b00, 1, 1, 1);
        vlanIDRAM.configure(this, 4, 4, "RW", 1, 'b000, 1, 1, 1);
        sppRAM.configure(this, 2, 2, "RW", 1, 'b0, 1, 1, 1);
        useDefKeyRAM.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRCNTRLREG_wr_cg";
        newRead_wr : coverpoint newRead.value[0:0];
        newWrite_wr : coverpoint newWrite.value[0:0];
        newSearch_wr : coverpoint newSearch.value[0:0];
        searchError_wr : coverpoint searchError.value[0:0];
        keyIndexRAM_wr : coverpoint keyIndexRAM.value[9:0];
        cLenRAM_wr : coverpoint cLenRAM.value[1:0];
        cTypeRAM_wr : coverpoint cTypeRAM.value[2:0];
        vlanIDRAM_wr : coverpoint vlanIDRAM.value[3:0];
        sppRAM_wr : coverpoint sppRAM.value[1:0];
        useDefKeyRAM_wr : coverpoint useDefKeyRAM.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRCNTRLREG_rd_cg";
        newRead_rd : coverpoint newRead.value[0:0];
        newWrite_rd : coverpoint newWrite.value[0:0];
        newSearch_rd : coverpoint newSearch.value[0:0];
        searchError_rd : coverpoint searchError.value[0:0];
        keyIndexRAM_rd : coverpoint keyIndexRAM.value[9:0];
        cLenRAM_rd : coverpoint cLenRAM.value[1:0];
        cTypeRAM_rd : coverpoint cTypeRAM.value[2:0];
        vlanIDRAM_rd : coverpoint vlanIDRAM.value[3:0];
        sppRAM_rd : coverpoint sppRAM.value[1:0];
        useDefKeyRAM_rd : coverpoint useDefKeyRAM.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRCNTRLREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRWPIINTKEY0REG
//--------------------------------------------------------------------
class ENCRWPIINTKEY0REG extends uvm_reg;
    `uvm_object_utils(ENCRWPIINTKEY0REG)
    rand uvm_reg_field encrIntKeyRAMWord0;

    //---build------------------------------------------------------------
    virtual function void build();
        encrIntKeyRAMWord0 = uvm_reg_field::type_id::create("encrIntKeyRAMWord0");

        encrIntKeyRAMWord0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRWPIINTKEY0REG_wr_cg";
        encrIntKeyRAMWord0_wr : coverpoint encrIntKeyRAMWord0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRWPIINTKEY0REG_rd_cg";
        encrIntKeyRAMWord0_rd : coverpoint encrIntKeyRAMWord0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRWPIINTKEY0REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRWPIINTKEY1REG
//--------------------------------------------------------------------
class ENCRWPIINTKEY1REG extends uvm_reg;
    `uvm_object_utils(ENCRWPIINTKEY1REG)
    rand uvm_reg_field encrIntKeyRAMWord1;

    //---build------------------------------------------------------------
    virtual function void build();
        encrIntKeyRAMWord1 = uvm_reg_field::type_id::create("encrIntKeyRAMWord1");

        encrIntKeyRAMWord1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRWPIINTKEY1REG_wr_cg";
        encrIntKeyRAMWord1_wr : coverpoint encrIntKeyRAMWord1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRWPIINTKEY1REG_rd_cg";
        encrIntKeyRAMWord1_rd : coverpoint encrIntKeyRAMWord1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRWPIINTKEY1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRWPIINTKEY2REG
//--------------------------------------------------------------------
class ENCRWPIINTKEY2REG extends uvm_reg;
    `uvm_object_utils(ENCRWPIINTKEY2REG)
    rand uvm_reg_field encrIntKeyRAMWord2;

    //---build------------------------------------------------------------
    virtual function void build();
        encrIntKeyRAMWord2 = uvm_reg_field::type_id::create("encrIntKeyRAMWord2");

        encrIntKeyRAMWord2.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRWPIINTKEY2REG_wr_cg";
        encrIntKeyRAMWord2_wr : coverpoint encrIntKeyRAMWord2.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRWPIINTKEY2REG_rd_cg";
        encrIntKeyRAMWord2_rd : coverpoint encrIntKeyRAMWord2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRWPIINTKEY2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRWPIINTKEY3REG
//--------------------------------------------------------------------
class ENCRWPIINTKEY3REG extends uvm_reg;
    `uvm_object_utils(ENCRWPIINTKEY3REG)
    rand uvm_reg_field encrIntKeyRAMWord3;

    //---build------------------------------------------------------------
    virtual function void build();
        encrIntKeyRAMWord3 = uvm_reg_field::type_id::create("encrIntKeyRAMWord3");

        encrIntKeyRAMWord3.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRWPIINTKEY3REG_wr_cg";
        encrIntKeyRAMWord3_wr : coverpoint encrIntKeyRAMWord3.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRWPIINTKEY3REG_rd_cg";
        encrIntKeyRAMWord3_rd : coverpoint encrIntKeyRAMWord3.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRWPIINTKEY3REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ENCRRAMCONFIGREG
//--------------------------------------------------------------------
class ENCRRAMCONFIGREG extends uvm_reg;
    `uvm_object_utils(ENCRRAMCONFIGREG)
    rand uvm_reg_field staKeyMaxIndex;
    rand uvm_reg_field nVAP;
    rand uvm_reg_field staKeyEndIndex;
    rand uvm_reg_field staKeyStartIndex;

    //---build------------------------------------------------------------
    virtual function void build();
        staKeyMaxIndex = uvm_reg_field::type_id::create("staKeyMaxIndex");
        nVAP = uvm_reg_field::type_id::create("nVAP");
        staKeyEndIndex = uvm_reg_field::type_id::create("staKeyEndIndex");
        staKeyStartIndex = uvm_reg_field::type_id::create("staKeyStartIndex");

        staKeyMaxIndex.configure(this, 8, 24, "RO", 1, `RW_KEY_INDEX_MAX, 1, 1, 1);
        nVAP.configure(this, 4, 16, "RW", 1, `RW_KEY_NVAP, 1, 1, 1);
        staKeyEndIndex.configure(this, 8, 8, "RW", 1, `RW_KEY_INDEX_MAX, 1, 1, 1);
        staKeyStartIndex.configure(this, 8, 0, "RW", 1, `RW_KEY_NVAP*4, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRRAMCONFIGREG_wr_cg";
        nVAP_wr : coverpoint nVAP.value[3:0];
        staKeyEndIndex_wr : coverpoint staKeyEndIndex.value[7:0];
        staKeyStartIndex_wr : coverpoint staKeyStartIndex.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ENCRRAMCONFIGREG_rd_cg";
        staKeyMaxIndex_rd : coverpoint staKeyMaxIndex.value[7:0];
        nVAP_rd : coverpoint nVAP.value[3:0];
        staKeyEndIndex_rd : coverpoint staKeyEndIndex.value[7:0];
        staKeyStartIndex_rd : coverpoint staKeyStartIndex.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ENCRRAMCONFIGREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RATESREG
//--------------------------------------------------------------------
class RATESREG extends uvm_reg;
    `uvm_object_utils(RATESREG)
    rand uvm_reg_field bssBasicRateSet;

    //---build------------------------------------------------------------
    virtual function void build();
        bssBasicRateSet = uvm_reg_field::type_id::create("bssBasicRateSet");

        bssBasicRateSet.configure(this, 12, 0, "RW", 1, 'b00101010000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_RATESREG_wr_cg";
        bssBasicRateSet_wr : coverpoint bssBasicRateSet.value[11:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_RATESREG_rd_cg";
        bssBasicRateSet_rd : coverpoint bssBasicRateSet.value[11:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RATESREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// OLBCREG
//--------------------------------------------------------------------
class OLBCREG extends uvm_reg;
    `uvm_object_utils(OLBCREG)
    rand uvm_reg_field dsssCount;
    rand uvm_reg_field ofdmCount;
    rand uvm_reg_field olbcTimer;

    //---build------------------------------------------------------------
    virtual function void build();
        dsssCount = uvm_reg_field::type_id::create("dsssCount");
        ofdmCount = uvm_reg_field::type_id::create("ofdmCount");
        olbcTimer = uvm_reg_field::type_id::create("olbcTimer");

        dsssCount.configure(this, 8, 24, "RW", 1, 'b0000000, 1, 1, 1);
        ofdmCount.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        olbcTimer.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_OLBCREG_wr_cg";
        dsssCount_wr : coverpoint dsssCount.value[7:0];
        ofdmCount_wr : coverpoint ofdmCount.value[7:0];
        olbcTimer_wr : coverpoint olbcTimer.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_OLBCREG_rd_cg";
        dsssCount_rd : coverpoint dsssCount.value[7:0];
        ofdmCount_rd : coverpoint ofdmCount.value[7:0];
        olbcTimer_rd : coverpoint olbcTimer.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "OLBCREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMINGS1REG
//--------------------------------------------------------------------
class TIMINGS1REG extends uvm_reg;
    `uvm_object_utils(TIMINGS1REG)
    rand uvm_reg_field txChainDelayInMACClk;
    rand uvm_reg_field txRFDelayInMACClk;
    rand uvm_reg_field macCoreClkFreq;

    //---build------------------------------------------------------------
    virtual function void build();
        txChainDelayInMACClk = uvm_reg_field::type_id::create("txChainDelayInMACClk");
        txRFDelayInMACClk = uvm_reg_field::type_id::create("txRFDelayInMACClk");
        macCoreClkFreq = uvm_reg_field::type_id::create("macCoreClkFreq");

        txChainDelayInMACClk.configure(this, 10, 18, "RW", 1, `TX_CHAIN_DLY * 10'd`MAC_FREQ, 1, 1, 1);
        txRFDelayInMACClk.configure(this, 10, 8, "RW", 1, `TX_RF_DLY * 10'd`MAC_FREQ, 1, 1, 1);
        macCoreClkFreq.configure(this, 8, 0, "RW", 1, `MAC_FREQ, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS1REG_wr_cg";
        txChainDelayInMACClk_wr : coverpoint txChainDelayInMACClk.value[9:0];
        txRFDelayInMACClk_wr : coverpoint txRFDelayInMACClk.value[9:0];
        macCoreClkFreq_wr : coverpoint macCoreClkFreq.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS1REG_rd_cg";
        txChainDelayInMACClk_rd : coverpoint txChainDelayInMACClk.value[9:0];
        txRFDelayInMACClk_rd : coverpoint txRFDelayInMACClk.value[9:0];
        macCoreClkFreq_rd : coverpoint macCoreClkFreq.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMINGS1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMINGS2REG
//--------------------------------------------------------------------
class TIMINGS2REG extends uvm_reg;
    `uvm_object_utils(TIMINGS2REG)
    rand uvm_reg_field slotTimeInMACClk;
    rand uvm_reg_field slotTime;

    //---build------------------------------------------------------------
    virtual function void build();
        slotTimeInMACClk = uvm_reg_field::type_id::create("slotTimeInMACClk");
        slotTime = uvm_reg_field::type_id::create("slotTime");

        slotTimeInMACClk.configure(this, 16, 8, "RW", 1, `SHORT_SLOT * 16'd`MAC_FREQ, 1, 1, 1);
        slotTime.configure(this, 8, 0, "RW", 1, `SHORT_SLOT, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS2REG_wr_cg";
        slotTimeInMACClk_wr : coverpoint slotTimeInMACClk.value[15:0];
        slotTime_wr : coverpoint slotTime.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS2REG_rd_cg";
        slotTimeInMACClk_rd : coverpoint slotTimeInMACClk.value[15:0];
        slotTime_rd : coverpoint slotTime.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMINGS2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMINGS3REG
//--------------------------------------------------------------------
class TIMINGS3REG extends uvm_reg;
    `uvm_object_utils(TIMINGS3REG)
    rand uvm_reg_field rxRFDelayInMACClk;
    rand uvm_reg_field macProcDelayInMACClk;

    //---build------------------------------------------------------------
    virtual function void build();
        rxRFDelayInMACClk = uvm_reg_field::type_id::create("rxRFDelayInMACClk");
        macProcDelayInMACClk = uvm_reg_field::type_id::create("macProcDelayInMACClk");

        rxRFDelayInMACClk.configure(this, 10, 20, "RW", 1, `RX_RF_DLY * 10'd`MAC_FREQ, 1, 1, 1);
        macProcDelayInMACClk.configure(this, 10, 0, "RW", 1, `MAC_PROC_DELAY * 10'd`MAC_FREQ, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS3REG_wr_cg";
        rxRFDelayInMACClk_wr : coverpoint rxRFDelayInMACClk.value[9:0];
        macProcDelayInMACClk_wr : coverpoint macProcDelayInMACClk.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS3REG_rd_cg";
        rxRFDelayInMACClk_rd : coverpoint rxRFDelayInMACClk.value[9:0];
        macProcDelayInMACClk_rd : coverpoint macProcDelayInMACClk.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMINGS3REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMINGS4REG
//--------------------------------------------------------------------
class TIMINGS4REG extends uvm_reg;
    `uvm_object_utils(TIMINGS4REG)
    rand uvm_reg_field radioWakeUpTime;
    rand uvm_reg_field radioChirpTime;
    rand uvm_reg_field wt2CryptClkRatio;

    //---build------------------------------------------------------------
    virtual function void build();
        radioWakeUpTime = uvm_reg_field::type_id::create("radioWakeUpTime");
        radioChirpTime = uvm_reg_field::type_id::create("radioChirpTime");
        wt2CryptClkRatio = uvm_reg_field::type_id::create("wt2CryptClkRatio");

        radioWakeUpTime.configure(this, 10, 22, "RW", 1, `RADIOWAKEUP_TIME, 1, 1, 1);
        radioChirpTime.configure(this, 10, 12, "RW", 1, `RADIO_CHIRP_TIME, 1, 1, 1);
        wt2CryptClkRatio.configure(this, 2, 0, "RW", 1, `WEP_2_BB_CLK_RATIO, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS4REG_wr_cg";
        radioWakeUpTime_wr : coverpoint radioWakeUpTime.value[9:0];
        radioChirpTime_wr : coverpoint radioChirpTime.value[9:0];
        wt2CryptClkRatio_wr : coverpoint wt2CryptClkRatio.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS4REG_rd_cg";
        radioWakeUpTime_rd : coverpoint radioWakeUpTime.value[9:0];
        radioChirpTime_rd : coverpoint radioChirpTime.value[9:0];
        wt2CryptClkRatio_rd : coverpoint wt2CryptClkRatio.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMINGS4REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMINGS5REG
//--------------------------------------------------------------------
class TIMINGS5REG extends uvm_reg;
    `uvm_object_utils(TIMINGS5REG)
    rand uvm_reg_field sifsBInMACClk;
    rand uvm_reg_field sifsB;

    //---build------------------------------------------------------------
    virtual function void build();
        sifsBInMACClk = uvm_reg_field::type_id::create("sifsBInMACClk");
        sifsB = uvm_reg_field::type_id::create("sifsB");

        sifsBInMACClk.configure(this, 16, 8, "RW", 1, `SIFS_B * 16'd`MAC_FREQ, 1, 1, 1);
        sifsB.configure(this, 8, 0, "RW", 1, `SIFS_B, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS5REG_wr_cg";
        sifsBInMACClk_wr : coverpoint sifsBInMACClk.value[15:0];
        sifsB_wr : coverpoint sifsB.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS5REG_rd_cg";
        sifsBInMACClk_rd : coverpoint sifsBInMACClk.value[15:0];
        sifsB_rd : coverpoint sifsB.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMINGS5REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMINGS6REG
//--------------------------------------------------------------------
class TIMINGS6REG extends uvm_reg;
    `uvm_object_utils(TIMINGS6REG)
    rand uvm_reg_field sifsAInMACClk;
    rand uvm_reg_field sifsA;

    //---build------------------------------------------------------------
    virtual function void build();
        sifsAInMACClk = uvm_reg_field::type_id::create("sifsAInMACClk");
        sifsA = uvm_reg_field::type_id::create("sifsA");

        sifsAInMACClk.configure(this, 16, 8, "RW", 1, `SIFS_A* 16'd`MAC_FREQ, 1, 1, 1);
        sifsA.configure(this, 8, 0, "RW", 1, `SIFS_A, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS6REG_wr_cg";
        sifsAInMACClk_wr : coverpoint sifsAInMACClk.value[15:0];
        sifsA_wr : coverpoint sifsA.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS6REG_rd_cg";
        sifsAInMACClk_rd : coverpoint sifsAInMACClk.value[15:0];
        sifsA_rd : coverpoint sifsA.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMINGS6REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMINGS7REG
//--------------------------------------------------------------------
class TIMINGS7REG extends uvm_reg;
    `uvm_object_utils(TIMINGS7REG)
    rand uvm_reg_field rxCCADelay;

    //---build------------------------------------------------------------
    virtual function void build();
        rxCCADelay = uvm_reg_field::type_id::create("rxCCADelay");

        rxCCADelay.configure(this, 4, 8, "RW", 1, `RX_CCA_DLY, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS7REG_wr_cg";
        rxCCADelay_wr : coverpoint rxCCADelay.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS7REG_rd_cg";
        rxCCADelay_rd : coverpoint rxCCADelay.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMINGS7REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMINGS8REG
//--------------------------------------------------------------------
class TIMINGS8REG extends uvm_reg;
    `uvm_object_utils(TIMINGS8REG)
    rand uvm_reg_field rxStartDelayMIMO;
    rand uvm_reg_field rxStartDelayShort;
    rand uvm_reg_field rxStartDelayLong;
    rand uvm_reg_field rxStartDelayOFDM;

    //---build------------------------------------------------------------
    virtual function void build();
        rxStartDelayMIMO = uvm_reg_field::type_id::create("rxStartDelayMIMO");
        rxStartDelayShort = uvm_reg_field::type_id::create("rxStartDelayShort");
        rxStartDelayLong = uvm_reg_field::type_id::create("rxStartDelayLong");
        rxStartDelayOFDM = uvm_reg_field::type_id::create("rxStartDelayOFDM");

        rxStartDelayMIMO.configure(this, 8, 24, "RW", 1, 'b0100001, 1, 1, 1);
        rxStartDelayShort.configure(this, 8, 16, "RW", 1, 'b1100110, 1, 1, 1);
        rxStartDelayLong.configure(this, 8, 8, "RW", 1, 'b11000110, 1, 1, 1);
        rxStartDelayOFDM.configure(this, 8, 0, "RW", 1, 'b0100001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS8REG_wr_cg";
        rxStartDelayMIMO_wr : coverpoint rxStartDelayMIMO.value[7:0];
        rxStartDelayShort_wr : coverpoint rxStartDelayShort.value[7:0];
        rxStartDelayLong_wr : coverpoint rxStartDelayLong.value[7:0];
        rxStartDelayOFDM_wr : coverpoint rxStartDelayOFDM.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS8REG_rd_cg";
        rxStartDelayMIMO_rd : coverpoint rxStartDelayMIMO.value[7:0];
        rxStartDelayShort_rd : coverpoint rxStartDelayShort.value[7:0];
        rxStartDelayLong_rd : coverpoint rxStartDelayLong.value[7:0];
        rxStartDelayOFDM_rd : coverpoint rxStartDelayOFDM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMINGS8REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMINGS9REG
//--------------------------------------------------------------------
class TIMINGS9REG extends uvm_reg;
    `uvm_object_utils(TIMINGS9REG)
    rand uvm_reg_field rifsTOInMACClk;
    rand uvm_reg_field txDMAProcDlyInMACClk;

    //---build------------------------------------------------------------
    virtual function void build();
        rifsTOInMACClk = uvm_reg_field::type_id::create("rifsTOInMACClk");
        txDMAProcDlyInMACClk = uvm_reg_field::type_id::create("txDMAProcDlyInMACClk");

        rifsTOInMACClk.configure(this, 10, 20, "RW", 1, `RIFSTO * 10'd`MAC_FREQ, 1, 1, 1);
        txDMAProcDlyInMACClk.configure(this, 10, 0, "RW", 1, `TX_DMA_PROC_DLY * 10'd`MAC_FREQ, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS9REG_wr_cg";
        rifsTOInMACClk_wr : coverpoint rifsTOInMACClk.value[9:0];
        txDMAProcDlyInMACClk_wr : coverpoint txDMAProcDlyInMACClk.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TIMINGS9REG_rd_cg";
        rifsTOInMACClk_rd : coverpoint rifsTOInMACClk.value[9:0];
        txDMAProcDlyInMACClk_rd : coverpoint txDMAProcDlyInMACClk.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMINGS9REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXCNTRL2
//--------------------------------------------------------------------
class RXCNTRL2 extends uvm_reg;
    `uvm_object_utils(RXCNTRL2)
    rand uvm_reg_field disableRxBuffer2;
    rand uvm_reg_field dataMHStoredwithPld;
    rand uvm_reg_field mgtMHStoredwithPld;
    rand uvm_reg_field ctrlMHStoredwithPld;
    rand uvm_reg_field partialUnwrapSize;
    rand uvm_reg_field dataFrmWrapMode;
    rand uvm_reg_field mgtFrmWrapMode;
    rand uvm_reg_field ctrlFrmWrapMode;

    //---build------------------------------------------------------------
    virtual function void build();
        disableRxBuffer2 = uvm_reg_field::type_id::create("disableRxBuffer2");
        dataMHStoredwithPld = uvm_reg_field::type_id::create("dataMHStoredwithPld");
        mgtMHStoredwithPld = uvm_reg_field::type_id::create("mgtMHStoredwithPld");
        ctrlMHStoredwithPld = uvm_reg_field::type_id::create("ctrlMHStoredwithPld");
        partialUnwrapSize = uvm_reg_field::type_id::create("partialUnwrapSize");
        dataFrmWrapMode = uvm_reg_field::type_id::create("dataFrmWrapMode");
        mgtFrmWrapMode = uvm_reg_field::type_id::create("mgtFrmWrapMode");
        ctrlFrmWrapMode = uvm_reg_field::type_id::create("ctrlFrmWrapMode");

        disableRxBuffer2.configure(this, 1, 19, "RW", 1, 'b0, 1, 1, 1);
        dataMHStoredwithPld.configure(this, 1, 18, "RW", 1, 'b0, 1, 1, 1);
        mgtMHStoredwithPld.configure(this, 1, 17, "RW", 1, 'b1, 1, 1, 1);
        ctrlMHStoredwithPld.configure(this, 1, 16, "RW", 1, 'b1, 1, 1, 1);
        partialUnwrapSize.configure(this, 8, 8, "RW", 1, 'b0110010, 1, 1, 1);
        dataFrmWrapMode.configure(this, 2, 4, "RW", 1, 'b10, 1, 1, 1);
        mgtFrmWrapMode.configure(this, 2, 2, "RW", 1, 'b1, 1, 1, 1);
        ctrlFrmWrapMode.configure(this, 2, 0, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_RXCNTRL2_wr_cg";
        disableRxBuffer2_wr : coverpoint disableRxBuffer2.value[0:0];
        dataMHStoredwithPld_wr : coverpoint dataMHStoredwithPld.value[0:0];
        mgtMHStoredwithPld_wr : coverpoint mgtMHStoredwithPld.value[0:0];
        ctrlMHStoredwithPld_wr : coverpoint ctrlMHStoredwithPld.value[0:0];
        partialUnwrapSize_wr : coverpoint partialUnwrapSize.value[7:0];
        dataFrmWrapMode_wr : coverpoint dataFrmWrapMode.value[1:0];
        mgtFrmWrapMode_wr : coverpoint mgtFrmWrapMode.value[1:0];
        ctrlFrmWrapMode_wr : coverpoint ctrlFrmWrapMode.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_RXCNTRL2_rd_cg";
        disableRxBuffer2_rd : coverpoint disableRxBuffer2.value[0:0];
        dataMHStoredwithPld_rd : coverpoint dataMHStoredwithPld.value[0:0];
        mgtMHStoredwithPld_rd : coverpoint mgtMHStoredwithPld.value[0:0];
        ctrlMHStoredwithPld_rd : coverpoint ctrlMHStoredwithPld.value[0:0];
        partialUnwrapSize_rd : coverpoint partialUnwrapSize.value[7:0];
        dataFrmWrapMode_rd : coverpoint dataFrmWrapMode.value[1:0];
        mgtFrmWrapMode_rd : coverpoint mgtFrmWrapMode.value[1:0];
        ctrlFrmWrapMode_rd : coverpoint ctrlFrmWrapMode.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXCNTRL2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXTRIGGERTIMERREG
//--------------------------------------------------------------------
class TXTRIGGERTIMERREG extends uvm_reg;
    `uvm_object_utils(TXTRIGGERTIMERREG)
    rand uvm_reg_field txPacketTimeout;
    rand uvm_reg_field txAbsoluteTimeout;

    //---build------------------------------------------------------------
    virtual function void build();
        txPacketTimeout = uvm_reg_field::type_id::create("txPacketTimeout");
        txAbsoluteTimeout = uvm_reg_field::type_id::create("txAbsoluteTimeout");

        txPacketTimeout.configure(this, 8, 8, "RW", 1, 'b0001111, 1, 1, 1);
        txAbsoluteTimeout.configure(this, 8, 0, "RW", 1, 'b10011100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TXTRIGGERTIMERREG_wr_cg";
        txPacketTimeout_wr : coverpoint txPacketTimeout.value[7:0];
        txAbsoluteTimeout_wr : coverpoint txAbsoluteTimeout.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TXTRIGGERTIMERREG_rd_cg";
        txPacketTimeout_rd : coverpoint txPacketTimeout.value[7:0];
        txAbsoluteTimeout_rd : coverpoint txAbsoluteTimeout.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXTRIGGERTIMERREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXTRIGGERTIMERREG
//--------------------------------------------------------------------
class RXTRIGGERTIMERREG extends uvm_reg;
    `uvm_object_utils(RXTRIGGERTIMERREG)
    rand uvm_reg_field rxPacketTimeout;
    rand uvm_reg_field rxAbsoluteTimeout;

    //---build------------------------------------------------------------
    virtual function void build();
        rxPacketTimeout = uvm_reg_field::type_id::create("rxPacketTimeout");
        rxAbsoluteTimeout = uvm_reg_field::type_id::create("rxAbsoluteTimeout");

        rxPacketTimeout.configure(this, 8, 8, "RW", 1, 'b0001111, 1, 1, 1);
        rxAbsoluteTimeout.configure(this, 8, 0, "RW", 1, 'b10011100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_RXTRIGGERTIMERREG_wr_cg";
        rxPacketTimeout_wr : coverpoint rxPacketTimeout.value[7:0];
        rxAbsoluteTimeout_wr : coverpoint rxAbsoluteTimeout.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_RXTRIGGERTIMERREG_rd_cg";
        rxPacketTimeout_rd : coverpoint rxPacketTimeout.value[7:0];
        rxAbsoluteTimeout_rd : coverpoint rxAbsoluteTimeout.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXTRIGGERTIMERREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MIBTABLEWRITEREG
//--------------------------------------------------------------------
class MIBTABLEWRITEREG extends uvm_reg;
    `uvm_object_utils(MIBTABLEWRITEREG)
    rand uvm_reg_field mibValue;
    rand uvm_reg_field mibWrite;
    rand uvm_reg_field mibIncrementMode;
    rand uvm_reg_field mibTableIndex;

    //---build------------------------------------------------------------
    virtual function void build();
        mibValue = uvm_reg_field::type_id::create("mibValue");
        mibWrite = uvm_reg_field::type_id::create("mibWrite");
        mibIncrementMode = uvm_reg_field::type_id::create("mibIncrementMode");
        mibTableIndex = uvm_reg_field::type_id::create("mibTableIndex");

        mibValue.configure(this, 16, 16, "RW", 1, 'b000000000000000, 1, 1, 1);
        mibWrite.configure(this, 1, 15, "RW", 1, 'b0, 1, 1, 1);
        mibIncrementMode.configure(this, 1, 14, "RW", 1, 'b1, 1, 1, 1);
        mibTableIndex.configure(this, 10, 0, "RW", 1, 'b000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MIBTABLEWRITEREG_wr_cg";
        mibValue_wr : coverpoint mibValue.value[15:0];
        mibWrite_wr : coverpoint mibWrite.value[0:0];
        mibIncrementMode_wr : coverpoint mibIncrementMode.value[0:0];
        mibTableIndex_wr : coverpoint mibTableIndex.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MIBTABLEWRITEREG_rd_cg";
        mibValue_rd : coverpoint mibValue.value[15:0];
        mibWrite_rd : coverpoint mibWrite.value[0:0];
        mibIncrementMode_rd : coverpoint mibIncrementMode.value[0:0];
        mibTableIndex_rd : coverpoint mibTableIndex.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MIBTABLEWRITEREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MONOTONICCOUNTER1REG
//--------------------------------------------------------------------
class MONOTONICCOUNTER1REG extends uvm_reg;
    `uvm_object_utils(MONOTONICCOUNTER1REG)
    rand uvm_reg_field monotonicCounter1;

    //---build------------------------------------------------------------
    virtual function void build();
        monotonicCounter1 = uvm_reg_field::type_id::create("monotonicCounter1");

        monotonicCounter1.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MONOTONICCOUNTER1REG_rd_cg";
        monotonicCounter1_rd : coverpoint monotonicCounter1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MONOTONICCOUNTER1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MONOTONICCOUNTER2LOREG
//--------------------------------------------------------------------
class MONOTONICCOUNTER2LOREG extends uvm_reg;
    `uvm_object_utils(MONOTONICCOUNTER2LOREG)
    rand uvm_reg_field monotonicCounterLow2;

    //---build------------------------------------------------------------
    virtual function void build();
        monotonicCounterLow2 = uvm_reg_field::type_id::create("monotonicCounterLow2");

        monotonicCounterLow2.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MONOTONICCOUNTER2LOREG_wr_cg";
        monotonicCounterLow2_wr : coverpoint monotonicCounterLow2.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MONOTONICCOUNTER2LOREG_rd_cg";
        monotonicCounterLow2_rd : coverpoint monotonicCounterLow2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MONOTONICCOUNTER2LOREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MONOTONICCOUNTER2HIREG
//--------------------------------------------------------------------
class MONOTONICCOUNTER2HIREG extends uvm_reg;
    `uvm_object_utils(MONOTONICCOUNTER2HIREG)
    rand uvm_reg_field monotonicCounter2SWUpdate;
    rand uvm_reg_field monotonicCounterHigh2;

    //---build------------------------------------------------------------
    virtual function void build();
        monotonicCounter2SWUpdate = uvm_reg_field::type_id::create("monotonicCounter2SWUpdate");
        monotonicCounterHigh2 = uvm_reg_field::type_id::create("monotonicCounterHigh2");

        monotonicCounter2SWUpdate.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        monotonicCounterHigh2.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MONOTONICCOUNTER2HIREG_wr_cg";
        monotonicCounter2SWUpdate_wr : coverpoint monotonicCounter2SWUpdate.value[0:0];
        monotonicCounterHigh2_wr : coverpoint monotonicCounterHigh2.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MONOTONICCOUNTER2HIREG_rd_cg";
        monotonicCounter2SWUpdate_rd : coverpoint monotonicCounter2SWUpdate.value[0:0];
        monotonicCounterHigh2_rd : coverpoint monotonicCounterHigh2.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MONOTONICCOUNTER2HIREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ABSTIMERREG0
//--------------------------------------------------------------------
class ABSTIMERREG0 extends uvm_reg;
    `uvm_object_utils(ABSTIMERREG0)
    rand uvm_reg_field absTimerValue0;

    //---build------------------------------------------------------------
    virtual function void build();
        absTimerValue0 = uvm_reg_field::type_id::create("absTimerValue0");

        absTimerValue0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG0_wr_cg";
        absTimerValue0_wr : coverpoint absTimerValue0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG0_rd_cg";
        absTimerValue0_rd : coverpoint absTimerValue0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ABSTIMERREG0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ABSTIMERREG1
//--------------------------------------------------------------------
class ABSTIMERREG1 extends uvm_reg;
    `uvm_object_utils(ABSTIMERREG1)
    rand uvm_reg_field absTimerValue1;

    //---build------------------------------------------------------------
    virtual function void build();
        absTimerValue1 = uvm_reg_field::type_id::create("absTimerValue1");

        absTimerValue1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG1_wr_cg";
        absTimerValue1_wr : coverpoint absTimerValue1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG1_rd_cg";
        absTimerValue1_rd : coverpoint absTimerValue1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ABSTIMERREG1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ABSTIMERREG2
//--------------------------------------------------------------------
class ABSTIMERREG2 extends uvm_reg;
    `uvm_object_utils(ABSTIMERREG2)
    rand uvm_reg_field absTimerValue2;

    //---build------------------------------------------------------------
    virtual function void build();
        absTimerValue2 = uvm_reg_field::type_id::create("absTimerValue2");

        absTimerValue2.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG2_wr_cg";
        absTimerValue2_wr : coverpoint absTimerValue2.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG2_rd_cg";
        absTimerValue2_rd : coverpoint absTimerValue2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ABSTIMERREG2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ABSTIMERREG3
//--------------------------------------------------------------------
class ABSTIMERREG3 extends uvm_reg;
    `uvm_object_utils(ABSTIMERREG3)
    rand uvm_reg_field absTimerValue3;

    //---build------------------------------------------------------------
    virtual function void build();
        absTimerValue3 = uvm_reg_field::type_id::create("absTimerValue3");

        absTimerValue3.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG3_wr_cg";
        absTimerValue3_wr : coverpoint absTimerValue3.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG3_rd_cg";
        absTimerValue3_rd : coverpoint absTimerValue3.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ABSTIMERREG3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ABSTIMERREG4
//--------------------------------------------------------------------
class ABSTIMERREG4 extends uvm_reg;
    `uvm_object_utils(ABSTIMERREG4)
    rand uvm_reg_field absTimerValue4;

    //---build------------------------------------------------------------
    virtual function void build();
        absTimerValue4 = uvm_reg_field::type_id::create("absTimerValue4");

        absTimerValue4.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG4_wr_cg";
        absTimerValue4_wr : coverpoint absTimerValue4.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG4_rd_cg";
        absTimerValue4_rd : coverpoint absTimerValue4.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ABSTIMERREG4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ABSTIMERREG5
//--------------------------------------------------------------------
class ABSTIMERREG5 extends uvm_reg;
    `uvm_object_utils(ABSTIMERREG5)
    rand uvm_reg_field absTimerValue5;

    //---build------------------------------------------------------------
    virtual function void build();
        absTimerValue5 = uvm_reg_field::type_id::create("absTimerValue5");

        absTimerValue5.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG5_wr_cg";
        absTimerValue5_wr : coverpoint absTimerValue5.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG5_rd_cg";
        absTimerValue5_rd : coverpoint absTimerValue5.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ABSTIMERREG5");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ABSTIMERREG6
//--------------------------------------------------------------------
class ABSTIMERREG6 extends uvm_reg;
    `uvm_object_utils(ABSTIMERREG6)
    rand uvm_reg_field absTimerValue6;

    //---build------------------------------------------------------------
    virtual function void build();
        absTimerValue6 = uvm_reg_field::type_id::create("absTimerValue6");

        absTimerValue6.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG6_wr_cg";
        absTimerValue6_wr : coverpoint absTimerValue6.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG6_rd_cg";
        absTimerValue6_rd : coverpoint absTimerValue6.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ABSTIMERREG6");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ABSTIMERREG7
//--------------------------------------------------------------------
class ABSTIMERREG7 extends uvm_reg;
    `uvm_object_utils(ABSTIMERREG7)
    rand uvm_reg_field absTimerValue7;

    //---build------------------------------------------------------------
    virtual function void build();
        absTimerValue7 = uvm_reg_field::type_id::create("absTimerValue7");

        absTimerValue7.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG7_wr_cg";
        absTimerValue7_wr : coverpoint absTimerValue7.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG7_rd_cg";
        absTimerValue7_rd : coverpoint absTimerValue7.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ABSTIMERREG7");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ABSTIMERREG8
//--------------------------------------------------------------------
class ABSTIMERREG8 extends uvm_reg;
    `uvm_object_utils(ABSTIMERREG8)
    rand uvm_reg_field absTimerValue8;

    //---build------------------------------------------------------------
    virtual function void build();
        absTimerValue8 = uvm_reg_field::type_id::create("absTimerValue8");

        absTimerValue8.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG8_wr_cg";
        absTimerValue8_wr : coverpoint absTimerValue8.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG8_rd_cg";
        absTimerValue8_rd : coverpoint absTimerValue8.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ABSTIMERREG8");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ABSTIMERREG9
//--------------------------------------------------------------------
class ABSTIMERREG9 extends uvm_reg;
    `uvm_object_utils(ABSTIMERREG9)
    rand uvm_reg_field absTimerValue9;

    //---build------------------------------------------------------------
    virtual function void build();
        absTimerValue9 = uvm_reg_field::type_id::create("absTimerValue9");

        absTimerValue9.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG9_wr_cg";
        absTimerValue9_wr : coverpoint absTimerValue9.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ABSTIMERREG9_rd_cg";
        absTimerValue9_rd : coverpoint absTimerValue9.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ABSTIMERREG9");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MAXRXLENGTHREG
//--------------------------------------------------------------------
class MAXRXLENGTHREG extends uvm_reg;
    `uvm_object_utils(MAXRXLENGTHREG)
    rand uvm_reg_field maxAllowedLength;

    //---build------------------------------------------------------------
    virtual function void build();
        maxAllowedLength = uvm_reg_field::type_id::create("maxAllowedLength");

        maxAllowedLength.configure(this, 20, 0, "RW", 1, 'b0001111111111111111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_MAXRXLENGTHREG_wr_cg";
        maxAllowedLength_wr : coverpoint maxAllowedLength.value[19:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_MAXRXLENGTHREG_rd_cg";
        maxAllowedLength_rd : coverpoint maxAllowedLength.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MAXRXLENGTHREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EDCAAC0REG
//--------------------------------------------------------------------
class EDCAAC0REG extends uvm_reg;
    `uvm_object_utils(EDCAAC0REG)
    rand uvm_reg_field txOpLimit0;
    rand uvm_reg_field cwMax0;
    rand uvm_reg_field cwMin0;
    rand uvm_reg_field aifsn0;

    //---build------------------------------------------------------------
    virtual function void build();
        txOpLimit0 = uvm_reg_field::type_id::create("txOpLimit0");
        cwMax0 = uvm_reg_field::type_id::create("cwMax0");
        cwMin0 = uvm_reg_field::type_id::create("cwMin0");
        aifsn0 = uvm_reg_field::type_id::create("aifsn0");

        txOpLimit0.configure(this, 16, 12, "RW", 1, 'b000000000000000, 1, 1, 1);
        cwMax0.configure(this, 4, 8, "RW", 1, 'b1010, 1, 1, 1);
        cwMin0.configure(this, 4, 4, "RW", 1, 'b100, 1, 1, 1);
        aifsn0.configure(this, 4, 0, "RW", 1, 'b111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCAAC0REG_wr_cg";
        txOpLimit0_wr : coverpoint txOpLimit0.value[15:0];
        cwMax0_wr : coverpoint cwMax0.value[3:0];
        cwMin0_wr : coverpoint cwMin0.value[3:0];
        aifsn0_wr : coverpoint aifsn0.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCAAC0REG_rd_cg";
        txOpLimit0_rd : coverpoint txOpLimit0.value[15:0];
        cwMax0_rd : coverpoint cwMax0.value[3:0];
        cwMin0_rd : coverpoint cwMin0.value[3:0];
        aifsn0_rd : coverpoint aifsn0.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EDCAAC0REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EDCAAC1REG
//--------------------------------------------------------------------
class EDCAAC1REG extends uvm_reg;
    `uvm_object_utils(EDCAAC1REG)
    rand uvm_reg_field txOpLimit1;
    rand uvm_reg_field cwMax1;
    rand uvm_reg_field cwMin1;
    rand uvm_reg_field aifsn1;

    //---build------------------------------------------------------------
    virtual function void build();
        txOpLimit1 = uvm_reg_field::type_id::create("txOpLimit1");
        cwMax1 = uvm_reg_field::type_id::create("cwMax1");
        cwMin1 = uvm_reg_field::type_id::create("cwMin1");
        aifsn1 = uvm_reg_field::type_id::create("aifsn1");

        txOpLimit1.configure(this, 16, 12, "RW", 1, 'b000000000000000, 1, 1, 1);
        cwMax1.configure(this, 4, 8, "RW", 1, 'b1010, 1, 1, 1);
        cwMin1.configure(this, 4, 4, "RW", 1, 'b100, 1, 1, 1);
        aifsn1.configure(this, 4, 0, "RW", 1, 'b011, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCAAC1REG_wr_cg";
        txOpLimit1_wr : coverpoint txOpLimit1.value[15:0];
        cwMax1_wr : coverpoint cwMax1.value[3:0];
        cwMin1_wr : coverpoint cwMin1.value[3:0];
        aifsn1_wr : coverpoint aifsn1.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCAAC1REG_rd_cg";
        txOpLimit1_rd : coverpoint txOpLimit1.value[15:0];
        cwMax1_rd : coverpoint cwMax1.value[3:0];
        cwMin1_rd : coverpoint cwMin1.value[3:0];
        aifsn1_rd : coverpoint aifsn1.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EDCAAC1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EDCAAC2REG
//--------------------------------------------------------------------
class EDCAAC2REG extends uvm_reg;
    `uvm_object_utils(EDCAAC2REG)
    rand uvm_reg_field txOpLimit2;
    rand uvm_reg_field cwMax2;
    rand uvm_reg_field cwMin2;
    rand uvm_reg_field aifsn2;

    //---build------------------------------------------------------------
    virtual function void build();
        txOpLimit2 = uvm_reg_field::type_id::create("txOpLimit2");
        cwMax2 = uvm_reg_field::type_id::create("cwMax2");
        cwMin2 = uvm_reg_field::type_id::create("cwMin2");
        aifsn2 = uvm_reg_field::type_id::create("aifsn2");

        txOpLimit2.configure(this, 16, 12, "RW", 1, 'b000000001011110, 1, 1, 1);
        cwMax2.configure(this, 4, 8, "RW", 1, 'b100, 1, 1, 1);
        cwMin2.configure(this, 4, 4, "RW", 1, 'b011, 1, 1, 1);
        aifsn2.configure(this, 4, 0, "RW", 1, 'b010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCAAC2REG_wr_cg";
        txOpLimit2_wr : coverpoint txOpLimit2.value[15:0];
        cwMax2_wr : coverpoint cwMax2.value[3:0];
        cwMin2_wr : coverpoint cwMin2.value[3:0];
        aifsn2_wr : coverpoint aifsn2.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCAAC2REG_rd_cg";
        txOpLimit2_rd : coverpoint txOpLimit2.value[15:0];
        cwMax2_rd : coverpoint cwMax2.value[3:0];
        cwMin2_rd : coverpoint cwMin2.value[3:0];
        aifsn2_rd : coverpoint aifsn2.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EDCAAC2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EDCAAC3REG
//--------------------------------------------------------------------
class EDCAAC3REG extends uvm_reg;
    `uvm_object_utils(EDCAAC3REG)
    rand uvm_reg_field txOpLimit3;
    rand uvm_reg_field cwMax3;
    rand uvm_reg_field cwMin3;
    rand uvm_reg_field aifsn3;

    //---build------------------------------------------------------------
    virtual function void build();
        txOpLimit3 = uvm_reg_field::type_id::create("txOpLimit3");
        cwMax3 = uvm_reg_field::type_id::create("cwMax3");
        cwMin3 = uvm_reg_field::type_id::create("cwMin3");
        aifsn3 = uvm_reg_field::type_id::create("aifsn3");

        txOpLimit3.configure(this, 16, 12, "RW", 1, 'b000000000101111, 1, 1, 1);
        cwMax3.configure(this, 4, 8, "RW", 1, 'b011, 1, 1, 1);
        cwMin3.configure(this, 4, 4, "RW", 1, 'b010, 1, 1, 1);
        aifsn3.configure(this, 4, 0, "RW", 1, 'b010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCAAC3REG_wr_cg";
        txOpLimit3_wr : coverpoint txOpLimit3.value[15:0];
        cwMax3_wr : coverpoint cwMax3.value[3:0];
        cwMin3_wr : coverpoint cwMin3.value[3:0];
        aifsn3_wr : coverpoint aifsn3.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCAAC3REG_rd_cg";
        txOpLimit3_rd : coverpoint txOpLimit3.value[15:0];
        cwMax3_rd : coverpoint cwMax3.value[3:0];
        cwMin3_rd : coverpoint cwMin3.value[3:0];
        aifsn3_rd : coverpoint aifsn3.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EDCAAC3REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EDCACCABUSYREG
//--------------------------------------------------------------------
class EDCACCABUSYREG extends uvm_reg;
    `uvm_object_utils(EDCACCABUSYREG)
    rand uvm_reg_field ccaBusyDur;

    //---build------------------------------------------------------------
    virtual function void build();
        ccaBusyDur = uvm_reg_field::type_id::create("ccaBusyDur");

        ccaBusyDur.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCACCABUSYREG_wr_cg";
        ccaBusyDur_wr : coverpoint ccaBusyDur.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCACCABUSYREG_rd_cg";
        ccaBusyDur_rd : coverpoint ccaBusyDur.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EDCACCABUSYREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EDCACNTRLREG
//--------------------------------------------------------------------
class EDCACNTRLREG extends uvm_reg;
    `uvm_object_utils(EDCACNTRLREG)
    rand uvm_reg_field keepTXOPOpen;
    rand uvm_reg_field remTXOPInDurField;
    rand uvm_reg_field sendCFEnd;
    rand uvm_reg_field sendCFEndNow;

    //---build------------------------------------------------------------
    virtual function void build();
        keepTXOPOpen = uvm_reg_field::type_id::create("keepTXOPOpen");
        remTXOPInDurField = uvm_reg_field::type_id::create("remTXOPInDurField");
        sendCFEnd = uvm_reg_field::type_id::create("sendCFEnd");
        sendCFEndNow = uvm_reg_field::type_id::create("sendCFEndNow");

        keepTXOPOpen.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        remTXOPInDurField.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        sendCFEnd.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        sendCFEndNow.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCACNTRLREG_wr_cg";
        keepTXOPOpen_wr : coverpoint keepTXOPOpen.value[0:0];
        remTXOPInDurField_wr : coverpoint remTXOPInDurField.value[0:0];
        sendCFEnd_wr : coverpoint sendCFEnd.value[0:0];
        sendCFEndNow_wr : coverpoint sendCFEndNow.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_EDCACNTRLREG_rd_cg";
        keepTXOPOpen_rd : coverpoint keepTXOPOpen.value[0:0];
        remTXOPInDurField_rd : coverpoint remTXOPInDurField.value[0:0];
        sendCFEnd_rd : coverpoint sendCFEnd.value[0:0];
        sendCFEndNow_rd : coverpoint sendCFEndNow.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EDCACNTRLREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// QUIETELEMENT1AREG
//--------------------------------------------------------------------
class QUIETELEMENT1AREG extends uvm_reg;
    `uvm_object_utils(QUIETELEMENT1AREG)
    rand uvm_reg_field quietDuration1;
    rand uvm_reg_field quietPeriod1;
    rand uvm_reg_field quietCount1;

    //---build------------------------------------------------------------
    virtual function void build();
        quietDuration1 = uvm_reg_field::type_id::create("quietDuration1");
        quietPeriod1 = uvm_reg_field::type_id::create("quietPeriod1");
        quietCount1 = uvm_reg_field::type_id::create("quietCount1");

        quietDuration1.configure(this, 16, 16, "RW", 1, 'b000000000000000, 1, 1, 1);
        quietPeriod1.configure(this, 8, 8, "RW", 1, 'b0000000, 1, 1, 1);
        quietCount1.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_QUIETELEMENT1AREG_wr_cg";
        quietDuration1_wr : coverpoint quietDuration1.value[15:0];
        quietPeriod1_wr : coverpoint quietPeriod1.value[7:0];
        quietCount1_wr : coverpoint quietCount1.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_QUIETELEMENT1AREG_rd_cg";
        quietDuration1_rd : coverpoint quietDuration1.value[15:0];
        quietPeriod1_rd : coverpoint quietPeriod1.value[7:0];
        quietCount1_rd : coverpoint quietCount1.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "QUIETELEMENT1AREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// QUIETELEMENT1BREG
//--------------------------------------------------------------------
class QUIETELEMENT1BREG extends uvm_reg;
    `uvm_object_utils(QUIETELEMENT1BREG)
    rand uvm_reg_field quietOffset1;

    //---build------------------------------------------------------------
    virtual function void build();
        quietOffset1 = uvm_reg_field::type_id::create("quietOffset1");

        quietOffset1.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_QUIETELEMENT1BREG_wr_cg";
        quietOffset1_wr : coverpoint quietOffset1.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_QUIETELEMENT1BREG_rd_cg";
        quietOffset1_rd : coverpoint quietOffset1.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "QUIETELEMENT1BREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ADDCCABUSYSEC20REG
//--------------------------------------------------------------------
class ADDCCABUSYSEC20REG extends uvm_reg;
    `uvm_object_utils(ADDCCABUSYSEC20REG)
    rand uvm_reg_field ccaBusyDurSec20;

    //---build------------------------------------------------------------
    virtual function void build();
        ccaBusyDurSec20 = uvm_reg_field::type_id::create("ccaBusyDurSec20");

        ccaBusyDurSec20.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ADDCCABUSYSEC20REG_wr_cg";
        ccaBusyDurSec20_wr : coverpoint ccaBusyDurSec20.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ADDCCABUSYSEC20REG_rd_cg";
        ccaBusyDurSec20_rd : coverpoint ccaBusyDurSec20.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ADDCCABUSYSEC20REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ADDCCABUSYSEC40REG
//--------------------------------------------------------------------
class ADDCCABUSYSEC40REG extends uvm_reg;
    `uvm_object_utils(ADDCCABUSYSEC40REG)
    rand uvm_reg_field ccaBusyDurSec40;

    //---build------------------------------------------------------------
    virtual function void build();
        ccaBusyDurSec40 = uvm_reg_field::type_id::create("ccaBusyDurSec40");

        ccaBusyDurSec40.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ADDCCABUSYSEC40REG_wr_cg";
        ccaBusyDurSec40_wr : coverpoint ccaBusyDurSec40.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ADDCCABUSYSEC40REG_rd_cg";
        ccaBusyDurSec40_rd : coverpoint ccaBusyDurSec40.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ADDCCABUSYSEC40REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// ADDCCABUSYSEC80REG
//--------------------------------------------------------------------
class ADDCCABUSYSEC80REG extends uvm_reg;
    `uvm_object_utils(ADDCCABUSYSEC80REG)
    rand uvm_reg_field ccaBusyDurSec80;

    //---build------------------------------------------------------------
    virtual function void build();
        ccaBusyDurSec80 = uvm_reg_field::type_id::create("ccaBusyDurSec80");

        ccaBusyDurSec80.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_ADDCCABUSYSEC80REG_wr_cg";
        ccaBusyDurSec80_wr : coverpoint ccaBusyDurSec80.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_ADDCCABUSYSEC80REG_rd_cg";
        ccaBusyDurSec80_rd : coverpoint ccaBusyDurSec80.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "ADDCCABUSYSEC80REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STBCCNTRLREG
//--------------------------------------------------------------------
class STBCCNTRLREG extends uvm_reg;
    `uvm_object_utils(STBCCNTRLREG)
    rand uvm_reg_field basicSTBCMCS;
    rand uvm_reg_field dualCTSProt;
    rand uvm_reg_field ctsSTBCDur;
    rand uvm_reg_field cfEndSTBCDur;

    //---build------------------------------------------------------------
    virtual function void build();
        basicSTBCMCS = uvm_reg_field::type_id::create("basicSTBCMCS");
        dualCTSProt = uvm_reg_field::type_id::create("dualCTSProt");
        ctsSTBCDur = uvm_reg_field::type_id::create("ctsSTBCDur");
        cfEndSTBCDur = uvm_reg_field::type_id::create("cfEndSTBCDur");

        basicSTBCMCS.configure(this, 7, 25, "RW", 1, 'b000000, 1, 1, 1);
        dualCTSProt.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        ctsSTBCDur.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        cfEndSTBCDur.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_STBCCNTRLREG_wr_cg";
        basicSTBCMCS_wr : coverpoint basicSTBCMCS.value[6:0];
        dualCTSProt_wr : coverpoint dualCTSProt.value[0:0];
        ctsSTBCDur_wr : coverpoint ctsSTBCDur.value[7:0];
        cfEndSTBCDur_wr : coverpoint cfEndSTBCDur.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_STBCCNTRLREG_rd_cg";
        basicSTBCMCS_rd : coverpoint basicSTBCMCS.value[6:0];
        dualCTSProt_rd : coverpoint dualCTSProt.value[0:0];
        ctsSTBCDur_rd : coverpoint ctsSTBCDur.value[7:0];
        cfEndSTBCDur_rd : coverpoint cfEndSTBCDur.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STBCCNTRLREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXBWCNTRLREG
//--------------------------------------------------------------------
class TXBWCNTRLREG extends uvm_reg;
    `uvm_object_utils(TXBWCNTRLREG)
    rand uvm_reg_field maxSupportedBW;
    rand uvm_reg_field aPPDUMaxTime;
    rand uvm_reg_field dynBWEn;
    rand uvm_reg_field numTryBWAcquisition;
    rand uvm_reg_field dropToLowerBW;
    rand uvm_reg_field defaultBWTXOP;
    rand uvm_reg_field defaultBWTXOPV;

    //---build------------------------------------------------------------
    virtual function void build();
        maxSupportedBW = uvm_reg_field::type_id::create("maxSupportedBW");
        aPPDUMaxTime = uvm_reg_field::type_id::create("aPPDUMaxTime");
        dynBWEn = uvm_reg_field::type_id::create("dynBWEn");
        numTryBWAcquisition = uvm_reg_field::type_id::create("numTryBWAcquisition");
        dropToLowerBW = uvm_reg_field::type_id::create("dropToLowerBW");
        defaultBWTXOP = uvm_reg_field::type_id::create("defaultBWTXOP");
        defaultBWTXOPV = uvm_reg_field::type_id::create("defaultBWTXOPV");

        maxSupportedBW.configure(this, 2, 16, "RW", 1, 'b0, 1, 1, 1);
        aPPDUMaxTime.configure(this, 8, 8, "RW", 1, 'b0001010, 1, 1, 1);
        dynBWEn.configure(this, 1, 7, "RW", 1, 'b0, 1, 1, 1);
        numTryBWAcquisition.configure(this, 3, 4, "RW", 1, 'b01, 1, 1, 1);
        dropToLowerBW.configure(this, 1, 3, "RW", 1, 'b1, 1, 1, 1);
        defaultBWTXOP.configure(this, 2, 1, "RW", 1, 'b0, 1, 1, 1);
        defaultBWTXOPV.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_TXBWCNTRLREG_wr_cg";
        maxSupportedBW_wr : coverpoint maxSupportedBW.value[1:0];
        aPPDUMaxTime_wr : coverpoint aPPDUMaxTime.value[7:0];
        dynBWEn_wr : coverpoint dynBWEn.value[0:0];
        numTryBWAcquisition_wr : coverpoint numTryBWAcquisition.value[2:0];
        dropToLowerBW_wr : coverpoint dropToLowerBW.value[0:0];
        defaultBWTXOP_wr : coverpoint defaultBWTXOP.value[1:0];
        defaultBWTXOPV_wr : coverpoint defaultBWTXOPV.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_TXBWCNTRLREG_rd_cg";
        maxSupportedBW_rd : coverpoint maxSupportedBW.value[1:0];
        aPPDUMaxTime_rd : coverpoint aPPDUMaxTime.value[7:0];
        dynBWEn_rd : coverpoint dynBWEn.value[0:0];
        numTryBWAcquisition_rd : coverpoint numTryBWAcquisition.value[2:0];
        dropToLowerBW_rd : coverpoint dropToLowerBW.value[0:0];
        defaultBWTXOP_rd : coverpoint defaultBWTXOP.value[1:0];
        defaultBWTXOPV_rd : coverpoint defaultBWTXOPV.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXBWCNTRLREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HTMCSREG
//--------------------------------------------------------------------
class HTMCSREG extends uvm_reg;
    `uvm_object_utils(HTMCSREG)
    rand uvm_reg_field bssBasicHTMCSSetUM;
    rand uvm_reg_field bssBasicHTMCSSetEM;

    //---build------------------------------------------------------------
    virtual function void build();
        bssBasicHTMCSSetUM = uvm_reg_field::type_id::create("bssBasicHTMCSSetUM");
        bssBasicHTMCSSetEM = uvm_reg_field::type_id::create("bssBasicHTMCSSetEM");

        bssBasicHTMCSSetUM.configure(this, 6, 16, "RW", 1, 'b00000, 1, 1, 1);
        bssBasicHTMCSSetEM.configure(this, 16, 0, "RW", 1, 'b1111111111111111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_HTMCSREG_wr_cg";
        bssBasicHTMCSSetUM_wr : coverpoint bssBasicHTMCSSetUM.value[5:0];
        bssBasicHTMCSSetEM_wr : coverpoint bssBasicHTMCSSetEM.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_HTMCSREG_rd_cg";
        bssBasicHTMCSSetUM_rd : coverpoint bssBasicHTMCSSetUM.value[5:0];
        bssBasicHTMCSSetEM_rd : coverpoint bssBasicHTMCSSetEM.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HTMCSREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// VHTMCSREG
//--------------------------------------------------------------------
class VHTMCSREG extends uvm_reg;
    `uvm_object_utils(VHTMCSREG)
    rand uvm_reg_field bssBasicVHTMCSSet;

    //---build------------------------------------------------------------
    virtual function void build();
        bssBasicVHTMCSSet = uvm_reg_field::type_id::create("bssBasicVHTMCSSet");

        bssBasicVHTMCSSet.configure(this, 16, 0, "RW", 1, 'b1111111111111111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_VHTMCSREG_wr_cg";
        bssBasicVHTMCSSet_wr : coverpoint bssBasicVHTMCSSet.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_VHTMCSREG_rd_cg";
        bssBasicVHTMCSSet_rd : coverpoint bssBasicVHTMCSSet.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "VHTMCSREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LSTPREG
//--------------------------------------------------------------------
class LSTPREG extends uvm_reg;
    `uvm_object_utils(LSTPREG)
    rand uvm_reg_field supportLSTP;

    //---build------------------------------------------------------------
    virtual function void build();
        supportLSTP = uvm_reg_field::type_id::create("supportLSTP");

        supportLSTP.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_LSTPREG_wr_cg";
        supportLSTP_wr : coverpoint supportLSTP.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_LSTPREG_rd_cg";
        supportLSTP_rd : coverpoint supportLSTP.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LSTPREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HECONFIGREG
//--------------------------------------------------------------------
class HECONFIGREG extends uvm_reg;
    `uvm_object_utils(HECONFIGREG)
    rand uvm_reg_field dcmSupport;
    rand uvm_reg_field dopplerSupport;
    rand uvm_reg_field enableOBSSPD;
    rand uvm_reg_field enableSRP;
    rand uvm_reg_field acceptAllTriggerFrames;
    rand uvm_reg_field acceptTriggerSWFrames;
    rand uvm_reg_field acceptTriggerHWFrames;
    rand uvm_reg_field disableTBUPH;
    rand uvm_reg_field disableTBRU26Resp;
    rand uvm_reg_field disableTBCS;
    rand uvm_reg_field disableTBResp;
    rand uvm_reg_field defaultPEDur;

    //---build------------------------------------------------------------
    virtual function void build();
        dcmSupport = uvm_reg_field::type_id::create("dcmSupport");
        dopplerSupport = uvm_reg_field::type_id::create("dopplerSupport");
        enableOBSSPD = uvm_reg_field::type_id::create("enableOBSSPD");
        enableSRP = uvm_reg_field::type_id::create("enableSRP");
        acceptAllTriggerFrames = uvm_reg_field::type_id::create("acceptAllTriggerFrames");
        acceptTriggerSWFrames = uvm_reg_field::type_id::create("acceptTriggerSWFrames");
        acceptTriggerHWFrames = uvm_reg_field::type_id::create("acceptTriggerHWFrames");
        disableTBUPH = uvm_reg_field::type_id::create("disableTBUPH");
        disableTBRU26Resp = uvm_reg_field::type_id::create("disableTBRU26Resp");
        disableTBCS = uvm_reg_field::type_id::create("disableTBCS");
        disableTBResp = uvm_reg_field::type_id::create("disableTBResp");
        defaultPEDur = uvm_reg_field::type_id::create("defaultPEDur");

        dcmSupport.configure(this, 1, 21, "RW", 1, 'b0, 1, 1, 1);
        dopplerSupport.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        enableOBSSPD.configure(this, 1, 17, "RW", 1, 'b0, 1, 1, 1);
        enableSRP.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        acceptAllTriggerFrames.configure(this, 1, 10, "RW", 1, 'b0, 1, 1, 1);
        acceptTriggerSWFrames.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        acceptTriggerHWFrames.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        disableTBUPH.configure(this, 1, 7, "RW", 1, 'b0, 1, 1, 1);
        disableTBRU26Resp.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        disableTBCS.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        disableTBResp.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        defaultPEDur.configure(this, 3, 0, "RW", 1, 'b00, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_HECONFIGREG_wr_cg";
        dcmSupport_wr : coverpoint dcmSupport.value[0:0];
        dopplerSupport_wr : coverpoint dopplerSupport.value[0:0];
        enableOBSSPD_wr : coverpoint enableOBSSPD.value[0:0];
        enableSRP_wr : coverpoint enableSRP.value[0:0];
        acceptAllTriggerFrames_wr : coverpoint acceptAllTriggerFrames.value[0:0];
        acceptTriggerSWFrames_wr : coverpoint acceptTriggerSWFrames.value[0:0];
        acceptTriggerHWFrames_wr : coverpoint acceptTriggerHWFrames.value[0:0];
        disableTBUPH_wr : coverpoint disableTBUPH.value[0:0];
        disableTBRU26Resp_wr : coverpoint disableTBRU26Resp.value[0:0];
        disableTBCS_wr : coverpoint disableTBCS.value[0:0];
        disableTBResp_wr : coverpoint disableTBResp.value[0:0];
        defaultPEDur_wr : coverpoint defaultPEDur.value[2:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_HECONFIGREG_rd_cg";
        dcmSupport_rd : coverpoint dcmSupport.value[0:0];
        dopplerSupport_rd : coverpoint dopplerSupport.value[0:0];
        enableOBSSPD_rd : coverpoint enableOBSSPD.value[0:0];
        enableSRP_rd : coverpoint enableSRP.value[0:0];
        acceptAllTriggerFrames_rd : coverpoint acceptAllTriggerFrames.value[0:0];
        acceptTriggerSWFrames_rd : coverpoint acceptTriggerSWFrames.value[0:0];
        acceptTriggerHWFrames_rd : coverpoint acceptTriggerHWFrames.value[0:0];
        disableTBUPH_rd : coverpoint disableTBUPH.value[0:0];
        disableTBRU26Resp_rd : coverpoint disableTBRU26Resp.value[0:0];
        disableTBCS_rd : coverpoint disableTBCS.value[0:0];
        disableTBResp_rd : coverpoint disableTBResp.value[0:0];
        defaultPEDur_rd : coverpoint defaultPEDur.value[2:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HECONFIGREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SPCONFIG1REG
//--------------------------------------------------------------------
class SPCONFIG1REG extends uvm_reg;
    `uvm_object_utils(SPCONFIG1REG)
    rand uvm_reg_field srgOBSSPDMaxOffset;
    rand uvm_reg_field srgOBSSPDMinOffset;
    rand uvm_reg_field nonSRGOBSSPDMaxOffset;
    rand uvm_reg_field srgInformationPresent;
    rand uvm_reg_field nonSRGOffsetPresent;
    rand uvm_reg_field nonSRGOBSSPDSRDisallowed;
    rand uvm_reg_field SRPDisallowed;

    //---build------------------------------------------------------------
    virtual function void build();
        srgOBSSPDMaxOffset = uvm_reg_field::type_id::create("srgOBSSPDMaxOffset");
        srgOBSSPDMinOffset = uvm_reg_field::type_id::create("srgOBSSPDMinOffset");
        nonSRGOBSSPDMaxOffset = uvm_reg_field::type_id::create("nonSRGOBSSPDMaxOffset");
        srgInformationPresent = uvm_reg_field::type_id::create("srgInformationPresent");
        nonSRGOffsetPresent = uvm_reg_field::type_id::create("nonSRGOffsetPresent");
        nonSRGOBSSPDSRDisallowed = uvm_reg_field::type_id::create("nonSRGOBSSPDSRDisallowed");
        SRPDisallowed = uvm_reg_field::type_id::create("SRPDisallowed");

        srgOBSSPDMaxOffset.configure(this, 8, 24, "RW", 1, 'b0000000, 1, 1, 1);
        srgOBSSPDMinOffset.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        nonSRGOBSSPDMaxOffset.configure(this, 8, 8, "RW", 1, 'b0000000, 1, 1, 1);
        srgInformationPresent.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        nonSRGOffsetPresent.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        nonSRGOBSSPDSRDisallowed.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        SRPDisallowed.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_SPCONFIG1REG_wr_cg";
        srgOBSSPDMaxOffset_wr : coverpoint srgOBSSPDMaxOffset.value[7:0];
        srgOBSSPDMinOffset_wr : coverpoint srgOBSSPDMinOffset.value[7:0];
        nonSRGOBSSPDMaxOffset_wr : coverpoint nonSRGOBSSPDMaxOffset.value[7:0];
        srgInformationPresent_wr : coverpoint srgInformationPresent.value[0:0];
        nonSRGOffsetPresent_wr : coverpoint nonSRGOffsetPresent.value[0:0];
        nonSRGOBSSPDSRDisallowed_wr : coverpoint nonSRGOBSSPDSRDisallowed.value[0:0];
        SRPDisallowed_wr : coverpoint SRPDisallowed.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_SPCONFIG1REG_rd_cg";
        srgOBSSPDMaxOffset_rd : coverpoint srgOBSSPDMaxOffset.value[7:0];
        srgOBSSPDMinOffset_rd : coverpoint srgOBSSPDMinOffset.value[7:0];
        nonSRGOBSSPDMaxOffset_rd : coverpoint nonSRGOBSSPDMaxOffset.value[7:0];
        srgInformationPresent_rd : coverpoint srgInformationPresent.value[0:0];
        nonSRGOffsetPresent_rd : coverpoint nonSRGOffsetPresent.value[0:0];
        nonSRGOBSSPDSRDisallowed_rd : coverpoint nonSRGOBSSPDSRDisallowed.value[0:0];
        SRPDisallowed_rd : coverpoint SRPDisallowed.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SPCONFIG1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SRGBSSCOLORBITMAPLOWREG
//--------------------------------------------------------------------
class SRGBSSCOLORBITMAPLOWREG extends uvm_reg;
    `uvm_object_utils(SRGBSSCOLORBITMAPLOWREG)
    rand uvm_reg_field SRGBSSColorBitmapLow;

    //---build------------------------------------------------------------
    virtual function void build();
        SRGBSSColorBitmapLow = uvm_reg_field::type_id::create("SRGBSSColorBitmapLow");

        SRGBSSColorBitmapLow.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_SRGBSSCOLORBITMAPLOWREG_wr_cg";
        SRGBSSColorBitmapLow_wr : coverpoint SRGBSSColorBitmapLow.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_SRGBSSCOLORBITMAPLOWREG_rd_cg";
        SRGBSSColorBitmapLow_rd : coverpoint SRGBSSColorBitmapLow.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SRGBSSCOLORBITMAPLOWREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SRGBSSCOLORBITMAPHIGHREG
//--------------------------------------------------------------------
class SRGBSSCOLORBITMAPHIGHREG extends uvm_reg;
    `uvm_object_utils(SRGBSSCOLORBITMAPHIGHREG)
    rand uvm_reg_field SRGBSSColorBitmapHigh;

    //---build------------------------------------------------------------
    virtual function void build();
        SRGBSSColorBitmapHigh = uvm_reg_field::type_id::create("SRGBSSColorBitmapHigh");

        SRGBSSColorBitmapHigh.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_SRGBSSCOLORBITMAPHIGHREG_wr_cg";
        SRGBSSColorBitmapHigh_wr : coverpoint SRGBSSColorBitmapHigh.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_SRGBSSCOLORBITMAPHIGHREG_rd_cg";
        SRGBSSColorBitmapHigh_rd : coverpoint SRGBSSColorBitmapHigh.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SRGBSSCOLORBITMAPHIGHREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SRGPARTIALBSSIDBITMAPLOWREG
//--------------------------------------------------------------------
class SRGPARTIALBSSIDBITMAPLOWREG extends uvm_reg;
    `uvm_object_utils(SRGPARTIALBSSIDBITMAPLOWREG)
    rand uvm_reg_field SRGPartialBSSIDBitmapLow;

    //---build------------------------------------------------------------
    virtual function void build();
        SRGPartialBSSIDBitmapLow = uvm_reg_field::type_id::create("SRGPartialBSSIDBitmapLow");

        SRGPartialBSSIDBitmapLow.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_SRGPARTIALBSSIDBITMAPLOWREG_wr_cg";
        SRGPartialBSSIDBitmapLow_wr : coverpoint SRGPartialBSSIDBitmapLow.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_SRGPARTIALBSSIDBITMAPLOWREG_rd_cg";
        SRGPartialBSSIDBitmapLow_rd : coverpoint SRGPartialBSSIDBitmapLow.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SRGPARTIALBSSIDBITMAPLOWREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SRGPARTIALBSSIDBITMAPHIGHREG
//--------------------------------------------------------------------
class SRGPARTIALBSSIDBITMAPHIGHREG extends uvm_reg;
    `uvm_object_utils(SRGPARTIALBSSIDBITMAPHIGHREG)
    rand uvm_reg_field SRGPartialBSSIDBitmapHigh;

    //---build------------------------------------------------------------
    virtual function void build();
        SRGPartialBSSIDBitmapHigh = uvm_reg_field::type_id::create("SRGPartialBSSIDBitmapHigh");

        SRGPartialBSSIDBitmapHigh.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_SRGPARTIALBSSIDBITMAPHIGHREG_wr_cg";
        SRGPartialBSSIDBitmapHigh_wr : coverpoint SRGPartialBSSIDBitmapHigh.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_SRGPARTIALBSSIDBITMAPHIGHREG_rd_cg";
        SRGPartialBSSIDBitmapHigh_rd : coverpoint SRGPartialBSSIDBitmapHigh.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SRGPARTIALBSSIDBITMAPHIGHREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BFMEECONTROLREG
//--------------------------------------------------------------------
class BFMEECONTROLREG extends uvm_reg;
    `uvm_object_utils(BFMEECONTROLREG)
    rand uvm_reg_field bfrHELTFType;
    rand uvm_reg_field bfrGIType;
    rand uvm_reg_field bfrFormatMod;
    rand uvm_reg_field bfrShortGI;
    rand uvm_reg_field bfrMCS;
    rand uvm_reg_field bfmeeNc;
    rand uvm_reg_field bfmeeNr;
    rand uvm_reg_field bfmeeGrouping;
    rand uvm_reg_field bfmeeCodebook;
    rand uvm_reg_field bfmeeMUSupport;
    rand uvm_reg_field bfmeeEnable;

    //---build------------------------------------------------------------
    virtual function void build();
        bfrHELTFType = uvm_reg_field::type_id::create("bfrHELTFType");
        bfrGIType = uvm_reg_field::type_id::create("bfrGIType");
        bfrFormatMod = uvm_reg_field::type_id::create("bfrFormatMod");
        bfrShortGI = uvm_reg_field::type_id::create("bfrShortGI");
        bfrMCS = uvm_reg_field::type_id::create("bfrMCS");
        bfmeeNc = uvm_reg_field::type_id::create("bfmeeNc");
        bfmeeNr = uvm_reg_field::type_id::create("bfmeeNr");
        bfmeeGrouping = uvm_reg_field::type_id::create("bfmeeGrouping");
        bfmeeCodebook = uvm_reg_field::type_id::create("bfmeeCodebook");
        bfmeeMUSupport = uvm_reg_field::type_id::create("bfmeeMUSupport");
        bfmeeEnable = uvm_reg_field::type_id::create("bfmeeEnable");

        bfrHELTFType.configure(this, 2, 30, "RW", 1, 'b0, 1, 1, 1);
        bfrGIType.configure(this, 2, 28, "RW", 1, 'b0, 1, 1, 1);
        bfrFormatMod.configure(this, 3, 25, "RW", 1, 'b100, 1, 1, 1);
        bfrShortGI.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        bfrMCS.configure(this, 8, 16, "RW", 1, 'b10000100, 1, 1, 1);
        bfmeeNc.configure(this, 3, 8, "RW", 1, 'b01, 1, 1, 1);
        bfmeeNr.configure(this, 3, 5, "RW", 1, 'b01, 1, 1, 1);
        bfmeeGrouping.configure(this, 2, 3, "RW", 1, 'b0, 1, 1, 1);
        bfmeeCodebook.configure(this, 1, 2, "RW", 1, 'b1, 1, 1, 1);
        bfmeeMUSupport.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        bfmeeEnable.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_BFMEECONTROLREG_wr_cg";
        bfrHELTFType_wr : coverpoint bfrHELTFType.value[1:0];
        bfrGIType_wr : coverpoint bfrGIType.value[1:0];
        bfrFormatMod_wr : coverpoint bfrFormatMod.value[2:0];
        bfrShortGI_wr : coverpoint bfrShortGI.value[0:0];
        bfrMCS_wr : coverpoint bfrMCS.value[7:0];
        bfmeeNc_wr : coverpoint bfmeeNc.value[2:0];
        bfmeeNr_wr : coverpoint bfmeeNr.value[2:0];
        bfmeeGrouping_wr : coverpoint bfmeeGrouping.value[1:0];
        bfmeeCodebook_wr : coverpoint bfmeeCodebook.value[0:0];
        bfmeeMUSupport_wr : coverpoint bfmeeMUSupport.value[0:0];
        bfmeeEnable_wr : coverpoint bfmeeEnable.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_BFMEECONTROLREG_rd_cg";
        bfrHELTFType_rd : coverpoint bfrHELTFType.value[1:0];
        bfrGIType_rd : coverpoint bfrGIType.value[1:0];
        bfrFormatMod_rd : coverpoint bfrFormatMod.value[2:0];
        bfrShortGI_rd : coverpoint bfrShortGI.value[0:0];
        bfrMCS_rd : coverpoint bfrMCS.value[7:0];
        bfmeeNc_rd : coverpoint bfmeeNc.value[2:0];
        bfmeeNr_rd : coverpoint bfmeeNr.value[2:0];
        bfmeeGrouping_rd : coverpoint bfmeeGrouping.value[1:0];
        bfmeeCodebook_rd : coverpoint bfmeeCodebook.value[0:0];
        bfmeeMUSupport_rd : coverpoint bfmeeMUSupport.value[0:0];
        bfmeeEnable_rd : coverpoint bfmeeEnable.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BFMEECONTROLREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// COEXCONTROLREG
//--------------------------------------------------------------------
class COEXCONTROLREG extends uvm_reg;
    `uvm_object_utils(COEXCONTROLREG)
    rand uvm_reg_field coexForceWlanPTI;
    rand uvm_reg_field coexForceWlanPTIToggle;
    rand uvm_reg_field coexForceWlanChanBw;
    rand uvm_reg_field coexForceWlanRx;
    rand uvm_reg_field coexForceWlanTx;
    rand uvm_reg_field coexWlanChanFreq;
    rand uvm_reg_field coexWlanChanOffset;
    rand uvm_reg_field coexAutoPTIAdjIncr;
    rand uvm_reg_field coexAutoPTIAdjEnable;
    rand uvm_reg_field coexForceEnable;
    rand uvm_reg_field coexPostponeTxEnable;
    rand uvm_reg_field coexPHYRxAbortEnable;
    rand uvm_reg_field coexPHYTxAbortEnable;
    rand uvm_reg_field coexEnable;

    //---build------------------------------------------------------------
    virtual function void build();
        coexForceWlanPTI = uvm_reg_field::type_id::create("coexForceWlanPTI");
        coexForceWlanPTIToggle = uvm_reg_field::type_id::create("coexForceWlanPTIToggle");
        coexForceWlanChanBw = uvm_reg_field::type_id::create("coexForceWlanChanBw");
        coexForceWlanRx = uvm_reg_field::type_id::create("coexForceWlanRx");
        coexForceWlanTx = uvm_reg_field::type_id::create("coexForceWlanTx");
        coexWlanChanFreq = uvm_reg_field::type_id::create("coexWlanChanFreq");
        coexWlanChanOffset = uvm_reg_field::type_id::create("coexWlanChanOffset");
        coexAutoPTIAdjIncr = uvm_reg_field::type_id::create("coexAutoPTIAdjIncr");
        coexAutoPTIAdjEnable = uvm_reg_field::type_id::create("coexAutoPTIAdjEnable");
        coexForceEnable = uvm_reg_field::type_id::create("coexForceEnable");
        coexPostponeTxEnable = uvm_reg_field::type_id::create("coexPostponeTxEnable");
        coexPHYRxAbortEnable = uvm_reg_field::type_id::create("coexPHYRxAbortEnable");
        coexPHYTxAbortEnable = uvm_reg_field::type_id::create("coexPHYTxAbortEnable");
        coexEnable = uvm_reg_field::type_id::create("coexEnable");

        coexForceWlanPTI.configure(this, 4, 28, "RW", 1, 'b000, 1, 1, 1);
        coexForceWlanPTIToggle.configure(this, 1, 27, "RW", 1, 'b0, 1, 1, 1);
        coexForceWlanChanBw.configure(this, 1, 26, "RW", 1, 'b0, 1, 1, 1);
        coexForceWlanRx.configure(this, 1, 25, "RW", 1, 'b0, 1, 1, 1);
        coexForceWlanTx.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        coexWlanChanFreq.configure(this, 7, 16, "RW", 1, 'b000000, 1, 1, 1);
        coexWlanChanOffset.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        coexAutoPTIAdjIncr.configure(this, 2, 6, "RW", 1, 'b1, 1, 1, 1);
        coexAutoPTIAdjEnable.configure(this, 1, 5, "RW", 1, 'b1, 1, 1, 1);
        coexForceEnable.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        coexPostponeTxEnable.configure(this, 1, 3, "RW", 1, 'b1, 1, 1, 1);
        coexPHYRxAbortEnable.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        coexPHYTxAbortEnable.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        coexEnable.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_COEXCONTROLREG_wr_cg";
        coexForceWlanPTI_wr : coverpoint coexForceWlanPTI.value[3:0];
        coexForceWlanPTIToggle_wr : coverpoint coexForceWlanPTIToggle.value[0:0];
        coexForceWlanChanBw_wr : coverpoint coexForceWlanChanBw.value[0:0];
        coexForceWlanRx_wr : coverpoint coexForceWlanRx.value[0:0];
        coexForceWlanTx_wr : coverpoint coexForceWlanTx.value[0:0];
        coexWlanChanFreq_wr : coverpoint coexWlanChanFreq.value[6:0];
        coexWlanChanOffset_wr : coverpoint coexWlanChanOffset.value[0:0];
        coexAutoPTIAdjIncr_wr : coverpoint coexAutoPTIAdjIncr.value[1:0];
        coexAutoPTIAdjEnable_wr : coverpoint coexAutoPTIAdjEnable.value[0:0];
        coexForceEnable_wr : coverpoint coexForceEnable.value[0:0];
        coexPostponeTxEnable_wr : coverpoint coexPostponeTxEnable.value[0:0];
        coexPHYRxAbortEnable_wr : coverpoint coexPHYRxAbortEnable.value[0:0];
        coexPHYTxAbortEnable_wr : coverpoint coexPHYTxAbortEnable.value[0:0];
        coexEnable_wr : coverpoint coexEnable.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_COEXCONTROLREG_rd_cg";
        coexForceWlanPTI_rd : coverpoint coexForceWlanPTI.value[3:0];
        coexForceWlanPTIToggle_rd : coverpoint coexForceWlanPTIToggle.value[0:0];
        coexForceWlanChanBw_rd : coverpoint coexForceWlanChanBw.value[0:0];
        coexForceWlanRx_rd : coverpoint coexForceWlanRx.value[0:0];
        coexForceWlanTx_rd : coverpoint coexForceWlanTx.value[0:0];
        coexWlanChanFreq_rd : coverpoint coexWlanChanFreq.value[6:0];
        coexWlanChanOffset_rd : coverpoint coexWlanChanOffset.value[0:0];
        coexAutoPTIAdjIncr_rd : coverpoint coexAutoPTIAdjIncr.value[1:0];
        coexAutoPTIAdjEnable_rd : coverpoint coexAutoPTIAdjEnable.value[0:0];
        coexForceEnable_rd : coverpoint coexForceEnable.value[0:0];
        coexPostponeTxEnable_rd : coverpoint coexPostponeTxEnable.value[0:0];
        coexPHYRxAbortEnable_rd : coverpoint coexPHYRxAbortEnable.value[0:0];
        coexPHYTxAbortEnable_rd : coverpoint coexPHYTxAbortEnable.value[0:0];
        coexEnable_rd : coverpoint coexEnable.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "COEXCONTROLREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// COEXPTIREG
//--------------------------------------------------------------------
class COEXPTIREG extends uvm_reg;
    `uvm_object_utils(COEXPTIREG)
    rand uvm_reg_field coexPTIBcnData;
    rand uvm_reg_field coexPTIBKData;
    rand uvm_reg_field coexPTIBEData;
    rand uvm_reg_field coexPTIVIData;
    rand uvm_reg_field coexPTIVOData;
    rand uvm_reg_field coexPTIMgt;
    rand uvm_reg_field coexPTICntl;
    rand uvm_reg_field coexPTIAck;

    //---build------------------------------------------------------------
    virtual function void build();
        coexPTIBcnData = uvm_reg_field::type_id::create("coexPTIBcnData");
        coexPTIBKData = uvm_reg_field::type_id::create("coexPTIBKData");
        coexPTIBEData = uvm_reg_field::type_id::create("coexPTIBEData");
        coexPTIVIData = uvm_reg_field::type_id::create("coexPTIVIData");
        coexPTIVOData = uvm_reg_field::type_id::create("coexPTIVOData");
        coexPTIMgt = uvm_reg_field::type_id::create("coexPTIMgt");
        coexPTICntl = uvm_reg_field::type_id::create("coexPTICntl");
        coexPTIAck = uvm_reg_field::type_id::create("coexPTIAck");

        coexPTIBcnData.configure(this, 4, 28, "RW", 1, 'b000, 1, 1, 1);
        coexPTIBKData.configure(this, 4, 24, "RW", 1, 'b000, 1, 1, 1);
        coexPTIBEData.configure(this, 4, 20, "RW", 1, 'b010, 1, 1, 1);
        coexPTIVIData.configure(this, 4, 16, "RW", 1, 'b100, 1, 1, 1);
        coexPTIVOData.configure(this, 4, 12, "RW", 1, 'b110, 1, 1, 1);
        coexPTIMgt.configure(this, 4, 8, "RW", 1, 'b110, 1, 1, 1);
        coexPTICntl.configure(this, 4, 4, "RW", 1, 'b011, 1, 1, 1);
        coexPTIAck.configure(this, 4, 0, "RW", 1, 'b111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_COEXPTIREG_wr_cg";
        coexPTIBcnData_wr : coverpoint coexPTIBcnData.value[3:0];
        coexPTIBKData_wr : coverpoint coexPTIBKData.value[3:0];
        coexPTIBEData_wr : coverpoint coexPTIBEData.value[3:0];
        coexPTIVIData_wr : coverpoint coexPTIVIData.value[3:0];
        coexPTIVOData_wr : coverpoint coexPTIVOData.value[3:0];
        coexPTIMgt_wr : coverpoint coexPTIMgt.value[3:0];
        coexPTICntl_wr : coverpoint coexPTICntl.value[3:0];
        coexPTIAck_wr : coverpoint coexPTIAck.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_COEXPTIREG_rd_cg";
        coexPTIBcnData_rd : coverpoint coexPTIBcnData.value[3:0];
        coexPTIBKData_rd : coverpoint coexPTIBKData.value[3:0];
        coexPTIBEData_rd : coverpoint coexPTIBEData.value[3:0];
        coexPTIVIData_rd : coverpoint coexPTIVIData.value[3:0];
        coexPTIVOData_rd : coverpoint coexPTIVOData.value[3:0];
        coexPTIMgt_rd : coverpoint coexPTIMgt.value[3:0];
        coexPTICntl_rd : coverpoint coexPTICntl.value[3:0];
        coexPTIAck_rd : coverpoint coexPTIAck.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "COEXPTIREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// COEXSTATREG
//--------------------------------------------------------------------
class COEXSTATREG extends uvm_reg;
    `uvm_object_utils(COEXSTATREG)
    rand uvm_reg_field coexWlanPTIState;
    rand uvm_reg_field coexWlanPTIToggleState;
    rand uvm_reg_field coexWlanChanBwState;
    rand uvm_reg_field coexWlanRxState;
    rand uvm_reg_field coexWlanTxState;
    rand uvm_reg_field coexWlanRxAbortState;
    rand uvm_reg_field coexWlanTxAbortState;

    //---build------------------------------------------------------------
    virtual function void build();
        coexWlanPTIState = uvm_reg_field::type_id::create("coexWlanPTIState");
        coexWlanPTIToggleState = uvm_reg_field::type_id::create("coexWlanPTIToggleState");
        coexWlanChanBwState = uvm_reg_field::type_id::create("coexWlanChanBwState");
        coexWlanRxState = uvm_reg_field::type_id::create("coexWlanRxState");
        coexWlanTxState = uvm_reg_field::type_id::create("coexWlanTxState");
        coexWlanRxAbortState = uvm_reg_field::type_id::create("coexWlanRxAbortState");
        coexWlanTxAbortState = uvm_reg_field::type_id::create("coexWlanTxAbortState");

        coexWlanPTIState.configure(this, 4, 8, "RO", 1, 'b000, 1, 1, 1);
        coexWlanPTIToggleState.configure(this, 1, 5, "RO", 1, 'b0, 1, 1, 1);
        coexWlanChanBwState.configure(this, 1, 4, "RO", 1, 'b0, 1, 1, 1);
        coexWlanRxState.configure(this, 1, 3, "RO", 1, 'b0, 1, 1, 1);
        coexWlanTxState.configure(this, 1, 2, "RO", 1, 'b0, 1, 1, 1);
        coexWlanRxAbortState.configure(this, 1, 1, "RO", 1, 'b0, 1, 1, 1);
        coexWlanTxAbortState.configure(this, 1, 0, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_COEXSTATREG_rd_cg";
        coexWlanPTIState_rd : coverpoint coexWlanPTIState.value[3:0];
        coexWlanPTIToggleState_rd : coverpoint coexWlanPTIToggleState.value[0:0];
        coexWlanChanBwState_rd : coverpoint coexWlanChanBwState.value[0:0];
        coexWlanRxState_rd : coverpoint coexWlanRxState.value[0:0];
        coexWlanTxState_rd : coverpoint coexWlanTxState.value[0:0];
        coexWlanRxAbortState_rd : coverpoint coexWlanRxAbortState.value[0:0];
        coexWlanTxAbortState_rd : coverpoint coexWlanTxAbortState.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "COEXSTATREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// COEXINTREG
//--------------------------------------------------------------------
class COEXINTREG extends uvm_reg;
    `uvm_object_utils(COEXINTREG)
    rand uvm_reg_field coexWlanRxAbortFallEn;
    rand uvm_reg_field coexWlanRxAbortRiseEn;
    rand uvm_reg_field coexWlanTxAbortFallEn;
    rand uvm_reg_field coexWlanTxAbortRiseEn;

    //---build------------------------------------------------------------
    virtual function void build();
        coexWlanRxAbortFallEn = uvm_reg_field::type_id::create("coexWlanRxAbortFallEn");
        coexWlanRxAbortRiseEn = uvm_reg_field::type_id::create("coexWlanRxAbortRiseEn");
        coexWlanTxAbortFallEn = uvm_reg_field::type_id::create("coexWlanTxAbortFallEn");
        coexWlanTxAbortRiseEn = uvm_reg_field::type_id::create("coexWlanTxAbortRiseEn");

        coexWlanRxAbortFallEn.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        coexWlanRxAbortRiseEn.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        coexWlanTxAbortFallEn.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        coexWlanTxAbortRiseEn.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_COEXINTREG_wr_cg";
        coexWlanRxAbortFallEn_wr : coverpoint coexWlanRxAbortFallEn.value[0:0];
        coexWlanRxAbortRiseEn_wr : coverpoint coexWlanRxAbortRiseEn.value[0:0];
        coexWlanTxAbortFallEn_wr : coverpoint coexWlanTxAbortFallEn.value[0:0];
        coexWlanTxAbortRiseEn_wr : coverpoint coexWlanTxAbortRiseEn.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_COEXINTREG_rd_cg";
        coexWlanRxAbortFallEn_rd : coverpoint coexWlanRxAbortFallEn.value[0:0];
        coexWlanRxAbortRiseEn_rd : coverpoint coexWlanRxAbortRiseEn.value[0:0];
        coexWlanTxAbortFallEn_rd : coverpoint coexWlanTxAbortFallEn.value[0:0];
        coexWlanTxAbortRiseEn_rd : coverpoint coexWlanTxAbortRiseEn.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "COEXINTREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGHWSM1REG
//--------------------------------------------------------------------
class DEBUGHWSM1REG extends uvm_reg;
    `uvm_object_utils(DEBUGHWSM1REG)
    rand uvm_reg_field macControlLs;
    rand uvm_reg_field txControlLs;
    rand uvm_reg_field rxControlLs;

    //---build------------------------------------------------------------
    virtual function void build();
        macControlLs = uvm_reg_field::type_id::create("macControlLs");
        txControlLs = uvm_reg_field::type_id::create("txControlLs");
        rxControlLs = uvm_reg_field::type_id::create("rxControlLs");

        macControlLs.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        txControlLs.configure(this, 9, 8, "RO", 1, 'b00000000, 1, 1, 1);
        rxControlLs.configure(this, 6, 0, "RO", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGHWSM1REG_rd_cg";
        macControlLs_rd : coverpoint macControlLs.value[7:0];
        txControlLs_rd : coverpoint txControlLs.value[8:0];
        rxControlLs_rd : coverpoint rxControlLs.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGHWSM1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGHWSM2REG
//--------------------------------------------------------------------
class DEBUGHWSM2REG extends uvm_reg;
    `uvm_object_utils(DEBUGHWSM2REG)
    rand uvm_reg_field macControlCs;
    rand uvm_reg_field txControlCs;
    rand uvm_reg_field rxControlCs;

    //---build------------------------------------------------------------
    virtual function void build();
        macControlCs = uvm_reg_field::type_id::create("macControlCs");
        txControlCs = uvm_reg_field::type_id::create("txControlCs");
        rxControlCs = uvm_reg_field::type_id::create("rxControlCs");

        macControlCs.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        txControlCs.configure(this, 9, 8, "RO", 1, 'b00000000, 1, 1, 1);
        rxControlCs.configure(this, 6, 0, "RO", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGHWSM2REG_rd_cg";
        macControlCs_rd : coverpoint macControlCs.value[7:0];
        txControlCs_rd : coverpoint txControlCs.value[8:0];
        rxControlCs_rd : coverpoint rxControlCs.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGHWSM2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGPORTVALUEREG
//--------------------------------------------------------------------
class DEBUGPORTVALUEREG extends uvm_reg;
    `uvm_object_utils(DEBUGPORTVALUEREG)
    rand uvm_reg_field debugPortRead;

    //---build------------------------------------------------------------
    virtual function void build();
        debugPortRead = uvm_reg_field::type_id::create("debugPortRead");

        debugPortRead.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGPORTVALUEREG_rd_cg";
        debugPortRead_rd : coverpoint debugPortRead.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGPORTVALUEREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGPORTSELREG
//--------------------------------------------------------------------
class DEBUGPORTSELREG extends uvm_reg;
    `uvm_object_utils(DEBUGPORTSELREG)
    rand uvm_reg_field debugPortSel2;
    rand uvm_reg_field debugPortSel1;

    //---build------------------------------------------------------------
    virtual function void build();
        debugPortSel2 = uvm_reg_field::type_id::create("debugPortSel2");
        debugPortSel1 = uvm_reg_field::type_id::create("debugPortSel1");

        debugPortSel2.configure(this, 8, 8, "RW", 1, 'b0000000, 1, 1, 1);
        debugPortSel1.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGPORTSELREG_wr_cg";
        debugPortSel2_wr : coverpoint debugPortSel2.value[7:0];
        debugPortSel1_wr : coverpoint debugPortSel1.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGPORTSELREG_rd_cg";
        debugPortSel2_rd : coverpoint debugPortSel2.value[7:0];
        debugPortSel1_rd : coverpoint debugPortSel1.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGPORTSELREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGBASICNAVREG
//--------------------------------------------------------------------
class DEBUGBASICNAVREG extends uvm_reg;
    `uvm_object_utils(DEBUGBASICNAVREG)
    rand uvm_reg_field basicNAVCounter;

    //---build------------------------------------------------------------
    virtual function void build();
        basicNAVCounter = uvm_reg_field::type_id::create("basicNAVCounter");

        basicNAVCounter.configure(this, 26, 0, "RW", 1, 'b0000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGBASICNAVREG_wr_cg";
        basicNAVCounter_wr : coverpoint basicNAVCounter.value[25:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGBASICNAVREG_rd_cg";
        basicNAVCounter_rd : coverpoint basicNAVCounter.value[25:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGBASICNAVREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGCWREG
//--------------------------------------------------------------------
class DEBUGCWREG extends uvm_reg;
    `uvm_object_utils(DEBUGCWREG)
    rand uvm_reg_field backoffOffset;
    rand uvm_reg_field activeAC;
    rand uvm_reg_field currentCW3;
    rand uvm_reg_field currentCW2;
    rand uvm_reg_field currentCW1;
    rand uvm_reg_field currentCW0;

    //---build------------------------------------------------------------
    virtual function void build();
        backoffOffset = uvm_reg_field::type_id::create("backoffOffset");
        activeAC = uvm_reg_field::type_id::create("activeAC");
        currentCW3 = uvm_reg_field::type_id::create("currentCW3");
        currentCW2 = uvm_reg_field::type_id::create("currentCW2");
        currentCW1 = uvm_reg_field::type_id::create("currentCW1");
        currentCW0 = uvm_reg_field::type_id::create("currentCW0");

        backoffOffset.configure(this, 2, 24, "RW", 1, 'b0, 1, 1, 1);
        activeAC.configure(this, 3, 16, "RO", 1, 'b00, 1, 1, 1);
        currentCW3.configure(this, 4, 12, "RO", 1, 'b010, 1, 1, 1);
        currentCW2.configure(this, 4, 8, "RO", 1, 'b011, 1, 1, 1);
        currentCW1.configure(this, 4, 4, "RO", 1, 'b100, 1, 1, 1);
        currentCW0.configure(this, 4, 0, "RO", 1, 'b100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGCWREG_wr_cg";
        backoffOffset_wr : coverpoint backoffOffset.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGCWREG_rd_cg";
        backoffOffset_rd : coverpoint backoffOffset.value[1:0];
        activeAC_rd : coverpoint activeAC.value[2:0];
        currentCW3_rd : coverpoint currentCW3.value[3:0];
        currentCW2_rd : coverpoint currentCW2.value[3:0];
        currentCW1_rd : coverpoint currentCW1.value[3:0];
        currentCW0_rd : coverpoint currentCW0.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGCWREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGQSRCREG
//--------------------------------------------------------------------
class DEBUGQSRCREG extends uvm_reg;
    `uvm_object_utils(DEBUGQSRCREG)
    rand uvm_reg_field ac3QSRC;
    rand uvm_reg_field ac2QSRC;
    rand uvm_reg_field ac1QSRC;
    rand uvm_reg_field ac0QSRC;

    //---build------------------------------------------------------------
    virtual function void build();
        ac3QSRC = uvm_reg_field::type_id::create("ac3QSRC");
        ac2QSRC = uvm_reg_field::type_id::create("ac2QSRC");
        ac1QSRC = uvm_reg_field::type_id::create("ac1QSRC");
        ac0QSRC = uvm_reg_field::type_id::create("ac0QSRC");

        ac3QSRC.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        ac2QSRC.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        ac1QSRC.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        ac0QSRC.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGQSRCREG_rd_cg";
        ac3QSRC_rd : coverpoint ac3QSRC.value[7:0];
        ac2QSRC_rd : coverpoint ac2QSRC.value[7:0];
        ac1QSRC_rd : coverpoint ac1QSRC.value[7:0];
        ac0QSRC_rd : coverpoint ac0QSRC.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGQSRCREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGQLRCREG
//--------------------------------------------------------------------
class DEBUGQLRCREG extends uvm_reg;
    `uvm_object_utils(DEBUGQLRCREG)
    rand uvm_reg_field ac3QLRC;
    rand uvm_reg_field ac2QLRC;
    rand uvm_reg_field ac1QLRC;
    rand uvm_reg_field ac0QLRC;

    //---build------------------------------------------------------------
    virtual function void build();
        ac3QLRC = uvm_reg_field::type_id::create("ac3QLRC");
        ac2QLRC = uvm_reg_field::type_id::create("ac2QLRC");
        ac1QLRC = uvm_reg_field::type_id::create("ac1QLRC");
        ac0QLRC = uvm_reg_field::type_id::create("ac0QLRC");

        ac3QLRC.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        ac2QLRC.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        ac1QLRC.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        ac0QLRC.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGQLRCREG_rd_cg";
        ac3QLRC_rd : coverpoint ac3QLRC.value[7:0];
        ac2QLRC_rd : coverpoint ac2QLRC.value[7:0];
        ac1QLRC_rd : coverpoint ac1QLRC.value[7:0];
        ac0QLRC_rd : coverpoint ac0QLRC.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGQLRCREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGUORAREG
//--------------------------------------------------------------------
class DEBUGUORAREG extends uvm_reg;
    `uvm_object_utils(DEBUGUORAREG)
    rand uvm_reg_field ocwLFSR;

    //---build------------------------------------------------------------
    virtual function void build();
        ocwLFSR = uvm_reg_field::type_id::create("ocwLFSR");

        ocwLFSR.configure(this, 7, 0, "RW", 1, 'b000001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGUORAREG_wr_cg";
        ocwLFSR_wr : coverpoint ocwLFSR.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGUORAREG_rd_cg";
        ocwLFSR_rd : coverpoint ocwLFSR.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGUORAREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGPHYREG
//--------------------------------------------------------------------
class DEBUGPHYREG extends uvm_reg;
    `uvm_object_utils(DEBUGPHYREG)
    rand uvm_reg_field rxEndForTimingErrRec;
    rand uvm_reg_field rxReqForceDeassertion;

    //---build------------------------------------------------------------
    virtual function void build();
        rxEndForTimingErrRec = uvm_reg_field::type_id::create("rxEndForTimingErrRec");
        rxReqForceDeassertion = uvm_reg_field::type_id::create("rxReqForceDeassertion");

        rxEndForTimingErrRec.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        rxReqForceDeassertion.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGPHYREG_wr_cg";
        rxEndForTimingErrRec_wr : coverpoint rxEndForTimingErrRec.value[0:0];
        rxReqForceDeassertion_wr : coverpoint rxReqForceDeassertion.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGPHYREG_rd_cg";
        rxEndForTimingErrRec_rd : coverpoint rxEndForTimingErrRec.value[0:0];
        rxReqForceDeassertion_rd : coverpoint rxReqForceDeassertion.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGPHYREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGINTRANAVREG
//--------------------------------------------------------------------
class DEBUGINTRANAVREG extends uvm_reg;
    `uvm_object_utils(DEBUGINTRANAVREG)
    rand uvm_reg_field intraNAVCounter;

    //---build------------------------------------------------------------
    virtual function void build();
        intraNAVCounter = uvm_reg_field::type_id::create("intraNAVCounter");

        intraNAVCounter.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGINTRANAVREG_wr_cg";
        intraNAVCounter_wr : coverpoint intraNAVCounter.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACCORE_DEBUGINTRANAVREG_rd_cg";
        intraNAVCounter_rd : coverpoint intraNAVCounter.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGINTRANAVREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class MACCORE_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(MACCORE_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins SIGNATUREREG              = {'h0};
        bins VERSION1REG              = {'h4};
        bins VERSION2REG              = {'h8};
        bins BITMAPCNTREG              = {'hC};
        bins MACADDRLOWREG              = {'h10};
        bins MACADDRHIREG              = {'h14};
        bins MACADDRLOWMASKREG              = {'h18};
        bins MACADDRHIMASKREG              = {'h1C};
        bins BSSIDLOWREG              = {'h20};
        bins BSSIDHIREG              = {'h24};
        bins BSSIDLOWMASKREG              = {'h28};
        bins BSSIDHIMASKREG              = {'h2C};
        bins BSSCOLORREG              = {'h34};
        bins STATECNTRLREG              = {'h38};
        bins SCANCNTRLREG              = {'h3C};
        bins DOZECNTRL1REG              = {'h44};
        bins MACCNTRL1REG              = {'h4C};
        bins MACERRRECCNTRLREG              = {'h54};
        bins MACERRSETSTATUSREG              = {'h58};
        bins MACERRCLEARSTATUSREG              = {'h5C};
        bins RXCNTRLREG              = {'h60};
        bins BCNCNTRL1REG              = {'h64};
        bins BCNCNTRL2REG              = {'h68};
        bins DTIM1REG              = {'h90};
        bins RETRYLIMITSREG              = {'h98};
        bins BBSERVICEREG              = {'h9C};
        bins MAXPOWERLEVELREG              = {'hA0};
        bins ENCRKEY0REG              = {'hAC};
        bins ENCRKEY1REG              = {'hB0};
        bins ENCRKEY2REG              = {'hB4};
        bins ENCRKEY3REG              = {'hB8};
        bins ENCRMACADDRLOWREG              = {'hBC};
        bins ENCRMACADDRHIGHREG              = {'hC0};
        bins ENCRCNTRLREG              = {'hC4};
        bins ENCRWPIINTKEY0REG              = {'hC8};
        bins ENCRWPIINTKEY1REG              = {'hCC};
        bins ENCRWPIINTKEY2REG              = {'hD0};
        bins ENCRWPIINTKEY3REG              = {'hD4};
        bins ENCRRAMCONFIGREG              = {'hD8};
        bins RATESREG              = {'hDC};
        bins OLBCREG              = {'hE0};
        bins TIMINGS1REG              = {'hE4};
        bins TIMINGS2REG              = {'hE8};
        bins TIMINGS3REG              = {'hEC};
        bins TIMINGS4REG              = {'hF0};
        bins TIMINGS5REG              = {'hF4};
        bins TIMINGS6REG              = {'hF8};
        bins TIMINGS7REG              = {'hFC};
        bins TIMINGS8REG              = {'h100};
        bins TIMINGS9REG              = {'h104};
        bins RXCNTRL2              = {'h10C};
        bins TXTRIGGERTIMERREG              = {'h110};
        bins RXTRIGGERTIMERREG              = {'h114};
        bins MIBTABLEWRITEREG              = {'h118};
        bins MONOTONICCOUNTER1REG              = {'h11C};
        bins MONOTONICCOUNTER2LOREG              = {'h120};
        bins MONOTONICCOUNTER2HIREG              = {'h124};
        bins ABSTIMERREG0              = {'h128};
        bins ABSTIMERREG1              = {'h12C};
        bins ABSTIMERREG2              = {'h130};
        bins ABSTIMERREG3              = {'h134};
        bins ABSTIMERREG4              = {'h138};
        bins ABSTIMERREG5              = {'h13C};
        bins ABSTIMERREG6              = {'h140};
        bins ABSTIMERREG7              = {'h144};
        bins ABSTIMERREG8              = {'h148};
        bins ABSTIMERREG9              = {'h14C};
        bins MAXRXLENGTHREG              = {'h150};
        bins EDCAAC0REG              = {'h200};
        bins EDCAAC1REG              = {'h204};
        bins EDCAAC2REG              = {'h208};
        bins EDCAAC3REG              = {'h20C};
        bins EDCACCABUSYREG              = {'h220};
        bins EDCACNTRLREG              = {'h224};
        bins QUIETELEMENT1AREG              = {'h280};
        bins QUIETELEMENT1BREG              = {'h284};
        bins ADDCCABUSYSEC20REG              = {'h290};
        bins ADDCCABUSYSEC40REG              = {'h294};
        bins ADDCCABUSYSEC80REG              = {'h298};
        bins STBCCNTRLREG              = {'h300};
        bins TXBWCNTRLREG              = {'h310};
        bins HTMCSREG              = {'h314};
        bins VHTMCSREG              = {'h31C};
        bins LSTPREG              = {'h320};
        bins HECONFIGREG              = {'h324};
        bins SPCONFIG1REG              = {'h328};
        bins SRGBSSCOLORBITMAPLOWREG              = {'h32C};
        bins SRGBSSCOLORBITMAPHIGHREG              = {'h330};
        bins SRGPARTIALBSSIDBITMAPLOWREG              = {'h334};
        bins SRGPARTIALBSSIDBITMAPHIGHREG              = {'h338};
        bins BFMEECONTROLREG              = {'h350};
        bins COEXCONTROLREG              = {'h400};
        bins COEXPTIREG              = {'h404};
        bins COEXSTATREG              = {'h408};
        bins COEXINTREG              = {'h40C};
        bins DEBUGHWSM1REG              = {'h500};
        bins DEBUGHWSM2REG              = {'h504};
        bins DEBUGPORTVALUEREG              = {'h50C};
        bins DEBUGPORTSELREG              = {'h510};
        bins DEBUGBASICNAVREG              = {'h514};
        bins DEBUGCWREG              = {'h518};
        bins DEBUGQSRCREG              = {'h51C};
        bins DEBUGQLRCREG              = {'h520};
        bins DEBUGUORAREG              = {'h558};
        bins DEBUGPHYREG              = {'h55C};
        bins DEBUGINTRANAVREG              = {'h560};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "MACCORE_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: MACCORE_reg_access_wrapper

//-------------------------------------------------------------------
// MACCORE_register_block
//--------------------------------------------------------------------
class MACCORE_register_block extends uvm_reg_block;
    `uvm_object_utils(MACCORE_register_block)

    rand SIGNATUREREG SIGNATUREREG_reg;
    rand VERSION1REG VERSION1REG_reg;
    rand VERSION2REG VERSION2REG_reg;
    rand BITMAPCNTREG BITMAPCNTREG_reg;
    rand MACADDRLOWREG MACADDRLOWREG_reg;
    rand MACADDRHIREG MACADDRHIREG_reg;
    rand MACADDRLOWMASKREG MACADDRLOWMASKREG_reg;
    rand MACADDRHIMASKREG MACADDRHIMASKREG_reg;
    rand BSSIDLOWREG BSSIDLOWREG_reg;
    rand BSSIDHIREG BSSIDHIREG_reg;
    rand BSSIDLOWMASKREG BSSIDLOWMASKREG_reg;
    rand BSSIDHIMASKREG BSSIDHIMASKREG_reg;
    rand BSSCOLORREG BSSCOLORREG_reg;
    rand STATECNTRLREG STATECNTRLREG_reg;
    rand SCANCNTRLREG SCANCNTRLREG_reg;
    rand DOZECNTRL1REG DOZECNTRL1REG_reg;
    rand MACCNTRL1REG MACCNTRL1REG_reg;
    rand MACERRRECCNTRLREG MACERRRECCNTRLREG_reg;
    rand MACERRSETSTATUSREG MACERRSETSTATUSREG_reg;
    rand MACERRCLEARSTATUSREG MACERRCLEARSTATUSREG_reg;
    rand RXCNTRLREG RXCNTRLREG_reg;
    rand BCNCNTRL1REG BCNCNTRL1REG_reg;
    rand BCNCNTRL2REG BCNCNTRL2REG_reg;
    rand DTIM1REG DTIM1REG_reg;
    rand RETRYLIMITSREG RETRYLIMITSREG_reg;
    rand BBSERVICEREG BBSERVICEREG_reg;
    rand MAXPOWERLEVELREG MAXPOWERLEVELREG_reg;
    rand ENCRKEY0REG ENCRKEY0REG_reg;
    rand ENCRKEY1REG ENCRKEY1REG_reg;
    rand ENCRKEY2REG ENCRKEY2REG_reg;
    rand ENCRKEY3REG ENCRKEY3REG_reg;
    rand ENCRMACADDRLOWREG ENCRMACADDRLOWREG_reg;
    rand ENCRMACADDRHIGHREG ENCRMACADDRHIGHREG_reg;
    rand ENCRCNTRLREG ENCRCNTRLREG_reg;
    rand ENCRWPIINTKEY0REG ENCRWPIINTKEY0REG_reg;
    rand ENCRWPIINTKEY1REG ENCRWPIINTKEY1REG_reg;
    rand ENCRWPIINTKEY2REG ENCRWPIINTKEY2REG_reg;
    rand ENCRWPIINTKEY3REG ENCRWPIINTKEY3REG_reg;
    rand ENCRRAMCONFIGREG ENCRRAMCONFIGREG_reg;
    rand RATESREG RATESREG_reg;
    rand OLBCREG OLBCREG_reg;
    rand TIMINGS1REG TIMINGS1REG_reg;
    rand TIMINGS2REG TIMINGS2REG_reg;
    rand TIMINGS3REG TIMINGS3REG_reg;
    rand TIMINGS4REG TIMINGS4REG_reg;
    rand TIMINGS5REG TIMINGS5REG_reg;
    rand TIMINGS6REG TIMINGS6REG_reg;
    rand TIMINGS7REG TIMINGS7REG_reg;
    rand TIMINGS8REG TIMINGS8REG_reg;
    rand TIMINGS9REG TIMINGS9REG_reg;
    rand RXCNTRL2 RXCNTRL2_reg;
    rand TXTRIGGERTIMERREG TXTRIGGERTIMERREG_reg;
    rand RXTRIGGERTIMERREG RXTRIGGERTIMERREG_reg;
    rand MIBTABLEWRITEREG MIBTABLEWRITEREG_reg;
    rand MONOTONICCOUNTER1REG MONOTONICCOUNTER1REG_reg;
    rand MONOTONICCOUNTER2LOREG MONOTONICCOUNTER2LOREG_reg;
    rand MONOTONICCOUNTER2HIREG MONOTONICCOUNTER2HIREG_reg;
    rand ABSTIMERREG0 ABSTIMERREG0_reg;
    rand ABSTIMERREG1 ABSTIMERREG1_reg;
    rand ABSTIMERREG2 ABSTIMERREG2_reg;
    rand ABSTIMERREG3 ABSTIMERREG3_reg;
    rand ABSTIMERREG4 ABSTIMERREG4_reg;
    rand ABSTIMERREG5 ABSTIMERREG5_reg;
    rand ABSTIMERREG6 ABSTIMERREG6_reg;
    rand ABSTIMERREG7 ABSTIMERREG7_reg;
    rand ABSTIMERREG8 ABSTIMERREG8_reg;
    rand ABSTIMERREG9 ABSTIMERREG9_reg;
    rand MAXRXLENGTHREG MAXRXLENGTHREG_reg;
    rand EDCAAC0REG EDCAAC0REG_reg;
    rand EDCAAC1REG EDCAAC1REG_reg;
    rand EDCAAC2REG EDCAAC2REG_reg;
    rand EDCAAC3REG EDCAAC3REG_reg;
    rand EDCACCABUSYREG EDCACCABUSYREG_reg;
    rand EDCACNTRLREG EDCACNTRLREG_reg;
    rand QUIETELEMENT1AREG QUIETELEMENT1AREG_reg;
    rand QUIETELEMENT1BREG QUIETELEMENT1BREG_reg;
    rand ADDCCABUSYSEC20REG ADDCCABUSYSEC20REG_reg;
    rand ADDCCABUSYSEC40REG ADDCCABUSYSEC40REG_reg;
    rand ADDCCABUSYSEC80REG ADDCCABUSYSEC80REG_reg;
    rand STBCCNTRLREG STBCCNTRLREG_reg;
    rand TXBWCNTRLREG TXBWCNTRLREG_reg;
    rand HTMCSREG HTMCSREG_reg;
    rand VHTMCSREG VHTMCSREG_reg;
    rand LSTPREG LSTPREG_reg;
    rand HECONFIGREG HECONFIGREG_reg;
    rand SPCONFIG1REG SPCONFIG1REG_reg;
    rand SRGBSSCOLORBITMAPLOWREG SRGBSSCOLORBITMAPLOWREG_reg;
    rand SRGBSSCOLORBITMAPHIGHREG SRGBSSCOLORBITMAPHIGHREG_reg;
    rand SRGPARTIALBSSIDBITMAPLOWREG SRGPARTIALBSSIDBITMAPLOWREG_reg;
    rand SRGPARTIALBSSIDBITMAPHIGHREG SRGPARTIALBSSIDBITMAPHIGHREG_reg;
    rand BFMEECONTROLREG BFMEECONTROLREG_reg;
    rand COEXCONTROLREG COEXCONTROLREG_reg;
    rand COEXPTIREG COEXPTIREG_reg;
    rand COEXSTATREG COEXSTATREG_reg;
    rand COEXINTREG COEXINTREG_reg;
    rand DEBUGHWSM1REG DEBUGHWSM1REG_reg;
    rand DEBUGHWSM2REG DEBUGHWSM2REG_reg;
    rand DEBUGPORTVALUEREG DEBUGPORTVALUEREG_reg;
    rand DEBUGPORTSELREG DEBUGPORTSELREG_reg;
    rand DEBUGBASICNAVREG DEBUGBASICNAVREG_reg;
    rand DEBUGCWREG DEBUGCWREG_reg;
    rand DEBUGQSRCREG DEBUGQSRCREG_reg;
    rand DEBUGQLRCREG DEBUGQLRCREG_reg;
    rand DEBUGUORAREG DEBUGUORAREG_reg;
    rand DEBUGPHYREG DEBUGPHYREG_reg;
    rand DEBUGINTRANAVREG DEBUGINTRANAVREG_reg;

    uvm_reg_map MACCORE_register_map; // Block map
    MACCORE_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "MACCORE_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = MACCORE_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        SIGNATUREREG_reg = SIGNATUREREG::type_id::create("SIGNATUREREG");
        SIGNATUREREG_reg.configure(this);
        SIGNATUREREG_reg.build();

        VERSION1REG_reg = VERSION1REG::type_id::create("VERSION1REG");
        VERSION1REG_reg.configure(this);
        VERSION1REG_reg.build();

        VERSION2REG_reg = VERSION2REG::type_id::create("VERSION2REG");
        VERSION2REG_reg.configure(this);
        VERSION2REG_reg.build();

        BITMAPCNTREG_reg = BITMAPCNTREG::type_id::create("BITMAPCNTREG");
        BITMAPCNTREG_reg.configure(this);
        BITMAPCNTREG_reg.build();

        MACADDRLOWREG_reg = MACADDRLOWREG::type_id::create("MACADDRLOWREG");
        MACADDRLOWREG_reg.configure(this);
        MACADDRLOWREG_reg.build();

        MACADDRHIREG_reg = MACADDRHIREG::type_id::create("MACADDRHIREG");
        MACADDRHIREG_reg.configure(this);
        MACADDRHIREG_reg.build();

        MACADDRLOWMASKREG_reg = MACADDRLOWMASKREG::type_id::create("MACADDRLOWMASKREG");
        MACADDRLOWMASKREG_reg.configure(this);
        MACADDRLOWMASKREG_reg.build();

        MACADDRHIMASKREG_reg = MACADDRHIMASKREG::type_id::create("MACADDRHIMASKREG");
        MACADDRHIMASKREG_reg.configure(this);
        MACADDRHIMASKREG_reg.build();

        BSSIDLOWREG_reg = BSSIDLOWREG::type_id::create("BSSIDLOWREG");
        BSSIDLOWREG_reg.configure(this);
        BSSIDLOWREG_reg.build();

        BSSIDHIREG_reg = BSSIDHIREG::type_id::create("BSSIDHIREG");
        BSSIDHIREG_reg.configure(this);
        BSSIDHIREG_reg.build();

        BSSIDLOWMASKREG_reg = BSSIDLOWMASKREG::type_id::create("BSSIDLOWMASKREG");
        BSSIDLOWMASKREG_reg.configure(this);
        BSSIDLOWMASKREG_reg.build();

        BSSIDHIMASKREG_reg = BSSIDHIMASKREG::type_id::create("BSSIDHIMASKREG");
        BSSIDHIMASKREG_reg.configure(this);
        BSSIDHIMASKREG_reg.build();

        BSSCOLORREG_reg = BSSCOLORREG::type_id::create("BSSCOLORREG");
        BSSCOLORREG_reg.configure(this);
        BSSCOLORREG_reg.build();

        STATECNTRLREG_reg = STATECNTRLREG::type_id::create("STATECNTRLREG");
        STATECNTRLREG_reg.configure(this);
        STATECNTRLREG_reg.build();

        SCANCNTRLREG_reg = SCANCNTRLREG::type_id::create("SCANCNTRLREG");
        SCANCNTRLREG_reg.configure(this);
        SCANCNTRLREG_reg.build();

        DOZECNTRL1REG_reg = DOZECNTRL1REG::type_id::create("DOZECNTRL1REG");
        DOZECNTRL1REG_reg.configure(this);
        DOZECNTRL1REG_reg.build();

        MACCNTRL1REG_reg = MACCNTRL1REG::type_id::create("MACCNTRL1REG");
        MACCNTRL1REG_reg.configure(this);
        MACCNTRL1REG_reg.build();

        MACERRRECCNTRLREG_reg = MACERRRECCNTRLREG::type_id::create("MACERRRECCNTRLREG");
        MACERRRECCNTRLREG_reg.configure(this);
        MACERRRECCNTRLREG_reg.build();

        MACERRSETSTATUSREG_reg = MACERRSETSTATUSREG::type_id::create("MACERRSETSTATUSREG");
        MACERRSETSTATUSREG_reg.configure(this);
        MACERRSETSTATUSREG_reg.build();

        MACERRCLEARSTATUSREG_reg = MACERRCLEARSTATUSREG::type_id::create("MACERRCLEARSTATUSREG");
        MACERRCLEARSTATUSREG_reg.configure(this);
        MACERRCLEARSTATUSREG_reg.build();

        RXCNTRLREG_reg = RXCNTRLREG::type_id::create("RXCNTRLREG");
        RXCNTRLREG_reg.configure(this);
        RXCNTRLREG_reg.build();

        BCNCNTRL1REG_reg = BCNCNTRL1REG::type_id::create("BCNCNTRL1REG");
        BCNCNTRL1REG_reg.configure(this);
        BCNCNTRL1REG_reg.build();

        BCNCNTRL2REG_reg = BCNCNTRL2REG::type_id::create("BCNCNTRL2REG");
        BCNCNTRL2REG_reg.configure(this);
        BCNCNTRL2REG_reg.build();

        DTIM1REG_reg = DTIM1REG::type_id::create("DTIM1REG");
        DTIM1REG_reg.configure(this);
        DTIM1REG_reg.build();

        RETRYLIMITSREG_reg = RETRYLIMITSREG::type_id::create("RETRYLIMITSREG");
        RETRYLIMITSREG_reg.configure(this);
        RETRYLIMITSREG_reg.build();

        BBSERVICEREG_reg = BBSERVICEREG::type_id::create("BBSERVICEREG");
        BBSERVICEREG_reg.configure(this);
        BBSERVICEREG_reg.build();

        MAXPOWERLEVELREG_reg = MAXPOWERLEVELREG::type_id::create("MAXPOWERLEVELREG");
        MAXPOWERLEVELREG_reg.configure(this);
        MAXPOWERLEVELREG_reg.build();

        ENCRKEY0REG_reg = ENCRKEY0REG::type_id::create("ENCRKEY0REG");
        ENCRKEY0REG_reg.configure(this);
        ENCRKEY0REG_reg.build();

        ENCRKEY1REG_reg = ENCRKEY1REG::type_id::create("ENCRKEY1REG");
        ENCRKEY1REG_reg.configure(this);
        ENCRKEY1REG_reg.build();

        ENCRKEY2REG_reg = ENCRKEY2REG::type_id::create("ENCRKEY2REG");
        ENCRKEY2REG_reg.configure(this);
        ENCRKEY2REG_reg.build();

        ENCRKEY3REG_reg = ENCRKEY3REG::type_id::create("ENCRKEY3REG");
        ENCRKEY3REG_reg.configure(this);
        ENCRKEY3REG_reg.build();

        ENCRMACADDRLOWREG_reg = ENCRMACADDRLOWREG::type_id::create("ENCRMACADDRLOWREG");
        ENCRMACADDRLOWREG_reg.configure(this);
        ENCRMACADDRLOWREG_reg.build();

        ENCRMACADDRHIGHREG_reg = ENCRMACADDRHIGHREG::type_id::create("ENCRMACADDRHIGHREG");
        ENCRMACADDRHIGHREG_reg.configure(this);
        ENCRMACADDRHIGHREG_reg.build();

        ENCRCNTRLREG_reg = ENCRCNTRLREG::type_id::create("ENCRCNTRLREG");
        ENCRCNTRLREG_reg.configure(this);
        ENCRCNTRLREG_reg.build();

        ENCRWPIINTKEY0REG_reg = ENCRWPIINTKEY0REG::type_id::create("ENCRWPIINTKEY0REG");
        ENCRWPIINTKEY0REG_reg.configure(this);
        ENCRWPIINTKEY0REG_reg.build();

        ENCRWPIINTKEY1REG_reg = ENCRWPIINTKEY1REG::type_id::create("ENCRWPIINTKEY1REG");
        ENCRWPIINTKEY1REG_reg.configure(this);
        ENCRWPIINTKEY1REG_reg.build();

        ENCRWPIINTKEY2REG_reg = ENCRWPIINTKEY2REG::type_id::create("ENCRWPIINTKEY2REG");
        ENCRWPIINTKEY2REG_reg.configure(this);
        ENCRWPIINTKEY2REG_reg.build();

        ENCRWPIINTKEY3REG_reg = ENCRWPIINTKEY3REG::type_id::create("ENCRWPIINTKEY3REG");
        ENCRWPIINTKEY3REG_reg.configure(this);
        ENCRWPIINTKEY3REG_reg.build();

        ENCRRAMCONFIGREG_reg = ENCRRAMCONFIGREG::type_id::create("ENCRRAMCONFIGREG");
        ENCRRAMCONFIGREG_reg.configure(this);
        ENCRRAMCONFIGREG_reg.build();

        RATESREG_reg = RATESREG::type_id::create("RATESREG");
        RATESREG_reg.configure(this);
        RATESREG_reg.build();

        OLBCREG_reg = OLBCREG::type_id::create("OLBCREG");
        OLBCREG_reg.configure(this);
        OLBCREG_reg.build();

        TIMINGS1REG_reg = TIMINGS1REG::type_id::create("TIMINGS1REG");
        TIMINGS1REG_reg.configure(this);
        TIMINGS1REG_reg.build();

        TIMINGS2REG_reg = TIMINGS2REG::type_id::create("TIMINGS2REG");
        TIMINGS2REG_reg.configure(this);
        TIMINGS2REG_reg.build();

        TIMINGS3REG_reg = TIMINGS3REG::type_id::create("TIMINGS3REG");
        TIMINGS3REG_reg.configure(this);
        TIMINGS3REG_reg.build();

        TIMINGS4REG_reg = TIMINGS4REG::type_id::create("TIMINGS4REG");
        TIMINGS4REG_reg.configure(this);
        TIMINGS4REG_reg.build();

        TIMINGS5REG_reg = TIMINGS5REG::type_id::create("TIMINGS5REG");
        TIMINGS5REG_reg.configure(this);
        TIMINGS5REG_reg.build();

        TIMINGS6REG_reg = TIMINGS6REG::type_id::create("TIMINGS6REG");
        TIMINGS6REG_reg.configure(this);
        TIMINGS6REG_reg.build();

        TIMINGS7REG_reg = TIMINGS7REG::type_id::create("TIMINGS7REG");
        TIMINGS7REG_reg.configure(this);
        TIMINGS7REG_reg.build();

        TIMINGS8REG_reg = TIMINGS8REG::type_id::create("TIMINGS8REG");
        TIMINGS8REG_reg.configure(this);
        TIMINGS8REG_reg.build();

        TIMINGS9REG_reg = TIMINGS9REG::type_id::create("TIMINGS9REG");
        TIMINGS9REG_reg.configure(this);
        TIMINGS9REG_reg.build();

        RXCNTRL2_reg = RXCNTRL2::type_id::create("RXCNTRL2");
        RXCNTRL2_reg.configure(this);
        RXCNTRL2_reg.build();

        TXTRIGGERTIMERREG_reg = TXTRIGGERTIMERREG::type_id::create("TXTRIGGERTIMERREG");
        TXTRIGGERTIMERREG_reg.configure(this);
        TXTRIGGERTIMERREG_reg.build();

        RXTRIGGERTIMERREG_reg = RXTRIGGERTIMERREG::type_id::create("RXTRIGGERTIMERREG");
        RXTRIGGERTIMERREG_reg.configure(this);
        RXTRIGGERTIMERREG_reg.build();

        MIBTABLEWRITEREG_reg = MIBTABLEWRITEREG::type_id::create("MIBTABLEWRITEREG");
        MIBTABLEWRITEREG_reg.configure(this);
        MIBTABLEWRITEREG_reg.build();

        MONOTONICCOUNTER1REG_reg = MONOTONICCOUNTER1REG::type_id::create("MONOTONICCOUNTER1REG");
        MONOTONICCOUNTER1REG_reg.configure(this);
        MONOTONICCOUNTER1REG_reg.build();

        MONOTONICCOUNTER2LOREG_reg = MONOTONICCOUNTER2LOREG::type_id::create("MONOTONICCOUNTER2LOREG");
        MONOTONICCOUNTER2LOREG_reg.configure(this);
        MONOTONICCOUNTER2LOREG_reg.build();

        MONOTONICCOUNTER2HIREG_reg = MONOTONICCOUNTER2HIREG::type_id::create("MONOTONICCOUNTER2HIREG");
        MONOTONICCOUNTER2HIREG_reg.configure(this);
        MONOTONICCOUNTER2HIREG_reg.build();

        ABSTIMERREG0_reg = ABSTIMERREG0::type_id::create("ABSTIMERREG0");
        ABSTIMERREG0_reg.configure(this);
        ABSTIMERREG0_reg.build();

        ABSTIMERREG1_reg = ABSTIMERREG1::type_id::create("ABSTIMERREG1");
        ABSTIMERREG1_reg.configure(this);
        ABSTIMERREG1_reg.build();

        ABSTIMERREG2_reg = ABSTIMERREG2::type_id::create("ABSTIMERREG2");
        ABSTIMERREG2_reg.configure(this);
        ABSTIMERREG2_reg.build();

        ABSTIMERREG3_reg = ABSTIMERREG3::type_id::create("ABSTIMERREG3");
        ABSTIMERREG3_reg.configure(this);
        ABSTIMERREG3_reg.build();

        ABSTIMERREG4_reg = ABSTIMERREG4::type_id::create("ABSTIMERREG4");
        ABSTIMERREG4_reg.configure(this);
        ABSTIMERREG4_reg.build();

        ABSTIMERREG5_reg = ABSTIMERREG5::type_id::create("ABSTIMERREG5");
        ABSTIMERREG5_reg.configure(this);
        ABSTIMERREG5_reg.build();

        ABSTIMERREG6_reg = ABSTIMERREG6::type_id::create("ABSTIMERREG6");
        ABSTIMERREG6_reg.configure(this);
        ABSTIMERREG6_reg.build();

        ABSTIMERREG7_reg = ABSTIMERREG7::type_id::create("ABSTIMERREG7");
        ABSTIMERREG7_reg.configure(this);
        ABSTIMERREG7_reg.build();

        ABSTIMERREG8_reg = ABSTIMERREG8::type_id::create("ABSTIMERREG8");
        ABSTIMERREG8_reg.configure(this);
        ABSTIMERREG8_reg.build();

        ABSTIMERREG9_reg = ABSTIMERREG9::type_id::create("ABSTIMERREG9");
        ABSTIMERREG9_reg.configure(this);
        ABSTIMERREG9_reg.build();

        MAXRXLENGTHREG_reg = MAXRXLENGTHREG::type_id::create("MAXRXLENGTHREG");
        MAXRXLENGTHREG_reg.configure(this);
        MAXRXLENGTHREG_reg.build();

        EDCAAC0REG_reg = EDCAAC0REG::type_id::create("EDCAAC0REG");
        EDCAAC0REG_reg.configure(this);
        EDCAAC0REG_reg.build();

        EDCAAC1REG_reg = EDCAAC1REG::type_id::create("EDCAAC1REG");
        EDCAAC1REG_reg.configure(this);
        EDCAAC1REG_reg.build();

        EDCAAC2REG_reg = EDCAAC2REG::type_id::create("EDCAAC2REG");
        EDCAAC2REG_reg.configure(this);
        EDCAAC2REG_reg.build();

        EDCAAC3REG_reg = EDCAAC3REG::type_id::create("EDCAAC3REG");
        EDCAAC3REG_reg.configure(this);
        EDCAAC3REG_reg.build();

        EDCACCABUSYREG_reg = EDCACCABUSYREG::type_id::create("EDCACCABUSYREG");
        EDCACCABUSYREG_reg.configure(this);
        EDCACCABUSYREG_reg.build();

        EDCACNTRLREG_reg = EDCACNTRLREG::type_id::create("EDCACNTRLREG");
        EDCACNTRLREG_reg.configure(this);
        EDCACNTRLREG_reg.build();

        QUIETELEMENT1AREG_reg = QUIETELEMENT1AREG::type_id::create("QUIETELEMENT1AREG");
        QUIETELEMENT1AREG_reg.configure(this);
        QUIETELEMENT1AREG_reg.build();

        QUIETELEMENT1BREG_reg = QUIETELEMENT1BREG::type_id::create("QUIETELEMENT1BREG");
        QUIETELEMENT1BREG_reg.configure(this);
        QUIETELEMENT1BREG_reg.build();

        ADDCCABUSYSEC20REG_reg = ADDCCABUSYSEC20REG::type_id::create("ADDCCABUSYSEC20REG");
        ADDCCABUSYSEC20REG_reg.configure(this);
        ADDCCABUSYSEC20REG_reg.build();

        ADDCCABUSYSEC40REG_reg = ADDCCABUSYSEC40REG::type_id::create("ADDCCABUSYSEC40REG");
        ADDCCABUSYSEC40REG_reg.configure(this);
        ADDCCABUSYSEC40REG_reg.build();

        ADDCCABUSYSEC80REG_reg = ADDCCABUSYSEC80REG::type_id::create("ADDCCABUSYSEC80REG");
        ADDCCABUSYSEC80REG_reg.configure(this);
        ADDCCABUSYSEC80REG_reg.build();

        STBCCNTRLREG_reg = STBCCNTRLREG::type_id::create("STBCCNTRLREG");
        STBCCNTRLREG_reg.configure(this);
        STBCCNTRLREG_reg.build();

        TXBWCNTRLREG_reg = TXBWCNTRLREG::type_id::create("TXBWCNTRLREG");
        TXBWCNTRLREG_reg.configure(this);
        TXBWCNTRLREG_reg.build();

        HTMCSREG_reg = HTMCSREG::type_id::create("HTMCSREG");
        HTMCSREG_reg.configure(this);
        HTMCSREG_reg.build();

        VHTMCSREG_reg = VHTMCSREG::type_id::create("VHTMCSREG");
        VHTMCSREG_reg.configure(this);
        VHTMCSREG_reg.build();

        LSTPREG_reg = LSTPREG::type_id::create("LSTPREG");
        LSTPREG_reg.configure(this);
        LSTPREG_reg.build();

        HECONFIGREG_reg = HECONFIGREG::type_id::create("HECONFIGREG");
        HECONFIGREG_reg.configure(this);
        HECONFIGREG_reg.build();

        SPCONFIG1REG_reg = SPCONFIG1REG::type_id::create("SPCONFIG1REG");
        SPCONFIG1REG_reg.configure(this);
        SPCONFIG1REG_reg.build();

        SRGBSSCOLORBITMAPLOWREG_reg = SRGBSSCOLORBITMAPLOWREG::type_id::create("SRGBSSCOLORBITMAPLOWREG");
        SRGBSSCOLORBITMAPLOWREG_reg.configure(this);
        SRGBSSCOLORBITMAPLOWREG_reg.build();

        SRGBSSCOLORBITMAPHIGHREG_reg = SRGBSSCOLORBITMAPHIGHREG::type_id::create("SRGBSSCOLORBITMAPHIGHREG");
        SRGBSSCOLORBITMAPHIGHREG_reg.configure(this);
        SRGBSSCOLORBITMAPHIGHREG_reg.build();

        SRGPARTIALBSSIDBITMAPLOWREG_reg = SRGPARTIALBSSIDBITMAPLOWREG::type_id::create("SRGPARTIALBSSIDBITMAPLOWREG");
        SRGPARTIALBSSIDBITMAPLOWREG_reg.configure(this);
        SRGPARTIALBSSIDBITMAPLOWREG_reg.build();

        SRGPARTIALBSSIDBITMAPHIGHREG_reg = SRGPARTIALBSSIDBITMAPHIGHREG::type_id::create("SRGPARTIALBSSIDBITMAPHIGHREG");
        SRGPARTIALBSSIDBITMAPHIGHREG_reg.configure(this);
        SRGPARTIALBSSIDBITMAPHIGHREG_reg.build();

        BFMEECONTROLREG_reg = BFMEECONTROLREG::type_id::create("BFMEECONTROLREG");
        BFMEECONTROLREG_reg.configure(this);
        BFMEECONTROLREG_reg.build();

        COEXCONTROLREG_reg = COEXCONTROLREG::type_id::create("COEXCONTROLREG");
        COEXCONTROLREG_reg.configure(this);
        COEXCONTROLREG_reg.build();

        COEXPTIREG_reg = COEXPTIREG::type_id::create("COEXPTIREG");
        COEXPTIREG_reg.configure(this);
        COEXPTIREG_reg.build();

        COEXSTATREG_reg = COEXSTATREG::type_id::create("COEXSTATREG");
        COEXSTATREG_reg.configure(this);
        COEXSTATREG_reg.build();

        COEXINTREG_reg = COEXINTREG::type_id::create("COEXINTREG");
        COEXINTREG_reg.configure(this);
        COEXINTREG_reg.build();

        DEBUGHWSM1REG_reg = DEBUGHWSM1REG::type_id::create("DEBUGHWSM1REG");
        DEBUGHWSM1REG_reg.configure(this);
        DEBUGHWSM1REG_reg.build();

        DEBUGHWSM2REG_reg = DEBUGHWSM2REG::type_id::create("DEBUGHWSM2REG");
        DEBUGHWSM2REG_reg.configure(this);
        DEBUGHWSM2REG_reg.build();

        DEBUGPORTVALUEREG_reg = DEBUGPORTVALUEREG::type_id::create("DEBUGPORTVALUEREG");
        DEBUGPORTVALUEREG_reg.configure(this);
        DEBUGPORTVALUEREG_reg.build();

        DEBUGPORTSELREG_reg = DEBUGPORTSELREG::type_id::create("DEBUGPORTSELREG");
        DEBUGPORTSELREG_reg.configure(this);
        DEBUGPORTSELREG_reg.build();

        DEBUGBASICNAVREG_reg = DEBUGBASICNAVREG::type_id::create("DEBUGBASICNAVREG");
        DEBUGBASICNAVREG_reg.configure(this);
        DEBUGBASICNAVREG_reg.build();

        DEBUGCWREG_reg = DEBUGCWREG::type_id::create("DEBUGCWREG");
        DEBUGCWREG_reg.configure(this);
        DEBUGCWREG_reg.build();

        DEBUGQSRCREG_reg = DEBUGQSRCREG::type_id::create("DEBUGQSRCREG");
        DEBUGQSRCREG_reg.configure(this);
        DEBUGQSRCREG_reg.build();

        DEBUGQLRCREG_reg = DEBUGQLRCREG::type_id::create("DEBUGQLRCREG");
        DEBUGQLRCREG_reg.configure(this);
        DEBUGQLRCREG_reg.build();

        DEBUGUORAREG_reg = DEBUGUORAREG::type_id::create("DEBUGUORAREG");
        DEBUGUORAREG_reg.configure(this);
        DEBUGUORAREG_reg.build();

        DEBUGPHYREG_reg = DEBUGPHYREG::type_id::create("DEBUGPHYREG");
        DEBUGPHYREG_reg.configure(this);
        DEBUGPHYREG_reg.build();

        DEBUGINTRANAVREG_reg = DEBUGINTRANAVREG::type_id::create("DEBUGINTRANAVREG");
        DEBUGINTRANAVREG_reg.configure(this);
        DEBUGINTRANAVREG_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        MACCORE_register_map = create_map("MACCORE_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        MACCORE_register_map.add_reg(SIGNATUREREG_reg, 'h0, "RO");
        MACCORE_register_map.add_reg(VERSION1REG_reg, 'h4, "RO");
        MACCORE_register_map.add_reg(VERSION2REG_reg, 'h8, "RO");
        MACCORE_register_map.add_reg(BITMAPCNTREG_reg, 'hC, "RO");
        MACCORE_register_map.add_reg(MACADDRLOWREG_reg, 'h10, "RW");
        MACCORE_register_map.add_reg(MACADDRHIREG_reg, 'h14, "RW");
        MACCORE_register_map.add_reg(MACADDRLOWMASKREG_reg, 'h18, "RW");
        MACCORE_register_map.add_reg(MACADDRHIMASKREG_reg, 'h1C, "RW");
        MACCORE_register_map.add_reg(BSSIDLOWREG_reg, 'h20, "RW");
        MACCORE_register_map.add_reg(BSSIDHIREG_reg, 'h24, "RW");
        MACCORE_register_map.add_reg(BSSIDLOWMASKREG_reg, 'h28, "RW");
        MACCORE_register_map.add_reg(BSSIDHIMASKREG_reg, 'h2C, "RW");
        MACCORE_register_map.add_reg(BSSCOLORREG_reg, 'h34, "RW");
        MACCORE_register_map.add_reg(STATECNTRLREG_reg, 'h38, "RW");
        MACCORE_register_map.add_reg(SCANCNTRLREG_reg, 'h3C, "RW");
        MACCORE_register_map.add_reg(DOZECNTRL1REG_reg, 'h44, "RW");
        MACCORE_register_map.add_reg(MACCNTRL1REG_reg, 'h4C, "RW");
        MACCORE_register_map.add_reg(MACERRRECCNTRLREG_reg, 'h54, "RW");
        MACCORE_register_map.add_reg(MACERRSETSTATUSREG_reg, 'h58, "RW");
        MACCORE_register_map.add_reg(MACERRCLEARSTATUSREG_reg, 'h5C, "RW");
        MACCORE_register_map.add_reg(RXCNTRLREG_reg, 'h60, "RW");
        MACCORE_register_map.add_reg(BCNCNTRL1REG_reg, 'h64, "RW");
        MACCORE_register_map.add_reg(BCNCNTRL2REG_reg, 'h68, "RW");
        MACCORE_register_map.add_reg(DTIM1REG_reg, 'h90, "RW");
        MACCORE_register_map.add_reg(RETRYLIMITSREG_reg, 'h98, "RW");
        MACCORE_register_map.add_reg(BBSERVICEREG_reg, 'h9C, "RW");
        MACCORE_register_map.add_reg(MAXPOWERLEVELREG_reg, 'hA0, "RW");
        MACCORE_register_map.add_reg(ENCRKEY0REG_reg, 'hAC, "RW");
        MACCORE_register_map.add_reg(ENCRKEY1REG_reg, 'hB0, "RW");
        MACCORE_register_map.add_reg(ENCRKEY2REG_reg, 'hB4, "RW");
        MACCORE_register_map.add_reg(ENCRKEY3REG_reg, 'hB8, "RW");
        MACCORE_register_map.add_reg(ENCRMACADDRLOWREG_reg, 'hBC, "RW");
        MACCORE_register_map.add_reg(ENCRMACADDRHIGHREG_reg, 'hC0, "RW");
        MACCORE_register_map.add_reg(ENCRCNTRLREG_reg, 'hC4, "RW");
        MACCORE_register_map.add_reg(ENCRWPIINTKEY0REG_reg, 'hC8, "RW");
        MACCORE_register_map.add_reg(ENCRWPIINTKEY1REG_reg, 'hCC, "RW");
        MACCORE_register_map.add_reg(ENCRWPIINTKEY2REG_reg, 'hD0, "RW");
        MACCORE_register_map.add_reg(ENCRWPIINTKEY3REG_reg, 'hD4, "RW");
        MACCORE_register_map.add_reg(ENCRRAMCONFIGREG_reg, 'hD8, "RW");
        MACCORE_register_map.add_reg(RATESREG_reg, 'hDC, "RW");
        MACCORE_register_map.add_reg(OLBCREG_reg, 'hE0, "RW");
        MACCORE_register_map.add_reg(TIMINGS1REG_reg, 'hE4, "RW");
        MACCORE_register_map.add_reg(TIMINGS2REG_reg, 'hE8, "RW");
        MACCORE_register_map.add_reg(TIMINGS3REG_reg, 'hEC, "RW");
        MACCORE_register_map.add_reg(TIMINGS4REG_reg, 'hF0, "RW");
        MACCORE_register_map.add_reg(TIMINGS5REG_reg, 'hF4, "RW");
        MACCORE_register_map.add_reg(TIMINGS6REG_reg, 'hF8, "RW");
        MACCORE_register_map.add_reg(TIMINGS7REG_reg, 'hFC, "RW");
        MACCORE_register_map.add_reg(TIMINGS8REG_reg, 'h100, "RW");
        MACCORE_register_map.add_reg(TIMINGS9REG_reg, 'h104, "RW");
        MACCORE_register_map.add_reg(RXCNTRL2_reg, 'h10C, "RW");
        MACCORE_register_map.add_reg(TXTRIGGERTIMERREG_reg, 'h110, "RW");
        MACCORE_register_map.add_reg(RXTRIGGERTIMERREG_reg, 'h114, "RW");
        MACCORE_register_map.add_reg(MIBTABLEWRITEREG_reg, 'h118, "RW");
        MACCORE_register_map.add_reg(MONOTONICCOUNTER1REG_reg, 'h11C, "RO");
        MACCORE_register_map.add_reg(MONOTONICCOUNTER2LOREG_reg, 'h120, "RW");
        MACCORE_register_map.add_reg(MONOTONICCOUNTER2HIREG_reg, 'h124, "RW");
        MACCORE_register_map.add_reg(ABSTIMERREG0_reg, 'h128, "RW");
        MACCORE_register_map.add_reg(ABSTIMERREG1_reg, 'h12C, "RW");
        MACCORE_register_map.add_reg(ABSTIMERREG2_reg, 'h130, "RW");
        MACCORE_register_map.add_reg(ABSTIMERREG3_reg, 'h134, "RW");
        MACCORE_register_map.add_reg(ABSTIMERREG4_reg, 'h138, "RW");
        MACCORE_register_map.add_reg(ABSTIMERREG5_reg, 'h13C, "RW");
        MACCORE_register_map.add_reg(ABSTIMERREG6_reg, 'h140, "RW");
        MACCORE_register_map.add_reg(ABSTIMERREG7_reg, 'h144, "RW");
        MACCORE_register_map.add_reg(ABSTIMERREG8_reg, 'h148, "RW");
        MACCORE_register_map.add_reg(ABSTIMERREG9_reg, 'h14C, "RW");
        MACCORE_register_map.add_reg(MAXRXLENGTHREG_reg, 'h150, "RW");
        MACCORE_register_map.add_reg(EDCAAC0REG_reg, 'h200, "RW");
        MACCORE_register_map.add_reg(EDCAAC1REG_reg, 'h204, "RW");
        MACCORE_register_map.add_reg(EDCAAC2REG_reg, 'h208, "RW");
        MACCORE_register_map.add_reg(EDCAAC3REG_reg, 'h20C, "RW");
        MACCORE_register_map.add_reg(EDCACCABUSYREG_reg, 'h220, "RW");
        MACCORE_register_map.add_reg(EDCACNTRLREG_reg, 'h224, "RW");
        MACCORE_register_map.add_reg(QUIETELEMENT1AREG_reg, 'h280, "RW");
        MACCORE_register_map.add_reg(QUIETELEMENT1BREG_reg, 'h284, "RW");
        MACCORE_register_map.add_reg(ADDCCABUSYSEC20REG_reg, 'h290, "RW");
        MACCORE_register_map.add_reg(ADDCCABUSYSEC40REG_reg, 'h294, "RW");
        MACCORE_register_map.add_reg(ADDCCABUSYSEC80REG_reg, 'h298, "RW");
        MACCORE_register_map.add_reg(STBCCNTRLREG_reg, 'h300, "RW");
        MACCORE_register_map.add_reg(TXBWCNTRLREG_reg, 'h310, "RW");
        MACCORE_register_map.add_reg(HTMCSREG_reg, 'h314, "RW");
        MACCORE_register_map.add_reg(VHTMCSREG_reg, 'h31C, "RW");
        MACCORE_register_map.add_reg(LSTPREG_reg, 'h320, "RW");
        MACCORE_register_map.add_reg(HECONFIGREG_reg, 'h324, "RW");
        MACCORE_register_map.add_reg(SPCONFIG1REG_reg, 'h328, "RW");
        MACCORE_register_map.add_reg(SRGBSSCOLORBITMAPLOWREG_reg, 'h32C, "RW");
        MACCORE_register_map.add_reg(SRGBSSCOLORBITMAPHIGHREG_reg, 'h330, "RW");
        MACCORE_register_map.add_reg(SRGPARTIALBSSIDBITMAPLOWREG_reg, 'h334, "RW");
        MACCORE_register_map.add_reg(SRGPARTIALBSSIDBITMAPHIGHREG_reg, 'h338, "RW");
        MACCORE_register_map.add_reg(BFMEECONTROLREG_reg, 'h350, "RW");
        MACCORE_register_map.add_reg(COEXCONTROLREG_reg, 'h400, "RW");
        MACCORE_register_map.add_reg(COEXPTIREG_reg, 'h404, "RW");
        MACCORE_register_map.add_reg(COEXSTATREG_reg, 'h408, "RO");
        MACCORE_register_map.add_reg(COEXINTREG_reg, 'h40C, "RW");
        MACCORE_register_map.add_reg(DEBUGHWSM1REG_reg, 'h500, "RO");
        MACCORE_register_map.add_reg(DEBUGHWSM2REG_reg, 'h504, "RO");
        MACCORE_register_map.add_reg(DEBUGPORTVALUEREG_reg, 'h50C, "RO");
        MACCORE_register_map.add_reg(DEBUGPORTSELREG_reg, 'h510, "RW");
        MACCORE_register_map.add_reg(DEBUGBASICNAVREG_reg, 'h514, "RW");
        MACCORE_register_map.add_reg(DEBUGCWREG_reg, 'h518, "RW");
        MACCORE_register_map.add_reg(DEBUGQSRCREG_reg, 'h51C, "RO");
        MACCORE_register_map.add_reg(DEBUGQLRCREG_reg, 'h520, "RO");
        MACCORE_register_map.add_reg(DEBUGUORAREG_reg, 'h558, "RW");
        MACCORE_register_map.add_reg(DEBUGPHYREG_reg, 'h55C, "RW");
        MACCORE_register_map.add_reg(DEBUGINTRANAVREG_reg, 'h560, "RW");

        // Lock the register model and build the map
        lock_model();
        MACCORE_register_map.set_check_on_read();
    endfunction

endclass
`endif // __MACCORE_REG_BLOCK_SV__
