//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : lvalla
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for MACPL
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __MACPL_REG_BLOCK_SV__
`define __MACPL_REG_BLOCK_SV__

//--------------------------------------------------------------------
// NEXTTBTTREG
//--------------------------------------------------------------------
class NEXTTBTTREG extends uvm_reg;
    `uvm_object_utils(NEXTTBTTREG)
    rand uvm_reg_field nextTBTT;

    //---build------------------------------------------------------------
    virtual function void build();
        nextTBTT = uvm_reg_field::type_id::create("nextTBTT");

        nextTBTT.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_NEXTTBTTREG_rd_cg";
        nextTBTT_rd : coverpoint nextTBTT.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "NEXTTBTTREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DOZECNTRL2REG
//--------------------------------------------------------------------
class DOZECNTRL2REG extends uvm_reg;
    `uvm_object_utils(DOZECNTRL2REG)
    rand uvm_reg_field wakeUpFromDoze;
    rand uvm_reg_field wakeUpSW;

    //---build------------------------------------------------------------
    virtual function void build();
        wakeUpFromDoze = uvm_reg_field::type_id::create("wakeUpFromDoze");
        wakeUpSW = uvm_reg_field::type_id::create("wakeUpSW");

        wakeUpFromDoze.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        wakeUpSW.configure(this, 1, 0, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_DOZECNTRL2REG_wr_cg";
        wakeUpFromDoze_wr : coverpoint wakeUpFromDoze.value[0:0];
        wakeUpSW_wr : coverpoint wakeUpSW.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DOZECNTRL2REG_rd_cg";
        wakeUpFromDoze_rd : coverpoint wakeUpFromDoze.value[0:0];
        wakeUpSW_rd : coverpoint wakeUpSW.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DOZECNTRL2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MACCNTRL2REG
//--------------------------------------------------------------------
class MACCNTRL2REG extends uvm_reg;
    `uvm_object_utils(MACCNTRL2REG)
    rand uvm_reg_field softReset;

    //---build------------------------------------------------------------
    virtual function void build();
        softReset = uvm_reg_field::type_id::create("softReset");

        softReset.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_MACCNTRL2REG_wr_cg";
        softReset_wr : coverpoint softReset.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_MACCNTRL2REG_rd_cg";
        softReset_rd : coverpoint softReset.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MACCNTRL2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// GENINTEVENTSETREG
//--------------------------------------------------------------------
class GENINTEVENTSETREG extends uvm_reg;
    `uvm_object_utils(GENINTEVENTSETREG)
    rand uvm_reg_field settbTxDMADead;
    rand uvm_reg_field setrxPayloadDMADead;
    rand uvm_reg_field setrxHeaderDMADead;
    rand uvm_reg_field setphyRxStart;
    rand uvm_reg_field setphyErr;
    rand uvm_reg_field setmacPHYIFUnderRun;
    rand uvm_reg_field sethwErr;
    rand uvm_reg_field setimpSecDTIM;
    rand uvm_reg_field setimpPriDTIM;
    rand uvm_reg_field setbcnTxDMADead;
    rand uvm_reg_field setac3TxDMADead;
    rand uvm_reg_field setac2TxDMADead;
    rand uvm_reg_field setac1TxDMADead;
    rand uvm_reg_field setac0TxDMADead;
    rand uvm_reg_field setptError;
    rand uvm_reg_field settimSet;
    rand uvm_reg_field setolbcDSSS;
    rand uvm_reg_field setolbcOFDM;
    rand uvm_reg_field setrxFIFOOverFlow;
    rand uvm_reg_field setmacPHYIFOverflow;
    rand uvm_reg_field setcoexEvent;
    rand uvm_reg_field absGenTimers;
    rand uvm_reg_field setidleInterrupt;
    rand uvm_reg_field setimpSecTBTT;
    rand uvm_reg_field setimpPriTBTT;

    //---build------------------------------------------------------------
    virtual function void build();
        settbTxDMADead = uvm_reg_field::type_id::create("settbTxDMADead");
        setrxPayloadDMADead = uvm_reg_field::type_id::create("setrxPayloadDMADead");
        setrxHeaderDMADead = uvm_reg_field::type_id::create("setrxHeaderDMADead");
        setphyRxStart = uvm_reg_field::type_id::create("setphyRxStart");
        setphyErr = uvm_reg_field::type_id::create("setphyErr");
        setmacPHYIFUnderRun = uvm_reg_field::type_id::create("setmacPHYIFUnderRun");
        sethwErr = uvm_reg_field::type_id::create("sethwErr");
        setimpSecDTIM = uvm_reg_field::type_id::create("setimpSecDTIM");
        setimpPriDTIM = uvm_reg_field::type_id::create("setimpPriDTIM");
        setbcnTxDMADead = uvm_reg_field::type_id::create("setbcnTxDMADead");
        setac3TxDMADead = uvm_reg_field::type_id::create("setac3TxDMADead");
        setac2TxDMADead = uvm_reg_field::type_id::create("setac2TxDMADead");
        setac1TxDMADead = uvm_reg_field::type_id::create("setac1TxDMADead");
        setac0TxDMADead = uvm_reg_field::type_id::create("setac0TxDMADead");
        setptError = uvm_reg_field::type_id::create("setptError");
        settimSet = uvm_reg_field::type_id::create("settimSet");
        setolbcDSSS = uvm_reg_field::type_id::create("setolbcDSSS");
        setolbcOFDM = uvm_reg_field::type_id::create("setolbcOFDM");
        setrxFIFOOverFlow = uvm_reg_field::type_id::create("setrxFIFOOverFlow");
        setmacPHYIFOverflow = uvm_reg_field::type_id::create("setmacPHYIFOverflow");
        setcoexEvent = uvm_reg_field::type_id::create("setcoexEvent");
        absGenTimers = uvm_reg_field::type_id::create("absGenTimers");
        setidleInterrupt = uvm_reg_field::type_id::create("setidleInterrupt");
        setimpSecTBTT = uvm_reg_field::type_id::create("setimpSecTBTT");
        setimpPriTBTT = uvm_reg_field::type_id::create("setimpPriTBTT");

        settbTxDMADead.configure(this, 1, 26, "W1S", 1, 'b0, 1, 1, 1);
        setrxPayloadDMADead.configure(this, 1, 25, "W1S", 1, 'b0, 1, 1, 1);
        setrxHeaderDMADead.configure(this, 1, 24, "W1S", 1, 'b0, 1, 1, 1);
        setphyRxStart.configure(this, 1, 23, "W1S", 1, 'b0, 1, 1, 1);
        setphyErr.configure(this, 1, 22, "W1S", 1, 'b0, 1, 1, 1);
        setmacPHYIFUnderRun.configure(this, 1, 21, "W1S", 1, 'b0, 1, 1, 1);
        sethwErr.configure(this, 1, 20, "W1S", 1, 'b0, 1, 1, 1);
        setimpSecDTIM.configure(this, 1, 19, "W1S", 1, 'b0, 1, 1, 1);
        setimpPriDTIM.configure(this, 1, 18, "W1S", 1, 'b0, 1, 1, 1);
        setbcnTxDMADead.configure(this, 1, 17, "W1S", 1, 'b0, 1, 1, 1);
        setac3TxDMADead.configure(this, 1, 16, "W1S", 1, 'b0, 1, 1, 1);
        setac2TxDMADead.configure(this, 1, 15, "W1S", 1, 'b0, 1, 1, 1);
        setac1TxDMADead.configure(this, 1, 14, "W1S", 1, 'b0, 1, 1, 1);
        setac0TxDMADead.configure(this, 1, 13, "W1S", 1, 'b0, 1, 1, 1);
        setptError.configure(this, 1, 12, "W1S", 1, 'b0, 1, 1, 1);
        settimSet.configure(this, 1, 11, "W1S", 1, 'b0, 1, 1, 1);
        setolbcDSSS.configure(this, 1, 10, "W1S", 1, 'b0, 1, 1, 1);
        setolbcOFDM.configure(this, 1, 9, "W1S", 1, 'b0, 1, 1, 1);
        setrxFIFOOverFlow.configure(this, 1, 8, "W1S", 1, 'b0, 1, 1, 1);
        setmacPHYIFOverflow.configure(this, 1, 6, "W1S", 1, 'b0, 1, 1, 1);
        setcoexEvent.configure(this, 1, 5, "W1S", 1, 'b0, 1, 1, 1);
        absGenTimers.configure(this, 1, 3, "RO", 1, 'b0, 1, 1, 1);
        setidleInterrupt.configure(this, 1, 2, "W1S", 1, 'b0, 1, 1, 1);
        setimpSecTBTT.configure(this, 1, 1, "W1S", 1, 'b0, 1, 1, 1);
        setimpPriTBTT.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_GENINTEVENTSETREG_rd_cg";
        absGenTimers_rd : coverpoint absGenTimers.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "GENINTEVENTSETREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// GENINTEVENTCLEARREG
//--------------------------------------------------------------------
class GENINTEVENTCLEARREG extends uvm_reg;
    `uvm_object_utils(GENINTEVENTCLEARREG)
    rand uvm_reg_field cleartbTxDMADead;
    rand uvm_reg_field clearrxPayloadDMADead;
    rand uvm_reg_field clearrxHeaderDMADead;
    rand uvm_reg_field clearphyRxStart;
    rand uvm_reg_field clearphyErr;
    rand uvm_reg_field clearmacPHYIFUnderRun;
    rand uvm_reg_field clearhwErr;
    rand uvm_reg_field clearimpSecDTIM;
    rand uvm_reg_field clearimpPriDTIM;
    rand uvm_reg_field clearbcnTxDMADead;
    rand uvm_reg_field clearac3TxDMADead;
    rand uvm_reg_field clearac2TxDMADead;
    rand uvm_reg_field clearac1TxDMADead;
    rand uvm_reg_field clearac0TxDMADead;
    rand uvm_reg_field clearptError;
    rand uvm_reg_field cleartimSet;
    rand uvm_reg_field clearolbcDSSS;
    rand uvm_reg_field clearolbcOFDM;
    rand uvm_reg_field clearrxFIFOOverFlow;
    rand uvm_reg_field clearmacPHYIFOverflow;
    rand uvm_reg_field clearcoexEvent;
    rand uvm_reg_field clearidleInterrupt;
    rand uvm_reg_field clearimpSecTBTT;
    rand uvm_reg_field clearimpPriTBTT;

    //---build------------------------------------------------------------
    virtual function void build();
        cleartbTxDMADead = uvm_reg_field::type_id::create("cleartbTxDMADead");
        clearrxPayloadDMADead = uvm_reg_field::type_id::create("clearrxPayloadDMADead");
        clearrxHeaderDMADead = uvm_reg_field::type_id::create("clearrxHeaderDMADead");
        clearphyRxStart = uvm_reg_field::type_id::create("clearphyRxStart");
        clearphyErr = uvm_reg_field::type_id::create("clearphyErr");
        clearmacPHYIFUnderRun = uvm_reg_field::type_id::create("clearmacPHYIFUnderRun");
        clearhwErr = uvm_reg_field::type_id::create("clearhwErr");
        clearimpSecDTIM = uvm_reg_field::type_id::create("clearimpSecDTIM");
        clearimpPriDTIM = uvm_reg_field::type_id::create("clearimpPriDTIM");
        clearbcnTxDMADead = uvm_reg_field::type_id::create("clearbcnTxDMADead");
        clearac3TxDMADead = uvm_reg_field::type_id::create("clearac3TxDMADead");
        clearac2TxDMADead = uvm_reg_field::type_id::create("clearac2TxDMADead");
        clearac1TxDMADead = uvm_reg_field::type_id::create("clearac1TxDMADead");
        clearac0TxDMADead = uvm_reg_field::type_id::create("clearac0TxDMADead");
        clearptError = uvm_reg_field::type_id::create("clearptError");
        cleartimSet = uvm_reg_field::type_id::create("cleartimSet");
        clearolbcDSSS = uvm_reg_field::type_id::create("clearolbcDSSS");
        clearolbcOFDM = uvm_reg_field::type_id::create("clearolbcOFDM");
        clearrxFIFOOverFlow = uvm_reg_field::type_id::create("clearrxFIFOOverFlow");
        clearmacPHYIFOverflow = uvm_reg_field::type_id::create("clearmacPHYIFOverflow");
        clearcoexEvent = uvm_reg_field::type_id::create("clearcoexEvent");
        clearidleInterrupt = uvm_reg_field::type_id::create("clearidleInterrupt");
        clearimpSecTBTT = uvm_reg_field::type_id::create("clearimpSecTBTT");
        clearimpPriTBTT = uvm_reg_field::type_id::create("clearimpPriTBTT");

        cleartbTxDMADead.configure(this, 1, 26, "W1C", 1, 'b0, 1, 1, 1);
        clearrxPayloadDMADead.configure(this, 1, 25, "W1C", 1, 'b0, 1, 1, 1);
        clearrxHeaderDMADead.configure(this, 1, 24, "W1C", 1, 'b0, 1, 1, 1);
        clearphyRxStart.configure(this, 1, 23, "W1C", 1, 'b0, 1, 1, 1);
        clearphyErr.configure(this, 1, 22, "W1C", 1, 'b0, 1, 1, 1);
        clearmacPHYIFUnderRun.configure(this, 1, 21, "W1C", 1, 'b0, 1, 1, 1);
        clearhwErr.configure(this, 1, 20, "W1C", 1, 'b0, 1, 1, 1);
        clearimpSecDTIM.configure(this, 1, 19, "W1C", 1, 'b0, 1, 1, 1);
        clearimpPriDTIM.configure(this, 1, 18, "W1C", 1, 'b0, 1, 1, 1);
        clearbcnTxDMADead.configure(this, 1, 17, "W1C", 1, 'b0, 1, 1, 1);
        clearac3TxDMADead.configure(this, 1, 16, "W1C", 1, 'b0, 1, 1, 1);
        clearac2TxDMADead.configure(this, 1, 15, "W1C", 1, 'b0, 1, 1, 1);
        clearac1TxDMADead.configure(this, 1, 14, "W1C", 1, 'b0, 1, 1, 1);
        clearac0TxDMADead.configure(this, 1, 13, "W1C", 1, 'b0, 1, 1, 1);
        clearptError.configure(this, 1, 12, "W1C", 1, 'b0, 1, 1, 1);
        cleartimSet.configure(this, 1, 11, "W1C", 1, 'b0, 1, 1, 1);
        clearolbcDSSS.configure(this, 1, 10, "W1C", 1, 'b0, 1, 1, 1);
        clearolbcOFDM.configure(this, 1, 9, "W1C", 1, 'b0, 1, 1, 1);
        clearrxFIFOOverFlow.configure(this, 1, 8, "W1C", 1, 'b0, 1, 1, 1);
        clearmacPHYIFOverflow.configure(this, 1, 6, "W1C", 1, 'b0, 1, 1, 1);
        clearcoexEvent.configure(this, 1, 5, "W1C", 1, 'b0, 1, 1, 1);
        clearidleInterrupt.configure(this, 1, 2, "W1C", 1, 'b0, 1, 1, 1);
        clearimpSecTBTT.configure(this, 1, 1, "W1C", 1, 'b0, 1, 1, 1);
        clearimpPriTBTT.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_GENINTEVENTCLEARREG_wr_cg";
        cleartbTxDMADead_wr : coverpoint cleartbTxDMADead.value[0:0];
        clearrxPayloadDMADead_wr : coverpoint clearrxPayloadDMADead.value[0:0];
        clearrxHeaderDMADead_wr : coverpoint clearrxHeaderDMADead.value[0:0];
        clearphyRxStart_wr : coverpoint clearphyRxStart.value[0:0];
        clearphyErr_wr : coverpoint clearphyErr.value[0:0];
        clearmacPHYIFUnderRun_wr : coverpoint clearmacPHYIFUnderRun.value[0:0];
        clearhwErr_wr : coverpoint clearhwErr.value[0:0];
        clearimpSecDTIM_wr : coverpoint clearimpSecDTIM.value[0:0];
        clearimpPriDTIM_wr : coverpoint clearimpPriDTIM.value[0:0];
        clearbcnTxDMADead_wr : coverpoint clearbcnTxDMADead.value[0:0];
        clearac3TxDMADead_wr : coverpoint clearac3TxDMADead.value[0:0];
        clearac2TxDMADead_wr : coverpoint clearac2TxDMADead.value[0:0];
        clearac1TxDMADead_wr : coverpoint clearac1TxDMADead.value[0:0];
        clearac0TxDMADead_wr : coverpoint clearac0TxDMADead.value[0:0];
        clearptError_wr : coverpoint clearptError.value[0:0];
        cleartimSet_wr : coverpoint cleartimSet.value[0:0];
        clearolbcDSSS_wr : coverpoint clearolbcDSSS.value[0:0];
        clearolbcOFDM_wr : coverpoint clearolbcOFDM.value[0:0];
        clearrxFIFOOverFlow_wr : coverpoint clearrxFIFOOverFlow.value[0:0];
        clearmacPHYIFOverflow_wr : coverpoint clearmacPHYIFOverflow.value[0:0];
        clearcoexEvent_wr : coverpoint clearcoexEvent.value[0:0];
        clearidleInterrupt_wr : coverpoint clearidleInterrupt.value[0:0];
        clearimpSecTBTT_wr : coverpoint clearimpSecTBTT.value[0:0];
        clearimpPriTBTT_wr : coverpoint clearimpPriTBTT.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "GENINTEVENTCLEARREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// GENINTUNMASKREG
//--------------------------------------------------------------------
class GENINTUNMASKREG extends uvm_reg;
    `uvm_object_utils(GENINTUNMASKREG)
    rand uvm_reg_field masterGenIntEn;
    rand uvm_reg_field masktbTxDMADead;
    rand uvm_reg_field maskrxPayloadDMADead;
    rand uvm_reg_field maskrxHeaderDMADead;
    rand uvm_reg_field maskphyRxStart;
    rand uvm_reg_field maskphyErr;
    rand uvm_reg_field maskmacPHYIFUnderRun;
    rand uvm_reg_field maskhwErr;
    rand uvm_reg_field maskimpSecDTIM;
    rand uvm_reg_field maskimpPriDTIM;
    rand uvm_reg_field maskbcnTxDMADead;
    rand uvm_reg_field maskac3TxDMADead;
    rand uvm_reg_field maskac2TxDMADead;
    rand uvm_reg_field maskac1TxDMADead;
    rand uvm_reg_field maskac0TxDMADead;
    rand uvm_reg_field maskptError;
    rand uvm_reg_field masktimSet;
    rand uvm_reg_field maskolbcDSSS;
    rand uvm_reg_field maskolbcOFDM;
    rand uvm_reg_field maskrxFIFOOverFlow;
    rand uvm_reg_field maskmacPHYIFOverflow;
    rand uvm_reg_field maskcoexEvent;
    rand uvm_reg_field maskabsGenTimers;
    rand uvm_reg_field maskidleInterrupt;
    rand uvm_reg_field maskimpSecTBTT;
    rand uvm_reg_field maskimpPriTBTT;

    //---build------------------------------------------------------------
    virtual function void build();
        masterGenIntEn = uvm_reg_field::type_id::create("masterGenIntEn");
        masktbTxDMADead = uvm_reg_field::type_id::create("masktbTxDMADead");
        maskrxPayloadDMADead = uvm_reg_field::type_id::create("maskrxPayloadDMADead");
        maskrxHeaderDMADead = uvm_reg_field::type_id::create("maskrxHeaderDMADead");
        maskphyRxStart = uvm_reg_field::type_id::create("maskphyRxStart");
        maskphyErr = uvm_reg_field::type_id::create("maskphyErr");
        maskmacPHYIFUnderRun = uvm_reg_field::type_id::create("maskmacPHYIFUnderRun");
        maskhwErr = uvm_reg_field::type_id::create("maskhwErr");
        maskimpSecDTIM = uvm_reg_field::type_id::create("maskimpSecDTIM");
        maskimpPriDTIM = uvm_reg_field::type_id::create("maskimpPriDTIM");
        maskbcnTxDMADead = uvm_reg_field::type_id::create("maskbcnTxDMADead");
        maskac3TxDMADead = uvm_reg_field::type_id::create("maskac3TxDMADead");
        maskac2TxDMADead = uvm_reg_field::type_id::create("maskac2TxDMADead");
        maskac1TxDMADead = uvm_reg_field::type_id::create("maskac1TxDMADead");
        maskac0TxDMADead = uvm_reg_field::type_id::create("maskac0TxDMADead");
        maskptError = uvm_reg_field::type_id::create("maskptError");
        masktimSet = uvm_reg_field::type_id::create("masktimSet");
        maskolbcDSSS = uvm_reg_field::type_id::create("maskolbcDSSS");
        maskolbcOFDM = uvm_reg_field::type_id::create("maskolbcOFDM");
        maskrxFIFOOverFlow = uvm_reg_field::type_id::create("maskrxFIFOOverFlow");
        maskmacPHYIFOverflow = uvm_reg_field::type_id::create("maskmacPHYIFOverflow");
        maskcoexEvent = uvm_reg_field::type_id::create("maskcoexEvent");
        maskabsGenTimers = uvm_reg_field::type_id::create("maskabsGenTimers");
        maskidleInterrupt = uvm_reg_field::type_id::create("maskidleInterrupt");
        maskimpSecTBTT = uvm_reg_field::type_id::create("maskimpSecTBTT");
        maskimpPriTBTT = uvm_reg_field::type_id::create("maskimpPriTBTT");

        masterGenIntEn.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        masktbTxDMADead.configure(this, 1, 26, "RW", 1, 'b0, 1, 1, 1);
        maskrxPayloadDMADead.configure(this, 1, 25, "RW", 1, 'b0, 1, 1, 1);
        maskrxHeaderDMADead.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        maskphyRxStart.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        maskphyErr.configure(this, 1, 22, "RW", 1, 'b0, 1, 1, 1);
        maskmacPHYIFUnderRun.configure(this, 1, 21, "RW", 1, 'b0, 1, 1, 1);
        maskhwErr.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        maskimpSecDTIM.configure(this, 1, 19, "RW", 1, 'b0, 1, 1, 1);
        maskimpPriDTIM.configure(this, 1, 18, "RW", 1, 'b0, 1, 1, 1);
        maskbcnTxDMADead.configure(this, 1, 17, "RW", 1, 'b0, 1, 1, 1);
        maskac3TxDMADead.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        maskac2TxDMADead.configure(this, 1, 15, "RW", 1, 'b0, 1, 1, 1);
        maskac1TxDMADead.configure(this, 1, 14, "RW", 1, 'b0, 1, 1, 1);
        maskac0TxDMADead.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        maskptError.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        masktimSet.configure(this, 1, 11, "RW", 1, 'b0, 1, 1, 1);
        maskolbcDSSS.configure(this, 1, 10, "RW", 1, 'b0, 1, 1, 1);
        maskolbcOFDM.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        maskrxFIFOOverFlow.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        maskmacPHYIFOverflow.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        maskcoexEvent.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        maskabsGenTimers.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        maskidleInterrupt.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        maskimpSecTBTT.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        maskimpPriTBTT.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_GENINTUNMASKREG_wr_cg";
        masterGenIntEn_wr : coverpoint masterGenIntEn.value[0:0];
        masktbTxDMADead_wr : coverpoint masktbTxDMADead.value[0:0];
        maskrxPayloadDMADead_wr : coverpoint maskrxPayloadDMADead.value[0:0];
        maskrxHeaderDMADead_wr : coverpoint maskrxHeaderDMADead.value[0:0];
        maskphyRxStart_wr : coverpoint maskphyRxStart.value[0:0];
        maskphyErr_wr : coverpoint maskphyErr.value[0:0];
        maskmacPHYIFUnderRun_wr : coverpoint maskmacPHYIFUnderRun.value[0:0];
        maskhwErr_wr : coverpoint maskhwErr.value[0:0];
        maskimpSecDTIM_wr : coverpoint maskimpSecDTIM.value[0:0];
        maskimpPriDTIM_wr : coverpoint maskimpPriDTIM.value[0:0];
        maskbcnTxDMADead_wr : coverpoint maskbcnTxDMADead.value[0:0];
        maskac3TxDMADead_wr : coverpoint maskac3TxDMADead.value[0:0];
        maskac2TxDMADead_wr : coverpoint maskac2TxDMADead.value[0:0];
        maskac1TxDMADead_wr : coverpoint maskac1TxDMADead.value[0:0];
        maskac0TxDMADead_wr : coverpoint maskac0TxDMADead.value[0:0];
        maskptError_wr : coverpoint maskptError.value[0:0];
        masktimSet_wr : coverpoint masktimSet.value[0:0];
        maskolbcDSSS_wr : coverpoint maskolbcDSSS.value[0:0];
        maskolbcOFDM_wr : coverpoint maskolbcOFDM.value[0:0];
        maskrxFIFOOverFlow_wr : coverpoint maskrxFIFOOverFlow.value[0:0];
        maskmacPHYIFOverflow_wr : coverpoint maskmacPHYIFOverflow.value[0:0];
        maskcoexEvent_wr : coverpoint maskcoexEvent.value[0:0];
        maskabsGenTimers_wr : coverpoint maskabsGenTimers.value[0:0];
        maskidleInterrupt_wr : coverpoint maskidleInterrupt.value[0:0];
        maskimpSecTBTT_wr : coverpoint maskimpSecTBTT.value[0:0];
        maskimpPriTBTT_wr : coverpoint maskimpPriTBTT.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_GENINTUNMASKREG_rd_cg";
        masterGenIntEn_rd : coverpoint masterGenIntEn.value[0:0];
        masktbTxDMADead_rd : coverpoint masktbTxDMADead.value[0:0];
        maskrxPayloadDMADead_rd : coverpoint maskrxPayloadDMADead.value[0:0];
        maskrxHeaderDMADead_rd : coverpoint maskrxHeaderDMADead.value[0:0];
        maskphyRxStart_rd : coverpoint maskphyRxStart.value[0:0];
        maskphyErr_rd : coverpoint maskphyErr.value[0:0];
        maskmacPHYIFUnderRun_rd : coverpoint maskmacPHYIFUnderRun.value[0:0];
        maskhwErr_rd : coverpoint maskhwErr.value[0:0];
        maskimpSecDTIM_rd : coverpoint maskimpSecDTIM.value[0:0];
        maskimpPriDTIM_rd : coverpoint maskimpPriDTIM.value[0:0];
        maskbcnTxDMADead_rd : coverpoint maskbcnTxDMADead.value[0:0];
        maskac3TxDMADead_rd : coverpoint maskac3TxDMADead.value[0:0];
        maskac2TxDMADead_rd : coverpoint maskac2TxDMADead.value[0:0];
        maskac1TxDMADead_rd : coverpoint maskac1TxDMADead.value[0:0];
        maskac0TxDMADead_rd : coverpoint maskac0TxDMADead.value[0:0];
        maskptError_rd : coverpoint maskptError.value[0:0];
        masktimSet_rd : coverpoint masktimSet.value[0:0];
        maskolbcDSSS_rd : coverpoint maskolbcDSSS.value[0:0];
        maskolbcOFDM_rd : coverpoint maskolbcOFDM.value[0:0];
        maskrxFIFOOverFlow_rd : coverpoint maskrxFIFOOverFlow.value[0:0];
        maskmacPHYIFOverflow_rd : coverpoint maskmacPHYIFOverflow.value[0:0];
        maskcoexEvent_rd : coverpoint maskcoexEvent.value[0:0];
        maskabsGenTimers_rd : coverpoint maskabsGenTimers.value[0:0];
        maskidleInterrupt_rd : coverpoint maskidleInterrupt.value[0:0];
        maskimpSecTBTT_rd : coverpoint maskimpSecTBTT.value[0:0];
        maskimpPriTBTT_rd : coverpoint maskimpPriTBTT.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "GENINTUNMASKREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXRXINTEVENTSETREG
//--------------------------------------------------------------------
class TXRXINTEVENTSETREG extends uvm_reg;
    `uvm_object_utils(TXRXINTEVENTSETREG)
    rand uvm_reg_field settbTxBufTrigger;
    rand uvm_reg_field setbcnTxBufTrigger;
    rand uvm_reg_field setac3TxBufTrigger;
    rand uvm_reg_field setac2TxBufTrigger;
    rand uvm_reg_field setac1TxBufTrigger;
    rand uvm_reg_field setac0TxBufTrigger;
    rand uvm_reg_field setac3BWDropTrigger;
    rand uvm_reg_field setac2BWDropTrigger;
    rand uvm_reg_field setac1BWDropTrigger;
    rand uvm_reg_field setac0BWDropTrigger;
    rand uvm_reg_field setrxBuffer2Trigger;
    rand uvm_reg_field settimerRxTrigger;
    rand uvm_reg_field setrxBuffer1Trigger;
    rand uvm_reg_field setsecUserTxTrigger;
    rand uvm_reg_field settimerTxTrigger;
    rand uvm_reg_field settxopComplete;
    rand uvm_reg_field settbTxCancelled;
    rand uvm_reg_field settbTxTrigger;
    rand uvm_reg_field setbcnTxTrigger;
    rand uvm_reg_field setac3TxTrigger;
    rand uvm_reg_field setac2TxTrigger;
    rand uvm_reg_field setac1TxTrigger;
    rand uvm_reg_field setac0TxTrigger;
    rand uvm_reg_field settbProtTrigger;
    rand uvm_reg_field setac3ProtTrigger;
    rand uvm_reg_field setac2ProtTrigger;
    rand uvm_reg_field setac1ProtTrigger;
    rand uvm_reg_field setac0ProtTrigger;

    //---build------------------------------------------------------------
    virtual function void build();
        settbTxBufTrigger = uvm_reg_field::type_id::create("settbTxBufTrigger");
        setbcnTxBufTrigger = uvm_reg_field::type_id::create("setbcnTxBufTrigger");
        setac3TxBufTrigger = uvm_reg_field::type_id::create("setac3TxBufTrigger");
        setac2TxBufTrigger = uvm_reg_field::type_id::create("setac2TxBufTrigger");
        setac1TxBufTrigger = uvm_reg_field::type_id::create("setac1TxBufTrigger");
        setac0TxBufTrigger = uvm_reg_field::type_id::create("setac0TxBufTrigger");
        setac3BWDropTrigger = uvm_reg_field::type_id::create("setac3BWDropTrigger");
        setac2BWDropTrigger = uvm_reg_field::type_id::create("setac2BWDropTrigger");
        setac1BWDropTrigger = uvm_reg_field::type_id::create("setac1BWDropTrigger");
        setac0BWDropTrigger = uvm_reg_field::type_id::create("setac0BWDropTrigger");
        setrxBuffer2Trigger = uvm_reg_field::type_id::create("setrxBuffer2Trigger");
        settimerRxTrigger = uvm_reg_field::type_id::create("settimerRxTrigger");
        setrxBuffer1Trigger = uvm_reg_field::type_id::create("setrxBuffer1Trigger");
        setsecUserTxTrigger = uvm_reg_field::type_id::create("setsecUserTxTrigger");
        settimerTxTrigger = uvm_reg_field::type_id::create("settimerTxTrigger");
        settxopComplete = uvm_reg_field::type_id::create("settxopComplete");
        settbTxCancelled = uvm_reg_field::type_id::create("settbTxCancelled");
        settbTxTrigger = uvm_reg_field::type_id::create("settbTxTrigger");
        setbcnTxTrigger = uvm_reg_field::type_id::create("setbcnTxTrigger");
        setac3TxTrigger = uvm_reg_field::type_id::create("setac3TxTrigger");
        setac2TxTrigger = uvm_reg_field::type_id::create("setac2TxTrigger");
        setac1TxTrigger = uvm_reg_field::type_id::create("setac1TxTrigger");
        setac0TxTrigger = uvm_reg_field::type_id::create("setac0TxTrigger");
        settbProtTrigger = uvm_reg_field::type_id::create("settbProtTrigger");
        setac3ProtTrigger = uvm_reg_field::type_id::create("setac3ProtTrigger");
        setac2ProtTrigger = uvm_reg_field::type_id::create("setac2ProtTrigger");
        setac1ProtTrigger = uvm_reg_field::type_id::create("setac1ProtTrigger");
        setac0ProtTrigger = uvm_reg_field::type_id::create("setac0ProtTrigger");

        settbTxBufTrigger.configure(this, 1, 29, "W1S", 1, 'b0, 1, 1, 1);
        setbcnTxBufTrigger.configure(this, 1, 28, "W1S", 1, 'b0, 1, 1, 1);
        setac3TxBufTrigger.configure(this, 1, 27, "W1S", 1, 'b0, 1, 1, 1);
        setac2TxBufTrigger.configure(this, 1, 26, "W1S", 1, 'b0, 1, 1, 1);
        setac1TxBufTrigger.configure(this, 1, 25, "W1S", 1, 'b0, 1, 1, 1);
        setac0TxBufTrigger.configure(this, 1, 24, "W1S", 1, 'b0, 1, 1, 1);
        setac3BWDropTrigger.configure(this, 1, 23, "W1S", 1, 'b0, 1, 1, 1);
        setac2BWDropTrigger.configure(this, 1, 22, "W1S", 1, 'b0, 1, 1, 1);
        setac1BWDropTrigger.configure(this, 1, 21, "W1S", 1, 'b0, 1, 1, 1);
        setac0BWDropTrigger.configure(this, 1, 20, "W1S", 1, 'b0, 1, 1, 1);
        setrxBuffer2Trigger.configure(this, 1, 18, "W1S", 1, 'b0, 1, 1, 1);
        settimerRxTrigger.configure(this, 1, 17, "W1S", 1, 'b0, 1, 1, 1);
        setrxBuffer1Trigger.configure(this, 1, 16, "W1S", 1, 'b0, 1, 1, 1);
        setsecUserTxTrigger.configure(this, 1, 15, "RO", 1, 'b0, 1, 1, 1);
        settimerTxTrigger.configure(this, 1, 14, "W1S", 1, 'b0, 1, 1, 1);
        settxopComplete.configure(this, 1, 13, "W1S", 1, 'b0, 1, 1, 1);
        settbTxCancelled.configure(this, 1, 12, "W1S", 1, 'b0, 1, 1, 1);
        settbTxTrigger.configure(this, 1, 11, "W1S", 1, 'b0, 1, 1, 1);
        setbcnTxTrigger.configure(this, 1, 10, "W1S", 1, 'b0, 1, 1, 1);
        setac3TxTrigger.configure(this, 1, 9, "W1S", 1, 'b0, 1, 1, 1);
        setac2TxTrigger.configure(this, 1, 8, "W1S", 1, 'b0, 1, 1, 1);
        setac1TxTrigger.configure(this, 1, 7, "W1S", 1, 'b0, 1, 1, 1);
        setac0TxTrigger.configure(this, 1, 6, "W1S", 1, 'b0, 1, 1, 1);
        settbProtTrigger.configure(this, 1, 4, "W1S", 1, 'b0, 1, 1, 1);
        setac3ProtTrigger.configure(this, 1, 3, "W1S", 1, 'b0, 1, 1, 1);
        setac2ProtTrigger.configure(this, 1, 2, "W1S", 1, 'b0, 1, 1, 1);
        setac1ProtTrigger.configure(this, 1, 1, "W1S", 1, 'b0, 1, 1, 1);
        setac0ProtTrigger.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXRXINTEVENTSETREG_rd_cg";
        setsecUserTxTrigger_rd : coverpoint setsecUserTxTrigger.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXRXINTEVENTSETREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXRXINTEVENTCLEARREG
//--------------------------------------------------------------------
class TXRXINTEVENTCLEARREG extends uvm_reg;
    `uvm_object_utils(TXRXINTEVENTCLEARREG)
    rand uvm_reg_field cleartbTxBufTrigger;
    rand uvm_reg_field clearbcnTxBufTrigger;
    rand uvm_reg_field clearac3TxBufTrigger;
    rand uvm_reg_field clearac2TxBufTrigger;
    rand uvm_reg_field clearac1TxBufTrigger;
    rand uvm_reg_field clearac0TxBufTrigger;
    rand uvm_reg_field clearac3BWDropTrigger;
    rand uvm_reg_field clearac2BWDropTrigger;
    rand uvm_reg_field clearac1BWDropTrigger;
    rand uvm_reg_field clearac0BWDropTrigger;
    rand uvm_reg_field clearrxBuffer2Trigger;
    rand uvm_reg_field cleartimerRxTrigger;
    rand uvm_reg_field clearrxBuffer1Trigger;
    rand uvm_reg_field cleartimerTxTrigger;
    rand uvm_reg_field cleartxopComplete;
    rand uvm_reg_field cleartbTxCancelled;
    rand uvm_reg_field cleartbTxTrigger;
    rand uvm_reg_field clearbcnTxTrigger;
    rand uvm_reg_field clearac3TxTrigger;
    rand uvm_reg_field clearac2TxTrigger;
    rand uvm_reg_field clearac1TxTrigger;
    rand uvm_reg_field clearac0TxTrigger;
    rand uvm_reg_field cleartbProtTrigger;
    rand uvm_reg_field clearac3ProtTrigger;
    rand uvm_reg_field clearac2ProtTrigger;
    rand uvm_reg_field clearac1ProtTrigger;
    rand uvm_reg_field clearac0ProtTrigger;

    //---build------------------------------------------------------------
    virtual function void build();
        cleartbTxBufTrigger = uvm_reg_field::type_id::create("cleartbTxBufTrigger");
        clearbcnTxBufTrigger = uvm_reg_field::type_id::create("clearbcnTxBufTrigger");
        clearac3TxBufTrigger = uvm_reg_field::type_id::create("clearac3TxBufTrigger");
        clearac2TxBufTrigger = uvm_reg_field::type_id::create("clearac2TxBufTrigger");
        clearac1TxBufTrigger = uvm_reg_field::type_id::create("clearac1TxBufTrigger");
        clearac0TxBufTrigger = uvm_reg_field::type_id::create("clearac0TxBufTrigger");
        clearac3BWDropTrigger = uvm_reg_field::type_id::create("clearac3BWDropTrigger");
        clearac2BWDropTrigger = uvm_reg_field::type_id::create("clearac2BWDropTrigger");
        clearac1BWDropTrigger = uvm_reg_field::type_id::create("clearac1BWDropTrigger");
        clearac0BWDropTrigger = uvm_reg_field::type_id::create("clearac0BWDropTrigger");
        clearrxBuffer2Trigger = uvm_reg_field::type_id::create("clearrxBuffer2Trigger");
        cleartimerRxTrigger = uvm_reg_field::type_id::create("cleartimerRxTrigger");
        clearrxBuffer1Trigger = uvm_reg_field::type_id::create("clearrxBuffer1Trigger");
        cleartimerTxTrigger = uvm_reg_field::type_id::create("cleartimerTxTrigger");
        cleartxopComplete = uvm_reg_field::type_id::create("cleartxopComplete");
        cleartbTxCancelled = uvm_reg_field::type_id::create("cleartbTxCancelled");
        cleartbTxTrigger = uvm_reg_field::type_id::create("cleartbTxTrigger");
        clearbcnTxTrigger = uvm_reg_field::type_id::create("clearbcnTxTrigger");
        clearac3TxTrigger = uvm_reg_field::type_id::create("clearac3TxTrigger");
        clearac2TxTrigger = uvm_reg_field::type_id::create("clearac2TxTrigger");
        clearac1TxTrigger = uvm_reg_field::type_id::create("clearac1TxTrigger");
        clearac0TxTrigger = uvm_reg_field::type_id::create("clearac0TxTrigger");
        cleartbProtTrigger = uvm_reg_field::type_id::create("cleartbProtTrigger");
        clearac3ProtTrigger = uvm_reg_field::type_id::create("clearac3ProtTrigger");
        clearac2ProtTrigger = uvm_reg_field::type_id::create("clearac2ProtTrigger");
        clearac1ProtTrigger = uvm_reg_field::type_id::create("clearac1ProtTrigger");
        clearac0ProtTrigger = uvm_reg_field::type_id::create("clearac0ProtTrigger");

        cleartbTxBufTrigger.configure(this, 1, 29, "W1C", 1, 'b0, 1, 1, 1);
        clearbcnTxBufTrigger.configure(this, 1, 28, "W1C", 1, 'b0, 1, 1, 1);
        clearac3TxBufTrigger.configure(this, 1, 27, "W1C", 1, 'b0, 1, 1, 1);
        clearac2TxBufTrigger.configure(this, 1, 26, "W1C", 1, 'b0, 1, 1, 1);
        clearac1TxBufTrigger.configure(this, 1, 25, "W1C", 1, 'b0, 1, 1, 1);
        clearac0TxBufTrigger.configure(this, 1, 24, "W1C", 1, 'b0, 1, 1, 1);
        clearac3BWDropTrigger.configure(this, 1, 23, "W1C", 1, 'b0, 1, 1, 1);
        clearac2BWDropTrigger.configure(this, 1, 22, "W1C", 1, 'b0, 1, 1, 1);
        clearac1BWDropTrigger.configure(this, 1, 21, "W1C", 1, 'b0, 1, 1, 1);
        clearac0BWDropTrigger.configure(this, 1, 20, "W1C", 1, 'b0, 1, 1, 1);
        clearrxBuffer2Trigger.configure(this, 1, 18, "W1C", 1, 'b0, 1, 1, 1);
        cleartimerRxTrigger.configure(this, 1, 17, "W1C", 1, 'b0, 1, 1, 1);
        clearrxBuffer1Trigger.configure(this, 1, 16, "W1C", 1, 'b0, 1, 1, 1);
        cleartimerTxTrigger.configure(this, 1, 14, "W1C", 1, 'b0, 1, 1, 1);
        cleartxopComplete.configure(this, 1, 13, "W1C", 1, 'b0, 1, 1, 1);
        cleartbTxCancelled.configure(this, 1, 12, "W1C", 1, 'b0, 1, 1, 1);
        cleartbTxTrigger.configure(this, 1, 11, "W1C", 1, 'b0, 1, 1, 1);
        clearbcnTxTrigger.configure(this, 1, 10, "W1C", 1, 'b0, 1, 1, 1);
        clearac3TxTrigger.configure(this, 1, 9, "W1C", 1, 'b0, 1, 1, 1);
        clearac2TxTrigger.configure(this, 1, 8, "W1C", 1, 'b0, 1, 1, 1);
        clearac1TxTrigger.configure(this, 1, 7, "W1C", 1, 'b0, 1, 1, 1);
        clearac0TxTrigger.configure(this, 1, 6, "W1C", 1, 'b0, 1, 1, 1);
        cleartbProtTrigger.configure(this, 1, 4, "W1C", 1, 'b0, 1, 1, 1);
        clearac3ProtTrigger.configure(this, 1, 3, "W1C", 1, 'b0, 1, 1, 1);
        clearac2ProtTrigger.configure(this, 1, 2, "W1C", 1, 'b0, 1, 1, 1);
        clearac1ProtTrigger.configure(this, 1, 1, "W1C", 1, 'b0, 1, 1, 1);
        clearac0ProtTrigger.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TXRXINTEVENTCLEARREG_wr_cg";
        cleartbTxBufTrigger_wr : coverpoint cleartbTxBufTrigger.value[0:0];
        clearbcnTxBufTrigger_wr : coverpoint clearbcnTxBufTrigger.value[0:0];
        clearac3TxBufTrigger_wr : coverpoint clearac3TxBufTrigger.value[0:0];
        clearac2TxBufTrigger_wr : coverpoint clearac2TxBufTrigger.value[0:0];
        clearac1TxBufTrigger_wr : coverpoint clearac1TxBufTrigger.value[0:0];
        clearac0TxBufTrigger_wr : coverpoint clearac0TxBufTrigger.value[0:0];
        clearac3BWDropTrigger_wr : coverpoint clearac3BWDropTrigger.value[0:0];
        clearac2BWDropTrigger_wr : coverpoint clearac2BWDropTrigger.value[0:0];
        clearac1BWDropTrigger_wr : coverpoint clearac1BWDropTrigger.value[0:0];
        clearac0BWDropTrigger_wr : coverpoint clearac0BWDropTrigger.value[0:0];
        clearrxBuffer2Trigger_wr : coverpoint clearrxBuffer2Trigger.value[0:0];
        cleartimerRxTrigger_wr : coverpoint cleartimerRxTrigger.value[0:0];
        clearrxBuffer1Trigger_wr : coverpoint clearrxBuffer1Trigger.value[0:0];
        cleartimerTxTrigger_wr : coverpoint cleartimerTxTrigger.value[0:0];
        cleartxopComplete_wr : coverpoint cleartxopComplete.value[0:0];
        cleartbTxCancelled_wr : coverpoint cleartbTxCancelled.value[0:0];
        cleartbTxTrigger_wr : coverpoint cleartbTxTrigger.value[0:0];
        clearbcnTxTrigger_wr : coverpoint clearbcnTxTrigger.value[0:0];
        clearac3TxTrigger_wr : coverpoint clearac3TxTrigger.value[0:0];
        clearac2TxTrigger_wr : coverpoint clearac2TxTrigger.value[0:0];
        clearac1TxTrigger_wr : coverpoint clearac1TxTrigger.value[0:0];
        clearac0TxTrigger_wr : coverpoint clearac0TxTrigger.value[0:0];
        cleartbProtTrigger_wr : coverpoint cleartbProtTrigger.value[0:0];
        clearac3ProtTrigger_wr : coverpoint clearac3ProtTrigger.value[0:0];
        clearac2ProtTrigger_wr : coverpoint clearac2ProtTrigger.value[0:0];
        clearac1ProtTrigger_wr : coverpoint clearac1ProtTrigger.value[0:0];
        clearac0ProtTrigger_wr : coverpoint clearac0ProtTrigger.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXRXINTEVENTCLEARREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXRXINTUNMASKREG
//--------------------------------------------------------------------
class TXRXINTUNMASKREG extends uvm_reg;
    `uvm_object_utils(TXRXINTUNMASKREG)
    rand uvm_reg_field masterTxRxIntEn;
    rand uvm_reg_field masktbTxBufTrigger;
    rand uvm_reg_field maskbcnTxBufTrigger;
    rand uvm_reg_field maskac3TxBufTrigger;
    rand uvm_reg_field maskac2TxBufTrigger;
    rand uvm_reg_field maskac1TxBufTrigger;
    rand uvm_reg_field maskac0TxBufTrigger;
    rand uvm_reg_field maskac3BWDropTrigger;
    rand uvm_reg_field maskac2BWDropTrigger;
    rand uvm_reg_field maskac1BWDropTrigger;
    rand uvm_reg_field maskac0BWDropTrigger;
    rand uvm_reg_field maskrxBuffer2Trigger;
    rand uvm_reg_field masktimerRxTrigger;
    rand uvm_reg_field maskrxBuffer1Trigger;
    rand uvm_reg_field masksecUserTxTrigger;
    rand uvm_reg_field masktimerTxTrigger;
    rand uvm_reg_field masktxopComplete;
    rand uvm_reg_field masktbTxCancelled;
    rand uvm_reg_field masktbTxTrigger;
    rand uvm_reg_field maskbcnTxTrigger;
    rand uvm_reg_field maskac3TxTrigger;
    rand uvm_reg_field maskac2TxTrigger;
    rand uvm_reg_field maskac1TxTrigger;
    rand uvm_reg_field maskac0TxTrigger;
    rand uvm_reg_field masktbProtTrigger;
    rand uvm_reg_field maskac3ProtTrigger;
    rand uvm_reg_field maskac2ProtTrigger;
    rand uvm_reg_field maskac1ProtTrigger;
    rand uvm_reg_field maskac0ProtTrigger;

    //---build------------------------------------------------------------
    virtual function void build();
        masterTxRxIntEn = uvm_reg_field::type_id::create("masterTxRxIntEn");
        masktbTxBufTrigger = uvm_reg_field::type_id::create("masktbTxBufTrigger");
        maskbcnTxBufTrigger = uvm_reg_field::type_id::create("maskbcnTxBufTrigger");
        maskac3TxBufTrigger = uvm_reg_field::type_id::create("maskac3TxBufTrigger");
        maskac2TxBufTrigger = uvm_reg_field::type_id::create("maskac2TxBufTrigger");
        maskac1TxBufTrigger = uvm_reg_field::type_id::create("maskac1TxBufTrigger");
        maskac0TxBufTrigger = uvm_reg_field::type_id::create("maskac0TxBufTrigger");
        maskac3BWDropTrigger = uvm_reg_field::type_id::create("maskac3BWDropTrigger");
        maskac2BWDropTrigger = uvm_reg_field::type_id::create("maskac2BWDropTrigger");
        maskac1BWDropTrigger = uvm_reg_field::type_id::create("maskac1BWDropTrigger");
        maskac0BWDropTrigger = uvm_reg_field::type_id::create("maskac0BWDropTrigger");
        maskrxBuffer2Trigger = uvm_reg_field::type_id::create("maskrxBuffer2Trigger");
        masktimerRxTrigger = uvm_reg_field::type_id::create("masktimerRxTrigger");
        maskrxBuffer1Trigger = uvm_reg_field::type_id::create("maskrxBuffer1Trigger");
        masksecUserTxTrigger = uvm_reg_field::type_id::create("masksecUserTxTrigger");
        masktimerTxTrigger = uvm_reg_field::type_id::create("masktimerTxTrigger");
        masktxopComplete = uvm_reg_field::type_id::create("masktxopComplete");
        masktbTxCancelled = uvm_reg_field::type_id::create("masktbTxCancelled");
        masktbTxTrigger = uvm_reg_field::type_id::create("masktbTxTrigger");
        maskbcnTxTrigger = uvm_reg_field::type_id::create("maskbcnTxTrigger");
        maskac3TxTrigger = uvm_reg_field::type_id::create("maskac3TxTrigger");
        maskac2TxTrigger = uvm_reg_field::type_id::create("maskac2TxTrigger");
        maskac1TxTrigger = uvm_reg_field::type_id::create("maskac1TxTrigger");
        maskac0TxTrigger = uvm_reg_field::type_id::create("maskac0TxTrigger");
        masktbProtTrigger = uvm_reg_field::type_id::create("masktbProtTrigger");
        maskac3ProtTrigger = uvm_reg_field::type_id::create("maskac3ProtTrigger");
        maskac2ProtTrigger = uvm_reg_field::type_id::create("maskac2ProtTrigger");
        maskac1ProtTrigger = uvm_reg_field::type_id::create("maskac1ProtTrigger");
        maskac0ProtTrigger = uvm_reg_field::type_id::create("maskac0ProtTrigger");

        masterTxRxIntEn.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        masktbTxBufTrigger.configure(this, 1, 29, "RW", 1, 'b0, 1, 1, 1);
        maskbcnTxBufTrigger.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        maskac3TxBufTrigger.configure(this, 1, 27, "RW", 1, 'b0, 1, 1, 1);
        maskac2TxBufTrigger.configure(this, 1, 26, "RW", 1, 'b0, 1, 1, 1);
        maskac1TxBufTrigger.configure(this, 1, 25, "RW", 1, 'b0, 1, 1, 1);
        maskac0TxBufTrigger.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        maskac3BWDropTrigger.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        maskac2BWDropTrigger.configure(this, 1, 22, "RW", 1, 'b0, 1, 1, 1);
        maskac1BWDropTrigger.configure(this, 1, 21, "RW", 1, 'b0, 1, 1, 1);
        maskac0BWDropTrigger.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        maskrxBuffer2Trigger.configure(this, 1, 18, "RW", 1, 'b0, 1, 1, 1);
        masktimerRxTrigger.configure(this, 1, 17, "RW", 1, 'b0, 1, 1, 1);
        maskrxBuffer1Trigger.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        masksecUserTxTrigger.configure(this, 1, 15, "RW", 1, 'b0, 1, 1, 1);
        masktimerTxTrigger.configure(this, 1, 14, "RW", 1, 'b0, 1, 1, 1);
        masktxopComplete.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        masktbTxCancelled.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        masktbTxTrigger.configure(this, 1, 11, "RW", 1, 'b0, 1, 1, 1);
        maskbcnTxTrigger.configure(this, 1, 10, "RW", 1, 'b0, 1, 1, 1);
        maskac3TxTrigger.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        maskac2TxTrigger.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        maskac1TxTrigger.configure(this, 1, 7, "RW", 1, 'b0, 1, 1, 1);
        maskac0TxTrigger.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        masktbProtTrigger.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        maskac3ProtTrigger.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        maskac2ProtTrigger.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        maskac1ProtTrigger.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        maskac0ProtTrigger.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TXRXINTUNMASKREG_wr_cg";
        masterTxRxIntEn_wr : coverpoint masterTxRxIntEn.value[0:0];
        masktbTxBufTrigger_wr : coverpoint masktbTxBufTrigger.value[0:0];
        maskbcnTxBufTrigger_wr : coverpoint maskbcnTxBufTrigger.value[0:0];
        maskac3TxBufTrigger_wr : coverpoint maskac3TxBufTrigger.value[0:0];
        maskac2TxBufTrigger_wr : coverpoint maskac2TxBufTrigger.value[0:0];
        maskac1TxBufTrigger_wr : coverpoint maskac1TxBufTrigger.value[0:0];
        maskac0TxBufTrigger_wr : coverpoint maskac0TxBufTrigger.value[0:0];
        maskac3BWDropTrigger_wr : coverpoint maskac3BWDropTrigger.value[0:0];
        maskac2BWDropTrigger_wr : coverpoint maskac2BWDropTrigger.value[0:0];
        maskac1BWDropTrigger_wr : coverpoint maskac1BWDropTrigger.value[0:0];
        maskac0BWDropTrigger_wr : coverpoint maskac0BWDropTrigger.value[0:0];
        maskrxBuffer2Trigger_wr : coverpoint maskrxBuffer2Trigger.value[0:0];
        masktimerRxTrigger_wr : coverpoint masktimerRxTrigger.value[0:0];
        maskrxBuffer1Trigger_wr : coverpoint maskrxBuffer1Trigger.value[0:0];
        masksecUserTxTrigger_wr : coverpoint masksecUserTxTrigger.value[0:0];
        masktimerTxTrigger_wr : coverpoint masktimerTxTrigger.value[0:0];
        masktxopComplete_wr : coverpoint masktxopComplete.value[0:0];
        masktbTxCancelled_wr : coverpoint masktbTxCancelled.value[0:0];
        masktbTxTrigger_wr : coverpoint masktbTxTrigger.value[0:0];
        maskbcnTxTrigger_wr : coverpoint maskbcnTxTrigger.value[0:0];
        maskac3TxTrigger_wr : coverpoint maskac3TxTrigger.value[0:0];
        maskac2TxTrigger_wr : coverpoint maskac2TxTrigger.value[0:0];
        maskac1TxTrigger_wr : coverpoint maskac1TxTrigger.value[0:0];
        maskac0TxTrigger_wr : coverpoint maskac0TxTrigger.value[0:0];
        masktbProtTrigger_wr : coverpoint masktbProtTrigger.value[0:0];
        maskac3ProtTrigger_wr : coverpoint maskac3ProtTrigger.value[0:0];
        maskac2ProtTrigger_wr : coverpoint maskac2ProtTrigger.value[0:0];
        maskac1ProtTrigger_wr : coverpoint maskac1ProtTrigger.value[0:0];
        maskac0ProtTrigger_wr : coverpoint maskac0ProtTrigger.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXRXINTUNMASKREG_rd_cg";
        masterTxRxIntEn_rd : coverpoint masterTxRxIntEn.value[0:0];
        masktbTxBufTrigger_rd : coverpoint masktbTxBufTrigger.value[0:0];
        maskbcnTxBufTrigger_rd : coverpoint maskbcnTxBufTrigger.value[0:0];
        maskac3TxBufTrigger_rd : coverpoint maskac3TxBufTrigger.value[0:0];
        maskac2TxBufTrigger_rd : coverpoint maskac2TxBufTrigger.value[0:0];
        maskac1TxBufTrigger_rd : coverpoint maskac1TxBufTrigger.value[0:0];
        maskac0TxBufTrigger_rd : coverpoint maskac0TxBufTrigger.value[0:0];
        maskac3BWDropTrigger_rd : coverpoint maskac3BWDropTrigger.value[0:0];
        maskac2BWDropTrigger_rd : coverpoint maskac2BWDropTrigger.value[0:0];
        maskac1BWDropTrigger_rd : coverpoint maskac1BWDropTrigger.value[0:0];
        maskac0BWDropTrigger_rd : coverpoint maskac0BWDropTrigger.value[0:0];
        maskrxBuffer2Trigger_rd : coverpoint maskrxBuffer2Trigger.value[0:0];
        masktimerRxTrigger_rd : coverpoint masktimerRxTrigger.value[0:0];
        maskrxBuffer1Trigger_rd : coverpoint maskrxBuffer1Trigger.value[0:0];
        masksecUserTxTrigger_rd : coverpoint masksecUserTxTrigger.value[0:0];
        masktimerTxTrigger_rd : coverpoint masktimerTxTrigger.value[0:0];
        masktxopComplete_rd : coverpoint masktxopComplete.value[0:0];
        masktbTxCancelled_rd : coverpoint masktbTxCancelled.value[0:0];
        masktbTxTrigger_rd : coverpoint masktbTxTrigger.value[0:0];
        maskbcnTxTrigger_rd : coverpoint maskbcnTxTrigger.value[0:0];
        maskac3TxTrigger_rd : coverpoint maskac3TxTrigger.value[0:0];
        maskac2TxTrigger_rd : coverpoint maskac2TxTrigger.value[0:0];
        maskac1TxTrigger_rd : coverpoint maskac1TxTrigger.value[0:0];
        maskac0TxTrigger_rd : coverpoint maskac0TxTrigger.value[0:0];
        masktbProtTrigger_rd : coverpoint masktbProtTrigger.value[0:0];
        maskac3ProtTrigger_rd : coverpoint maskac3ProtTrigger.value[0:0];
        maskac2ProtTrigger_rd : coverpoint maskac2ProtTrigger.value[0:0];
        maskac1ProtTrigger_rd : coverpoint maskac1ProtTrigger.value[0:0];
        maskac0ProtTrigger_rd : coverpoint maskac0ProtTrigger.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXRXINTUNMASKREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMERSINTEVENTSETREG
//--------------------------------------------------------------------
class TIMERSINTEVENTSETREG extends uvm_reg;
    `uvm_object_utils(TIMERSINTEVENTSETREG)
    rand uvm_reg_field setabsTimers9;
    rand uvm_reg_field setabsTimers8;
    rand uvm_reg_field setabsTimers7;
    rand uvm_reg_field setabsTimers6;
    rand uvm_reg_field setabsTimers5;
    rand uvm_reg_field setabsTimers4;
    rand uvm_reg_field setabsTimers3;
    rand uvm_reg_field setabsTimers2;
    rand uvm_reg_field setabsTimers1;
    rand uvm_reg_field setabsTimers0;

    //---build------------------------------------------------------------
    virtual function void build();
        setabsTimers9 = uvm_reg_field::type_id::create("setabsTimers9");
        setabsTimers8 = uvm_reg_field::type_id::create("setabsTimers8");
        setabsTimers7 = uvm_reg_field::type_id::create("setabsTimers7");
        setabsTimers6 = uvm_reg_field::type_id::create("setabsTimers6");
        setabsTimers5 = uvm_reg_field::type_id::create("setabsTimers5");
        setabsTimers4 = uvm_reg_field::type_id::create("setabsTimers4");
        setabsTimers3 = uvm_reg_field::type_id::create("setabsTimers3");
        setabsTimers2 = uvm_reg_field::type_id::create("setabsTimers2");
        setabsTimers1 = uvm_reg_field::type_id::create("setabsTimers1");
        setabsTimers0 = uvm_reg_field::type_id::create("setabsTimers0");

        setabsTimers9.configure(this, 1, 9, "W1S", 1, 'b0, 1, 1, 1);
        setabsTimers8.configure(this, 1, 8, "W1S", 1, 'b0, 1, 1, 1);
        setabsTimers7.configure(this, 1, 7, "W1S", 1, 'b0, 1, 1, 1);
        setabsTimers6.configure(this, 1, 6, "W1S", 1, 'b0, 1, 1, 1);
        setabsTimers5.configure(this, 1, 5, "W1S", 1, 'b0, 1, 1, 1);
        setabsTimers4.configure(this, 1, 4, "W1S", 1, 'b0, 1, 1, 1);
        setabsTimers3.configure(this, 1, 3, "W1S", 1, 'b0, 1, 1, 1);
        setabsTimers2.configure(this, 1, 2, "W1S", 1, 'b0, 1, 1, 1);
        setabsTimers1.configure(this, 1, 1, "W1S", 1, 'b0, 1, 1, 1);
        setabsTimers0.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TIMERSINTEVENTSETREG_wr_cg";
        setabsTimers9_wr : coverpoint setabsTimers9.value[0:0];
        setabsTimers8_wr : coverpoint setabsTimers8.value[0:0];
        setabsTimers7_wr : coverpoint setabsTimers7.value[0:0];
        setabsTimers6_wr : coverpoint setabsTimers6.value[0:0];
        setabsTimers5_wr : coverpoint setabsTimers5.value[0:0];
        setabsTimers4_wr : coverpoint setabsTimers4.value[0:0];
        setabsTimers3_wr : coverpoint setabsTimers3.value[0:0];
        setabsTimers2_wr : coverpoint setabsTimers2.value[0:0];
        setabsTimers1_wr : coverpoint setabsTimers1.value[0:0];
        setabsTimers0_wr : coverpoint setabsTimers0.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMERSINTEVENTSETREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMERSINTEVENTCLEARREG
//--------------------------------------------------------------------
class TIMERSINTEVENTCLEARREG extends uvm_reg;
    `uvm_object_utils(TIMERSINTEVENTCLEARREG)
    rand uvm_reg_field clearabsTimers9;
    rand uvm_reg_field clearabsTimers8;
    rand uvm_reg_field clearabsTimers7;
    rand uvm_reg_field clearabsTimers6;
    rand uvm_reg_field clearabsTimers5;
    rand uvm_reg_field clearabsTimers4;
    rand uvm_reg_field clearabsTimers3;
    rand uvm_reg_field clearabsTimers2;
    rand uvm_reg_field clearabsTimers1;
    rand uvm_reg_field clearabsTimers0;

    //---build------------------------------------------------------------
    virtual function void build();
        clearabsTimers9 = uvm_reg_field::type_id::create("clearabsTimers9");
        clearabsTimers8 = uvm_reg_field::type_id::create("clearabsTimers8");
        clearabsTimers7 = uvm_reg_field::type_id::create("clearabsTimers7");
        clearabsTimers6 = uvm_reg_field::type_id::create("clearabsTimers6");
        clearabsTimers5 = uvm_reg_field::type_id::create("clearabsTimers5");
        clearabsTimers4 = uvm_reg_field::type_id::create("clearabsTimers4");
        clearabsTimers3 = uvm_reg_field::type_id::create("clearabsTimers3");
        clearabsTimers2 = uvm_reg_field::type_id::create("clearabsTimers2");
        clearabsTimers1 = uvm_reg_field::type_id::create("clearabsTimers1");
        clearabsTimers0 = uvm_reg_field::type_id::create("clearabsTimers0");

        clearabsTimers9.configure(this, 1, 9, "W1C", 1, 'b0, 1, 1, 1);
        clearabsTimers8.configure(this, 1, 8, "W1C", 1, 'b0, 1, 1, 1);
        clearabsTimers7.configure(this, 1, 7, "W1C", 1, 'b0, 1, 1, 1);
        clearabsTimers6.configure(this, 1, 6, "W1C", 1, 'b0, 1, 1, 1);
        clearabsTimers5.configure(this, 1, 5, "W1C", 1, 'b0, 1, 1, 1);
        clearabsTimers4.configure(this, 1, 4, "W1C", 1, 'b0, 1, 1, 1);
        clearabsTimers3.configure(this, 1, 3, "W1C", 1, 'b0, 1, 1, 1);
        clearabsTimers2.configure(this, 1, 2, "W1C", 1, 'b0, 1, 1, 1);
        clearabsTimers1.configure(this, 1, 1, "W1C", 1, 'b0, 1, 1, 1);
        clearabsTimers0.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TIMERSINTEVENTCLEARREG_wr_cg";
        clearabsTimers9_wr : coverpoint clearabsTimers9.value[0:0];
        clearabsTimers8_wr : coverpoint clearabsTimers8.value[0:0];
        clearabsTimers7_wr : coverpoint clearabsTimers7.value[0:0];
        clearabsTimers6_wr : coverpoint clearabsTimers6.value[0:0];
        clearabsTimers5_wr : coverpoint clearabsTimers5.value[0:0];
        clearabsTimers4_wr : coverpoint clearabsTimers4.value[0:0];
        clearabsTimers3_wr : coverpoint clearabsTimers3.value[0:0];
        clearabsTimers2_wr : coverpoint clearabsTimers2.value[0:0];
        clearabsTimers1_wr : coverpoint clearabsTimers1.value[0:0];
        clearabsTimers0_wr : coverpoint clearabsTimers0.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMERSINTEVENTCLEARREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMERSINTUNMASKREG
//--------------------------------------------------------------------
class TIMERSINTUNMASKREG extends uvm_reg;
    `uvm_object_utils(TIMERSINTUNMASKREG)
    rand uvm_reg_field maskabsTimers9;
    rand uvm_reg_field maskabsTimers8;
    rand uvm_reg_field maskabsTimers7;
    rand uvm_reg_field maskabsTimers6;
    rand uvm_reg_field maskabsTimers5;
    rand uvm_reg_field maskabsTimers4;
    rand uvm_reg_field maskabsTimers3;
    rand uvm_reg_field maskabsTimers2;
    rand uvm_reg_field maskabsTimers1;
    rand uvm_reg_field maskabsTimers0;

    //---build------------------------------------------------------------
    virtual function void build();
        maskabsTimers9 = uvm_reg_field::type_id::create("maskabsTimers9");
        maskabsTimers8 = uvm_reg_field::type_id::create("maskabsTimers8");
        maskabsTimers7 = uvm_reg_field::type_id::create("maskabsTimers7");
        maskabsTimers6 = uvm_reg_field::type_id::create("maskabsTimers6");
        maskabsTimers5 = uvm_reg_field::type_id::create("maskabsTimers5");
        maskabsTimers4 = uvm_reg_field::type_id::create("maskabsTimers4");
        maskabsTimers3 = uvm_reg_field::type_id::create("maskabsTimers3");
        maskabsTimers2 = uvm_reg_field::type_id::create("maskabsTimers2");
        maskabsTimers1 = uvm_reg_field::type_id::create("maskabsTimers1");
        maskabsTimers0 = uvm_reg_field::type_id::create("maskabsTimers0");

        maskabsTimers9.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        maskabsTimers8.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        maskabsTimers7.configure(this, 1, 7, "RW", 1, 'b0, 1, 1, 1);
        maskabsTimers6.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        maskabsTimers5.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        maskabsTimers4.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        maskabsTimers3.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        maskabsTimers2.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        maskabsTimers1.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        maskabsTimers0.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TIMERSINTUNMASKREG_wr_cg";
        maskabsTimers9_wr : coverpoint maskabsTimers9.value[0:0];
        maskabsTimers8_wr : coverpoint maskabsTimers8.value[0:0];
        maskabsTimers7_wr : coverpoint maskabsTimers7.value[0:0];
        maskabsTimers6_wr : coverpoint maskabsTimers6.value[0:0];
        maskabsTimers5_wr : coverpoint maskabsTimers5.value[0:0];
        maskabsTimers4_wr : coverpoint maskabsTimers4.value[0:0];
        maskabsTimers3_wr : coverpoint maskabsTimers3.value[0:0];
        maskabsTimers2_wr : coverpoint maskabsTimers2.value[0:0];
        maskabsTimers1_wr : coverpoint maskabsTimers1.value[0:0];
        maskabsTimers0_wr : coverpoint maskabsTimers0.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TIMERSINTUNMASKREG_rd_cg";
        maskabsTimers9_rd : coverpoint maskabsTimers9.value[0:0];
        maskabsTimers8_rd : coverpoint maskabsTimers8.value[0:0];
        maskabsTimers7_rd : coverpoint maskabsTimers7.value[0:0];
        maskabsTimers6_rd : coverpoint maskabsTimers6.value[0:0];
        maskabsTimers5_rd : coverpoint maskabsTimers5.value[0:0];
        maskabsTimers4_rd : coverpoint maskabsTimers4.value[0:0];
        maskabsTimers3_rd : coverpoint maskabsTimers3.value[0:0];
        maskabsTimers2_rd : coverpoint maskabsTimers2.value[0:0];
        maskabsTimers1_rd : coverpoint maskabsTimers1.value[0:0];
        maskabsTimers0_rd : coverpoint maskabsTimers0.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMERSINTUNMASKREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TSFLOREG
//--------------------------------------------------------------------
class TSFLOREG extends uvm_reg;
    `uvm_object_utils(TSFLOREG)
    rand uvm_reg_field tsfTimerLow;

    //---build------------------------------------------------------------
    virtual function void build();
        tsfTimerLow = uvm_reg_field::type_id::create("tsfTimerLow");

        tsfTimerLow.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TSFLOREG_wr_cg";
        tsfTimerLow_wr : coverpoint tsfTimerLow.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TSFLOREG_rd_cg";
        tsfTimerLow_rd : coverpoint tsfTimerLow.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TSFLOREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TSFHIREG
//--------------------------------------------------------------------
class TSFHIREG extends uvm_reg;
    `uvm_object_utils(TSFHIREG)
    rand uvm_reg_field tsfTimerHigh;

    //---build------------------------------------------------------------
    virtual function void build();
        tsfTimerHigh = uvm_reg_field::type_id::create("tsfTimerHigh");

        tsfTimerHigh.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TSFHIREG_wr_cg";
        tsfTimerHigh_wr : coverpoint tsfTimerHigh.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TSFHIREG_rd_cg";
        tsfTimerHigh_rd : coverpoint tsfTimerHigh.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TSFHIREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMEONAIRPARAM1REG
//--------------------------------------------------------------------
class TIMEONAIRPARAM1REG extends uvm_reg;
    `uvm_object_utils(TIMEONAIRPARAM1REG)
    rand uvm_reg_field ppduSTBC;
    rand uvm_reg_field ppduNumExtnSS;
    rand uvm_reg_field ppduBW;
    rand uvm_reg_field ppduGI;
    rand uvm_reg_field ppduPreType;
    rand uvm_reg_field ppduLength;

    //---build------------------------------------------------------------
    virtual function void build();
        ppduSTBC = uvm_reg_field::type_id::create("ppduSTBC");
        ppduNumExtnSS = uvm_reg_field::type_id::create("ppduNumExtnSS");
        ppduBW = uvm_reg_field::type_id::create("ppduBW");
        ppduGI = uvm_reg_field::type_id::create("ppduGI");
        ppduPreType = uvm_reg_field::type_id::create("ppduPreType");
        ppduLength = uvm_reg_field::type_id::create("ppduLength");

        ppduSTBC.configure(this, 2, 30, "RW", 1, 'b0, 1, 1, 1);
        ppduNumExtnSS.configure(this, 2, 28, "RW", 1, 'b0, 1, 1, 1);
        ppduBW.configure(this, 2, 26, "RW", 1, 'b0, 1, 1, 1);
        ppduGI.configure(this, 2, 24, "RW", 1, 'b0, 1, 1, 1);
        ppduPreType.configure(this, 4, 20, "RW", 1, 'b000, 1, 1, 1);
        ppduLength.configure(this, 20, 0, "RW", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TIMEONAIRPARAM1REG_wr_cg";
        ppduSTBC_wr : coverpoint ppduSTBC.value[1:0];
        ppduNumExtnSS_wr : coverpoint ppduNumExtnSS.value[1:0];
        ppduBW_wr : coverpoint ppduBW.value[1:0];
        ppduGI_wr : coverpoint ppduGI.value[1:0];
        ppduPreType_wr : coverpoint ppduPreType.value[3:0];
        ppduLength_wr : coverpoint ppduLength.value[19:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TIMEONAIRPARAM1REG_rd_cg";
        ppduSTBC_rd : coverpoint ppduSTBC.value[1:0];
        ppduNumExtnSS_rd : coverpoint ppduNumExtnSS.value[1:0];
        ppduBW_rd : coverpoint ppduBW.value[1:0];
        ppduGI_rd : coverpoint ppduGI.value[1:0];
        ppduPreType_rd : coverpoint ppduPreType.value[3:0];
        ppduLength_rd : coverpoint ppduLength.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMEONAIRPARAM1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMEONAIRPARAM2REG
//--------------------------------------------------------------------
class TIMEONAIRPARAM2REG extends uvm_reg;
    `uvm_object_utils(TIMEONAIRPARAM2REG)
    rand uvm_reg_field ppduNumHeLtf;
    rand uvm_reg_field ppduNUser;
    rand uvm_reg_field ppduPE;
    rand uvm_reg_field ppduMCSSigB;
    rand uvm_reg_field ppduDCMSigB;
    rand uvm_reg_field ppduSigBCompMode;
    rand uvm_reg_field ppduHELTFType;
    rand uvm_reg_field ppduDCM;
    rand uvm_reg_field ppduMCSIndex;

    //---build------------------------------------------------------------
    virtual function void build();
        ppduNumHeLtf = uvm_reg_field::type_id::create("ppduNumHeLtf");
        ppduNUser = uvm_reg_field::type_id::create("ppduNUser");
        ppduPE = uvm_reg_field::type_id::create("ppduPE");
        ppduMCSSigB = uvm_reg_field::type_id::create("ppduMCSSigB");
        ppduDCMSigB = uvm_reg_field::type_id::create("ppduDCMSigB");
        ppduSigBCompMode = uvm_reg_field::type_id::create("ppduSigBCompMode");
        ppduHELTFType = uvm_reg_field::type_id::create("ppduHELTFType");
        ppduDCM = uvm_reg_field::type_id::create("ppduDCM");
        ppduMCSIndex = uvm_reg_field::type_id::create("ppduMCSIndex");

        ppduNumHeLtf.configure(this, 3, 28, "RW", 1, 'b00, 1, 1, 1);
        ppduNUser.configure(this, 7, 20, "RW", 1, 'b000000, 1, 1, 1);
        ppduPE.configure(this, 3, 16, "RW", 1, 'b00, 1, 1, 1);
        ppduMCSSigB.configure(this, 3, 13, "RW", 1, 'b00, 1, 1, 1);
        ppduDCMSigB.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        ppduSigBCompMode.configure(this, 1, 11, "RW", 1, 'b0, 1, 1, 1);
        ppduHELTFType.configure(this, 2, 9, "RW", 1, 'b0, 1, 1, 1);
        ppduDCM.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        ppduMCSIndex.configure(this, 7, 0, "RW", 1, 'b000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TIMEONAIRPARAM2REG_wr_cg";
        ppduNumHeLtf_wr : coverpoint ppduNumHeLtf.value[2:0];
        ppduNUser_wr : coverpoint ppduNUser.value[6:0];
        ppduPE_wr : coverpoint ppduPE.value[2:0];
        ppduMCSSigB_wr : coverpoint ppduMCSSigB.value[2:0];
        ppduDCMSigB_wr : coverpoint ppduDCMSigB.value[0:0];
        ppduSigBCompMode_wr : coverpoint ppduSigBCompMode.value[0:0];
        ppduHELTFType_wr : coverpoint ppduHELTFType.value[1:0];
        ppduDCM_wr : coverpoint ppduDCM.value[0:0];
        ppduMCSIndex_wr : coverpoint ppduMCSIndex.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TIMEONAIRPARAM2REG_rd_cg";
        ppduNumHeLtf_rd : coverpoint ppduNumHeLtf.value[2:0];
        ppduNUser_rd : coverpoint ppduNUser.value[6:0];
        ppduPE_rd : coverpoint ppduPE.value[2:0];
        ppduMCSSigB_rd : coverpoint ppduMCSSigB.value[2:0];
        ppduDCMSigB_rd : coverpoint ppduDCMSigB.value[0:0];
        ppduSigBCompMode_rd : coverpoint ppduSigBCompMode.value[0:0];
        ppduHELTFType_rd : coverpoint ppduHELTFType.value[1:0];
        ppduDCM_rd : coverpoint ppduDCM.value[0:0];
        ppduMCSIndex_rd : coverpoint ppduMCSIndex.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMEONAIRPARAM2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMEONAIRPARAM3REG
//--------------------------------------------------------------------
class TIMEONAIRPARAM3REG extends uvm_reg;
    `uvm_object_utils(TIMEONAIRPARAM3REG)
    rand uvm_reg_field ppduRuType;
    rand uvm_reg_field ppduMma;
    rand uvm_reg_field ppduDoppler;

    //---build------------------------------------------------------------
    virtual function void build();
        ppduRuType = uvm_reg_field::type_id::create("ppduRuType");
        ppduMma = uvm_reg_field::type_id::create("ppduMma");
        ppduDoppler = uvm_reg_field::type_id::create("ppduDoppler");

        ppduRuType.configure(this, 3, 4, "RW", 1, 'b00, 1, 1, 1);
        ppduMma.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        ppduDoppler.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TIMEONAIRPARAM3REG_wr_cg";
        ppduRuType_wr : coverpoint ppduRuType.value[2:0];
        ppduMma_wr : coverpoint ppduMma.value[0:0];
        ppduDoppler_wr : coverpoint ppduDoppler.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TIMEONAIRPARAM3REG_rd_cg";
        ppduRuType_rd : coverpoint ppduRuType.value[2:0];
        ppduMma_rd : coverpoint ppduMma.value[0:0];
        ppduDoppler_rd : coverpoint ppduDoppler.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMEONAIRPARAM3REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMEONAIRVALUEREG
//--------------------------------------------------------------------
class TIMEONAIRVALUEREG extends uvm_reg;
    `uvm_object_utils(TIMEONAIRVALUEREG)
    rand uvm_reg_field computeDuration;
    rand uvm_reg_field timeOnAirValid;
    rand uvm_reg_field timeOnAir;

    //---build------------------------------------------------------------
    virtual function void build();
        computeDuration = uvm_reg_field::type_id::create("computeDuration");
        timeOnAirValid = uvm_reg_field::type_id::create("timeOnAirValid");
        timeOnAir = uvm_reg_field::type_id::create("timeOnAir");

        computeDuration.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        timeOnAirValid.configure(this, 1, 30, "RO", 1, 'b0, 1, 1, 1);
        timeOnAir.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TIMEONAIRVALUEREG_wr_cg";
        computeDuration_wr : coverpoint computeDuration.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TIMEONAIRVALUEREG_rd_cg";
        computeDuration_rd : coverpoint computeDuration.value[0:0];
        timeOnAirValid_rd : coverpoint timeOnAirValid.value[0:0];
        timeOnAir_rd : coverpoint timeOnAir.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMEONAIRVALUEREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DMACNTRLSETREG
//--------------------------------------------------------------------
class DMACNTRLSETREG extends uvm_reg;
    `uvm_object_utils(DMACNTRLSETREG)
    rand uvm_reg_field sethaltTBAfterTXOP;
    rand uvm_reg_field sethaltAC3AfterTXOP;
    rand uvm_reg_field sethaltAC2AfterTXOP;
    rand uvm_reg_field sethaltAC1AfterTXOP;
    rand uvm_reg_field sethaltAC0AfterTXOP;
    rand uvm_reg_field sethaltBcnAfterTXOP;
    rand uvm_reg_field settxTBNewHead;
    rand uvm_reg_field settxAC3NewHead;
    rand uvm_reg_field settxAC2NewHead;
    rand uvm_reg_field settxAC1NewHead;
    rand uvm_reg_field settxAC0NewHead;
    rand uvm_reg_field settxBcnNewHead;
    rand uvm_reg_field settxAC3NewTail;
    rand uvm_reg_field settxAC2NewTail;
    rand uvm_reg_field settxAC1NewTail;
    rand uvm_reg_field settxAC0NewTail;
    rand uvm_reg_field settxBcnNewTail;

    //---build------------------------------------------------------------
    virtual function void build();
        sethaltTBAfterTXOP = uvm_reg_field::type_id::create("sethaltTBAfterTXOP");
        sethaltAC3AfterTXOP = uvm_reg_field::type_id::create("sethaltAC3AfterTXOP");
        sethaltAC2AfterTXOP = uvm_reg_field::type_id::create("sethaltAC2AfterTXOP");
        sethaltAC1AfterTXOP = uvm_reg_field::type_id::create("sethaltAC1AfterTXOP");
        sethaltAC0AfterTXOP = uvm_reg_field::type_id::create("sethaltAC0AfterTXOP");
        sethaltBcnAfterTXOP = uvm_reg_field::type_id::create("sethaltBcnAfterTXOP");
        settxTBNewHead = uvm_reg_field::type_id::create("settxTBNewHead");
        settxAC3NewHead = uvm_reg_field::type_id::create("settxAC3NewHead");
        settxAC2NewHead = uvm_reg_field::type_id::create("settxAC2NewHead");
        settxAC1NewHead = uvm_reg_field::type_id::create("settxAC1NewHead");
        settxAC0NewHead = uvm_reg_field::type_id::create("settxAC0NewHead");
        settxBcnNewHead = uvm_reg_field::type_id::create("settxBcnNewHead");
        settxAC3NewTail = uvm_reg_field::type_id::create("settxAC3NewTail");
        settxAC2NewTail = uvm_reg_field::type_id::create("settxAC2NewTail");
        settxAC1NewTail = uvm_reg_field::type_id::create("settxAC1NewTail");
        settxAC0NewTail = uvm_reg_field::type_id::create("settxAC0NewTail");
        settxBcnNewTail = uvm_reg_field::type_id::create("settxBcnNewTail");

        sethaltTBAfterTXOP.configure(this, 1, 20, "W1S", 1, 'b0, 1, 1, 1);
        sethaltAC3AfterTXOP.configure(this, 1, 19, "W1S", 1, 'b0, 1, 1, 1);
        sethaltAC2AfterTXOP.configure(this, 1, 18, "W1S", 1, 'b0, 1, 1, 1);
        sethaltAC1AfterTXOP.configure(this, 1, 17, "W1S", 1, 'b0, 1, 1, 1);
        sethaltAC0AfterTXOP.configure(this, 1, 16, "W1S", 1, 'b0, 1, 1, 1);
        sethaltBcnAfterTXOP.configure(this, 1, 15, "W1S", 1, 'b0, 1, 1, 1);
        settxTBNewHead.configure(this, 1, 13, "W1S", 1, 'b0, 1, 1, 1);
        settxAC3NewHead.configure(this, 1, 12, "W1S", 1, 'b0, 1, 1, 1);
        settxAC2NewHead.configure(this, 1, 11, "W1S", 1, 'b0, 1, 1, 1);
        settxAC1NewHead.configure(this, 1, 10, "W1S", 1, 'b0, 1, 1, 1);
        settxAC0NewHead.configure(this, 1, 9, "W1S", 1, 'b0, 1, 1, 1);
        settxBcnNewHead.configure(this, 1, 8, "W1S", 1, 'b0, 1, 1, 1);
        settxAC3NewTail.configure(this, 1, 4, "W1S", 1, 'b0, 1, 1, 1);
        settxAC2NewTail.configure(this, 1, 3, "W1S", 1, 'b0, 1, 1, 1);
        settxAC1NewTail.configure(this, 1, 2, "W1S", 1, 'b0, 1, 1, 1);
        settxAC0NewTail.configure(this, 1, 1, "W1S", 1, 'b0, 1, 1, 1);
        settxBcnNewTail.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_DMACNTRLSETREG_wr_cg";
        sethaltTBAfterTXOP_wr : coverpoint sethaltTBAfterTXOP.value[0:0];
        sethaltAC3AfterTXOP_wr : coverpoint sethaltAC3AfterTXOP.value[0:0];
        sethaltAC2AfterTXOP_wr : coverpoint sethaltAC2AfterTXOP.value[0:0];
        sethaltAC1AfterTXOP_wr : coverpoint sethaltAC1AfterTXOP.value[0:0];
        sethaltAC0AfterTXOP_wr : coverpoint sethaltAC0AfterTXOP.value[0:0];
        sethaltBcnAfterTXOP_wr : coverpoint sethaltBcnAfterTXOP.value[0:0];
        settxTBNewHead_wr : coverpoint settxTBNewHead.value[0:0];
        settxAC3NewHead_wr : coverpoint settxAC3NewHead.value[0:0];
        settxAC2NewHead_wr : coverpoint settxAC2NewHead.value[0:0];
        settxAC1NewHead_wr : coverpoint settxAC1NewHead.value[0:0];
        settxAC0NewHead_wr : coverpoint settxAC0NewHead.value[0:0];
        settxBcnNewHead_wr : coverpoint settxBcnNewHead.value[0:0];
        settxAC3NewTail_wr : coverpoint settxAC3NewTail.value[0:0];
        settxAC2NewTail_wr : coverpoint settxAC2NewTail.value[0:0];
        settxAC1NewTail_wr : coverpoint settxAC1NewTail.value[0:0];
        settxAC0NewTail_wr : coverpoint settxAC0NewTail.value[0:0];
        settxBcnNewTail_wr : coverpoint settxBcnNewTail.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DMACNTRLSETREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DMACNTRLCLEARREG
//--------------------------------------------------------------------
class DMACNTRLCLEARREG extends uvm_reg;
    `uvm_object_utils(DMACNTRLCLEARREG)
    rand uvm_reg_field clearhaltTBAfterTXOP;
    rand uvm_reg_field clearhaltAC3AfterTXOP;
    rand uvm_reg_field clearhaltAC2AfterTXOP;
    rand uvm_reg_field clearhaltAC1AfterTXOP;
    rand uvm_reg_field clearhaltAC0AfterTXOP;
    rand uvm_reg_field clearhaltBcnAfterTXOP;
    rand uvm_reg_field cleartxTBNewHead;
    rand uvm_reg_field cleartxAC3NewHead;
    rand uvm_reg_field cleartxAC2NewHead;
    rand uvm_reg_field cleartxAC1NewHead;
    rand uvm_reg_field cleartxAC0NewHead;
    rand uvm_reg_field cleartxBcnNewHead;
    rand uvm_reg_field cleartxAC3NewTail;
    rand uvm_reg_field cleartxAC2NewTail;
    rand uvm_reg_field cleartxAC1NewTail;
    rand uvm_reg_field cleartxAC0NewTail;
    rand uvm_reg_field cleartxBcnNewTail;

    //---build------------------------------------------------------------
    virtual function void build();
        clearhaltTBAfterTXOP = uvm_reg_field::type_id::create("clearhaltTBAfterTXOP");
        clearhaltAC3AfterTXOP = uvm_reg_field::type_id::create("clearhaltAC3AfterTXOP");
        clearhaltAC2AfterTXOP = uvm_reg_field::type_id::create("clearhaltAC2AfterTXOP");
        clearhaltAC1AfterTXOP = uvm_reg_field::type_id::create("clearhaltAC1AfterTXOP");
        clearhaltAC0AfterTXOP = uvm_reg_field::type_id::create("clearhaltAC0AfterTXOP");
        clearhaltBcnAfterTXOP = uvm_reg_field::type_id::create("clearhaltBcnAfterTXOP");
        cleartxTBNewHead = uvm_reg_field::type_id::create("cleartxTBNewHead");
        cleartxAC3NewHead = uvm_reg_field::type_id::create("cleartxAC3NewHead");
        cleartxAC2NewHead = uvm_reg_field::type_id::create("cleartxAC2NewHead");
        cleartxAC1NewHead = uvm_reg_field::type_id::create("cleartxAC1NewHead");
        cleartxAC0NewHead = uvm_reg_field::type_id::create("cleartxAC0NewHead");
        cleartxBcnNewHead = uvm_reg_field::type_id::create("cleartxBcnNewHead");
        cleartxAC3NewTail = uvm_reg_field::type_id::create("cleartxAC3NewTail");
        cleartxAC2NewTail = uvm_reg_field::type_id::create("cleartxAC2NewTail");
        cleartxAC1NewTail = uvm_reg_field::type_id::create("cleartxAC1NewTail");
        cleartxAC0NewTail = uvm_reg_field::type_id::create("cleartxAC0NewTail");
        cleartxBcnNewTail = uvm_reg_field::type_id::create("cleartxBcnNewTail");

        clearhaltTBAfterTXOP.configure(this, 1, 20, "W1C", 1, 'b0, 1, 1, 1);
        clearhaltAC3AfterTXOP.configure(this, 1, 19, "W1C", 1, 'b0, 1, 1, 1);
        clearhaltAC2AfterTXOP.configure(this, 1, 18, "W1C", 1, 'b0, 1, 1, 1);
        clearhaltAC1AfterTXOP.configure(this, 1, 17, "W1C", 1, 'b0, 1, 1, 1);
        clearhaltAC0AfterTXOP.configure(this, 1, 16, "W1C", 1, 'b0, 1, 1, 1);
        clearhaltBcnAfterTXOP.configure(this, 1, 15, "W1C", 1, 'b0, 1, 1, 1);
        cleartxTBNewHead.configure(this, 1, 13, "W1C", 1, 'b0, 1, 1, 1);
        cleartxAC3NewHead.configure(this, 1, 12, "W1C", 1, 'b0, 1, 1, 1);
        cleartxAC2NewHead.configure(this, 1, 11, "W1C", 1, 'b0, 1, 1, 1);
        cleartxAC1NewHead.configure(this, 1, 10, "W1C", 1, 'b0, 1, 1, 1);
        cleartxAC0NewHead.configure(this, 1, 9, "W1C", 1, 'b0, 1, 1, 1);
        cleartxBcnNewHead.configure(this, 1, 8, "W1C", 1, 'b0, 1, 1, 1);
        cleartxAC3NewTail.configure(this, 1, 4, "W1C", 1, 'b0, 1, 1, 1);
        cleartxAC2NewTail.configure(this, 1, 3, "W1C", 1, 'b0, 1, 1, 1);
        cleartxAC1NewTail.configure(this, 1, 2, "W1C", 1, 'b0, 1, 1, 1);
        cleartxAC0NewTail.configure(this, 1, 1, "W1C", 1, 'b0, 1, 1, 1);
        cleartxBcnNewTail.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_DMACNTRLCLEARREG_wr_cg";
        clearhaltTBAfterTXOP_wr : coverpoint clearhaltTBAfterTXOP.value[0:0];
        clearhaltAC3AfterTXOP_wr : coverpoint clearhaltAC3AfterTXOP.value[0:0];
        clearhaltAC2AfterTXOP_wr : coverpoint clearhaltAC2AfterTXOP.value[0:0];
        clearhaltAC1AfterTXOP_wr : coverpoint clearhaltAC1AfterTXOP.value[0:0];
        clearhaltAC0AfterTXOP_wr : coverpoint clearhaltAC0AfterTXOP.value[0:0];
        clearhaltBcnAfterTXOP_wr : coverpoint clearhaltBcnAfterTXOP.value[0:0];
        cleartxTBNewHead_wr : coverpoint cleartxTBNewHead.value[0:0];
        cleartxAC3NewHead_wr : coverpoint cleartxAC3NewHead.value[0:0];
        cleartxAC2NewHead_wr : coverpoint cleartxAC2NewHead.value[0:0];
        cleartxAC1NewHead_wr : coverpoint cleartxAC1NewHead.value[0:0];
        cleartxAC0NewHead_wr : coverpoint cleartxAC0NewHead.value[0:0];
        cleartxBcnNewHead_wr : coverpoint cleartxBcnNewHead.value[0:0];
        cleartxAC3NewTail_wr : coverpoint cleartxAC3NewTail.value[0:0];
        cleartxAC2NewTail_wr : coverpoint cleartxAC2NewTail.value[0:0];
        cleartxAC1NewTail_wr : coverpoint cleartxAC1NewTail.value[0:0];
        cleartxAC0NewTail_wr : coverpoint cleartxAC0NewTail.value[0:0];
        cleartxBcnNewTail_wr : coverpoint cleartxBcnNewTail.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DMACNTRLCLEARREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DMASTATUS1REG
//--------------------------------------------------------------------
class DMASTATUS1REG extends uvm_reg;
    `uvm_object_utils(DMASTATUS1REG)
    rand uvm_reg_field txTBState;
    rand uvm_reg_field txAC3State;
    rand uvm_reg_field txAC2State;
    rand uvm_reg_field txAC1State;
    rand uvm_reg_field txAC0State;
    rand uvm_reg_field txBcnState;

    //---build------------------------------------------------------------
    virtual function void build();
        txTBState = uvm_reg_field::type_id::create("txTBState");
        txAC3State = uvm_reg_field::type_id::create("txAC3State");
        txAC2State = uvm_reg_field::type_id::create("txAC2State");
        txAC1State = uvm_reg_field::type_id::create("txAC1State");
        txAC0State = uvm_reg_field::type_id::create("txAC0State");
        txBcnState = uvm_reg_field::type_id::create("txBcnState");

        txTBState.configure(this, 2, 20, "RO", 1, 'b0, 1, 1, 1);
        txAC3State.configure(this, 2, 16, "RO", 1, 'b0, 1, 1, 1);
        txAC2State.configure(this, 2, 12, "RO", 1, 'b0, 1, 1, 1);
        txAC1State.configure(this, 2, 8, "RO", 1, 'b0, 1, 1, 1);
        txAC0State.configure(this, 2, 4, "RO", 1, 'b0, 1, 1, 1);
        txBcnState.configure(this, 2, 0, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DMASTATUS1REG_rd_cg";
        txTBState_rd : coverpoint txTBState.value[1:0];
        txAC3State_rd : coverpoint txAC3State.value[1:0];
        txAC2State_rd : coverpoint txAC2State.value[1:0];
        txAC1State_rd : coverpoint txAC1State.value[1:0];
        txAC0State_rd : coverpoint txAC0State.value[1:0];
        txBcnState_rd : coverpoint txBcnState.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DMASTATUS1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DMASTATUS2REG
//--------------------------------------------------------------------
class DMASTATUS2REG extends uvm_reg;
    `uvm_object_utils(DMASTATUS2REG)
    rand uvm_reg_field txNewHeadErr;
    rand uvm_reg_field txBusErr;
    rand uvm_reg_field txPTAddressErr;
    rand uvm_reg_field txNextPointerErr;
    rand uvm_reg_field txUPatternErr;
    rand uvm_reg_field txLenMismatch;

    //---build------------------------------------------------------------
    virtual function void build();
        txNewHeadErr = uvm_reg_field::type_id::create("txNewHeadErr");
        txBusErr = uvm_reg_field::type_id::create("txBusErr");
        txPTAddressErr = uvm_reg_field::type_id::create("txPTAddressErr");
        txNextPointerErr = uvm_reg_field::type_id::create("txNextPointerErr");
        txUPatternErr = uvm_reg_field::type_id::create("txUPatternErr");
        txLenMismatch = uvm_reg_field::type_id::create("txLenMismatch");

        txNewHeadErr.configure(this, 1, 5, "RO", 1, 'b0, 1, 1, 1);
        txBusErr.configure(this, 1, 4, "RO", 1, 'b0, 1, 1, 1);
        txPTAddressErr.configure(this, 1, 3, "RO", 1, 'b0, 1, 1, 1);
        txNextPointerErr.configure(this, 1, 2, "RO", 1, 'b0, 1, 1, 1);
        txUPatternErr.configure(this, 1, 1, "RO", 1, 'b0, 1, 1, 1);
        txLenMismatch.configure(this, 1, 0, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DMASTATUS2REG_rd_cg";
        txNewHeadErr_rd : coverpoint txNewHeadErr.value[0:0];
        txBusErr_rd : coverpoint txBusErr.value[0:0];
        txPTAddressErr_rd : coverpoint txPTAddressErr.value[0:0];
        txNextPointerErr_rd : coverpoint txNextPointerErr.value[0:0];
        txUPatternErr_rd : coverpoint txUPatternErr.value[0:0];
        txLenMismatch_rd : coverpoint txLenMismatch.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DMASTATUS2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DMASTATUS3REG
//--------------------------------------------------------------------
class DMASTATUS3REG extends uvm_reg;
    `uvm_object_utils(DMASTATUS3REG)
    rand uvm_reg_field rxPayBusErr;
    rand uvm_reg_field rxHdrBusErr;

    //---build------------------------------------------------------------
    virtual function void build();
        rxPayBusErr = uvm_reg_field::type_id::create("rxPayBusErr");
        rxHdrBusErr = uvm_reg_field::type_id::create("rxHdrBusErr");

        rxPayBusErr.configure(this, 1, 5, "RO", 1, 'b0, 1, 1, 1);
        rxHdrBusErr.configure(this, 1, 4, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DMASTATUS3REG_rd_cg";
        rxPayBusErr_rd : coverpoint rxPayBusErr.value[0:0];
        rxHdrBusErr_rd : coverpoint rxHdrBusErr.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DMASTATUS3REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DMASTATUS4REG
//--------------------------------------------------------------------
class DMASTATUS4REG extends uvm_reg;
    `uvm_object_utils(DMASTATUS4REG)
    rand uvm_reg_field txTBHaltAfterTXOP;
    rand uvm_reg_field txAC3HaltAfterTXOP;
    rand uvm_reg_field txAC2HaltAfterTXOP;
    rand uvm_reg_field txAC1HaltAfterTXOP;
    rand uvm_reg_field txAC0HaltAfterTXOP;
    rand uvm_reg_field txBcnHaltAfterTXOP;
    rand uvm_reg_field txAC3EndQ;
    rand uvm_reg_field txAC2EndQ;
    rand uvm_reg_field txAC1EndQ;
    rand uvm_reg_field txAC0EndQ;
    rand uvm_reg_field txBcnEndQ;
    rand uvm_reg_field txAC3Startup;
    rand uvm_reg_field txAC2Startup;
    rand uvm_reg_field txAC1Startup;
    rand uvm_reg_field txAC0Startup;
    rand uvm_reg_field txBcnStartup;

    //---build------------------------------------------------------------
    virtual function void build();
        txTBHaltAfterTXOP = uvm_reg_field::type_id::create("txTBHaltAfterTXOP");
        txAC3HaltAfterTXOP = uvm_reg_field::type_id::create("txAC3HaltAfterTXOP");
        txAC2HaltAfterTXOP = uvm_reg_field::type_id::create("txAC2HaltAfterTXOP");
        txAC1HaltAfterTXOP = uvm_reg_field::type_id::create("txAC1HaltAfterTXOP");
        txAC0HaltAfterTXOP = uvm_reg_field::type_id::create("txAC0HaltAfterTXOP");
        txBcnHaltAfterTXOP = uvm_reg_field::type_id::create("txBcnHaltAfterTXOP");
        txAC3EndQ = uvm_reg_field::type_id::create("txAC3EndQ");
        txAC2EndQ = uvm_reg_field::type_id::create("txAC2EndQ");
        txAC1EndQ = uvm_reg_field::type_id::create("txAC1EndQ");
        txAC0EndQ = uvm_reg_field::type_id::create("txAC0EndQ");
        txBcnEndQ = uvm_reg_field::type_id::create("txBcnEndQ");
        txAC3Startup = uvm_reg_field::type_id::create("txAC3Startup");
        txAC2Startup = uvm_reg_field::type_id::create("txAC2Startup");
        txAC1Startup = uvm_reg_field::type_id::create("txAC1Startup");
        txAC0Startup = uvm_reg_field::type_id::create("txAC0Startup");
        txBcnStartup = uvm_reg_field::type_id::create("txBcnStartup");

        txTBHaltAfterTXOP.configure(this, 1, 15, "RO", 1, 'b0, 1, 1, 1);
        txAC3HaltAfterTXOP.configure(this, 1, 14, "RO", 1, 'b0, 1, 1, 1);
        txAC2HaltAfterTXOP.configure(this, 1, 13, "RO", 1, 'b0, 1, 1, 1);
        txAC1HaltAfterTXOP.configure(this, 1, 12, "RO", 1, 'b0, 1, 1, 1);
        txAC0HaltAfterTXOP.configure(this, 1, 11, "RO", 1, 'b0, 1, 1, 1);
        txBcnHaltAfterTXOP.configure(this, 1, 10, "RO", 1, 'b0, 1, 1, 1);
        txAC3EndQ.configure(this, 1, 9, "RO", 1, 'b0, 1, 1, 1);
        txAC2EndQ.configure(this, 1, 8, "RO", 1, 'b0, 1, 1, 1);
        txAC1EndQ.configure(this, 1, 7, "RO", 1, 'b0, 1, 1, 1);
        txAC0EndQ.configure(this, 1, 6, "RO", 1, 'b0, 1, 1, 1);
        txBcnEndQ.configure(this, 1, 5, "RO", 1, 'b0, 1, 1, 1);
        txAC3Startup.configure(this, 1, 4, "RO", 1, 'b1, 1, 1, 1);
        txAC2Startup.configure(this, 1, 3, "RO", 1, 'b1, 1, 1, 1);
        txAC1Startup.configure(this, 1, 2, "RO", 1, 'b1, 1, 1, 1);
        txAC0Startup.configure(this, 1, 1, "RO", 1, 'b1, 1, 1, 1);
        txBcnStartup.configure(this, 1, 0, "RO", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DMASTATUS4REG_rd_cg";
        txTBHaltAfterTXOP_rd : coverpoint txTBHaltAfterTXOP.value[0:0];
        txAC3HaltAfterTXOP_rd : coverpoint txAC3HaltAfterTXOP.value[0:0];
        txAC2HaltAfterTXOP_rd : coverpoint txAC2HaltAfterTXOP.value[0:0];
        txAC1HaltAfterTXOP_rd : coverpoint txAC1HaltAfterTXOP.value[0:0];
        txAC0HaltAfterTXOP_rd : coverpoint txAC0HaltAfterTXOP.value[0:0];
        txBcnHaltAfterTXOP_rd : coverpoint txBcnHaltAfterTXOP.value[0:0];
        txAC3EndQ_rd : coverpoint txAC3EndQ.value[0:0];
        txAC2EndQ_rd : coverpoint txAC2EndQ.value[0:0];
        txAC1EndQ_rd : coverpoint txAC1EndQ.value[0:0];
        txAC0EndQ_rd : coverpoint txAC0EndQ.value[0:0];
        txBcnEndQ_rd : coverpoint txBcnEndQ.value[0:0];
        txAC3Startup_rd : coverpoint txAC3Startup.value[0:0];
        txAC2Startup_rd : coverpoint txAC2Startup.value[0:0];
        txAC1Startup_rd : coverpoint txAC1Startup.value[0:0];
        txAC0Startup_rd : coverpoint txAC0Startup.value[0:0];
        txBcnStartup_rd : coverpoint txBcnStartup.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DMASTATUS4REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXBCNHEADPTRREG
//--------------------------------------------------------------------
class TXBCNHEADPTRREG extends uvm_reg;
    `uvm_object_utils(TXBCNHEADPTRREG)
    rand uvm_reg_field txBcnHeadPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        txBcnHeadPtr = uvm_reg_field::type_id::create("txBcnHeadPtr");

        txBcnHeadPtr.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TXBCNHEADPTRREG_wr_cg";
        txBcnHeadPtr_wr : coverpoint txBcnHeadPtr.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXBCNHEADPTRREG_rd_cg";
        txBcnHeadPtr_rd : coverpoint txBcnHeadPtr.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXBCNHEADPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXAC0HEADPTRREG
//--------------------------------------------------------------------
class TXAC0HEADPTRREG extends uvm_reg;
    `uvm_object_utils(TXAC0HEADPTRREG)
    rand uvm_reg_field txAC0HeadPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        txAC0HeadPtr = uvm_reg_field::type_id::create("txAC0HeadPtr");

        txAC0HeadPtr.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TXAC0HEADPTRREG_wr_cg";
        txAC0HeadPtr_wr : coverpoint txAC0HeadPtr.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXAC0HEADPTRREG_rd_cg";
        txAC0HeadPtr_rd : coverpoint txAC0HeadPtr.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXAC0HEADPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXAC1HEADPTRREG
//--------------------------------------------------------------------
class TXAC1HEADPTRREG extends uvm_reg;
    `uvm_object_utils(TXAC1HEADPTRREG)
    rand uvm_reg_field txAC1HeadPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        txAC1HeadPtr = uvm_reg_field::type_id::create("txAC1HeadPtr");

        txAC1HeadPtr.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TXAC1HEADPTRREG_wr_cg";
        txAC1HeadPtr_wr : coverpoint txAC1HeadPtr.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXAC1HEADPTRREG_rd_cg";
        txAC1HeadPtr_rd : coverpoint txAC1HeadPtr.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXAC1HEADPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXAC2HEADPTRREG
//--------------------------------------------------------------------
class TXAC2HEADPTRREG extends uvm_reg;
    `uvm_object_utils(TXAC2HEADPTRREG)
    rand uvm_reg_field txAC2HeadPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        txAC2HeadPtr = uvm_reg_field::type_id::create("txAC2HeadPtr");

        txAC2HeadPtr.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TXAC2HEADPTRREG_wr_cg";
        txAC2HeadPtr_wr : coverpoint txAC2HeadPtr.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXAC2HEADPTRREG_rd_cg";
        txAC2HeadPtr_rd : coverpoint txAC2HeadPtr.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXAC2HEADPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXAC3HEADPTRREG
//--------------------------------------------------------------------
class TXAC3HEADPTRREG extends uvm_reg;
    `uvm_object_utils(TXAC3HEADPTRREG)
    rand uvm_reg_field txAC3HeadPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        txAC3HeadPtr = uvm_reg_field::type_id::create("txAC3HeadPtr");

        txAC3HeadPtr.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TXAC3HEADPTRREG_wr_cg";
        txAC3HeadPtr_wr : coverpoint txAC3HeadPtr.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXAC3HEADPTRREG_rd_cg";
        txAC3HeadPtr_rd : coverpoint txAC3HeadPtr.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXAC3HEADPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXTBHEADPTRREG
//--------------------------------------------------------------------
class TXTBHEADPTRREG extends uvm_reg;
    `uvm_object_utils(TXTBHEADPTRREG)
    rand uvm_reg_field txTBHeadPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        txTBHeadPtr = uvm_reg_field::type_id::create("txTBHeadPtr");

        txTBHeadPtr.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TXTBHEADPTRREG_wr_cg";
        txTBHeadPtr_wr : coverpoint txTBHeadPtr.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXTBHEADPTRREG_rd_cg";
        txTBHeadPtr_rd : coverpoint txTBHeadPtr.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXTBHEADPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXSTRUCTSIZESREG
//--------------------------------------------------------------------
class TXSTRUCTSIZESREG extends uvm_reg;
    `uvm_object_utils(TXSTRUCTSIZESREG)
    rand uvm_reg_field dmaRBDSize;
    rand uvm_reg_field dmaRHDSize;
    rand uvm_reg_field dmaTBDSize;
    rand uvm_reg_field dmaTHDSize;
    rand uvm_reg_field ptEntrySize;

    //---build------------------------------------------------------------
    virtual function void build();
        dmaRBDSize = uvm_reg_field::type_id::create("dmaRBDSize");
        dmaRHDSize = uvm_reg_field::type_id::create("dmaRHDSize");
        dmaTBDSize = uvm_reg_field::type_id::create("dmaTBDSize");
        dmaTHDSize = uvm_reg_field::type_id::create("dmaTHDSize");
        ptEntrySize = uvm_reg_field::type_id::create("ptEntrySize");

        dmaRBDSize.configure(this, 6, 24, "RW", 1, `RBD_SIZE, 1, 1, 1);
        dmaRHDSize.configure(this, 6, 18, "RW", 1, `RHD_SIZE, 1, 1, 1);
        dmaTBDSize.configure(this, 6, 12, "RW", 1, `TBD_SIZE, 1, 1, 1);
        dmaTHDSize.configure(this, 6, 6, "RW", 1, `THD_SIZE, 1, 1, 1);
        ptEntrySize.configure(this, 6, 0, "RW", 1, `PT_SIZE, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TXSTRUCTSIZESREG_wr_cg";
        dmaRBDSize_wr : coverpoint dmaRBDSize.value[5:0];
        dmaRHDSize_wr : coverpoint dmaRHDSize.value[5:0];
        dmaTBDSize_wr : coverpoint dmaTBDSize.value[5:0];
        dmaTHDSize_wr : coverpoint dmaTHDSize.value[5:0];
        ptEntrySize_wr : coverpoint ptEntrySize.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXSTRUCTSIZESREG_rd_cg";
        dmaRBDSize_rd : coverpoint dmaRBDSize.value[5:0];
        dmaRHDSize_rd : coverpoint dmaRHDSize.value[5:0];
        dmaTBDSize_rd : coverpoint dmaTBDSize.value[5:0];
        dmaTHDSize_rd : coverpoint dmaTHDSize.value[5:0];
        ptEntrySize_rd : coverpoint ptEntrySize.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXSTRUCTSIZESREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DMATHRESHOLDREG
//--------------------------------------------------------------------
class DMATHRESHOLDREG extends uvm_reg;
    `uvm_object_utils(DMATHRESHOLDREG)
    rand uvm_reg_field rxFIFOThreshold;
    rand uvm_reg_field txFIFOThreshold;

    //---build------------------------------------------------------------
    virtual function void build();
        rxFIFOThreshold = uvm_reg_field::type_id::create("rxFIFOThreshold");
        txFIFOThreshold = uvm_reg_field::type_id::create("txFIFOThreshold");

        rxFIFOThreshold.configure(this, 8, 16, "RW", 1, 'b0010000, 1, 1, 1);
        txFIFOThreshold.configure(this, 8, 0, "RW", 1, 'b0010000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_DMATHRESHOLDREG_wr_cg";
        rxFIFOThreshold_wr : coverpoint rxFIFOThreshold.value[7:0];
        txFIFOThreshold_wr : coverpoint txFIFOThreshold.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DMATHRESHOLDREG_rd_cg";
        rxFIFOThreshold_rd : coverpoint rxFIFOThreshold.value[7:0];
        txFIFOThreshold_rd : coverpoint txFIFOThreshold.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DMATHRESHOLDREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXHEADERTFPTRREG
//--------------------------------------------------------------------
class RXHEADERTFPTRREG extends uvm_reg;
    `uvm_object_utils(RXHEADERTFPTRREG)
    rand uvm_reg_field rxHeaderTFPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        rxHeaderTFPtr = uvm_reg_field::type_id::create("rxHeaderTFPtr");

        rxHeaderTFPtr.configure(this, 30, 2, "RO", 1, 'b00000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXHEADERTFPTRREG_rd_cg";
        rxHeaderTFPtr_rd : coverpoint rxHeaderTFPtr.value[29:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXHEADERTFPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXBUF1STARTPTRREG
//--------------------------------------------------------------------
class RXBUF1STARTPTRREG extends uvm_reg;
    `uvm_object_utils(RXBUF1STARTPTRREG)
    rand uvm_reg_field rxBuf1StartPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        rxBuf1StartPtr = uvm_reg_field::type_id::create("rxBuf1StartPtr");

        rxBuf1StartPtr.configure(this, 31, 0, "RW", 1, 'b000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF1STARTPTRREG_wr_cg";
        rxBuf1StartPtr_wr : coverpoint rxBuf1StartPtr.value[30:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF1STARTPTRREG_rd_cg";
        rxBuf1StartPtr_rd : coverpoint rxBuf1StartPtr.value[30:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXBUF1STARTPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXBUF1ENDPTRREG
//--------------------------------------------------------------------
class RXBUF1ENDPTRREG extends uvm_reg;
    `uvm_object_utils(RXBUF1ENDPTRREG)
    rand uvm_reg_field rxBuf1EndPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        rxBuf1EndPtr = uvm_reg_field::type_id::create("rxBuf1EndPtr");

        rxBuf1EndPtr.configure(this, 31, 0, "RW", 1, 'b000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF1ENDPTRREG_wr_cg";
        rxBuf1EndPtr_wr : coverpoint rxBuf1EndPtr.value[30:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF1ENDPTRREG_rd_cg";
        rxBuf1EndPtr_rd : coverpoint rxBuf1EndPtr.value[30:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXBUF1ENDPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXBUF1RDPTRREG
//--------------------------------------------------------------------
class RXBUF1RDPTRREG extends uvm_reg;
    `uvm_object_utils(RXBUF1RDPTRREG)
    rand uvm_reg_field rxBuf1RdPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        rxBuf1RdPtr = uvm_reg_field::type_id::create("rxBuf1RdPtr");

        rxBuf1RdPtr.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF1RDPTRREG_wr_cg";
        rxBuf1RdPtr_wr : coverpoint rxBuf1RdPtr.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF1RDPTRREG_rd_cg";
        rxBuf1RdPtr_rd : coverpoint rxBuf1RdPtr.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXBUF1RDPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXBUF1WRPTRREG
//--------------------------------------------------------------------
class RXBUF1WRPTRREG extends uvm_reg;
    `uvm_object_utils(RXBUF1WRPTRREG)
    rand uvm_reg_field rxBuf1WrPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        rxBuf1WrPtr = uvm_reg_field::type_id::create("rxBuf1WrPtr");

        rxBuf1WrPtr.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF1WRPTRREG_wr_cg";
        rxBuf1WrPtr_wr : coverpoint rxBuf1WrPtr.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF1WRPTRREG_rd_cg";
        rxBuf1WrPtr_rd : coverpoint rxBuf1WrPtr.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXBUF1WRPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXBUF2STARTPTRREG
//--------------------------------------------------------------------
class RXBUF2STARTPTRREG extends uvm_reg;
    `uvm_object_utils(RXBUF2STARTPTRREG)
    rand uvm_reg_field rxBuf2StartPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        rxBuf2StartPtr = uvm_reg_field::type_id::create("rxBuf2StartPtr");

        rxBuf2StartPtr.configure(this, 31, 0, "RW", 1, 'b000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF2STARTPTRREG_wr_cg";
        rxBuf2StartPtr_wr : coverpoint rxBuf2StartPtr.value[30:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF2STARTPTRREG_rd_cg";
        rxBuf2StartPtr_rd : coverpoint rxBuf2StartPtr.value[30:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXBUF2STARTPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXBUF2ENDPTRREG
//--------------------------------------------------------------------
class RXBUF2ENDPTRREG extends uvm_reg;
    `uvm_object_utils(RXBUF2ENDPTRREG)
    rand uvm_reg_field rxBuf2EndPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        rxBuf2EndPtr = uvm_reg_field::type_id::create("rxBuf2EndPtr");

        rxBuf2EndPtr.configure(this, 31, 0, "RW", 1, 'b000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF2ENDPTRREG_wr_cg";
        rxBuf2EndPtr_wr : coverpoint rxBuf2EndPtr.value[30:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF2ENDPTRREG_rd_cg";
        rxBuf2EndPtr_rd : coverpoint rxBuf2EndPtr.value[30:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXBUF2ENDPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXBUF2RDPTRREG
//--------------------------------------------------------------------
class RXBUF2RDPTRREG extends uvm_reg;
    `uvm_object_utils(RXBUF2RDPTRREG)
    rand uvm_reg_field rxBuf2RdPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        rxBuf2RdPtr = uvm_reg_field::type_id::create("rxBuf2RdPtr");

        rxBuf2RdPtr.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF2RDPTRREG_wr_cg";
        rxBuf2RdPtr_wr : coverpoint rxBuf2RdPtr.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF2RDPTRREG_rd_cg";
        rxBuf2RdPtr_rd : coverpoint rxBuf2RdPtr.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXBUF2RDPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXBUF2WRPTRREG
//--------------------------------------------------------------------
class RXBUF2WRPTRREG extends uvm_reg;
    `uvm_object_utils(RXBUF2WRPTRREG)
    rand uvm_reg_field rxBuf2WrPtr;

    //---build------------------------------------------------------------
    virtual function void build();
        rxBuf2WrPtr = uvm_reg_field::type_id::create("rxBuf2WrPtr");

        rxBuf2WrPtr.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF2WRPTRREG_wr_cg";
        rxBuf2WrPtr_wr : coverpoint rxBuf2WrPtr.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUF2WRPTRREG_rd_cg";
        rxBuf2WrPtr_rd : coverpoint rxBuf2WrPtr.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXBUF2WRPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXBUFCONFIGREG
//--------------------------------------------------------------------
class RXBUFCONFIGREG extends uvm_reg;
    `uvm_object_utils(RXBUFCONFIGREG)
    rand uvm_reg_field rxBufRPDFooter;
    rand uvm_reg_field rxBufRPDHeader;
    rand uvm_reg_field rxBufRHDFooter;
    rand uvm_reg_field rxBufRHDHeader;

    //---build------------------------------------------------------------
    virtual function void build();
        rxBufRPDFooter = uvm_reg_field::type_id::create("rxBufRPDFooter");
        rxBufRPDHeader = uvm_reg_field::type_id::create("rxBufRPDHeader");
        rxBufRHDFooter = uvm_reg_field::type_id::create("rxBufRHDFooter");
        rxBufRHDHeader = uvm_reg_field::type_id::create("rxBufRHDHeader");

        rxBufRPDFooter.configure(this, 8, 24, "RW", 1, 'b0000000, 1, 1, 1);
        rxBufRPDHeader.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        rxBufRHDFooter.configure(this, 8, 8, "RW", 1, 'b0000000, 1, 1, 1);
        rxBufRHDHeader.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUFCONFIGREG_wr_cg";
        rxBufRPDFooter_wr : coverpoint rxBufRPDFooter.value[7:0];
        rxBufRPDHeader_wr : coverpoint rxBufRPDHeader.value[7:0];
        rxBufRHDFooter_wr : coverpoint rxBufRHDFooter.value[7:0];
        rxBufRHDHeader_wr : coverpoint rxBufRHDHeader.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXBUFCONFIGREG_rd_cg";
        rxBufRPDFooter_rd : coverpoint rxBufRPDFooter.value[7:0];
        rxBufRPDHeader_rd : coverpoint rxBufRPDHeader.value[7:0];
        rxBufRHDFooter_rd : coverpoint rxBufRHDFooter.value[7:0];
        rxBufRHDHeader_rd : coverpoint rxBufRHDHeader.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXBUFCONFIGREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MOT1REG
//--------------------------------------------------------------------
class MOT1REG extends uvm_reg;
    `uvm_object_utils(MOT1REG)
    rand uvm_reg_field ac1MOT;
    rand uvm_reg_field ac0MOT;

    //---build------------------------------------------------------------
    virtual function void build();
        ac1MOT = uvm_reg_field::type_id::create("ac1MOT");
        ac0MOT = uvm_reg_field::type_id::create("ac0MOT");

        ac1MOT.configure(this, 16, 16, "RO", 1, 'b000000000000000, 1, 1, 1);
        ac0MOT.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_MOT1REG_rd_cg";
        ac1MOT_rd : coverpoint ac1MOT.value[15:0];
        ac0MOT_rd : coverpoint ac0MOT.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MOT1REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MOT2REG
//--------------------------------------------------------------------
class MOT2REG extends uvm_reg;
    `uvm_object_utils(MOT2REG)
    rand uvm_reg_field ac3MOT;
    rand uvm_reg_field ac2MOT;

    //---build------------------------------------------------------------
    virtual function void build();
        ac3MOT = uvm_reg_field::type_id::create("ac3MOT");
        ac2MOT = uvm_reg_field::type_id::create("ac2MOT");

        ac3MOT.configure(this, 16, 16, "RO", 1, 'b000000000101111, 1, 1, 1);
        ac2MOT.configure(this, 16, 0, "RO", 1, 'b000000001011110, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_MOT2REG_rd_cg";
        ac3MOT_rd : coverpoint ac3MOT.value[15:0];
        ac2MOT_rd : coverpoint ac2MOT.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MOT2REG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXBWDROPINFOREG
//--------------------------------------------------------------------
class TXBWDROPINFOREG extends uvm_reg;
    `uvm_object_utils(TXBWDROPINFOREG)
    rand uvm_reg_field txBWAfterDrop;

    //---build------------------------------------------------------------
    virtual function void build();
        txBWAfterDrop = uvm_reg_field::type_id::create("txBWAfterDrop");

        txBWAfterDrop.configure(this, 2, 0, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXBWDROPINFOREG_rd_cg";
        txBWAfterDrop_rd : coverpoint txBWAfterDrop.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXBWDROPINFOREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXHETBINFOREG
//--------------------------------------------------------------------
class TXHETBINFOREG extends uvm_reg;
    `uvm_object_utils(TXHETBINFOREG)
    rand uvm_reg_field maxMCSInHETB;
    rand uvm_reg_field eOCW;
    rand uvm_reg_field eOCWMin;
    rand uvm_reg_field raRUType;
    rand uvm_reg_field raRUEnable;
    rand uvm_reg_field txHETBMaxDur;
    rand uvm_reg_field txHETBRemDur;

    //---build------------------------------------------------------------
    virtual function void build();
        maxMCSInHETB = uvm_reg_field::type_id::create("maxMCSInHETB");
        eOCW = uvm_reg_field::type_id::create("eOCW");
        eOCWMin = uvm_reg_field::type_id::create("eOCWMin");
        raRUType = uvm_reg_field::type_id::create("raRUType");
        raRUEnable = uvm_reg_field::type_id::create("raRUEnable");
        txHETBMaxDur = uvm_reg_field::type_id::create("txHETBMaxDur");
        txHETBRemDur = uvm_reg_field::type_id::create("txHETBRemDur");

        maxMCSInHETB.configure(this, 4, 28, "RW", 1, 'b111, 1, 1, 1);
        eOCW.configure(this, 3, 24, "RW", 1, 'b11, 1, 1, 1);
        eOCWMin.configure(this, 3, 20, "RW", 1, 'b11, 1, 1, 1);
        raRUType.configure(this, 1, 17, "RW", 1, 'b0, 1, 1, 1);
        raRUEnable.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        txHETBMaxDur.configure(this, 6, 8, "RW", 1, 'b11100, 1, 1, 1);
        txHETBRemDur.configure(this, 6, 0, "RO", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_TXHETBINFOREG_wr_cg";
        maxMCSInHETB_wr : coverpoint maxMCSInHETB.value[3:0];
        eOCW_wr : coverpoint eOCW.value[2:0];
        eOCWMin_wr : coverpoint eOCWMin.value[2:0];
        raRUType_wr : coverpoint raRUType.value[0:0];
        raRUEnable_wr : coverpoint raRUEnable.value[0:0];
        txHETBMaxDur_wr : coverpoint txHETBMaxDur.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_TXHETBINFOREG_rd_cg";
        maxMCSInHETB_rd : coverpoint maxMCSInHETB.value[3:0];
        eOCW_rd : coverpoint eOCW.value[2:0];
        eOCWMin_rd : coverpoint eOCWMin.value[2:0];
        raRUType_rd : coverpoint raRUType.value[0:0];
        raRUEnable_rd : coverpoint raRUEnable.value[0:0];
        txHETBMaxDur_rd : coverpoint txHETBMaxDur.value[5:0];
        txHETBRemDur_rd : coverpoint txHETBRemDur.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXHETBINFOREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXHETRIGCOMMONINFOREG
//--------------------------------------------------------------------
class RXHETRIGCOMMONINFOREG extends uvm_reg;
    `uvm_object_utils(RXHETRIGCOMMONINFOREG)
    rand uvm_reg_field ulDoppler;
    rand uvm_reg_field ulPEDisambiguity;
    rand uvm_reg_field ulPreFecPadding;
    rand uvm_reg_field ulLDPCExtrSymb;
    rand uvm_reg_field ulSTBC;
    rand uvm_reg_field ulNLTFAndMidamble;
    rand uvm_reg_field ulMULTFMode;
    rand uvm_reg_field ulGILTFType;
    rand uvm_reg_field ulBW;
    rand uvm_reg_field ulLength;
    rand uvm_reg_field ulTriggerType;

    //---build------------------------------------------------------------
    virtual function void build();
        ulDoppler = uvm_reg_field::type_id::create("ulDoppler");
        ulPEDisambiguity = uvm_reg_field::type_id::create("ulPEDisambiguity");
        ulPreFecPadding = uvm_reg_field::type_id::create("ulPreFecPadding");
        ulLDPCExtrSymb = uvm_reg_field::type_id::create("ulLDPCExtrSymb");
        ulSTBC = uvm_reg_field::type_id::create("ulSTBC");
        ulNLTFAndMidamble = uvm_reg_field::type_id::create("ulNLTFAndMidamble");
        ulMULTFMode = uvm_reg_field::type_id::create("ulMULTFMode");
        ulGILTFType = uvm_reg_field::type_id::create("ulGILTFType");
        ulBW = uvm_reg_field::type_id::create("ulBW");
        ulLength = uvm_reg_field::type_id::create("ulLength");
        ulTriggerType = uvm_reg_field::type_id::create("ulTriggerType");

        ulDoppler.configure(this, 1, 29, "RO", 1, 'b0, 1, 1, 1);
        ulPEDisambiguity.configure(this, 1, 28, "RO", 1, 'b0, 1, 1, 1);
        ulPreFecPadding.configure(this, 2, 26, "RO", 1, 'b0, 1, 1, 1);
        ulLDPCExtrSymb.configure(this, 1, 25, "RO", 1, 'b0, 1, 1, 1);
        ulSTBC.configure(this, 1, 24, "RO", 1, 'b0, 1, 1, 1);
        ulNLTFAndMidamble.configure(this, 3, 21, "RO", 1, 'b00, 1, 1, 1);
        ulMULTFMode.configure(this, 1, 20, "RO", 1, 'b0, 1, 1, 1);
        ulGILTFType.configure(this, 2, 18, "RO", 1, 'b0, 1, 1, 1);
        ulBW.configure(this, 2, 16, "RO", 1, 'b0, 1, 1, 1);
        ulLength.configure(this, 12, 4, "RO", 1, 'b00000000000, 1, 1, 1);
        ulTriggerType.configure(this, 4, 0, "RO", 1, 'b000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXHETRIGCOMMONINFOREG_rd_cg";
        ulDoppler_rd : coverpoint ulDoppler.value[0:0];
        ulPEDisambiguity_rd : coverpoint ulPEDisambiguity.value[0:0];
        ulPreFecPadding_rd : coverpoint ulPreFecPadding.value[1:0];
        ulLDPCExtrSymb_rd : coverpoint ulLDPCExtrSymb.value[0:0];
        ulSTBC_rd : coverpoint ulSTBC.value[0:0];
        ulNLTFAndMidamble_rd : coverpoint ulNLTFAndMidamble.value[2:0];
        ulMULTFMode_rd : coverpoint ulMULTFMode.value[0:0];
        ulGILTFType_rd : coverpoint ulGILTFType.value[1:0];
        ulBW_rd : coverpoint ulBW.value[1:0];
        ulLength_rd : coverpoint ulLength.value[11:0];
        ulTriggerType_rd : coverpoint ulTriggerType.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXHETRIGCOMMONINFOREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXHETRIGUSERINFOREG
//--------------------------------------------------------------------
class RXHETRIGUSERINFOREG extends uvm_reg;
    `uvm_object_utils(RXHETRIGUSERINFOREG)
    rand uvm_reg_field tdUserInfoSubfield;
    rand uvm_reg_field ulRUType;
    rand uvm_reg_field ulNSS;
    rand uvm_reg_field ulDCM;
    rand uvm_reg_field ulMCS;
    rand uvm_reg_field ulFECCoding;
    rand uvm_reg_field ulRUSize;

    //---build------------------------------------------------------------
    virtual function void build();
        tdUserInfoSubfield = uvm_reg_field::type_id::create("tdUserInfoSubfield");
        ulRUType = uvm_reg_field::type_id::create("ulRUType");
        ulNSS = uvm_reg_field::type_id::create("ulNSS");
        ulDCM = uvm_reg_field::type_id::create("ulDCM");
        ulMCS = uvm_reg_field::type_id::create("ulMCS");
        ulFECCoding = uvm_reg_field::type_id::create("ulFECCoding");
        ulRUSize = uvm_reg_field::type_id::create("ulRUSize");

        tdUserInfoSubfield.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        ulRUType.configure(this, 1, 12, "RO", 1, 'b0, 1, 1, 1);
        ulNSS.configure(this, 3, 9, "RO", 1, 'b00, 1, 1, 1);
        ulDCM.configure(this, 1, 8, "RO", 1, 'b0, 1, 1, 1);
        ulMCS.configure(this, 4, 4, "RO", 1, 'b000, 1, 1, 1);
        ulFECCoding.configure(this, 1, 3, "RO", 1, 'b0, 1, 1, 1);
        ulRUSize.configure(this, 3, 0, "RO", 1, 'b00, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXHETRIGUSERINFOREG_rd_cg";
        tdUserInfoSubfield_rd : coverpoint tdUserInfoSubfield.value[7:0];
        ulRUType_rd : coverpoint ulRUType.value[0:0];
        ulNSS_rd : coverpoint ulNSS.value[2:0];
        ulDCM_rd : coverpoint ulDCM.value[0:0];
        ulMCS_rd : coverpoint ulMCS.value[3:0];
        ulFECCoding_rd : coverpoint ulFECCoding.value[0:0];
        ulRUSize_rd : coverpoint ulRUSize.value[2:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXHETRIGUSERINFOREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXHETRIGPSDULENREG
//--------------------------------------------------------------------
class RXHETRIGPSDULENREG extends uvm_reg;
    `uvm_object_utils(RXHETRIGPSDULENREG)
    rand uvm_reg_field ulPSDULenValid;
    rand uvm_reg_field ulPSDULen;

    //---build------------------------------------------------------------
    virtual function void build();
        ulPSDULenValid = uvm_reg_field::type_id::create("ulPSDULenValid");
        ulPSDULen = uvm_reg_field::type_id::create("ulPSDULen");

        ulPSDULenValid.configure(this, 1, 31, "RO", 1, 'b1, 1, 1, 1);
        ulPSDULen.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXHETRIGPSDULENREG_rd_cg";
        ulPSDULenValid_rd : coverpoint ulPSDULenValid.value[0:0];
        ulPSDULen_rd : coverpoint ulPSDULen.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXHETRIGPSDULENREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXHETRIGPWRINFOREG
//--------------------------------------------------------------------
class RXHETRIGPWRINFOREG extends uvm_reg;
    `uvm_object_utils(RXHETRIGPWRINFOREG)
    rand uvm_reg_field heTBUPHControl;
    rand uvm_reg_field ulTargetRSSI;
    rand uvm_reg_field apTXPower;

    //---build------------------------------------------------------------
    virtual function void build();
        heTBUPHControl = uvm_reg_field::type_id::create("heTBUPHControl");
        ulTargetRSSI = uvm_reg_field::type_id::create("ulTargetRSSI");
        apTXPower = uvm_reg_field::type_id::create("apTXPower");

        heTBUPHControl.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        ulTargetRSSI.configure(this, 7, 8, "RO", 1, 'b000000, 1, 1, 1);
        apTXPower.configure(this, 6, 0, "RO", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_RXHETRIGPWRINFOREG_rd_cg";
        heTBUPHControl_rd : coverpoint heTBUPHControl.value[7:0];
        ulTargetRSSI_rd : coverpoint ulTargetRSSI.value[6:0];
        apTXPower_rd : coverpoint apTXPower.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXHETRIGPWRINFOREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SECUSERSTXINTEVENTSETREG
//--------------------------------------------------------------------
class SECUSERSTXINTEVENTSETREG extends uvm_reg;
    `uvm_object_utils(SECUSERSTXINTEVENTSETREG)
    rand uvm_reg_field setsecU3ac3TxBufTrigger;
    rand uvm_reg_field setsecU3ac2TxBufTrigger;
    rand uvm_reg_field setsecU3ac1TxBufTrigger;
    rand uvm_reg_field setsecU3ac0TxBufTrigger;
    rand uvm_reg_field setsecU3ac3TxTrigger;
    rand uvm_reg_field setsecU3ac2TxTrigger;
    rand uvm_reg_field setsecU3ac1TxTrigger;
    rand uvm_reg_field setsecU3ac0TxTrigger;
    rand uvm_reg_field setsecU2ac3TxBufTrigger;
    rand uvm_reg_field setsecU2ac2TxBufTrigger;
    rand uvm_reg_field setsecU2ac1TxBufTrigger;
    rand uvm_reg_field setsecU2ac0TxBufTrigger;
    rand uvm_reg_field setsecU2ac3TxTrigger;
    rand uvm_reg_field setsecU2ac2TxTrigger;
    rand uvm_reg_field setsecU2ac1TxTrigger;
    rand uvm_reg_field setsecU2ac0TxTrigger;
    rand uvm_reg_field setsecU1ac3TxBufTrigger;
    rand uvm_reg_field setsecU1ac2TxBufTrigger;
    rand uvm_reg_field setsecU1ac1TxBufTrigger;
    rand uvm_reg_field setsecU1ac0TxBufTrigger;
    rand uvm_reg_field setsecU1ac3TxTrigger;
    rand uvm_reg_field setsecU1ac2TxTrigger;
    rand uvm_reg_field setsecU1ac1TxTrigger;
    rand uvm_reg_field setsecU1ac0TxTrigger;

    //---build------------------------------------------------------------
    virtual function void build();
        setsecU3ac3TxBufTrigger = uvm_reg_field::type_id::create("setsecU3ac3TxBufTrigger");
        setsecU3ac2TxBufTrigger = uvm_reg_field::type_id::create("setsecU3ac2TxBufTrigger");
        setsecU3ac1TxBufTrigger = uvm_reg_field::type_id::create("setsecU3ac1TxBufTrigger");
        setsecU3ac0TxBufTrigger = uvm_reg_field::type_id::create("setsecU3ac0TxBufTrigger");
        setsecU3ac3TxTrigger = uvm_reg_field::type_id::create("setsecU3ac3TxTrigger");
        setsecU3ac2TxTrigger = uvm_reg_field::type_id::create("setsecU3ac2TxTrigger");
        setsecU3ac1TxTrigger = uvm_reg_field::type_id::create("setsecU3ac1TxTrigger");
        setsecU3ac0TxTrigger = uvm_reg_field::type_id::create("setsecU3ac0TxTrigger");
        setsecU2ac3TxBufTrigger = uvm_reg_field::type_id::create("setsecU2ac3TxBufTrigger");
        setsecU2ac2TxBufTrigger = uvm_reg_field::type_id::create("setsecU2ac2TxBufTrigger");
        setsecU2ac1TxBufTrigger = uvm_reg_field::type_id::create("setsecU2ac1TxBufTrigger");
        setsecU2ac0TxBufTrigger = uvm_reg_field::type_id::create("setsecU2ac0TxBufTrigger");
        setsecU2ac3TxTrigger = uvm_reg_field::type_id::create("setsecU2ac3TxTrigger");
        setsecU2ac2TxTrigger = uvm_reg_field::type_id::create("setsecU2ac2TxTrigger");
        setsecU2ac1TxTrigger = uvm_reg_field::type_id::create("setsecU2ac1TxTrigger");
        setsecU2ac0TxTrigger = uvm_reg_field::type_id::create("setsecU2ac0TxTrigger");
        setsecU1ac3TxBufTrigger = uvm_reg_field::type_id::create("setsecU1ac3TxBufTrigger");
        setsecU1ac2TxBufTrigger = uvm_reg_field::type_id::create("setsecU1ac2TxBufTrigger");
        setsecU1ac1TxBufTrigger = uvm_reg_field::type_id::create("setsecU1ac1TxBufTrigger");
        setsecU1ac0TxBufTrigger = uvm_reg_field::type_id::create("setsecU1ac0TxBufTrigger");
        setsecU1ac3TxTrigger = uvm_reg_field::type_id::create("setsecU1ac3TxTrigger");
        setsecU1ac2TxTrigger = uvm_reg_field::type_id::create("setsecU1ac2TxTrigger");
        setsecU1ac1TxTrigger = uvm_reg_field::type_id::create("setsecU1ac1TxTrigger");
        setsecU1ac0TxTrigger = uvm_reg_field::type_id::create("setsecU1ac0TxTrigger");

        setsecU3ac3TxBufTrigger.configure(this, 1, 23, "W1S", 1, 'b0, 1, 1, 1);
        setsecU3ac2TxBufTrigger.configure(this, 1, 22, "W1S", 1, 'b0, 1, 1, 1);
        setsecU3ac1TxBufTrigger.configure(this, 1, 21, "W1S", 1, 'b0, 1, 1, 1);
        setsecU3ac0TxBufTrigger.configure(this, 1, 20, "W1S", 1, 'b0, 1, 1, 1);
        setsecU3ac3TxTrigger.configure(this, 1, 19, "W1S", 1, 'b0, 1, 1, 1);
        setsecU3ac2TxTrigger.configure(this, 1, 18, "W1S", 1, 'b0, 1, 1, 1);
        setsecU3ac1TxTrigger.configure(this, 1, 17, "W1S", 1, 'b0, 1, 1, 1);
        setsecU3ac0TxTrigger.configure(this, 1, 16, "W1S", 1, 'b0, 1, 1, 1);
        setsecU2ac3TxBufTrigger.configure(this, 1, 15, "W1S", 1, 'b0, 1, 1, 1);
        setsecU2ac2TxBufTrigger.configure(this, 1, 14, "W1S", 1, 'b0, 1, 1, 1);
        setsecU2ac1TxBufTrigger.configure(this, 1, 13, "W1S", 1, 'b0, 1, 1, 1);
        setsecU2ac0TxBufTrigger.configure(this, 1, 12, "W1S", 1, 'b0, 1, 1, 1);
        setsecU2ac3TxTrigger.configure(this, 1, 11, "W1S", 1, 'b0, 1, 1, 1);
        setsecU2ac2TxTrigger.configure(this, 1, 10, "W1S", 1, 'b0, 1, 1, 1);
        setsecU2ac1TxTrigger.configure(this, 1, 9, "W1S", 1, 'b0, 1, 1, 1);
        setsecU2ac0TxTrigger.configure(this, 1, 8, "W1S", 1, 'b0, 1, 1, 1);
        setsecU1ac3TxBufTrigger.configure(this, 1, 7, "W1S", 1, 'b0, 1, 1, 1);
        setsecU1ac2TxBufTrigger.configure(this, 1, 6, "W1S", 1, 'b0, 1, 1, 1);
        setsecU1ac1TxBufTrigger.configure(this, 1, 5, "W1S", 1, 'b0, 1, 1, 1);
        setsecU1ac0TxBufTrigger.configure(this, 1, 4, "W1S", 1, 'b0, 1, 1, 1);
        setsecU1ac3TxTrigger.configure(this, 1, 3, "W1S", 1, 'b0, 1, 1, 1);
        setsecU1ac2TxTrigger.configure(this, 1, 2, "W1S", 1, 'b0, 1, 1, 1);
        setsecU1ac1TxTrigger.configure(this, 1, 1, "W1S", 1, 'b0, 1, 1, 1);
        setsecU1ac0TxTrigger.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_SECUSERSTXINTEVENTSETREG_wr_cg";
        setsecU3ac3TxBufTrigger_wr : coverpoint setsecU3ac3TxBufTrigger.value[0:0];
        setsecU3ac2TxBufTrigger_wr : coverpoint setsecU3ac2TxBufTrigger.value[0:0];
        setsecU3ac1TxBufTrigger_wr : coverpoint setsecU3ac1TxBufTrigger.value[0:0];
        setsecU3ac0TxBufTrigger_wr : coverpoint setsecU3ac0TxBufTrigger.value[0:0];
        setsecU3ac3TxTrigger_wr : coverpoint setsecU3ac3TxTrigger.value[0:0];
        setsecU3ac2TxTrigger_wr : coverpoint setsecU3ac2TxTrigger.value[0:0];
        setsecU3ac1TxTrigger_wr : coverpoint setsecU3ac1TxTrigger.value[0:0];
        setsecU3ac0TxTrigger_wr : coverpoint setsecU3ac0TxTrigger.value[0:0];
        setsecU2ac3TxBufTrigger_wr : coverpoint setsecU2ac3TxBufTrigger.value[0:0];
        setsecU2ac2TxBufTrigger_wr : coverpoint setsecU2ac2TxBufTrigger.value[0:0];
        setsecU2ac1TxBufTrigger_wr : coverpoint setsecU2ac1TxBufTrigger.value[0:0];
        setsecU2ac0TxBufTrigger_wr : coverpoint setsecU2ac0TxBufTrigger.value[0:0];
        setsecU2ac3TxTrigger_wr : coverpoint setsecU2ac3TxTrigger.value[0:0];
        setsecU2ac2TxTrigger_wr : coverpoint setsecU2ac2TxTrigger.value[0:0];
        setsecU2ac1TxTrigger_wr : coverpoint setsecU2ac1TxTrigger.value[0:0];
        setsecU2ac0TxTrigger_wr : coverpoint setsecU2ac0TxTrigger.value[0:0];
        setsecU1ac3TxBufTrigger_wr : coverpoint setsecU1ac3TxBufTrigger.value[0:0];
        setsecU1ac2TxBufTrigger_wr : coverpoint setsecU1ac2TxBufTrigger.value[0:0];
        setsecU1ac1TxBufTrigger_wr : coverpoint setsecU1ac1TxBufTrigger.value[0:0];
        setsecU1ac0TxBufTrigger_wr : coverpoint setsecU1ac0TxBufTrigger.value[0:0];
        setsecU1ac3TxTrigger_wr : coverpoint setsecU1ac3TxTrigger.value[0:0];
        setsecU1ac2TxTrigger_wr : coverpoint setsecU1ac2TxTrigger.value[0:0];
        setsecU1ac1TxTrigger_wr : coverpoint setsecU1ac1TxTrigger.value[0:0];
        setsecU1ac0TxTrigger_wr : coverpoint setsecU1ac0TxTrigger.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SECUSERSTXINTEVENTSETREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SECUSERSTXINTEVENTCLEARREG
//--------------------------------------------------------------------
class SECUSERSTXINTEVENTCLEARREG extends uvm_reg;
    `uvm_object_utils(SECUSERSTXINTEVENTCLEARREG)
    rand uvm_reg_field clearsecU3ac3TxBufTrigger;
    rand uvm_reg_field clearsecU3ac2TxBufTrigger;
    rand uvm_reg_field clearsecU3ac1TxBufTrigger;
    rand uvm_reg_field clearsecU3ac0TxBufTrigger;
    rand uvm_reg_field clearsecU3ac3TxTrigger;
    rand uvm_reg_field clearsecU3ac2TxTrigger;
    rand uvm_reg_field clearsecU3ac1TxTrigger;
    rand uvm_reg_field clearsecU3ac0TxTrigger;
    rand uvm_reg_field clearsecU2ac3TxBufTrigger;
    rand uvm_reg_field clearsecU2ac2TxBufTrigger;
    rand uvm_reg_field clearsecU2ac1TxBufTrigger;
    rand uvm_reg_field clearsecU2ac0TxBufTrigger;
    rand uvm_reg_field clearsecU2ac3TxTrigger;
    rand uvm_reg_field clearsecU2ac2TxTrigger;
    rand uvm_reg_field clearsecU2ac1TxTrigger;
    rand uvm_reg_field clearsecU2ac0TxTrigger;
    rand uvm_reg_field clearsecU1ac3TxBufTrigger;
    rand uvm_reg_field clearsecU1ac2TxBufTrigger;
    rand uvm_reg_field clearsecU1ac1TxBufTrigger;
    rand uvm_reg_field clearsecU1ac0TxBufTrigger;
    rand uvm_reg_field clearsecU1ac3TxTrigger;
    rand uvm_reg_field clearsecU1ac2TxTrigger;
    rand uvm_reg_field clearsecU1ac1TxTrigger;
    rand uvm_reg_field clearsecU1ac0TxTrigger;

    //---build------------------------------------------------------------
    virtual function void build();
        clearsecU3ac3TxBufTrigger = uvm_reg_field::type_id::create("clearsecU3ac3TxBufTrigger");
        clearsecU3ac2TxBufTrigger = uvm_reg_field::type_id::create("clearsecU3ac2TxBufTrigger");
        clearsecU3ac1TxBufTrigger = uvm_reg_field::type_id::create("clearsecU3ac1TxBufTrigger");
        clearsecU3ac0TxBufTrigger = uvm_reg_field::type_id::create("clearsecU3ac0TxBufTrigger");
        clearsecU3ac3TxTrigger = uvm_reg_field::type_id::create("clearsecU3ac3TxTrigger");
        clearsecU3ac2TxTrigger = uvm_reg_field::type_id::create("clearsecU3ac2TxTrigger");
        clearsecU3ac1TxTrigger = uvm_reg_field::type_id::create("clearsecU3ac1TxTrigger");
        clearsecU3ac0TxTrigger = uvm_reg_field::type_id::create("clearsecU3ac0TxTrigger");
        clearsecU2ac3TxBufTrigger = uvm_reg_field::type_id::create("clearsecU2ac3TxBufTrigger");
        clearsecU2ac2TxBufTrigger = uvm_reg_field::type_id::create("clearsecU2ac2TxBufTrigger");
        clearsecU2ac1TxBufTrigger = uvm_reg_field::type_id::create("clearsecU2ac1TxBufTrigger");
        clearsecU2ac0TxBufTrigger = uvm_reg_field::type_id::create("clearsecU2ac0TxBufTrigger");
        clearsecU2ac3TxTrigger = uvm_reg_field::type_id::create("clearsecU2ac3TxTrigger");
        clearsecU2ac2TxTrigger = uvm_reg_field::type_id::create("clearsecU2ac2TxTrigger");
        clearsecU2ac1TxTrigger = uvm_reg_field::type_id::create("clearsecU2ac1TxTrigger");
        clearsecU2ac0TxTrigger = uvm_reg_field::type_id::create("clearsecU2ac0TxTrigger");
        clearsecU1ac3TxBufTrigger = uvm_reg_field::type_id::create("clearsecU1ac3TxBufTrigger");
        clearsecU1ac2TxBufTrigger = uvm_reg_field::type_id::create("clearsecU1ac2TxBufTrigger");
        clearsecU1ac1TxBufTrigger = uvm_reg_field::type_id::create("clearsecU1ac1TxBufTrigger");
        clearsecU1ac0TxBufTrigger = uvm_reg_field::type_id::create("clearsecU1ac0TxBufTrigger");
        clearsecU1ac3TxTrigger = uvm_reg_field::type_id::create("clearsecU1ac3TxTrigger");
        clearsecU1ac2TxTrigger = uvm_reg_field::type_id::create("clearsecU1ac2TxTrigger");
        clearsecU1ac1TxTrigger = uvm_reg_field::type_id::create("clearsecU1ac1TxTrigger");
        clearsecU1ac0TxTrigger = uvm_reg_field::type_id::create("clearsecU1ac0TxTrigger");

        clearsecU3ac3TxBufTrigger.configure(this, 1, 23, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU3ac2TxBufTrigger.configure(this, 1, 22, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU3ac1TxBufTrigger.configure(this, 1, 21, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU3ac0TxBufTrigger.configure(this, 1, 20, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU3ac3TxTrigger.configure(this, 1, 19, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU3ac2TxTrigger.configure(this, 1, 18, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU3ac1TxTrigger.configure(this, 1, 17, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU3ac0TxTrigger.configure(this, 1, 16, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU2ac3TxBufTrigger.configure(this, 1, 15, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU2ac2TxBufTrigger.configure(this, 1, 14, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU2ac1TxBufTrigger.configure(this, 1, 13, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU2ac0TxBufTrigger.configure(this, 1, 12, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU2ac3TxTrigger.configure(this, 1, 11, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU2ac2TxTrigger.configure(this, 1, 10, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU2ac1TxTrigger.configure(this, 1, 9, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU2ac0TxTrigger.configure(this, 1, 8, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU1ac3TxBufTrigger.configure(this, 1, 7, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU1ac2TxBufTrigger.configure(this, 1, 6, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU1ac1TxBufTrigger.configure(this, 1, 5, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU1ac0TxBufTrigger.configure(this, 1, 4, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU1ac3TxTrigger.configure(this, 1, 3, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU1ac2TxTrigger.configure(this, 1, 2, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU1ac1TxTrigger.configure(this, 1, 1, "W1C", 1, 'b0, 1, 1, 1);
        clearsecU1ac0TxTrigger.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_SECUSERSTXINTEVENTCLEARREG_wr_cg";
        clearsecU3ac3TxBufTrigger_wr : coverpoint clearsecU3ac3TxBufTrigger.value[0:0];
        clearsecU3ac2TxBufTrigger_wr : coverpoint clearsecU3ac2TxBufTrigger.value[0:0];
        clearsecU3ac1TxBufTrigger_wr : coverpoint clearsecU3ac1TxBufTrigger.value[0:0];
        clearsecU3ac0TxBufTrigger_wr : coverpoint clearsecU3ac0TxBufTrigger.value[0:0];
        clearsecU3ac3TxTrigger_wr : coverpoint clearsecU3ac3TxTrigger.value[0:0];
        clearsecU3ac2TxTrigger_wr : coverpoint clearsecU3ac2TxTrigger.value[0:0];
        clearsecU3ac1TxTrigger_wr : coverpoint clearsecU3ac1TxTrigger.value[0:0];
        clearsecU3ac0TxTrigger_wr : coverpoint clearsecU3ac0TxTrigger.value[0:0];
        clearsecU2ac3TxBufTrigger_wr : coverpoint clearsecU2ac3TxBufTrigger.value[0:0];
        clearsecU2ac2TxBufTrigger_wr : coverpoint clearsecU2ac2TxBufTrigger.value[0:0];
        clearsecU2ac1TxBufTrigger_wr : coverpoint clearsecU2ac1TxBufTrigger.value[0:0];
        clearsecU2ac0TxBufTrigger_wr : coverpoint clearsecU2ac0TxBufTrigger.value[0:0];
        clearsecU2ac3TxTrigger_wr : coverpoint clearsecU2ac3TxTrigger.value[0:0];
        clearsecU2ac2TxTrigger_wr : coverpoint clearsecU2ac2TxTrigger.value[0:0];
        clearsecU2ac1TxTrigger_wr : coverpoint clearsecU2ac1TxTrigger.value[0:0];
        clearsecU2ac0TxTrigger_wr : coverpoint clearsecU2ac0TxTrigger.value[0:0];
        clearsecU1ac3TxBufTrigger_wr : coverpoint clearsecU1ac3TxBufTrigger.value[0:0];
        clearsecU1ac2TxBufTrigger_wr : coverpoint clearsecU1ac2TxBufTrigger.value[0:0];
        clearsecU1ac1TxBufTrigger_wr : coverpoint clearsecU1ac1TxBufTrigger.value[0:0];
        clearsecU1ac0TxBufTrigger_wr : coverpoint clearsecU1ac0TxBufTrigger.value[0:0];
        clearsecU1ac3TxTrigger_wr : coverpoint clearsecU1ac3TxTrigger.value[0:0];
        clearsecU1ac2TxTrigger_wr : coverpoint clearsecU1ac2TxTrigger.value[0:0];
        clearsecU1ac1TxTrigger_wr : coverpoint clearsecU1ac1TxTrigger.value[0:0];
        clearsecU1ac0TxTrigger_wr : coverpoint clearsecU1ac0TxTrigger.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SECUSERSTXINTEVENTCLEARREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SECUSERSTXINTEVENTUNMASKREG
//--------------------------------------------------------------------
class SECUSERSTXINTEVENTUNMASKREG extends uvm_reg;
    `uvm_object_utils(SECUSERSTXINTEVENTUNMASKREG)
    rand uvm_reg_field masterSecUsersTxIntEn;
    rand uvm_reg_field masksecU3ac3TxBufTrigger;
    rand uvm_reg_field masksecU3ac2TxBufTrigger;
    rand uvm_reg_field masksecU3ac1TxBufTrigger;
    rand uvm_reg_field masksecU3ac0TxBufTrigger;
    rand uvm_reg_field masksecU3ac3TxTrigger;
    rand uvm_reg_field masksecU3ac2TxTrigger;
    rand uvm_reg_field masksecU3ac1TxTrigger;
    rand uvm_reg_field masksecU3ac0TxTrigger;
    rand uvm_reg_field masksecU2ac3TxBufTrigger;
    rand uvm_reg_field masksecU2ac2TxBufTrigger;
    rand uvm_reg_field masksecU2ac1TxBufTrigger;
    rand uvm_reg_field masksecU2ac0TxBufTrigger;
    rand uvm_reg_field masksecU2ac3TxTrigger;
    rand uvm_reg_field masksecU2ac2TxTrigger;
    rand uvm_reg_field masksecU2ac1TxTrigger;
    rand uvm_reg_field masksecU2ac0TxTrigger;
    rand uvm_reg_field masksecU1ac3TxBufTrigger;
    rand uvm_reg_field masksecU1ac2TxBufTrigger;
    rand uvm_reg_field masksecU1ac1TxBufTrigger;
    rand uvm_reg_field masksecU1ac0TxBufTrigger;
    rand uvm_reg_field masksecU1ac3TxTrigger;
    rand uvm_reg_field masksecU1ac2TxTrigger;
    rand uvm_reg_field masksecU1ac1TxTrigger;
    rand uvm_reg_field masksecU1ac0TxTrigger;

    //---build------------------------------------------------------------
    virtual function void build();
        masterSecUsersTxIntEn = uvm_reg_field::type_id::create("masterSecUsersTxIntEn");
        masksecU3ac3TxBufTrigger = uvm_reg_field::type_id::create("masksecU3ac3TxBufTrigger");
        masksecU3ac2TxBufTrigger = uvm_reg_field::type_id::create("masksecU3ac2TxBufTrigger");
        masksecU3ac1TxBufTrigger = uvm_reg_field::type_id::create("masksecU3ac1TxBufTrigger");
        masksecU3ac0TxBufTrigger = uvm_reg_field::type_id::create("masksecU3ac0TxBufTrigger");
        masksecU3ac3TxTrigger = uvm_reg_field::type_id::create("masksecU3ac3TxTrigger");
        masksecU3ac2TxTrigger = uvm_reg_field::type_id::create("masksecU3ac2TxTrigger");
        masksecU3ac1TxTrigger = uvm_reg_field::type_id::create("masksecU3ac1TxTrigger");
        masksecU3ac0TxTrigger = uvm_reg_field::type_id::create("masksecU3ac0TxTrigger");
        masksecU2ac3TxBufTrigger = uvm_reg_field::type_id::create("masksecU2ac3TxBufTrigger");
        masksecU2ac2TxBufTrigger = uvm_reg_field::type_id::create("masksecU2ac2TxBufTrigger");
        masksecU2ac1TxBufTrigger = uvm_reg_field::type_id::create("masksecU2ac1TxBufTrigger");
        masksecU2ac0TxBufTrigger = uvm_reg_field::type_id::create("masksecU2ac0TxBufTrigger");
        masksecU2ac3TxTrigger = uvm_reg_field::type_id::create("masksecU2ac3TxTrigger");
        masksecU2ac2TxTrigger = uvm_reg_field::type_id::create("masksecU2ac2TxTrigger");
        masksecU2ac1TxTrigger = uvm_reg_field::type_id::create("masksecU2ac1TxTrigger");
        masksecU2ac0TxTrigger = uvm_reg_field::type_id::create("masksecU2ac0TxTrigger");
        masksecU1ac3TxBufTrigger = uvm_reg_field::type_id::create("masksecU1ac3TxBufTrigger");
        masksecU1ac2TxBufTrigger = uvm_reg_field::type_id::create("masksecU1ac2TxBufTrigger");
        masksecU1ac1TxBufTrigger = uvm_reg_field::type_id::create("masksecU1ac1TxBufTrigger");
        masksecU1ac0TxBufTrigger = uvm_reg_field::type_id::create("masksecU1ac0TxBufTrigger");
        masksecU1ac3TxTrigger = uvm_reg_field::type_id::create("masksecU1ac3TxTrigger");
        masksecU1ac2TxTrigger = uvm_reg_field::type_id::create("masksecU1ac2TxTrigger");
        masksecU1ac1TxTrigger = uvm_reg_field::type_id::create("masksecU1ac1TxTrigger");
        masksecU1ac0TxTrigger = uvm_reg_field::type_id::create("masksecU1ac0TxTrigger");

        masterSecUsersTxIntEn.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        masksecU3ac3TxBufTrigger.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        masksecU3ac2TxBufTrigger.configure(this, 1, 22, "RW", 1, 'b0, 1, 1, 1);
        masksecU3ac1TxBufTrigger.configure(this, 1, 21, "RW", 1, 'b0, 1, 1, 1);
        masksecU3ac0TxBufTrigger.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        masksecU3ac3TxTrigger.configure(this, 1, 19, "RW", 1, 'b0, 1, 1, 1);
        masksecU3ac2TxTrigger.configure(this, 1, 18, "RW", 1, 'b0, 1, 1, 1);
        masksecU3ac1TxTrigger.configure(this, 1, 17, "RW", 1, 'b0, 1, 1, 1);
        masksecU3ac0TxTrigger.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        masksecU2ac3TxBufTrigger.configure(this, 1, 15, "RW", 1, 'b0, 1, 1, 1);
        masksecU2ac2TxBufTrigger.configure(this, 1, 14, "RW", 1, 'b0, 1, 1, 1);
        masksecU2ac1TxBufTrigger.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        masksecU2ac0TxBufTrigger.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        masksecU2ac3TxTrigger.configure(this, 1, 11, "RW", 1, 'b0, 1, 1, 1);
        masksecU2ac2TxTrigger.configure(this, 1, 10, "RW", 1, 'b0, 1, 1, 1);
        masksecU2ac1TxTrigger.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        masksecU2ac0TxTrigger.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        masksecU1ac3TxBufTrigger.configure(this, 1, 7, "RW", 1, 'b0, 1, 1, 1);
        masksecU1ac2TxBufTrigger.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        masksecU1ac1TxBufTrigger.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        masksecU1ac0TxBufTrigger.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        masksecU1ac3TxTrigger.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        masksecU1ac2TxTrigger.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        masksecU1ac1TxTrigger.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        masksecU1ac0TxTrigger.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_SECUSERSTXINTEVENTUNMASKREG_wr_cg";
        masterSecUsersTxIntEn_wr : coverpoint masterSecUsersTxIntEn.value[0:0];
        masksecU3ac3TxBufTrigger_wr : coverpoint masksecU3ac3TxBufTrigger.value[0:0];
        masksecU3ac2TxBufTrigger_wr : coverpoint masksecU3ac2TxBufTrigger.value[0:0];
        masksecU3ac1TxBufTrigger_wr : coverpoint masksecU3ac1TxBufTrigger.value[0:0];
        masksecU3ac0TxBufTrigger_wr : coverpoint masksecU3ac0TxBufTrigger.value[0:0];
        masksecU3ac3TxTrigger_wr : coverpoint masksecU3ac3TxTrigger.value[0:0];
        masksecU3ac2TxTrigger_wr : coverpoint masksecU3ac2TxTrigger.value[0:0];
        masksecU3ac1TxTrigger_wr : coverpoint masksecU3ac1TxTrigger.value[0:0];
        masksecU3ac0TxTrigger_wr : coverpoint masksecU3ac0TxTrigger.value[0:0];
        masksecU2ac3TxBufTrigger_wr : coverpoint masksecU2ac3TxBufTrigger.value[0:0];
        masksecU2ac2TxBufTrigger_wr : coverpoint masksecU2ac2TxBufTrigger.value[0:0];
        masksecU2ac1TxBufTrigger_wr : coverpoint masksecU2ac1TxBufTrigger.value[0:0];
        masksecU2ac0TxBufTrigger_wr : coverpoint masksecU2ac0TxBufTrigger.value[0:0];
        masksecU2ac3TxTrigger_wr : coverpoint masksecU2ac3TxTrigger.value[0:0];
        masksecU2ac2TxTrigger_wr : coverpoint masksecU2ac2TxTrigger.value[0:0];
        masksecU2ac1TxTrigger_wr : coverpoint masksecU2ac1TxTrigger.value[0:0];
        masksecU2ac0TxTrigger_wr : coverpoint masksecU2ac0TxTrigger.value[0:0];
        masksecU1ac3TxBufTrigger_wr : coverpoint masksecU1ac3TxBufTrigger.value[0:0];
        masksecU1ac2TxBufTrigger_wr : coverpoint masksecU1ac2TxBufTrigger.value[0:0];
        masksecU1ac1TxBufTrigger_wr : coverpoint masksecU1ac1TxBufTrigger.value[0:0];
        masksecU1ac0TxBufTrigger_wr : coverpoint masksecU1ac0TxBufTrigger.value[0:0];
        masksecU1ac3TxTrigger_wr : coverpoint masksecU1ac3TxTrigger.value[0:0];
        masksecU1ac2TxTrigger_wr : coverpoint masksecU1ac2TxTrigger.value[0:0];
        masksecU1ac1TxTrigger_wr : coverpoint masksecU1ac1TxTrigger.value[0:0];
        masksecU1ac0TxTrigger_wr : coverpoint masksecU1ac0TxTrigger.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_SECUSERSTXINTEVENTUNMASKREG_rd_cg";
        masterSecUsersTxIntEn_rd : coverpoint masterSecUsersTxIntEn.value[0:0];
        masksecU3ac3TxBufTrigger_rd : coverpoint masksecU3ac3TxBufTrigger.value[0:0];
        masksecU3ac2TxBufTrigger_rd : coverpoint masksecU3ac2TxBufTrigger.value[0:0];
        masksecU3ac1TxBufTrigger_rd : coverpoint masksecU3ac1TxBufTrigger.value[0:0];
        masksecU3ac0TxBufTrigger_rd : coverpoint masksecU3ac0TxBufTrigger.value[0:0];
        masksecU3ac3TxTrigger_rd : coverpoint masksecU3ac3TxTrigger.value[0:0];
        masksecU3ac2TxTrigger_rd : coverpoint masksecU3ac2TxTrigger.value[0:0];
        masksecU3ac1TxTrigger_rd : coverpoint masksecU3ac1TxTrigger.value[0:0];
        masksecU3ac0TxTrigger_rd : coverpoint masksecU3ac0TxTrigger.value[0:0];
        masksecU2ac3TxBufTrigger_rd : coverpoint masksecU2ac3TxBufTrigger.value[0:0];
        masksecU2ac2TxBufTrigger_rd : coverpoint masksecU2ac2TxBufTrigger.value[0:0];
        masksecU2ac1TxBufTrigger_rd : coverpoint masksecU2ac1TxBufTrigger.value[0:0];
        masksecU2ac0TxBufTrigger_rd : coverpoint masksecU2ac0TxBufTrigger.value[0:0];
        masksecU2ac3TxTrigger_rd : coverpoint masksecU2ac3TxTrigger.value[0:0];
        masksecU2ac2TxTrigger_rd : coverpoint masksecU2ac2TxTrigger.value[0:0];
        masksecU2ac1TxTrigger_rd : coverpoint masksecU2ac1TxTrigger.value[0:0];
        masksecU2ac0TxTrigger_rd : coverpoint masksecU2ac0TxTrigger.value[0:0];
        masksecU1ac3TxBufTrigger_rd : coverpoint masksecU1ac3TxBufTrigger.value[0:0];
        masksecU1ac2TxBufTrigger_rd : coverpoint masksecU1ac2TxBufTrigger.value[0:0];
        masksecU1ac1TxBufTrigger_rd : coverpoint masksecU1ac1TxBufTrigger.value[0:0];
        masksecU1ac0TxBufTrigger_rd : coverpoint masksecU1ac0TxBufTrigger.value[0:0];
        masksecU1ac3TxTrigger_rd : coverpoint masksecU1ac3TxTrigger.value[0:0];
        masksecU1ac2TxTrigger_rd : coverpoint masksecU1ac2TxTrigger.value[0:0];
        masksecU1ac1TxTrigger_rd : coverpoint masksecU1ac1TxTrigger.value[0:0];
        masksecU1ac0TxTrigger_rd : coverpoint masksecU1ac0TxTrigger.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SECUSERSTXINTEVENTUNMASKREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGBCNSPTRREG
//--------------------------------------------------------------------
class DEBUGBCNSPTRREG extends uvm_reg;
    `uvm_object_utils(DEBUGBCNSPTRREG)
    rand uvm_reg_field bcnStatusPointer;

    //---build------------------------------------------------------------
    virtual function void build();
        bcnStatusPointer = uvm_reg_field::type_id::create("bcnStatusPointer");

        bcnStatusPointer.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DEBUGBCNSPTRREG_rd_cg";
        bcnStatusPointer_rd : coverpoint bcnStatusPointer.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGBCNSPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGAC0SPTRREG
//--------------------------------------------------------------------
class DEBUGAC0SPTRREG extends uvm_reg;
    `uvm_object_utils(DEBUGAC0SPTRREG)
    rand uvm_reg_field ac0StatusPointer;

    //---build------------------------------------------------------------
    virtual function void build();
        ac0StatusPointer = uvm_reg_field::type_id::create("ac0StatusPointer");

        ac0StatusPointer.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DEBUGAC0SPTRREG_rd_cg";
        ac0StatusPointer_rd : coverpoint ac0StatusPointer.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGAC0SPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGAC1SPTRREG
//--------------------------------------------------------------------
class DEBUGAC1SPTRREG extends uvm_reg;
    `uvm_object_utils(DEBUGAC1SPTRREG)
    rand uvm_reg_field ac1StatusPointer;

    //---build------------------------------------------------------------
    virtual function void build();
        ac1StatusPointer = uvm_reg_field::type_id::create("ac1StatusPointer");

        ac1StatusPointer.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DEBUGAC1SPTRREG_rd_cg";
        ac1StatusPointer_rd : coverpoint ac1StatusPointer.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGAC1SPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGAC2SPTRREG
//--------------------------------------------------------------------
class DEBUGAC2SPTRREG extends uvm_reg;
    `uvm_object_utils(DEBUGAC2SPTRREG)
    rand uvm_reg_field ac2StatusPointer;

    //---build------------------------------------------------------------
    virtual function void build();
        ac2StatusPointer = uvm_reg_field::type_id::create("ac2StatusPointer");

        ac2StatusPointer.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DEBUGAC2SPTRREG_rd_cg";
        ac2StatusPointer_rd : coverpoint ac2StatusPointer.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGAC2SPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGAC3SPTRREG
//--------------------------------------------------------------------
class DEBUGAC3SPTRREG extends uvm_reg;
    `uvm_object_utils(DEBUGAC3SPTRREG)
    rand uvm_reg_field ac3StatusPointer;

    //---build------------------------------------------------------------
    virtual function void build();
        ac3StatusPointer = uvm_reg_field::type_id::create("ac3StatusPointer");

        ac3StatusPointer.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DEBUGAC3SPTRREG_rd_cg";
        ac3StatusPointer_rd : coverpoint ac3StatusPointer.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGAC3SPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGTBSPTRREG
//--------------------------------------------------------------------
class DEBUGTBSPTRREG extends uvm_reg;
    `uvm_object_utils(DEBUGTBSPTRREG)
    rand uvm_reg_field tbStatusPointer;

    //---build------------------------------------------------------------
    virtual function void build();
        tbStatusPointer = uvm_reg_field::type_id::create("tbStatusPointer");

        tbStatusPointer.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DEBUGTBSPTRREG_rd_cg";
        tbStatusPointer_rd : coverpoint tbStatusPointer.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGTBSPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGTXCPTRREG
//--------------------------------------------------------------------
class DEBUGTXCPTRREG extends uvm_reg;
    `uvm_object_utils(DEBUGTXCPTRREG)
    rand uvm_reg_field txCurrentPointer;

    //---build------------------------------------------------------------
    virtual function void build();
        txCurrentPointer = uvm_reg_field::type_id::create("txCurrentPointer");

        txCurrentPointer.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DEBUGTXCPTRREG_rd_cg";
        txCurrentPointer_rd : coverpoint txCurrentPointer.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGTXCPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SWPROFILINGREG
//--------------------------------------------------------------------
class SWPROFILINGREG extends uvm_reg;
    `uvm_object_utils(SWPROFILINGREG)
    rand uvm_reg_field swProf31;
    rand uvm_reg_field swProf30;
    rand uvm_reg_field swProf29;
    rand uvm_reg_field swProf28;
    rand uvm_reg_field swProf27;
    rand uvm_reg_field swProf26;
    rand uvm_reg_field swProf25;
    rand uvm_reg_field swProf24;
    rand uvm_reg_field swProf23;
    rand uvm_reg_field swProf22;
    rand uvm_reg_field swProf21;
    rand uvm_reg_field swProf20;
    rand uvm_reg_field swProf19;
    rand uvm_reg_field swProf18;
    rand uvm_reg_field swProf17;
    rand uvm_reg_field swProf16;
    rand uvm_reg_field swProf15;
    rand uvm_reg_field swProf14;
    rand uvm_reg_field swProf13;
    rand uvm_reg_field swProf12;
    rand uvm_reg_field swProf11;
    rand uvm_reg_field swProf10;
    rand uvm_reg_field swProf9;
    rand uvm_reg_field swProf8;
    rand uvm_reg_field swProf7;
    rand uvm_reg_field swProf6;
    rand uvm_reg_field swProf5;
    rand uvm_reg_field swProf4;
    rand uvm_reg_field swProf3;
    rand uvm_reg_field swProf2;
    rand uvm_reg_field swProf1;
    rand uvm_reg_field swProf0;

    //---build------------------------------------------------------------
    virtual function void build();
        swProf31 = uvm_reg_field::type_id::create("swProf31");
        swProf30 = uvm_reg_field::type_id::create("swProf30");
        swProf29 = uvm_reg_field::type_id::create("swProf29");
        swProf28 = uvm_reg_field::type_id::create("swProf28");
        swProf27 = uvm_reg_field::type_id::create("swProf27");
        swProf26 = uvm_reg_field::type_id::create("swProf26");
        swProf25 = uvm_reg_field::type_id::create("swProf25");
        swProf24 = uvm_reg_field::type_id::create("swProf24");
        swProf23 = uvm_reg_field::type_id::create("swProf23");
        swProf22 = uvm_reg_field::type_id::create("swProf22");
        swProf21 = uvm_reg_field::type_id::create("swProf21");
        swProf20 = uvm_reg_field::type_id::create("swProf20");
        swProf19 = uvm_reg_field::type_id::create("swProf19");
        swProf18 = uvm_reg_field::type_id::create("swProf18");
        swProf17 = uvm_reg_field::type_id::create("swProf17");
        swProf16 = uvm_reg_field::type_id::create("swProf16");
        swProf15 = uvm_reg_field::type_id::create("swProf15");
        swProf14 = uvm_reg_field::type_id::create("swProf14");
        swProf13 = uvm_reg_field::type_id::create("swProf13");
        swProf12 = uvm_reg_field::type_id::create("swProf12");
        swProf11 = uvm_reg_field::type_id::create("swProf11");
        swProf10 = uvm_reg_field::type_id::create("swProf10");
        swProf9 = uvm_reg_field::type_id::create("swProf9");
        swProf8 = uvm_reg_field::type_id::create("swProf8");
        swProf7 = uvm_reg_field::type_id::create("swProf7");
        swProf6 = uvm_reg_field::type_id::create("swProf6");
        swProf5 = uvm_reg_field::type_id::create("swProf5");
        swProf4 = uvm_reg_field::type_id::create("swProf4");
        swProf3 = uvm_reg_field::type_id::create("swProf3");
        swProf2 = uvm_reg_field::type_id::create("swProf2");
        swProf1 = uvm_reg_field::type_id::create("swProf1");
        swProf0 = uvm_reg_field::type_id::create("swProf0");

        swProf31.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        swProf30.configure(this, 1, 30, "RW", 1, 'b0, 1, 1, 1);
        swProf29.configure(this, 1, 29, "RW", 1, 'b0, 1, 1, 1);
        swProf28.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        swProf27.configure(this, 1, 27, "RW", 1, 'b0, 1, 1, 1);
        swProf26.configure(this, 1, 26, "RW", 1, 'b0, 1, 1, 1);
        swProf25.configure(this, 1, 25, "RW", 1, 'b0, 1, 1, 1);
        swProf24.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        swProf23.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        swProf22.configure(this, 1, 22, "RW", 1, 'b0, 1, 1, 1);
        swProf21.configure(this, 1, 21, "RW", 1, 'b0, 1, 1, 1);
        swProf20.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        swProf19.configure(this, 1, 19, "RW", 1, 'b0, 1, 1, 1);
        swProf18.configure(this, 1, 18, "RW", 1, 'b0, 1, 1, 1);
        swProf17.configure(this, 1, 17, "RW", 1, 'b0, 1, 1, 1);
        swProf16.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        swProf15.configure(this, 1, 15, "RW", 1, 'b0, 1, 1, 1);
        swProf14.configure(this, 1, 14, "RW", 1, 'b0, 1, 1, 1);
        swProf13.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        swProf12.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        swProf11.configure(this, 1, 11, "RW", 1, 'b0, 1, 1, 1);
        swProf10.configure(this, 1, 10, "RW", 1, 'b0, 1, 1, 1);
        swProf9.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        swProf8.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        swProf7.configure(this, 1, 7, "RW", 1, 'b0, 1, 1, 1);
        swProf6.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        swProf5.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        swProf4.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        swProf3.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        swProf2.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        swProf1.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        swProf0.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_SWPROFILINGREG_wr_cg";
        swProf31_wr : coverpoint swProf31.value[0:0];
        swProf30_wr : coverpoint swProf30.value[0:0];
        swProf29_wr : coverpoint swProf29.value[0:0];
        swProf28_wr : coverpoint swProf28.value[0:0];
        swProf27_wr : coverpoint swProf27.value[0:0];
        swProf26_wr : coverpoint swProf26.value[0:0];
        swProf25_wr : coverpoint swProf25.value[0:0];
        swProf24_wr : coverpoint swProf24.value[0:0];
        swProf23_wr : coverpoint swProf23.value[0:0];
        swProf22_wr : coverpoint swProf22.value[0:0];
        swProf21_wr : coverpoint swProf21.value[0:0];
        swProf20_wr : coverpoint swProf20.value[0:0];
        swProf19_wr : coverpoint swProf19.value[0:0];
        swProf18_wr : coverpoint swProf18.value[0:0];
        swProf17_wr : coverpoint swProf17.value[0:0];
        swProf16_wr : coverpoint swProf16.value[0:0];
        swProf15_wr : coverpoint swProf15.value[0:0];
        swProf14_wr : coverpoint swProf14.value[0:0];
        swProf13_wr : coverpoint swProf13.value[0:0];
        swProf12_wr : coverpoint swProf12.value[0:0];
        swProf11_wr : coverpoint swProf11.value[0:0];
        swProf10_wr : coverpoint swProf10.value[0:0];
        swProf9_wr : coverpoint swProf9.value[0:0];
        swProf8_wr : coverpoint swProf8.value[0:0];
        swProf7_wr : coverpoint swProf7.value[0:0];
        swProf6_wr : coverpoint swProf6.value[0:0];
        swProf5_wr : coverpoint swProf5.value[0:0];
        swProf4_wr : coverpoint swProf4.value[0:0];
        swProf3_wr : coverpoint swProf3.value[0:0];
        swProf2_wr : coverpoint swProf2.value[0:0];
        swProf1_wr : coverpoint swProf1.value[0:0];
        swProf0_wr : coverpoint swProf0.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_SWPROFILINGREG_rd_cg";
        swProf31_rd : coverpoint swProf31.value[0:0];
        swProf30_rd : coverpoint swProf30.value[0:0];
        swProf29_rd : coverpoint swProf29.value[0:0];
        swProf28_rd : coverpoint swProf28.value[0:0];
        swProf27_rd : coverpoint swProf27.value[0:0];
        swProf26_rd : coverpoint swProf26.value[0:0];
        swProf25_rd : coverpoint swProf25.value[0:0];
        swProf24_rd : coverpoint swProf24.value[0:0];
        swProf23_rd : coverpoint swProf23.value[0:0];
        swProf22_rd : coverpoint swProf22.value[0:0];
        swProf21_rd : coverpoint swProf21.value[0:0];
        swProf20_rd : coverpoint swProf20.value[0:0];
        swProf19_rd : coverpoint swProf19.value[0:0];
        swProf18_rd : coverpoint swProf18.value[0:0];
        swProf17_rd : coverpoint swProf17.value[0:0];
        swProf16_rd : coverpoint swProf16.value[0:0];
        swProf15_rd : coverpoint swProf15.value[0:0];
        swProf14_rd : coverpoint swProf14.value[0:0];
        swProf13_rd : coverpoint swProf13.value[0:0];
        swProf12_rd : coverpoint swProf12.value[0:0];
        swProf11_rd : coverpoint swProf11.value[0:0];
        swProf10_rd : coverpoint swProf10.value[0:0];
        swProf9_rd : coverpoint swProf9.value[0:0];
        swProf8_rd : coverpoint swProf8.value[0:0];
        swProf7_rd : coverpoint swProf7.value[0:0];
        swProf6_rd : coverpoint swProf6.value[0:0];
        swProf5_rd : coverpoint swProf5.value[0:0];
        swProf4_rd : coverpoint swProf4.value[0:0];
        swProf3_rd : coverpoint swProf3.value[0:0];
        swProf2_rd : coverpoint swProf2.value[0:0];
        swProf1_rd : coverpoint swProf1.value[0:0];
        swProf0_rd : coverpoint swProf0.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SWPROFILINGREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SWSETPROFILINGREG
//--------------------------------------------------------------------
class SWSETPROFILINGREG extends uvm_reg;
    `uvm_object_utils(SWSETPROFILINGREG)
    rand uvm_reg_field swSetProf31;
    rand uvm_reg_field swSetProf30;
    rand uvm_reg_field swSetProf29;
    rand uvm_reg_field swSetProf28;
    rand uvm_reg_field swSetProf27;
    rand uvm_reg_field swSetProf26;
    rand uvm_reg_field swSetProf25;
    rand uvm_reg_field swSetProf24;
    rand uvm_reg_field swSetProf23;
    rand uvm_reg_field swSetProf22;
    rand uvm_reg_field swSetProf21;
    rand uvm_reg_field swSetProf20;
    rand uvm_reg_field swSetProf19;
    rand uvm_reg_field swSetProf18;
    rand uvm_reg_field swSetProf17;
    rand uvm_reg_field swSetProf16;
    rand uvm_reg_field swSetProf15;
    rand uvm_reg_field swSetProf14;
    rand uvm_reg_field swSetProf13;
    rand uvm_reg_field swSetProf12;
    rand uvm_reg_field swSetProf11;
    rand uvm_reg_field swSetProf10;
    rand uvm_reg_field swSetProf9;
    rand uvm_reg_field swSetProf8;
    rand uvm_reg_field swSetProf7;
    rand uvm_reg_field swSetProf6;
    rand uvm_reg_field swSetProf5;
    rand uvm_reg_field swSetProf4;
    rand uvm_reg_field swSetProf3;
    rand uvm_reg_field swSetProf2;
    rand uvm_reg_field swSetProf1;
    rand uvm_reg_field swSetProf0;

    //---build------------------------------------------------------------
    virtual function void build();
        swSetProf31 = uvm_reg_field::type_id::create("swSetProf31");
        swSetProf30 = uvm_reg_field::type_id::create("swSetProf30");
        swSetProf29 = uvm_reg_field::type_id::create("swSetProf29");
        swSetProf28 = uvm_reg_field::type_id::create("swSetProf28");
        swSetProf27 = uvm_reg_field::type_id::create("swSetProf27");
        swSetProf26 = uvm_reg_field::type_id::create("swSetProf26");
        swSetProf25 = uvm_reg_field::type_id::create("swSetProf25");
        swSetProf24 = uvm_reg_field::type_id::create("swSetProf24");
        swSetProf23 = uvm_reg_field::type_id::create("swSetProf23");
        swSetProf22 = uvm_reg_field::type_id::create("swSetProf22");
        swSetProf21 = uvm_reg_field::type_id::create("swSetProf21");
        swSetProf20 = uvm_reg_field::type_id::create("swSetProf20");
        swSetProf19 = uvm_reg_field::type_id::create("swSetProf19");
        swSetProf18 = uvm_reg_field::type_id::create("swSetProf18");
        swSetProf17 = uvm_reg_field::type_id::create("swSetProf17");
        swSetProf16 = uvm_reg_field::type_id::create("swSetProf16");
        swSetProf15 = uvm_reg_field::type_id::create("swSetProf15");
        swSetProf14 = uvm_reg_field::type_id::create("swSetProf14");
        swSetProf13 = uvm_reg_field::type_id::create("swSetProf13");
        swSetProf12 = uvm_reg_field::type_id::create("swSetProf12");
        swSetProf11 = uvm_reg_field::type_id::create("swSetProf11");
        swSetProf10 = uvm_reg_field::type_id::create("swSetProf10");
        swSetProf9 = uvm_reg_field::type_id::create("swSetProf9");
        swSetProf8 = uvm_reg_field::type_id::create("swSetProf8");
        swSetProf7 = uvm_reg_field::type_id::create("swSetProf7");
        swSetProf6 = uvm_reg_field::type_id::create("swSetProf6");
        swSetProf5 = uvm_reg_field::type_id::create("swSetProf5");
        swSetProf4 = uvm_reg_field::type_id::create("swSetProf4");
        swSetProf3 = uvm_reg_field::type_id::create("swSetProf3");
        swSetProf2 = uvm_reg_field::type_id::create("swSetProf2");
        swSetProf1 = uvm_reg_field::type_id::create("swSetProf1");
        swSetProf0 = uvm_reg_field::type_id::create("swSetProf0");

        swSetProf31.configure(this, 1, 31, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf30.configure(this, 1, 30, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf29.configure(this, 1, 29, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf28.configure(this, 1, 28, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf27.configure(this, 1, 27, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf26.configure(this, 1, 26, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf25.configure(this, 1, 25, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf24.configure(this, 1, 24, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf23.configure(this, 1, 23, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf22.configure(this, 1, 22, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf21.configure(this, 1, 21, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf20.configure(this, 1, 20, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf19.configure(this, 1, 19, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf18.configure(this, 1, 18, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf17.configure(this, 1, 17, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf16.configure(this, 1, 16, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf15.configure(this, 1, 15, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf14.configure(this, 1, 14, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf13.configure(this, 1, 13, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf12.configure(this, 1, 12, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf11.configure(this, 1, 11, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf10.configure(this, 1, 10, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf9.configure(this, 1, 9, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf8.configure(this, 1, 8, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf7.configure(this, 1, 7, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf6.configure(this, 1, 6, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf5.configure(this, 1, 5, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf4.configure(this, 1, 4, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf3.configure(this, 1, 3, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf2.configure(this, 1, 2, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf1.configure(this, 1, 1, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf0.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_SWSETPROFILINGREG_wr_cg";
        swSetProf31_wr : coverpoint swSetProf31.value[0:0];
        swSetProf30_wr : coverpoint swSetProf30.value[0:0];
        swSetProf29_wr : coverpoint swSetProf29.value[0:0];
        swSetProf28_wr : coverpoint swSetProf28.value[0:0];
        swSetProf27_wr : coverpoint swSetProf27.value[0:0];
        swSetProf26_wr : coverpoint swSetProf26.value[0:0];
        swSetProf25_wr : coverpoint swSetProf25.value[0:0];
        swSetProf24_wr : coverpoint swSetProf24.value[0:0];
        swSetProf23_wr : coverpoint swSetProf23.value[0:0];
        swSetProf22_wr : coverpoint swSetProf22.value[0:0];
        swSetProf21_wr : coverpoint swSetProf21.value[0:0];
        swSetProf20_wr : coverpoint swSetProf20.value[0:0];
        swSetProf19_wr : coverpoint swSetProf19.value[0:0];
        swSetProf18_wr : coverpoint swSetProf18.value[0:0];
        swSetProf17_wr : coverpoint swSetProf17.value[0:0];
        swSetProf16_wr : coverpoint swSetProf16.value[0:0];
        swSetProf15_wr : coverpoint swSetProf15.value[0:0];
        swSetProf14_wr : coverpoint swSetProf14.value[0:0];
        swSetProf13_wr : coverpoint swSetProf13.value[0:0];
        swSetProf12_wr : coverpoint swSetProf12.value[0:0];
        swSetProf11_wr : coverpoint swSetProf11.value[0:0];
        swSetProf10_wr : coverpoint swSetProf10.value[0:0];
        swSetProf9_wr : coverpoint swSetProf9.value[0:0];
        swSetProf8_wr : coverpoint swSetProf8.value[0:0];
        swSetProf7_wr : coverpoint swSetProf7.value[0:0];
        swSetProf6_wr : coverpoint swSetProf6.value[0:0];
        swSetProf5_wr : coverpoint swSetProf5.value[0:0];
        swSetProf4_wr : coverpoint swSetProf4.value[0:0];
        swSetProf3_wr : coverpoint swSetProf3.value[0:0];
        swSetProf2_wr : coverpoint swSetProf2.value[0:0];
        swSetProf1_wr : coverpoint swSetProf1.value[0:0];
        swSetProf0_wr : coverpoint swSetProf0.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SWSETPROFILINGREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SWCLEARPROFILINGREG
//--------------------------------------------------------------------
class SWCLEARPROFILINGREG extends uvm_reg;
    `uvm_object_utils(SWCLEARPROFILINGREG)
    rand uvm_reg_field swClearProf31;
    rand uvm_reg_field swClearProf30;
    rand uvm_reg_field swClearProf29;
    rand uvm_reg_field swClearProf28;
    rand uvm_reg_field swClearProf27;
    rand uvm_reg_field swClearProf26;
    rand uvm_reg_field swClearProf25;
    rand uvm_reg_field swClearProf24;
    rand uvm_reg_field swClearProf23;
    rand uvm_reg_field swClearProf22;
    rand uvm_reg_field swClearProf21;
    rand uvm_reg_field swClearProf20;
    rand uvm_reg_field swClearProf19;
    rand uvm_reg_field swClearProf18;
    rand uvm_reg_field swClearProf17;
    rand uvm_reg_field swClearProf16;
    rand uvm_reg_field swClearProf15;
    rand uvm_reg_field swClearProf14;
    rand uvm_reg_field swClearProf13;
    rand uvm_reg_field swClearProf12;
    rand uvm_reg_field swClearProf11;
    rand uvm_reg_field swClearProf10;
    rand uvm_reg_field swClearProf9;
    rand uvm_reg_field swClearProf8;
    rand uvm_reg_field swClearProf7;
    rand uvm_reg_field swClearProf6;
    rand uvm_reg_field swClearProf5;
    rand uvm_reg_field swClearProf4;
    rand uvm_reg_field swClearProf3;
    rand uvm_reg_field swClearProf2;
    rand uvm_reg_field swClearProf1;
    rand uvm_reg_field swClearProf0;

    //---build------------------------------------------------------------
    virtual function void build();
        swClearProf31 = uvm_reg_field::type_id::create("swClearProf31");
        swClearProf30 = uvm_reg_field::type_id::create("swClearProf30");
        swClearProf29 = uvm_reg_field::type_id::create("swClearProf29");
        swClearProf28 = uvm_reg_field::type_id::create("swClearProf28");
        swClearProf27 = uvm_reg_field::type_id::create("swClearProf27");
        swClearProf26 = uvm_reg_field::type_id::create("swClearProf26");
        swClearProf25 = uvm_reg_field::type_id::create("swClearProf25");
        swClearProf24 = uvm_reg_field::type_id::create("swClearProf24");
        swClearProf23 = uvm_reg_field::type_id::create("swClearProf23");
        swClearProf22 = uvm_reg_field::type_id::create("swClearProf22");
        swClearProf21 = uvm_reg_field::type_id::create("swClearProf21");
        swClearProf20 = uvm_reg_field::type_id::create("swClearProf20");
        swClearProf19 = uvm_reg_field::type_id::create("swClearProf19");
        swClearProf18 = uvm_reg_field::type_id::create("swClearProf18");
        swClearProf17 = uvm_reg_field::type_id::create("swClearProf17");
        swClearProf16 = uvm_reg_field::type_id::create("swClearProf16");
        swClearProf15 = uvm_reg_field::type_id::create("swClearProf15");
        swClearProf14 = uvm_reg_field::type_id::create("swClearProf14");
        swClearProf13 = uvm_reg_field::type_id::create("swClearProf13");
        swClearProf12 = uvm_reg_field::type_id::create("swClearProf12");
        swClearProf11 = uvm_reg_field::type_id::create("swClearProf11");
        swClearProf10 = uvm_reg_field::type_id::create("swClearProf10");
        swClearProf9 = uvm_reg_field::type_id::create("swClearProf9");
        swClearProf8 = uvm_reg_field::type_id::create("swClearProf8");
        swClearProf7 = uvm_reg_field::type_id::create("swClearProf7");
        swClearProf6 = uvm_reg_field::type_id::create("swClearProf6");
        swClearProf5 = uvm_reg_field::type_id::create("swClearProf5");
        swClearProf4 = uvm_reg_field::type_id::create("swClearProf4");
        swClearProf3 = uvm_reg_field::type_id::create("swClearProf3");
        swClearProf2 = uvm_reg_field::type_id::create("swClearProf2");
        swClearProf1 = uvm_reg_field::type_id::create("swClearProf1");
        swClearProf0 = uvm_reg_field::type_id::create("swClearProf0");

        swClearProf31.configure(this, 1, 31, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf30.configure(this, 1, 30, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf29.configure(this, 1, 29, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf28.configure(this, 1, 28, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf27.configure(this, 1, 27, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf26.configure(this, 1, 26, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf25.configure(this, 1, 25, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf24.configure(this, 1, 24, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf23.configure(this, 1, 23, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf22.configure(this, 1, 22, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf21.configure(this, 1, 21, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf20.configure(this, 1, 20, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf19.configure(this, 1, 19, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf18.configure(this, 1, 18, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf17.configure(this, 1, 17, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf16.configure(this, 1, 16, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf15.configure(this, 1, 15, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf14.configure(this, 1, 14, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf13.configure(this, 1, 13, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf12.configure(this, 1, 12, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf11.configure(this, 1, 11, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf10.configure(this, 1, 10, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf9.configure(this, 1, 9, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf8.configure(this, 1, 8, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf7.configure(this, 1, 7, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf6.configure(this, 1, 6, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf5.configure(this, 1, 5, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf4.configure(this, 1, 4, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf3.configure(this, 1, 3, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf2.configure(this, 1, 2, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf1.configure(this, 1, 1, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf0.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_SWCLEARPROFILINGREG_wr_cg";
        swClearProf31_wr : coverpoint swClearProf31.value[0:0];
        swClearProf30_wr : coverpoint swClearProf30.value[0:0];
        swClearProf29_wr : coverpoint swClearProf29.value[0:0];
        swClearProf28_wr : coverpoint swClearProf28.value[0:0];
        swClearProf27_wr : coverpoint swClearProf27.value[0:0];
        swClearProf26_wr : coverpoint swClearProf26.value[0:0];
        swClearProf25_wr : coverpoint swClearProf25.value[0:0];
        swClearProf24_wr : coverpoint swClearProf24.value[0:0];
        swClearProf23_wr : coverpoint swClearProf23.value[0:0];
        swClearProf22_wr : coverpoint swClearProf22.value[0:0];
        swClearProf21_wr : coverpoint swClearProf21.value[0:0];
        swClearProf20_wr : coverpoint swClearProf20.value[0:0];
        swClearProf19_wr : coverpoint swClearProf19.value[0:0];
        swClearProf18_wr : coverpoint swClearProf18.value[0:0];
        swClearProf17_wr : coverpoint swClearProf17.value[0:0];
        swClearProf16_wr : coverpoint swClearProf16.value[0:0];
        swClearProf15_wr : coverpoint swClearProf15.value[0:0];
        swClearProf14_wr : coverpoint swClearProf14.value[0:0];
        swClearProf13_wr : coverpoint swClearProf13.value[0:0];
        swClearProf12_wr : coverpoint swClearProf12.value[0:0];
        swClearProf11_wr : coverpoint swClearProf11.value[0:0];
        swClearProf10_wr : coverpoint swClearProf10.value[0:0];
        swClearProf9_wr : coverpoint swClearProf9.value[0:0];
        swClearProf8_wr : coverpoint swClearProf8.value[0:0];
        swClearProf7_wr : coverpoint swClearProf7.value[0:0];
        swClearProf6_wr : coverpoint swClearProf6.value[0:0];
        swClearProf5_wr : coverpoint swClearProf5.value[0:0];
        swClearProf4_wr : coverpoint swClearProf4.value[0:0];
        swClearProf3_wr : coverpoint swClearProf3.value[0:0];
        swClearProf2_wr : coverpoint swClearProf2.value[0:0];
        swClearProf1_wr : coverpoint swClearProf1.value[0:0];
        swClearProf0_wr : coverpoint swClearProf0.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SWCLEARPROFILINGREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SWPROFILINGREG2
//--------------------------------------------------------------------
class SWPROFILINGREG2 extends uvm_reg;
    `uvm_object_utils(SWPROFILINGREG2)
    rand uvm_reg_field swProf63;
    rand uvm_reg_field swProf62;
    rand uvm_reg_field swProf61;
    rand uvm_reg_field swProf60;
    rand uvm_reg_field swProf59;
    rand uvm_reg_field swProf58;
    rand uvm_reg_field swProf57;
    rand uvm_reg_field swProf56;
    rand uvm_reg_field swProf55;
    rand uvm_reg_field swProf54;
    rand uvm_reg_field swProf53;
    rand uvm_reg_field swProf52;
    rand uvm_reg_field swProf51;
    rand uvm_reg_field swProf50;
    rand uvm_reg_field swProf49;
    rand uvm_reg_field swProf48;
    rand uvm_reg_field swProf47;
    rand uvm_reg_field swProf46;
    rand uvm_reg_field swProf45;
    rand uvm_reg_field swProf44;
    rand uvm_reg_field swProf43;
    rand uvm_reg_field swProf42;
    rand uvm_reg_field swProf41;
    rand uvm_reg_field swProf40;
    rand uvm_reg_field swProf39;
    rand uvm_reg_field swProf38;
    rand uvm_reg_field swProf37;
    rand uvm_reg_field swProf36;
    rand uvm_reg_field swProf35;
    rand uvm_reg_field swProf34;
    rand uvm_reg_field swProf33;
    rand uvm_reg_field swProf32;

    //---build------------------------------------------------------------
    virtual function void build();
        swProf63 = uvm_reg_field::type_id::create("swProf63");
        swProf62 = uvm_reg_field::type_id::create("swProf62");
        swProf61 = uvm_reg_field::type_id::create("swProf61");
        swProf60 = uvm_reg_field::type_id::create("swProf60");
        swProf59 = uvm_reg_field::type_id::create("swProf59");
        swProf58 = uvm_reg_field::type_id::create("swProf58");
        swProf57 = uvm_reg_field::type_id::create("swProf57");
        swProf56 = uvm_reg_field::type_id::create("swProf56");
        swProf55 = uvm_reg_field::type_id::create("swProf55");
        swProf54 = uvm_reg_field::type_id::create("swProf54");
        swProf53 = uvm_reg_field::type_id::create("swProf53");
        swProf52 = uvm_reg_field::type_id::create("swProf52");
        swProf51 = uvm_reg_field::type_id::create("swProf51");
        swProf50 = uvm_reg_field::type_id::create("swProf50");
        swProf49 = uvm_reg_field::type_id::create("swProf49");
        swProf48 = uvm_reg_field::type_id::create("swProf48");
        swProf47 = uvm_reg_field::type_id::create("swProf47");
        swProf46 = uvm_reg_field::type_id::create("swProf46");
        swProf45 = uvm_reg_field::type_id::create("swProf45");
        swProf44 = uvm_reg_field::type_id::create("swProf44");
        swProf43 = uvm_reg_field::type_id::create("swProf43");
        swProf42 = uvm_reg_field::type_id::create("swProf42");
        swProf41 = uvm_reg_field::type_id::create("swProf41");
        swProf40 = uvm_reg_field::type_id::create("swProf40");
        swProf39 = uvm_reg_field::type_id::create("swProf39");
        swProf38 = uvm_reg_field::type_id::create("swProf38");
        swProf37 = uvm_reg_field::type_id::create("swProf37");
        swProf36 = uvm_reg_field::type_id::create("swProf36");
        swProf35 = uvm_reg_field::type_id::create("swProf35");
        swProf34 = uvm_reg_field::type_id::create("swProf34");
        swProf33 = uvm_reg_field::type_id::create("swProf33");
        swProf32 = uvm_reg_field::type_id::create("swProf32");

        swProf63.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        swProf62.configure(this, 1, 30, "RW", 1, 'b0, 1, 1, 1);
        swProf61.configure(this, 1, 29, "RW", 1, 'b0, 1, 1, 1);
        swProf60.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        swProf59.configure(this, 1, 27, "RW", 1, 'b0, 1, 1, 1);
        swProf58.configure(this, 1, 26, "RW", 1, 'b0, 1, 1, 1);
        swProf57.configure(this, 1, 25, "RW", 1, 'b0, 1, 1, 1);
        swProf56.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        swProf55.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        swProf54.configure(this, 1, 22, "RW", 1, 'b0, 1, 1, 1);
        swProf53.configure(this, 1, 21, "RW", 1, 'b0, 1, 1, 1);
        swProf52.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        swProf51.configure(this, 1, 19, "RW", 1, 'b0, 1, 1, 1);
        swProf50.configure(this, 1, 18, "RW", 1, 'b0, 1, 1, 1);
        swProf49.configure(this, 1, 17, "RW", 1, 'b0, 1, 1, 1);
        swProf48.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        swProf47.configure(this, 1, 15, "RW", 1, 'b0, 1, 1, 1);
        swProf46.configure(this, 1, 14, "RW", 1, 'b0, 1, 1, 1);
        swProf45.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        swProf44.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        swProf43.configure(this, 1, 11, "RW", 1, 'b0, 1, 1, 1);
        swProf42.configure(this, 1, 10, "RW", 1, 'b0, 1, 1, 1);
        swProf41.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        swProf40.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        swProf39.configure(this, 1, 7, "RW", 1, 'b0, 1, 1, 1);
        swProf38.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        swProf37.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        swProf36.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        swProf35.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        swProf34.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        swProf33.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        swProf32.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_SWPROFILINGREG2_wr_cg";
        swProf63_wr : coverpoint swProf63.value[0:0];
        swProf62_wr : coverpoint swProf62.value[0:0];
        swProf61_wr : coverpoint swProf61.value[0:0];
        swProf60_wr : coverpoint swProf60.value[0:0];
        swProf59_wr : coverpoint swProf59.value[0:0];
        swProf58_wr : coverpoint swProf58.value[0:0];
        swProf57_wr : coverpoint swProf57.value[0:0];
        swProf56_wr : coverpoint swProf56.value[0:0];
        swProf55_wr : coverpoint swProf55.value[0:0];
        swProf54_wr : coverpoint swProf54.value[0:0];
        swProf53_wr : coverpoint swProf53.value[0:0];
        swProf52_wr : coverpoint swProf52.value[0:0];
        swProf51_wr : coverpoint swProf51.value[0:0];
        swProf50_wr : coverpoint swProf50.value[0:0];
        swProf49_wr : coverpoint swProf49.value[0:0];
        swProf48_wr : coverpoint swProf48.value[0:0];
        swProf47_wr : coverpoint swProf47.value[0:0];
        swProf46_wr : coverpoint swProf46.value[0:0];
        swProf45_wr : coverpoint swProf45.value[0:0];
        swProf44_wr : coverpoint swProf44.value[0:0];
        swProf43_wr : coverpoint swProf43.value[0:0];
        swProf42_wr : coverpoint swProf42.value[0:0];
        swProf41_wr : coverpoint swProf41.value[0:0];
        swProf40_wr : coverpoint swProf40.value[0:0];
        swProf39_wr : coverpoint swProf39.value[0:0];
        swProf38_wr : coverpoint swProf38.value[0:0];
        swProf37_wr : coverpoint swProf37.value[0:0];
        swProf36_wr : coverpoint swProf36.value[0:0];
        swProf35_wr : coverpoint swProf35.value[0:0];
        swProf34_wr : coverpoint swProf34.value[0:0];
        swProf33_wr : coverpoint swProf33.value[0:0];
        swProf32_wr : coverpoint swProf32.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_SWPROFILINGREG2_rd_cg";
        swProf63_rd : coverpoint swProf63.value[0:0];
        swProf62_rd : coverpoint swProf62.value[0:0];
        swProf61_rd : coverpoint swProf61.value[0:0];
        swProf60_rd : coverpoint swProf60.value[0:0];
        swProf59_rd : coverpoint swProf59.value[0:0];
        swProf58_rd : coverpoint swProf58.value[0:0];
        swProf57_rd : coverpoint swProf57.value[0:0];
        swProf56_rd : coverpoint swProf56.value[0:0];
        swProf55_rd : coverpoint swProf55.value[0:0];
        swProf54_rd : coverpoint swProf54.value[0:0];
        swProf53_rd : coverpoint swProf53.value[0:0];
        swProf52_rd : coverpoint swProf52.value[0:0];
        swProf51_rd : coverpoint swProf51.value[0:0];
        swProf50_rd : coverpoint swProf50.value[0:0];
        swProf49_rd : coverpoint swProf49.value[0:0];
        swProf48_rd : coverpoint swProf48.value[0:0];
        swProf47_rd : coverpoint swProf47.value[0:0];
        swProf46_rd : coverpoint swProf46.value[0:0];
        swProf45_rd : coverpoint swProf45.value[0:0];
        swProf44_rd : coverpoint swProf44.value[0:0];
        swProf43_rd : coverpoint swProf43.value[0:0];
        swProf42_rd : coverpoint swProf42.value[0:0];
        swProf41_rd : coverpoint swProf41.value[0:0];
        swProf40_rd : coverpoint swProf40.value[0:0];
        swProf39_rd : coverpoint swProf39.value[0:0];
        swProf38_rd : coverpoint swProf38.value[0:0];
        swProf37_rd : coverpoint swProf37.value[0:0];
        swProf36_rd : coverpoint swProf36.value[0:0];
        swProf35_rd : coverpoint swProf35.value[0:0];
        swProf34_rd : coverpoint swProf34.value[0:0];
        swProf33_rd : coverpoint swProf33.value[0:0];
        swProf32_rd : coverpoint swProf32.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SWPROFILINGREG2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SWSETPROFILINGREG2
//--------------------------------------------------------------------
class SWSETPROFILINGREG2 extends uvm_reg;
    `uvm_object_utils(SWSETPROFILINGREG2)
    rand uvm_reg_field swSetProf63;
    rand uvm_reg_field swSetProf62;
    rand uvm_reg_field swSetProf61;
    rand uvm_reg_field swSetProf60;
    rand uvm_reg_field swSetProf59;
    rand uvm_reg_field swSetProf58;
    rand uvm_reg_field swSetProf57;
    rand uvm_reg_field swSetProf56;
    rand uvm_reg_field swSetProf55;
    rand uvm_reg_field swSetProf54;
    rand uvm_reg_field swSetProf53;
    rand uvm_reg_field swSetProf52;
    rand uvm_reg_field swSetProf51;
    rand uvm_reg_field swSetProf50;
    rand uvm_reg_field swSetProf49;
    rand uvm_reg_field swSetProf48;
    rand uvm_reg_field swSetProf47;
    rand uvm_reg_field swSetProf46;
    rand uvm_reg_field swSetProf45;
    rand uvm_reg_field swSetProf44;
    rand uvm_reg_field swSetProf43;
    rand uvm_reg_field swSetProf42;
    rand uvm_reg_field swSetProf41;
    rand uvm_reg_field swSetProf40;
    rand uvm_reg_field swSetProf39;
    rand uvm_reg_field swSetProf38;
    rand uvm_reg_field swSetProf37;
    rand uvm_reg_field swSetProf36;
    rand uvm_reg_field swSetProf35;
    rand uvm_reg_field swSetProf34;
    rand uvm_reg_field swSetProf33;
    rand uvm_reg_field swSetProf32;

    //---build------------------------------------------------------------
    virtual function void build();
        swSetProf63 = uvm_reg_field::type_id::create("swSetProf63");
        swSetProf62 = uvm_reg_field::type_id::create("swSetProf62");
        swSetProf61 = uvm_reg_field::type_id::create("swSetProf61");
        swSetProf60 = uvm_reg_field::type_id::create("swSetProf60");
        swSetProf59 = uvm_reg_field::type_id::create("swSetProf59");
        swSetProf58 = uvm_reg_field::type_id::create("swSetProf58");
        swSetProf57 = uvm_reg_field::type_id::create("swSetProf57");
        swSetProf56 = uvm_reg_field::type_id::create("swSetProf56");
        swSetProf55 = uvm_reg_field::type_id::create("swSetProf55");
        swSetProf54 = uvm_reg_field::type_id::create("swSetProf54");
        swSetProf53 = uvm_reg_field::type_id::create("swSetProf53");
        swSetProf52 = uvm_reg_field::type_id::create("swSetProf52");
        swSetProf51 = uvm_reg_field::type_id::create("swSetProf51");
        swSetProf50 = uvm_reg_field::type_id::create("swSetProf50");
        swSetProf49 = uvm_reg_field::type_id::create("swSetProf49");
        swSetProf48 = uvm_reg_field::type_id::create("swSetProf48");
        swSetProf47 = uvm_reg_field::type_id::create("swSetProf47");
        swSetProf46 = uvm_reg_field::type_id::create("swSetProf46");
        swSetProf45 = uvm_reg_field::type_id::create("swSetProf45");
        swSetProf44 = uvm_reg_field::type_id::create("swSetProf44");
        swSetProf43 = uvm_reg_field::type_id::create("swSetProf43");
        swSetProf42 = uvm_reg_field::type_id::create("swSetProf42");
        swSetProf41 = uvm_reg_field::type_id::create("swSetProf41");
        swSetProf40 = uvm_reg_field::type_id::create("swSetProf40");
        swSetProf39 = uvm_reg_field::type_id::create("swSetProf39");
        swSetProf38 = uvm_reg_field::type_id::create("swSetProf38");
        swSetProf37 = uvm_reg_field::type_id::create("swSetProf37");
        swSetProf36 = uvm_reg_field::type_id::create("swSetProf36");
        swSetProf35 = uvm_reg_field::type_id::create("swSetProf35");
        swSetProf34 = uvm_reg_field::type_id::create("swSetProf34");
        swSetProf33 = uvm_reg_field::type_id::create("swSetProf33");
        swSetProf32 = uvm_reg_field::type_id::create("swSetProf32");

        swSetProf63.configure(this, 1, 31, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf62.configure(this, 1, 30, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf61.configure(this, 1, 29, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf60.configure(this, 1, 28, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf59.configure(this, 1, 27, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf58.configure(this, 1, 26, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf57.configure(this, 1, 25, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf56.configure(this, 1, 24, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf55.configure(this, 1, 23, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf54.configure(this, 1, 22, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf53.configure(this, 1, 21, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf52.configure(this, 1, 20, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf51.configure(this, 1, 19, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf50.configure(this, 1, 18, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf49.configure(this, 1, 17, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf48.configure(this, 1, 16, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf47.configure(this, 1, 15, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf46.configure(this, 1, 14, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf45.configure(this, 1, 13, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf44.configure(this, 1, 12, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf43.configure(this, 1, 11, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf42.configure(this, 1, 10, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf41.configure(this, 1, 9, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf40.configure(this, 1, 8, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf39.configure(this, 1, 7, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf38.configure(this, 1, 6, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf37.configure(this, 1, 5, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf36.configure(this, 1, 4, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf35.configure(this, 1, 3, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf34.configure(this, 1, 2, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf33.configure(this, 1, 1, "W1S", 1, 'b0, 1, 1, 1);
        swSetProf32.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_SWSETPROFILINGREG2_wr_cg";
        swSetProf63_wr : coverpoint swSetProf63.value[0:0];
        swSetProf62_wr : coverpoint swSetProf62.value[0:0];
        swSetProf61_wr : coverpoint swSetProf61.value[0:0];
        swSetProf60_wr : coverpoint swSetProf60.value[0:0];
        swSetProf59_wr : coverpoint swSetProf59.value[0:0];
        swSetProf58_wr : coverpoint swSetProf58.value[0:0];
        swSetProf57_wr : coverpoint swSetProf57.value[0:0];
        swSetProf56_wr : coverpoint swSetProf56.value[0:0];
        swSetProf55_wr : coverpoint swSetProf55.value[0:0];
        swSetProf54_wr : coverpoint swSetProf54.value[0:0];
        swSetProf53_wr : coverpoint swSetProf53.value[0:0];
        swSetProf52_wr : coverpoint swSetProf52.value[0:0];
        swSetProf51_wr : coverpoint swSetProf51.value[0:0];
        swSetProf50_wr : coverpoint swSetProf50.value[0:0];
        swSetProf49_wr : coverpoint swSetProf49.value[0:0];
        swSetProf48_wr : coverpoint swSetProf48.value[0:0];
        swSetProf47_wr : coverpoint swSetProf47.value[0:0];
        swSetProf46_wr : coverpoint swSetProf46.value[0:0];
        swSetProf45_wr : coverpoint swSetProf45.value[0:0];
        swSetProf44_wr : coverpoint swSetProf44.value[0:0];
        swSetProf43_wr : coverpoint swSetProf43.value[0:0];
        swSetProf42_wr : coverpoint swSetProf42.value[0:0];
        swSetProf41_wr : coverpoint swSetProf41.value[0:0];
        swSetProf40_wr : coverpoint swSetProf40.value[0:0];
        swSetProf39_wr : coverpoint swSetProf39.value[0:0];
        swSetProf38_wr : coverpoint swSetProf38.value[0:0];
        swSetProf37_wr : coverpoint swSetProf37.value[0:0];
        swSetProf36_wr : coverpoint swSetProf36.value[0:0];
        swSetProf35_wr : coverpoint swSetProf35.value[0:0];
        swSetProf34_wr : coverpoint swSetProf34.value[0:0];
        swSetProf33_wr : coverpoint swSetProf33.value[0:0];
        swSetProf32_wr : coverpoint swSetProf32.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SWSETPROFILINGREG2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SWCLEARPROFILINGREG2
//--------------------------------------------------------------------
class SWCLEARPROFILINGREG2 extends uvm_reg;
    `uvm_object_utils(SWCLEARPROFILINGREG2)
    rand uvm_reg_field swClearProf63;
    rand uvm_reg_field swClearProf62;
    rand uvm_reg_field swClearProf61;
    rand uvm_reg_field swClearProf60;
    rand uvm_reg_field swClearProf59;
    rand uvm_reg_field swClearProf58;
    rand uvm_reg_field swClearProf57;
    rand uvm_reg_field swClearProf56;
    rand uvm_reg_field swClearProf55;
    rand uvm_reg_field swClearProf54;
    rand uvm_reg_field swClearProf53;
    rand uvm_reg_field swClearProf52;
    rand uvm_reg_field swClearProf51;
    rand uvm_reg_field swClearProf50;
    rand uvm_reg_field swClearProf49;
    rand uvm_reg_field swClearProf48;
    rand uvm_reg_field swClearProf47;
    rand uvm_reg_field swClearProf46;
    rand uvm_reg_field swClearProf45;
    rand uvm_reg_field swClearProf44;
    rand uvm_reg_field swClearProf43;
    rand uvm_reg_field swClearProf42;
    rand uvm_reg_field swClearProf41;
    rand uvm_reg_field swClearProf40;
    rand uvm_reg_field swClearProf39;
    rand uvm_reg_field swClearProf38;
    rand uvm_reg_field swClearProf37;
    rand uvm_reg_field swClearProf36;
    rand uvm_reg_field swClearProf35;
    rand uvm_reg_field swClearProf34;
    rand uvm_reg_field swClearProf33;
    rand uvm_reg_field swClearProf32;

    //---build------------------------------------------------------------
    virtual function void build();
        swClearProf63 = uvm_reg_field::type_id::create("swClearProf63");
        swClearProf62 = uvm_reg_field::type_id::create("swClearProf62");
        swClearProf61 = uvm_reg_field::type_id::create("swClearProf61");
        swClearProf60 = uvm_reg_field::type_id::create("swClearProf60");
        swClearProf59 = uvm_reg_field::type_id::create("swClearProf59");
        swClearProf58 = uvm_reg_field::type_id::create("swClearProf58");
        swClearProf57 = uvm_reg_field::type_id::create("swClearProf57");
        swClearProf56 = uvm_reg_field::type_id::create("swClearProf56");
        swClearProf55 = uvm_reg_field::type_id::create("swClearProf55");
        swClearProf54 = uvm_reg_field::type_id::create("swClearProf54");
        swClearProf53 = uvm_reg_field::type_id::create("swClearProf53");
        swClearProf52 = uvm_reg_field::type_id::create("swClearProf52");
        swClearProf51 = uvm_reg_field::type_id::create("swClearProf51");
        swClearProf50 = uvm_reg_field::type_id::create("swClearProf50");
        swClearProf49 = uvm_reg_field::type_id::create("swClearProf49");
        swClearProf48 = uvm_reg_field::type_id::create("swClearProf48");
        swClearProf47 = uvm_reg_field::type_id::create("swClearProf47");
        swClearProf46 = uvm_reg_field::type_id::create("swClearProf46");
        swClearProf45 = uvm_reg_field::type_id::create("swClearProf45");
        swClearProf44 = uvm_reg_field::type_id::create("swClearProf44");
        swClearProf43 = uvm_reg_field::type_id::create("swClearProf43");
        swClearProf42 = uvm_reg_field::type_id::create("swClearProf42");
        swClearProf41 = uvm_reg_field::type_id::create("swClearProf41");
        swClearProf40 = uvm_reg_field::type_id::create("swClearProf40");
        swClearProf39 = uvm_reg_field::type_id::create("swClearProf39");
        swClearProf38 = uvm_reg_field::type_id::create("swClearProf38");
        swClearProf37 = uvm_reg_field::type_id::create("swClearProf37");
        swClearProf36 = uvm_reg_field::type_id::create("swClearProf36");
        swClearProf35 = uvm_reg_field::type_id::create("swClearProf35");
        swClearProf34 = uvm_reg_field::type_id::create("swClearProf34");
        swClearProf33 = uvm_reg_field::type_id::create("swClearProf33");
        swClearProf32 = uvm_reg_field::type_id::create("swClearProf32");

        swClearProf63.configure(this, 1, 31, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf62.configure(this, 1, 30, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf61.configure(this, 1, 29, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf60.configure(this, 1, 28, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf59.configure(this, 1, 27, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf58.configure(this, 1, 26, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf57.configure(this, 1, 25, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf56.configure(this, 1, 24, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf55.configure(this, 1, 23, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf54.configure(this, 1, 22, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf53.configure(this, 1, 21, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf52.configure(this, 1, 20, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf51.configure(this, 1, 19, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf50.configure(this, 1, 18, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf49.configure(this, 1, 17, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf48.configure(this, 1, 16, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf47.configure(this, 1, 15, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf46.configure(this, 1, 14, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf45.configure(this, 1, 13, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf44.configure(this, 1, 12, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf43.configure(this, 1, 11, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf42.configure(this, 1, 10, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf41.configure(this, 1, 9, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf40.configure(this, 1, 8, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf39.configure(this, 1, 7, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf38.configure(this, 1, 6, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf37.configure(this, 1, 5, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf36.configure(this, 1, 4, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf35.configure(this, 1, 3, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf34.configure(this, 1, 2, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf33.configure(this, 1, 1, "W1C", 1, 'b0, 1, 1, 1);
        swClearProf32.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="MACPL_SWCLEARPROFILINGREG2_wr_cg";
        swClearProf63_wr : coverpoint swClearProf63.value[0:0];
        swClearProf62_wr : coverpoint swClearProf62.value[0:0];
        swClearProf61_wr : coverpoint swClearProf61.value[0:0];
        swClearProf60_wr : coverpoint swClearProf60.value[0:0];
        swClearProf59_wr : coverpoint swClearProf59.value[0:0];
        swClearProf58_wr : coverpoint swClearProf58.value[0:0];
        swClearProf57_wr : coverpoint swClearProf57.value[0:0];
        swClearProf56_wr : coverpoint swClearProf56.value[0:0];
        swClearProf55_wr : coverpoint swClearProf55.value[0:0];
        swClearProf54_wr : coverpoint swClearProf54.value[0:0];
        swClearProf53_wr : coverpoint swClearProf53.value[0:0];
        swClearProf52_wr : coverpoint swClearProf52.value[0:0];
        swClearProf51_wr : coverpoint swClearProf51.value[0:0];
        swClearProf50_wr : coverpoint swClearProf50.value[0:0];
        swClearProf49_wr : coverpoint swClearProf49.value[0:0];
        swClearProf48_wr : coverpoint swClearProf48.value[0:0];
        swClearProf47_wr : coverpoint swClearProf47.value[0:0];
        swClearProf46_wr : coverpoint swClearProf46.value[0:0];
        swClearProf45_wr : coverpoint swClearProf45.value[0:0];
        swClearProf44_wr : coverpoint swClearProf44.value[0:0];
        swClearProf43_wr : coverpoint swClearProf43.value[0:0];
        swClearProf42_wr : coverpoint swClearProf42.value[0:0];
        swClearProf41_wr : coverpoint swClearProf41.value[0:0];
        swClearProf40_wr : coverpoint swClearProf40.value[0:0];
        swClearProf39_wr : coverpoint swClearProf39.value[0:0];
        swClearProf38_wr : coverpoint swClearProf38.value[0:0];
        swClearProf37_wr : coverpoint swClearProf37.value[0:0];
        swClearProf36_wr : coverpoint swClearProf36.value[0:0];
        swClearProf35_wr : coverpoint swClearProf35.value[0:0];
        swClearProf34_wr : coverpoint swClearProf34.value[0:0];
        swClearProf33_wr : coverpoint swClearProf33.value[0:0];
        swClearProf32_wr : coverpoint swClearProf32.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SWCLEARPROFILINGREG2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGSECU1TXCPTRREG
//--------------------------------------------------------------------
class DEBUGSECU1TXCPTRREG extends uvm_reg;
    `uvm_object_utils(DEBUGSECU1TXCPTRREG)
    rand uvm_reg_field secU1TxCurrentPointer;

    //---build------------------------------------------------------------
    virtual function void build();
        secU1TxCurrentPointer = uvm_reg_field::type_id::create("secU1TxCurrentPointer");

        secU1TxCurrentPointer.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DEBUGSECU1TXCPTRREG_rd_cg";
        secU1TxCurrentPointer_rd : coverpoint secU1TxCurrentPointer.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGSECU1TXCPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGSECU2TXCPTRREG
//--------------------------------------------------------------------
class DEBUGSECU2TXCPTRREG extends uvm_reg;
    `uvm_object_utils(DEBUGSECU2TXCPTRREG)
    rand uvm_reg_field secU2TxCurrentPointer;

    //---build------------------------------------------------------------
    virtual function void build();
        secU2TxCurrentPointer = uvm_reg_field::type_id::create("secU2TxCurrentPointer");

        secU2TxCurrentPointer.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DEBUGSECU2TXCPTRREG_rd_cg";
        secU2TxCurrentPointer_rd : coverpoint secU2TxCurrentPointer.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGSECU2TXCPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DEBUGSECU3TXCPTRREG
//--------------------------------------------------------------------
class DEBUGSECU3TXCPTRREG extends uvm_reg;
    `uvm_object_utils(DEBUGSECU3TXCPTRREG)
    rand uvm_reg_field secU3TxCurrentPointer;

    //---build------------------------------------------------------------
    virtual function void build();
        secU3TxCurrentPointer = uvm_reg_field::type_id::create("secU3TxCurrentPointer");

        secU3TxCurrentPointer.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="MACPL_DEBUGSECU3TXCPTRREG_rd_cg";
        secU3TxCurrentPointer_rd : coverpoint secU3TxCurrentPointer.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DEBUGSECU3TXCPTRREG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class MACPL_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(MACPL_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins NEXTTBTTREG              = {'h40};
        bins DOZECNTRL2REG              = {'h48};
        bins MACCNTRL2REG              = {'h50};
        bins GENINTEVENTSETREG              = {'h6C};
        bins GENINTEVENTCLEARREG              = {'h70};
        bins GENINTUNMASKREG              = {'h74};
        bins TXRXINTEVENTSETREG              = {'h78};
        bins TXRXINTEVENTCLEARREG              = {'h7C};
        bins TXRXINTUNMASKREG              = {'h80};
        bins TIMERSINTEVENTSETREG              = {'h84};
        bins TIMERSINTEVENTCLEARREG              = {'h88};
        bins TIMERSINTUNMASKREG              = {'h8C};
        bins TSFLOREG              = {'hA4};
        bins TSFHIREG              = {'hA8};
        bins TIMEONAIRPARAM1REG              = {'h160};
        bins TIMEONAIRPARAM2REG              = {'h164};
        bins TIMEONAIRPARAM3REG              = {'h168};
        bins TIMEONAIRVALUEREG              = {'h16C};
        bins DMACNTRLSETREG              = {'h180};
        bins DMACNTRLCLEARREG              = {'h184};
        bins DMASTATUS1REG              = {'h188};
        bins DMASTATUS2REG              = {'h18C};
        bins DMASTATUS3REG              = {'h190};
        bins DMASTATUS4REG              = {'h194};
        bins TXBCNHEADPTRREG              = {'h198};
        bins TXAC0HEADPTRREG              = {'h19C};
        bins TXAC1HEADPTRREG              = {'h1A0};
        bins TXAC2HEADPTRREG              = {'h1A4};
        bins TXAC3HEADPTRREG              = {'h1A8};
        bins TXTBHEADPTRREG              = {'h1AC};
        bins TXSTRUCTSIZESREG              = {'h1B0};
        bins DMATHRESHOLDREG              = {'h1C0};
        bins RXHEADERTFPTRREG              = {'h1C4};
        bins RXBUF1STARTPTRREG              = {'h1C8};
        bins RXBUF1ENDPTRREG              = {'h1CC};
        bins RXBUF1RDPTRREG              = {'h1D0};
        bins RXBUF1WRPTRREG              = {'h1D4};
        bins RXBUF2STARTPTRREG              = {'h1D8};
        bins RXBUF2ENDPTRREG              = {'h1DC};
        bins RXBUF2RDPTRREG              = {'h1E0};
        bins RXBUF2WRPTRREG              = {'h1E4};
        bins RXBUFCONFIGREG              = {'h1E8};
        bins MOT1REG              = {'h228};
        bins MOT2REG              = {'h22C};
        bins TXBWDROPINFOREG              = {'h330};
        bins TXHETBINFOREG              = {'h354};
        bins RXHETRIGCOMMONINFOREG              = {'h358};
        bins RXHETRIGUSERINFOREG              = {'h35C};
        bins RXHETRIGPSDULENREG              = {'h360};
        bins RXHETRIGPWRINFOREG              = {'h364};
        bins SECUSERSTXINTEVENTSETREG              = {'h368};
        bins SECUSERSTXINTEVENTCLEARREG              = {'h36C};
        bins SECUSERSTXINTEVENTUNMASKREG              = {'h370};
        bins DEBUGBCNSPTRREG              = {'h524};
        bins DEBUGAC0SPTRREG              = {'h528};
        bins DEBUGAC1SPTRREG              = {'h52C};
        bins DEBUGAC2SPTRREG              = {'h530};
        bins DEBUGAC3SPTRREG              = {'h534};
        bins DEBUGTBSPTRREG              = {'h538};
        bins DEBUGTXCPTRREG              = {'h540};
        bins SWPROFILINGREG              = {'h560};
        bins SWSETPROFILINGREG              = {'h564};
        bins SWCLEARPROFILINGREG              = {'h568};
        bins SWPROFILINGREG2              = {'h56C};
        bins SWSETPROFILINGREG2              = {'h570};
        bins SWCLEARPROFILINGREG2              = {'h574};
        bins DEBUGSECU1TXCPTRREG              = {'h590};
        bins DEBUGSECU2TXCPTRREG              = {'h594};
        bins DEBUGSECU3TXCPTRREG              = {'h598};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "MACPL_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: MACPL_reg_access_wrapper

//-------------------------------------------------------------------
// MACPL_register_block
//--------------------------------------------------------------------
class MACPL_register_block extends uvm_reg_block;
    `uvm_object_utils(MACPL_register_block)

    rand NEXTTBTTREG NEXTTBTTREG_reg;
    rand DOZECNTRL2REG DOZECNTRL2REG_reg;
    rand MACCNTRL2REG MACCNTRL2REG_reg;
    rand GENINTEVENTSETREG GENINTEVENTSETREG_reg;
    rand GENINTEVENTCLEARREG GENINTEVENTCLEARREG_reg;
    rand GENINTUNMASKREG GENINTUNMASKREG_reg;
    rand TXRXINTEVENTSETREG TXRXINTEVENTSETREG_reg;
    rand TXRXINTEVENTCLEARREG TXRXINTEVENTCLEARREG_reg;
    rand TXRXINTUNMASKREG TXRXINTUNMASKREG_reg;
    rand TIMERSINTEVENTSETREG TIMERSINTEVENTSETREG_reg;
    rand TIMERSINTEVENTCLEARREG TIMERSINTEVENTCLEARREG_reg;
    rand TIMERSINTUNMASKREG TIMERSINTUNMASKREG_reg;
    rand TSFLOREG TSFLOREG_reg;
    rand TSFHIREG TSFHIREG_reg;
    rand TIMEONAIRPARAM1REG TIMEONAIRPARAM1REG_reg;
    rand TIMEONAIRPARAM2REG TIMEONAIRPARAM2REG_reg;
    rand TIMEONAIRPARAM3REG TIMEONAIRPARAM3REG_reg;
    rand TIMEONAIRVALUEREG TIMEONAIRVALUEREG_reg;
    rand DMACNTRLSETREG DMACNTRLSETREG_reg;
    rand DMACNTRLCLEARREG DMACNTRLCLEARREG_reg;
    rand DMASTATUS1REG DMASTATUS1REG_reg;
    rand DMASTATUS2REG DMASTATUS2REG_reg;
    rand DMASTATUS3REG DMASTATUS3REG_reg;
    rand DMASTATUS4REG DMASTATUS4REG_reg;
    rand TXBCNHEADPTRREG TXBCNHEADPTRREG_reg;
    rand TXAC0HEADPTRREG TXAC0HEADPTRREG_reg;
    rand TXAC1HEADPTRREG TXAC1HEADPTRREG_reg;
    rand TXAC2HEADPTRREG TXAC2HEADPTRREG_reg;
    rand TXAC3HEADPTRREG TXAC3HEADPTRREG_reg;
    rand TXTBHEADPTRREG TXTBHEADPTRREG_reg;
    rand TXSTRUCTSIZESREG TXSTRUCTSIZESREG_reg;
    rand DMATHRESHOLDREG DMATHRESHOLDREG_reg;
    rand RXHEADERTFPTRREG RXHEADERTFPTRREG_reg;
    rand RXBUF1STARTPTRREG RXBUF1STARTPTRREG_reg;
    rand RXBUF1ENDPTRREG RXBUF1ENDPTRREG_reg;
    rand RXBUF1RDPTRREG RXBUF1RDPTRREG_reg;
    rand RXBUF1WRPTRREG RXBUF1WRPTRREG_reg;
    rand RXBUF2STARTPTRREG RXBUF2STARTPTRREG_reg;
    rand RXBUF2ENDPTRREG RXBUF2ENDPTRREG_reg;
    rand RXBUF2RDPTRREG RXBUF2RDPTRREG_reg;
    rand RXBUF2WRPTRREG RXBUF2WRPTRREG_reg;
    rand RXBUFCONFIGREG RXBUFCONFIGREG_reg;
    rand MOT1REG MOT1REG_reg;
    rand MOT2REG MOT2REG_reg;
    rand TXBWDROPINFOREG TXBWDROPINFOREG_reg;
    rand TXHETBINFOREG TXHETBINFOREG_reg;
    rand RXHETRIGCOMMONINFOREG RXHETRIGCOMMONINFOREG_reg;
    rand RXHETRIGUSERINFOREG RXHETRIGUSERINFOREG_reg;
    rand RXHETRIGPSDULENREG RXHETRIGPSDULENREG_reg;
    rand RXHETRIGPWRINFOREG RXHETRIGPWRINFOREG_reg;
    rand SECUSERSTXINTEVENTSETREG SECUSERSTXINTEVENTSETREG_reg;
    rand SECUSERSTXINTEVENTCLEARREG SECUSERSTXINTEVENTCLEARREG_reg;
    rand SECUSERSTXINTEVENTUNMASKREG SECUSERSTXINTEVENTUNMASKREG_reg;
    rand DEBUGBCNSPTRREG DEBUGBCNSPTRREG_reg;
    rand DEBUGAC0SPTRREG DEBUGAC0SPTRREG_reg;
    rand DEBUGAC1SPTRREG DEBUGAC1SPTRREG_reg;
    rand DEBUGAC2SPTRREG DEBUGAC2SPTRREG_reg;
    rand DEBUGAC3SPTRREG DEBUGAC3SPTRREG_reg;
    rand DEBUGTBSPTRREG DEBUGTBSPTRREG_reg;
    rand DEBUGTXCPTRREG DEBUGTXCPTRREG_reg;
    rand SWPROFILINGREG SWPROFILINGREG_reg;
    rand SWSETPROFILINGREG SWSETPROFILINGREG_reg;
    rand SWCLEARPROFILINGREG SWCLEARPROFILINGREG_reg;
    rand SWPROFILINGREG2 SWPROFILINGREG2_reg;
    rand SWSETPROFILINGREG2 SWSETPROFILINGREG2_reg;
    rand SWCLEARPROFILINGREG2 SWCLEARPROFILINGREG2_reg;
    rand DEBUGSECU1TXCPTRREG DEBUGSECU1TXCPTRREG_reg;
    rand DEBUGSECU2TXCPTRREG DEBUGSECU2TXCPTRREG_reg;
    rand DEBUGSECU3TXCPTRREG DEBUGSECU3TXCPTRREG_reg;

    uvm_reg_map MACPL_register_map; // Block map
    MACPL_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "MACPL_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = MACPL_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        NEXTTBTTREG_reg = NEXTTBTTREG::type_id::create("NEXTTBTTREG");
        NEXTTBTTREG_reg.configure(this);
        NEXTTBTTREG_reg.build();

        DOZECNTRL2REG_reg = DOZECNTRL2REG::type_id::create("DOZECNTRL2REG");
        DOZECNTRL2REG_reg.configure(this);
        DOZECNTRL2REG_reg.build();

        MACCNTRL2REG_reg = MACCNTRL2REG::type_id::create("MACCNTRL2REG");
        MACCNTRL2REG_reg.configure(this);
        MACCNTRL2REG_reg.build();

        GENINTEVENTSETREG_reg = GENINTEVENTSETREG::type_id::create("GENINTEVENTSETREG");
        GENINTEVENTSETREG_reg.configure(this);
        GENINTEVENTSETREG_reg.build();

        GENINTEVENTCLEARREG_reg = GENINTEVENTCLEARREG::type_id::create("GENINTEVENTCLEARREG");
        GENINTEVENTCLEARREG_reg.configure(this);
        GENINTEVENTCLEARREG_reg.build();

        GENINTUNMASKREG_reg = GENINTUNMASKREG::type_id::create("GENINTUNMASKREG");
        GENINTUNMASKREG_reg.configure(this);
        GENINTUNMASKREG_reg.build();

        TXRXINTEVENTSETREG_reg = TXRXINTEVENTSETREG::type_id::create("TXRXINTEVENTSETREG");
        TXRXINTEVENTSETREG_reg.configure(this);
        TXRXINTEVENTSETREG_reg.build();

        TXRXINTEVENTCLEARREG_reg = TXRXINTEVENTCLEARREG::type_id::create("TXRXINTEVENTCLEARREG");
        TXRXINTEVENTCLEARREG_reg.configure(this);
        TXRXINTEVENTCLEARREG_reg.build();

        TXRXINTUNMASKREG_reg = TXRXINTUNMASKREG::type_id::create("TXRXINTUNMASKREG");
        TXRXINTUNMASKREG_reg.configure(this);
        TXRXINTUNMASKREG_reg.build();

        TIMERSINTEVENTSETREG_reg = TIMERSINTEVENTSETREG::type_id::create("TIMERSINTEVENTSETREG");
        TIMERSINTEVENTSETREG_reg.configure(this);
        TIMERSINTEVENTSETREG_reg.build();

        TIMERSINTEVENTCLEARREG_reg = TIMERSINTEVENTCLEARREG::type_id::create("TIMERSINTEVENTCLEARREG");
        TIMERSINTEVENTCLEARREG_reg.configure(this);
        TIMERSINTEVENTCLEARREG_reg.build();

        TIMERSINTUNMASKREG_reg = TIMERSINTUNMASKREG::type_id::create("TIMERSINTUNMASKREG");
        TIMERSINTUNMASKREG_reg.configure(this);
        TIMERSINTUNMASKREG_reg.build();

        TSFLOREG_reg = TSFLOREG::type_id::create("TSFLOREG");
        TSFLOREG_reg.configure(this);
        TSFLOREG_reg.build();

        TSFHIREG_reg = TSFHIREG::type_id::create("TSFHIREG");
        TSFHIREG_reg.configure(this);
        TSFHIREG_reg.build();

        TIMEONAIRPARAM1REG_reg = TIMEONAIRPARAM1REG::type_id::create("TIMEONAIRPARAM1REG");
        TIMEONAIRPARAM1REG_reg.configure(this);
        TIMEONAIRPARAM1REG_reg.build();

        TIMEONAIRPARAM2REG_reg = TIMEONAIRPARAM2REG::type_id::create("TIMEONAIRPARAM2REG");
        TIMEONAIRPARAM2REG_reg.configure(this);
        TIMEONAIRPARAM2REG_reg.build();

        TIMEONAIRPARAM3REG_reg = TIMEONAIRPARAM3REG::type_id::create("TIMEONAIRPARAM3REG");
        TIMEONAIRPARAM3REG_reg.configure(this);
        TIMEONAIRPARAM3REG_reg.build();

        TIMEONAIRVALUEREG_reg = TIMEONAIRVALUEREG::type_id::create("TIMEONAIRVALUEREG");
        TIMEONAIRVALUEREG_reg.configure(this);
        TIMEONAIRVALUEREG_reg.build();

        DMACNTRLSETREG_reg = DMACNTRLSETREG::type_id::create("DMACNTRLSETREG");
        DMACNTRLSETREG_reg.configure(this);
        DMACNTRLSETREG_reg.build();

        DMACNTRLCLEARREG_reg = DMACNTRLCLEARREG::type_id::create("DMACNTRLCLEARREG");
        DMACNTRLCLEARREG_reg.configure(this);
        DMACNTRLCLEARREG_reg.build();

        DMASTATUS1REG_reg = DMASTATUS1REG::type_id::create("DMASTATUS1REG");
        DMASTATUS1REG_reg.configure(this);
        DMASTATUS1REG_reg.build();

        DMASTATUS2REG_reg = DMASTATUS2REG::type_id::create("DMASTATUS2REG");
        DMASTATUS2REG_reg.configure(this);
        DMASTATUS2REG_reg.build();

        DMASTATUS3REG_reg = DMASTATUS3REG::type_id::create("DMASTATUS3REG");
        DMASTATUS3REG_reg.configure(this);
        DMASTATUS3REG_reg.build();

        DMASTATUS4REG_reg = DMASTATUS4REG::type_id::create("DMASTATUS4REG");
        DMASTATUS4REG_reg.configure(this);
        DMASTATUS4REG_reg.build();

        TXBCNHEADPTRREG_reg = TXBCNHEADPTRREG::type_id::create("TXBCNHEADPTRREG");
        TXBCNHEADPTRREG_reg.configure(this);
        TXBCNHEADPTRREG_reg.build();

        TXAC0HEADPTRREG_reg = TXAC0HEADPTRREG::type_id::create("TXAC0HEADPTRREG");
        TXAC0HEADPTRREG_reg.configure(this);
        TXAC0HEADPTRREG_reg.build();

        TXAC1HEADPTRREG_reg = TXAC1HEADPTRREG::type_id::create("TXAC1HEADPTRREG");
        TXAC1HEADPTRREG_reg.configure(this);
        TXAC1HEADPTRREG_reg.build();

        TXAC2HEADPTRREG_reg = TXAC2HEADPTRREG::type_id::create("TXAC2HEADPTRREG");
        TXAC2HEADPTRREG_reg.configure(this);
        TXAC2HEADPTRREG_reg.build();

        TXAC3HEADPTRREG_reg = TXAC3HEADPTRREG::type_id::create("TXAC3HEADPTRREG");
        TXAC3HEADPTRREG_reg.configure(this);
        TXAC3HEADPTRREG_reg.build();

        TXTBHEADPTRREG_reg = TXTBHEADPTRREG::type_id::create("TXTBHEADPTRREG");
        TXTBHEADPTRREG_reg.configure(this);
        TXTBHEADPTRREG_reg.build();

        TXSTRUCTSIZESREG_reg = TXSTRUCTSIZESREG::type_id::create("TXSTRUCTSIZESREG");
        TXSTRUCTSIZESREG_reg.configure(this);
        TXSTRUCTSIZESREG_reg.build();

        DMATHRESHOLDREG_reg = DMATHRESHOLDREG::type_id::create("DMATHRESHOLDREG");
        DMATHRESHOLDREG_reg.configure(this);
        DMATHRESHOLDREG_reg.build();

        RXHEADERTFPTRREG_reg = RXHEADERTFPTRREG::type_id::create("RXHEADERTFPTRREG");
        RXHEADERTFPTRREG_reg.configure(this);
        RXHEADERTFPTRREG_reg.build();

        RXBUF1STARTPTRREG_reg = RXBUF1STARTPTRREG::type_id::create("RXBUF1STARTPTRREG");
        RXBUF1STARTPTRREG_reg.configure(this);
        RXBUF1STARTPTRREG_reg.build();

        RXBUF1ENDPTRREG_reg = RXBUF1ENDPTRREG::type_id::create("RXBUF1ENDPTRREG");
        RXBUF1ENDPTRREG_reg.configure(this);
        RXBUF1ENDPTRREG_reg.build();

        RXBUF1RDPTRREG_reg = RXBUF1RDPTRREG::type_id::create("RXBUF1RDPTRREG");
        RXBUF1RDPTRREG_reg.configure(this);
        RXBUF1RDPTRREG_reg.build();

        RXBUF1WRPTRREG_reg = RXBUF1WRPTRREG::type_id::create("RXBUF1WRPTRREG");
        RXBUF1WRPTRREG_reg.configure(this);
        RXBUF1WRPTRREG_reg.build();

        RXBUF2STARTPTRREG_reg = RXBUF2STARTPTRREG::type_id::create("RXBUF2STARTPTRREG");
        RXBUF2STARTPTRREG_reg.configure(this);
        RXBUF2STARTPTRREG_reg.build();

        RXBUF2ENDPTRREG_reg = RXBUF2ENDPTRREG::type_id::create("RXBUF2ENDPTRREG");
        RXBUF2ENDPTRREG_reg.configure(this);
        RXBUF2ENDPTRREG_reg.build();

        RXBUF2RDPTRREG_reg = RXBUF2RDPTRREG::type_id::create("RXBUF2RDPTRREG");
        RXBUF2RDPTRREG_reg.configure(this);
        RXBUF2RDPTRREG_reg.build();

        RXBUF2WRPTRREG_reg = RXBUF2WRPTRREG::type_id::create("RXBUF2WRPTRREG");
        RXBUF2WRPTRREG_reg.configure(this);
        RXBUF2WRPTRREG_reg.build();

        RXBUFCONFIGREG_reg = RXBUFCONFIGREG::type_id::create("RXBUFCONFIGREG");
        RXBUFCONFIGREG_reg.configure(this);
        RXBUFCONFIGREG_reg.build();

        MOT1REG_reg = MOT1REG::type_id::create("MOT1REG");
        MOT1REG_reg.configure(this);
        MOT1REG_reg.build();

        MOT2REG_reg = MOT2REG::type_id::create("MOT2REG");
        MOT2REG_reg.configure(this);
        MOT2REG_reg.build();

        TXBWDROPINFOREG_reg = TXBWDROPINFOREG::type_id::create("TXBWDROPINFOREG");
        TXBWDROPINFOREG_reg.configure(this);
        TXBWDROPINFOREG_reg.build();

        TXHETBINFOREG_reg = TXHETBINFOREG::type_id::create("TXHETBINFOREG");
        TXHETBINFOREG_reg.configure(this);
        TXHETBINFOREG_reg.build();

        RXHETRIGCOMMONINFOREG_reg = RXHETRIGCOMMONINFOREG::type_id::create("RXHETRIGCOMMONINFOREG");
        RXHETRIGCOMMONINFOREG_reg.configure(this);
        RXHETRIGCOMMONINFOREG_reg.build();

        RXHETRIGUSERINFOREG_reg = RXHETRIGUSERINFOREG::type_id::create("RXHETRIGUSERINFOREG");
        RXHETRIGUSERINFOREG_reg.configure(this);
        RXHETRIGUSERINFOREG_reg.build();

        RXHETRIGPSDULENREG_reg = RXHETRIGPSDULENREG::type_id::create("RXHETRIGPSDULENREG");
        RXHETRIGPSDULENREG_reg.configure(this);
        RXHETRIGPSDULENREG_reg.build();

        RXHETRIGPWRINFOREG_reg = RXHETRIGPWRINFOREG::type_id::create("RXHETRIGPWRINFOREG");
        RXHETRIGPWRINFOREG_reg.configure(this);
        RXHETRIGPWRINFOREG_reg.build();

        SECUSERSTXINTEVENTSETREG_reg = SECUSERSTXINTEVENTSETREG::type_id::create("SECUSERSTXINTEVENTSETREG");
        SECUSERSTXINTEVENTSETREG_reg.configure(this);
        SECUSERSTXINTEVENTSETREG_reg.build();

        SECUSERSTXINTEVENTCLEARREG_reg = SECUSERSTXINTEVENTCLEARREG::type_id::create("SECUSERSTXINTEVENTCLEARREG");
        SECUSERSTXINTEVENTCLEARREG_reg.configure(this);
        SECUSERSTXINTEVENTCLEARREG_reg.build();

        SECUSERSTXINTEVENTUNMASKREG_reg = SECUSERSTXINTEVENTUNMASKREG::type_id::create("SECUSERSTXINTEVENTUNMASKREG");
        SECUSERSTXINTEVENTUNMASKREG_reg.configure(this);
        SECUSERSTXINTEVENTUNMASKREG_reg.build();

        DEBUGBCNSPTRREG_reg = DEBUGBCNSPTRREG::type_id::create("DEBUGBCNSPTRREG");
        DEBUGBCNSPTRREG_reg.configure(this);
        DEBUGBCNSPTRREG_reg.build();

        DEBUGAC0SPTRREG_reg = DEBUGAC0SPTRREG::type_id::create("DEBUGAC0SPTRREG");
        DEBUGAC0SPTRREG_reg.configure(this);
        DEBUGAC0SPTRREG_reg.build();

        DEBUGAC1SPTRREG_reg = DEBUGAC1SPTRREG::type_id::create("DEBUGAC1SPTRREG");
        DEBUGAC1SPTRREG_reg.configure(this);
        DEBUGAC1SPTRREG_reg.build();

        DEBUGAC2SPTRREG_reg = DEBUGAC2SPTRREG::type_id::create("DEBUGAC2SPTRREG");
        DEBUGAC2SPTRREG_reg.configure(this);
        DEBUGAC2SPTRREG_reg.build();

        DEBUGAC3SPTRREG_reg = DEBUGAC3SPTRREG::type_id::create("DEBUGAC3SPTRREG");
        DEBUGAC3SPTRREG_reg.configure(this);
        DEBUGAC3SPTRREG_reg.build();

        DEBUGTBSPTRREG_reg = DEBUGTBSPTRREG::type_id::create("DEBUGTBSPTRREG");
        DEBUGTBSPTRREG_reg.configure(this);
        DEBUGTBSPTRREG_reg.build();

        DEBUGTXCPTRREG_reg = DEBUGTXCPTRREG::type_id::create("DEBUGTXCPTRREG");
        DEBUGTXCPTRREG_reg.configure(this);
        DEBUGTXCPTRREG_reg.build();

        SWPROFILINGREG_reg = SWPROFILINGREG::type_id::create("SWPROFILINGREG");
        SWPROFILINGREG_reg.configure(this);
        SWPROFILINGREG_reg.build();

        SWSETPROFILINGREG_reg = SWSETPROFILINGREG::type_id::create("SWSETPROFILINGREG");
        SWSETPROFILINGREG_reg.configure(this);
        SWSETPROFILINGREG_reg.build();

        SWCLEARPROFILINGREG_reg = SWCLEARPROFILINGREG::type_id::create("SWCLEARPROFILINGREG");
        SWCLEARPROFILINGREG_reg.configure(this);
        SWCLEARPROFILINGREG_reg.build();

        SWPROFILINGREG2_reg = SWPROFILINGREG2::type_id::create("SWPROFILINGREG2");
        SWPROFILINGREG2_reg.configure(this);
        SWPROFILINGREG2_reg.build();

        SWSETPROFILINGREG2_reg = SWSETPROFILINGREG2::type_id::create("SWSETPROFILINGREG2");
        SWSETPROFILINGREG2_reg.configure(this);
        SWSETPROFILINGREG2_reg.build();

        SWCLEARPROFILINGREG2_reg = SWCLEARPROFILINGREG2::type_id::create("SWCLEARPROFILINGREG2");
        SWCLEARPROFILINGREG2_reg.configure(this);
        SWCLEARPROFILINGREG2_reg.build();

        DEBUGSECU1TXCPTRREG_reg = DEBUGSECU1TXCPTRREG::type_id::create("DEBUGSECU1TXCPTRREG");
        DEBUGSECU1TXCPTRREG_reg.configure(this);
        DEBUGSECU1TXCPTRREG_reg.build();

        DEBUGSECU2TXCPTRREG_reg = DEBUGSECU2TXCPTRREG::type_id::create("DEBUGSECU2TXCPTRREG");
        DEBUGSECU2TXCPTRREG_reg.configure(this);
        DEBUGSECU2TXCPTRREG_reg.build();

        DEBUGSECU3TXCPTRREG_reg = DEBUGSECU3TXCPTRREG::type_id::create("DEBUGSECU3TXCPTRREG");
        DEBUGSECU3TXCPTRREG_reg.configure(this);
        DEBUGSECU3TXCPTRREG_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        MACPL_register_map = create_map("MACPL_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        MACPL_register_map.add_reg(NEXTTBTTREG_reg, 'h40, "RO");
        MACPL_register_map.add_reg(DOZECNTRL2REG_reg, 'h48, "RW");
        MACPL_register_map.add_reg(MACCNTRL2REG_reg, 'h50, "RW");
        MACPL_register_map.add_reg(GENINTEVENTSETREG_reg, 'h6C, "RW");
        MACPL_register_map.add_reg(GENINTEVENTCLEARREG_reg, 'h70, "RW");
        MACPL_register_map.add_reg(GENINTUNMASKREG_reg, 'h74, "RW");
        MACPL_register_map.add_reg(TXRXINTEVENTSETREG_reg, 'h78, "RW");
        MACPL_register_map.add_reg(TXRXINTEVENTCLEARREG_reg, 'h7C, "RW");
        MACPL_register_map.add_reg(TXRXINTUNMASKREG_reg, 'h80, "RW");
        MACPL_register_map.add_reg(TIMERSINTEVENTSETREG_reg, 'h84, "RW");
        MACPL_register_map.add_reg(TIMERSINTEVENTCLEARREG_reg, 'h88, "RW");
        MACPL_register_map.add_reg(TIMERSINTUNMASKREG_reg, 'h8C, "RW");
        MACPL_register_map.add_reg(TSFLOREG_reg, 'hA4, "RW");
        MACPL_register_map.add_reg(TSFHIREG_reg, 'hA8, "RW");
        MACPL_register_map.add_reg(TIMEONAIRPARAM1REG_reg, 'h160, "RW");
        MACPL_register_map.add_reg(TIMEONAIRPARAM2REG_reg, 'h164, "RW");
        MACPL_register_map.add_reg(TIMEONAIRPARAM3REG_reg, 'h168, "RW");
        MACPL_register_map.add_reg(TIMEONAIRVALUEREG_reg, 'h16C, "RW");
        MACPL_register_map.add_reg(DMACNTRLSETREG_reg, 'h180, "RW");
        MACPL_register_map.add_reg(DMACNTRLCLEARREG_reg, 'h184, "RW");
        MACPL_register_map.add_reg(DMASTATUS1REG_reg, 'h188, "RO");
        MACPL_register_map.add_reg(DMASTATUS2REG_reg, 'h18C, "RO");
        MACPL_register_map.add_reg(DMASTATUS3REG_reg, 'h190, "RO");
        MACPL_register_map.add_reg(DMASTATUS4REG_reg, 'h194, "RO");
        MACPL_register_map.add_reg(TXBCNHEADPTRREG_reg, 'h198, "RW");
        MACPL_register_map.add_reg(TXAC0HEADPTRREG_reg, 'h19C, "RW");
        MACPL_register_map.add_reg(TXAC1HEADPTRREG_reg, 'h1A0, "RW");
        MACPL_register_map.add_reg(TXAC2HEADPTRREG_reg, 'h1A4, "RW");
        MACPL_register_map.add_reg(TXAC3HEADPTRREG_reg, 'h1A8, "RW");
        MACPL_register_map.add_reg(TXTBHEADPTRREG_reg, 'h1AC, "RW");
        MACPL_register_map.add_reg(TXSTRUCTSIZESREG_reg, 'h1B0, "RW");
        MACPL_register_map.add_reg(DMATHRESHOLDREG_reg, 'h1C0, "RW");
        MACPL_register_map.add_reg(RXHEADERTFPTRREG_reg, 'h1C4, "RO");
        MACPL_register_map.add_reg(RXBUF1STARTPTRREG_reg, 'h1C8, "RW");
        MACPL_register_map.add_reg(RXBUF1ENDPTRREG_reg, 'h1CC, "RW");
        MACPL_register_map.add_reg(RXBUF1RDPTRREG_reg, 'h1D0, "RW");
        MACPL_register_map.add_reg(RXBUF1WRPTRREG_reg, 'h1D4, "RW");
        MACPL_register_map.add_reg(RXBUF2STARTPTRREG_reg, 'h1D8, "RW");
        MACPL_register_map.add_reg(RXBUF2ENDPTRREG_reg, 'h1DC, "RW");
        MACPL_register_map.add_reg(RXBUF2RDPTRREG_reg, 'h1E0, "RW");
        MACPL_register_map.add_reg(RXBUF2WRPTRREG_reg, 'h1E4, "RW");
        MACPL_register_map.add_reg(RXBUFCONFIGREG_reg, 'h1E8, "RW");
        MACPL_register_map.add_reg(MOT1REG_reg, 'h228, "RO");
        MACPL_register_map.add_reg(MOT2REG_reg, 'h22C, "RO");
        MACPL_register_map.add_reg(TXBWDROPINFOREG_reg, 'h330, "RO");
        MACPL_register_map.add_reg(TXHETBINFOREG_reg, 'h354, "RW");
        MACPL_register_map.add_reg(RXHETRIGCOMMONINFOREG_reg, 'h358, "RO");
        MACPL_register_map.add_reg(RXHETRIGUSERINFOREG_reg, 'h35C, "RO");
        MACPL_register_map.add_reg(RXHETRIGPSDULENREG_reg, 'h360, "RO");
        MACPL_register_map.add_reg(RXHETRIGPWRINFOREG_reg, 'h364, "RO");
        MACPL_register_map.add_reg(SECUSERSTXINTEVENTSETREG_reg, 'h368, "RW");
        MACPL_register_map.add_reg(SECUSERSTXINTEVENTCLEARREG_reg, 'h36C, "RW");
        MACPL_register_map.add_reg(SECUSERSTXINTEVENTUNMASKREG_reg, 'h370, "RW");
        MACPL_register_map.add_reg(DEBUGBCNSPTRREG_reg, 'h524, "RO");
        MACPL_register_map.add_reg(DEBUGAC0SPTRREG_reg, 'h528, "RO");
        MACPL_register_map.add_reg(DEBUGAC1SPTRREG_reg, 'h52C, "RO");
        MACPL_register_map.add_reg(DEBUGAC2SPTRREG_reg, 'h530, "RO");
        MACPL_register_map.add_reg(DEBUGAC3SPTRREG_reg, 'h534, "RO");
        MACPL_register_map.add_reg(DEBUGTBSPTRREG_reg, 'h538, "RW");
        MACPL_register_map.add_reg(DEBUGTXCPTRREG_reg, 'h540, "RO");
        MACPL_register_map.add_reg(SWPROFILINGREG_reg, 'h560, "RW");
        MACPL_register_map.add_reg(SWSETPROFILINGREG_reg, 'h564, "RW");
        MACPL_register_map.add_reg(SWCLEARPROFILINGREG_reg, 'h568, "RW");
        MACPL_register_map.add_reg(SWPROFILINGREG2_reg, 'h56C, "RW");
        MACPL_register_map.add_reg(SWSETPROFILINGREG2_reg, 'h570, "RW");
        MACPL_register_map.add_reg(SWCLEARPROFILINGREG2_reg, 'h574, "RW");
        MACPL_register_map.add_reg(DEBUGSECU1TXCPTRREG_reg, 'h590, "RO");
        MACPL_register_map.add_reg(DEBUGSECU2TXCPTRREG_reg, 'h594, "RO");
        MACPL_register_map.add_reg(DEBUGSECU3TXCPTRREG_reg, 'h598, "RO");

        // Lock the register model and build the map
        lock_model();
        MACPL_register_map.set_check_on_read();
    endfunction

endclass
`endif // __MACPL_REG_BLOCK_SV__
