//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for PHYCONFIG
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __PHYCONFIG_REG_BLOCK_SV__
`define __PHYCONFIG_REG_BLOCK_SV__

//--------------------------------------------------------------------
// HDMCONFIG
//--------------------------------------------------------------------
class HDMCONFIG extends uvm_reg;
    `uvm_object_utils(HDMCONFIG)
    rand uvm_reg_field MUMIMOTX;
    rand uvm_reg_field MUMIMORX;
    rand uvm_reg_field BFMER;
    rand uvm_reg_field BFMEE;
    rand uvm_reg_field LDPCDEC;
    rand uvm_reg_field LDPCENC;
    rand uvm_reg_field CHBW;
    rand uvm_reg_field DSSSCCK;
    rand uvm_reg_field VHT;
    rand uvm_reg_field HE;
    rand uvm_reg_field ESS;
    rand uvm_reg_field RFMODE;
    rand uvm_reg_field NSTS;
    rand uvm_reg_field NSS;
    rand uvm_reg_field NTX;
    rand uvm_reg_field NRX;

    //---build------------------------------------------------------------
    virtual function void build();
        MUMIMOTX = uvm_reg_field::type_id::create("MUMIMOTX");
        MUMIMORX = uvm_reg_field::type_id::create("MUMIMORX");
        BFMER = uvm_reg_field::type_id::create("BFMER");
        BFMEE = uvm_reg_field::type_id::create("BFMEE");
        LDPCDEC = uvm_reg_field::type_id::create("LDPCDEC");
        LDPCENC = uvm_reg_field::type_id::create("LDPCENC");
        CHBW = uvm_reg_field::type_id::create("CHBW");
        DSSSCCK = uvm_reg_field::type_id::create("DSSSCCK");
        VHT = uvm_reg_field::type_id::create("VHT");
        HE = uvm_reg_field::type_id::create("HE");
        ESS = uvm_reg_field::type_id::create("ESS");
        RFMODE = uvm_reg_field::type_id::create("RFMODE");
        NSTS = uvm_reg_field::type_id::create("NSTS");
        NSS = uvm_reg_field::type_id::create("NSS");
        NTX = uvm_reg_field::type_id::create("NTX");
        NRX = uvm_reg_field::type_id::create("NRX");

        MUMIMOTX.configure(this, 1, 31, "RO", 1, `RW_MDM_MUMIMO_TX_EN, 1, 1, 1);
        MUMIMORX.configure(this, 1, 30, "RO", 1, `RW_MDM_MUMIMO_RX_EN, 1, 1, 1);
        BFMER.configure(this, 1, 29, "RO", 1, `RW_MDM_BFMER_EN, 1, 1, 1);
        BFMEE.configure(this, 1, 28, "RO", 1, `RW_MDM_BFMEE_EN, 1, 1, 1);
        LDPCDEC.configure(this, 1, 27, "RO", 1, `RW_NX_DERIV_LDEC, 1, 1, 1);
        LDPCENC.configure(this, 1, 26, "RO", 1, `RW_NX_DERIV_LENC, 1, 1, 1);
        CHBW.configure(this, 2, 24, "RO", 1, `RW_MDM_CHBW, 1, 1, 1);
        DSSSCCK.configure(this, 1, 23, "RO", 1, `RW_MDM_80211B_EN, 1, 1, 1);
        VHT.configure(this, 1, 22, "RO", 1, `RW_MDM_VHT_EN, 1, 1, 1);
        HE.configure(this, 1, 21, "RO", 1, 'b1, 1, 1, 1);
        ESS.configure(this, 1, 20, "RO", 1, 'b0, 1, 1, 1);
        RFMODE.configure(this, 4, 16, "RO", 1, 'b010, 1, 1, 1);
        NSTS.configure(this, 4, 12, "RO", 1, `RW_NX_DERIV_NSTS, 1, 1, 1);
        NSS.configure(this, 4, 8, "RO", 1, `RW_NX_DERIV_NSS, 1, 1, 1);
        NTX.configure(this, 4, 4, "RO", 1, `RW_NX_DERIV_NTX, 1, 1, 1);
        NRX.configure(this, 4, 0, "RO", 1, `RW_NX_DERIV_NRX, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HDMCONFIG_rd_cg";
        MUMIMOTX_rd : coverpoint MUMIMOTX.value[0:0];
        MUMIMORX_rd : coverpoint MUMIMORX.value[0:0];
        BFMER_rd : coverpoint BFMER.value[0:0];
        BFMEE_rd : coverpoint BFMEE.value[0:0];
        LDPCDEC_rd : coverpoint LDPCDEC.value[0:0];
        LDPCENC_rd : coverpoint LDPCENC.value[0:0];
        CHBW_rd : coverpoint CHBW.value[1:0];
        DSSSCCK_rd : coverpoint DSSSCCK.value[0:0];
        VHT_rd : coverpoint VHT.value[0:0];
        HE_rd : coverpoint HE.value[0:0];
        ESS_rd : coverpoint ESS.value[0:0];
        RFMODE_rd : coverpoint RFMODE.value[3:0];
        NSTS_rd : coverpoint NSTS.value[3:0];
        NSS_rd : coverpoint NSS.value[3:0];
        NTX_rd : coverpoint NTX.value[3:0];
        NRX_rd : coverpoint NRX.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HDMCONFIG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TDOFFSETSTAT0
//--------------------------------------------------------------------
class TDOFFSETSTAT0 extends uvm_reg;
    `uvm_object_utils(TDOFFSETSTAT0)
    rand uvm_reg_field COARSEFOANGLE;

    //---build------------------------------------------------------------
    virtual function void build();
        COARSEFOANGLE = uvm_reg_field::type_id::create("COARSEFOANGLE");

        COARSEFOANGLE.configure(this, 21, 0, "RO", 1, 'b00000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TDOFFSETSTAT0_rd_cg";
        COARSEFOANGLE_rd : coverpoint COARSEFOANGLE.value[20:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TDOFFSETSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TDOFFSETSTAT1
//--------------------------------------------------------------------
class TDOFFSETSTAT1 extends uvm_reg;
    `uvm_object_utils(TDOFFSETSTAT1)
    rand uvm_reg_field FINEFOANGLE;

    //---build------------------------------------------------------------
    virtual function void build();
        FINEFOANGLE = uvm_reg_field::type_id::create("FINEFOANGLE");

        FINEFOANGLE.configure(this, 21, 0, "RO", 1, 'b00000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TDOFFSETSTAT1_rd_cg";
        FINEFOANGLE_rd : coverpoint FINEFOANGLE.value[20:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TDOFFSETSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FDTOFFSETSTAT0
//--------------------------------------------------------------------
class FDTOFFSETSTAT0 extends uvm_reg;
    `uvm_object_utils(FDTOFFSETSTAT0)
    rand uvm_reg_field STOSLOPESTAT;
    rand uvm_reg_field TDSYNCHOFFSTAT;

    //---build------------------------------------------------------------
    virtual function void build();
        STOSLOPESTAT = uvm_reg_field::type_id::create("STOSLOPESTAT");
        TDSYNCHOFFSTAT = uvm_reg_field::type_id::create("TDSYNCHOFFSTAT");

        STOSLOPESTAT.configure(this, 22, 8, "RO", 1, 'b000000000000000000000, 1, 1, 1);
        TDSYNCHOFFSTAT.configure(this, 6, 0, "RO", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FDTOFFSETSTAT0_rd_cg";
        STOSLOPESTAT_rd : coverpoint STOSLOPESTAT.value[21:0];
        TDSYNCHOFFSTAT_rd : coverpoint TDSYNCHOFFSTAT.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FDTOFFSETSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FDTOFFSETSTAT1
//--------------------------------------------------------------------
class FDTOFFSETSTAT1 extends uvm_reg;
    `uvm_object_utils(FDTOFFSETSTAT1)
    rand uvm_reg_field CPESLOPESTAT;

    //---build------------------------------------------------------------
    virtual function void build();
        CPESLOPESTAT = uvm_reg_field::type_id::create("CPESLOPESTAT");

        CPESLOPESTAT.configure(this, 22, 0, "RO", 1, 'b000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FDTOFFSETSTAT1_rd_cg";
        CPESLOPESTAT_rd : coverpoint CPESLOPESTAT.value[21:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FDTOFFSETSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TBESTAT
//--------------------------------------------------------------------
class TBESTAT extends uvm_reg;
    `uvm_object_utils(TBESTAT)
    rand uvm_reg_field TBEMaxCorrValSum;
    rand uvm_reg_field TBECOUNT;

    //---build------------------------------------------------------------
    virtual function void build();
        TBEMaxCorrValSum = uvm_reg_field::type_id::create("TBEMaxCorrValSum");
        TBECOUNT = uvm_reg_field::type_id::create("TBECOUNT");

        TBEMaxCorrValSum.configure(this, 13, 8, "RO", 1, 'b000000000000, 1, 1, 1);
        TBECOUNT.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TBESTAT_rd_cg";
        TBEMaxCorrValSum_rd : coverpoint TBEMaxCorrValSum.value[12:0];
        TBECOUNT_rd : coverpoint TBECOUNT.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TBESTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BFMERSTAT0
//--------------------------------------------------------------------
class BFMERSTAT0 extends uvm_reg;
    `uvm_object_utils(BFMERSTAT0)
    rand uvm_reg_field BFMERMemSize;

    //---build------------------------------------------------------------
    virtual function void build();
        BFMERMemSize = uvm_reg_field::type_id::create("BFMERMemSize");

        BFMERMemSize.configure(this, 5, 0, "RO", 1, 'b0000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_BFMERSTAT0_rd_cg";
        BFMERMemSize_rd : coverpoint BFMERMemSize.value[4:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BFMERSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EQUALSTAT0
//--------------------------------------------------------------------
class EQUALSTAT0 extends uvm_reg;
    `uvm_object_utils(EQUALSTAT0)
    rand uvm_reg_field MHSTAT;

    //---build------------------------------------------------------------
    virtual function void build();
        MHSTAT = uvm_reg_field::type_id::create("MHSTAT");

        MHSTAT.configure(this, 28, 0, "RO", 1, 'b000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_EQUALSTAT0_rd_cg";
        MHSTAT_rd : coverpoint MHSTAT.value[27:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EQUALSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EQUALSTAT1
//--------------------------------------------------------------------
class EQUALSTAT1 extends uvm_reg;
    `uvm_object_utils(EQUALSTAT1)
    rand uvm_reg_field MHSCMAXSTAT;

    //---build------------------------------------------------------------
    virtual function void build();
        MHSCMAXSTAT = uvm_reg_field::type_id::create("MHSCMAXSTAT");

        MHSCMAXSTAT.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_EQUALSTAT1_rd_cg";
        MHSCMAXSTAT_rd : coverpoint MHSCMAXSTAT.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EQUALSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HDMVERSION
//--------------------------------------------------------------------
class HDMVERSION extends uvm_reg;
    `uvm_object_utils(HDMVERSION)
    rand uvm_reg_field MajorVersion;
    rand uvm_reg_field MinorVersion;
    rand uvm_reg_field Rel;

    //---build------------------------------------------------------------
    virtual function void build();
        MajorVersion = uvm_reg_field::type_id::create("MajorVersion");
        MinorVersion = uvm_reg_field::type_id::create("MinorVersion");
        Rel = uvm_reg_field::type_id::create("Rel");

        MajorVersion.configure(this, 8, 24, "RO", 1, 'b0000001, 1, 1, 1);
        MinorVersion.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        Rel.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HDMVERSION_rd_cg";
        MajorVersion_rd : coverpoint MajorVersion.value[7:0];
        MinorVersion_rd : coverpoint MinorVersion.value[7:0];
        Rel_rd : coverpoint Rel.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HDMVERSION");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HDMCONFIG2
//--------------------------------------------------------------------
class HDMCONFIG2 extends uvm_reg;
    `uvm_object_utils(HDMCONFIG2)
    rand uvm_reg_field QAM256;
    rand uvm_reg_field QAM1024;

    //---build------------------------------------------------------------
    virtual function void build();
        QAM256 = uvm_reg_field::type_id::create("QAM256");
        QAM1024 = uvm_reg_field::type_id::create("QAM1024");

        QAM256.configure(this, 1, 1, "RO", 1, `RW_MDM_256QAM_EN, 1, 1, 1);
        QAM1024.configure(this, 1, 0, "RO", 1, `RW_MDM_1024QAM_EN, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HDMCONFIG2_rd_cg";
        QAM256_rd : coverpoint QAM256.value[0:0];
        QAM1024_rd : coverpoint QAM1024.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HDMCONFIG2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FDTOFFSETSTAT2
//--------------------------------------------------------------------
class FDTOFFSETSTAT2 extends uvm_reg;
    `uvm_object_utils(FDTOFFSETSTAT2)
    rand uvm_reg_field FDOPREAMBSTAT;

    //---build------------------------------------------------------------
    virtual function void build();
        FDOPREAMBSTAT = uvm_reg_field::type_id::create("FDOPREAMBSTAT");

        FDOPREAMBSTAT.configure(this, 22, 0, "RO", 1, 'b000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FDTOFFSETSTAT2_rd_cg";
        FDOPREAMBSTAT_rd : coverpoint FDOPREAMBSTAT.value[21:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FDTOFFSETSTAT2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FDTOFFSETSTAT3
//--------------------------------------------------------------------
class FDTOFFSETSTAT3 extends uvm_reg;
    `uvm_object_utils(FDTOFFSETSTAT3)
    rand uvm_reg_field FDODATASTAT;

    //---build------------------------------------------------------------
    virtual function void build();
        FDODATASTAT = uvm_reg_field::type_id::create("FDODATASTAT");

        FDODATASTAT.configure(this, 22, 0, "RO", 1, 'b000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FDTOFFSETSTAT3_rd_cg";
        FDODATASTAT_rd : coverpoint FDODATASTAT.value[21:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FDTOFFSETSTAT3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXCFOEST
//--------------------------------------------------------------------
class RXCFOEST extends uvm_reg;
    `uvm_object_utils(RXCFOEST)
    rand uvm_reg_field RXCFOPHASEEST;

    //---build------------------------------------------------------------
    virtual function void build();
        RXCFOPHASEEST = uvm_reg_field::type_id::create("RXCFOPHASEEST");

        RXCFOPHASEEST.configure(this, 25, 0, "RO", 1, 'b000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCFOEST_rd_cg";
        RXCFOPHASEEST_rd : coverpoint RXCFOPHASEEST.value[24:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXCFOEST");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXSFOEST
//--------------------------------------------------------------------
class RXSFOEST extends uvm_reg;
    `uvm_object_utils(RXSFOEST)
    rand uvm_reg_field RXFSRATIOOOR;
    rand uvm_reg_field RXSFOFSRATIOEST;

    //---build------------------------------------------------------------
    virtual function void build();
        RXFSRATIOOOR = uvm_reg_field::type_id::create("RXFSRATIOOOR");
        RXSFOFSRATIOEST = uvm_reg_field::type_id::create("RXSFOFSRATIOEST");

        RXFSRATIOOOR.configure(this, 1, 28, "RO", 1, 'b0, 1, 1, 1);
        RXSFOFSRATIOEST.configure(this, 27, 0, "RO", 1, 'b00000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXSFOEST_rd_cg";
        RXFSRATIOOOR_rd : coverpoint RXFSRATIOOOR.value[0:0];
        RXSFOFSRATIOEST_rd : coverpoint RXSFOFSRATIOEST.value[26:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXSFOEST");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXNSRSTAT
//--------------------------------------------------------------------
class RXNSRSTAT extends uvm_reg;
    `uvm_object_utils(RXNSRSTAT)
    rand uvm_reg_field NSREXP;
    rand uvm_reg_field NSRMANT;

    //---build------------------------------------------------------------
    virtual function void build();
        NSREXP = uvm_reg_field::type_id::create("NSREXP");
        NSRMANT = uvm_reg_field::type_id::create("NSRMANT");

        NSREXP.configure(this, 6, 16, "RO", 1, 'b00000, 1, 1, 1);
        NSRMANT.configure(this, 12, 0, "RO", 1, 'b00000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXNSRSTAT_rd_cg";
        NSREXP_rd : coverpoint NSREXP.value[5:0];
        NSRMANT_rd : coverpoint NSRMANT.value[11:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXNSRSTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LDPCDECSTAT0
//--------------------------------------------------------------------
class LDPCDECSTAT0 extends uvm_reg;
    `uvm_object_utils(LDPCDECSTAT0)
    rand uvm_reg_field LDPCFFTOVCOUNT;
    rand uvm_reg_field LDPCCOUNT;

    //---build------------------------------------------------------------
    virtual function void build();
        LDPCFFTOVCOUNT = uvm_reg_field::type_id::create("LDPCFFTOVCOUNT");
        LDPCCOUNT = uvm_reg_field::type_id::create("LDPCCOUNT");

        LDPCFFTOVCOUNT.configure(this, 16, 16, "RO", 1, 'b000000000000000, 1, 1, 1);
        LDPCCOUNT.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_LDPCDECSTAT0_rd_cg";
        LDPCFFTOVCOUNT_rd : coverpoint LDPCFFTOVCOUNT.value[15:0];
        LDPCCOUNT_rd : coverpoint LDPCCOUNT.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LDPCDECSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FEBCNTL
//--------------------------------------------------------------------
class FEBCNTL extends uvm_reg;
    `uvm_object_utils(FEBCNTL)
    rand uvm_reg_field MAXSTAGE;
    rand uvm_reg_field FIRDISB;
    rand uvm_reg_field GAINDISB;
    rand uvm_reg_field INTERPDISB;
    rand uvm_reg_field FIRCOEFSEL;

    //---build------------------------------------------------------------
    virtual function void build();
        MAXSTAGE = uvm_reg_field::type_id::create("MAXSTAGE");
        FIRDISB = uvm_reg_field::type_id::create("FIRDISB");
        GAINDISB = uvm_reg_field::type_id::create("GAINDISB");
        INTERPDISB = uvm_reg_field::type_id::create("INTERPDISB");
        FIRCOEFSEL = uvm_reg_field::type_id::create("FIRCOEFSEL");

        MAXSTAGE.configure(this, 6, 16, "RW", 1, 'b100111, 1, 1, 1);
        FIRDISB.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        GAINDISB.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        INTERPDISB.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        FIRCOEFSEL.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FEBCNTL_wr_cg";
        MAXSTAGE_wr : coverpoint MAXSTAGE.value[5:0];
        FIRDISB_wr : coverpoint FIRDISB.value[0:0];
        GAINDISB_wr : coverpoint GAINDISB.value[0:0];
        INTERPDISB_wr : coverpoint INTERPDISB.value[0:0];
        FIRCOEFSEL_wr : coverpoint FIRCOEFSEL.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FEBCNTL_rd_cg";
        MAXSTAGE_rd : coverpoint MAXSTAGE.value[5:0];
        FIRDISB_rd : coverpoint FIRDISB.value[0:0];
        GAINDISB_rd : coverpoint GAINDISB.value[0:0];
        INTERPDISB_rd : coverpoint INTERPDISB.value[0:0];
        FIRCOEFSEL_rd : coverpoint FIRCOEFSEL.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FEBCNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBCNTL
//--------------------------------------------------------------------
class MDMBCNTL extends uvm_reg;
    `uvm_object_utils(MDMBCNTL)
    rand uvm_reg_field IQMMDISB;
    rand uvm_reg_field PRECOMPDISB;
    rand uvm_reg_field DCOFFDISB;
    rand uvm_reg_field COMPDISB;
    rand uvm_reg_field EQDISB;
    rand uvm_reg_field SPREADDISB;
    rand uvm_reg_field SCRAMBDISB;
    rand uvm_reg_field SFDERR;
    rand uvm_reg_field SFDLEN;
    rand uvm_reg_field PREPRE;

    //---build------------------------------------------------------------
    virtual function void build();
        IQMMDISB = uvm_reg_field::type_id::create("IQMMDISB");
        PRECOMPDISB = uvm_reg_field::type_id::create("PRECOMPDISB");
        DCOFFDISB = uvm_reg_field::type_id::create("DCOFFDISB");
        COMPDISB = uvm_reg_field::type_id::create("COMPDISB");
        EQDISB = uvm_reg_field::type_id::create("EQDISB");
        SPREADDISB = uvm_reg_field::type_id::create("SPREADDISB");
        SCRAMBDISB = uvm_reg_field::type_id::create("SCRAMBDISB");
        SFDERR = uvm_reg_field::type_id::create("SFDERR");
        SFDLEN = uvm_reg_field::type_id::create("SFDLEN");
        PREPRE = uvm_reg_field::type_id::create("PREPRE");

        IQMMDISB.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        PRECOMPDISB.configure(this, 1, 26, "RW", 1, 'b0, 1, 1, 1);
        DCOFFDISB.configure(this, 1, 25, "RW", 1, 'b0, 1, 1, 1);
        COMPDISB.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        EQDISB.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        SPREADDISB.configure(this, 1, 21, "RW", 1, 'b0, 1, 1, 1);
        SCRAMBDISB.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        SFDERR.configure(this, 3, 12, "RW", 1, 'b00, 1, 1, 1);
        SFDLEN.configure(this, 3, 8, "RW", 1, 'b00, 1, 1, 1);
        PREPRE.configure(this, 6, 0, "RW", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBCNTL_wr_cg";
        IQMMDISB_wr : coverpoint IQMMDISB.value[0:0];
        PRECOMPDISB_wr : coverpoint PRECOMPDISB.value[0:0];
        DCOFFDISB_wr : coverpoint DCOFFDISB.value[0:0];
        COMPDISB_wr : coverpoint COMPDISB.value[0:0];
        EQDISB_wr : coverpoint EQDISB.value[0:0];
        SPREADDISB_wr : coverpoint SPREADDISB.value[0:0];
        SCRAMBDISB_wr : coverpoint SCRAMBDISB.value[0:0];
        SFDERR_wr : coverpoint SFDERR.value[2:0];
        SFDLEN_wr : coverpoint SFDLEN.value[2:0];
        PREPRE_wr : coverpoint PREPRE.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBCNTL_rd_cg";
        IQMMDISB_rd : coverpoint IQMMDISB.value[0:0];
        PRECOMPDISB_rd : coverpoint PRECOMPDISB.value[0:0];
        DCOFFDISB_rd : coverpoint DCOFFDISB.value[0:0];
        COMPDISB_rd : coverpoint COMPDISB.value[0:0];
        EQDISB_rd : coverpoint EQDISB.value[0:0];
        SPREADDISB_rd : coverpoint SPREADDISB.value[0:0];
        SCRAMBDISB_rd : coverpoint SCRAMBDISB.value[0:0];
        SFDERR_rd : coverpoint SFDERR.value[2:0];
        SFDLEN_rd : coverpoint SFDLEN.value[2:0];
        PREPRE_rd : coverpoint PREPRE.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBCNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBPRMINIT
//--------------------------------------------------------------------
class MDMBPRMINIT extends uvm_reg;
    `uvm_object_utils(MDMBPRMINIT)
    rand uvm_reg_field RHO;
    rand uvm_reg_field MU;
    rand uvm_reg_field BETA;
    rand uvm_reg_field ALPHA;

    //---build------------------------------------------------------------
    virtual function void build();
        RHO = uvm_reg_field::type_id::create("RHO");
        MU = uvm_reg_field::type_id::create("MU");
        BETA = uvm_reg_field::type_id::create("BETA");
        ALPHA = uvm_reg_field::type_id::create("ALPHA");

        RHO.configure(this, 2, 20, "RW", 1, 'b0, 1, 1, 1);
        MU.configure(this, 2, 16, "RW", 1, 'b1, 1, 1, 1);
        BETA.configure(this, 2, 4, "RW", 1, 'b10, 1, 1, 1);
        ALPHA.configure(this, 2, 0, "RW", 1, 'b10, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBPRMINIT_wr_cg";
        RHO_wr : coverpoint RHO.value[1:0];
        MU_wr : coverpoint MU.value[1:0];
        BETA_wr : coverpoint BETA.value[1:0];
        ALPHA_wr : coverpoint ALPHA.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBPRMINIT_rd_cg";
        RHO_rd : coverpoint RHO.value[1:0];
        MU_rd : coverpoint MU.value[1:0];
        BETA_rd : coverpoint BETA.value[1:0];
        ALPHA_rd : coverpoint ALPHA.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBPRMINIT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBTALPHA
//--------------------------------------------------------------------
class MDMBTALPHA extends uvm_reg;
    `uvm_object_utils(MDMBTALPHA)
    rand uvm_reg_field TALPHA3;
    rand uvm_reg_field TALPHA2;
    rand uvm_reg_field TALPHA1;
    rand uvm_reg_field TALPHA0;

    //---build------------------------------------------------------------
    virtual function void build();
        TALPHA3 = uvm_reg_field::type_id::create("TALPHA3");
        TALPHA2 = uvm_reg_field::type_id::create("TALPHA2");
        TALPHA1 = uvm_reg_field::type_id::create("TALPHA1");
        TALPHA0 = uvm_reg_field::type_id::create("TALPHA0");

        TALPHA3.configure(this, 4, 12, "RW", 1, 'b110, 1, 1, 1);
        TALPHA2.configure(this, 4, 8, "RW", 1, 'b010, 1, 1, 1);
        TALPHA1.configure(this, 4, 4, "RW", 1, 'b011, 1, 1, 1);
        TALPHA0.configure(this, 4, 0, "RW", 1, 'b110, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBTALPHA_wr_cg";
        TALPHA3_wr : coverpoint TALPHA3.value[3:0];
        TALPHA2_wr : coverpoint TALPHA2.value[3:0];
        TALPHA1_wr : coverpoint TALPHA1.value[3:0];
        TALPHA0_wr : coverpoint TALPHA0.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBTALPHA_rd_cg";
        TALPHA3_rd : coverpoint TALPHA3.value[3:0];
        TALPHA2_rd : coverpoint TALPHA2.value[3:0];
        TALPHA1_rd : coverpoint TALPHA1.value[3:0];
        TALPHA0_rd : coverpoint TALPHA0.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBTALPHA");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBTBETA
//--------------------------------------------------------------------
class MDMBTBETA extends uvm_reg;
    `uvm_object_utils(MDMBTBETA)
    rand uvm_reg_field TBETA3;
    rand uvm_reg_field TBETA2;
    rand uvm_reg_field TBETA1;
    rand uvm_reg_field TBETA0;

    //---build------------------------------------------------------------
    virtual function void build();
        TBETA3 = uvm_reg_field::type_id::create("TBETA3");
        TBETA2 = uvm_reg_field::type_id::create("TBETA2");
        TBETA1 = uvm_reg_field::type_id::create("TBETA1");
        TBETA0 = uvm_reg_field::type_id::create("TBETA0");

        TBETA3.configure(this, 4, 12, "RW", 1, 'b110, 1, 1, 1);
        TBETA2.configure(this, 4, 8, "RW", 1, 'b010, 1, 1, 1);
        TBETA1.configure(this, 4, 4, "RW", 1, 'b011, 1, 1, 1);
        TBETA0.configure(this, 4, 0, "RW", 1, 'b110, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBTBETA_wr_cg";
        TBETA3_wr : coverpoint TBETA3.value[3:0];
        TBETA2_wr : coverpoint TBETA2.value[3:0];
        TBETA1_wr : coverpoint TBETA1.value[3:0];
        TBETA0_wr : coverpoint TBETA0.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBTBETA_rd_cg";
        TBETA3_rd : coverpoint TBETA3.value[3:0];
        TBETA2_rd : coverpoint TBETA2.value[3:0];
        TBETA1_rd : coverpoint TBETA1.value[3:0];
        TBETA0_rd : coverpoint TBETA0.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBTBETA");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBTMU
//--------------------------------------------------------------------
class MDMBTMU extends uvm_reg;
    `uvm_object_utils(MDMBTMU)
    rand uvm_reg_field TMU3;
    rand uvm_reg_field TMU2;
    rand uvm_reg_field TMU1;
    rand uvm_reg_field TMU0;

    //---build------------------------------------------------------------
    virtual function void build();
        TMU3 = uvm_reg_field::type_id::create("TMU3");
        TMU2 = uvm_reg_field::type_id::create("TMU2");
        TMU1 = uvm_reg_field::type_id::create("TMU1");
        TMU0 = uvm_reg_field::type_id::create("TMU0");

        TMU3.configure(this, 4, 12, "RW", 1, 'b101, 1, 1, 1);
        TMU2.configure(this, 4, 8, "RW", 1, 'b101, 1, 1, 1);
        TMU1.configure(this, 4, 4, "RW", 1, 'b101, 1, 1, 1);
        TMU0.configure(this, 4, 0, "RW", 1, 'b101, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBTMU_wr_cg";
        TMU3_wr : coverpoint TMU3.value[3:0];
        TMU2_wr : coverpoint TMU2.value[3:0];
        TMU1_wr : coverpoint TMU1.value[3:0];
        TMU0_wr : coverpoint TMU0.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBTMU_rd_cg";
        TMU3_rd : coverpoint TMU3.value[3:0];
        TMU2_rd : coverpoint TMU2.value[3:0];
        TMU1_rd : coverpoint TMU1.value[3:0];
        TMU0_rd : coverpoint TMU0.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBTMU");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBCNTL1
//--------------------------------------------------------------------
class MDMBCNTL1 extends uvm_reg;
    `uvm_object_utils(MDMBCNTL1)
    rand uvm_reg_field RXLENCHKEN;
    rand uvm_reg_field RXMAXLENGTH;

    //---build------------------------------------------------------------
    virtual function void build();
        RXLENCHKEN = uvm_reg_field::type_id::create("RXLENCHKEN");
        RXMAXLENGTH = uvm_reg_field::type_id::create("RXMAXLENGTH");

        RXLENCHKEN.configure(this, 1, 12, "RW", 1, 'b1, 1, 1, 1);
        RXMAXLENGTH.configure(this, 12, 0, "RW", 1, 'b100100101010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBCNTL1_wr_cg";
        RXLENCHKEN_wr : coverpoint RXLENCHKEN.value[0:0];
        RXMAXLENGTH_wr : coverpoint RXMAXLENGTH.value[11:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBCNTL1_rd_cg";
        RXLENCHKEN_rd : coverpoint RXLENCHKEN.value[0:0];
        RXMAXLENGTH_rd : coverpoint RXMAXLENGTH.value[11:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBCNTL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBRFCNTL
//--------------------------------------------------------------------
class MDMBRFCNTL extends uvm_reg;
    `uvm_object_utils(MDMBRFCNTL)
    rand uvm_reg_field TXENDDEL;

    //---build------------------------------------------------------------
    virtual function void build();
        TXENDDEL = uvm_reg_field::type_id::create("TXENDDEL");

        TXENDDEL.configure(this, 8, 0, "RW", 1, 'b0110000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBRFCNTL_wr_cg";
        TXENDDEL_wr : coverpoint TXENDDEL.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBRFCNTL_rd_cg";
        TXENDDEL_rd : coverpoint TXENDDEL.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBRFCNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBEQCNTL
//--------------------------------------------------------------------
class MDMBEQCNTL extends uvm_reg;
    `uvm_object_utils(MDMBEQCNTL)
    rand uvm_reg_field EQHOLD;
    rand uvm_reg_field COMPTIME;
    rand uvm_reg_field ESTTIME;
    rand uvm_reg_field EQTIME;

    //---build------------------------------------------------------------
    virtual function void build();
        EQHOLD = uvm_reg_field::type_id::create("EQHOLD");
        COMPTIME = uvm_reg_field::type_id::create("COMPTIME");
        ESTTIME = uvm_reg_field::type_id::create("ESTTIME");
        EQTIME = uvm_reg_field::type_id::create("EQTIME");

        EQHOLD.configure(this, 12, 16, "RW", 1, 'b111111111111, 1, 1, 1);
        COMPTIME.configure(this, 5, 10, "RW", 1, 'b0000, 1, 1, 1);
        ESTTIME.configure(this, 5, 5, "RW", 1, 'b0000, 1, 1, 1);
        EQTIME.configure(this, 4, 0, "RW", 1, 'b001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBEQCNTL_wr_cg";
        EQHOLD_wr : coverpoint EQHOLD.value[11:0];
        COMPTIME_wr : coverpoint COMPTIME.value[4:0];
        ESTTIME_wr : coverpoint ESTTIME.value[4:0];
        EQTIME_wr : coverpoint EQTIME.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBEQCNTL_rd_cg";
        EQHOLD_rd : coverpoint EQHOLD.value[11:0];
        COMPTIME_rd : coverpoint COMPTIME.value[4:0];
        ESTTIME_rd : coverpoint ESTTIME.value[4:0];
        EQTIME_rd : coverpoint EQTIME.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBEQCNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBCNTL2
//--------------------------------------------------------------------
class MDMBCNTL2 extends uvm_reg;
    `uvm_object_utils(MDMBCNTL2)
    rand uvm_reg_field PRECOMP;
    rand uvm_reg_field SYNCTIME;
    rand uvm_reg_field LOOPTIME;

    //---build------------------------------------------------------------
    virtual function void build();
        PRECOMP = uvm_reg_field::type_id::create("PRECOMP");
        SYNCTIME = uvm_reg_field::type_id::create("SYNCTIME");
        LOOPTIME = uvm_reg_field::type_id::create("LOOPTIME");

        PRECOMP.configure(this, 6, 16, "RW", 1, 'b111000, 1, 1, 1);
        SYNCTIME.configure(this, 6, 8, "RW", 1, 'b10010, 1, 1, 1);
        LOOPTIME.configure(this, 4, 0, "RW", 1, 'b101, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBCNTL2_wr_cg";
        PRECOMP_wr : coverpoint PRECOMP.value[5:0];
        SYNCTIME_wr : coverpoint SYNCTIME.value[5:0];
        LOOPTIME_wr : coverpoint LOOPTIME.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBCNTL2_rd_cg";
        PRECOMP_rd : coverpoint PRECOMP.value[5:0];
        SYNCTIME_rd : coverpoint SYNCTIME.value[5:0];
        LOOPTIME_rd : coverpoint LOOPTIME.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBCNTL2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBSTAT0
//--------------------------------------------------------------------
class MDMBSTAT0 extends uvm_reg;
    `uvm_object_utils(MDMBSTAT0)
    rand uvm_reg_field EQSUMQ;
    rand uvm_reg_field EQSUMI;
    rand uvm_reg_field DCOFFSETQ;
    rand uvm_reg_field DCOFFSETI;

    //---build------------------------------------------------------------
    virtual function void build();
        EQSUMQ = uvm_reg_field::type_id::create("EQSUMQ");
        EQSUMI = uvm_reg_field::type_id::create("EQSUMI");
        DCOFFSETQ = uvm_reg_field::type_id::create("DCOFFSETQ");
        DCOFFSETI = uvm_reg_field::type_id::create("DCOFFSETI");

        EQSUMQ.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        EQSUMI.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        DCOFFSETQ.configure(this, 6, 8, "RO", 1, 'b00000, 1, 1, 1);
        DCOFFSETI.configure(this, 6, 0, "RO", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBSTAT0_rd_cg";
        EQSUMQ_rd : coverpoint EQSUMQ.value[7:0];
        EQSUMI_rd : coverpoint EQSUMI.value[7:0];
        DCOFFSETQ_rd : coverpoint DCOFFSETQ.value[5:0];
        DCOFFSETI_rd : coverpoint DCOFFSETI.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBSTAT1
//--------------------------------------------------------------------
class MDMBSTAT1 extends uvm_reg;
    `uvm_object_utils(MDMBSTAT1)
    rand uvm_reg_field RXERRORSTAT;
    rand uvm_reg_field EVM;
    rand uvm_reg_field IQGAINESTIM;
    rand uvm_reg_field FREQOFFESTIM;

    //---build------------------------------------------------------------
    virtual function void build();
        RXERRORSTAT = uvm_reg_field::type_id::create("RXERRORSTAT");
        EVM = uvm_reg_field::type_id::create("EVM");
        IQGAINESTIM = uvm_reg_field::type_id::create("IQGAINESTIM");
        FREQOFFESTIM = uvm_reg_field::type_id::create("FREQOFFESTIM");

        RXERRORSTAT.configure(this, 2, 30, "RO", 1, 'b0, 1, 1, 1);
        EVM.configure(this, 13, 16, "RO", 1, 'b000000000000, 1, 1, 1);
        IQGAINESTIM.configure(this, 7, 8, "RO", 1, 'b000000, 1, 1, 1);
        FREQOFFESTIM.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMBSTAT1_rd_cg";
        RXERRORSTAT_rd : coverpoint RXERRORSTAT.value[1:0];
        EVM_rd : coverpoint EVM.value[12:0];
        IQGAINESTIM_rd : coverpoint IQGAINESTIM.value[6:0];
        FREQOFFESTIM_rd : coverpoint FREQOFFESTIM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMCONF
//--------------------------------------------------------------------
class MDMCONF extends uvm_reg;
    `uvm_object_utils(MDMCONF)
    rand uvm_reg_field CONF_NRX;
    rand uvm_reg_field CONF_NTX;
    rand uvm_reg_field CONF_BW;

    //---build------------------------------------------------------------
    virtual function void build();
        CONF_NRX = uvm_reg_field::type_id::create("CONF_NRX");
        CONF_NTX = uvm_reg_field::type_id::create("CONF_NTX");
        CONF_BW = uvm_reg_field::type_id::create("CONF_BW");

        CONF_NRX.configure(this, 4, 8, "RW", 1, 'b000, 1, 1, 1);
        CONF_NTX.configure(this, 4, 4, "RW", 1, 'b000, 1, 1, 1);
        CONF_BW.configure(this, 4, 0, "RW", 1, 'b000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMCONF_wr_cg";
        CONF_NRX_wr : coverpoint CONF_NRX.value[3:0];
        CONF_NTX_wr : coverpoint CONF_NTX.value[3:0];
        CONF_BW_wr : coverpoint CONF_BW.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MDMCONF_rd_cg";
        CONF_NRX_rd : coverpoint CONF_NRX.value[3:0];
        CONF_NTX_rd : coverpoint CONF_NTX.value[3:0];
        CONF_BW_rd : coverpoint CONF_BW.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMCONF");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXTDCTRL0
//--------------------------------------------------------------------
class RXTDCTRL0 extends uvm_reg;
    `uvm_object_utils(RXTDCTRL0)
    rand uvm_reg_field TDSYNCOFF20;
    rand uvm_reg_field TDSYNCOFF2080;
    rand uvm_reg_field TDSYNCOFF2040;

    //---build------------------------------------------------------------
    virtual function void build();
        TDSYNCOFF20 = uvm_reg_field::type_id::create("TDSYNCOFF20");
        TDSYNCOFF2080 = uvm_reg_field::type_id::create("TDSYNCOFF2080");
        TDSYNCOFF2040 = uvm_reg_field::type_id::create("TDSYNCOFF2040");

        TDSYNCOFF20.configure(this, 8, 24, "RW", 1, 'b0011001, 1, 1, 1);
        TDSYNCOFF2080.configure(this, 8, 8, "RW", 1, 'b11101010, 1, 1, 1);
        TDSYNCOFF2040.configure(this, 8, 0, "RW", 1, 'b0001101, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXTDCTRL0_wr_cg";
        TDSYNCOFF20_wr : coverpoint TDSYNCOFF20.value[7:0];
        TDSYNCOFF2080_wr : coverpoint TDSYNCOFF2080.value[7:0];
        TDSYNCOFF2040_wr : coverpoint TDSYNCOFF2040.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXTDCTRL0_rd_cg";
        TDSYNCOFF20_rd : coverpoint TDSYNCOFF20.value[7:0];
        TDSYNCOFF2080_rd : coverpoint TDSYNCOFF2080.value[7:0];
        TDSYNCOFF2040_rd : coverpoint TDSYNCOFF2040.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXTDCTRL0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FDOCTRL0
//--------------------------------------------------------------------
class FDOCTRL0 extends uvm_reg;
    `uvm_object_utils(FDOCTRL0)
    rand uvm_reg_field CFGSTO4TDCOMP;
    rand uvm_reg_field CFGCPEWALK;
    rand uvm_reg_field CFGSTOREF;
    rand uvm_reg_field CFGCPEREF;
    rand uvm_reg_field CPESLOPELGHT;
    rand uvm_reg_field STOSLOPELGHT;
    rand uvm_reg_field CPEMODE;
    rand uvm_reg_field STOMODE;
    rand uvm_reg_field STOCOMPTIME;
    rand uvm_reg_field MAXNTDSYNCHOFF;
    rand uvm_reg_field MAXPTDSYNCHOFF;
    rand uvm_reg_field STOFDCOMPEN;
    rand uvm_reg_field CPESLOPEESTEN;
    rand uvm_reg_field CPEFDCOMPEN;
    rand uvm_reg_field STOSLOPEESTEN;
    rand uvm_reg_field STOTDCOMPEN;

    //---build------------------------------------------------------------
    virtual function void build();
        CFGSTO4TDCOMP = uvm_reg_field::type_id::create("CFGSTO4TDCOMP");
        CFGCPEWALK = uvm_reg_field::type_id::create("CFGCPEWALK");
        CFGSTOREF = uvm_reg_field::type_id::create("CFGSTOREF");
        CFGCPEREF = uvm_reg_field::type_id::create("CFGCPEREF");
        CPESLOPELGHT = uvm_reg_field::type_id::create("CPESLOPELGHT");
        STOSLOPELGHT = uvm_reg_field::type_id::create("STOSLOPELGHT");
        CPEMODE = uvm_reg_field::type_id::create("CPEMODE");
        STOMODE = uvm_reg_field::type_id::create("STOMODE");
        STOCOMPTIME = uvm_reg_field::type_id::create("STOCOMPTIME");
        MAXNTDSYNCHOFF = uvm_reg_field::type_id::create("MAXNTDSYNCHOFF");
        MAXPTDSYNCHOFF = uvm_reg_field::type_id::create("MAXPTDSYNCHOFF");
        STOFDCOMPEN = uvm_reg_field::type_id::create("STOFDCOMPEN");
        CPESLOPEESTEN = uvm_reg_field::type_id::create("CPESLOPEESTEN");
        CPEFDCOMPEN = uvm_reg_field::type_id::create("CPEFDCOMPEN");
        STOSLOPEESTEN = uvm_reg_field::type_id::create("STOSLOPEESTEN");
        STOTDCOMPEN = uvm_reg_field::type_id::create("STOTDCOMPEN");

        CFGSTO4TDCOMP.configure(this, 1, 31, "RW", 1, 'b1, 1, 1, 1);
        CFGCPEWALK.configure(this, 1, 30, "RW", 1, 'b1, 1, 1, 1);
        CFGSTOREF.configure(this, 1, 29, "RW", 1, 'b1, 1, 1, 1);
        CFGCPEREF.configure(this, 1, 28, "RW", 1, 'b1, 1, 1, 1);
        CPESLOPELGHT.configure(this, 1, 25, "RW", 1, 'b1, 1, 1, 1);
        STOSLOPELGHT.configure(this, 1, 24, "RW", 1, 'b1, 1, 1, 1);
        CPEMODE.configure(this, 1, 23, "RW", 1, 'b1, 1, 1, 1);
        STOMODE.configure(this, 1, 22, "RW", 1, 'b1, 1, 1, 1);
        STOCOMPTIME.configure(this, 5, 17, "RW", 1, 'b0000, 1, 1, 1);
        MAXNTDSYNCHOFF.configure(this, 6, 11, "RW", 1, 'b11111, 1, 1, 1);
        MAXPTDSYNCHOFF.configure(this, 6, 5, "RW", 1, 'b11111, 1, 1, 1);
        STOFDCOMPEN.configure(this, 1, 4, "RW", 1, 'b1, 1, 1, 1);
        CPESLOPEESTEN.configure(this, 1, 3, "RW", 1, 'b1, 1, 1, 1);
        CPEFDCOMPEN.configure(this, 1, 2, "RW", 1, 'b1, 1, 1, 1);
        STOSLOPEESTEN.configure(this, 1, 1, "RW", 1, 'b1, 1, 1, 1);
        STOTDCOMPEN.configure(this, 1, 0, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FDOCTRL0_wr_cg";
        CFGSTO4TDCOMP_wr : coverpoint CFGSTO4TDCOMP.value[0:0];
        CFGCPEWALK_wr : coverpoint CFGCPEWALK.value[0:0];
        CFGSTOREF_wr : coverpoint CFGSTOREF.value[0:0];
        CFGCPEREF_wr : coverpoint CFGCPEREF.value[0:0];
        CPESLOPELGHT_wr : coverpoint CPESLOPELGHT.value[0:0];
        STOSLOPELGHT_wr : coverpoint STOSLOPELGHT.value[0:0];
        CPEMODE_wr : coverpoint CPEMODE.value[0:0];
        STOMODE_wr : coverpoint STOMODE.value[0:0];
        STOCOMPTIME_wr : coverpoint STOCOMPTIME.value[4:0];
        MAXNTDSYNCHOFF_wr : coverpoint MAXNTDSYNCHOFF.value[5:0];
        MAXPTDSYNCHOFF_wr : coverpoint MAXPTDSYNCHOFF.value[5:0];
        STOFDCOMPEN_wr : coverpoint STOFDCOMPEN.value[0:0];
        CPESLOPEESTEN_wr : coverpoint CPESLOPEESTEN.value[0:0];
        CPEFDCOMPEN_wr : coverpoint CPEFDCOMPEN.value[0:0];
        STOSLOPEESTEN_wr : coverpoint STOSLOPEESTEN.value[0:0];
        STOTDCOMPEN_wr : coverpoint STOTDCOMPEN.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FDOCTRL0_rd_cg";
        CFGSTO4TDCOMP_rd : coverpoint CFGSTO4TDCOMP.value[0:0];
        CFGCPEWALK_rd : coverpoint CFGCPEWALK.value[0:0];
        CFGSTOREF_rd : coverpoint CFGSTOREF.value[0:0];
        CFGCPEREF_rd : coverpoint CFGCPEREF.value[0:0];
        CPESLOPELGHT_rd : coverpoint CPESLOPELGHT.value[0:0];
        STOSLOPELGHT_rd : coverpoint STOSLOPELGHT.value[0:0];
        CPEMODE_rd : coverpoint CPEMODE.value[0:0];
        STOMODE_rd : coverpoint STOMODE.value[0:0];
        STOCOMPTIME_rd : coverpoint STOCOMPTIME.value[4:0];
        MAXNTDSYNCHOFF_rd : coverpoint MAXNTDSYNCHOFF.value[5:0];
        MAXPTDSYNCHOFF_rd : coverpoint MAXPTDSYNCHOFF.value[5:0];
        STOFDCOMPEN_rd : coverpoint STOFDCOMPEN.value[0:0];
        CPESLOPEESTEN_rd : coverpoint CPESLOPEESTEN.value[0:0];
        CPEFDCOMPEN_rd : coverpoint CPEFDCOMPEN.value[0:0];
        STOSLOPEESTEN_rd : coverpoint STOSLOPEESTEN.value[0:0];
        STOTDCOMPEN_rd : coverpoint STOTDCOMPEN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FDOCTRL0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FDOCTRL1
//--------------------------------------------------------------------
class FDOCTRL1 extends uvm_reg;
    `uvm_object_utils(FDOCTRL1)
    rand uvm_reg_field STOSLOPEFORCED;

    //---build------------------------------------------------------------
    virtual function void build();
        STOSLOPEFORCED = uvm_reg_field::type_id::create("STOSLOPEFORCED");

        STOSLOPEFORCED.configure(this, 22, 0, "RW", 1, 'b000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FDOCTRL1_wr_cg";
        STOSLOPEFORCED_wr : coverpoint STOSLOPEFORCED.value[21:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FDOCTRL1_rd_cg";
        STOSLOPEFORCED_rd : coverpoint STOSLOPEFORCED.value[21:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FDOCTRL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FDOCTRL2
//--------------------------------------------------------------------
class FDOCTRL2 extends uvm_reg;
    `uvm_object_utils(FDOCTRL2)
    rand uvm_reg_field CPESLOPEFORCED;

    //---build------------------------------------------------------------
    virtual function void build();
        CPESLOPEFORCED = uvm_reg_field::type_id::create("CPESLOPEFORCED");

        CPESLOPEFORCED.configure(this, 22, 0, "RW", 1, 'b000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FDOCTRL2_wr_cg";
        CPESLOPEFORCED_wr : coverpoint CPESLOPEFORCED.value[21:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_FDOCTRL2_rd_cg";
        CPESLOPEFORCED_rd : coverpoint CPESLOPEFORCED.value[21:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FDOCTRL2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EQUALCTRL0
//--------------------------------------------------------------------
class EQUALCTRL0 extends uvm_reg;
    `uvm_object_utils(EQUALCTRL0)
    rand uvm_reg_field FDDCWEIGHTP2;
    rand uvm_reg_field FDDCWEIGHTP1;
    rand uvm_reg_field FDDCWEIGHTM1;
    rand uvm_reg_field FDDCWEIGHTM2;
    rand uvm_reg_field NOISEVARADJUSTDB;
    rand uvm_reg_field FDDCSNRTHRESHOLD;
    rand uvm_reg_field FDDCCOMPEN;

    //---build------------------------------------------------------------
    virtual function void build();
        FDDCWEIGHTP2 = uvm_reg_field::type_id::create("FDDCWEIGHTP2");
        FDDCWEIGHTP1 = uvm_reg_field::type_id::create("FDDCWEIGHTP1");
        FDDCWEIGHTM1 = uvm_reg_field::type_id::create("FDDCWEIGHTM1");
        FDDCWEIGHTM2 = uvm_reg_field::type_id::create("FDDCWEIGHTM2");
        NOISEVARADJUSTDB = uvm_reg_field::type_id::create("NOISEVARADJUSTDB");
        FDDCSNRTHRESHOLD = uvm_reg_field::type_id::create("FDDCSNRTHRESHOLD");
        FDDCCOMPEN = uvm_reg_field::type_id::create("FDDCCOMPEN");

        FDDCWEIGHTP2.configure(this, 3, 29, "RW", 1, 'b10, 1, 1, 1);
        FDDCWEIGHTP1.configure(this, 3, 26, "RW", 1, 'b11, 1, 1, 1);
        FDDCWEIGHTM1.configure(this, 3, 23, "RW", 1, 'b11, 1, 1, 1);
        FDDCWEIGHTM2.configure(this, 3, 20, "RW", 1, 'b10, 1, 1, 1);
        NOISEVARADJUSTDB.configure(this, 8, 12, "RW", 1, 'b0000000, 1, 1, 1);
        FDDCSNRTHRESHOLD.configure(this, 8, 4, "RW", 1, 'b0011110, 1, 1, 1);
        FDDCCOMPEN.configure(this, 1, 3, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_EQUALCTRL0_wr_cg";
        FDDCWEIGHTP2_wr : coverpoint FDDCWEIGHTP2.value[2:0];
        FDDCWEIGHTP1_wr : coverpoint FDDCWEIGHTP1.value[2:0];
        FDDCWEIGHTM1_wr : coverpoint FDDCWEIGHTM1.value[2:0];
        FDDCWEIGHTM2_wr : coverpoint FDDCWEIGHTM2.value[2:0];
        NOISEVARADJUSTDB_wr : coverpoint NOISEVARADJUSTDB.value[7:0];
        FDDCSNRTHRESHOLD_wr : coverpoint FDDCSNRTHRESHOLD.value[7:0];
        FDDCCOMPEN_wr : coverpoint FDDCCOMPEN.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_EQUALCTRL0_rd_cg";
        FDDCWEIGHTP2_rd : coverpoint FDDCWEIGHTP2.value[2:0];
        FDDCWEIGHTP1_rd : coverpoint FDDCWEIGHTP1.value[2:0];
        FDDCWEIGHTM1_rd : coverpoint FDDCWEIGHTM1.value[2:0];
        FDDCWEIGHTM2_rd : coverpoint FDDCWEIGHTM2.value[2:0];
        NOISEVARADJUSTDB_rd : coverpoint NOISEVARADJUSTDB.value[7:0];
        FDDCSNRTHRESHOLD_rd : coverpoint FDDCSNRTHRESHOLD.value[7:0];
        FDDCCOMPEN_rd : coverpoint FDDCCOMPEN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EQUALCTRL0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SMOOTHCTRL
//--------------------------------------------------------------------
class SMOOTHCTRL extends uvm_reg;
    `uvm_object_utils(SMOOTHCTRL)
    rand uvm_reg_field TDCYCROTVAL80;
    rand uvm_reg_field SMOOTHEN;
    rand uvm_reg_field TDCYCROTVAL40;
    rand uvm_reg_field TDCYCROTVAL20;

    //---build------------------------------------------------------------
    virtual function void build();
        TDCYCROTVAL80 = uvm_reg_field::type_id::create("TDCYCROTVAL80");
        SMOOTHEN = uvm_reg_field::type_id::create("SMOOTHEN");
        TDCYCROTVAL40 = uvm_reg_field::type_id::create("TDCYCROTVAL40");
        TDCYCROTVAL20 = uvm_reg_field::type_id::create("TDCYCROTVAL20");

        TDCYCROTVAL80.configure(this, 8, 20, "RW", 1, 'b0011000, 1, 1, 1);
        SMOOTHEN.configure(this, 1, 19, "RW", 1, 'b1, 1, 1, 1);
        TDCYCROTVAL40.configure(this, 8, 8, "RW", 1, 'b0001100, 1, 1, 1);
        TDCYCROTVAL20.configure(this, 8, 0, "RW", 1, 'b0000110, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_SMOOTHCTRL_wr_cg";
        TDCYCROTVAL80_wr : coverpoint TDCYCROTVAL80.value[7:0];
        SMOOTHEN_wr : coverpoint SMOOTHEN.value[0:0];
        TDCYCROTVAL40_wr : coverpoint TDCYCROTVAL40.value[7:0];
        TDCYCROTVAL20_wr : coverpoint TDCYCROTVAL20.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_SMOOTHCTRL_rd_cg";
        TDCYCROTVAL80_rd : coverpoint TDCYCROTVAL80.value[7:0];
        SMOOTHEN_rd : coverpoint SMOOTHEN.value[0:0];
        TDCYCROTVAL40_rd : coverpoint TDCYCROTVAL40.value[7:0];
        TDCYCROTVAL20_rd : coverpoint TDCYCROTVAL20.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SMOOTHCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DCESTIMCTRL
//--------------------------------------------------------------------
class DCESTIMCTRL extends uvm_reg;
    `uvm_object_utils(DCESTIMCTRL)
    rand uvm_reg_field STARTHTDC;
    rand uvm_reg_field STARTDC;
    rand uvm_reg_field DELAYSYNC;
    rand uvm_reg_field WAITHTSTF;

    //---build------------------------------------------------------------
    virtual function void build();
        STARTHTDC = uvm_reg_field::type_id::create("STARTHTDC");
        STARTDC = uvm_reg_field::type_id::create("STARTDC");
        DELAYSYNC = uvm_reg_field::type_id::create("DELAYSYNC");
        WAITHTSTF = uvm_reg_field::type_id::create("WAITHTSTF");

        STARTHTDC.configure(this, 4, 28, "RW", 1, 'b000, 1, 1, 1);
        STARTDC.configure(this, 4, 24, "RW", 1, 'b010, 1, 1, 1);
        DELAYSYNC.configure(this, 7, 8, "RW", 1, 'b001010, 1, 1, 1);
        WAITHTSTF.configure(this, 7, 0, "RW", 1, 'b001111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_DCESTIMCTRL_wr_cg";
        STARTHTDC_wr : coverpoint STARTHTDC.value[3:0];
        STARTDC_wr : coverpoint STARTDC.value[3:0];
        DELAYSYNC_wr : coverpoint DELAYSYNC.value[6:0];
        WAITHTSTF_wr : coverpoint WAITHTSTF.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_DCESTIMCTRL_rd_cg";
        STARTHTDC_rd : coverpoint STARTHTDC.value[3:0];
        STARTDC_rd : coverpoint STARTDC.value[3:0];
        DELAYSYNC_rd : coverpoint DELAYSYNC.value[6:0];
        WAITHTSTF_rd : coverpoint WAITHTSTF.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DCESTIMCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXMODE
//--------------------------------------------------------------------
class RXMODE extends uvm_reg;
    `uvm_object_utils(RXMODE)
    rand uvm_reg_field RXHEMUMIMOEN;
    rand uvm_reg_field RXCBWMAX;
    rand uvm_reg_field RXDCMEN;
    rand uvm_reg_field RXHEEN;
    rand uvm_reg_field RXVHTMUMIMOEN;
    rand uvm_reg_field RXNDPNSTSMAX;
    rand uvm_reg_field RXSTBCEN;
    rand uvm_reg_field RXLDPCEN;
    rand uvm_reg_field RXNSSMAX;
    rand uvm_reg_field RXGFEN;
    rand uvm_reg_field RXMMEN;
    rand uvm_reg_field RXVHTEN;
    rand uvm_reg_field RXDSSSEN;

    //---build------------------------------------------------------------
    virtual function void build();
        RXHEMUMIMOEN = uvm_reg_field::type_id::create("RXHEMUMIMOEN");
        RXCBWMAX = uvm_reg_field::type_id::create("RXCBWMAX");
        RXDCMEN = uvm_reg_field::type_id::create("RXDCMEN");
        RXHEEN = uvm_reg_field::type_id::create("RXHEEN");
        RXVHTMUMIMOEN = uvm_reg_field::type_id::create("RXVHTMUMIMOEN");
        RXNDPNSTSMAX = uvm_reg_field::type_id::create("RXNDPNSTSMAX");
        RXSTBCEN = uvm_reg_field::type_id::create("RXSTBCEN");
        RXLDPCEN = uvm_reg_field::type_id::create("RXLDPCEN");
        RXNSSMAX = uvm_reg_field::type_id::create("RXNSSMAX");
        RXGFEN = uvm_reg_field::type_id::create("RXGFEN");
        RXMMEN = uvm_reg_field::type_id::create("RXMMEN");
        RXVHTEN = uvm_reg_field::type_id::create("RXVHTEN");
        RXDSSSEN = uvm_reg_field::type_id::create("RXDSSSEN");

        RXHEMUMIMOEN.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        RXCBWMAX.configure(this, 2, 24, "RW", 1, 'b0, 1, 1, 1);
        RXDCMEN.configure(this, 1, 21, "RW", 1, 'b1, 1, 1, 1);
        RXHEEN.configure(this, 1, 20, "RW", 1, 'b1, 1, 1, 1);
        RXVHTMUMIMOEN.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        RXNDPNSTSMAX.configure(this, 3, 12, "RW", 1, 'b11, 1, 1, 1);
        RXSTBCEN.configure(this, 1, 9, "RW", 1, 'b1, 1, 1, 1);
        RXLDPCEN.configure(this, 1, 8, "RW", 1, `RW_NX_DERIV_LDEC, 1, 1, 1);
        RXNSSMAX.configure(this, 3, 4, "RW", 1, 'b00, 1, 1, 1);
        RXGFEN.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        RXMMEN.configure(this, 1, 2, "RW", 1, 'b1, 1, 1, 1);
        RXVHTEN.configure(this, 1, 1, "RW", 1, 'b1, 1, 1, 1);
        RXDSSSEN.configure(this, 1, 0, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXMODE_wr_cg";
        RXHEMUMIMOEN_wr : coverpoint RXHEMUMIMOEN.value[0:0];
        RXCBWMAX_wr : coverpoint RXCBWMAX.value[1:0];
        RXDCMEN_wr : coverpoint RXDCMEN.value[0:0];
        RXHEEN_wr : coverpoint RXHEEN.value[0:0];
        RXVHTMUMIMOEN_wr : coverpoint RXVHTMUMIMOEN.value[0:0];
        RXNDPNSTSMAX_wr : coverpoint RXNDPNSTSMAX.value[2:0];
        RXSTBCEN_wr : coverpoint RXSTBCEN.value[0:0];
        RXLDPCEN_wr : coverpoint RXLDPCEN.value[0:0];
        RXNSSMAX_wr : coverpoint RXNSSMAX.value[2:0];
        RXGFEN_wr : coverpoint RXGFEN.value[0:0];
        RXMMEN_wr : coverpoint RXMMEN.value[0:0];
        RXVHTEN_wr : coverpoint RXVHTEN.value[0:0];
        RXDSSSEN_wr : coverpoint RXDSSSEN.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXMODE_rd_cg";
        RXHEMUMIMOEN_rd : coverpoint RXHEMUMIMOEN.value[0:0];
        RXCBWMAX_rd : coverpoint RXCBWMAX.value[1:0];
        RXDCMEN_rd : coverpoint RXDCMEN.value[0:0];
        RXHEEN_rd : coverpoint RXHEEN.value[0:0];
        RXVHTMUMIMOEN_rd : coverpoint RXVHTMUMIMOEN.value[0:0];
        RXNDPNSTSMAX_rd : coverpoint RXNDPNSTSMAX.value[2:0];
        RXSTBCEN_rd : coverpoint RXSTBCEN.value[0:0];
        RXLDPCEN_rd : coverpoint RXLDPCEN.value[0:0];
        RXNSSMAX_rd : coverpoint RXNSSMAX.value[2:0];
        RXGFEN_rd : coverpoint RXGFEN.value[0:0];
        RXMMEN_rd : coverpoint RXMMEN.value[0:0];
        RXVHTEN_rd : coverpoint RXVHTEN.value[0:0];
        RXDSSSEN_rd : coverpoint RXDSSSEN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXMODE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXMODE
//--------------------------------------------------------------------
class TXMODE extends uvm_reg;
    `uvm_object_utils(TXMODE)
    rand uvm_reg_field TXCBWMAX;
    rand uvm_reg_field NTXMAX;
    rand uvm_reg_field TXHEEN;
    rand uvm_reg_field TXMUMIMOEN;
    rand uvm_reg_field TXESSEN;
    rand uvm_reg_field TXUNEQMODEN;
    rand uvm_reg_field TXSTBCEN;
    rand uvm_reg_field TXLDPCEN;
    rand uvm_reg_field TXNSSMAX;
    rand uvm_reg_field TXGFEN;
    rand uvm_reg_field TXMMEN;
    rand uvm_reg_field TXVHTEN;
    rand uvm_reg_field TXDSSSEN;

    //---build------------------------------------------------------------
    virtual function void build();
        TXCBWMAX = uvm_reg_field::type_id::create("TXCBWMAX");
        NTXMAX = uvm_reg_field::type_id::create("NTXMAX");
        TXHEEN = uvm_reg_field::type_id::create("TXHEEN");
        TXMUMIMOEN = uvm_reg_field::type_id::create("TXMUMIMOEN");
        TXESSEN = uvm_reg_field::type_id::create("TXESSEN");
        TXUNEQMODEN = uvm_reg_field::type_id::create("TXUNEQMODEN");
        TXSTBCEN = uvm_reg_field::type_id::create("TXSTBCEN");
        TXLDPCEN = uvm_reg_field::type_id::create("TXLDPCEN");
        TXNSSMAX = uvm_reg_field::type_id::create("TXNSSMAX");
        TXGFEN = uvm_reg_field::type_id::create("TXGFEN");
        TXMMEN = uvm_reg_field::type_id::create("TXMMEN");
        TXVHTEN = uvm_reg_field::type_id::create("TXVHTEN");
        TXDSSSEN = uvm_reg_field::type_id::create("TXDSSSEN");

        TXCBWMAX.configure(this, 2, 24, "RW", 1, 'b0, 1, 1, 1);
        NTXMAX.configure(this, 3, 20, "RW", 1, 'b01, 1, 1, 1);
        TXHEEN.configure(this, 1, 17, "RW", 1, 'b1, 1, 1, 1);
        TXMUMIMOEN.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        TXESSEN.configure(this, 1, 11, "RW", 1, 'b0, 1, 1, 1);
        TXUNEQMODEN.configure(this, 1, 10, "RW", 1, 'b0, 1, 1, 1);
        TXSTBCEN.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        TXLDPCEN.configure(this, 1, 8, "RW", 1, `RW_NX_DERIV_LENC, 1, 1, 1);
        TXNSSMAX.configure(this, 3, 4, "RW", 1, 'b01, 1, 1, 1);
        TXGFEN.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        TXMMEN.configure(this, 1, 2, "RW", 1, 'b1, 1, 1, 1);
        TXVHTEN.configure(this, 1, 1, "RW", 1, 'b1, 1, 1, 1);
        TXDSSSEN.configure(this, 1, 0, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TXMODE_wr_cg";
        TXCBWMAX_wr : coverpoint TXCBWMAX.value[1:0];
        NTXMAX_wr : coverpoint NTXMAX.value[2:0];
        TXHEEN_wr : coverpoint TXHEEN.value[0:0];
        TXMUMIMOEN_wr : coverpoint TXMUMIMOEN.value[0:0];
        TXESSEN_wr : coverpoint TXESSEN.value[0:0];
        TXUNEQMODEN_wr : coverpoint TXUNEQMODEN.value[0:0];
        TXSTBCEN_wr : coverpoint TXSTBCEN.value[0:0];
        TXLDPCEN_wr : coverpoint TXLDPCEN.value[0:0];
        TXNSSMAX_wr : coverpoint TXNSSMAX.value[2:0];
        TXGFEN_wr : coverpoint TXGFEN.value[0:0];
        TXMMEN_wr : coverpoint TXMMEN.value[0:0];
        TXVHTEN_wr : coverpoint TXVHTEN.value[0:0];
        TXDSSSEN_wr : coverpoint TXDSSSEN.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TXMODE_rd_cg";
        TXCBWMAX_rd : coverpoint TXCBWMAX.value[1:0];
        NTXMAX_rd : coverpoint NTXMAX.value[2:0];
        TXHEEN_rd : coverpoint TXHEEN.value[0:0];
        TXMUMIMOEN_rd : coverpoint TXMUMIMOEN.value[0:0];
        TXESSEN_rd : coverpoint TXESSEN.value[0:0];
        TXUNEQMODEN_rd : coverpoint TXUNEQMODEN.value[0:0];
        TXSTBCEN_rd : coverpoint TXSTBCEN.value[0:0];
        TXLDPCEN_rd : coverpoint TXLDPCEN.value[0:0];
        TXNSSMAX_rd : coverpoint TXNSSMAX.value[2:0];
        TXGFEN_rd : coverpoint TXGFEN.value[0:0];
        TXMMEN_rd : coverpoint TXMMEN.value[0:0];
        TXVHTEN_rd : coverpoint TXVHTEN.value[0:0];
        TXDSSSEN_rd : coverpoint TXDSSSEN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXMODE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EQUALCTRL1
//--------------------------------------------------------------------
class EQUALCTRL1 extends uvm_reg;
    `uvm_object_utils(EQUALCTRL1)
    rand uvm_reg_field SATSB_LDPCNSTS1;
    rand uvm_reg_field SATSB_BCCNSTS1;
    rand uvm_reg_field SATSB_LDPCNSTS0;
    rand uvm_reg_field SATSB_BCCNSTS0;
    rand uvm_reg_field MHSHIFTVAL;
    rand uvm_reg_field MHSHIFTTHR;

    //---build------------------------------------------------------------
    virtual function void build();
        SATSB_LDPCNSTS1 = uvm_reg_field::type_id::create("SATSB_LDPCNSTS1");
        SATSB_BCCNSTS1 = uvm_reg_field::type_id::create("SATSB_BCCNSTS1");
        SATSB_LDPCNSTS0 = uvm_reg_field::type_id::create("SATSB_LDPCNSTS0");
        SATSB_BCCNSTS0 = uvm_reg_field::type_id::create("SATSB_BCCNSTS0");
        MHSHIFTVAL = uvm_reg_field::type_id::create("MHSHIFTVAL");
        MHSHIFTTHR = uvm_reg_field::type_id::create("MHSHIFTTHR");

        SATSB_LDPCNSTS1.configure(this, 3, 28, "RW", 1, 'b01, 1, 1, 1);
        SATSB_BCCNSTS1.configure(this, 3, 24, "RW", 1, 'b01, 1, 1, 1);
        SATSB_LDPCNSTS0.configure(this, 3, 20, "RW", 1, 'b00, 1, 1, 1);
        SATSB_BCCNSTS0.configure(this, 3, 16, "RW", 1, 'b00, 1, 1, 1);
        MHSHIFTVAL.configure(this, 3, 12, "RW", 1, 'b01, 1, 1, 1);
        MHSHIFTTHR.configure(this, 8, 0, "RW", 1, 'b0101000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_EQUALCTRL1_wr_cg";
        SATSB_LDPCNSTS1_wr : coverpoint SATSB_LDPCNSTS1.value[2:0];
        SATSB_BCCNSTS1_wr : coverpoint SATSB_BCCNSTS1.value[2:0];
        SATSB_LDPCNSTS0_wr : coverpoint SATSB_LDPCNSTS0.value[2:0];
        SATSB_BCCNSTS0_wr : coverpoint SATSB_BCCNSTS0.value[2:0];
        MHSHIFTVAL_wr : coverpoint MHSHIFTVAL.value[2:0];
        MHSHIFTTHR_wr : coverpoint MHSHIFTTHR.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_EQUALCTRL1_rd_cg";
        SATSB_LDPCNSTS1_rd : coverpoint SATSB_LDPCNSTS1.value[2:0];
        SATSB_BCCNSTS1_rd : coverpoint SATSB_BCCNSTS1.value[2:0];
        SATSB_LDPCNSTS0_rd : coverpoint SATSB_LDPCNSTS0.value[2:0];
        SATSB_BCCNSTS0_rd : coverpoint SATSB_BCCNSTS0.value[2:0];
        MHSHIFTVAL_rd : coverpoint MHSHIFTVAL.value[2:0];
        MHSHIFTTHR_rd : coverpoint MHSHIFTTHR.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EQUALCTRL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EQUALCTRL2
//--------------------------------------------------------------------
class EQUALCTRL2 extends uvm_reg;
    `uvm_object_utils(EQUALCTRL2)
    rand uvm_reg_field SATSB_MU_LDPCNSTS1;
    rand uvm_reg_field SATSB_MU_BCCNSTS1;
    rand uvm_reg_field SATSB_MU_LDPCNSTS0;
    rand uvm_reg_field SATSB_MU_BCCNSTS0;

    //---build------------------------------------------------------------
    virtual function void build();
        SATSB_MU_LDPCNSTS1 = uvm_reg_field::type_id::create("SATSB_MU_LDPCNSTS1");
        SATSB_MU_BCCNSTS1 = uvm_reg_field::type_id::create("SATSB_MU_BCCNSTS1");
        SATSB_MU_LDPCNSTS0 = uvm_reg_field::type_id::create("SATSB_MU_LDPCNSTS0");
        SATSB_MU_BCCNSTS0 = uvm_reg_field::type_id::create("SATSB_MU_BCCNSTS0");

        SATSB_MU_LDPCNSTS1.configure(this, 3, 28, "RW", 1, 'b10, 1, 1, 1);
        SATSB_MU_BCCNSTS1.configure(this, 3, 24, "RW", 1, 'b01, 1, 1, 1);
        SATSB_MU_LDPCNSTS0.configure(this, 3, 20, "RW", 1, 'b00, 1, 1, 1);
        SATSB_MU_BCCNSTS0.configure(this, 3, 16, "RW", 1, 'b01, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_EQUALCTRL2_wr_cg";
        SATSB_MU_LDPCNSTS1_wr : coverpoint SATSB_MU_LDPCNSTS1.value[2:0];
        SATSB_MU_BCCNSTS1_wr : coverpoint SATSB_MU_BCCNSTS1.value[2:0];
        SATSB_MU_LDPCNSTS0_wr : coverpoint SATSB_MU_LDPCNSTS0.value[2:0];
        SATSB_MU_BCCNSTS0_wr : coverpoint SATSB_MU_BCCNSTS0.value[2:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_EQUALCTRL2_rd_cg";
        SATSB_MU_LDPCNSTS1_rd : coverpoint SATSB_MU_LDPCNSTS1.value[2:0];
        SATSB_MU_BCCNSTS1_rd : coverpoint SATSB_MU_BCCNSTS1.value[2:0];
        SATSB_MU_LDPCNSTS0_rd : coverpoint SATSB_MU_LDPCNSTS0.value[2:0];
        SATSB_MU_BCCNSTS0_rd : coverpoint SATSB_MU_BCCNSTS0.value[2:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EQUALCTRL2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SMOOTHSNRTHR
//--------------------------------------------------------------------
class SMOOTHSNRTHR extends uvm_reg;
    `uvm_object_utils(SMOOTHSNRTHR)
    rand uvm_reg_field SMOOTHSNRTHRHIGH;
    rand uvm_reg_field SMOOTHSNRTHRMID;

    //---build------------------------------------------------------------
    virtual function void build();
        SMOOTHSNRTHRHIGH = uvm_reg_field::type_id::create("SMOOTHSNRTHRHIGH");
        SMOOTHSNRTHRMID = uvm_reg_field::type_id::create("SMOOTHSNRTHRMID");

        SMOOTHSNRTHRHIGH.configure(this, 8, 8, "RW", 1, 'b0011011, 1, 1, 1);
        SMOOTHSNRTHRMID.configure(this, 8, 0, "RW", 1, 'b0001111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_SMOOTHSNRTHR_wr_cg";
        SMOOTHSNRTHRHIGH_wr : coverpoint SMOOTHSNRTHRHIGH.value[7:0];
        SMOOTHSNRTHRMID_wr : coverpoint SMOOTHSNRTHRMID.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_SMOOTHSNRTHR_rd_cg";
        SMOOTHSNRTHRHIGH_rd : coverpoint SMOOTHSNRTHRHIGH.value[7:0];
        SMOOTHSNRTHRMID_rd : coverpoint SMOOTHSNRTHRMID.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SMOOTHSNRTHR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXTDCTRL1
//--------------------------------------------------------------------
class RXTDCTRL1 extends uvm_reg;
    `uvm_object_utils(RXTDCTRL1)
    rand uvm_reg_field TDDCHTSTFMARGIN;
    rand uvm_reg_field RXTDDCEN;

    //---build------------------------------------------------------------
    virtual function void build();
        TDDCHTSTFMARGIN = uvm_reg_field::type_id::create("TDDCHTSTFMARGIN");
        RXTDDCEN = uvm_reg_field::type_id::create("RXTDDCEN");

        TDDCHTSTFMARGIN.configure(this, 8, 24, "RW", 1, 'b0000001, 1, 1, 1);
        RXTDDCEN.configure(this, 1, 8, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXTDCTRL1_wr_cg";
        TDDCHTSTFMARGIN_wr : coverpoint TDDCHTSTFMARGIN.value[7:0];
        RXTDDCEN_wr : coverpoint RXTDDCEN.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXTDCTRL1_rd_cg";
        TDDCHTSTFMARGIN_rd : coverpoint TDDCHTSTFMARGIN.value[7:0];
        RXTDDCEN_rd : coverpoint RXTDDCEN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXTDCTRL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXCTRL0
//--------------------------------------------------------------------
class TXCTRL0 extends uvm_reg;
    `uvm_object_utils(TXCTRL0)
    rand uvm_reg_field TXSTARTDELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        TXSTARTDELAY = uvm_reg_field::type_id::create("TXSTARTDELAY");

        TXSTARTDELAY.configure(this, 10, 0, "RW", 1, 'b110100100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TXCTRL0_wr_cg";
        TXSTARTDELAY_wr : coverpoint TXSTARTDELAY.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TXCTRL0_rd_cg";
        TXSTARTDELAY_rd : coverpoint TXSTARTDELAY.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXCTRL0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXCTRL1
//--------------------------------------------------------------------
class RXCTRL1 extends uvm_reg;
    `uvm_object_utils(RXCTRL1)
    rand uvm_reg_field RXBCCNDBPSMAXSGI;
    rand uvm_reg_field RXBCCNDBPSMAXLGI;

    //---build------------------------------------------------------------
    virtual function void build();
        RXBCCNDBPSMAXSGI = uvm_reg_field::type_id::create("RXBCCNDBPSMAXSGI");
        RXBCCNDBPSMAXLGI = uvm_reg_field::type_id::create("RXBCCNDBPSMAXLGI");

        RXBCCNDBPSMAXSGI.configure(this, 16, 16, "RW", 1, 'b000011000011000, 1, 1, 1);
        RXBCCNDBPSMAXLGI.configure(this, 16, 0, "RW", 1, 'b000011000011000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL1_wr_cg";
        RXBCCNDBPSMAXSGI_wr : coverpoint RXBCCNDBPSMAXSGI.value[15:0];
        RXBCCNDBPSMAXLGI_wr : coverpoint RXBCCNDBPSMAXLGI.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL1_rd_cg";
        RXBCCNDBPSMAXSGI_rd : coverpoint RXBCCNDBPSMAXSGI.value[15:0];
        RXBCCNDBPSMAXLGI_rd : coverpoint RXBCCNDBPSMAXLGI.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXCTRL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SMOOTHFORCECTRL
//--------------------------------------------------------------------
class SMOOTHFORCECTRL extends uvm_reg;
    `uvm_object_utils(SMOOTHFORCECTRL)
    rand uvm_reg_field MUSMOOTHFORCE;
    rand uvm_reg_field BFSMOOTHFORCE;
    rand uvm_reg_field CFGNONHTSMOOTHFORCE;
    rand uvm_reg_field CFGNONHTSMOOTH;

    //---build------------------------------------------------------------
    virtual function void build();
        MUSMOOTHFORCE = uvm_reg_field::type_id::create("MUSMOOTHFORCE");
        BFSMOOTHFORCE = uvm_reg_field::type_id::create("BFSMOOTHFORCE");
        CFGNONHTSMOOTHFORCE = uvm_reg_field::type_id::create("CFGNONHTSMOOTHFORCE");
        CFGNONHTSMOOTH = uvm_reg_field::type_id::create("CFGNONHTSMOOTH");

        MUSMOOTHFORCE.configure(this, 1, 27, "RW", 1, 'b0, 1, 1, 1);
        BFSMOOTHFORCE.configure(this, 1, 26, "RW", 1, 'b0, 1, 1, 1);
        CFGNONHTSMOOTHFORCE.configure(this, 1, 16, "RW", 1, 'b1, 1, 1, 1);
        CFGNONHTSMOOTH.configure(this, 2, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_SMOOTHFORCECTRL_wr_cg";
        MUSMOOTHFORCE_wr : coverpoint MUSMOOTHFORCE.value[0:0];
        BFSMOOTHFORCE_wr : coverpoint BFSMOOTHFORCE.value[0:0];
        CFGNONHTSMOOTHFORCE_wr : coverpoint CFGNONHTSMOOTHFORCE.value[0:0];
        CFGNONHTSMOOTH_wr : coverpoint CFGNONHTSMOOTH.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_SMOOTHFORCECTRL_rd_cg";
        MUSMOOTHFORCE_rd : coverpoint MUSMOOTHFORCE.value[0:0];
        BFSMOOTHFORCE_rd : coverpoint BFSMOOTHFORCE.value[0:0];
        CFGNONHTSMOOTHFORCE_rd : coverpoint CFGNONHTSMOOTHFORCE.value[0:0];
        CFGNONHTSMOOTH_rd : coverpoint CFGNONHTSMOOTH.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SMOOTHFORCECTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXTDCFOCTRL
//--------------------------------------------------------------------
class TXTDCFOCTRL extends uvm_reg;
    `uvm_object_utils(TXTDCFOCTRL)
    rand uvm_reg_field TXTDCFOPHASEFORCE;
    rand uvm_reg_field TXTDCFOPHASETESTEN;
    rand uvm_reg_field TXTDCFOPHASEEN;
    rand uvm_reg_field TXTDCFOPHASE;

    //---build------------------------------------------------------------
    virtual function void build();
        TXTDCFOPHASEFORCE = uvm_reg_field::type_id::create("TXTDCFOPHASEFORCE");
        TXTDCFOPHASETESTEN = uvm_reg_field::type_id::create("TXTDCFOPHASETESTEN");
        TXTDCFOPHASEEN = uvm_reg_field::type_id::create("TXTDCFOPHASEEN");
        TXTDCFOPHASE = uvm_reg_field::type_id::create("TXTDCFOPHASE");

        TXTDCFOPHASEFORCE.configure(this, 1, 30, "RW", 1, 'b0, 1, 1, 1);
        TXTDCFOPHASETESTEN.configure(this, 1, 29, "RW", 1, 'b0, 1, 1, 1);
        TXTDCFOPHASEEN.configure(this, 1, 28, "RW", 1, 'b1, 1, 1, 1);
        TXTDCFOPHASE.configure(this, 25, 0, "RW", 1, 'b000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TXTDCFOCTRL_wr_cg";
        TXTDCFOPHASEFORCE_wr : coverpoint TXTDCFOPHASEFORCE.value[0:0];
        TXTDCFOPHASETESTEN_wr : coverpoint TXTDCFOPHASETESTEN.value[0:0];
        TXTDCFOPHASEEN_wr : coverpoint TXTDCFOPHASEEN.value[0:0];
        TXTDCFOPHASE_wr : coverpoint TXTDCFOPHASE.value[24:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TXTDCFOCTRL_rd_cg";
        TXTDCFOPHASEFORCE_rd : coverpoint TXTDCFOPHASEFORCE.value[0:0];
        TXTDCFOPHASETESTEN_rd : coverpoint TXTDCFOPHASETESTEN.value[0:0];
        TXTDCFOPHASEEN_rd : coverpoint TXTDCFOPHASEEN.value[0:0];
        TXTDCFOPHASE_rd : coverpoint TXTDCFOPHASE.value[24:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXTDCFOCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXTDSFOCTRL
//--------------------------------------------------------------------
class TXTDSFOCTRL extends uvm_reg;
    `uvm_object_utils(TXTDSFOCTRL)
    rand uvm_reg_field TXTDSFOFSRATIOFORCE;
    rand uvm_reg_field TXTDSFOFSRATIOTESTEN;
    rand uvm_reg_field TXTDSFOFSRATIOEN;
    rand uvm_reg_field TXTDSFOFSRATIO;

    //---build------------------------------------------------------------
    virtual function void build();
        TXTDSFOFSRATIOFORCE = uvm_reg_field::type_id::create("TXTDSFOFSRATIOFORCE");
        TXTDSFOFSRATIOTESTEN = uvm_reg_field::type_id::create("TXTDSFOFSRATIOTESTEN");
        TXTDSFOFSRATIOEN = uvm_reg_field::type_id::create("TXTDSFOFSRATIOEN");
        TXTDSFOFSRATIO = uvm_reg_field::type_id::create("TXTDSFOFSRATIO");

        TXTDSFOFSRATIOFORCE.configure(this, 1, 30, "RW", 1, 'b0, 1, 1, 1);
        TXTDSFOFSRATIOTESTEN.configure(this, 1, 29, "RW", 1, 'b0, 1, 1, 1);
        TXTDSFOFSRATIOEN.configure(this, 1, 28, "RW", 1, 'b1, 1, 1, 1);
        TXTDSFOFSRATIO.configure(this, 27, 0, "RW", 1, 'b100000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TXTDSFOCTRL_wr_cg";
        TXTDSFOFSRATIOFORCE_wr : coverpoint TXTDSFOFSRATIOFORCE.value[0:0];
        TXTDSFOFSRATIOTESTEN_wr : coverpoint TXTDSFOFSRATIOTESTEN.value[0:0];
        TXTDSFOFSRATIOEN_wr : coverpoint TXTDSFOFSRATIOEN.value[0:0];
        TXTDSFOFSRATIO_wr : coverpoint TXTDSFOFSRATIO.value[26:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TXTDSFOCTRL_rd_cg";
        TXTDSFOFSRATIOFORCE_rd : coverpoint TXTDSFOFSRATIOFORCE.value[0:0];
        TXTDSFOFSRATIOTESTEN_rd : coverpoint TXTDSFOFSRATIOTESTEN.value[0:0];
        TXTDSFOFSRATIOEN_rd : coverpoint TXTDSFOFSRATIOEN.value[0:0];
        TXTDSFOFSRATIO_rd : coverpoint TXTDSFOFSRATIO.value[26:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXTDSFOCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXFOESTCTRL
//--------------------------------------------------------------------
class RXFOESTCTRL extends uvm_reg;
    `uvm_object_utils(RXFOESTCTRL)
    rand uvm_reg_field FOESTFDDATAEN;
    rand uvm_reg_field FOESTFDPREAMBEN;
    rand uvm_reg_field FOESTTDEN;
    rand uvm_reg_field INVCARRIERFREQ;

    //---build------------------------------------------------------------
    virtual function void build();
        FOESTFDDATAEN = uvm_reg_field::type_id::create("FOESTFDDATAEN");
        FOESTFDPREAMBEN = uvm_reg_field::type_id::create("FOESTFDPREAMBEN");
        FOESTTDEN = uvm_reg_field::type_id::create("FOESTTDEN");
        INVCARRIERFREQ = uvm_reg_field::type_id::create("INVCARRIERFREQ");

        FOESTFDDATAEN.configure(this, 1, 26, "RW", 1, 'b1, 1, 1, 1);
        FOESTFDPREAMBEN.configure(this, 1, 25, "RW", 1, 'b0, 1, 1, 1);
        FOESTTDEN.configure(this, 1, 24, "RW", 1, 'b1, 1, 1, 1);
        INVCARRIERFREQ.configure(this, 15, 0, "RW", 1, 'b10101110110001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXFOESTCTRL_wr_cg";
        FOESTFDDATAEN_wr : coverpoint FOESTFDDATAEN.value[0:0];
        FOESTFDPREAMBEN_wr : coverpoint FOESTFDPREAMBEN.value[0:0];
        FOESTTDEN_wr : coverpoint FOESTTDEN.value[0:0];
        INVCARRIERFREQ_wr : coverpoint INVCARRIERFREQ.value[14:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXFOESTCTRL_rd_cg";
        FOESTFDDATAEN_rd : coverpoint FOESTFDDATAEN.value[0:0];
        FOESTFDPREAMBEN_rd : coverpoint FOESTFDPREAMBEN.value[0:0];
        FOESTTDEN_rd : coverpoint FOESTTDEN.value[0:0];
        INVCARRIERFREQ_rd : coverpoint INVCARRIERFREQ.value[14:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXFOESTCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// PRIMARYIND
//--------------------------------------------------------------------
class PRIMARYIND extends uvm_reg;
    `uvm_object_utils(PRIMARYIND)
    rand uvm_reg_field PRIMARY;

    //---build------------------------------------------------------------
    virtual function void build();
        PRIMARY = uvm_reg_field::type_id::create("PRIMARY");

        PRIMARY.configure(this, 3, 0, "RW", 1, 'b00, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_PRIMARYIND_wr_cg";
        PRIMARY_wr : coverpoint PRIMARY.value[2:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_PRIMARYIND_rd_cg";
        PRIMARY_rd : coverpoint PRIMARY.value[2:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "PRIMARYIND");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SCRAMBLERCTRL
//--------------------------------------------------------------------
class SCRAMBLERCTRL extends uvm_reg;
    `uvm_object_utils(SCRAMBLERCTRL)
    rand uvm_reg_field SCRAMSEED;

    //---build------------------------------------------------------------
    virtual function void build();
        SCRAMSEED = uvm_reg_field::type_id::create("SCRAMSEED");

        SCRAMSEED.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_SCRAMBLERCTRL_wr_cg";
        SCRAMSEED_wr : coverpoint SCRAMSEED.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_SCRAMBLERCTRL_rd_cg";
        SCRAMSEED_rd : coverpoint SCRAMSEED.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SCRAMBLERCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TBECTRL0
//--------------------------------------------------------------------
class TBECTRL0 extends uvm_reg;
    `uvm_object_utils(TBECTRL0)
    rand uvm_reg_field TBECountAdjust20;

    //---build------------------------------------------------------------
    virtual function void build();
        TBECountAdjust20 = uvm_reg_field::type_id::create("TBECountAdjust20");

        TBECountAdjust20.configure(this, 8, 0, "RW", 1, 'b0000100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TBECTRL0_wr_cg";
        TBECountAdjust20_wr : coverpoint TBECountAdjust20.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TBECTRL0_rd_cg";
        TBECountAdjust20_rd : coverpoint TBECountAdjust20.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TBECTRL0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TBECTRL1
//--------------------------------------------------------------------
class TBECTRL1 extends uvm_reg;
    `uvm_object_utils(TBECTRL1)
    rand uvm_reg_field PeakSearchStop;
    rand uvm_reg_field PeakSearchStart;

    //---build------------------------------------------------------------
    virtual function void build();
        PeakSearchStop = uvm_reg_field::type_id::create("PeakSearchStop");
        PeakSearchStart = uvm_reg_field::type_id::create("PeakSearchStart");

        PeakSearchStop.configure(this, 7, 8, "RW", 1, 'b111110, 1, 1, 1);
        PeakSearchStart.configure(this, 7, 0, "RW", 1, 'b010100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TBECTRL1_wr_cg";
        PeakSearchStop_wr : coverpoint PeakSearchStop.value[6:0];
        PeakSearchStart_wr : coverpoint PeakSearchStart.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TBECTRL1_rd_cg";
        PeakSearchStop_rd : coverpoint PeakSearchStop.value[6:0];
        PeakSearchStart_rd : coverpoint PeakSearchStart.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TBECTRL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TBECTRL2
//--------------------------------------------------------------------
class TBECTRL2 extends uvm_reg;
    `uvm_object_utils(TBECTRL2)
    rand uvm_reg_field TDAdjust80ShortGI;
    rand uvm_reg_field TDAdjust40ShortGI;
    rand uvm_reg_field TDAdjust20ShortGI;
    rand uvm_reg_field PeakSearchDelta;
    rand uvm_reg_field PeakSearchNdlEn;
    rand uvm_reg_field PeakSearchNdlIndex;
    rand uvm_reg_field TBEBias;

    //---build------------------------------------------------------------
    virtual function void build();
        TDAdjust80ShortGI = uvm_reg_field::type_id::create("TDAdjust80ShortGI");
        TDAdjust40ShortGI = uvm_reg_field::type_id::create("TDAdjust40ShortGI");
        TDAdjust20ShortGI = uvm_reg_field::type_id::create("TDAdjust20ShortGI");
        PeakSearchDelta = uvm_reg_field::type_id::create("PeakSearchDelta");
        PeakSearchNdlEn = uvm_reg_field::type_id::create("PeakSearchNdlEn");
        PeakSearchNdlIndex = uvm_reg_field::type_id::create("PeakSearchNdlIndex");
        TBEBias = uvm_reg_field::type_id::create("TBEBias");

        TDAdjust80ShortGI.configure(this, 5, 27, "RW", 1, 'b1000, 1, 1, 1);
        TDAdjust40ShortGI.configure(this, 5, 22, "RW", 1, 'b0100, 1, 1, 1);
        TDAdjust20ShortGI.configure(this, 5, 17, "RW", 1, 'b0010, 1, 1, 1);
        PeakSearchDelta.configure(this, 5, 12, "RW", 1, 'b0111, 1, 1, 1);
        PeakSearchNdlEn.configure(this, 1, 11, "RW", 1, 'b1, 1, 1, 1);
        PeakSearchNdlIndex.configure(this, 3, 8, "RW", 1, 'b111, 1, 1, 1);
        TBEBias.configure(this, 8, 0, "RW", 1, 'b0000100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TBECTRL2_wr_cg";
        TDAdjust80ShortGI_wr : coverpoint TDAdjust80ShortGI.value[4:0];
        TDAdjust40ShortGI_wr : coverpoint TDAdjust40ShortGI.value[4:0];
        TDAdjust20ShortGI_wr : coverpoint TDAdjust20ShortGI.value[4:0];
        PeakSearchDelta_wr : coverpoint PeakSearchDelta.value[4:0];
        PeakSearchNdlEn_wr : coverpoint PeakSearchNdlEn.value[0:0];
        PeakSearchNdlIndex_wr : coverpoint PeakSearchNdlIndex.value[2:0];
        TBEBias_wr : coverpoint TBEBias.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TBECTRL2_rd_cg";
        TDAdjust80ShortGI_rd : coverpoint TDAdjust80ShortGI.value[4:0];
        TDAdjust40ShortGI_rd : coverpoint TDAdjust40ShortGI.value[4:0];
        TDAdjust20ShortGI_rd : coverpoint TDAdjust20ShortGI.value[4:0];
        PeakSearchDelta_rd : coverpoint PeakSearchDelta.value[4:0];
        PeakSearchNdlEn_rd : coverpoint PeakSearchNdlEn.value[0:0];
        PeakSearchNdlIndex_rd : coverpoint PeakSearchNdlIndex.value[2:0];
        TBEBias_rd : coverpoint TBEBias.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TBECTRL2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TDFOCTRL0
//--------------------------------------------------------------------
class TDFOCTRL0 extends uvm_reg;
    `uvm_object_utils(TDFOCTRL0)
    rand uvm_reg_field AutoCorrCompareRatioHigh;
    rand uvm_reg_field AutoCorrCompareRatioLow;

    //---build------------------------------------------------------------
    virtual function void build();
        AutoCorrCompareRatioHigh = uvm_reg_field::type_id::create("AutoCorrCompareRatioHigh");
        AutoCorrCompareRatioLow = uvm_reg_field::type_id::create("AutoCorrCompareRatioLow");

        AutoCorrCompareRatioHigh.configure(this, 10, 12, "RW", 1, 'b1101000000, 1, 1, 1);
        AutoCorrCompareRatioLow.configure(this, 10, 0, "RW", 1, 'b100000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TDFOCTRL0_wr_cg";
        AutoCorrCompareRatioHigh_wr : coverpoint AutoCorrCompareRatioHigh.value[9:0];
        AutoCorrCompareRatioLow_wr : coverpoint AutoCorrCompareRatioLow.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TDFOCTRL0_rd_cg";
        AutoCorrCompareRatioHigh_rd : coverpoint AutoCorrCompareRatioHigh.value[9:0];
        AutoCorrCompareRatioLow_rd : coverpoint AutoCorrCompareRatioLow.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TDFOCTRL0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TDFOCTRL1
//--------------------------------------------------------------------
class TDFOCTRL1 extends uvm_reg;
    `uvm_object_utils(TDFOCTRL1)
    rand uvm_reg_field AutoCorrPlatSumEnd;
    rand uvm_reg_field AutoCorrPlatSumStart;

    //---build------------------------------------------------------------
    virtual function void build();
        AutoCorrPlatSumEnd = uvm_reg_field::type_id::create("AutoCorrPlatSumEnd");
        AutoCorrPlatSumStart = uvm_reg_field::type_id::create("AutoCorrPlatSumStart");

        AutoCorrPlatSumEnd.configure(this, 9, 12, "RW", 1, 'b01000010, 1, 1, 1);
        AutoCorrPlatSumStart.configure(this, 9, 0, "RW", 1, 'b00110010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TDFOCTRL1_wr_cg";
        AutoCorrPlatSumEnd_wr : coverpoint AutoCorrPlatSumEnd.value[8:0];
        AutoCorrPlatSumStart_wr : coverpoint AutoCorrPlatSumStart.value[8:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TDFOCTRL1_rd_cg";
        AutoCorrPlatSumEnd_rd : coverpoint AutoCorrPlatSumEnd.value[8:0];
        AutoCorrPlatSumStart_rd : coverpoint AutoCorrPlatSumStart.value[8:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TDFOCTRL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TDFOCTRL2
//--------------------------------------------------------------------
class TDFOCTRL2 extends uvm_reg;
    `uvm_object_utils(TDFOCTRL2)
    rand uvm_reg_field AutoCorrPhSumEnd;
    rand uvm_reg_field AutoCorrPhSumStart;
    rand uvm_reg_field AutoCorrPlatFallSearchStart;

    //---build------------------------------------------------------------
    virtual function void build();
        AutoCorrPhSumEnd = uvm_reg_field::type_id::create("AutoCorrPhSumEnd");
        AutoCorrPhSumStart = uvm_reg_field::type_id::create("AutoCorrPhSumStart");
        AutoCorrPlatFallSearchStart = uvm_reg_field::type_id::create("AutoCorrPlatFallSearchStart");

        AutoCorrPhSumEnd.configure(this, 9, 20, "RW", 1, 'b01001100, 1, 1, 1);
        AutoCorrPhSumStart.configure(this, 9, 10, "RW", 1, 'b00011100, 1, 1, 1);
        AutoCorrPlatFallSearchStart.configure(this, 9, 0, "RW", 1, 'b01000100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TDFOCTRL2_wr_cg";
        AutoCorrPhSumEnd_wr : coverpoint AutoCorrPhSumEnd.value[8:0];
        AutoCorrPhSumStart_wr : coverpoint AutoCorrPhSumStart.value[8:0];
        AutoCorrPlatFallSearchStart_wr : coverpoint AutoCorrPlatFallSearchStart.value[8:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TDFOCTRL2_rd_cg";
        AutoCorrPhSumEnd_rd : coverpoint AutoCorrPhSumEnd.value[8:0];
        AutoCorrPhSumStart_rd : coverpoint AutoCorrPhSumStart.value[8:0];
        AutoCorrPlatFallSearchStart_rd : coverpoint AutoCorrPlatFallSearchStart.value[8:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TDFOCTRL2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TDFOCTRL3
//--------------------------------------------------------------------
class TDFOCTRL3 extends uvm_reg;
    `uvm_object_utils(TDFOCTRL3)
    rand uvm_reg_field TDFOCOMPEN;
    rand uvm_reg_field TDFOFINEESTEN;
    rand uvm_reg_field TDFOCPESLOPEEN;
    rand uvm_reg_field TDFOPlatFallTimeOut;
    rand uvm_reg_field AutoCorrPlatFallIndexOffset;
    rand uvm_reg_field AutoCorrFallCount;

    //---build------------------------------------------------------------
    virtual function void build();
        TDFOCOMPEN = uvm_reg_field::type_id::create("TDFOCOMPEN");
        TDFOFINEESTEN = uvm_reg_field::type_id::create("TDFOFINEESTEN");
        TDFOCPESLOPEEN = uvm_reg_field::type_id::create("TDFOCPESLOPEEN");
        TDFOPlatFallTimeOut = uvm_reg_field::type_id::create("TDFOPlatFallTimeOut");
        AutoCorrPlatFallIndexOffset = uvm_reg_field::type_id::create("AutoCorrPlatFallIndexOffset");
        AutoCorrFallCount = uvm_reg_field::type_id::create("AutoCorrFallCount");

        TDFOCOMPEN.configure(this, 1, 31, "RW", 1, 'b1, 1, 1, 1);
        TDFOFINEESTEN.configure(this, 1, 27, "RW", 1, 'b1, 1, 1, 1);
        TDFOCPESLOPEEN.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        TDFOPlatFallTimeOut.configure(this, 12, 12, "RW", 1, 'b00111110100, 1, 1, 1);
        AutoCorrPlatFallIndexOffset.configure(this, 4, 4, "RW", 1, 'b1000, 1, 1, 1);
        AutoCorrFallCount.configure(this, 4, 0, "RW", 1, 'b001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TDFOCTRL3_wr_cg";
        TDFOCOMPEN_wr : coverpoint TDFOCOMPEN.value[0:0];
        TDFOFINEESTEN_wr : coverpoint TDFOFINEESTEN.value[0:0];
        TDFOCPESLOPEEN_wr : coverpoint TDFOCPESLOPEEN.value[0:0];
        TDFOPlatFallTimeOut_wr : coverpoint TDFOPlatFallTimeOut.value[11:0];
        AutoCorrPlatFallIndexOffset_wr : coverpoint AutoCorrPlatFallIndexOffset.value[3:0];
        AutoCorrFallCount_wr : coverpoint AutoCorrFallCount.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TDFOCTRL3_rd_cg";
        TDFOCOMPEN_rd : coverpoint TDFOCOMPEN.value[0:0];
        TDFOFINEESTEN_rd : coverpoint TDFOFINEESTEN.value[0:0];
        TDFOCPESLOPEEN_rd : coverpoint TDFOCPESLOPEEN.value[0:0];
        TDFOPlatFallTimeOut_rd : coverpoint TDFOPlatFallTimeOut.value[11:0];
        AutoCorrPlatFallIndexOffset_rd : coverpoint AutoCorrPlatFallIndexOffset.value[3:0];
        AutoCorrFallCount_rd : coverpoint AutoCorrFallCount.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TDFOCTRL3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXCTRL1
//--------------------------------------------------------------------
class TXCTRL1 extends uvm_reg;
    `uvm_object_utils(TXCTRL1)
    rand uvm_reg_field TXFEOFDM20DELAY;
    rand uvm_reg_field TXFEDSSSDELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        TXFEOFDM20DELAY = uvm_reg_field::type_id::create("TXFEOFDM20DELAY");
        TXFEDSSSDELAY = uvm_reg_field::type_id::create("TXFEDSSSDELAY");

        TXFEOFDM20DELAY.configure(this, 8, 8, "RW", 1, 'b0011100, 1, 1, 1);
        TXFEDSSSDELAY.configure(this, 8, 0, "RW", 1, 'b0110000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TXCTRL1_wr_cg";
        TXFEOFDM20DELAY_wr : coverpoint TXFEOFDM20DELAY.value[7:0];
        TXFEDSSSDELAY_wr : coverpoint TXFEDSSSDELAY.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_TXCTRL1_rd_cg";
        TXFEOFDM20DELAY_rd : coverpoint TXFEOFDM20DELAY.value[7:0];
        TXFEDSSSDELAY_rd : coverpoint TXFEDSSSDELAY.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXCTRL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// LDPCDECCTRL
//--------------------------------------------------------------------
class LDPCDECCTRL extends uvm_reg;
    `uvm_object_utils(LDPCDECCTRL)
    rand uvm_reg_field LDPCDECSTATEN;
    rand uvm_reg_field LDPCDECFIFOTHR;
    rand uvm_reg_field LDPCDECLLRUNITY;

    //---build------------------------------------------------------------
    virtual function void build();
        LDPCDECSTATEN = uvm_reg_field::type_id::create("LDPCDECSTATEN");
        LDPCDECFIFOTHR = uvm_reg_field::type_id::create("LDPCDECFIFOTHR");
        LDPCDECLLRUNITY = uvm_reg_field::type_id::create("LDPCDECLLRUNITY");

        LDPCDECSTATEN.configure(this, 1, 28, "RW", 1, 'b1, 1, 1, 1);
        LDPCDECFIFOTHR.configure(this, 9, 8, "RW", 1, 'b01100010, 1, 1, 1);
        LDPCDECLLRUNITY.configure(this, 6, 0, "RW", 1, 'b00010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_LDPCDECCTRL_wr_cg";
        LDPCDECSTATEN_wr : coverpoint LDPCDECSTATEN.value[0:0];
        LDPCDECFIFOTHR_wr : coverpoint LDPCDECFIFOTHR.value[8:0];
        LDPCDECLLRUNITY_wr : coverpoint LDPCDECLLRUNITY.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_LDPCDECCTRL_rd_cg";
        LDPCDECSTATEN_rd : coverpoint LDPCDECSTATEN.value[0:0];
        LDPCDECFIFOTHR_rd : coverpoint LDPCDECFIFOTHR.value[8:0];
        LDPCDECLLRUNITY_rd : coverpoint LDPCDECLLRUNITY.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "LDPCDECCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXCTRL2
//--------------------------------------------------------------------
class RXCTRL2 extends uvm_reg;
    `uvm_object_utils(RXCTRL2)
    rand uvm_reg_field RXFRAMEVIOLATIONMASK;

    //---build------------------------------------------------------------
    virtual function void build();
        RXFRAMEVIOLATIONMASK = uvm_reg_field::type_id::create("RXFRAMEVIOLATIONMASK");

        RXFRAMEVIOLATIONMASK.configure(this, 32, 0, "RW", 1, 'b11111111111111111111111111111111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL2_wr_cg";
        RXFRAMEVIOLATIONMASK_wr : coverpoint RXFRAMEVIOLATIONMASK.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL2_rd_cg";
        RXFRAMEVIOLATIONMASK_rd : coverpoint RXFRAMEVIOLATIONMASK.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXCTRL2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXCTRL3
//--------------------------------------------------------------------
class RXCTRL3 extends uvm_reg;
    `uvm_object_utils(RXCTRL3)
    rand uvm_reg_field RXLDPCNDBPSMAXSGI;
    rand uvm_reg_field RXLDPCNDBPSMAXLGI;

    //---build------------------------------------------------------------
    virtual function void build();
        RXLDPCNDBPSMAXSGI = uvm_reg_field::type_id::create("RXLDPCNDBPSMAXSGI");
        RXLDPCNDBPSMAXLGI = uvm_reg_field::type_id::create("RXLDPCNDBPSMAXLGI");

        RXLDPCNDBPSMAXSGI.configure(this, 16, 16, "RW", 1, 'b000011000011000, 1, 1, 1);
        RXLDPCNDBPSMAXLGI.configure(this, 16, 0, "RW", 1, 'b000011000011000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL3_wr_cg";
        RXLDPCNDBPSMAXSGI_wr : coverpoint RXLDPCNDBPSMAXSGI.value[15:0];
        RXLDPCNDBPSMAXLGI_wr : coverpoint RXLDPCNDBPSMAXLGI.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL3_rd_cg";
        RXLDPCNDBPSMAXSGI_rd : coverpoint RXLDPCNDBPSMAXSGI.value[15:0];
        RXLDPCNDBPSMAXLGI_rd : coverpoint RXLDPCNDBPSMAXLGI.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXCTRL3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SVDCTRL
//--------------------------------------------------------------------
class SVDCTRL extends uvm_reg;
    `uvm_object_utils(SVDCTRL)
    rand uvm_reg_field RXANTSEL;
    rand uvm_reg_field SNRSCALING;

    //---build------------------------------------------------------------
    virtual function void build();
        RXANTSEL = uvm_reg_field::type_id::create("RXANTSEL");
        SNRSCALING = uvm_reg_field::type_id::create("SNRSCALING");

        RXANTSEL.configure(this, 4, 20, "RW", 1, 'b011, 1, 1, 1);
        SNRSCALING.configure(this, 10, 0, "RW", 1, 'b001010110, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_SVDCTRL_wr_cg";
        RXANTSEL_wr : coverpoint RXANTSEL.value[3:0];
        SNRSCALING_wr : coverpoint SNRSCALING.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_SVDCTRL_rd_cg";
        RXANTSEL_rd : coverpoint RXANTSEL.value[3:0];
        SNRSCALING_rd : coverpoint SNRSCALING.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SVDCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MUMIMO_GROUPID_TAB0
//--------------------------------------------------------------------
class MUMIMO_GROUPID_TAB0 extends uvm_reg;
    `uvm_object_utils(MUMIMO_GROUPID_TAB0)
    rand uvm_reg_field VHTMEMBERSHIPSTAT0;

    //---build------------------------------------------------------------
    virtual function void build();
        VHTMEMBERSHIPSTAT0 = uvm_reg_field::type_id::create("VHTMEMBERSHIPSTAT0");

        VHTMEMBERSHIPSTAT0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_GROUPID_TAB0_wr_cg";
        VHTMEMBERSHIPSTAT0_wr : coverpoint VHTMEMBERSHIPSTAT0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_GROUPID_TAB0_rd_cg";
        VHTMEMBERSHIPSTAT0_rd : coverpoint VHTMEMBERSHIPSTAT0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MUMIMO_GROUPID_TAB0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MUMIMO_GROUPID_TAB1
//--------------------------------------------------------------------
class MUMIMO_GROUPID_TAB1 extends uvm_reg;
    `uvm_object_utils(MUMIMO_GROUPID_TAB1)
    rand uvm_reg_field VHTMEMBERSHIPSTAT1;

    //---build------------------------------------------------------------
    virtual function void build();
        VHTMEMBERSHIPSTAT1 = uvm_reg_field::type_id::create("VHTMEMBERSHIPSTAT1");

        VHTMEMBERSHIPSTAT1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_GROUPID_TAB1_wr_cg";
        VHTMEMBERSHIPSTAT1_wr : coverpoint VHTMEMBERSHIPSTAT1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_GROUPID_TAB1_rd_cg";
        VHTMEMBERSHIPSTAT1_rd : coverpoint VHTMEMBERSHIPSTAT1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MUMIMO_GROUPID_TAB1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MUMIMO_USERPOSITION_TAB0
//--------------------------------------------------------------------
class MUMIMO_USERPOSITION_TAB0 extends uvm_reg;
    `uvm_object_utils(MUMIMO_USERPOSITION_TAB0)
    rand uvm_reg_field VHTUSERPOSID0;

    //---build------------------------------------------------------------
    virtual function void build();
        VHTUSERPOSID0 = uvm_reg_field::type_id::create("VHTUSERPOSID0");

        VHTUSERPOSID0.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_USERPOSITION_TAB0_wr_cg";
        VHTUSERPOSID0_wr : coverpoint VHTUSERPOSID0.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_USERPOSITION_TAB0_rd_cg";
        VHTUSERPOSID0_rd : coverpoint VHTUSERPOSID0.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MUMIMO_USERPOSITION_TAB0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MUMIMO_USERPOSITION_TAB1
//--------------------------------------------------------------------
class MUMIMO_USERPOSITION_TAB1 extends uvm_reg;
    `uvm_object_utils(MUMIMO_USERPOSITION_TAB1)
    rand uvm_reg_field VHTUSERPOSID1;

    //---build------------------------------------------------------------
    virtual function void build();
        VHTUSERPOSID1 = uvm_reg_field::type_id::create("VHTUSERPOSID1");

        VHTUSERPOSID1.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_USERPOSITION_TAB1_wr_cg";
        VHTUSERPOSID1_wr : coverpoint VHTUSERPOSID1.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_USERPOSITION_TAB1_rd_cg";
        VHTUSERPOSID1_rd : coverpoint VHTUSERPOSID1.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MUMIMO_USERPOSITION_TAB1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MUMIMO_USERPOSITION_TAB2
//--------------------------------------------------------------------
class MUMIMO_USERPOSITION_TAB2 extends uvm_reg;
    `uvm_object_utils(MUMIMO_USERPOSITION_TAB2)
    rand uvm_reg_field VHTUSERPOSID2;

    //---build------------------------------------------------------------
    virtual function void build();
        VHTUSERPOSID2 = uvm_reg_field::type_id::create("VHTUSERPOSID2");

        VHTUSERPOSID2.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_USERPOSITION_TAB2_wr_cg";
        VHTUSERPOSID2_wr : coverpoint VHTUSERPOSID2.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_USERPOSITION_TAB2_rd_cg";
        VHTUSERPOSID2_rd : coverpoint VHTUSERPOSID2.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MUMIMO_USERPOSITION_TAB2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MUMIMO_USERPOSITION_TAB3
//--------------------------------------------------------------------
class MUMIMO_USERPOSITION_TAB3 extends uvm_reg;
    `uvm_object_utils(MUMIMO_USERPOSITION_TAB3)
    rand uvm_reg_field VHTUSERPOSID3;

    //---build------------------------------------------------------------
    virtual function void build();
        VHTUSERPOSID3 = uvm_reg_field::type_id::create("VHTUSERPOSID3");

        VHTUSERPOSID3.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_USERPOSITION_TAB3_wr_cg";
        VHTUSERPOSID3_wr : coverpoint VHTUSERPOSID3.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_MUMIMO_USERPOSITION_TAB3_rd_cg";
        VHTUSERPOSID3_rd : coverpoint VHTUSERPOSID3.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MUMIMO_USERPOSITION_TAB3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HE_STAID_TAB0
//--------------------------------------------------------------------
class HE_STAID_TAB0 extends uvm_reg;
    `uvm_object_utils(HE_STAID_TAB0)
    rand uvm_reg_field HESTAID0;

    //---build------------------------------------------------------------
    virtual function void build();
        HESTAID0 = uvm_reg_field::type_id::create("HESTAID0");

        HESTAID0.configure(this, 11, 0, "RW", 1, 'b0000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HE_STAID_TAB0_wr_cg";
        HESTAID0_wr : coverpoint HESTAID0.value[10:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HE_STAID_TAB0_rd_cg";
        HESTAID0_rd : coverpoint HESTAID0.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HE_STAID_TAB0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HE_STAID_TAB1
//--------------------------------------------------------------------
class HE_STAID_TAB1 extends uvm_reg;
    `uvm_object_utils(HE_STAID_TAB1)
    rand uvm_reg_field HESTAID1;

    //---build------------------------------------------------------------
    virtual function void build();
        HESTAID1 = uvm_reg_field::type_id::create("HESTAID1");

        HESTAID1.configure(this, 11, 0, "RW", 1, 'b0000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HE_STAID_TAB1_wr_cg";
        HESTAID1_wr : coverpoint HESTAID1.value[10:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HE_STAID_TAB1_rd_cg";
        HESTAID1_rd : coverpoint HESTAID1.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HE_STAID_TAB1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HE_STAID_TAB2
//--------------------------------------------------------------------
class HE_STAID_TAB2 extends uvm_reg;
    `uvm_object_utils(HE_STAID_TAB2)
    rand uvm_reg_field HESTAID2;

    //---build------------------------------------------------------------
    virtual function void build();
        HESTAID2 = uvm_reg_field::type_id::create("HESTAID2");

        HESTAID2.configure(this, 11, 0, "RW", 1, 'b0000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HE_STAID_TAB2_wr_cg";
        HESTAID2_wr : coverpoint HESTAID2.value[10:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HE_STAID_TAB2_rd_cg";
        HESTAID2_rd : coverpoint HESTAID2.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HE_STAID_TAB2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HE_STAID_TAB3
//--------------------------------------------------------------------
class HE_STAID_TAB3 extends uvm_reg;
    `uvm_object_utils(HE_STAID_TAB3)
    rand uvm_reg_field HESTAID3;

    //---build------------------------------------------------------------
    virtual function void build();
        HESTAID3 = uvm_reg_field::type_id::create("HESTAID3");

        HESTAID3.configure(this, 11, 0, "RW", 1, 'b0000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HE_STAID_TAB3_wr_cg";
        HESTAID3_wr : coverpoint HESTAID3.value[10:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_HE_STAID_TAB3_rd_cg";
        HESTAID3_rd : coverpoint HESTAID3.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HE_STAID_TAB3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXCTRL4
//--------------------------------------------------------------------
class RXCTRL4 extends uvm_reg;
    `uvm_object_utils(RXCTRL4)
    rand uvm_reg_field RXHEFRAMEVIOLATIONMASK;

    //---build------------------------------------------------------------
    virtual function void build();
        RXHEFRAMEVIOLATIONMASK = uvm_reg_field::type_id::create("RXHEFRAMEVIOLATIONMASK");

        RXHEFRAMEVIOLATIONMASK.configure(this, 32, 0, "RW", 1, 'b11111111111111111111111111111111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL4_wr_cg";
        RXHEFRAMEVIOLATIONMASK_wr : coverpoint RXHEFRAMEVIOLATIONMASK.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL4_rd_cg";
        RXHEFRAMEVIOLATIONMASK_rd : coverpoint RXHEFRAMEVIOLATIONMASK.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXCTRL4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXCTRL5
//--------------------------------------------------------------------
class RXCTRL5 extends uvm_reg;
    `uvm_object_utils(RXCTRL5)
    rand uvm_reg_field RXFEOFDM20DELAY;
    rand uvm_reg_field RXSIFSDELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        RXFEOFDM20DELAY = uvm_reg_field::type_id::create("RXFEOFDM20DELAY");
        RXSIFSDELAY = uvm_reg_field::type_id::create("RXSIFSDELAY");

        RXFEOFDM20DELAY.configure(this, 10, 16, "RW", 1, 'b000100001, 1, 1, 1);
        RXSIFSDELAY.configure(this, 13, 0, "RW", 1, 'b011110000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL5_wr_cg";
        RXFEOFDM20DELAY_wr : coverpoint RXFEOFDM20DELAY.value[9:0];
        RXSIFSDELAY_wr : coverpoint RXSIFSDELAY.value[12:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL5_rd_cg";
        RXFEOFDM20DELAY_rd : coverpoint RXFEOFDM20DELAY.value[9:0];
        RXSIFSDELAY_rd : coverpoint RXSIFSDELAY.value[12:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXCTRL5");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXCTRL6
//--------------------------------------------------------------------
class RXCTRL6 extends uvm_reg;
    `uvm_object_utils(RXCTRL6)
    rand uvm_reg_field RXFEOFDM4020DELAY;
    rand uvm_reg_field RXFEOFDM40DELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        RXFEOFDM4020DELAY = uvm_reg_field::type_id::create("RXFEOFDM4020DELAY");
        RXFEOFDM40DELAY = uvm_reg_field::type_id::create("RXFEOFDM40DELAY");

        RXFEOFDM4020DELAY.configure(this, 10, 16, "RW", 1, 'b000110111, 1, 1, 1);
        RXFEOFDM40DELAY.configure(this, 10, 0, "RW", 1, 'b000010110, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL6_wr_cg";
        RXFEOFDM4020DELAY_wr : coverpoint RXFEOFDM4020DELAY.value[9:0];
        RXFEOFDM40DELAY_wr : coverpoint RXFEOFDM40DELAY.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL6_rd_cg";
        RXFEOFDM4020DELAY_rd : coverpoint RXFEOFDM4020DELAY.value[9:0];
        RXFEOFDM40DELAY_rd : coverpoint RXFEOFDM40DELAY.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXCTRL6");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RXCTRL7
//--------------------------------------------------------------------
class RXCTRL7 extends uvm_reg;
    `uvm_object_utils(RXCTRL7)
    rand uvm_reg_field RXVHTMUFRAMEVIOLATIONMASK;
    rand uvm_reg_field RXSKIPMIDAMBLE4X;
    rand uvm_reg_field RXSKIPMIDAMBLE2X;
    rand uvm_reg_field RXSKIPMIDAMBLE1X;

    //---build------------------------------------------------------------
    virtual function void build();
        RXVHTMUFRAMEVIOLATIONMASK = uvm_reg_field::type_id::create("RXVHTMUFRAMEVIOLATIONMASK");
        RXSKIPMIDAMBLE4X = uvm_reg_field::type_id::create("RXSKIPMIDAMBLE4X");
        RXSKIPMIDAMBLE2X = uvm_reg_field::type_id::create("RXSKIPMIDAMBLE2X");
        RXSKIPMIDAMBLE1X = uvm_reg_field::type_id::create("RXSKIPMIDAMBLE1X");

        RXVHTMUFRAMEVIOLATIONMASK.configure(this, 4, 4, "RW", 1, 'b111, 1, 1, 1);
        RXSKIPMIDAMBLE4X.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        RXSKIPMIDAMBLE2X.configure(this, 1, 1, "RW", 1, 'b1, 1, 1, 1);
        RXSKIPMIDAMBLE1X.configure(this, 1, 0, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL7_wr_cg";
        RXVHTMUFRAMEVIOLATIONMASK_wr : coverpoint RXVHTMUFRAMEVIOLATIONMASK.value[3:0];
        RXSKIPMIDAMBLE4X_wr : coverpoint RXSKIPMIDAMBLE4X.value[0:0];
        RXSKIPMIDAMBLE2X_wr : coverpoint RXSKIPMIDAMBLE2X.value[0:0];
        RXSKIPMIDAMBLE1X_wr : coverpoint RXSKIPMIDAMBLE1X.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYCONFIG_RXCTRL7_rd_cg";
        RXVHTMUFRAMEVIOLATIONMASK_rd : coverpoint RXVHTMUFRAMEVIOLATIONMASK.value[3:0];
        RXSKIPMIDAMBLE4X_rd : coverpoint RXSKIPMIDAMBLE4X.value[0:0];
        RXSKIPMIDAMBLE2X_rd : coverpoint RXSKIPMIDAMBLE2X.value[0:0];
        RXSKIPMIDAMBLE1X_rd : coverpoint RXSKIPMIDAMBLE1X.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RXCTRL7");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class PHYCONFIG_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(PHYCONFIG_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins HDMCONFIG              = {'h0};
        bins TDOFFSETSTAT0              = {'h4};
        bins TDOFFSETSTAT1              = {'h8};
        bins FDTOFFSETSTAT0              = {'hC};
        bins FDTOFFSETSTAT1              = {'h10};
        bins TBESTAT              = {'h14};
        bins BFMERSTAT0              = {'h18};
        bins EQUALSTAT0              = {'h34};
        bins EQUALSTAT1              = {'h38};
        bins HDMVERSION              = {'h3C};
        bins HDMCONFIG2              = {'h48};
        bins FDTOFFSETSTAT2              = {'h4C};
        bins FDTOFFSETSTAT3              = {'h50};
        bins RXCFOEST              = {'h54};
        bins RXSFOEST              = {'h58};
        bins RXNSRSTAT              = {'h5C};
        bins LDPCDECSTAT0              = {'h60};
        bins FEBCNTL              = {'h300};
        bins MDMBCNTL              = {'h304};
        bins MDMBPRMINIT              = {'h308};
        bins MDMBTALPHA              = {'h30C};
        bins MDMBTBETA              = {'h310};
        bins MDMBTMU              = {'h314};
        bins MDMBCNTL1              = {'h318};
        bins MDMBRFCNTL              = {'h31C};
        bins MDMBEQCNTL              = {'h320};
        bins MDMBCNTL2              = {'h324};
        bins MDMBSTAT0              = {'h328};
        bins MDMBSTAT1              = {'h32C};
        bins MDMCONF              = {'h800};
        bins RXTDCTRL0              = {'h804};
        bins FDOCTRL0              = {'h808};
        bins FDOCTRL1              = {'h80C};
        bins FDOCTRL2              = {'h810};
        bins EQUALCTRL0              = {'h814};
        bins SMOOTHCTRL              = {'h818};
        bins DCESTIMCTRL              = {'h81C};
        bins RXMODE              = {'h820};
        bins TXMODE              = {'h824};
        bins EQUALCTRL1              = {'h828};
        bins EQUALCTRL2              = {'h82C};
        bins SMOOTHSNRTHR              = {'h830};
        bins RXTDCTRL1              = {'h834};
        bins TXCTRL0              = {'h838};
        bins RXCTRL1              = {'h83C};
        bins SMOOTHFORCECTRL              = {'h840};
        bins TXTDCFOCTRL              = {'h844};
        bins TXTDSFOCTRL              = {'h848};
        bins RXFOESTCTRL              = {'h84C};
        bins PRIMARYIND              = {'h850};
        bins SCRAMBLERCTRL              = {'h854};
        bins TBECTRL0              = {'h858};
        bins TBECTRL1              = {'h85C};
        bins TBECTRL2              = {'h860};
        bins TDFOCTRL0              = {'h864};
        bins TDFOCTRL1              = {'h868};
        bins TDFOCTRL2              = {'h86C};
        bins TDFOCTRL3              = {'h870};
        bins TXCTRL1              = {'h88C};
        bins LDPCDECCTRL              = {'h894};
        bins RXCTRL2              = {'h89C};
        bins RXCTRL3              = {'h8A0};
        bins SVDCTRL              = {'h8A4};
        bins MUMIMO_GROUPID_TAB0              = {'h8A8};
        bins MUMIMO_GROUPID_TAB1              = {'h8AC};
        bins MUMIMO_USERPOSITION_TAB0              = {'h8B0};
        bins MUMIMO_USERPOSITION_TAB1              = {'h8B4};
        bins MUMIMO_USERPOSITION_TAB2              = {'h8B8};
        bins MUMIMO_USERPOSITION_TAB3              = {'h8BC};
        bins HE_STAID_TAB0              = {'h8C0};
        bins HE_STAID_TAB1              = {'h8C4};
        bins HE_STAID_TAB2              = {'h8C8};
        bins HE_STAID_TAB3              = {'h8CC};
        bins RXCTRL4              = {'h8D0};
        bins RXCTRL5              = {'h8D4};
        bins RXCTRL6              = {'h8D8};
        bins RXCTRL7              = {'h8DC};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "PHYCONFIG_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: PHYCONFIG_reg_access_wrapper

//-------------------------------------------------------------------
// PHYCONFIG_register_block
//--------------------------------------------------------------------
class PHYCONFIG_register_block extends uvm_reg_block;
    `uvm_object_utils(PHYCONFIG_register_block)

    rand HDMCONFIG HDMCONFIG_reg;
    rand TDOFFSETSTAT0 TDOFFSETSTAT0_reg;
    rand TDOFFSETSTAT1 TDOFFSETSTAT1_reg;
    rand FDTOFFSETSTAT0 FDTOFFSETSTAT0_reg;
    rand FDTOFFSETSTAT1 FDTOFFSETSTAT1_reg;
    rand TBESTAT TBESTAT_reg;
    rand BFMERSTAT0 BFMERSTAT0_reg;
    rand EQUALSTAT0 EQUALSTAT0_reg;
    rand EQUALSTAT1 EQUALSTAT1_reg;
    rand HDMVERSION HDMVERSION_reg;
    rand HDMCONFIG2 HDMCONFIG2_reg;
    rand FDTOFFSETSTAT2 FDTOFFSETSTAT2_reg;
    rand FDTOFFSETSTAT3 FDTOFFSETSTAT3_reg;
    rand RXCFOEST RXCFOEST_reg;
    rand RXSFOEST RXSFOEST_reg;
    rand RXNSRSTAT RXNSRSTAT_reg;
    rand LDPCDECSTAT0 LDPCDECSTAT0_reg;
    rand FEBCNTL FEBCNTL_reg;
    rand MDMBCNTL MDMBCNTL_reg;
    rand MDMBPRMINIT MDMBPRMINIT_reg;
    rand MDMBTALPHA MDMBTALPHA_reg;
    rand MDMBTBETA MDMBTBETA_reg;
    rand MDMBTMU MDMBTMU_reg;
    rand MDMBCNTL1 MDMBCNTL1_reg;
    rand MDMBRFCNTL MDMBRFCNTL_reg;
    rand MDMBEQCNTL MDMBEQCNTL_reg;
    rand MDMBCNTL2 MDMBCNTL2_reg;
    rand MDMBSTAT0 MDMBSTAT0_reg;
    rand MDMBSTAT1 MDMBSTAT1_reg;
    rand MDMCONF MDMCONF_reg;
    rand RXTDCTRL0 RXTDCTRL0_reg;
    rand FDOCTRL0 FDOCTRL0_reg;
    rand FDOCTRL1 FDOCTRL1_reg;
    rand FDOCTRL2 FDOCTRL2_reg;
    rand EQUALCTRL0 EQUALCTRL0_reg;
    rand SMOOTHCTRL SMOOTHCTRL_reg;
    rand DCESTIMCTRL DCESTIMCTRL_reg;
    rand RXMODE RXMODE_reg;
    rand TXMODE TXMODE_reg;
    rand EQUALCTRL1 EQUALCTRL1_reg;
    rand EQUALCTRL2 EQUALCTRL2_reg;
    rand SMOOTHSNRTHR SMOOTHSNRTHR_reg;
    rand RXTDCTRL1 RXTDCTRL1_reg;
    rand TXCTRL0 TXCTRL0_reg;
    rand RXCTRL1 RXCTRL1_reg;
    rand SMOOTHFORCECTRL SMOOTHFORCECTRL_reg;
    rand TXTDCFOCTRL TXTDCFOCTRL_reg;
    rand TXTDSFOCTRL TXTDSFOCTRL_reg;
    rand RXFOESTCTRL RXFOESTCTRL_reg;
    rand PRIMARYIND PRIMARYIND_reg;
    rand SCRAMBLERCTRL SCRAMBLERCTRL_reg;
    rand TBECTRL0 TBECTRL0_reg;
    rand TBECTRL1 TBECTRL1_reg;
    rand TBECTRL2 TBECTRL2_reg;
    rand TDFOCTRL0 TDFOCTRL0_reg;
    rand TDFOCTRL1 TDFOCTRL1_reg;
    rand TDFOCTRL2 TDFOCTRL2_reg;
    rand TDFOCTRL3 TDFOCTRL3_reg;
    rand TXCTRL1 TXCTRL1_reg;
    rand LDPCDECCTRL LDPCDECCTRL_reg;
    rand RXCTRL2 RXCTRL2_reg;
    rand RXCTRL3 RXCTRL3_reg;
    rand SVDCTRL SVDCTRL_reg;
    rand MUMIMO_GROUPID_TAB0 MUMIMO_GROUPID_TAB0_reg;
    rand MUMIMO_GROUPID_TAB1 MUMIMO_GROUPID_TAB1_reg;
    rand MUMIMO_USERPOSITION_TAB0 MUMIMO_USERPOSITION_TAB0_reg;
    rand MUMIMO_USERPOSITION_TAB1 MUMIMO_USERPOSITION_TAB1_reg;
    rand MUMIMO_USERPOSITION_TAB2 MUMIMO_USERPOSITION_TAB2_reg;
    rand MUMIMO_USERPOSITION_TAB3 MUMIMO_USERPOSITION_TAB3_reg;
    rand HE_STAID_TAB0 HE_STAID_TAB0_reg;
    rand HE_STAID_TAB1 HE_STAID_TAB1_reg;
    rand HE_STAID_TAB2 HE_STAID_TAB2_reg;
    rand HE_STAID_TAB3 HE_STAID_TAB3_reg;
    rand RXCTRL4 RXCTRL4_reg;
    rand RXCTRL5 RXCTRL5_reg;
    rand RXCTRL6 RXCTRL6_reg;
    rand RXCTRL7 RXCTRL7_reg;

    uvm_reg_map PHYCONFIG_register_map; // Block map
    PHYCONFIG_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "PHYCONFIG_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = PHYCONFIG_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        HDMCONFIG_reg = HDMCONFIG::type_id::create("HDMCONFIG");
        HDMCONFIG_reg.configure(this);
        HDMCONFIG_reg.build();

        TDOFFSETSTAT0_reg = TDOFFSETSTAT0::type_id::create("TDOFFSETSTAT0");
        TDOFFSETSTAT0_reg.configure(this);
        TDOFFSETSTAT0_reg.build();

        TDOFFSETSTAT1_reg = TDOFFSETSTAT1::type_id::create("TDOFFSETSTAT1");
        TDOFFSETSTAT1_reg.configure(this);
        TDOFFSETSTAT1_reg.build();

        FDTOFFSETSTAT0_reg = FDTOFFSETSTAT0::type_id::create("FDTOFFSETSTAT0");
        FDTOFFSETSTAT0_reg.configure(this);
        FDTOFFSETSTAT0_reg.build();

        FDTOFFSETSTAT1_reg = FDTOFFSETSTAT1::type_id::create("FDTOFFSETSTAT1");
        FDTOFFSETSTAT1_reg.configure(this);
        FDTOFFSETSTAT1_reg.build();

        TBESTAT_reg = TBESTAT::type_id::create("TBESTAT");
        TBESTAT_reg.configure(this);
        TBESTAT_reg.build();

        BFMERSTAT0_reg = BFMERSTAT0::type_id::create("BFMERSTAT0");
        BFMERSTAT0_reg.configure(this);
        BFMERSTAT0_reg.build();

        EQUALSTAT0_reg = EQUALSTAT0::type_id::create("EQUALSTAT0");
        EQUALSTAT0_reg.configure(this);
        EQUALSTAT0_reg.build();

        EQUALSTAT1_reg = EQUALSTAT1::type_id::create("EQUALSTAT1");
        EQUALSTAT1_reg.configure(this);
        EQUALSTAT1_reg.build();

        HDMVERSION_reg = HDMVERSION::type_id::create("HDMVERSION");
        HDMVERSION_reg.configure(this);
        HDMVERSION_reg.build();

        HDMCONFIG2_reg = HDMCONFIG2::type_id::create("HDMCONFIG2");
        HDMCONFIG2_reg.configure(this);
        HDMCONFIG2_reg.build();

        FDTOFFSETSTAT2_reg = FDTOFFSETSTAT2::type_id::create("FDTOFFSETSTAT2");
        FDTOFFSETSTAT2_reg.configure(this);
        FDTOFFSETSTAT2_reg.build();

        FDTOFFSETSTAT3_reg = FDTOFFSETSTAT3::type_id::create("FDTOFFSETSTAT3");
        FDTOFFSETSTAT3_reg.configure(this);
        FDTOFFSETSTAT3_reg.build();

        RXCFOEST_reg = RXCFOEST::type_id::create("RXCFOEST");
        RXCFOEST_reg.configure(this);
        RXCFOEST_reg.build();

        RXSFOEST_reg = RXSFOEST::type_id::create("RXSFOEST");
        RXSFOEST_reg.configure(this);
        RXSFOEST_reg.build();

        RXNSRSTAT_reg = RXNSRSTAT::type_id::create("RXNSRSTAT");
        RXNSRSTAT_reg.configure(this);
        RXNSRSTAT_reg.build();

        LDPCDECSTAT0_reg = LDPCDECSTAT0::type_id::create("LDPCDECSTAT0");
        LDPCDECSTAT0_reg.configure(this);
        LDPCDECSTAT0_reg.build();

        FEBCNTL_reg = FEBCNTL::type_id::create("FEBCNTL");
        FEBCNTL_reg.configure(this);
        FEBCNTL_reg.build();

        MDMBCNTL_reg = MDMBCNTL::type_id::create("MDMBCNTL");
        MDMBCNTL_reg.configure(this);
        MDMBCNTL_reg.build();

        MDMBPRMINIT_reg = MDMBPRMINIT::type_id::create("MDMBPRMINIT");
        MDMBPRMINIT_reg.configure(this);
        MDMBPRMINIT_reg.build();

        MDMBTALPHA_reg = MDMBTALPHA::type_id::create("MDMBTALPHA");
        MDMBTALPHA_reg.configure(this);
        MDMBTALPHA_reg.build();

        MDMBTBETA_reg = MDMBTBETA::type_id::create("MDMBTBETA");
        MDMBTBETA_reg.configure(this);
        MDMBTBETA_reg.build();

        MDMBTMU_reg = MDMBTMU::type_id::create("MDMBTMU");
        MDMBTMU_reg.configure(this);
        MDMBTMU_reg.build();

        MDMBCNTL1_reg = MDMBCNTL1::type_id::create("MDMBCNTL1");
        MDMBCNTL1_reg.configure(this);
        MDMBCNTL1_reg.build();

        MDMBRFCNTL_reg = MDMBRFCNTL::type_id::create("MDMBRFCNTL");
        MDMBRFCNTL_reg.configure(this);
        MDMBRFCNTL_reg.build();

        MDMBEQCNTL_reg = MDMBEQCNTL::type_id::create("MDMBEQCNTL");
        MDMBEQCNTL_reg.configure(this);
        MDMBEQCNTL_reg.build();

        MDMBCNTL2_reg = MDMBCNTL2::type_id::create("MDMBCNTL2");
        MDMBCNTL2_reg.configure(this);
        MDMBCNTL2_reg.build();

        MDMBSTAT0_reg = MDMBSTAT0::type_id::create("MDMBSTAT0");
        MDMBSTAT0_reg.configure(this);
        MDMBSTAT0_reg.build();

        MDMBSTAT1_reg = MDMBSTAT1::type_id::create("MDMBSTAT1");
        MDMBSTAT1_reg.configure(this);
        MDMBSTAT1_reg.build();

        MDMCONF_reg = MDMCONF::type_id::create("MDMCONF");
        MDMCONF_reg.configure(this);
        MDMCONF_reg.build();

        RXTDCTRL0_reg = RXTDCTRL0::type_id::create("RXTDCTRL0");
        RXTDCTRL0_reg.configure(this);
        RXTDCTRL0_reg.build();

        FDOCTRL0_reg = FDOCTRL0::type_id::create("FDOCTRL0");
        FDOCTRL0_reg.configure(this);
        FDOCTRL0_reg.build();

        FDOCTRL1_reg = FDOCTRL1::type_id::create("FDOCTRL1");
        FDOCTRL1_reg.configure(this);
        FDOCTRL1_reg.build();

        FDOCTRL2_reg = FDOCTRL2::type_id::create("FDOCTRL2");
        FDOCTRL2_reg.configure(this);
        FDOCTRL2_reg.build();

        EQUALCTRL0_reg = EQUALCTRL0::type_id::create("EQUALCTRL0");
        EQUALCTRL0_reg.configure(this);
        EQUALCTRL0_reg.build();

        SMOOTHCTRL_reg = SMOOTHCTRL::type_id::create("SMOOTHCTRL");
        SMOOTHCTRL_reg.configure(this);
        SMOOTHCTRL_reg.build();

        DCESTIMCTRL_reg = DCESTIMCTRL::type_id::create("DCESTIMCTRL");
        DCESTIMCTRL_reg.configure(this);
        DCESTIMCTRL_reg.build();

        RXMODE_reg = RXMODE::type_id::create("RXMODE");
        RXMODE_reg.configure(this);
        RXMODE_reg.build();

        TXMODE_reg = TXMODE::type_id::create("TXMODE");
        TXMODE_reg.configure(this);
        TXMODE_reg.build();

        EQUALCTRL1_reg = EQUALCTRL1::type_id::create("EQUALCTRL1");
        EQUALCTRL1_reg.configure(this);
        EQUALCTRL1_reg.build();

        EQUALCTRL2_reg = EQUALCTRL2::type_id::create("EQUALCTRL2");
        EQUALCTRL2_reg.configure(this);
        EQUALCTRL2_reg.build();

        SMOOTHSNRTHR_reg = SMOOTHSNRTHR::type_id::create("SMOOTHSNRTHR");
        SMOOTHSNRTHR_reg.configure(this);
        SMOOTHSNRTHR_reg.build();

        RXTDCTRL1_reg = RXTDCTRL1::type_id::create("RXTDCTRL1");
        RXTDCTRL1_reg.configure(this);
        RXTDCTRL1_reg.build();

        TXCTRL0_reg = TXCTRL0::type_id::create("TXCTRL0");
        TXCTRL0_reg.configure(this);
        TXCTRL0_reg.build();

        RXCTRL1_reg = RXCTRL1::type_id::create("RXCTRL1");
        RXCTRL1_reg.configure(this);
        RXCTRL1_reg.build();

        SMOOTHFORCECTRL_reg = SMOOTHFORCECTRL::type_id::create("SMOOTHFORCECTRL");
        SMOOTHFORCECTRL_reg.configure(this);
        SMOOTHFORCECTRL_reg.build();

        TXTDCFOCTRL_reg = TXTDCFOCTRL::type_id::create("TXTDCFOCTRL");
        TXTDCFOCTRL_reg.configure(this);
        TXTDCFOCTRL_reg.build();

        TXTDSFOCTRL_reg = TXTDSFOCTRL::type_id::create("TXTDSFOCTRL");
        TXTDSFOCTRL_reg.configure(this);
        TXTDSFOCTRL_reg.build();

        RXFOESTCTRL_reg = RXFOESTCTRL::type_id::create("RXFOESTCTRL");
        RXFOESTCTRL_reg.configure(this);
        RXFOESTCTRL_reg.build();

        PRIMARYIND_reg = PRIMARYIND::type_id::create("PRIMARYIND");
        PRIMARYIND_reg.configure(this);
        PRIMARYIND_reg.build();

        SCRAMBLERCTRL_reg = SCRAMBLERCTRL::type_id::create("SCRAMBLERCTRL");
        SCRAMBLERCTRL_reg.configure(this);
        SCRAMBLERCTRL_reg.build();

        TBECTRL0_reg = TBECTRL0::type_id::create("TBECTRL0");
        TBECTRL0_reg.configure(this);
        TBECTRL0_reg.build();

        TBECTRL1_reg = TBECTRL1::type_id::create("TBECTRL1");
        TBECTRL1_reg.configure(this);
        TBECTRL1_reg.build();

        TBECTRL2_reg = TBECTRL2::type_id::create("TBECTRL2");
        TBECTRL2_reg.configure(this);
        TBECTRL2_reg.build();

        TDFOCTRL0_reg = TDFOCTRL0::type_id::create("TDFOCTRL0");
        TDFOCTRL0_reg.configure(this);
        TDFOCTRL0_reg.build();

        TDFOCTRL1_reg = TDFOCTRL1::type_id::create("TDFOCTRL1");
        TDFOCTRL1_reg.configure(this);
        TDFOCTRL1_reg.build();

        TDFOCTRL2_reg = TDFOCTRL2::type_id::create("TDFOCTRL2");
        TDFOCTRL2_reg.configure(this);
        TDFOCTRL2_reg.build();

        TDFOCTRL3_reg = TDFOCTRL3::type_id::create("TDFOCTRL3");
        TDFOCTRL3_reg.configure(this);
        TDFOCTRL3_reg.build();

        TXCTRL1_reg = TXCTRL1::type_id::create("TXCTRL1");
        TXCTRL1_reg.configure(this);
        TXCTRL1_reg.build();

        LDPCDECCTRL_reg = LDPCDECCTRL::type_id::create("LDPCDECCTRL");
        LDPCDECCTRL_reg.configure(this);
        LDPCDECCTRL_reg.build();

        RXCTRL2_reg = RXCTRL2::type_id::create("RXCTRL2");
        RXCTRL2_reg.configure(this);
        RXCTRL2_reg.build();

        RXCTRL3_reg = RXCTRL3::type_id::create("RXCTRL3");
        RXCTRL3_reg.configure(this);
        RXCTRL3_reg.build();

        SVDCTRL_reg = SVDCTRL::type_id::create("SVDCTRL");
        SVDCTRL_reg.configure(this);
        SVDCTRL_reg.build();

        MUMIMO_GROUPID_TAB0_reg = MUMIMO_GROUPID_TAB0::type_id::create("MUMIMO_GROUPID_TAB0");
        MUMIMO_GROUPID_TAB0_reg.configure(this);
        MUMIMO_GROUPID_TAB0_reg.build();

        MUMIMO_GROUPID_TAB1_reg = MUMIMO_GROUPID_TAB1::type_id::create("MUMIMO_GROUPID_TAB1");
        MUMIMO_GROUPID_TAB1_reg.configure(this);
        MUMIMO_GROUPID_TAB1_reg.build();

        MUMIMO_USERPOSITION_TAB0_reg = MUMIMO_USERPOSITION_TAB0::type_id::create("MUMIMO_USERPOSITION_TAB0");
        MUMIMO_USERPOSITION_TAB0_reg.configure(this);
        MUMIMO_USERPOSITION_TAB0_reg.build();

        MUMIMO_USERPOSITION_TAB1_reg = MUMIMO_USERPOSITION_TAB1::type_id::create("MUMIMO_USERPOSITION_TAB1");
        MUMIMO_USERPOSITION_TAB1_reg.configure(this);
        MUMIMO_USERPOSITION_TAB1_reg.build();

        MUMIMO_USERPOSITION_TAB2_reg = MUMIMO_USERPOSITION_TAB2::type_id::create("MUMIMO_USERPOSITION_TAB2");
        MUMIMO_USERPOSITION_TAB2_reg.configure(this);
        MUMIMO_USERPOSITION_TAB2_reg.build();

        MUMIMO_USERPOSITION_TAB3_reg = MUMIMO_USERPOSITION_TAB3::type_id::create("MUMIMO_USERPOSITION_TAB3");
        MUMIMO_USERPOSITION_TAB3_reg.configure(this);
        MUMIMO_USERPOSITION_TAB3_reg.build();

        HE_STAID_TAB0_reg = HE_STAID_TAB0::type_id::create("HE_STAID_TAB0");
        HE_STAID_TAB0_reg.configure(this);
        HE_STAID_TAB0_reg.build();

        HE_STAID_TAB1_reg = HE_STAID_TAB1::type_id::create("HE_STAID_TAB1");
        HE_STAID_TAB1_reg.configure(this);
        HE_STAID_TAB1_reg.build();

        HE_STAID_TAB2_reg = HE_STAID_TAB2::type_id::create("HE_STAID_TAB2");
        HE_STAID_TAB2_reg.configure(this);
        HE_STAID_TAB2_reg.build();

        HE_STAID_TAB3_reg = HE_STAID_TAB3::type_id::create("HE_STAID_TAB3");
        HE_STAID_TAB3_reg.configure(this);
        HE_STAID_TAB3_reg.build();

        RXCTRL4_reg = RXCTRL4::type_id::create("RXCTRL4");
        RXCTRL4_reg.configure(this);
        RXCTRL4_reg.build();

        RXCTRL5_reg = RXCTRL5::type_id::create("RXCTRL5");
        RXCTRL5_reg.configure(this);
        RXCTRL5_reg.build();

        RXCTRL6_reg = RXCTRL6::type_id::create("RXCTRL6");
        RXCTRL6_reg.configure(this);
        RXCTRL6_reg.build();

        RXCTRL7_reg = RXCTRL7::type_id::create("RXCTRL7");
        RXCTRL7_reg.configure(this);
        RXCTRL7_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        PHYCONFIG_register_map = create_map("PHYCONFIG_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        PHYCONFIG_register_map.add_reg(HDMCONFIG_reg, 'h0, "RO");
        PHYCONFIG_register_map.add_reg(TDOFFSETSTAT0_reg, 'h4, "RO");
        PHYCONFIG_register_map.add_reg(TDOFFSETSTAT1_reg, 'h8, "RO");
        PHYCONFIG_register_map.add_reg(FDTOFFSETSTAT0_reg, 'hC, "RO");
        PHYCONFIG_register_map.add_reg(FDTOFFSETSTAT1_reg, 'h10, "RO");
        PHYCONFIG_register_map.add_reg(TBESTAT_reg, 'h14, "RO");
        PHYCONFIG_register_map.add_reg(BFMERSTAT0_reg, 'h18, "RO");
        PHYCONFIG_register_map.add_reg(EQUALSTAT0_reg, 'h34, "RO");
        PHYCONFIG_register_map.add_reg(EQUALSTAT1_reg, 'h38, "RO");
        PHYCONFIG_register_map.add_reg(HDMVERSION_reg, 'h3C, "RO");
        PHYCONFIG_register_map.add_reg(HDMCONFIG2_reg, 'h48, "RO");
        PHYCONFIG_register_map.add_reg(FDTOFFSETSTAT2_reg, 'h4C, "RO");
        PHYCONFIG_register_map.add_reg(FDTOFFSETSTAT3_reg, 'h50, "RO");
        PHYCONFIG_register_map.add_reg(RXCFOEST_reg, 'h54, "RO");
        PHYCONFIG_register_map.add_reg(RXSFOEST_reg, 'h58, "RO");
        PHYCONFIG_register_map.add_reg(RXNSRSTAT_reg, 'h5C, "RO");
        PHYCONFIG_register_map.add_reg(LDPCDECSTAT0_reg, 'h60, "RO");
        PHYCONFIG_register_map.add_reg(FEBCNTL_reg, 'h300, "RW");
        PHYCONFIG_register_map.add_reg(MDMBCNTL_reg, 'h304, "RW");
        PHYCONFIG_register_map.add_reg(MDMBPRMINIT_reg, 'h308, "RW");
        PHYCONFIG_register_map.add_reg(MDMBTALPHA_reg, 'h30C, "RW");
        PHYCONFIG_register_map.add_reg(MDMBTBETA_reg, 'h310, "RW");
        PHYCONFIG_register_map.add_reg(MDMBTMU_reg, 'h314, "RW");
        PHYCONFIG_register_map.add_reg(MDMBCNTL1_reg, 'h318, "RW");
        PHYCONFIG_register_map.add_reg(MDMBRFCNTL_reg, 'h31C, "RW");
        PHYCONFIG_register_map.add_reg(MDMBEQCNTL_reg, 'h320, "RW");
        PHYCONFIG_register_map.add_reg(MDMBCNTL2_reg, 'h324, "RW");
        PHYCONFIG_register_map.add_reg(MDMBSTAT0_reg, 'h328, "RO");
        PHYCONFIG_register_map.add_reg(MDMBSTAT1_reg, 'h32C, "RO");
        PHYCONFIG_register_map.add_reg(MDMCONF_reg, 'h800, "RW");
        PHYCONFIG_register_map.add_reg(RXTDCTRL0_reg, 'h804, "RW");
        PHYCONFIG_register_map.add_reg(FDOCTRL0_reg, 'h808, "RW");
        PHYCONFIG_register_map.add_reg(FDOCTRL1_reg, 'h80C, "RW");
        PHYCONFIG_register_map.add_reg(FDOCTRL2_reg, 'h810, "RW");
        PHYCONFIG_register_map.add_reg(EQUALCTRL0_reg, 'h814, "RW");
        PHYCONFIG_register_map.add_reg(SMOOTHCTRL_reg, 'h818, "RW");
        PHYCONFIG_register_map.add_reg(DCESTIMCTRL_reg, 'h81C, "RW");
        PHYCONFIG_register_map.add_reg(RXMODE_reg, 'h820, "RW");
        PHYCONFIG_register_map.add_reg(TXMODE_reg, 'h824, "RW");
        PHYCONFIG_register_map.add_reg(EQUALCTRL1_reg, 'h828, "RW");
        PHYCONFIG_register_map.add_reg(EQUALCTRL2_reg, 'h82C, "RW");
        PHYCONFIG_register_map.add_reg(SMOOTHSNRTHR_reg, 'h830, "RW");
        PHYCONFIG_register_map.add_reg(RXTDCTRL1_reg, 'h834, "RW");
        PHYCONFIG_register_map.add_reg(TXCTRL0_reg, 'h838, "RW");
        PHYCONFIG_register_map.add_reg(RXCTRL1_reg, 'h83C, "RW");
        PHYCONFIG_register_map.add_reg(SMOOTHFORCECTRL_reg, 'h840, "RW");
        PHYCONFIG_register_map.add_reg(TXTDCFOCTRL_reg, 'h844, "RW");
        PHYCONFIG_register_map.add_reg(TXTDSFOCTRL_reg, 'h848, "RW");
        PHYCONFIG_register_map.add_reg(RXFOESTCTRL_reg, 'h84C, "RW");
        PHYCONFIG_register_map.add_reg(PRIMARYIND_reg, 'h850, "RW");
        PHYCONFIG_register_map.add_reg(SCRAMBLERCTRL_reg, 'h854, "RW");
        PHYCONFIG_register_map.add_reg(TBECTRL0_reg, 'h858, "RW");
        PHYCONFIG_register_map.add_reg(TBECTRL1_reg, 'h85C, "RW");
        PHYCONFIG_register_map.add_reg(TBECTRL2_reg, 'h860, "RW");
        PHYCONFIG_register_map.add_reg(TDFOCTRL0_reg, 'h864, "RW");
        PHYCONFIG_register_map.add_reg(TDFOCTRL1_reg, 'h868, "RW");
        PHYCONFIG_register_map.add_reg(TDFOCTRL2_reg, 'h86C, "RW");
        PHYCONFIG_register_map.add_reg(TDFOCTRL3_reg, 'h870, "RW");
        PHYCONFIG_register_map.add_reg(TXCTRL1_reg, 'h88C, "RW");
        PHYCONFIG_register_map.add_reg(LDPCDECCTRL_reg, 'h894, "RW");
        PHYCONFIG_register_map.add_reg(RXCTRL2_reg, 'h89C, "RW");
        PHYCONFIG_register_map.add_reg(RXCTRL3_reg, 'h8A0, "RW");
        PHYCONFIG_register_map.add_reg(SVDCTRL_reg, 'h8A4, "RW");
        PHYCONFIG_register_map.add_reg(MUMIMO_GROUPID_TAB0_reg, 'h8A8, "RW");
        PHYCONFIG_register_map.add_reg(MUMIMO_GROUPID_TAB1_reg, 'h8AC, "RW");
        PHYCONFIG_register_map.add_reg(MUMIMO_USERPOSITION_TAB0_reg, 'h8B0, "RW");
        PHYCONFIG_register_map.add_reg(MUMIMO_USERPOSITION_TAB1_reg, 'h8B4, "RW");
        PHYCONFIG_register_map.add_reg(MUMIMO_USERPOSITION_TAB2_reg, 'h8B8, "RW");
        PHYCONFIG_register_map.add_reg(MUMIMO_USERPOSITION_TAB3_reg, 'h8BC, "RW");
        PHYCONFIG_register_map.add_reg(HE_STAID_TAB0_reg, 'h8C0, "RW");
        PHYCONFIG_register_map.add_reg(HE_STAID_TAB1_reg, 'h8C4, "RW");
        PHYCONFIG_register_map.add_reg(HE_STAID_TAB2_reg, 'h8C8, "RW");
        PHYCONFIG_register_map.add_reg(HE_STAID_TAB3_reg, 'h8CC, "RW");
        PHYCONFIG_register_map.add_reg(RXCTRL4_reg, 'h8D0, "RW");
        PHYCONFIG_register_map.add_reg(RXCTRL5_reg, 'h8D4, "RW");
        PHYCONFIG_register_map.add_reg(RXCTRL6_reg, 'h8D8, "RW");
        PHYCONFIG_register_map.add_reg(RXCTRL7_reg, 'h8DC, "RW");

        // Lock the register model and build the map
        lock_model();
        PHYCONFIG_register_map.set_check_on_read();
    endfunction

endclass
`endif // __PHYCONFIG_REG_BLOCK_SV__
