//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : lmesaros
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 30649 $
// $Date: 2017-06-06 11:33:55 +0200 (Tue, 06 Jun 2017) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for PHYDSSSCONFIG
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __PHYDSSSCONFIG_REG_BLOCK_SV__
`define __PHYDSSSCONFIG_REG_BLOCK_SV__

//--------------------------------------------------------------------
// FEBCNTL
//--------------------------------------------------------------------
class FEBCNTL extends uvm_reg;
    `uvm_object_utils(FEBCNTL)
    rand uvm_reg_field MAXSTAGE;
    rand uvm_reg_field FIRDISB;
    rand uvm_reg_field GAINDISB;
    rand uvm_reg_field INTERPDISB;
    rand uvm_reg_field FIRCOEFSEL;

    //---build------------------------------------------------------------
    virtual function void build();
        MAXSTAGE = uvm_reg_field::type_id::create("MAXSTAGE");
        FIRDISB = uvm_reg_field::type_id::create("FIRDISB");
        GAINDISB = uvm_reg_field::type_id::create("GAINDISB");
        INTERPDISB = uvm_reg_field::type_id::create("INTERPDISB");
        FIRCOEFSEL = uvm_reg_field::type_id::create("FIRCOEFSEL");

        MAXSTAGE.configure(this, 6, 16, "RW", 1, 'b100111, 1, 1, 1);
        FIRDISB.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        GAINDISB.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        INTERPDISB.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        FIRCOEFSEL.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_FEBCNTL_wr_cg";
        MAXSTAGE_wr : coverpoint MAXSTAGE.value[5:0];
        FIRDISB_wr : coverpoint FIRDISB.value[0:0];
        GAINDISB_wr : coverpoint GAINDISB.value[0:0];
        INTERPDISB_wr : coverpoint INTERPDISB.value[0:0];
        FIRCOEFSEL_wr : coverpoint FIRCOEFSEL.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_FEBCNTL_rd_cg";
        MAXSTAGE_rd : coverpoint MAXSTAGE.value[5:0];
        FIRDISB_rd : coverpoint FIRDISB.value[0:0];
        GAINDISB_rd : coverpoint GAINDISB.value[0:0];
        INTERPDISB_rd : coverpoint INTERPDISB.value[0:0];
        FIRCOEFSEL_rd : coverpoint FIRCOEFSEL.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FEBCNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBCNTL
//--------------------------------------------------------------------
class MDMBCNTL extends uvm_reg;
    `uvm_object_utils(MDMBCNTL)
    rand uvm_reg_field IQMMDISB;
    rand uvm_reg_field PRECOMPDISB;
    rand uvm_reg_field DCOFFDISB;
    rand uvm_reg_field COMPDISB;
    rand uvm_reg_field EQDISB;
    rand uvm_reg_field SPREADDISB;
    rand uvm_reg_field SCRAMBDISB;
    rand uvm_reg_field SFDERR;
    rand uvm_reg_field SFDLEN;
    rand uvm_reg_field PREPRE;

    //---build------------------------------------------------------------
    virtual function void build();
        IQMMDISB = uvm_reg_field::type_id::create("IQMMDISB");
        PRECOMPDISB = uvm_reg_field::type_id::create("PRECOMPDISB");
        DCOFFDISB = uvm_reg_field::type_id::create("DCOFFDISB");
        COMPDISB = uvm_reg_field::type_id::create("COMPDISB");
        EQDISB = uvm_reg_field::type_id::create("EQDISB");
        SPREADDISB = uvm_reg_field::type_id::create("SPREADDISB");
        SCRAMBDISB = uvm_reg_field::type_id::create("SCRAMBDISB");
        SFDERR = uvm_reg_field::type_id::create("SFDERR");
        SFDLEN = uvm_reg_field::type_id::create("SFDLEN");
        PREPRE = uvm_reg_field::type_id::create("PREPRE");

        IQMMDISB.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        PRECOMPDISB.configure(this, 1, 26, "RW", 1, 'b0, 1, 1, 1);
        DCOFFDISB.configure(this, 1, 25, "RW", 1, 'b0, 1, 1, 1);
        COMPDISB.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        EQDISB.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        SPREADDISB.configure(this, 1, 21, "RW", 1, 'b0, 1, 1, 1);
        SCRAMBDISB.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        SFDERR.configure(this, 3, 12, "RW", 1, 'b00, 1, 1, 1);
        SFDLEN.configure(this, 3, 8, "RW", 1, 'b00, 1, 1, 1);
        PREPRE.configure(this, 6, 0, "RW", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBCNTL_wr_cg";
        IQMMDISB_wr : coverpoint IQMMDISB.value[0:0];
        PRECOMPDISB_wr : coverpoint PRECOMPDISB.value[0:0];
        DCOFFDISB_wr : coverpoint DCOFFDISB.value[0:0];
        COMPDISB_wr : coverpoint COMPDISB.value[0:0];
        EQDISB_wr : coverpoint EQDISB.value[0:0];
        SPREADDISB_wr : coverpoint SPREADDISB.value[0:0];
        SCRAMBDISB_wr : coverpoint SCRAMBDISB.value[0:0];
        SFDERR_wr : coverpoint SFDERR.value[2:0];
        SFDLEN_wr : coverpoint SFDLEN.value[2:0];
        PREPRE_wr : coverpoint PREPRE.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBCNTL_rd_cg";
        IQMMDISB_rd : coverpoint IQMMDISB.value[0:0];
        PRECOMPDISB_rd : coverpoint PRECOMPDISB.value[0:0];
        DCOFFDISB_rd : coverpoint DCOFFDISB.value[0:0];
        COMPDISB_rd : coverpoint COMPDISB.value[0:0];
        EQDISB_rd : coverpoint EQDISB.value[0:0];
        SPREADDISB_rd : coverpoint SPREADDISB.value[0:0];
        SCRAMBDISB_rd : coverpoint SCRAMBDISB.value[0:0];
        SFDERR_rd : coverpoint SFDERR.value[2:0];
        SFDLEN_rd : coverpoint SFDLEN.value[2:0];
        PREPRE_rd : coverpoint PREPRE.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBCNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBPRMINIT
//--------------------------------------------------------------------
class MDMBPRMINIT extends uvm_reg;
    `uvm_object_utils(MDMBPRMINIT)
    rand uvm_reg_field RHO;
    rand uvm_reg_field MU;
    rand uvm_reg_field BETA;
    rand uvm_reg_field ALPHA;

    //---build------------------------------------------------------------
    virtual function void build();
        RHO = uvm_reg_field::type_id::create("RHO");
        MU = uvm_reg_field::type_id::create("MU");
        BETA = uvm_reg_field::type_id::create("BETA");
        ALPHA = uvm_reg_field::type_id::create("ALPHA");

        RHO.configure(this, 2, 20, "RW", 1, 'b0, 1, 1, 1);
        MU.configure(this, 2, 16, "RW", 1, 'b1, 1, 1, 1);
        BETA.configure(this, 2, 4, "RW", 1, 'b10, 1, 1, 1);
        ALPHA.configure(this, 2, 0, "RW", 1, 'b10, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBPRMINIT_wr_cg";
        RHO_wr : coverpoint RHO.value[1:0];
        MU_wr : coverpoint MU.value[1:0];
        BETA_wr : coverpoint BETA.value[1:0];
        ALPHA_wr : coverpoint ALPHA.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBPRMINIT_rd_cg";
        RHO_rd : coverpoint RHO.value[1:0];
        MU_rd : coverpoint MU.value[1:0];
        BETA_rd : coverpoint BETA.value[1:0];
        ALPHA_rd : coverpoint ALPHA.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBPRMINIT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBTALPHA
//--------------------------------------------------------------------
class MDMBTALPHA extends uvm_reg;
    `uvm_object_utils(MDMBTALPHA)
    rand uvm_reg_field TALPHA3;
    rand uvm_reg_field TALPHA2;
    rand uvm_reg_field TALPHA1;
    rand uvm_reg_field TALPHA0;

    //---build------------------------------------------------------------
    virtual function void build();
        TALPHA3 = uvm_reg_field::type_id::create("TALPHA3");
        TALPHA2 = uvm_reg_field::type_id::create("TALPHA2");
        TALPHA1 = uvm_reg_field::type_id::create("TALPHA1");
        TALPHA0 = uvm_reg_field::type_id::create("TALPHA0");

        TALPHA3.configure(this, 4, 12, "RW", 1, 'b110, 1, 1, 1);
        TALPHA2.configure(this, 4, 8, "RW", 1, 'b010, 1, 1, 1);
        TALPHA1.configure(this, 4, 4, "RW", 1, 'b011, 1, 1, 1);
        TALPHA0.configure(this, 4, 0, "RW", 1, 'b110, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBTALPHA_wr_cg";
        TALPHA3_wr : coverpoint TALPHA3.value[3:0];
        TALPHA2_wr : coverpoint TALPHA2.value[3:0];
        TALPHA1_wr : coverpoint TALPHA1.value[3:0];
        TALPHA0_wr : coverpoint TALPHA0.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBTALPHA_rd_cg";
        TALPHA3_rd : coverpoint TALPHA3.value[3:0];
        TALPHA2_rd : coverpoint TALPHA2.value[3:0];
        TALPHA1_rd : coverpoint TALPHA1.value[3:0];
        TALPHA0_rd : coverpoint TALPHA0.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBTALPHA");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBTBETA
//--------------------------------------------------------------------
class MDMBTBETA extends uvm_reg;
    `uvm_object_utils(MDMBTBETA)
    rand uvm_reg_field TBETA3;
    rand uvm_reg_field TBETA2;
    rand uvm_reg_field TBETA1;
    rand uvm_reg_field TBETA0;

    //---build------------------------------------------------------------
    virtual function void build();
        TBETA3 = uvm_reg_field::type_id::create("TBETA3");
        TBETA2 = uvm_reg_field::type_id::create("TBETA2");
        TBETA1 = uvm_reg_field::type_id::create("TBETA1");
        TBETA0 = uvm_reg_field::type_id::create("TBETA0");

        TBETA3.configure(this, 4, 12, "RW", 1, 'b110, 1, 1, 1);
        TBETA2.configure(this, 4, 8, "RW", 1, 'b010, 1, 1, 1);
        TBETA1.configure(this, 4, 4, "RW", 1, 'b011, 1, 1, 1);
        TBETA0.configure(this, 4, 0, "RW", 1, 'b110, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBTBETA_wr_cg";
        TBETA3_wr : coverpoint TBETA3.value[3:0];
        TBETA2_wr : coverpoint TBETA2.value[3:0];
        TBETA1_wr : coverpoint TBETA1.value[3:0];
        TBETA0_wr : coverpoint TBETA0.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBTBETA_rd_cg";
        TBETA3_rd : coverpoint TBETA3.value[3:0];
        TBETA2_rd : coverpoint TBETA2.value[3:0];
        TBETA1_rd : coverpoint TBETA1.value[3:0];
        TBETA0_rd : coverpoint TBETA0.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBTBETA");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBTMU
//--------------------------------------------------------------------
class MDMBTMU extends uvm_reg;
    `uvm_object_utils(MDMBTMU)
    rand uvm_reg_field TMU3;
    rand uvm_reg_field TMU2;
    rand uvm_reg_field TMU1;
    rand uvm_reg_field TMU0;

    //---build------------------------------------------------------------
    virtual function void build();
        TMU3 = uvm_reg_field::type_id::create("TMU3");
        TMU2 = uvm_reg_field::type_id::create("TMU2");
        TMU1 = uvm_reg_field::type_id::create("TMU1");
        TMU0 = uvm_reg_field::type_id::create("TMU0");

        TMU3.configure(this, 4, 12, "RW", 1, 'b101, 1, 1, 1);
        TMU2.configure(this, 4, 8, "RW", 1, 'b101, 1, 1, 1);
        TMU1.configure(this, 4, 4, "RW", 1, 'b101, 1, 1, 1);
        TMU0.configure(this, 4, 0, "RW", 1, 'b101, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBTMU_wr_cg";
        TMU3_wr : coverpoint TMU3.value[3:0];
        TMU2_wr : coverpoint TMU2.value[3:0];
        TMU1_wr : coverpoint TMU1.value[3:0];
        TMU0_wr : coverpoint TMU0.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBTMU_rd_cg";
        TMU3_rd : coverpoint TMU3.value[3:0];
        TMU2_rd : coverpoint TMU2.value[3:0];
        TMU1_rd : coverpoint TMU1.value[3:0];
        TMU0_rd : coverpoint TMU0.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBTMU");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBCNTL1
//--------------------------------------------------------------------
class MDMBCNTL1 extends uvm_reg;
    `uvm_object_utils(MDMBCNTL1)
    rand uvm_reg_field RXLENCHKEN;
    rand uvm_reg_field RXMAXLENGTH;

    //---build------------------------------------------------------------
    virtual function void build();
        RXLENCHKEN = uvm_reg_field::type_id::create("RXLENCHKEN");
        RXMAXLENGTH = uvm_reg_field::type_id::create("RXMAXLENGTH");

        RXLENCHKEN.configure(this, 1, 12, "RW", 1, 'b1, 1, 1, 1);
        RXMAXLENGTH.configure(this, 12, 0, "RW", 1, 'b100100101010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBCNTL1_wr_cg";
        RXLENCHKEN_wr : coverpoint RXLENCHKEN.value[0:0];
        RXMAXLENGTH_wr : coverpoint RXMAXLENGTH.value[11:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBCNTL1_rd_cg";
        RXLENCHKEN_rd : coverpoint RXLENCHKEN.value[0:0];
        RXMAXLENGTH_rd : coverpoint RXMAXLENGTH.value[11:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBCNTL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBRFCNTL
//--------------------------------------------------------------------
class MDMBRFCNTL extends uvm_reg;
    `uvm_object_utils(MDMBRFCNTL)
    rand uvm_reg_field TXENDDEL;

    //---build------------------------------------------------------------
    virtual function void build();
        TXENDDEL = uvm_reg_field::type_id::create("TXENDDEL");

        TXENDDEL.configure(this, 8, 0, "RW", 1, 'b0110000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBRFCNTL_wr_cg";
        TXENDDEL_wr : coverpoint TXENDDEL.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBRFCNTL_rd_cg";
        TXENDDEL_rd : coverpoint TXENDDEL.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBRFCNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBEQCNTL
//--------------------------------------------------------------------
class MDMBEQCNTL extends uvm_reg;
    `uvm_object_utils(MDMBEQCNTL)
    rand uvm_reg_field EQHOLD;
    rand uvm_reg_field COMPTIME;
    rand uvm_reg_field ESTTIME;
    rand uvm_reg_field EQTIME;

    //---build------------------------------------------------------------
    virtual function void build();
        EQHOLD = uvm_reg_field::type_id::create("EQHOLD");
        COMPTIME = uvm_reg_field::type_id::create("COMPTIME");
        ESTTIME = uvm_reg_field::type_id::create("ESTTIME");
        EQTIME = uvm_reg_field::type_id::create("EQTIME");

        EQHOLD.configure(this, 12, 16, "RW", 1, 'b111111111111, 1, 1, 1);
        COMPTIME.configure(this, 5, 10, "RW", 1, 'b0000, 1, 1, 1);
        ESTTIME.configure(this, 5, 5, "RW", 1, 'b0000, 1, 1, 1);
        EQTIME.configure(this, 4, 0, "RW", 1, 'b001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBEQCNTL_wr_cg";
        EQHOLD_wr : coverpoint EQHOLD.value[11:0];
        COMPTIME_wr : coverpoint COMPTIME.value[4:0];
        ESTTIME_wr : coverpoint ESTTIME.value[4:0];
        EQTIME_wr : coverpoint EQTIME.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBEQCNTL_rd_cg";
        EQHOLD_rd : coverpoint EQHOLD.value[11:0];
        COMPTIME_rd : coverpoint COMPTIME.value[4:0];
        ESTTIME_rd : coverpoint ESTTIME.value[4:0];
        EQTIME_rd : coverpoint EQTIME.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBEQCNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBCNTL2
//--------------------------------------------------------------------
class MDMBCNTL2 extends uvm_reg;
    `uvm_object_utils(MDMBCNTL2)
    rand uvm_reg_field PRECOMP;
    rand uvm_reg_field SYNCTIME;
    rand uvm_reg_field LOOPTIME;

    //---build------------------------------------------------------------
    virtual function void build();
        PRECOMP = uvm_reg_field::type_id::create("PRECOMP");
        SYNCTIME = uvm_reg_field::type_id::create("SYNCTIME");
        LOOPTIME = uvm_reg_field::type_id::create("LOOPTIME");

        PRECOMP.configure(this, 6, 16, "RW", 1, 'b111000, 1, 1, 1);
        SYNCTIME.configure(this, 6, 8, "RW", 1, 'b10010, 1, 1, 1);
        LOOPTIME.configure(this, 4, 0, "RW", 1, 'b101, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBCNTL2_wr_cg";
        PRECOMP_wr : coverpoint PRECOMP.value[5:0];
        SYNCTIME_wr : coverpoint SYNCTIME.value[5:0];
        LOOPTIME_wr : coverpoint LOOPTIME.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBCNTL2_rd_cg";
        PRECOMP_rd : coverpoint PRECOMP.value[5:0];
        SYNCTIME_rd : coverpoint SYNCTIME.value[5:0];
        LOOPTIME_rd : coverpoint LOOPTIME.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBCNTL2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBSTAT0
//--------------------------------------------------------------------
class MDMBSTAT0 extends uvm_reg;
    `uvm_object_utils(MDMBSTAT0)
    rand uvm_reg_field EQSUMQ;
    rand uvm_reg_field EQSUMI;
    rand uvm_reg_field DCOFFSETQ;
    rand uvm_reg_field DCOFFSETI;

    //---build------------------------------------------------------------
    virtual function void build();
        EQSUMQ = uvm_reg_field::type_id::create("EQSUMQ");
        EQSUMI = uvm_reg_field::type_id::create("EQSUMI");
        DCOFFSETQ = uvm_reg_field::type_id::create("DCOFFSETQ");
        DCOFFSETI = uvm_reg_field::type_id::create("DCOFFSETI");

        EQSUMQ.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        EQSUMI.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        DCOFFSETQ.configure(this, 6, 8, "RO", 1, 'b00000, 1, 1, 1);
        DCOFFSETI.configure(this, 6, 0, "RO", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBSTAT0_rd_cg";
        EQSUMQ_rd : coverpoint EQSUMQ.value[7:0];
        EQSUMI_rd : coverpoint EQSUMI.value[7:0];
        DCOFFSETQ_rd : coverpoint DCOFFSETQ.value[5:0];
        DCOFFSETI_rd : coverpoint DCOFFSETI.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MDMBSTAT1
//--------------------------------------------------------------------
class MDMBSTAT1 extends uvm_reg;
    `uvm_object_utils(MDMBSTAT1)
    rand uvm_reg_field RXERRORSTAT;
    rand uvm_reg_field EVM;
    rand uvm_reg_field IQGAINESTIM;
    rand uvm_reg_field FREQOFFESTIM;

    //---build------------------------------------------------------------
    virtual function void build();
        RXERRORSTAT = uvm_reg_field::type_id::create("RXERRORSTAT");
        EVM = uvm_reg_field::type_id::create("EVM");
        IQGAINESTIM = uvm_reg_field::type_id::create("IQGAINESTIM");
        FREQOFFESTIM = uvm_reg_field::type_id::create("FREQOFFESTIM");

        RXERRORSTAT.configure(this, 2, 30, "RO", 1, 'b0, 1, 1, 1);
        EVM.configure(this, 13, 16, "RO", 1, 'b000000000000, 1, 1, 1);
        IQGAINESTIM.configure(this, 7, 8, "RO", 1, 'b000000, 1, 1, 1);
        FREQOFFESTIM.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYDSSSCONFIG_MDMBSTAT1_rd_cg";
        RXERRORSTAT_rd : coverpoint RXERRORSTAT.value[1:0];
        EVM_rd : coverpoint EVM.value[12:0];
        IQGAINESTIM_rd : coverpoint IQGAINESTIM.value[6:0];
        FREQOFFESTIM_rd : coverpoint FREQOFFESTIM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MDMBSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class PHYDSSSCONFIG_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(PHYDSSSCONFIG_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins FEBCNTL              = {'h0};
        bins MDMBCNTL              = {'h4};
        bins MDMBPRMINIT              = {'h8};
        bins MDMBTALPHA              = {'hC};
        bins MDMBTBETA              = {'h10};
        bins MDMBTMU              = {'h14};
        bins MDMBCNTL1              = {'h18};
        bins MDMBRFCNTL              = {'h1C};
        bins MDMBEQCNTL              = {'h20};
        bins MDMBCNTL2              = {'h24};
        bins MDMBSTAT0              = {'h28};
        bins MDMBSTAT1              = {'h2C};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "PHYDSSSCONFIG_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: PHYDSSSCONFIG_reg_access_wrapper

//-------------------------------------------------------------------
// PHYDSSSCONFIG_register_block
//--------------------------------------------------------------------
class PHYDSSSCONFIG_register_block extends uvm_reg_block;
    `uvm_object_utils(PHYDSSSCONFIG_register_block)

    rand FEBCNTL FEBCNTL_reg;
    rand MDMBCNTL MDMBCNTL_reg;
    rand MDMBPRMINIT MDMBPRMINIT_reg;
    rand MDMBTALPHA MDMBTALPHA_reg;
    rand MDMBTBETA MDMBTBETA_reg;
    rand MDMBTMU MDMBTMU_reg;
    rand MDMBCNTL1 MDMBCNTL1_reg;
    rand MDMBRFCNTL MDMBRFCNTL_reg;
    rand MDMBEQCNTL MDMBEQCNTL_reg;
    rand MDMBCNTL2 MDMBCNTL2_reg;
    rand MDMBSTAT0 MDMBSTAT0_reg;
    rand MDMBSTAT1 MDMBSTAT1_reg;

    uvm_reg_map PHYDSSSCONFIG_register_map; // Block map
    PHYDSSSCONFIG_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "PHYDSSSCONFIG_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = PHYDSSSCONFIG_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        FEBCNTL_reg = FEBCNTL::type_id::create("FEBCNTL");
        FEBCNTL_reg.configure(this);
        FEBCNTL_reg.build();

        MDMBCNTL_reg = MDMBCNTL::type_id::create("MDMBCNTL");
        MDMBCNTL_reg.configure(this);
        MDMBCNTL_reg.build();

        MDMBPRMINIT_reg = MDMBPRMINIT::type_id::create("MDMBPRMINIT");
        MDMBPRMINIT_reg.configure(this);
        MDMBPRMINIT_reg.build();

        MDMBTALPHA_reg = MDMBTALPHA::type_id::create("MDMBTALPHA");
        MDMBTALPHA_reg.configure(this);
        MDMBTALPHA_reg.build();

        MDMBTBETA_reg = MDMBTBETA::type_id::create("MDMBTBETA");
        MDMBTBETA_reg.configure(this);
        MDMBTBETA_reg.build();

        MDMBTMU_reg = MDMBTMU::type_id::create("MDMBTMU");
        MDMBTMU_reg.configure(this);
        MDMBTMU_reg.build();

        MDMBCNTL1_reg = MDMBCNTL1::type_id::create("MDMBCNTL1");
        MDMBCNTL1_reg.configure(this);
        MDMBCNTL1_reg.build();

        MDMBRFCNTL_reg = MDMBRFCNTL::type_id::create("MDMBRFCNTL");
        MDMBRFCNTL_reg.configure(this);
        MDMBRFCNTL_reg.build();

        MDMBEQCNTL_reg = MDMBEQCNTL::type_id::create("MDMBEQCNTL");
        MDMBEQCNTL_reg.configure(this);
        MDMBEQCNTL_reg.build();

        MDMBCNTL2_reg = MDMBCNTL2::type_id::create("MDMBCNTL2");
        MDMBCNTL2_reg.configure(this);
        MDMBCNTL2_reg.build();

        MDMBSTAT0_reg = MDMBSTAT0::type_id::create("MDMBSTAT0");
        MDMBSTAT0_reg.configure(this);
        MDMBSTAT0_reg.build();

        MDMBSTAT1_reg = MDMBSTAT1::type_id::create("MDMBSTAT1");
        MDMBSTAT1_reg.configure(this);
        MDMBSTAT1_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        PHYDSSSCONFIG_register_map = create_map("PHYDSSSCONFIG_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        PHYDSSSCONFIG_register_map.add_reg(FEBCNTL_reg, 'h0, "RW");
        PHYDSSSCONFIG_register_map.add_reg(MDMBCNTL_reg, 'h4, "RW");
        PHYDSSSCONFIG_register_map.add_reg(MDMBPRMINIT_reg, 'h8, "RW");
        PHYDSSSCONFIG_register_map.add_reg(MDMBTALPHA_reg, 'hC, "RW");
        PHYDSSSCONFIG_register_map.add_reg(MDMBTBETA_reg, 'h10, "RW");
        PHYDSSSCONFIG_register_map.add_reg(MDMBTMU_reg, 'h14, "RW");
        PHYDSSSCONFIG_register_map.add_reg(MDMBCNTL1_reg, 'h18, "RW");
        PHYDSSSCONFIG_register_map.add_reg(MDMBRFCNTL_reg, 'h1C, "RW");
        PHYDSSSCONFIG_register_map.add_reg(MDMBEQCNTL_reg, 'h20, "RW");
        PHYDSSSCONFIG_register_map.add_reg(MDMBCNTL2_reg, 'h24, "RW");
        PHYDSSSCONFIG_register_map.add_reg(MDMBSTAT0_reg, 'h28, "RO");
        PHYDSSSCONFIG_register_map.add_reg(MDMBSTAT1_reg, 'h2C, "RO");

        // Lock the register model and build the map
        lock_model();
        PHYDSSSCONFIG_register_map.set_check_on_read();
    endfunction

endclass
`endif // __PHYDSSSCONFIG_REG_BLOCK_SV__
