//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : lmesaros
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 30649 $
// $Date: 2017-06-06 11:33:55 +0200 (Tue, 06 Jun 2017) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for PHYSTATUS
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __PHYSTATUS_REG_BLOCK_SV__
`define __PHYSTATUS_REG_BLOCK_SV__

//--------------------------------------------------------------------
// HDMCONFIG
//--------------------------------------------------------------------
class HDMCONFIG extends uvm_reg;
    `uvm_object_utils(HDMCONFIG)
    rand uvm_reg_field MUMIMOTX;
    rand uvm_reg_field MUMIMORX;
    rand uvm_reg_field BFMER;
    rand uvm_reg_field BFMEE;
    rand uvm_reg_field LDPCDEC;
    rand uvm_reg_field LDPCENC;
    rand uvm_reg_field CHBW;
    rand uvm_reg_field DSSSCCK;
    rand uvm_reg_field VHT;
    rand uvm_reg_field NESS;
    rand uvm_reg_field RFMODE;
    rand uvm_reg_field NSTS;
    rand uvm_reg_field NSS;
    rand uvm_reg_field NTX;
    rand uvm_reg_field NRX;

    //---build------------------------------------------------------------
    virtual function void build();
        MUMIMOTX = uvm_reg_field::type_id::create("MUMIMOTX");
        MUMIMORX = uvm_reg_field::type_id::create("MUMIMORX");
        BFMER = uvm_reg_field::type_id::create("BFMER");
        BFMEE = uvm_reg_field::type_id::create("BFMEE");
        LDPCDEC = uvm_reg_field::type_id::create("LDPCDEC");
        LDPCENC = uvm_reg_field::type_id::create("LDPCENC");
        CHBW = uvm_reg_field::type_id::create("CHBW");
        DSSSCCK = uvm_reg_field::type_id::create("DSSSCCK");
        VHT = uvm_reg_field::type_id::create("VHT");
        NESS = uvm_reg_field::type_id::create("NESS");
        RFMODE = uvm_reg_field::type_id::create("RFMODE");
        NSTS = uvm_reg_field::type_id::create("NSTS");
        NSS = uvm_reg_field::type_id::create("NSS");
        NTX = uvm_reg_field::type_id::create("NTX");
        NRX = uvm_reg_field::type_id::create("NRX");

        MUMIMOTX.configure(this, 1, 31, "RO", 1, 'b0, 1, 1, 1);
        MUMIMORX.configure(this, 1, 30, "RO", 1, 'b0, 1, 1, 1);
        BFMER.configure(this, 1, 29, "RO", 1, 'b0, 1, 1, 1);
        BFMEE.configure(this, 1, 28, "RO", 1, 'b0, 1, 1, 1);
        LDPCDEC.configure(this, 1, 27, "RO", 1, 'b0, 1, 1, 1);
        LDPCENC.configure(this, 1, 26, "RO", 1, 'b0, 1, 1, 1);
        CHBW.configure(this, 2, 24, "RO", 1, 'b0, 1, 1, 1);
        DSSSCCK.configure(this, 1, 23, "RO", 1, 'b1, 1, 1, 1);
        VHT.configure(this, 1, 22, "RO", 1, 'b1, 1, 1, 1);
        NESS.configure(this, 2, 20, "RO", 1, 'b0, 1, 1, 1);
        RFMODE.configure(this, 4, 16, "RO", 1, 'b010, 1, 1, 1);
        NSTS.configure(this, 4, 12, "RO", 1, 'b010, 1, 1, 1);
        NSS.configure(this, 4, 8, "RO", 1, 'b010, 1, 1, 1);
        NTX.configure(this, 4, 4, "RO", 1, 'b010, 1, 1, 1);
        NRX.configure(this, 4, 0, "RO", 1, 'b010, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_HDMCONFIG_rd_cg";
        MUMIMOTX_rd : coverpoint MUMIMOTX.value[0:0];
        MUMIMORX_rd : coverpoint MUMIMORX.value[0:0];
        BFMER_rd : coverpoint BFMER.value[0:0];
        BFMEE_rd : coverpoint BFMEE.value[0:0];
        LDPCDEC_rd : coverpoint LDPCDEC.value[0:0];
        LDPCENC_rd : coverpoint LDPCENC.value[0:0];
        CHBW_rd : coverpoint CHBW.value[1:0];
        DSSSCCK_rd : coverpoint DSSSCCK.value[0:0];
        VHT_rd : coverpoint VHT.value[0:0];
        NESS_rd : coverpoint NESS.value[1:0];
        RFMODE_rd : coverpoint RFMODE.value[3:0];
        NSTS_rd : coverpoint NSTS.value[3:0];
        NSS_rd : coverpoint NSS.value[3:0];
        NTX_rd : coverpoint NTX.value[3:0];
        NRX_rd : coverpoint NRX.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HDMCONFIG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TDOFFSETSTAT0
//--------------------------------------------------------------------
class TDOFFSETSTAT0 extends uvm_reg;
    `uvm_object_utils(TDOFFSETSTAT0)
    rand uvm_reg_field COARSEFOANGLE;

    //---build------------------------------------------------------------
    virtual function void build();
        COARSEFOANGLE = uvm_reg_field::type_id::create("COARSEFOANGLE");

        COARSEFOANGLE.configure(this, 21, 0, "RO", 1, 'b00000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_TDOFFSETSTAT0_rd_cg";
        COARSEFOANGLE_rd : coverpoint COARSEFOANGLE.value[20:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TDOFFSETSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TDOFFSETSTAT1
//--------------------------------------------------------------------
class TDOFFSETSTAT1 extends uvm_reg;
    `uvm_object_utils(TDOFFSETSTAT1)
    rand uvm_reg_field FINEFOANGLE;

    //---build------------------------------------------------------------
    virtual function void build();
        FINEFOANGLE = uvm_reg_field::type_id::create("FINEFOANGLE");

        FINEFOANGLE.configure(this, 21, 0, "RO", 1, 'b00000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_TDOFFSETSTAT1_rd_cg";
        FINEFOANGLE_rd : coverpoint FINEFOANGLE.value[20:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TDOFFSETSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FDTOFFSETSTAT0
//--------------------------------------------------------------------
class FDTOFFSETSTAT0 extends uvm_reg;
    `uvm_object_utils(FDTOFFSETSTAT0)
    rand uvm_reg_field STOSLOPESTAT;
    rand uvm_reg_field TDSYNCHOFFSTAT;

    //---build------------------------------------------------------------
    virtual function void build();
        STOSLOPESTAT = uvm_reg_field::type_id::create("STOSLOPESTAT");
        TDSYNCHOFFSTAT = uvm_reg_field::type_id::create("TDSYNCHOFFSTAT");

        STOSLOPESTAT.configure(this, 18, 12, "RO", 1, 'b00000000000000000, 1, 1, 1);
        TDSYNCHOFFSTAT.configure(this, 6, 0, "RO", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_FDTOFFSETSTAT0_rd_cg";
        STOSLOPESTAT_rd : coverpoint STOSLOPESTAT.value[17:0];
        TDSYNCHOFFSTAT_rd : coverpoint TDSYNCHOFFSTAT.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FDTOFFSETSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// FDTOFFSETSTAT1
//--------------------------------------------------------------------
class FDTOFFSETSTAT1 extends uvm_reg;
    `uvm_object_utils(FDTOFFSETSTAT1)
    rand uvm_reg_field CPESLOPESTAT;

    //---build------------------------------------------------------------
    virtual function void build();
        CPESLOPESTAT = uvm_reg_field::type_id::create("CPESLOPESTAT");

        CPESLOPESTAT.configure(this, 18, 0, "RO", 1, 'b00000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_FDTOFFSETSTAT1_rd_cg";
        CPESLOPESTAT_rd : coverpoint CPESLOPESTAT.value[17:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "FDTOFFSETSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TBESTAT
//--------------------------------------------------------------------
class TBESTAT extends uvm_reg;
    `uvm_object_utils(TBESTAT)
    rand uvm_reg_field TBEMaxCorrValSum;
    rand uvm_reg_field TBECOUNT;

    //---build------------------------------------------------------------
    virtual function void build();
        TBEMaxCorrValSum = uvm_reg_field::type_id::create("TBEMaxCorrValSum");
        TBECOUNT = uvm_reg_field::type_id::create("TBECOUNT");

        TBEMaxCorrValSum.configure(this, 13, 8, "RO", 1, 'b000000000000, 1, 1, 1);
        TBECOUNT.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_TBESTAT_rd_cg";
        TBEMaxCorrValSum_rd : coverpoint TBEMaxCorrValSum.value[12:0];
        TBECOUNT_rd : coverpoint TBECOUNT.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TBESTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BFMERSTAT0
//--------------------------------------------------------------------
class BFMERSTAT0 extends uvm_reg;
    `uvm_object_utils(BFMERSTAT0)
    rand uvm_reg_field BFMERMemSize;

    //---build------------------------------------------------------------
    virtual function void build();
        BFMERMemSize = uvm_reg_field::type_id::create("BFMERMemSize");

        BFMERMemSize.configure(this, 5, 0, "RO", 1, 'b0000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_BFMERSTAT0_rd_cg";
        BFMERMemSize_rd : coverpoint BFMERMemSize.value[4:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BFMERSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EVENTFLAGSTAT
//--------------------------------------------------------------------
class EVENTFLAGSTAT extends uvm_reg;
    `uvm_object_utils(EVENTFLAGSTAT)
    rand uvm_reg_field EVENTCLEAR;
    rand uvm_reg_field EVENTFLAG;

    //---build------------------------------------------------------------
    virtual function void build();
        EVENTCLEAR = uvm_reg_field::type_id::create("EVENTCLEAR");
        EVENTFLAG = uvm_reg_field::type_id::create("EVENTFLAG");

        EVENTCLEAR.configure(this, 1, 31, "W1S", 1, 'b0, 1, 1, 1);
        EVENTFLAG.configure(this, 31, 0, "RO", 1, 'b000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_EVENTFLAGSTAT_rd_cg";
        EVENTFLAG_rd : coverpoint EVENTFLAG.value[30:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EVENTFLAGSTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BFMERSTAT1
//--------------------------------------------------------------------
class BFMERSTAT1 extends uvm_reg;
    `uvm_object_utils(BFMERSTAT1)
    rand uvm_reg_field BFMERNSD;
    rand uvm_reg_field BFMERRhoMuAcc;

    //---build------------------------------------------------------------
    virtual function void build();
        BFMERNSD = uvm_reg_field::type_id::create("BFMERNSD");
        BFMERRhoMuAcc = uvm_reg_field::type_id::create("BFMERRhoMuAcc");

        BFMERNSD.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        BFMERRhoMuAcc.configure(this, 22, 0, "RO", 1, 'b000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_BFMERSTAT1_rd_cg";
        BFMERNSD_rd : coverpoint BFMERNSD.value[7:0];
        BFMERRhoMuAcc_rd : coverpoint BFMERRhoMuAcc.value[21:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BFMERSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BFMERSTAT2
//--------------------------------------------------------------------
class BFMERSTAT2 extends uvm_reg;
    `uvm_object_utils(BFMERSTAT2)
    rand uvm_reg_field BFMERpMuMin;
    rand uvm_reg_field BFMERRhoMuMax;

    //---build------------------------------------------------------------
    virtual function void build();
        BFMERpMuMin = uvm_reg_field::type_id::create("BFMERpMuMin");
        BFMERRhoMuMax = uvm_reg_field::type_id::create("BFMERRhoMuMax");

        BFMERpMuMin.configure(this, 12, 16, "RO", 1, 'b00000000000, 1, 1, 1);
        BFMERRhoMuMax.configure(this, 13, 0, "RO", 1, 'b000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_BFMERSTAT2_rd_cg";
        BFMERpMuMin_rd : coverpoint BFMERpMuMin.value[11:0];
        BFMERRhoMuMax_rd : coverpoint BFMERRhoMuMax.value[12:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BFMERSTAT2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BFMERERRSTAT
//--------------------------------------------------------------------
class BFMERERRSTAT extends uvm_reg;
    `uvm_object_utils(BFMERERRSTAT)
    rand uvm_reg_field BFMERSecChanRptBwErr;
    rand uvm_reg_field BFMERSecFrameRptBwErr;
    rand uvm_reg_field BFMERSecGroupingErr;
    rand uvm_reg_field BFMERSecNcErr;
    rand uvm_reg_field BFMERSecNrErr;
    rand uvm_reg_field BFMERSecHdrAddrErr;
    rand uvm_reg_field BFMERSUNcNssErr;
    rand uvm_reg_field BFMERPrimChanRptBwErr;
    rand uvm_reg_field BFMERPrimFrameRptBwErr;
    rand uvm_reg_field BFMERPrimGroupingErr;
    rand uvm_reg_field BFMERPrimNcErr;
    rand uvm_reg_field BFMERPrimNrErr;
    rand uvm_reg_field BFMERPrimHdrAddrErr;

    //---build------------------------------------------------------------
    virtual function void build();
        BFMERSecChanRptBwErr = uvm_reg_field::type_id::create("BFMERSecChanRptBwErr");
        BFMERSecFrameRptBwErr = uvm_reg_field::type_id::create("BFMERSecFrameRptBwErr");
        BFMERSecGroupingErr = uvm_reg_field::type_id::create("BFMERSecGroupingErr");
        BFMERSecNcErr = uvm_reg_field::type_id::create("BFMERSecNcErr");
        BFMERSecNrErr = uvm_reg_field::type_id::create("BFMERSecNrErr");
        BFMERSecHdrAddrErr = uvm_reg_field::type_id::create("BFMERSecHdrAddrErr");
        BFMERSUNcNssErr = uvm_reg_field::type_id::create("BFMERSUNcNssErr");
        BFMERPrimChanRptBwErr = uvm_reg_field::type_id::create("BFMERPrimChanRptBwErr");
        BFMERPrimFrameRptBwErr = uvm_reg_field::type_id::create("BFMERPrimFrameRptBwErr");
        BFMERPrimGroupingErr = uvm_reg_field::type_id::create("BFMERPrimGroupingErr");
        BFMERPrimNcErr = uvm_reg_field::type_id::create("BFMERPrimNcErr");
        BFMERPrimNrErr = uvm_reg_field::type_id::create("BFMERPrimNrErr");
        BFMERPrimHdrAddrErr = uvm_reg_field::type_id::create("BFMERPrimHdrAddrErr");

        BFMERSecChanRptBwErr.configure(this, 1, 21, "RO", 1, 'b0, 1, 1, 1);
        BFMERSecFrameRptBwErr.configure(this, 1, 20, "RO", 1, 'b0, 1, 1, 1);
        BFMERSecGroupingErr.configure(this, 1, 19, "RO", 1, 'b0, 1, 1, 1);
        BFMERSecNcErr.configure(this, 1, 18, "RO", 1, 'b0, 1, 1, 1);
        BFMERSecNrErr.configure(this, 1, 17, "RO", 1, 'b0, 1, 1, 1);
        BFMERSecHdrAddrErr.configure(this, 1, 16, "RO", 1, 'b0, 1, 1, 1);
        BFMERSUNcNssErr.configure(this, 1, 8, "RO", 1, 'b0, 1, 1, 1);
        BFMERPrimChanRptBwErr.configure(this, 1, 5, "RO", 1, 'b0, 1, 1, 1);
        BFMERPrimFrameRptBwErr.configure(this, 1, 4, "RO", 1, 'b0, 1, 1, 1);
        BFMERPrimGroupingErr.configure(this, 1, 3, "RO", 1, 'b0, 1, 1, 1);
        BFMERPrimNcErr.configure(this, 1, 2, "RO", 1, 'b0, 1, 1, 1);
        BFMERPrimNrErr.configure(this, 1, 1, "RO", 1, 'b0, 1, 1, 1);
        BFMERPrimHdrAddrErr.configure(this, 1, 0, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_BFMERERRSTAT_rd_cg";
        BFMERSecChanRptBwErr_rd : coverpoint BFMERSecChanRptBwErr.value[0:0];
        BFMERSecFrameRptBwErr_rd : coverpoint BFMERSecFrameRptBwErr.value[0:0];
        BFMERSecGroupingErr_rd : coverpoint BFMERSecGroupingErr.value[0:0];
        BFMERSecNcErr_rd : coverpoint BFMERSecNcErr.value[0:0];
        BFMERSecNrErr_rd : coverpoint BFMERSecNrErr.value[0:0];
        BFMERSecHdrAddrErr_rd : coverpoint BFMERSecHdrAddrErr.value[0:0];
        BFMERSUNcNssErr_rd : coverpoint BFMERSUNcNssErr.value[0:0];
        BFMERPrimChanRptBwErr_rd : coverpoint BFMERPrimChanRptBwErr.value[0:0];
        BFMERPrimFrameRptBwErr_rd : coverpoint BFMERPrimFrameRptBwErr.value[0:0];
        BFMERPrimGroupingErr_rd : coverpoint BFMERPrimGroupingErr.value[0:0];
        BFMERPrimNcErr_rd : coverpoint BFMERPrimNcErr.value[0:0];
        BFMERPrimNrErr_rd : coverpoint BFMERPrimNrErr.value[0:0];
        BFMERPrimHdrAddrErr_rd : coverpoint BFMERPrimHdrAddrErr.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BFMERERRSTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BFMERSTAT3
//--------------------------------------------------------------------
class BFMERSTAT3 extends uvm_reg;
    `uvm_object_utils(BFMERSTAT3)
    rand uvm_reg_field BFMERpMuAcc;

    //---build------------------------------------------------------------
    virtual function void build();
        BFMERpMuAcc = uvm_reg_field::type_id::create("BFMERpMuAcc");

        BFMERpMuAcc.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_BFMERSTAT3_rd_cg";
        BFMERpMuAcc_rd : coverpoint BFMERpMuAcc.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BFMERSTAT3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BFMERSTAT4
//--------------------------------------------------------------------
class BFMERSTAT4 extends uvm_reg;
    `uvm_object_utils(BFMERSTAT4)
    rand uvm_reg_field BFMERSMMIndexSec;
    rand uvm_reg_field BFMERSMMIndexPrim;

    //---build------------------------------------------------------------
    virtual function void build();
        BFMERSMMIndexSec = uvm_reg_field::type_id::create("BFMERSMMIndexSec");
        BFMERSMMIndexPrim = uvm_reg_field::type_id::create("BFMERSMMIndexPrim");

        BFMERSMMIndexSec.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        BFMERSMMIndexPrim.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_BFMERSTAT4_rd_cg";
        BFMERSMMIndexSec_rd : coverpoint BFMERSMMIndexSec.value[7:0];
        BFMERSMMIndexPrim_rd : coverpoint BFMERSMMIndexPrim.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BFMERSTAT4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EQUALSTAT0
//--------------------------------------------------------------------
class EQUALSTAT0 extends uvm_reg;
    `uvm_object_utils(EQUALSTAT0)
    rand uvm_reg_field MHSTAT;

    //---build------------------------------------------------------------
    virtual function void build();
        MHSTAT = uvm_reg_field::type_id::create("MHSTAT");

        MHSTAT.configure(this, 28, 0, "RO", 1, 'b000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_EQUALSTAT0_rd_cg";
        MHSTAT_rd : coverpoint MHSTAT.value[27:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EQUALSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EQUALSTAT1
//--------------------------------------------------------------------
class EQUALSTAT1 extends uvm_reg;
    `uvm_object_utils(EQUALSTAT1)
    rand uvm_reg_field MHSCMAXSTAT;

    //---build------------------------------------------------------------
    virtual function void build();
        MHSCMAXSTAT = uvm_reg_field::type_id::create("MHSCMAXSTAT");

        MHSCMAXSTAT.configure(this, 20, 0, "RO", 1, 'b0000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_EQUALSTAT1_rd_cg";
        MHSCMAXSTAT_rd : coverpoint MHSCMAXSTAT.value[19:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EQUALSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HDMVERSION
//--------------------------------------------------------------------
class HDMVERSION extends uvm_reg;
    `uvm_object_utils(HDMVERSION)
    rand uvm_reg_field Version;
    rand uvm_reg_field Release;

    //---build------------------------------------------------------------
    virtual function void build();
        Version = uvm_reg_field::type_id::create("Version");
        Release = uvm_reg_field::type_id::create("Release");

        Version.configure(this, 16, 16, "RO", 1, 'b000000000000001, 1, 1, 1);
        Release.configure(this, 16, 0, "RO", 1, 'b000000000000001, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_HDMVERSION_rd_cg";
        Version_rd : coverpoint Version.value[15:0];
        Release_rd : coverpoint Release.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HDMVERSION");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BFMERSTAT5
//--------------------------------------------------------------------
class BFMERSTAT5 extends uvm_reg;
    `uvm_object_utils(BFMERSTAT5)
    rand uvm_reg_field BFMERHeaderPrim;

    //---build------------------------------------------------------------
    virtual function void build();
        BFMERHeaderPrim = uvm_reg_field::type_id::create("BFMERHeaderPrim");

        BFMERHeaderPrim.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_BFMERSTAT5_rd_cg";
        BFMERHeaderPrim_rd : coverpoint BFMERHeaderPrim.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BFMERSTAT5");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// BFMERSTAT6
//--------------------------------------------------------------------
class BFMERSTAT6 extends uvm_reg;
    `uvm_object_utils(BFMERSTAT6)
    rand uvm_reg_field BFMERHeaderSec;

    //---build------------------------------------------------------------
    virtual function void build();
        BFMERHeaderSec = uvm_reg_field::type_id::create("BFMERHeaderSec");

        BFMERHeaderSec.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PHYSTATUS_BFMERSTAT6_rd_cg";
        BFMERHeaderSec_rd : coverpoint BFMERHeaderSec.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "BFMERSTAT6");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class PHYSTATUS_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(PHYSTATUS_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins HDMCONFIG              = {'h0};
        bins TDOFFSETSTAT0              = {'h4};
        bins TDOFFSETSTAT1              = {'h8};
        bins FDTOFFSETSTAT0              = {'hC};
        bins FDTOFFSETSTAT1              = {'h10};
        bins TBESTAT              = {'h14};
        bins BFMERSTAT0              = {'h18};
        bins EVENTFLAGSTAT              = {'h1C};
        bins BFMERSTAT1              = {'h20};
        bins BFMERSTAT2              = {'h24};
        bins BFMERERRSTAT              = {'h28};
        bins BFMERSTAT3              = {'h2C};
        bins BFMERSTAT4              = {'h30};
        bins EQUALSTAT0              = {'h34};
        bins EQUALSTAT1              = {'h38};
        bins HDMVERSION              = {'h3C};
        bins BFMERSTAT5              = {'h40};
        bins BFMERSTAT6              = {'h44};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "PHYSTATUS_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: PHYSTATUS_reg_access_wrapper

//-------------------------------------------------------------------
// PHYSTATUS_register_block
//--------------------------------------------------------------------
class PHYSTATUS_register_block extends uvm_reg_block;
    `uvm_object_utils(PHYSTATUS_register_block)

    rand HDMCONFIG HDMCONFIG_reg;
    rand TDOFFSETSTAT0 TDOFFSETSTAT0_reg;
    rand TDOFFSETSTAT1 TDOFFSETSTAT1_reg;
    rand FDTOFFSETSTAT0 FDTOFFSETSTAT0_reg;
    rand FDTOFFSETSTAT1 FDTOFFSETSTAT1_reg;
    rand TBESTAT TBESTAT_reg;
    rand BFMERSTAT0 BFMERSTAT0_reg;
    rand EVENTFLAGSTAT EVENTFLAGSTAT_reg;
    rand BFMERSTAT1 BFMERSTAT1_reg;
    rand BFMERSTAT2 BFMERSTAT2_reg;
    rand BFMERERRSTAT BFMERERRSTAT_reg;
    rand BFMERSTAT3 BFMERSTAT3_reg;
    rand BFMERSTAT4 BFMERSTAT4_reg;
    rand EQUALSTAT0 EQUALSTAT0_reg;
    rand EQUALSTAT1 EQUALSTAT1_reg;
    rand HDMVERSION HDMVERSION_reg;
    rand BFMERSTAT5 BFMERSTAT5_reg;
    rand BFMERSTAT6 BFMERSTAT6_reg;

    uvm_reg_map PHYSTATUS_register_map; // Block map
    PHYSTATUS_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "PHYSTATUS_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = PHYSTATUS_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        HDMCONFIG_reg = HDMCONFIG::type_id::create("HDMCONFIG");
        HDMCONFIG_reg.configure(this);
        HDMCONFIG_reg.build();

        TDOFFSETSTAT0_reg = TDOFFSETSTAT0::type_id::create("TDOFFSETSTAT0");
        TDOFFSETSTAT0_reg.configure(this);
        TDOFFSETSTAT0_reg.build();

        TDOFFSETSTAT1_reg = TDOFFSETSTAT1::type_id::create("TDOFFSETSTAT1");
        TDOFFSETSTAT1_reg.configure(this);
        TDOFFSETSTAT1_reg.build();

        FDTOFFSETSTAT0_reg = FDTOFFSETSTAT0::type_id::create("FDTOFFSETSTAT0");
        FDTOFFSETSTAT0_reg.configure(this);
        FDTOFFSETSTAT0_reg.build();

        FDTOFFSETSTAT1_reg = FDTOFFSETSTAT1::type_id::create("FDTOFFSETSTAT1");
        FDTOFFSETSTAT1_reg.configure(this);
        FDTOFFSETSTAT1_reg.build();

        TBESTAT_reg = TBESTAT::type_id::create("TBESTAT");
        TBESTAT_reg.configure(this);
        TBESTAT_reg.build();

        BFMERSTAT0_reg = BFMERSTAT0::type_id::create("BFMERSTAT0");
        BFMERSTAT0_reg.configure(this);
        BFMERSTAT0_reg.build();

        EVENTFLAGSTAT_reg = EVENTFLAGSTAT::type_id::create("EVENTFLAGSTAT");
        EVENTFLAGSTAT_reg.configure(this);
        EVENTFLAGSTAT_reg.build();

        BFMERSTAT1_reg = BFMERSTAT1::type_id::create("BFMERSTAT1");
        BFMERSTAT1_reg.configure(this);
        BFMERSTAT1_reg.build();

        BFMERSTAT2_reg = BFMERSTAT2::type_id::create("BFMERSTAT2");
        BFMERSTAT2_reg.configure(this);
        BFMERSTAT2_reg.build();

        BFMERERRSTAT_reg = BFMERERRSTAT::type_id::create("BFMERERRSTAT");
        BFMERERRSTAT_reg.configure(this);
        BFMERERRSTAT_reg.build();

        BFMERSTAT3_reg = BFMERSTAT3::type_id::create("BFMERSTAT3");
        BFMERSTAT3_reg.configure(this);
        BFMERSTAT3_reg.build();

        BFMERSTAT4_reg = BFMERSTAT4::type_id::create("BFMERSTAT4");
        BFMERSTAT4_reg.configure(this);
        BFMERSTAT4_reg.build();

        EQUALSTAT0_reg = EQUALSTAT0::type_id::create("EQUALSTAT0");
        EQUALSTAT0_reg.configure(this);
        EQUALSTAT0_reg.build();

        EQUALSTAT1_reg = EQUALSTAT1::type_id::create("EQUALSTAT1");
        EQUALSTAT1_reg.configure(this);
        EQUALSTAT1_reg.build();

        HDMVERSION_reg = HDMVERSION::type_id::create("HDMVERSION");
        HDMVERSION_reg.configure(this);
        HDMVERSION_reg.build();

        BFMERSTAT5_reg = BFMERSTAT5::type_id::create("BFMERSTAT5");
        BFMERSTAT5_reg.configure(this);
        BFMERSTAT5_reg.build();

        BFMERSTAT6_reg = BFMERSTAT6::type_id::create("BFMERSTAT6");
        BFMERSTAT6_reg.configure(this);
        BFMERSTAT6_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        PHYSTATUS_register_map = create_map("PHYSTATUS_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        PHYSTATUS_register_map.add_reg(HDMCONFIG_reg, 'h0, "RO");
        PHYSTATUS_register_map.add_reg(TDOFFSETSTAT0_reg, 'h4, "RO");
        PHYSTATUS_register_map.add_reg(TDOFFSETSTAT1_reg, 'h8, "RO");
        PHYSTATUS_register_map.add_reg(FDTOFFSETSTAT0_reg, 'hC, "RO");
        PHYSTATUS_register_map.add_reg(FDTOFFSETSTAT1_reg, 'h10, "RO");
        PHYSTATUS_register_map.add_reg(TBESTAT_reg, 'h14, "RO");
        PHYSTATUS_register_map.add_reg(BFMERSTAT0_reg, 'h18, "RO");
        PHYSTATUS_register_map.add_reg(EVENTFLAGSTAT_reg, 'h1C, "RW");
        PHYSTATUS_register_map.add_reg(BFMERSTAT1_reg, 'h20, "RO");
        PHYSTATUS_register_map.add_reg(BFMERSTAT2_reg, 'h24, "RO");
        PHYSTATUS_register_map.add_reg(BFMERERRSTAT_reg, 'h28, "RO");
        PHYSTATUS_register_map.add_reg(BFMERSTAT3_reg, 'h2C, "RO");
        PHYSTATUS_register_map.add_reg(BFMERSTAT4_reg, 'h30, "RO");
        PHYSTATUS_register_map.add_reg(EQUALSTAT0_reg, 'h34, "RO");
        PHYSTATUS_register_map.add_reg(EQUALSTAT1_reg, 'h38, "RO");
        PHYSTATUS_register_map.add_reg(HDMVERSION_reg, 'h3C, "RO");
        PHYSTATUS_register_map.add_reg(BFMERSTAT5_reg, 'h40, "RO");
        PHYSTATUS_register_map.add_reg(BFMERSTAT6_reg, 'h44, "RO");

        // Lock the register model and build the map
        lock_model();
        PHYSTATUS_register_map.set_check_on_read();
    endfunction

endclass
`endif // __PHYSTATUS_REG_BLOCK_SV__
