//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for PTA
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __PTA_REG_BLOCK_SV__
`define __PTA_REG_BLOCK_SV__

//--------------------------------------------------------------------
// REVISION
//--------------------------------------------------------------------
class REVISION extends uvm_reg;
    `uvm_object_utils(REVISION)
    rand uvm_reg_field pta_revision;

    //---build------------------------------------------------------------
    virtual function void build();
        pta_revision = uvm_reg_field::type_id::create("pta_revision");

        pta_revision.configure(this, 32, 0, "RO", 1, 'b0000000000000010000000000000001, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PTA_REVISION_rd_cg";
        pta_revision_rd : coverpoint pta_revision.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "REVISION");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// CONFIG
//--------------------------------------------------------------------
class CONFIG extends uvm_reg;
    `uvm_object_utils(CONFIG)
    rand uvm_reg_field abortrx_when_tx;
    rand uvm_reg_field sw_wlan_rx_abort;
    rand uvm_reg_field sw_wlan_tx_abort;
    rand uvm_reg_field sw_bt_rx_abort;
    rand uvm_reg_field sw_bt_tx_abort;
    rand uvm_reg_field chan_margin;
    rand uvm_reg_field wlan_pti_mode;
    rand uvm_reg_field bt_event_mask;
    rand uvm_reg_field chan_enable;
    rand uvm_reg_field pti_enable;
    rand uvm_reg_field no_sim_rx;
    rand uvm_reg_field no_sim_tx;
    rand uvm_reg_field basic_priority;
    rand uvm_reg_field pta_enable;

    //---build------------------------------------------------------------
    virtual function void build();
        abortrx_when_tx = uvm_reg_field::type_id::create("abortrx_when_tx");
        sw_wlan_rx_abort = uvm_reg_field::type_id::create("sw_wlan_rx_abort");
        sw_wlan_tx_abort = uvm_reg_field::type_id::create("sw_wlan_tx_abort");
        sw_bt_rx_abort = uvm_reg_field::type_id::create("sw_bt_rx_abort");
        sw_bt_tx_abort = uvm_reg_field::type_id::create("sw_bt_tx_abort");
        chan_margin = uvm_reg_field::type_id::create("chan_margin");
        wlan_pti_mode = uvm_reg_field::type_id::create("wlan_pti_mode");
        bt_event_mask = uvm_reg_field::type_id::create("bt_event_mask");
        chan_enable = uvm_reg_field::type_id::create("chan_enable");
        pti_enable = uvm_reg_field::type_id::create("pti_enable");
        no_sim_rx = uvm_reg_field::type_id::create("no_sim_rx");
        no_sim_tx = uvm_reg_field::type_id::create("no_sim_tx");
        basic_priority = uvm_reg_field::type_id::create("basic_priority");
        pta_enable = uvm_reg_field::type_id::create("pta_enable");

        abortrx_when_tx.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        sw_wlan_rx_abort.configure(this, 1, 19, "RW", 1, 'b0, 1, 1, 1);
        sw_wlan_tx_abort.configure(this, 1, 18, "RW", 1, 'b0, 1, 1, 1);
        sw_bt_rx_abort.configure(this, 1, 17, "RW", 1, 'b0, 1, 1, 1);
        sw_bt_tx_abort.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        chan_margin.configure(this, 6, 8, "RW", 1, 'b00000, 1, 1, 1);
        wlan_pti_mode.configure(this, 1, 7, "RW", 1, 'b0, 1, 1, 1);
        bt_event_mask.configure(this, 1, 6, "RW", 1, 'b0, 1, 1, 1);
        chan_enable.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        pti_enable.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        no_sim_rx.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        no_sim_tx.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        basic_priority.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        pta_enable.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PTA_CONFIG_wr_cg";
        abortrx_when_tx_wr : coverpoint abortrx_when_tx.value[0:0];
        sw_wlan_rx_abort_wr : coverpoint sw_wlan_rx_abort.value[0:0];
        sw_wlan_tx_abort_wr : coverpoint sw_wlan_tx_abort.value[0:0];
        sw_bt_rx_abort_wr : coverpoint sw_bt_rx_abort.value[0:0];
        sw_bt_tx_abort_wr : coverpoint sw_bt_tx_abort.value[0:0];
        chan_margin_wr : coverpoint chan_margin.value[5:0];
        wlan_pti_mode_wr : coverpoint wlan_pti_mode.value[0:0];
        bt_event_mask_wr : coverpoint bt_event_mask.value[0:0];
        chan_enable_wr : coverpoint chan_enable.value[0:0];
        pti_enable_wr : coverpoint pti_enable.value[0:0];
        no_sim_rx_wr : coverpoint no_sim_rx.value[0:0];
        no_sim_tx_wr : coverpoint no_sim_tx.value[0:0];
        basic_priority_wr : coverpoint basic_priority.value[0:0];
        pta_enable_wr : coverpoint pta_enable.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PTA_CONFIG_rd_cg";
        abortrx_when_tx_rd : coverpoint abortrx_when_tx.value[0:0];
        sw_wlan_rx_abort_rd : coverpoint sw_wlan_rx_abort.value[0:0];
        sw_wlan_tx_abort_rd : coverpoint sw_wlan_tx_abort.value[0:0];
        sw_bt_rx_abort_rd : coverpoint sw_bt_rx_abort.value[0:0];
        sw_bt_tx_abort_rd : coverpoint sw_bt_tx_abort.value[0:0];
        chan_margin_rd : coverpoint chan_margin.value[5:0];
        wlan_pti_mode_rd : coverpoint wlan_pti_mode.value[0:0];
        bt_event_mask_rd : coverpoint bt_event_mask.value[0:0];
        chan_enable_rd : coverpoint chan_enable.value[0:0];
        pti_enable_rd : coverpoint pti_enable.value[0:0];
        no_sim_rx_rd : coverpoint no_sim_rx.value[0:0];
        no_sim_tx_rd : coverpoint no_sim_tx.value[0:0];
        basic_priority_rd : coverpoint basic_priority.value[0:0];
        pta_enable_rd : coverpoint pta_enable.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "CONFIG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_BT_TX
//--------------------------------------------------------------------
class STAT_BT_TX extends uvm_reg;
    `uvm_object_utils(STAT_BT_TX)
    rand uvm_reg_field stat_bt_tx;

    //---build------------------------------------------------------------
    virtual function void build();
        stat_bt_tx = uvm_reg_field::type_id::create("stat_bt_tx");

        stat_bt_tx.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PTA_STAT_BT_TX_wr_cg";
        stat_bt_tx_wr : coverpoint stat_bt_tx.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PTA_STAT_BT_TX_rd_cg";
        stat_bt_tx_rd : coverpoint stat_bt_tx.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_BT_TX");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_BT_TX_ABORT
//--------------------------------------------------------------------
class STAT_BT_TX_ABORT extends uvm_reg;
    `uvm_object_utils(STAT_BT_TX_ABORT)
    rand uvm_reg_field stat_bt_tx_abort;

    //---build------------------------------------------------------------
    virtual function void build();
        stat_bt_tx_abort = uvm_reg_field::type_id::create("stat_bt_tx_abort");

        stat_bt_tx_abort.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PTA_STAT_BT_TX_ABORT_wr_cg";
        stat_bt_tx_abort_wr : coverpoint stat_bt_tx_abort.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PTA_STAT_BT_TX_ABORT_rd_cg";
        stat_bt_tx_abort_rd : coverpoint stat_bt_tx_abort.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_BT_TX_ABORT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_BT_RX
//--------------------------------------------------------------------
class STAT_BT_RX extends uvm_reg;
    `uvm_object_utils(STAT_BT_RX)
    rand uvm_reg_field stat_bt_rx;

    //---build------------------------------------------------------------
    virtual function void build();
        stat_bt_rx = uvm_reg_field::type_id::create("stat_bt_rx");

        stat_bt_rx.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PTA_STAT_BT_RX_wr_cg";
        stat_bt_rx_wr : coverpoint stat_bt_rx.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PTA_STAT_BT_RX_rd_cg";
        stat_bt_rx_rd : coverpoint stat_bt_rx.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_BT_RX");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_BT_RX_ABORT
//--------------------------------------------------------------------
class STAT_BT_RX_ABORT extends uvm_reg;
    `uvm_object_utils(STAT_BT_RX_ABORT)
    rand uvm_reg_field stat_bt_rx_abort;

    //---build------------------------------------------------------------
    virtual function void build();
        stat_bt_rx_abort = uvm_reg_field::type_id::create("stat_bt_rx_abort");

        stat_bt_rx_abort.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PTA_STAT_BT_RX_ABORT_wr_cg";
        stat_bt_rx_abort_wr : coverpoint stat_bt_rx_abort.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PTA_STAT_BT_RX_ABORT_rd_cg";
        stat_bt_rx_abort_rd : coverpoint stat_bt_rx_abort.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_BT_RX_ABORT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_WLAN_TX
//--------------------------------------------------------------------
class STAT_WLAN_TX extends uvm_reg;
    `uvm_object_utils(STAT_WLAN_TX)
    rand uvm_reg_field stat_wlan_tx;

    //---build------------------------------------------------------------
    virtual function void build();
        stat_wlan_tx = uvm_reg_field::type_id::create("stat_wlan_tx");

        stat_wlan_tx.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PTA_STAT_WLAN_TX_wr_cg";
        stat_wlan_tx_wr : coverpoint stat_wlan_tx.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PTA_STAT_WLAN_TX_rd_cg";
        stat_wlan_tx_rd : coverpoint stat_wlan_tx.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_WLAN_TX");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_WLAN_TX_ABORT
//--------------------------------------------------------------------
class STAT_WLAN_TX_ABORT extends uvm_reg;
    `uvm_object_utils(STAT_WLAN_TX_ABORT)
    rand uvm_reg_field stat_wlan_tx_abort;

    //---build------------------------------------------------------------
    virtual function void build();
        stat_wlan_tx_abort = uvm_reg_field::type_id::create("stat_wlan_tx_abort");

        stat_wlan_tx_abort.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PTA_STAT_WLAN_TX_ABORT_wr_cg";
        stat_wlan_tx_abort_wr : coverpoint stat_wlan_tx_abort.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PTA_STAT_WLAN_TX_ABORT_rd_cg";
        stat_wlan_tx_abort_rd : coverpoint stat_wlan_tx_abort.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_WLAN_TX_ABORT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_WLAN_RX
//--------------------------------------------------------------------
class STAT_WLAN_RX extends uvm_reg;
    `uvm_object_utils(STAT_WLAN_RX)
    rand uvm_reg_field stat_wlan_rx;

    //---build------------------------------------------------------------
    virtual function void build();
        stat_wlan_rx = uvm_reg_field::type_id::create("stat_wlan_rx");

        stat_wlan_rx.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PTA_STAT_WLAN_RX_wr_cg";
        stat_wlan_rx_wr : coverpoint stat_wlan_rx.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PTA_STAT_WLAN_RX_rd_cg";
        stat_wlan_rx_rd : coverpoint stat_wlan_rx.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_WLAN_RX");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STAT_WLAN_RX_ABORT
//--------------------------------------------------------------------
class STAT_WLAN_RX_ABORT extends uvm_reg;
    `uvm_object_utils(STAT_WLAN_RX_ABORT)
    rand uvm_reg_field stat_wlan_rx_abort;

    //---build------------------------------------------------------------
    virtual function void build();
        stat_wlan_rx_abort = uvm_reg_field::type_id::create("stat_wlan_rx_abort");

        stat_wlan_rx_abort.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="PTA_STAT_WLAN_RX_ABORT_wr_cg";
        stat_wlan_rx_abort_wr : coverpoint stat_wlan_rx_abort.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="PTA_STAT_WLAN_RX_ABORT_rd_cg";
        stat_wlan_rx_abort_rd : coverpoint stat_wlan_rx_abort.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STAT_WLAN_RX_ABORT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class PTA_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(PTA_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins REVISION              = {'h0};
        bins CONFIG              = {'h4};
        bins STAT_BT_TX              = {'h8};
        bins STAT_BT_TX_ABORT              = {'hC};
        bins STAT_BT_RX              = {'h10};
        bins STAT_BT_RX_ABORT              = {'h14};
        bins STAT_WLAN_TX              = {'h18};
        bins STAT_WLAN_TX_ABORT              = {'h1C};
        bins STAT_WLAN_RX              = {'h20};
        bins STAT_WLAN_RX_ABORT              = {'h24};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "PTA_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: PTA_reg_access_wrapper

//-------------------------------------------------------------------
// PTA_register_block
//--------------------------------------------------------------------
class PTA_register_block extends uvm_reg_block;
    `uvm_object_utils(PTA_register_block)

    rand REVISION REVISION_reg;
    rand CONFIG CONFIG_reg;
    rand STAT_BT_TX STAT_BT_TX_reg;
    rand STAT_BT_TX_ABORT STAT_BT_TX_ABORT_reg;
    rand STAT_BT_RX STAT_BT_RX_reg;
    rand STAT_BT_RX_ABORT STAT_BT_RX_ABORT_reg;
    rand STAT_WLAN_TX STAT_WLAN_TX_reg;
    rand STAT_WLAN_TX_ABORT STAT_WLAN_TX_ABORT_reg;
    rand STAT_WLAN_RX STAT_WLAN_RX_reg;
    rand STAT_WLAN_RX_ABORT STAT_WLAN_RX_ABORT_reg;

    uvm_reg_map PTA_register_map; // Block map
    PTA_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "PTA_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = PTA_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        REVISION_reg = REVISION::type_id::create("REVISION");
        REVISION_reg.configure(this);
        REVISION_reg.build();

        CONFIG_reg = CONFIG::type_id::create("CONFIG");
        CONFIG_reg.configure(this);
        CONFIG_reg.build();

        STAT_BT_TX_reg = STAT_BT_TX::type_id::create("STAT_BT_TX");
        STAT_BT_TX_reg.configure(this);
        STAT_BT_TX_reg.build();

        STAT_BT_TX_ABORT_reg = STAT_BT_TX_ABORT::type_id::create("STAT_BT_TX_ABORT");
        STAT_BT_TX_ABORT_reg.configure(this);
        STAT_BT_TX_ABORT_reg.build();

        STAT_BT_RX_reg = STAT_BT_RX::type_id::create("STAT_BT_RX");
        STAT_BT_RX_reg.configure(this);
        STAT_BT_RX_reg.build();

        STAT_BT_RX_ABORT_reg = STAT_BT_RX_ABORT::type_id::create("STAT_BT_RX_ABORT");
        STAT_BT_RX_ABORT_reg.configure(this);
        STAT_BT_RX_ABORT_reg.build();

        STAT_WLAN_TX_reg = STAT_WLAN_TX::type_id::create("STAT_WLAN_TX");
        STAT_WLAN_TX_reg.configure(this);
        STAT_WLAN_TX_reg.build();

        STAT_WLAN_TX_ABORT_reg = STAT_WLAN_TX_ABORT::type_id::create("STAT_WLAN_TX_ABORT");
        STAT_WLAN_TX_ABORT_reg.configure(this);
        STAT_WLAN_TX_ABORT_reg.build();

        STAT_WLAN_RX_reg = STAT_WLAN_RX::type_id::create("STAT_WLAN_RX");
        STAT_WLAN_RX_reg.configure(this);
        STAT_WLAN_RX_reg.build();

        STAT_WLAN_RX_ABORT_reg = STAT_WLAN_RX_ABORT::type_id::create("STAT_WLAN_RX_ABORT");
        STAT_WLAN_RX_ABORT_reg.configure(this);
        STAT_WLAN_RX_ABORT_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        PTA_register_map = create_map("PTA_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        PTA_register_map.add_reg(REVISION_reg, 'h0, "RO");
        PTA_register_map.add_reg(CONFIG_reg, 'h4, "RW");
        PTA_register_map.add_reg(STAT_BT_TX_reg, 'h8, "RW");
        PTA_register_map.add_reg(STAT_BT_TX_ABORT_reg, 'hC, "RW");
        PTA_register_map.add_reg(STAT_BT_RX_reg, 'h10, "RW");
        PTA_register_map.add_reg(STAT_BT_RX_ABORT_reg, 'h14, "RW");
        PTA_register_map.add_reg(STAT_WLAN_TX_reg, 'h18, "RW");
        PTA_register_map.add_reg(STAT_WLAN_TX_ABORT_reg, 'h1C, "RW");
        PTA_register_map.add_reg(STAT_WLAN_RX_reg, 'h20, "RW");
        PTA_register_map.add_reg(STAT_WLAN_RX_ABORT_reg, 'h24, "RW");

        // Lock the register model and build the map
        lock_model();
        PTA_register_map.set_check_on_read();
    endfunction

endclass
`endif // __PTA_REG_BLOCK_SV__
