//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for RCKARST
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __RCKARST_REG_BLOCK_SV__
`define __RCKARST_REG_BLOCK_SV__

//--------------------------------------------------------------------
// STATIC_CFG
//--------------------------------------------------------------------
class STATIC_CFG extends uvm_reg;
    `uvm_object_utils(STATIC_CFG)
    rand uvm_reg_field HW_PRESCALER;
    rand uvm_reg_field AUTO_TX_GAIN_EN;
    rand uvm_reg_field RF_FORCE_TXON;
    rand uvm_reg_field RF_TESTMODE;
    rand uvm_reg_field RF_SEL_2G4;
    rand uvm_reg_field SAMEANTCTRL;
    rand uvm_reg_field RF_RESET_N;

    //---build------------------------------------------------------------
    virtual function void build();
        HW_PRESCALER = uvm_reg_field::type_id::create("HW_PRESCALER");
        AUTO_TX_GAIN_EN = uvm_reg_field::type_id::create("AUTO_TX_GAIN_EN");
        RF_FORCE_TXON = uvm_reg_field::type_id::create("RF_FORCE_TXON");
        RF_TESTMODE = uvm_reg_field::type_id::create("RF_TESTMODE");
        RF_SEL_2G4 = uvm_reg_field::type_id::create("RF_SEL_2G4");
        SAMEANTCTRL = uvm_reg_field::type_id::create("SAMEANTCTRL");
        RF_RESET_N = uvm_reg_field::type_id::create("RF_RESET_N");

        HW_PRESCALER.configure(this, 4, 28, "RW", 1, 'b000, 1, 1, 1);
        AUTO_TX_GAIN_EN.configure(this, 1, 24, "RW", 1, 'b0, 1, 1, 1);
        RF_FORCE_TXON.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        RF_TESTMODE.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        RF_SEL_2G4.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        SAMEANTCTRL.configure(this, 1, 4, "RW", 1, 'b1, 1, 1, 1);
        RF_RESET_N.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_STATIC_CFG_wr_cg";
        HW_PRESCALER_wr : coverpoint HW_PRESCALER.value[3:0];
        AUTO_TX_GAIN_EN_wr : coverpoint AUTO_TX_GAIN_EN.value[0:0];
        RF_FORCE_TXON_wr : coverpoint RF_FORCE_TXON.value[0:0];
        RF_TESTMODE_wr : coverpoint RF_TESTMODE.value[0:0];
        RF_SEL_2G4_wr : coverpoint RF_SEL_2G4.value[0:0];
        SAMEANTCTRL_wr : coverpoint SAMEANTCTRL.value[0:0];
        RF_RESET_N_wr : coverpoint RF_RESET_N.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_STATIC_CFG_rd_cg";
        HW_PRESCALER_rd : coverpoint HW_PRESCALER.value[3:0];
        AUTO_TX_GAIN_EN_rd : coverpoint AUTO_TX_GAIN_EN.value[0:0];
        RF_FORCE_TXON_rd : coverpoint RF_FORCE_TXON.value[0:0];
        RF_TESTMODE_rd : coverpoint RF_TESTMODE.value[0:0];
        RF_SEL_2G4_rd : coverpoint RF_SEL_2G4.value[0:0];
        SAMEANTCTRL_rd : coverpoint SAMEANTCTRL.value[0:0];
        RF_RESET_N_rd : coverpoint RF_RESET_N.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STATIC_CFG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SW_CTRL
//--------------------------------------------------------------------
class SW_CTRL extends uvm_reg;
    `uvm_object_utils(SW_CTRL)
    rand uvm_reg_field SW_PRESCALER;
    rand uvm_reg_field START_DONE;
    rand uvm_reg_field READNOTWRITE;
    rand uvm_reg_field ADDRESS;
    rand uvm_reg_field DATA;

    //---build------------------------------------------------------------
    virtual function void build();
        SW_PRESCALER = uvm_reg_field::type_id::create("SW_PRESCALER");
        START_DONE = uvm_reg_field::type_id::create("START_DONE");
        READNOTWRITE = uvm_reg_field::type_id::create("READNOTWRITE");
        ADDRESS = uvm_reg_field::type_id::create("ADDRESS");
        DATA = uvm_reg_field::type_id::create("DATA");

        SW_PRESCALER.configure(this, 4, 28, "RW", 1, 'b000, 1, 1, 1);
        START_DONE.configure(this, 1, 27, "RW", 1, 'b0, 1, 1, 1);
        READNOTWRITE.configure(this, 1, 26, "RW", 1, 'b0, 1, 1, 1);
        ADDRESS.configure(this, 10, 16, "RW", 1, 'b000000000, 1, 1, 1);
        DATA.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_SW_CTRL_wr_cg";
        SW_PRESCALER_wr : coverpoint SW_PRESCALER.value[3:0];
        START_DONE_wr : coverpoint START_DONE.value[0:0];
        READNOTWRITE_wr : coverpoint READNOTWRITE.value[0:0];
        ADDRESS_wr : coverpoint ADDRESS.value[9:0];
        DATA_wr : coverpoint DATA.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_SW_CTRL_rd_cg";
        SW_PRESCALER_rd : coverpoint SW_PRESCALER.value[3:0];
        START_DONE_rd : coverpoint START_DONE.value[0:0];
        READNOTWRITE_rd : coverpoint READNOTWRITE.value[0:0];
        ADDRESS_rd : coverpoint ADDRESS.value[9:0];
        DATA_rd : coverpoint DATA.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SW_CTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HW_TRX0_MODE
//--------------------------------------------------------------------
class HW_TRX0_MODE extends uvm_reg;
    `uvm_object_utils(HW_TRX0_MODE)
    rand uvm_reg_field TX0PAMODE;
    rand uvm_reg_field TX0MODE;
    rand uvm_reg_field TX0LOMODE;
    rand uvm_reg_field RX0MODE;
    rand uvm_reg_field RX0LOMODE;

    //---build------------------------------------------------------------
    virtual function void build();
        TX0PAMODE = uvm_reg_field::type_id::create("TX0PAMODE");
        TX0MODE = uvm_reg_field::type_id::create("TX0MODE");
        TX0LOMODE = uvm_reg_field::type_id::create("TX0LOMODE");
        RX0MODE = uvm_reg_field::type_id::create("RX0MODE");
        RX0LOMODE = uvm_reg_field::type_id::create("RX0LOMODE");

        TX0PAMODE.configure(this, 4, 16, "RW", 1, 'b100, 1, 1, 1);
        TX0MODE.configure(this, 4, 12, "RW", 1, 'b011, 1, 1, 1);
        TX0LOMODE.configure(this, 4, 8, "RW", 1, 'b001, 1, 1, 1);
        RX0MODE.configure(this, 4, 4, "RW", 1, 'b010, 1, 1, 1);
        RX0LOMODE.configure(this, 4, 0, "RW", 1, 'b001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_TRX0_MODE_wr_cg";
        TX0PAMODE_wr : coverpoint TX0PAMODE.value[3:0];
        TX0MODE_wr : coverpoint TX0MODE.value[3:0];
        TX0LOMODE_wr : coverpoint TX0LOMODE.value[3:0];
        RX0MODE_wr : coverpoint RX0MODE.value[3:0];
        RX0LOMODE_wr : coverpoint RX0LOMODE.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_TRX0_MODE_rd_cg";
        TX0PAMODE_rd : coverpoint TX0PAMODE.value[3:0];
        TX0MODE_rd : coverpoint TX0MODE.value[3:0];
        TX0LOMODE_rd : coverpoint TX0LOMODE.value[3:0];
        RX0MODE_rd : coverpoint RX0MODE.value[3:0];
        RX0LOMODE_rd : coverpoint RX0LOMODE.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HW_TRX0_MODE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HW_TRX1_MODE
//--------------------------------------------------------------------
class HW_TRX1_MODE extends uvm_reg;
    `uvm_object_utils(HW_TRX1_MODE)
    rand uvm_reg_field TX1PAMODE;
    rand uvm_reg_field TX1MODE;
    rand uvm_reg_field TX1LOMODE;
    rand uvm_reg_field RX1MODE;
    rand uvm_reg_field RX1LOMODE;

    //---build------------------------------------------------------------
    virtual function void build();
        TX1PAMODE = uvm_reg_field::type_id::create("TX1PAMODE");
        TX1MODE = uvm_reg_field::type_id::create("TX1MODE");
        TX1LOMODE = uvm_reg_field::type_id::create("TX1LOMODE");
        RX1MODE = uvm_reg_field::type_id::create("RX1MODE");
        RX1LOMODE = uvm_reg_field::type_id::create("RX1LOMODE");

        TX1PAMODE.configure(this, 4, 16, "RW", 1, 'b100, 1, 1, 1);
        TX1MODE.configure(this, 4, 12, "RW", 1, 'b011, 1, 1, 1);
        TX1LOMODE.configure(this, 4, 8, "RW", 1, 'b001, 1, 1, 1);
        RX1MODE.configure(this, 4, 4, "RW", 1, 'b010, 1, 1, 1);
        RX1LOMODE.configure(this, 4, 0, "RW", 1, 'b001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_TRX1_MODE_wr_cg";
        TX1PAMODE_wr : coverpoint TX1PAMODE.value[3:0];
        TX1MODE_wr : coverpoint TX1MODE.value[3:0];
        TX1LOMODE_wr : coverpoint TX1LOMODE.value[3:0];
        RX1MODE_wr : coverpoint RX1MODE.value[3:0];
        RX1LOMODE_wr : coverpoint RX1LOMODE.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_TRX1_MODE_rd_cg";
        TX1PAMODE_rd : coverpoint TX1PAMODE.value[3:0];
        TX1MODE_rd : coverpoint TX1MODE.value[3:0];
        TX1LOMODE_rd : coverpoint TX1LOMODE.value[3:0];
        RX1MODE_rd : coverpoint RX1MODE.value[3:0];
        RX1LOMODE_rd : coverpoint RX1LOMODE.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HW_TRX1_MODE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HW_TX_GAIN_SPI_ADDR
//--------------------------------------------------------------------
class HW_TX_GAIN_SPI_ADDR extends uvm_reg;
    `uvm_object_utils(HW_TX_GAIN_SPI_ADDR)
    rand uvm_reg_field TX1GAINOFFSET;
    rand uvm_reg_field TX0GAINOFFSET;
    rand uvm_reg_field TX1GAINADDR;
    rand uvm_reg_field TX0GAINADDR;

    //---build------------------------------------------------------------
    virtual function void build();
        TX1GAINOFFSET = uvm_reg_field::type_id::create("TX1GAINOFFSET");
        TX0GAINOFFSET = uvm_reg_field::type_id::create("TX0GAINOFFSET");
        TX1GAINADDR = uvm_reg_field::type_id::create("TX1GAINADDR");
        TX0GAINADDR = uvm_reg_field::type_id::create("TX0GAINADDR");

        TX1GAINOFFSET.configure(this, 4, 28, "RW", 1, 'b000, 1, 1, 1);
        TX0GAINOFFSET.configure(this, 4, 24, "RW", 1, 'b000, 1, 1, 1);
        TX1GAINADDR.configure(this, 10, 12, "RW", 1, 'b1001100011, 1, 1, 1);
        TX0GAINADDR.configure(this, 10, 0, "RW", 1, 'b001100011, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_TX_GAIN_SPI_ADDR_wr_cg";
        TX1GAINOFFSET_wr : coverpoint TX1GAINOFFSET.value[3:0];
        TX0GAINOFFSET_wr : coverpoint TX0GAINOFFSET.value[3:0];
        TX1GAINADDR_wr : coverpoint TX1GAINADDR.value[9:0];
        TX0GAINADDR_wr : coverpoint TX0GAINADDR.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_TX_GAIN_SPI_ADDR_rd_cg";
        TX1GAINOFFSET_rd : coverpoint TX1GAINOFFSET.value[3:0];
        TX0GAINOFFSET_rd : coverpoint TX0GAINOFFSET.value[3:0];
        TX1GAINADDR_rd : coverpoint TX1GAINADDR.value[9:0];
        TX0GAINADDR_rd : coverpoint TX0GAINADDR.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HW_TX_GAIN_SPI_ADDR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HW_RX_GAIN_SPI_ADDR
//--------------------------------------------------------------------
class HW_RX_GAIN_SPI_ADDR extends uvm_reg;
    `uvm_object_utils(HW_RX_GAIN_SPI_ADDR)
    rand uvm_reg_field RX1GAINADDR;
    rand uvm_reg_field RX0GAINADDR;

    //---build------------------------------------------------------------
    virtual function void build();
        RX1GAINADDR = uvm_reg_field::type_id::create("RX1GAINADDR");
        RX0GAINADDR = uvm_reg_field::type_id::create("RX0GAINADDR");

        RX1GAINADDR.configure(this, 10, 12, "RW", 1, 'b1001100000, 1, 1, 1);
        RX0GAINADDR.configure(this, 10, 0, "RW", 1, 'b001100000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_RX_GAIN_SPI_ADDR_wr_cg";
        RX1GAINADDR_wr : coverpoint RX1GAINADDR.value[9:0];
        RX0GAINADDR_wr : coverpoint RX0GAINADDR.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_RX_GAIN_SPI_ADDR_rd_cg";
        RX1GAINADDR_rd : coverpoint RX1GAINADDR.value[9:0];
        RX0GAINADDR_rd : coverpoint RX0GAINADDR.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HW_RX_GAIN_SPI_ADDR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HW_RX_DELAY
//--------------------------------------------------------------------
class HW_RX_DELAY extends uvm_reg;
    `uvm_object_utils(HW_RX_DELAY)
    rand uvm_reg_field RXON_2_LO_DELAY;
    rand uvm_reg_field LO_2_RXON_DELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        RXON_2_LO_DELAY = uvm_reg_field::type_id::create("RXON_2_LO_DELAY");
        LO_2_RXON_DELAY = uvm_reg_field::type_id::create("LO_2_RXON_DELAY");

        RXON_2_LO_DELAY.configure(this, 10, 16, "RW", 1, 'b000000101, 1, 1, 1);
        LO_2_RXON_DELAY.configure(this, 10, 0, "RW", 1, 'b001010000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_RX_DELAY_wr_cg";
        RXON_2_LO_DELAY_wr : coverpoint RXON_2_LO_DELAY.value[9:0];
        LO_2_RXON_DELAY_wr : coverpoint LO_2_RXON_DELAY.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_RX_DELAY_rd_cg";
        RXON_2_LO_DELAY_rd : coverpoint RXON_2_LO_DELAY.value[9:0];
        LO_2_RXON_DELAY_rd : coverpoint LO_2_RXON_DELAY.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HW_RX_DELAY");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HW_TX_DELAY
//--------------------------------------------------------------------
class HW_TX_DELAY extends uvm_reg;
    `uvm_object_utils(HW_TX_DELAY)
    rand uvm_reg_field TXON_2_LO_DELAY;
    rand uvm_reg_field LO_2_TXON_DELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        TXON_2_LO_DELAY = uvm_reg_field::type_id::create("TXON_2_LO_DELAY");
        LO_2_TXON_DELAY = uvm_reg_field::type_id::create("LO_2_TXON_DELAY");

        TXON_2_LO_DELAY.configure(this, 10, 16, "RW", 1, 'b000000101, 1, 1, 1);
        LO_2_TXON_DELAY.configure(this, 10, 0, "RW", 1, 'b001010000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_TX_DELAY_wr_cg";
        TXON_2_LO_DELAY_wr : coverpoint TXON_2_LO_DELAY.value[9:0];
        LO_2_TXON_DELAY_wr : coverpoint LO_2_TXON_DELAY.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_TX_DELAY_rd_cg";
        TXON_2_LO_DELAY_rd : coverpoint TXON_2_LO_DELAY.value[9:0];
        LO_2_TXON_DELAY_rd : coverpoint LO_2_TXON_DELAY.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HW_TX_DELAY");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HW_PA_DELAY
//--------------------------------------------------------------------
class HW_PA_DELAY extends uvm_reg;
    `uvm_object_utils(HW_PA_DELAY)
    rand uvm_reg_field PAOFF_DELAY;
    rand uvm_reg_field PAON_DELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        PAOFF_DELAY = uvm_reg_field::type_id::create("PAOFF_DELAY");
        PAON_DELAY = uvm_reg_field::type_id::create("PAON_DELAY");

        PAOFF_DELAY.configure(this, 10, 16, "RW", 1, 'b000000101, 1, 1, 1);
        PAON_DELAY.configure(this, 10, 0, "RW", 1, 'b001010000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_PA_DELAY_wr_cg";
        PAOFF_DELAY_wr : coverpoint PAOFF_DELAY.value[9:0];
        PAON_DELAY_wr : coverpoint PAON_DELAY.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_PA_DELAY_rd_cg";
        PAOFF_DELAY_rd : coverpoint PAOFF_DELAY.value[9:0];
        PAON_DELAY_rd : coverpoint PAON_DELAY.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HW_PA_DELAY");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HW_RX2TX_DELAY
//--------------------------------------------------------------------
class HW_RX2TX_DELAY extends uvm_reg;
    `uvm_object_utils(HW_RX2TX_DELAY)
    rand uvm_reg_field RX2TXON_DELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        RX2TXON_DELAY = uvm_reg_field::type_id::create("RX2TXON_DELAY");

        RX2TXON_DELAY.configure(this, 10, 0, "RW", 1, 'b000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_RX2TX_DELAY_wr_cg";
        RX2TXON_DELAY_wr : coverpoint RX2TXON_DELAY.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_RX2TX_DELAY_rd_cg";
        RX2TXON_DELAY_rd : coverpoint RX2TXON_DELAY.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HW_RX2TX_DELAY");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EXTPA_SEQ_ON_DELAY
//--------------------------------------------------------------------
class EXTPA_SEQ_ON_DELAY extends uvm_reg;
    `uvm_object_utils(EXTPA_SEQ_ON_DELAY)
    rand uvm_reg_field EXTPA1_SEQ_ON_DELAY;
    rand uvm_reg_field EXTPA0_SEQ_ON_DELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        EXTPA1_SEQ_ON_DELAY = uvm_reg_field::type_id::create("EXTPA1_SEQ_ON_DELAY");
        EXTPA0_SEQ_ON_DELAY = uvm_reg_field::type_id::create("EXTPA0_SEQ_ON_DELAY");

        EXTPA1_SEQ_ON_DELAY.configure(this, 8, 8, "RW", 1, 'b0000000, 1, 1, 1);
        EXTPA0_SEQ_ON_DELAY.configure(this, 8, 0, "RW", 1, 'b1010000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_EXTPA_SEQ_ON_DELAY_wr_cg";
        EXTPA1_SEQ_ON_DELAY_wr : coverpoint EXTPA1_SEQ_ON_DELAY.value[7:0];
        EXTPA0_SEQ_ON_DELAY_wr : coverpoint EXTPA0_SEQ_ON_DELAY.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_EXTPA_SEQ_ON_DELAY_rd_cg";
        EXTPA1_SEQ_ON_DELAY_rd : coverpoint EXTPA1_SEQ_ON_DELAY.value[7:0];
        EXTPA0_SEQ_ON_DELAY_rd : coverpoint EXTPA0_SEQ_ON_DELAY.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EXTPA_SEQ_ON_DELAY");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// EXTPA_SEQ_OFF_DELAY
//--------------------------------------------------------------------
class EXTPA_SEQ_OFF_DELAY extends uvm_reg;
    `uvm_object_utils(EXTPA_SEQ_OFF_DELAY)
    rand uvm_reg_field EXTPA1_SEQ_OFF_DELAY;
    rand uvm_reg_field EXTPA0_SEQ_OFF_DELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        EXTPA1_SEQ_OFF_DELAY = uvm_reg_field::type_id::create("EXTPA1_SEQ_OFF_DELAY");
        EXTPA0_SEQ_OFF_DELAY = uvm_reg_field::type_id::create("EXTPA0_SEQ_OFF_DELAY");

        EXTPA1_SEQ_OFF_DELAY.configure(this, 8, 8, "RW", 1, 'b0000000, 1, 1, 1);
        EXTPA0_SEQ_OFF_DELAY.configure(this, 8, 0, "RW", 1, 'b0001000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_EXTPA_SEQ_OFF_DELAY_wr_cg";
        EXTPA1_SEQ_OFF_DELAY_wr : coverpoint EXTPA1_SEQ_OFF_DELAY.value[7:0];
        EXTPA0_SEQ_OFF_DELAY_wr : coverpoint EXTPA0_SEQ_OFF_DELAY.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_EXTPA_SEQ_OFF_DELAY_rd_cg";
        EXTPA1_SEQ_OFF_DELAY_rd : coverpoint EXTPA1_SEQ_OFF_DELAY.value[7:0];
        EXTPA0_SEQ_OFF_DELAY_rd : coverpoint EXTPA0_SEQ_OFF_DELAY.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "EXTPA_SEQ_OFF_DELAY");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TXSWITCH_ONOFF_DELAY
//--------------------------------------------------------------------
class TXSWITCH_ONOFF_DELAY extends uvm_reg;
    `uvm_object_utils(TXSWITCH_ONOFF_DELAY)
    rand uvm_reg_field TXSWITCH_OFF_DELAY;
    rand uvm_reg_field TXSWITCH_ON_DELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        TXSWITCH_OFF_DELAY = uvm_reg_field::type_id::create("TXSWITCH_OFF_DELAY");
        TXSWITCH_ON_DELAY = uvm_reg_field::type_id::create("TXSWITCH_ON_DELAY");

        TXSWITCH_OFF_DELAY.configure(this, 10, 16, "RW", 1, 'b010100000, 1, 1, 1);
        TXSWITCH_ON_DELAY.configure(this, 10, 0, "RW", 1, 'b000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_TXSWITCH_ONOFF_DELAY_wr_cg";
        TXSWITCH_OFF_DELAY_wr : coverpoint TXSWITCH_OFF_DELAY.value[9:0];
        TXSWITCH_ON_DELAY_wr : coverpoint TXSWITCH_ON_DELAY.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_TXSWITCH_ONOFF_DELAY_rd_cg";
        TXSWITCH_OFF_DELAY_rd : coverpoint TXSWITCH_OFF_DELAY.value[9:0];
        TXSWITCH_ON_DELAY_rd : coverpoint TXSWITCH_ON_DELAY.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TXSWITCH_ONOFF_DELAY");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SPI_RD_DELAY
//--------------------------------------------------------------------
class SPI_RD_DELAY extends uvm_reg;
    `uvm_object_utils(SPI_RD_DELAY)
    rand uvm_reg_field SPI_RD_DELAY;

    //---build------------------------------------------------------------
    virtual function void build();
        SPI_RD_DELAY = uvm_reg_field::type_id::create("SPI_RD_DELAY");

        SPI_RD_DELAY.configure(this, 6, 0, "RW", 1, 'b11010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_SPI_RD_DELAY_wr_cg";
        SPI_RD_DELAY_wr : coverpoint SPI_RD_DELAY.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_SPI_RD_DELAY_rd_cg";
        SPI_RD_DELAY_rd : coverpoint SPI_RD_DELAY.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SPI_RD_DELAY");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// STATUS
//--------------------------------------------------------------------
class STATUS extends uvm_reg;
    `uvm_object_utils(STATUS)
    rand uvm_reg_field RC_STATE;

    //---build------------------------------------------------------------
    virtual function void build();
        RC_STATE = uvm_reg_field::type_id::create("RC_STATE");

        RC_STATE.configure(this, 3, 0, "RO", 1, 'b00, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_STATUS_rd_cg";
        RC_STATE_rd : coverpoint RC_STATE.value[2:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "STATUS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// HW_RX_AGCGAINREF
//--------------------------------------------------------------------
class HW_RX_AGCGAINREF extends uvm_reg;
    `uvm_object_utils(HW_RX_AGCGAINREF)
    rand uvm_reg_field RXAGCGAININDMAX;
    rand uvm_reg_field RXAGCGAININDMIN;

    //---build------------------------------------------------------------
    virtual function void build();
        RXAGCGAININDMAX = uvm_reg_field::type_id::create("RXAGCGAININDMAX");
        RXAGCGAININDMIN = uvm_reg_field::type_id::create("RXAGCGAININDMIN");

        RXAGCGAININDMAX.configure(this, 7, 16, "RW", 1, 'b1000010, 1, 1, 1);
        RXAGCGAININDMIN.configure(this, 7, 0, "RW", 1, 'b000011, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_RX_AGCGAINREF_wr_cg";
        RXAGCGAININDMAX_wr : coverpoint RXAGCGAININDMAX.value[6:0];
        RXAGCGAININDMIN_wr : coverpoint RXAGCGAININDMIN.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RCKARST_HW_RX_AGCGAINREF_rd_cg";
        RXAGCGAININDMAX_rd : coverpoint RXAGCGAININDMAX.value[6:0];
        RXAGCGAININDMIN_rd : coverpoint RXAGCGAININDMIN.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "HW_RX_AGCGAINREF");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class RCKARST_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(RCKARST_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins STATIC_CFG              = {'h0};
        bins SW_CTRL              = {'h4};
        bins HW_TRX0_MODE              = {'h8};
        bins HW_TRX1_MODE              = {'hC};
        bins HW_TX_GAIN_SPI_ADDR              = {'h10};
        bins HW_RX_GAIN_SPI_ADDR              = {'h14};
        bins HW_RX_DELAY              = {'h18};
        bins HW_TX_DELAY              = {'h1C};
        bins HW_PA_DELAY              = {'h20};
        bins HW_RX2TX_DELAY              = {'h24};
        bins EXTPA_SEQ_ON_DELAY              = {'h28};
        bins EXTPA_SEQ_OFF_DELAY              = {'h2C};
        bins TXSWITCH_ONOFF_DELAY              = {'h30};
        bins SPI_RD_DELAY              = {'h34};
        bins STATUS              = {'h38};
        bins HW_RX_AGCGAINREF              = {'h3C};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "RCKARST_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: RCKARST_reg_access_wrapper

//-------------------------------------------------------------------
// RCKARST_register_block
//--------------------------------------------------------------------
class RCKARST_register_block extends uvm_reg_block;
    `uvm_object_utils(RCKARST_register_block)

    rand STATIC_CFG STATIC_CFG_reg;
    rand SW_CTRL SW_CTRL_reg;
    rand HW_TRX0_MODE HW_TRX0_MODE_reg;
    rand HW_TRX1_MODE HW_TRX1_MODE_reg;
    rand HW_TX_GAIN_SPI_ADDR HW_TX_GAIN_SPI_ADDR_reg;
    rand HW_RX_GAIN_SPI_ADDR HW_RX_GAIN_SPI_ADDR_reg;
    rand HW_RX_DELAY HW_RX_DELAY_reg;
    rand HW_TX_DELAY HW_TX_DELAY_reg;
    rand HW_PA_DELAY HW_PA_DELAY_reg;
    rand HW_RX2TX_DELAY HW_RX2TX_DELAY_reg;
    rand EXTPA_SEQ_ON_DELAY EXTPA_SEQ_ON_DELAY_reg;
    rand EXTPA_SEQ_OFF_DELAY EXTPA_SEQ_OFF_DELAY_reg;
    rand TXSWITCH_ONOFF_DELAY TXSWITCH_ONOFF_DELAY_reg;
    rand SPI_RD_DELAY SPI_RD_DELAY_reg;
    rand STATUS STATUS_reg;
    rand HW_RX_AGCGAINREF HW_RX_AGCGAINREF_reg;

    uvm_reg_map RCKARST_register_map; // Block map
    RCKARST_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "RCKARST_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = RCKARST_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        STATIC_CFG_reg = STATIC_CFG::type_id::create("STATIC_CFG");
        STATIC_CFG_reg.configure(this);
        STATIC_CFG_reg.build();

        SW_CTRL_reg = SW_CTRL::type_id::create("SW_CTRL");
        SW_CTRL_reg.configure(this);
        SW_CTRL_reg.build();

        HW_TRX0_MODE_reg = HW_TRX0_MODE::type_id::create("HW_TRX0_MODE");
        HW_TRX0_MODE_reg.configure(this);
        HW_TRX0_MODE_reg.build();

        HW_TRX1_MODE_reg = HW_TRX1_MODE::type_id::create("HW_TRX1_MODE");
        HW_TRX1_MODE_reg.configure(this);
        HW_TRX1_MODE_reg.build();

        HW_TX_GAIN_SPI_ADDR_reg = HW_TX_GAIN_SPI_ADDR::type_id::create("HW_TX_GAIN_SPI_ADDR");
        HW_TX_GAIN_SPI_ADDR_reg.configure(this);
        HW_TX_GAIN_SPI_ADDR_reg.build();

        HW_RX_GAIN_SPI_ADDR_reg = HW_RX_GAIN_SPI_ADDR::type_id::create("HW_RX_GAIN_SPI_ADDR");
        HW_RX_GAIN_SPI_ADDR_reg.configure(this);
        HW_RX_GAIN_SPI_ADDR_reg.build();

        HW_RX_DELAY_reg = HW_RX_DELAY::type_id::create("HW_RX_DELAY");
        HW_RX_DELAY_reg.configure(this);
        HW_RX_DELAY_reg.build();

        HW_TX_DELAY_reg = HW_TX_DELAY::type_id::create("HW_TX_DELAY");
        HW_TX_DELAY_reg.configure(this);
        HW_TX_DELAY_reg.build();

        HW_PA_DELAY_reg = HW_PA_DELAY::type_id::create("HW_PA_DELAY");
        HW_PA_DELAY_reg.configure(this);
        HW_PA_DELAY_reg.build();

        HW_RX2TX_DELAY_reg = HW_RX2TX_DELAY::type_id::create("HW_RX2TX_DELAY");
        HW_RX2TX_DELAY_reg.configure(this);
        HW_RX2TX_DELAY_reg.build();

        EXTPA_SEQ_ON_DELAY_reg = EXTPA_SEQ_ON_DELAY::type_id::create("EXTPA_SEQ_ON_DELAY");
        EXTPA_SEQ_ON_DELAY_reg.configure(this);
        EXTPA_SEQ_ON_DELAY_reg.build();

        EXTPA_SEQ_OFF_DELAY_reg = EXTPA_SEQ_OFF_DELAY::type_id::create("EXTPA_SEQ_OFF_DELAY");
        EXTPA_SEQ_OFF_DELAY_reg.configure(this);
        EXTPA_SEQ_OFF_DELAY_reg.build();

        TXSWITCH_ONOFF_DELAY_reg = TXSWITCH_ONOFF_DELAY::type_id::create("TXSWITCH_ONOFF_DELAY");
        TXSWITCH_ONOFF_DELAY_reg.configure(this);
        TXSWITCH_ONOFF_DELAY_reg.build();

        SPI_RD_DELAY_reg = SPI_RD_DELAY::type_id::create("SPI_RD_DELAY");
        SPI_RD_DELAY_reg.configure(this);
        SPI_RD_DELAY_reg.build();

        STATUS_reg = STATUS::type_id::create("STATUS");
        STATUS_reg.configure(this);
        STATUS_reg.build();

        HW_RX_AGCGAINREF_reg = HW_RX_AGCGAINREF::type_id::create("HW_RX_AGCGAINREF");
        HW_RX_AGCGAINREF_reg.configure(this);
        HW_RX_AGCGAINREF_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        RCKARST_register_map = create_map("RCKARST_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        RCKARST_register_map.add_reg(STATIC_CFG_reg, 'h0, "RW");
        RCKARST_register_map.add_reg(SW_CTRL_reg, 'h4, "RW");
        RCKARST_register_map.add_reg(HW_TRX0_MODE_reg, 'h8, "RW");
        RCKARST_register_map.add_reg(HW_TRX1_MODE_reg, 'hC, "RW");
        RCKARST_register_map.add_reg(HW_TX_GAIN_SPI_ADDR_reg, 'h10, "RW");
        RCKARST_register_map.add_reg(HW_RX_GAIN_SPI_ADDR_reg, 'h14, "RW");
        RCKARST_register_map.add_reg(HW_RX_DELAY_reg, 'h18, "RW");
        RCKARST_register_map.add_reg(HW_TX_DELAY_reg, 'h1C, "RW");
        RCKARST_register_map.add_reg(HW_PA_DELAY_reg, 'h20, "RW");
        RCKARST_register_map.add_reg(HW_RX2TX_DELAY_reg, 'h24, "RW");
        RCKARST_register_map.add_reg(EXTPA_SEQ_ON_DELAY_reg, 'h28, "RW");
        RCKARST_register_map.add_reg(EXTPA_SEQ_OFF_DELAY_reg, 'h2C, "RW");
        RCKARST_register_map.add_reg(TXSWITCH_ONOFF_DELAY_reg, 'h30, "RW");
        RCKARST_register_map.add_reg(SPI_RD_DELAY_reg, 'h34, "RW");
        RCKARST_register_map.add_reg(STATUS_reg, 'h38, "RO");
        RCKARST_register_map.add_reg(HW_RX_AGCGAINREF_reg, 'h3C, "RW");

        // Lock the register model and build the map
        lock_model();
        RCKARST_register_map.set_check_on_read();
    endfunction

endclass
`endif // __RCKARST_REG_BLOCK_SV__
