//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : *_reg_block.sv
// Description      : Systemverilog package file for the register model
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __REGMODEL_PKG_SV__
`define __REGMODEL_PKG_SV__

package REGMODEL_pkg;
  import uvm_pkg::*;
  `include "uvm_macros.svh"

  import MACCORE_reg_block_pkg::*;
  import MACPL_reg_block_pkg::*;
  import PHYCONFIG_reg_block_pkg::*;
  import RCKARST_reg_block_pkg::*;
  import RIUKARST_reg_block_pkg::*;
  import PTA_reg_block_pkg::*;
  import SYSCTRL_reg_block_pkg::*;
  import LA_reg_block_pkg::*;
  import IPCEMB_reg_block_pkg::*;
  import IPCAPP_reg_block_pkg::*;
  import INTC_reg_block_pkg::*;
  import DMA_reg_block_pkg::*;
  import HSU_reg_block_pkg::*;
  import MACBYPASS_reg_block_pkg::*;
  import CRM_reg_block_pkg::*;
  import callbacks_pkg::*;

  `include "REGMODEL_reg_block.sv"
  `include "TOP_reg_block.sv"

endpackage : REGMODEL_pkg

`endif // __REGMODEL_PKG_SV__
