//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for REGMODEL
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __REGMODEL_REG_BLOCK_SV__
`define __REGMODEL_REG_BLOCK_SV__


//-------------------------------------------------------------------
// REGMODEL_register_block
//--------------------------------------------------------------------
class REGMODEL_register_block extends uvm_reg_block;
    `uvm_object_utils(REGMODEL_register_block)

    MACCORE_register_block MACCORE;
    MACPL_register_block MACPL;
    PHYCONFIG_register_block PHYCONFIG;
    RCKARST_register_block RCKARST;
    RIUKARST_register_block RIUKARST;
    PTA_register_block PTA;
    SYSCTRL_register_block SYSCTRL;
    LA_register_block LA;
    IPCEMB_register_block IPCEMB;
    IPCAPP_register_block IPCAPP;
    INTC_register_block INTC;
    DMA_register_block DMA;
    HSU_register_block HSU;
    MACBYPASS_register_block MACBYPASS;
    CRM_register_block CRM;

    uvm_reg_map REGMODEL_register_map; // Top level map

    //---new--------------------------------------------------------------
    function new(string name = "REGMODEL_register_block");
        super.new(name, build_coverage(UVM_CVR_FIELD_VALS));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();

        MACCORE = MACCORE_register_block::type_id::create("MACCORE");
        MACCORE.configure(this);
        MACCORE.build();

        MACPL = MACPL_register_block::type_id::create("MACPL");
        MACPL.configure(this);
        MACPL.build();

        PHYCONFIG = PHYCONFIG_register_block::type_id::create("PHYCONFIG");
        PHYCONFIG.configure(this);
        PHYCONFIG.build();

        RCKARST = RCKARST_register_block::type_id::create("RCKARST");
        RCKARST.configure(this);
        RCKARST.build();

        RIUKARST = RIUKARST_register_block::type_id::create("RIUKARST");
        RIUKARST.configure(this);
        RIUKARST.build();

        PTA = PTA_register_block::type_id::create("PTA");
        PTA.configure(this);
        PTA.build();

        SYSCTRL = SYSCTRL_register_block::type_id::create("SYSCTRL");
        SYSCTRL.configure(this);
        SYSCTRL.build();

        LA = LA_register_block::type_id::create("LA");
        LA.configure(this);
        LA.build();

        IPCEMB = IPCEMB_register_block::type_id::create("IPCEMB");
        IPCEMB.configure(this);
        IPCEMB.build();

        IPCAPP = IPCAPP_register_block::type_id::create("IPCAPP");
        IPCAPP.configure(this);
        IPCAPP.build();

        INTC = INTC_register_block::type_id::create("INTC");
        INTC.configure(this);
        INTC.build();

        DMA = DMA_register_block::type_id::create("DMA");
        DMA.configure(this);
        DMA.build();

        HSU = HSU_register_block::type_id::create("HSU");
        HSU.configure(this);
        HSU.build();

        MACBYPASS = MACBYPASS_register_block::type_id::create("MACBYPASS");
        MACBYPASS.configure(this);
        MACBYPASS.build();

        CRM = CRM_register_block::type_id::create("CRM");
        CRM.configure(this);
        CRM.build();

        // Map name, Offset, Number of bytes, Endianess)
        REGMODEL_register_map = create_map("REGMODEL_register_map", `MEMMAP_OFFSET, 4, UVM_LITTLE_ENDIAN);

        REGMODEL_register_map.add_submap(MACCORE.MACCORE_register_map, 32'h00B00000);
        REGMODEL_register_map.add_submap(MACPL.MACPL_register_map, 32'h00B08000);
        REGMODEL_register_map.add_submap(PHYCONFIG.PHYCONFIG_register_map, 32'h00C00000);
        REGMODEL_register_map.add_submap(RCKARST.RCKARST_register_map, 32'h00C0C000);
        REGMODEL_register_map.add_submap(RIUKARST.RIUKARST_register_map, 32'h00C0B000);
        REGMODEL_register_map.add_submap(PTA.PTA_register_map, 32'h00920000);
        REGMODEL_register_map.add_submap(SYSCTRL.SYSCTRL_register_map, 32'h00900000);
        REGMODEL_register_map.add_submap(LA.LA_register_map, 32'h00E00000);
        REGMODEL_register_map.add_submap(IPCEMB.IPCEMB_register_map, 32'h00800100);
        REGMODEL_register_map.add_submap(IPCAPP.IPCAPP_register_map, 32'h00800000);
        REGMODEL_register_map.add_submap(INTC.INTC_register_map, 32'h00910000);
        REGMODEL_register_map.add_submap(DMA.DMA_register_map, 32'h00A00000);
        REGMODEL_register_map.add_submap(HSU.HSU_register_map, 32'h00930000);
        REGMODEL_register_map.add_submap(MACBYPASS.MACBYPASS_register_map, 32'h00C60000);
        REGMODEL_register_map.add_submap(CRM.CRM_register_map, 32'h00940000);

        // Lock the register model and build the map
        lock_model();
        REGMODEL_register_map.set_check_on_read();
    endfunction

endclass
`endif // __REGMODEL_REG_BLOCK_SV__
