//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for RIUKARST
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __RIUKARST_REG_BLOCK_SV__
`define __RIUKARST_REG_BLOCK_SV__

//--------------------------------------------------------------------
// RWNXVERSION
//--------------------------------------------------------------------
class RWNXVERSION extends uvm_reg;
    `uvm_object_utils(RWNXVERSION)
    rand uvm_reg_field RESERVED;
    rand uvm_reg_field AGCRAMMODE;
    rand uvm_reg_field IQCOMP;
    rand uvm_reg_field DSSSCORR;
    rand uvm_reg_field FIQCOMP;
    rand uvm_reg_field AGCSNR;
    rand uvm_reg_field RADAR;
    rand uvm_reg_field DSSSCCK;
    rand uvm_reg_field CHBW;
    rand uvm_reg_field NSS;
    rand uvm_reg_field NTX;
    rand uvm_reg_field NRX;

    //---build------------------------------------------------------------
    virtual function void build();
        RESERVED = uvm_reg_field::type_id::create("RESERVED");
        AGCRAMMODE = uvm_reg_field::type_id::create("AGCRAMMODE");
        IQCOMP = uvm_reg_field::type_id::create("IQCOMP");
        DSSSCORR = uvm_reg_field::type_id::create("DSSSCORR");
        FIQCOMP = uvm_reg_field::type_id::create("FIQCOMP");
        AGCSNR = uvm_reg_field::type_id::create("AGCSNR");
        RADAR = uvm_reg_field::type_id::create("RADAR");
        DSSSCCK = uvm_reg_field::type_id::create("DSSSCCK");
        CHBW = uvm_reg_field::type_id::create("CHBW");
        NSS = uvm_reg_field::type_id::create("NSS");
        NTX = uvm_reg_field::type_id::create("NTX");
        NRX = uvm_reg_field::type_id::create("NRX");

        RESERVED.configure(this, 8, 24, "RO", 1, 'b0000000, 1, 1, 1);
        AGCRAMMODE.configure(this, 2, 22, "RO", 1, 'b10, 1, 1, 1);
        IQCOMP.configure(this, 1, 21, "RO", 1, 'b0, 1, 1, 1);
        DSSSCORR.configure(this, 1, 20, "RO", 1, 'b1, 1, 1, 1);
        FIQCOMP.configure(this, 1, 19, "RO", 1, 'b0, 1, 1, 1);
        AGCSNR.configure(this, 1, 18, "RO", 1, 'b1, 1, 1, 1);
        RADAR.configure(this, 1, 16, "RO", 1, 'b1, 1, 1, 1);
        DSSSCCK.configure(this, 1, 14, "RO", 1, 'b1, 1, 1, 1);
        CHBW.configure(this, 2, 12, "RO", 1, 'b10, 1, 1, 1);
        NSS.configure(this, 4, 8, "RO", 1, 'b010, 1, 1, 1);
        NTX.configure(this, 4, 4, "RO", 1, 'b010, 1, 1, 1);
        NRX.configure(this, 4, 0, "RO", 1, 'b010, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXVERSION_rd_cg";
        RESERVED_rd : coverpoint RESERVED.value[7:0];
        AGCRAMMODE_rd : coverpoint AGCRAMMODE.value[1:0];
        IQCOMP_rd : coverpoint IQCOMP.value[0:0];
        DSSSCORR_rd : coverpoint DSSSCORR.value[0:0];
        FIQCOMP_rd : coverpoint FIQCOMP.value[0:0];
        AGCSNR_rd : coverpoint AGCSNR.value[0:0];
        RADAR_rd : coverpoint RADAR.value[0:0];
        DSSSCCK_rd : coverpoint DSSSCCK.value[0:0];
        CHBW_rd : coverpoint CHBW.value[1:0];
        NSS_rd : coverpoint NSS.value[3:0];
        NTX_rd : coverpoint NTX.value[3:0];
        NRX_rd : coverpoint NRX.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXVERSION");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXSTATICCONFIG
//--------------------------------------------------------------------
class RWNXSTATICCONFIG extends uvm_reg;
    `uvm_object_utils(RWNXSTATICCONFIG)
    rand uvm_reg_field ACTIVEANT;

    //---build------------------------------------------------------------
    virtual function void build();
        ACTIVEANT = uvm_reg_field::type_id::create("ACTIVEANT");

        ACTIVEANT.configure(this, 2, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXSTATICCONFIG_wr_cg";
        ACTIVEANT_wr : coverpoint ACTIVEANT.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXSTATICCONFIG_rd_cg";
        ACTIVEANT_rd : coverpoint ACTIVEANT.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXSTATICCONFIG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXDYNAMICCONFIG
//--------------------------------------------------------------------
class RWNXDYNAMICCONFIG extends uvm_reg;
    `uvm_object_utils(RWNXDYNAMICCONFIG)
    rand uvm_reg_field AGCINBDPOWSTARTCAPTURE;

    //---build------------------------------------------------------------
    virtual function void build();
        AGCINBDPOWSTARTCAPTURE = uvm_reg_field::type_id::create("AGCINBDPOWSTARTCAPTURE");

        AGCINBDPOWSTARTCAPTURE.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXDYNAMICCONFIG_wr_cg";
        AGCINBDPOWSTARTCAPTURE_wr : coverpoint AGCINBDPOWSTARTCAPTURE.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXDYNAMICCONFIG_rd_cg";
        AGCINBDPOWSTARTCAPTURE_rd : coverpoint AGCINBDPOWSTARTCAPTURE.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXDYNAMICCONFIG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXIQCTRL
//--------------------------------------------------------------------
class RWNXIQCTRL extends uvm_reg;
    `uvm_object_utils(RWNXIQCTRL)
    rand uvm_reg_field TXIQSWAPPATH1;
    rand uvm_reg_field TXIQSWAPPATH0;
    rand uvm_reg_field RXIQSWAPPATH1;
    rand uvm_reg_field RXIQSWAPPATH0;
    rand uvm_reg_field TXIQDELPATHQ1;
    rand uvm_reg_field TXIQDELPATHI1;
    rand uvm_reg_field TXIQDELPATHQ0;
    rand uvm_reg_field TXIQDELPATHI0;
    rand uvm_reg_field RXIQDELPATHQ1;
    rand uvm_reg_field RXIQDELPATHI1;
    rand uvm_reg_field RXIQDELPATHQ0;
    rand uvm_reg_field RXIQDELPATHI0;
    rand uvm_reg_field TXC2SDISBCFG;
    rand uvm_reg_field RXC2SDISBCFG;

    //---build------------------------------------------------------------
    virtual function void build();
        TXIQSWAPPATH1 = uvm_reg_field::type_id::create("TXIQSWAPPATH1");
        TXIQSWAPPATH0 = uvm_reg_field::type_id::create("TXIQSWAPPATH0");
        RXIQSWAPPATH1 = uvm_reg_field::type_id::create("RXIQSWAPPATH1");
        RXIQSWAPPATH0 = uvm_reg_field::type_id::create("RXIQSWAPPATH0");
        TXIQDELPATHQ1 = uvm_reg_field::type_id::create("TXIQDELPATHQ1");
        TXIQDELPATHI1 = uvm_reg_field::type_id::create("TXIQDELPATHI1");
        TXIQDELPATHQ0 = uvm_reg_field::type_id::create("TXIQDELPATHQ0");
        TXIQDELPATHI0 = uvm_reg_field::type_id::create("TXIQDELPATHI0");
        RXIQDELPATHQ1 = uvm_reg_field::type_id::create("RXIQDELPATHQ1");
        RXIQDELPATHI1 = uvm_reg_field::type_id::create("RXIQDELPATHI1");
        RXIQDELPATHQ0 = uvm_reg_field::type_id::create("RXIQDELPATHQ0");
        RXIQDELPATHI0 = uvm_reg_field::type_id::create("RXIQDELPATHI0");
        TXC2SDISBCFG = uvm_reg_field::type_id::create("TXC2SDISBCFG");
        RXC2SDISBCFG = uvm_reg_field::type_id::create("RXC2SDISBCFG");

        TXIQSWAPPATH1.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        TXIQSWAPPATH0.configure(this, 1, 27, "RW", 1, 'b0, 1, 1, 1);
        RXIQSWAPPATH1.configure(this, 1, 23, "RW", 1, 'b0, 1, 1, 1);
        RXIQSWAPPATH0.configure(this, 1, 22, "RW", 1, 'b0, 1, 1, 1);
        TXIQDELPATHQ1.configure(this, 1, 15, "RW", 1, 'b0, 1, 1, 1);
        TXIQDELPATHI1.configure(this, 1, 14, "RW", 1, 'b0, 1, 1, 1);
        TXIQDELPATHQ0.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        TXIQDELPATHI0.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        RXIQDELPATHQ1.configure(this, 1, 5, "RW", 1, 'b0, 1, 1, 1);
        RXIQDELPATHI1.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        RXIQDELPATHQ0.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        RXIQDELPATHI0.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        TXC2SDISBCFG.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        RXC2SDISBCFG.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXIQCTRL_wr_cg";
        TXIQSWAPPATH1_wr : coverpoint TXIQSWAPPATH1.value[0:0];
        TXIQSWAPPATH0_wr : coverpoint TXIQSWAPPATH0.value[0:0];
        RXIQSWAPPATH1_wr : coverpoint RXIQSWAPPATH1.value[0:0];
        RXIQSWAPPATH0_wr : coverpoint RXIQSWAPPATH0.value[0:0];
        TXIQDELPATHQ1_wr : coverpoint TXIQDELPATHQ1.value[0:0];
        TXIQDELPATHI1_wr : coverpoint TXIQDELPATHI1.value[0:0];
        TXIQDELPATHQ0_wr : coverpoint TXIQDELPATHQ0.value[0:0];
        TXIQDELPATHI0_wr : coverpoint TXIQDELPATHI0.value[0:0];
        RXIQDELPATHQ1_wr : coverpoint RXIQDELPATHQ1.value[0:0];
        RXIQDELPATHI1_wr : coverpoint RXIQDELPATHI1.value[0:0];
        RXIQDELPATHQ0_wr : coverpoint RXIQDELPATHQ0.value[0:0];
        RXIQDELPATHI0_wr : coverpoint RXIQDELPATHI0.value[0:0];
        TXC2SDISBCFG_wr : coverpoint TXC2SDISBCFG.value[0:0];
        RXC2SDISBCFG_wr : coverpoint RXC2SDISBCFG.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXIQCTRL_rd_cg";
        TXIQSWAPPATH1_rd : coverpoint TXIQSWAPPATH1.value[0:0];
        TXIQSWAPPATH0_rd : coverpoint TXIQSWAPPATH0.value[0:0];
        RXIQSWAPPATH1_rd : coverpoint RXIQSWAPPATH1.value[0:0];
        RXIQSWAPPATH0_rd : coverpoint RXIQSWAPPATH0.value[0:0];
        TXIQDELPATHQ1_rd : coverpoint TXIQDELPATHQ1.value[0:0];
        TXIQDELPATHI1_rd : coverpoint TXIQDELPATHI1.value[0:0];
        TXIQDELPATHQ0_rd : coverpoint TXIQDELPATHQ0.value[0:0];
        TXIQDELPATHI0_rd : coverpoint TXIQDELPATHI0.value[0:0];
        RXIQDELPATHQ1_rd : coverpoint RXIQDELPATHQ1.value[0:0];
        RXIQDELPATHI1_rd : coverpoint RXIQDELPATHI1.value[0:0];
        RXIQDELPATHQ0_rd : coverpoint RXIQDELPATHQ0.value[0:0];
        RXIQDELPATHI0_rd : coverpoint RXIQDELPATHI0.value[0:0];
        TXC2SDISBCFG_rd : coverpoint TXC2SDISBCFG.value[0:0];
        RXC2SDISBCFG_rd : coverpoint RXC2SDISBCFG.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXIQCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXMACSTATICCONFIG
//--------------------------------------------------------------------
class RWNXMACSTATICCONFIG extends uvm_reg;
    `uvm_object_utils(RWNXMACSTATICCONFIG)
    rand uvm_reg_field PSSELECT;

    //---build------------------------------------------------------------
    virtual function void build();
        PSSELECT = uvm_reg_field::type_id::create("PSSELECT");

        PSSELECT.configure(this, 2, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXMACSTATICCONFIG_wr_cg";
        PSSELECT_wr : coverpoint PSSELECT.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXMACSTATICCONFIG_rd_cg";
        PSSELECT_rd : coverpoint PSSELECT.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXMACSTATICCONFIG");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFECTRL0
//--------------------------------------------------------------------
class RWNXFECTRL0 extends uvm_reg;
    `uvm_object_utils(RWNXFECTRL0)
    rand uvm_reg_field TX80DIGGAINLIN0;
    rand uvm_reg_field TX40DIGGAINLIN0;
    rand uvm_reg_field TX20DIGGAINLIN0;

    //---build------------------------------------------------------------
    virtual function void build();
        TX80DIGGAINLIN0 = uvm_reg_field::type_id::create("TX80DIGGAINLIN0");
        TX40DIGGAINLIN0 = uvm_reg_field::type_id::create("TX40DIGGAINLIN0");
        TX20DIGGAINLIN0 = uvm_reg_field::type_id::create("TX20DIGGAINLIN0");

        TX80DIGGAINLIN0.configure(this, 7, 16, "RW", 1, 'b100000, 1, 1, 1);
        TX40DIGGAINLIN0.configure(this, 7, 8, "RW", 1, 'b1000000, 1, 1, 1);
        TX20DIGGAINLIN0.configure(this, 7, 0, "RW", 1, 'b1000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFECTRL0_wr_cg";
        TX80DIGGAINLIN0_wr : coverpoint TX80DIGGAINLIN0.value[6:0];
        TX40DIGGAINLIN0_wr : coverpoint TX40DIGGAINLIN0.value[6:0];
        TX20DIGGAINLIN0_wr : coverpoint TX20DIGGAINLIN0.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFECTRL0_rd_cg";
        TX80DIGGAINLIN0_rd : coverpoint TX80DIGGAINLIN0.value[6:0];
        TX40DIGGAINLIN0_rd : coverpoint TX40DIGGAINLIN0.value[6:0];
        TX20DIGGAINLIN0_rd : coverpoint TX20DIGGAINLIN0.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFECTRL0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFECTRL1
//--------------------------------------------------------------------
class RWNXFECTRL1 extends uvm_reg;
    `uvm_object_utils(RWNXFECTRL1)
    rand uvm_reg_field TX80DIGGAINLIN1;
    rand uvm_reg_field TX40DIGGAINLIN1;
    rand uvm_reg_field TX20DIGGAINLIN1;

    //---build------------------------------------------------------------
    virtual function void build();
        TX80DIGGAINLIN1 = uvm_reg_field::type_id::create("TX80DIGGAINLIN1");
        TX40DIGGAINLIN1 = uvm_reg_field::type_id::create("TX40DIGGAINLIN1");
        TX20DIGGAINLIN1 = uvm_reg_field::type_id::create("TX20DIGGAINLIN1");

        TX80DIGGAINLIN1.configure(this, 7, 16, "RW", 1, 'b100000, 1, 1, 1);
        TX40DIGGAINLIN1.configure(this, 7, 8, "RW", 1, 'b1000000, 1, 1, 1);
        TX20DIGGAINLIN1.configure(this, 7, 0, "RW", 1, 'b1000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFECTRL1_wr_cg";
        TX80DIGGAINLIN1_wr : coverpoint TX80DIGGAINLIN1.value[6:0];
        TX40DIGGAINLIN1_wr : coverpoint TX40DIGGAINLIN1.value[6:0];
        TX20DIGGAINLIN1_wr : coverpoint TX20DIGGAINLIN1.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFECTRL1_rd_cg";
        TX80DIGGAINLIN1_rd : coverpoint TX80DIGGAINLIN1.value[6:0];
        TX40DIGGAINLIN1_rd : coverpoint TX40DIGGAINLIN1.value[6:0];
        TX20DIGGAINLIN1_rd : coverpoint TX20DIGGAINLIN1.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFECTRL1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFETXIQCOMP0
//--------------------------------------------------------------------
class RWNXFETXIQCOMP0 extends uvm_reg;
    `uvm_object_utils(RWNXFETXIQCOMP0)
    rand uvm_reg_field TXIQPHASECOMPEN0;
    rand uvm_reg_field TXIQGAINCOMPEN0;
    rand uvm_reg_field TXIQPHASE0;
    rand uvm_reg_field TXIQGAIN0;

    //---build------------------------------------------------------------
    virtual function void build();
        TXIQPHASECOMPEN0 = uvm_reg_field::type_id::create("TXIQPHASECOMPEN0");
        TXIQGAINCOMPEN0 = uvm_reg_field::type_id::create("TXIQGAINCOMPEN0");
        TXIQPHASE0 = uvm_reg_field::type_id::create("TXIQPHASE0");
        TXIQGAIN0 = uvm_reg_field::type_id::create("TXIQGAIN0");

        TXIQPHASECOMPEN0.configure(this, 1, 29, "RW", 1, 'b0, 1, 1, 1);
        TXIQGAINCOMPEN0.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        TXIQPHASE0.configure(this, 9, 16, "RW", 1, 'b00000000, 1, 1, 1);
        TXIQGAIN0.configure(this, 11, 0, "RW", 1, 'b10000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFETXIQCOMP0_wr_cg";
        TXIQPHASECOMPEN0_wr : coverpoint TXIQPHASECOMPEN0.value[0:0];
        TXIQGAINCOMPEN0_wr : coverpoint TXIQGAINCOMPEN0.value[0:0];
        TXIQPHASE0_wr : coverpoint TXIQPHASE0.value[8:0];
        TXIQGAIN0_wr : coverpoint TXIQGAIN0.value[10:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFETXIQCOMP0_rd_cg";
        TXIQPHASECOMPEN0_rd : coverpoint TXIQPHASECOMPEN0.value[0:0];
        TXIQGAINCOMPEN0_rd : coverpoint TXIQGAINCOMPEN0.value[0:0];
        TXIQPHASE0_rd : coverpoint TXIQPHASE0.value[8:0];
        TXIQGAIN0_rd : coverpoint TXIQGAIN0.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFETXIQCOMP0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFETXIQCOMP1
//--------------------------------------------------------------------
class RWNXFETXIQCOMP1 extends uvm_reg;
    `uvm_object_utils(RWNXFETXIQCOMP1)
    rand uvm_reg_field TXIQPHASECOMPEN1;
    rand uvm_reg_field TXIQGAINCOMPEN1;
    rand uvm_reg_field TXIQPHASE1;
    rand uvm_reg_field TXIQGAIN1;

    //---build------------------------------------------------------------
    virtual function void build();
        TXIQPHASECOMPEN1 = uvm_reg_field::type_id::create("TXIQPHASECOMPEN1");
        TXIQGAINCOMPEN1 = uvm_reg_field::type_id::create("TXIQGAINCOMPEN1");
        TXIQPHASE1 = uvm_reg_field::type_id::create("TXIQPHASE1");
        TXIQGAIN1 = uvm_reg_field::type_id::create("TXIQGAIN1");

        TXIQPHASECOMPEN1.configure(this, 1, 29, "RW", 1, 'b0, 1, 1, 1);
        TXIQGAINCOMPEN1.configure(this, 1, 28, "RW", 1, 'b0, 1, 1, 1);
        TXIQPHASE1.configure(this, 9, 16, "RW", 1, 'b00000000, 1, 1, 1);
        TXIQGAIN1.configure(this, 11, 0, "RW", 1, 'b10000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFETXIQCOMP1_wr_cg";
        TXIQPHASECOMPEN1_wr : coverpoint TXIQPHASECOMPEN1.value[0:0];
        TXIQGAINCOMPEN1_wr : coverpoint TXIQGAINCOMPEN1.value[0:0];
        TXIQPHASE1_wr : coverpoint TXIQPHASE1.value[8:0];
        TXIQGAIN1_wr : coverpoint TXIQGAIN1.value[10:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFETXIQCOMP1_rd_cg";
        TXIQPHASECOMPEN1_rd : coverpoint TXIQPHASECOMPEN1.value[0:0];
        TXIQGAINCOMPEN1_rd : coverpoint TXIQGAINCOMPEN1.value[0:0];
        TXIQPHASE1_rd : coverpoint TXIQPHASE1.value[8:0];
        TXIQGAIN1_rd : coverpoint TXIQGAIN1.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFETXIQCOMP1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQESTCTRL
//--------------------------------------------------------------------
class RWNXFERXIQESTCTRL extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQESTCTRL)
    rand uvm_reg_field IQESTFOMIN;
    rand uvm_reg_field IQESTBWLIST;
    rand uvm_reg_field IQESTMCSMIN;
    rand uvm_reg_field IQESTSNRMIN;
    rand uvm_reg_field RXIQPHASEESTEN;
    rand uvm_reg_field RXIQGAINESTEN;
    rand uvm_reg_field RXIQPHASECOMPEN;
    rand uvm_reg_field RXIQGAINCOMPEN;

    //---build------------------------------------------------------------
    virtual function void build();
        IQESTFOMIN = uvm_reg_field::type_id::create("IQESTFOMIN");
        IQESTBWLIST = uvm_reg_field::type_id::create("IQESTBWLIST");
        IQESTMCSMIN = uvm_reg_field::type_id::create("IQESTMCSMIN");
        IQESTSNRMIN = uvm_reg_field::type_id::create("IQESTSNRMIN");
        RXIQPHASEESTEN = uvm_reg_field::type_id::create("RXIQPHASEESTEN");
        RXIQGAINESTEN = uvm_reg_field::type_id::create("RXIQGAINESTEN");
        RXIQPHASECOMPEN = uvm_reg_field::type_id::create("RXIQPHASECOMPEN");
        RXIQGAINCOMPEN = uvm_reg_field::type_id::create("RXIQGAINCOMPEN");

        IQESTFOMIN.configure(this, 8, 24, "RW", 1, 'b0000000, 1, 1, 1);
        IQESTBWLIST.configure(this, 3, 20, "RW", 1, 'b111, 1, 1, 1);
        IQESTMCSMIN.configure(this, 4, 12, "RW", 1, 'b000, 1, 1, 1);
        IQESTSNRMIN.configure(this, 8, 4, "RW", 1, 'b0000000, 1, 1, 1);
        RXIQPHASEESTEN.configure(this, 1, 3, "RW", 1, 'b0, 1, 1, 1);
        RXIQGAINESTEN.configure(this, 1, 2, "RW", 1, 'b0, 1, 1, 1);
        RXIQPHASECOMPEN.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        RXIQGAINCOMPEN.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQESTCTRL_wr_cg";
        IQESTFOMIN_wr : coverpoint IQESTFOMIN.value[7:0];
        IQESTBWLIST_wr : coverpoint IQESTBWLIST.value[2:0];
        IQESTMCSMIN_wr : coverpoint IQESTMCSMIN.value[3:0];
        IQESTSNRMIN_wr : coverpoint IQESTSNRMIN.value[7:0];
        RXIQPHASEESTEN_wr : coverpoint RXIQPHASEESTEN.value[0:0];
        RXIQGAINESTEN_wr : coverpoint RXIQGAINESTEN.value[0:0];
        RXIQPHASECOMPEN_wr : coverpoint RXIQPHASECOMPEN.value[0:0];
        RXIQGAINCOMPEN_wr : coverpoint RXIQGAINCOMPEN.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQESTCTRL_rd_cg";
        IQESTFOMIN_rd : coverpoint IQESTFOMIN.value[7:0];
        IQESTBWLIST_rd : coverpoint IQESTBWLIST.value[2:0];
        IQESTMCSMIN_rd : coverpoint IQESTMCSMIN.value[3:0];
        IQESTSNRMIN_rd : coverpoint IQESTSNRMIN.value[7:0];
        RXIQPHASEESTEN_rd : coverpoint RXIQPHASEESTEN.value[0:0];
        RXIQGAINESTEN_rd : coverpoint RXIQGAINESTEN.value[0:0];
        RXIQPHASECOMPEN_rd : coverpoint RXIQPHASECOMPEN.value[0:0];
        RXIQGAINCOMPEN_rd : coverpoint RXIQGAINCOMPEN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQESTCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQESTLOOP
//--------------------------------------------------------------------
class RWNXFERXIQESTLOOP extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQESTLOOP)
    rand uvm_reg_field RXIQESTSTEP4;
    rand uvm_reg_field RXIQESTSTEP3;
    rand uvm_reg_field RXIQESTSTEP2;
    rand uvm_reg_field RXIQESTSTEP1;
    rand uvm_reg_field RXIQESTSTEP0;
    rand uvm_reg_field RXIQESTPHASESTEPSTOP;
    rand uvm_reg_field RXIQESTPHASESTEPINIT;
    rand uvm_reg_field RXIQESTGAINSTEPSTOP;
    rand uvm_reg_field RXIQESTGAINSTEPINIT;
    rand uvm_reg_field RXIQESTDEL;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQESTSTEP4 = uvm_reg_field::type_id::create("RXIQESTSTEP4");
        RXIQESTSTEP3 = uvm_reg_field::type_id::create("RXIQESTSTEP3");
        RXIQESTSTEP2 = uvm_reg_field::type_id::create("RXIQESTSTEP2");
        RXIQESTSTEP1 = uvm_reg_field::type_id::create("RXIQESTSTEP1");
        RXIQESTSTEP0 = uvm_reg_field::type_id::create("RXIQESTSTEP0");
        RXIQESTPHASESTEPSTOP = uvm_reg_field::type_id::create("RXIQESTPHASESTEPSTOP");
        RXIQESTPHASESTEPINIT = uvm_reg_field::type_id::create("RXIQESTPHASESTEPINIT");
        RXIQESTGAINSTEPSTOP = uvm_reg_field::type_id::create("RXIQESTGAINSTEPSTOP");
        RXIQESTGAINSTEPINIT = uvm_reg_field::type_id::create("RXIQESTGAINSTEPINIT");
        RXIQESTDEL = uvm_reg_field::type_id::create("RXIQESTDEL");

        RXIQESTSTEP4.configure(this, 3, 28, "RW", 1, 'b10, 1, 1, 1);
        RXIQESTSTEP3.configure(this, 3, 25, "RW", 1, 'b10, 1, 1, 1);
        RXIQESTSTEP2.configure(this, 3, 22, "RW", 1, 'b10, 1, 1, 1);
        RXIQESTSTEP1.configure(this, 3, 19, "RW", 1, 'b10, 1, 1, 1);
        RXIQESTSTEP0.configure(this, 3, 16, "RW", 1, 'b10, 1, 1, 1);
        RXIQESTPHASESTEPSTOP.configure(this, 3, 13, "RW", 1, 'b01, 1, 1, 1);
        RXIQESTPHASESTEPINIT.configure(this, 3, 10, "RW", 1, 'b101, 1, 1, 1);
        RXIQESTGAINSTEPSTOP.configure(this, 3, 7, "RW", 1, 'b01, 1, 1, 1);
        RXIQESTGAINSTEPINIT.configure(this, 3, 4, "RW", 1, 'b110, 1, 1, 1);
        RXIQESTDEL.configure(this, 3, 0, "RW", 1, 'b10, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQESTLOOP_wr_cg";
        RXIQESTSTEP4_wr : coverpoint RXIQESTSTEP4.value[2:0];
        RXIQESTSTEP3_wr : coverpoint RXIQESTSTEP3.value[2:0];
        RXIQESTSTEP2_wr : coverpoint RXIQESTSTEP2.value[2:0];
        RXIQESTSTEP1_wr : coverpoint RXIQESTSTEP1.value[2:0];
        RXIQESTSTEP0_wr : coverpoint RXIQESTSTEP0.value[2:0];
        RXIQESTPHASESTEPSTOP_wr : coverpoint RXIQESTPHASESTEPSTOP.value[2:0];
        RXIQESTPHASESTEPINIT_wr : coverpoint RXIQESTPHASESTEPINIT.value[2:0];
        RXIQESTGAINSTEPSTOP_wr : coverpoint RXIQESTGAINSTEPSTOP.value[2:0];
        RXIQESTGAINSTEPINIT_wr : coverpoint RXIQESTGAINSTEPINIT.value[2:0];
        RXIQESTDEL_wr : coverpoint RXIQESTDEL.value[2:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQESTLOOP_rd_cg";
        RXIQESTSTEP4_rd : coverpoint RXIQESTSTEP4.value[2:0];
        RXIQESTSTEP3_rd : coverpoint RXIQESTSTEP3.value[2:0];
        RXIQESTSTEP2_rd : coverpoint RXIQESTSTEP2.value[2:0];
        RXIQESTSTEP1_rd : coverpoint RXIQESTSTEP1.value[2:0];
        RXIQESTSTEP0_rd : coverpoint RXIQESTSTEP0.value[2:0];
        RXIQESTPHASESTEPSTOP_rd : coverpoint RXIQESTPHASESTEPSTOP.value[2:0];
        RXIQESTPHASESTEPINIT_rd : coverpoint RXIQESTPHASESTEPINIT.value[2:0];
        RXIQESTGAINSTEPSTOP_rd : coverpoint RXIQESTGAINSTEPSTOP.value[2:0];
        RXIQESTGAINSTEPINIT_rd : coverpoint RXIQESTGAINSTEPINIT.value[2:0];
        RXIQESTDEL_rd : coverpoint RXIQESTDEL.value[2:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQESTLOOP");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQESTCLR
//--------------------------------------------------------------------
class RWNXFERXIQESTCLR extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQESTCLR)
    rand uvm_reg_field IQESTITERCLR;

    //---build------------------------------------------------------------
    virtual function void build();
        IQESTITERCLR = uvm_reg_field::type_id::create("IQESTITERCLR");

        IQESTITERCLR.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQESTCLR_wr_cg";
        IQESTITERCLR_wr : coverpoint IQESTITERCLR.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQESTCLR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQCOMP0
//--------------------------------------------------------------------
class RWNXFERXIQCOMP0 extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQCOMP0)
    rand uvm_reg_field RXIQPHASE0;
    rand uvm_reg_field RXIQGAIN0;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQPHASE0 = uvm_reg_field::type_id::create("RXIQPHASE0");
        RXIQGAIN0 = uvm_reg_field::type_id::create("RXIQGAIN0");

        RXIQPHASE0.configure(this, 9, 16, "RW", 1, 'b00000000, 1, 1, 1);
        RXIQGAIN0.configure(this, 11, 0, "RW", 1, 'b10000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQCOMP0_wr_cg";
        RXIQPHASE0_wr : coverpoint RXIQPHASE0.value[8:0];
        RXIQGAIN0_wr : coverpoint RXIQGAIN0.value[10:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQCOMP0_rd_cg";
        RXIQPHASE0_rd : coverpoint RXIQPHASE0.value[8:0];
        RXIQGAIN0_rd : coverpoint RXIQGAIN0.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQCOMP0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQCOMP1
//--------------------------------------------------------------------
class RWNXFERXIQCOMP1 extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQCOMP1)
    rand uvm_reg_field RXIQPHASE1;
    rand uvm_reg_field RXIQGAIN1;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQPHASE1 = uvm_reg_field::type_id::create("RXIQPHASE1");
        RXIQGAIN1 = uvm_reg_field::type_id::create("RXIQGAIN1");

        RXIQPHASE1.configure(this, 9, 16, "RW", 1, 'b00000000, 1, 1, 1);
        RXIQGAIN1.configure(this, 11, 0, "RW", 1, 'b10000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQCOMP1_wr_cg";
        RXIQPHASE1_wr : coverpoint RXIQPHASE1.value[8:0];
        RXIQGAIN1_wr : coverpoint RXIQGAIN1.value[10:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQCOMP1_rd_cg";
        RXIQPHASE1_rd : coverpoint RXIQPHASE1.value[8:0];
        RXIQGAIN1_rd : coverpoint RXIQGAIN1.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQCOMP1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCTRL
//--------------------------------------------------------------------
class RWNXFEFIQCTRL extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCTRL)
    rand uvm_reg_field FIQPATHSEL;
    rand uvm_reg_field FIQTXRX;
    rand uvm_reg_field FIQRXBYPASS;
    rand uvm_reg_field FIQTXBYPASS;
    rand uvm_reg_field FIQCALEN;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQPATHSEL = uvm_reg_field::type_id::create("FIQPATHSEL");
        FIQTXRX = uvm_reg_field::type_id::create("FIQTXRX");
        FIQRXBYPASS = uvm_reg_field::type_id::create("FIQRXBYPASS");
        FIQTXBYPASS = uvm_reg_field::type_id::create("FIQTXBYPASS");
        FIQCALEN = uvm_reg_field::type_id::create("FIQCALEN");

        FIQPATHSEL.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        FIQTXRX.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        FIQRXBYPASS.configure(this, 1, 2, "RW", 1, 'b1, 1, 1, 1);
        FIQTXBYPASS.configure(this, 1, 1, "RW", 1, 'b1, 1, 1, 1);
        FIQCALEN.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCTRL_wr_cg";
        FIQPATHSEL_wr : coverpoint FIQPATHSEL.value[0:0];
        FIQTXRX_wr : coverpoint FIQTXRX.value[0:0];
        FIQRXBYPASS_wr : coverpoint FIQRXBYPASS.value[0:0];
        FIQTXBYPASS_wr : coverpoint FIQTXBYPASS.value[0:0];
        FIQCALEN_wr : coverpoint FIQCALEN.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCTRL_rd_cg";
        FIQPATHSEL_rd : coverpoint FIQPATHSEL.value[0:0];
        FIQTXRX_rd : coverpoint FIQTXRX.value[0:0];
        FIQRXBYPASS_rd : coverpoint FIQRXBYPASS.value[0:0];
        FIQTXBYPASS_rd : coverpoint FIQTXBYPASS.value[0:0];
        FIQCALEN_rd : coverpoint FIQCALEN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOLL
//--------------------------------------------------------------------
class RWNXFEFIQCOLL extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOLL)
    rand uvm_reg_field FIQCOLLWROFFSET;
    rand uvm_reg_field FIQCOLLRDOFFSET;
    rand uvm_reg_field FIQCOLLSIZE;
    rand uvm_reg_field FIQCOLLPATH;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOLLWROFFSET = uvm_reg_field::type_id::create("FIQCOLLWROFFSET");
        FIQCOLLRDOFFSET = uvm_reg_field::type_id::create("FIQCOLLRDOFFSET");
        FIQCOLLSIZE = uvm_reg_field::type_id::create("FIQCOLLSIZE");
        FIQCOLLPATH = uvm_reg_field::type_id::create("FIQCOLLPATH");

        FIQCOLLWROFFSET.configure(this, 8, 24, "RW", 1, 'b10000000, 1, 1, 1);
        FIQCOLLRDOFFSET.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        FIQCOLLSIZE.configure(this, 8, 8, "RW", 1, 'b10000000, 1, 1, 1);
        FIQCOLLPATH.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOLL_wr_cg";
        FIQCOLLWROFFSET_wr : coverpoint FIQCOLLWROFFSET.value[7:0];
        FIQCOLLRDOFFSET_wr : coverpoint FIQCOLLRDOFFSET.value[7:0];
        FIQCOLLSIZE_wr : coverpoint FIQCOLLSIZE.value[7:0];
        FIQCOLLPATH_wr : coverpoint FIQCOLLPATH.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOLL_rd_cg";
        FIQCOLLWROFFSET_rd : coverpoint FIQCOLLWROFFSET.value[7:0];
        FIQCOLLRDOFFSET_rd : coverpoint FIQCOLLRDOFFSET.value[7:0];
        FIQCOLLSIZE_rd : coverpoint FIQCOLLSIZE.value[7:0];
        FIQCOLLPATH_rd : coverpoint FIQCOLLPATH.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOLL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQEST0
//--------------------------------------------------------------------
class RWNXFEFIQEST0 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQEST0)
    rand uvm_reg_field FIQESTQOFFSET;
    rand uvm_reg_field FIQESTIOFFSET;
    rand uvm_reg_field FIQESTSIZE;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQESTQOFFSET = uvm_reg_field::type_id::create("FIQESTQOFFSET");
        FIQESTIOFFSET = uvm_reg_field::type_id::create("FIQESTIOFFSET");
        FIQESTSIZE = uvm_reg_field::type_id::create("FIQESTSIZE");

        FIQESTQOFFSET.configure(this, 8, 24, "RW", 1, 'b10000000, 1, 1, 1);
        FIQESTIOFFSET.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        FIQESTSIZE.configure(this, 8, 0, "RW", 1, 'b10000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQEST0_wr_cg";
        FIQESTQOFFSET_wr : coverpoint FIQESTQOFFSET.value[7:0];
        FIQESTIOFFSET_wr : coverpoint FIQESTIOFFSET.value[7:0];
        FIQESTSIZE_wr : coverpoint FIQESTSIZE.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQEST0_rd_cg";
        FIQESTQOFFSET_rd : coverpoint FIQESTQOFFSET.value[7:0];
        FIQESTIOFFSET_rd : coverpoint FIQESTIOFFSET.value[7:0];
        FIQESTSIZE_rd : coverpoint FIQESTSIZE.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQEST0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQEST1
//--------------------------------------------------------------------
class RWNXFEFIQEST1 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQEST1)
    rand uvm_reg_field FIQESTSTEP;
    rand uvm_reg_field FIQESTNITE;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQESTSTEP = uvm_reg_field::type_id::create("FIQESTSTEP");
        FIQESTNITE = uvm_reg_field::type_id::create("FIQESTNITE");

        FIQESTSTEP.configure(this, 4, 16, "RW", 1, 'b110, 1, 1, 1);
        FIQESTNITE.configure(this, 16, 0, "RW", 1, 'b010011100010000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQEST1_wr_cg";
        FIQESTSTEP_wr : coverpoint FIQESTSTEP.value[3:0];
        FIQESTNITE_wr : coverpoint FIQESTNITE.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQEST1_rd_cg";
        FIQESTSTEP_rd : coverpoint FIQESTSTEP.value[3:0];
        FIQESTNITE_rd : coverpoint FIQESTNITE.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQEST1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQDEL
//--------------------------------------------------------------------
class RWNXFEFIQDEL extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQDEL)
    rand uvm_reg_field FIQRXDEL;
    rand uvm_reg_field FIQTXDEL;
    rand uvm_reg_field FIQCOLLDEL;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQRXDEL = uvm_reg_field::type_id::create("FIQRXDEL");
        FIQTXDEL = uvm_reg_field::type_id::create("FIQTXDEL");
        FIQCOLLDEL = uvm_reg_field::type_id::create("FIQCOLLDEL");

        FIQRXDEL.configure(this, 5, 24, "RW", 1, 'b1001, 1, 1, 1);
        FIQTXDEL.configure(this, 5, 16, "RW", 1, 'b1001, 1, 1, 1);
        FIQCOLLDEL.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQDEL_wr_cg";
        FIQRXDEL_wr : coverpoint FIQRXDEL.value[4:0];
        FIQTXDEL_wr : coverpoint FIQTXDEL.value[4:0];
        FIQCOLLDEL_wr : coverpoint FIQCOLLDEL.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQDEL_rd_cg";
        FIQRXDEL_rd : coverpoint FIQRXDEL.value[4:0];
        FIQTXDEL_rd : coverpoint FIQTXDEL.value[4:0];
        FIQCOLLDEL_rd : coverpoint FIQCOLLDEL.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQDEL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF0
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF0 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF0)
    rand uvm_reg_field FIQCOEFF0;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF0 = uvm_reg_field::type_id::create("FIQCOEFF0");

        FIQCOEFF0.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF0_wr_cg";
        FIQCOEFF0_wr : coverpoint FIQCOEFF0.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF0_rd_cg";
        FIQCOEFF0_rd : coverpoint FIQCOEFF0.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF1
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF1 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF1)
    rand uvm_reg_field FIQCOEFF1;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF1 = uvm_reg_field::type_id::create("FIQCOEFF1");

        FIQCOEFF1.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF1_wr_cg";
        FIQCOEFF1_wr : coverpoint FIQCOEFF1.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF1_rd_cg";
        FIQCOEFF1_rd : coverpoint FIQCOEFF1.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF2
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF2 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF2)
    rand uvm_reg_field FIQCOEFF2;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF2 = uvm_reg_field::type_id::create("FIQCOEFF2");

        FIQCOEFF2.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF2_wr_cg";
        FIQCOEFF2_wr : coverpoint FIQCOEFF2.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF2_rd_cg";
        FIQCOEFF2_rd : coverpoint FIQCOEFF2.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF3
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF3 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF3)
    rand uvm_reg_field FIQCOEFF3;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF3 = uvm_reg_field::type_id::create("FIQCOEFF3");

        FIQCOEFF3.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF3_wr_cg";
        FIQCOEFF3_wr : coverpoint FIQCOEFF3.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF3_rd_cg";
        FIQCOEFF3_rd : coverpoint FIQCOEFF3.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF4
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF4 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF4)
    rand uvm_reg_field FIQCOEFF4;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF4 = uvm_reg_field::type_id::create("FIQCOEFF4");

        FIQCOEFF4.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF4_wr_cg";
        FIQCOEFF4_wr : coverpoint FIQCOEFF4.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF4_rd_cg";
        FIQCOEFF4_rd : coverpoint FIQCOEFF4.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF5
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF5 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF5)
    rand uvm_reg_field FIQCOEFF5;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF5 = uvm_reg_field::type_id::create("FIQCOEFF5");

        FIQCOEFF5.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF5_wr_cg";
        FIQCOEFF5_wr : coverpoint FIQCOEFF5.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF5_rd_cg";
        FIQCOEFF5_rd : coverpoint FIQCOEFF5.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF5");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF6
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF6 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF6)
    rand uvm_reg_field FIQCOEFF6;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF6 = uvm_reg_field::type_id::create("FIQCOEFF6");

        FIQCOEFF6.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF6_wr_cg";
        FIQCOEFF6_wr : coverpoint FIQCOEFF6.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF6_rd_cg";
        FIQCOEFF6_rd : coverpoint FIQCOEFF6.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF6");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF7
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF7 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF7)
    rand uvm_reg_field FIQCOEFF7;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF7 = uvm_reg_field::type_id::create("FIQCOEFF7");

        FIQCOEFF7.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF7_wr_cg";
        FIQCOEFF7_wr : coverpoint FIQCOEFF7.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF7_rd_cg";
        FIQCOEFF7_rd : coverpoint FIQCOEFF7.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF7");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF8
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF8 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF8)
    rand uvm_reg_field FIQCOEFF8;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF8 = uvm_reg_field::type_id::create("FIQCOEFF8");

        FIQCOEFF8.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF8_wr_cg";
        FIQCOEFF8_wr : coverpoint FIQCOEFF8.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF8_rd_cg";
        FIQCOEFF8_rd : coverpoint FIQCOEFF8.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF8");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF9
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF9 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF9)
    rand uvm_reg_field FIQCOEFF9;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF9 = uvm_reg_field::type_id::create("FIQCOEFF9");

        FIQCOEFF9.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF9_wr_cg";
        FIQCOEFF9_wr : coverpoint FIQCOEFF9.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF9_rd_cg";
        FIQCOEFF9_rd : coverpoint FIQCOEFF9.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF9");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF10
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF10 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF10)
    rand uvm_reg_field FIQCOEFF10;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF10 = uvm_reg_field::type_id::create("FIQCOEFF10");

        FIQCOEFF10.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF10_wr_cg";
        FIQCOEFF10_wr : coverpoint FIQCOEFF10.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF10_rd_cg";
        FIQCOEFF10_rd : coverpoint FIQCOEFF10.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF10");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF11
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF11 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF11)
    rand uvm_reg_field FIQCOEFF11;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF11 = uvm_reg_field::type_id::create("FIQCOEFF11");

        FIQCOEFF11.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF11_wr_cg";
        FIQCOEFF11_wr : coverpoint FIQCOEFF11.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF11_rd_cg";
        FIQCOEFF11_rd : coverpoint FIQCOEFF11.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF11");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF12
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF12 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF12)
    rand uvm_reg_field FIQCOEFF12;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF12 = uvm_reg_field::type_id::create("FIQCOEFF12");

        FIQCOEFF12.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF12_wr_cg";
        FIQCOEFF12_wr : coverpoint FIQCOEFF12.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF12_rd_cg";
        FIQCOEFF12_rd : coverpoint FIQCOEFF12.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF12");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF13
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF13 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF13)
    rand uvm_reg_field FIQCOEFF13;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF13 = uvm_reg_field::type_id::create("FIQCOEFF13");

        FIQCOEFF13.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF13_wr_cg";
        FIQCOEFF13_wr : coverpoint FIQCOEFF13.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF13_rd_cg";
        FIQCOEFF13_rd : coverpoint FIQCOEFF13.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF13");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF14
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF14 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF14)
    rand uvm_reg_field FIQCOEFF14;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF14 = uvm_reg_field::type_id::create("FIQCOEFF14");

        FIQCOEFF14.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF14_wr_cg";
        FIQCOEFF14_wr : coverpoint FIQCOEFF14.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF14_rd_cg";
        FIQCOEFF14_rd : coverpoint FIQCOEFF14.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF14");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF15
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF15 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF15)
    rand uvm_reg_field FIQCOEFF15;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF15 = uvm_reg_field::type_id::create("FIQCOEFF15");

        FIQCOEFF15.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF15_wr_cg";
        FIQCOEFF15_wr : coverpoint FIQCOEFF15.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF15_rd_cg";
        FIQCOEFF15_rd : coverpoint FIQCOEFF15.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF15");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF16
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF16 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF16)
    rand uvm_reg_field FIQCOEFF16;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF16 = uvm_reg_field::type_id::create("FIQCOEFF16");

        FIQCOEFF16.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF16_wr_cg";
        FIQCOEFF16_wr : coverpoint FIQCOEFF16.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF16_rd_cg";
        FIQCOEFF16_rd : coverpoint FIQCOEFF16.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF16");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF17
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF17 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF17)
    rand uvm_reg_field FIQCOEFF17;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF17 = uvm_reg_field::type_id::create("FIQCOEFF17");

        FIQCOEFF17.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF17_wr_cg";
        FIQCOEFF17_wr : coverpoint FIQCOEFF17.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF17_rd_cg";
        FIQCOEFF17_rd : coverpoint FIQCOEFF17.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF17");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF18
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF18 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF18)
    rand uvm_reg_field FIQCOEFF18;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF18 = uvm_reg_field::type_id::create("FIQCOEFF18");

        FIQCOEFF18.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF18_wr_cg";
        FIQCOEFF18_wr : coverpoint FIQCOEFF18.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF18_rd_cg";
        FIQCOEFF18_rd : coverpoint FIQCOEFF18.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF18");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFF19
//--------------------------------------------------------------------
class RWNXFEFIQCOEFF19 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFF19)
    rand uvm_reg_field FIQCOEFF19;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFF19 = uvm_reg_field::type_id::create("FIQCOEFF19");

        FIQCOEFF19.configure(this, 16, 0, "RW", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF19_wr_cg";
        FIQCOEFF19_wr : coverpoint FIQCOEFF19.value[15:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFF19_rd_cg";
        FIQCOEFF19_rd : coverpoint FIQCOEFF19.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFF19");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFFUPDATE
//--------------------------------------------------------------------
class RWNXFEFIQCOEFFUPDATE extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFFUPDATE)
    rand uvm_reg_field FIQCOEFFUPDATE;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFFUPDATE = uvm_reg_field::type_id::create("FIQCOEFFUPDATE");

        FIQCOEFFUPDATE.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFFUPDATE_wr_cg";
        FIQCOEFFUPDATE_wr : coverpoint FIQCOEFFUPDATE.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFFUPDATE_rd_cg";
        FIQCOEFFUPDATE_rd : coverpoint FIQCOEFFUPDATE.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFFUPDATE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQCOEFFREQ
//--------------------------------------------------------------------
class RWNXFEFIQCOEFFREQ extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQCOEFFREQ)
    rand uvm_reg_field FIQCOEFFREQ;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQCOEFFREQ = uvm_reg_field::type_id::create("FIQCOEFFREQ");

        FIQCOEFFREQ.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFFREQ_wr_cg";
        FIQCOEFFREQ_wr : coverpoint FIQCOEFFREQ.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQCOEFFREQ_rd_cg";
        FIQCOEFFREQ_rd : coverpoint FIQCOEFFREQ.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQCOEFFREQ");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTART
//--------------------------------------------------------------------
class RWNXFEFIQSTART extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTART)
    rand uvm_reg_field FIQESTSTART;
    rand uvm_reg_field FIQCOLLSTART;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQESTSTART = uvm_reg_field::type_id::create("FIQESTSTART");
        FIQCOLLSTART = uvm_reg_field::type_id::create("FIQCOLLSTART");

        FIQESTSTART.configure(this, 1, 16, "W1S", 1, 'b0, 1, 1, 1);
        FIQCOLLSTART.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTART_wr_cg";
        FIQESTSTART_wr : coverpoint FIQESTSTART.value[0:0];
        FIQCOLLSTART_wr : coverpoint FIQCOLLSTART.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTART");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// AGCGAINSTAT
//--------------------------------------------------------------------
class AGCGAINSTAT extends uvm_reg;
    `uvm_object_utils(AGCGAINSTAT)
    rand uvm_reg_field AGCGAIN1;
    rand uvm_reg_field AGCGAIN0;

    //---build------------------------------------------------------------
    virtual function void build();
        AGCGAIN1 = uvm_reg_field::type_id::create("AGCGAIN1");
        AGCGAIN0 = uvm_reg_field::type_id::create("AGCGAIN0");

        AGCGAIN1.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        AGCGAIN0.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_AGCGAINSTAT_rd_cg";
        AGCGAIN1_rd : coverpoint AGCGAIN1.value[7:0];
        AGCGAIN0_rd : coverpoint AGCGAIN0.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "AGCGAINSTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// AGCADCPOWSTAT
//--------------------------------------------------------------------
class AGCADCPOWSTAT extends uvm_reg;
    `uvm_object_utils(AGCADCPOWSTAT)
    rand uvm_reg_field ADCPOWDBV1;
    rand uvm_reg_field ADCPOWDBV0;

    //---build------------------------------------------------------------
    virtual function void build();
        ADCPOWDBV1 = uvm_reg_field::type_id::create("ADCPOWDBV1");
        ADCPOWDBV0 = uvm_reg_field::type_id::create("ADCPOWDBV0");

        ADCPOWDBV1.configure(this, 7, 8, "RO", 1, 'b000000, 1, 1, 1);
        ADCPOWDBV0.configure(this, 7, 0, "RO", 1, 'b000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_AGCADCPOWSTAT_rd_cg";
        ADCPOWDBV1_rd : coverpoint ADCPOWDBV1.value[6:0];
        ADCPOWDBV0_rd : coverpoint ADCPOWDBV0.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "AGCADCPOWSTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// AGCINBDPOW20PSTAT
//--------------------------------------------------------------------
class AGCINBDPOW20PSTAT extends uvm_reg;
    `uvm_object_utils(AGCINBDPOW20PSTAT)
    rand uvm_reg_field INBDPOW20PDBM1;
    rand uvm_reg_field INBDPOW20PDBM0;

    //---build------------------------------------------------------------
    virtual function void build();
        INBDPOW20PDBM1 = uvm_reg_field::type_id::create("INBDPOW20PDBM1");
        INBDPOW20PDBM0 = uvm_reg_field::type_id::create("INBDPOW20PDBM0");

        INBDPOW20PDBM1.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        INBDPOW20PDBM0.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_AGCINBDPOW20PSTAT_rd_cg";
        INBDPOW20PDBM1_rd : coverpoint INBDPOW20PDBM1.value[7:0];
        INBDPOW20PDBM0_rd : coverpoint INBDPOW20PDBM0.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "AGCINBDPOW20PSTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// AGCDIGGAIN0STAT
//--------------------------------------------------------------------
class AGCDIGGAIN0STAT extends uvm_reg;
    `uvm_object_utils(AGCDIGGAIN0STAT)
    rand uvm_reg_field DIGGAIN80ANT0;
    rand uvm_reg_field DIGGAIN40ANT0;
    rand uvm_reg_field DIGGAIN20ANT0;

    //---build------------------------------------------------------------
    virtual function void build();
        DIGGAIN80ANT0 = uvm_reg_field::type_id::create("DIGGAIN80ANT0");
        DIGGAIN40ANT0 = uvm_reg_field::type_id::create("DIGGAIN40ANT0");
        DIGGAIN20ANT0 = uvm_reg_field::type_id::create("DIGGAIN20ANT0");

        DIGGAIN80ANT0.configure(this, 7, 16, "RO", 1, 'b000000, 1, 1, 1);
        DIGGAIN40ANT0.configure(this, 7, 8, "RO", 1, 'b000000, 1, 1, 1);
        DIGGAIN20ANT0.configure(this, 7, 0, "RO", 1, 'b000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_AGCDIGGAIN0STAT_rd_cg";
        DIGGAIN80ANT0_rd : coverpoint DIGGAIN80ANT0.value[6:0];
        DIGGAIN40ANT0_rd : coverpoint DIGGAIN40ANT0.value[6:0];
        DIGGAIN20ANT0_rd : coverpoint DIGGAIN20ANT0.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "AGCDIGGAIN0STAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// AGCDIGGAIN1STAT
//--------------------------------------------------------------------
class AGCDIGGAIN1STAT extends uvm_reg;
    `uvm_object_utils(AGCDIGGAIN1STAT)
    rand uvm_reg_field DIGGAIN80ANT1;
    rand uvm_reg_field DIGGAIN40ANT1;
    rand uvm_reg_field DIGGAIN20ANT1;

    //---build------------------------------------------------------------
    virtual function void build();
        DIGGAIN80ANT1 = uvm_reg_field::type_id::create("DIGGAIN80ANT1");
        DIGGAIN40ANT1 = uvm_reg_field::type_id::create("DIGGAIN40ANT1");
        DIGGAIN20ANT1 = uvm_reg_field::type_id::create("DIGGAIN20ANT1");

        DIGGAIN80ANT1.configure(this, 7, 16, "RO", 1, 'b000000, 1, 1, 1);
        DIGGAIN40ANT1.configure(this, 7, 8, "RO", 1, 'b000000, 1, 1, 1);
        DIGGAIN20ANT1.configure(this, 7, 0, "RO", 1, 'b000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_AGCDIGGAIN1STAT_rd_cg";
        DIGGAIN80ANT1_rd : coverpoint DIGGAIN80ANT1.value[6:0];
        DIGGAIN40ANT1_rd : coverpoint DIGGAIN40ANT1.value[6:0];
        DIGGAIN20ANT1_rd : coverpoint DIGGAIN20ANT1.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "AGCDIGGAIN1STAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RADARFIFOSTAT
//--------------------------------------------------------------------
class RADARFIFOSTAT extends uvm_reg;
    `uvm_object_utils(RADARFIFOSTAT)
    rand uvm_reg_field RADFIFOEMPTY;

    //---build------------------------------------------------------------
    virtual function void build();
        RADFIFOEMPTY = uvm_reg_field::type_id::create("RADFIFOEMPTY");

        RADFIFOEMPTY.configure(this, 1, 0, "RO", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RADARFIFOSTAT_rd_cg";
        RADFIFOEMPTY_rd : coverpoint RADFIFOEMPTY.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RADARFIFOSTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// AGCINBDPOW20PNOISESTAT
//--------------------------------------------------------------------
class AGCINBDPOW20PNOISESTAT extends uvm_reg;
    `uvm_object_utils(AGCINBDPOW20PNOISESTAT)
    rand uvm_reg_field INBDPOW20PNOISEDBM1;
    rand uvm_reg_field INBDPOW20PNOISEDBM0;

    //---build------------------------------------------------------------
    virtual function void build();
        INBDPOW20PNOISEDBM1 = uvm_reg_field::type_id::create("INBDPOW20PNOISEDBM1");
        INBDPOW20PNOISEDBM0 = uvm_reg_field::type_id::create("INBDPOW20PNOISEDBM0");

        INBDPOW20PNOISEDBM1.configure(this, 8, 8, "RO", 1, 'b0000000, 1, 1, 1);
        INBDPOW20PNOISEDBM0.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_AGCINBDPOW20PNOISESTAT_rd_cg";
        INBDPOW20PNOISEDBM1_rd : coverpoint INBDPOW20PNOISEDBM1.value[7:0];
        INBDPOW20PNOISEDBM0_rd : coverpoint INBDPOW20PNOISEDBM0.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "AGCINBDPOW20PNOISESTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// AGCINBDPOWSECSTAT
//--------------------------------------------------------------------
class AGCINBDPOWSECSTAT extends uvm_reg;
    `uvm_object_utils(AGCINBDPOWSECSTAT)
    rand uvm_reg_field INBDPOW40SDBM;
    rand uvm_reg_field INBDPOW20SDBM;

    //---build------------------------------------------------------------
    virtual function void build();
        INBDPOW40SDBM = uvm_reg_field::type_id::create("INBDPOW40SDBM");
        INBDPOW20SDBM = uvm_reg_field::type_id::create("INBDPOW20SDBM");

        INBDPOW40SDBM.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        INBDPOW20SDBM.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_AGCINBDPOWSECSTAT_rd_cg";
        INBDPOW40SDBM_rd : coverpoint INBDPOW40SDBM.value[7:0];
        INBDPOW20SDBM_rd : coverpoint INBDPOW20SDBM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "AGCINBDPOWSECSTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// AGCINBDPOWSECNOISESTAT
//--------------------------------------------------------------------
class AGCINBDPOWSECNOISESTAT extends uvm_reg;
    `uvm_object_utils(AGCINBDPOWSECNOISESTAT)
    rand uvm_reg_field INBDPOW40SNOISEDBM;
    rand uvm_reg_field INBDPOW20SNOISEDBM;

    //---build------------------------------------------------------------
    virtual function void build();
        INBDPOW40SNOISEDBM = uvm_reg_field::type_id::create("INBDPOW40SNOISEDBM");
        INBDPOW20SNOISEDBM = uvm_reg_field::type_id::create("INBDPOW20SNOISEDBM");

        INBDPOW40SNOISEDBM.configure(this, 8, 16, "RO", 1, 'b0000000, 1, 1, 1);
        INBDPOW20SNOISEDBM.configure(this, 8, 0, "RO", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_AGCINBDPOWSECNOISESTAT_rd_cg";
        INBDPOW40SNOISEDBM_rd : coverpoint INBDPOW40SNOISEDBM.value[7:0];
        INBDPOW20SNOISEDBM_rd : coverpoint INBDPOW20SNOISEDBM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "AGCINBDPOWSECNOISESTAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQSTATVARI0
//--------------------------------------------------------------------
class RWNXFERXIQSTATVARI0 extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQSTATVARI0)
    rand uvm_reg_field RXIQVARI0;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQVARI0 = uvm_reg_field::type_id::create("RXIQVARI0");

        RXIQVARI0.configure(this, 22, 0, "RO", 1, 'b000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQSTATVARI0_rd_cg";
        RXIQVARI0_rd : coverpoint RXIQVARI0.value[21:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQSTATVARI0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQSTATVARQ0
//--------------------------------------------------------------------
class RWNXFERXIQSTATVARQ0 extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQSTATVARQ0)
    rand uvm_reg_field RXIQVARQ0;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQVARQ0 = uvm_reg_field::type_id::create("RXIQVARQ0");

        RXIQVARQ0.configure(this, 22, 0, "RO", 1, 'b000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQSTATVARQ0_rd_cg";
        RXIQVARQ0_rd : coverpoint RXIQVARQ0.value[21:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQSTATVARQ0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQSTATMIQ0
//--------------------------------------------------------------------
class RWNXFERXIQSTATMIQ0 extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQSTATMIQ0)
    rand uvm_reg_field RXIQSTATMIQ0;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQSTATMIQ0 = uvm_reg_field::type_id::create("RXIQSTATMIQ0");

        RXIQSTATMIQ0.configure(this, 23, 0, "RO", 1, 'b0000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQSTATMIQ0_rd_cg";
        RXIQSTATMIQ0_rd : coverpoint RXIQSTATMIQ0.value[22:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQSTATMIQ0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQSTAT0
//--------------------------------------------------------------------
class RWNXFERXIQSTAT0 extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQSTAT0)
    rand uvm_reg_field RXIQSTATPHASE0;
    rand uvm_reg_field RXIQSTATGAIN0;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQSTATPHASE0 = uvm_reg_field::type_id::create("RXIQSTATPHASE0");
        RXIQSTATGAIN0 = uvm_reg_field::type_id::create("RXIQSTATGAIN0");

        RXIQSTATPHASE0.configure(this, 9, 16, "RO", 1, 'b00000000, 1, 1, 1);
        RXIQSTATGAIN0.configure(this, 11, 0, "RO", 1, 'b0000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQSTAT0_rd_cg";
        RXIQSTATPHASE0_rd : coverpoint RXIQSTATPHASE0.value[8:0];
        RXIQSTATGAIN0_rd : coverpoint RXIQSTATGAIN0.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQSTATVARI1
//--------------------------------------------------------------------
class RWNXFERXIQSTATVARI1 extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQSTATVARI1)
    rand uvm_reg_field RXIQVARI1;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQVARI1 = uvm_reg_field::type_id::create("RXIQVARI1");

        RXIQVARI1.configure(this, 22, 0, "RO", 1, 'b000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQSTATVARI1_rd_cg";
        RXIQVARI1_rd : coverpoint RXIQVARI1.value[21:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQSTATVARI1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQSTATVARQ1
//--------------------------------------------------------------------
class RWNXFERXIQSTATVARQ1 extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQSTATVARQ1)
    rand uvm_reg_field RXIQVARQ1;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQVARQ1 = uvm_reg_field::type_id::create("RXIQVARQ1");

        RXIQVARQ1.configure(this, 22, 0, "RO", 1, 'b000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQSTATVARQ1_rd_cg";
        RXIQVARQ1_rd : coverpoint RXIQVARQ1.value[21:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQSTATVARQ1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQSTATMIQ1
//--------------------------------------------------------------------
class RWNXFERXIQSTATMIQ1 extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQSTATMIQ1)
    rand uvm_reg_field RXIQSTATMIQ1;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQSTATMIQ1 = uvm_reg_field::type_id::create("RXIQSTATMIQ1");

        RXIQSTATMIQ1.configure(this, 23, 0, "RO", 1, 'b0000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQSTATMIQ1_rd_cg";
        RXIQSTATMIQ1_rd : coverpoint RXIQSTATMIQ1.value[22:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQSTATMIQ1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFERXIQSTAT1
//--------------------------------------------------------------------
class RWNXFERXIQSTAT1 extends uvm_reg;
    `uvm_object_utils(RWNXFERXIQSTAT1)
    rand uvm_reg_field RXIQSTATPHASE1;
    rand uvm_reg_field RXIQSTATGAIN1;

    //---build------------------------------------------------------------
    virtual function void build();
        RXIQSTATPHASE1 = uvm_reg_field::type_id::create("RXIQSTATPHASE1");
        RXIQSTATGAIN1 = uvm_reg_field::type_id::create("RXIQSTATGAIN1");

        RXIQSTATPHASE1.configure(this, 9, 16, "RO", 1, 'b00000000, 1, 1, 1);
        RXIQSTATGAIN1.configure(this, 11, 0, "RO", 1, 'b0000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFERXIQSTAT1_rd_cg";
        RXIQSTATPHASE1_rd : coverpoint RXIQSTATPHASE1.value[8:0];
        RXIQSTATGAIN1_rd : coverpoint RXIQSTATGAIN1.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFERXIQSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQDONE
//--------------------------------------------------------------------
class RWNXFEFIQDONE extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQDONE)
    rand uvm_reg_field FIQESTDONE;
    rand uvm_reg_field FIQCOLLDONE;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQESTDONE = uvm_reg_field::type_id::create("FIQESTDONE");
        FIQCOLLDONE = uvm_reg_field::type_id::create("FIQCOLLDONE");

        FIQESTDONE.configure(this, 1, 16, "RO", 1, 'b1, 1, 1, 1);
        FIQCOLLDONE.configure(this, 1, 0, "RO", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQDONE_rd_cg";
        FIQESTDONE_rd : coverpoint FIQESTDONE.value[0:0];
        FIQCOLLDONE_rd : coverpoint FIQCOLLDONE.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQDONE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTAT0
//--------------------------------------------------------------------
class RWNXFEFIQSTAT0 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTAT0)
    rand uvm_reg_field FIQTXESTERROR0;
    rand uvm_reg_field FIQRXESTERROR0;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQTXESTERROR0 = uvm_reg_field::type_id::create("FIQTXESTERROR0");
        FIQRXESTERROR0 = uvm_reg_field::type_id::create("FIQRXESTERROR0");

        FIQTXESTERROR0.configure(this, 13, 16, "RO", 1, 'b000000000000, 1, 1, 1);
        FIQRXESTERROR0.configure(this, 13, 0, "RO", 1, 'b000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTAT0_rd_cg";
        FIQTXESTERROR0_rd : coverpoint FIQTXESTERROR0.value[12:0];
        FIQRXESTERROR0_rd : coverpoint FIQRXESTERROR0.value[12:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTAT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTAT1
//--------------------------------------------------------------------
class RWNXFEFIQSTAT1 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTAT1)
    rand uvm_reg_field FIQTXESTERROR1;
    rand uvm_reg_field FIQRXESTERROR1;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQTXESTERROR1 = uvm_reg_field::type_id::create("FIQTXESTERROR1");
        FIQRXESTERROR1 = uvm_reg_field::type_id::create("FIQRXESTERROR1");

        FIQTXESTERROR1.configure(this, 13, 16, "RO", 1, 'b000000000000, 1, 1, 1);
        FIQRXESTERROR1.configure(this, 13, 0, "RO", 1, 'b000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTAT1_rd_cg";
        FIQTXESTERROR1_rd : coverpoint FIQTXESTERROR1.value[12:0];
        FIQRXESTERROR1_rd : coverpoint FIQRXESTERROR1.value[12:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTAT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF0
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF0 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF0)
    rand uvm_reg_field FIQSTATCOEFF0;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF0 = uvm_reg_field::type_id::create("FIQSTATCOEFF0");

        FIQSTATCOEFF0.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF0_rd_cg";
        FIQSTATCOEFF0_rd : coverpoint FIQSTATCOEFF0.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF1
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF1 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF1)
    rand uvm_reg_field FIQSTATCOEFF1;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF1 = uvm_reg_field::type_id::create("FIQSTATCOEFF1");

        FIQSTATCOEFF1.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF1_rd_cg";
        FIQSTATCOEFF1_rd : coverpoint FIQSTATCOEFF1.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF2
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF2 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF2)
    rand uvm_reg_field FIQSTATCOEFF2;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF2 = uvm_reg_field::type_id::create("FIQSTATCOEFF2");

        FIQSTATCOEFF2.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF2_rd_cg";
        FIQSTATCOEFF2_rd : coverpoint FIQSTATCOEFF2.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF3
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF3 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF3)
    rand uvm_reg_field FIQSTATCOEFF3;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF3 = uvm_reg_field::type_id::create("FIQSTATCOEFF3");

        FIQSTATCOEFF3.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF3_rd_cg";
        FIQSTATCOEFF3_rd : coverpoint FIQSTATCOEFF3.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF4
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF4 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF4)
    rand uvm_reg_field FIQSTATCOEFF4;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF4 = uvm_reg_field::type_id::create("FIQSTATCOEFF4");

        FIQSTATCOEFF4.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF4_rd_cg";
        FIQSTATCOEFF4_rd : coverpoint FIQSTATCOEFF4.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF5
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF5 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF5)
    rand uvm_reg_field FIQSTATCOEFF5;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF5 = uvm_reg_field::type_id::create("FIQSTATCOEFF5");

        FIQSTATCOEFF5.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF5_rd_cg";
        FIQSTATCOEFF5_rd : coverpoint FIQSTATCOEFF5.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF5");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF6
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF6 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF6)
    rand uvm_reg_field FIQSTATCOEFF6;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF6 = uvm_reg_field::type_id::create("FIQSTATCOEFF6");

        FIQSTATCOEFF6.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF6_rd_cg";
        FIQSTATCOEFF6_rd : coverpoint FIQSTATCOEFF6.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF6");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF7
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF7 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF7)
    rand uvm_reg_field FIQSTATCOEFF7;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF7 = uvm_reg_field::type_id::create("FIQSTATCOEFF7");

        FIQSTATCOEFF7.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF7_rd_cg";
        FIQSTATCOEFF7_rd : coverpoint FIQSTATCOEFF7.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF7");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF8
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF8 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF8)
    rand uvm_reg_field FIQSTATCOEFF8;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF8 = uvm_reg_field::type_id::create("FIQSTATCOEFF8");

        FIQSTATCOEFF8.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF8_rd_cg";
        FIQSTATCOEFF8_rd : coverpoint FIQSTATCOEFF8.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF8");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF9
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF9 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF9)
    rand uvm_reg_field FIQSTATCOEFF9;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF9 = uvm_reg_field::type_id::create("FIQSTATCOEFF9");

        FIQSTATCOEFF9.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF9_rd_cg";
        FIQSTATCOEFF9_rd : coverpoint FIQSTATCOEFF9.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF9");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF10
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF10 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF10)
    rand uvm_reg_field FIQSTATCOEFF10;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF10 = uvm_reg_field::type_id::create("FIQSTATCOEFF10");

        FIQSTATCOEFF10.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF10_rd_cg";
        FIQSTATCOEFF10_rd : coverpoint FIQSTATCOEFF10.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF10");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF11
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF11 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF11)
    rand uvm_reg_field FIQSTATCOEFF11;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF11 = uvm_reg_field::type_id::create("FIQSTATCOEFF11");

        FIQSTATCOEFF11.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF11_rd_cg";
        FIQSTATCOEFF11_rd : coverpoint FIQSTATCOEFF11.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF11");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF12
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF12 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF12)
    rand uvm_reg_field FIQSTATCOEFF12;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF12 = uvm_reg_field::type_id::create("FIQSTATCOEFF12");

        FIQSTATCOEFF12.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF12_rd_cg";
        FIQSTATCOEFF12_rd : coverpoint FIQSTATCOEFF12.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF12");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF13
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF13 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF13)
    rand uvm_reg_field FIQSTATCOEFF13;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF13 = uvm_reg_field::type_id::create("FIQSTATCOEFF13");

        FIQSTATCOEFF13.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF13_rd_cg";
        FIQSTATCOEFF13_rd : coverpoint FIQSTATCOEFF13.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF13");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF14
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF14 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF14)
    rand uvm_reg_field FIQSTATCOEFF14;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF14 = uvm_reg_field::type_id::create("FIQSTATCOEFF14");

        FIQSTATCOEFF14.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF14_rd_cg";
        FIQSTATCOEFF14_rd : coverpoint FIQSTATCOEFF14.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF14");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF15
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF15 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF15)
    rand uvm_reg_field FIQSTATCOEFF15;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF15 = uvm_reg_field::type_id::create("FIQSTATCOEFF15");

        FIQSTATCOEFF15.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF15_rd_cg";
        FIQSTATCOEFF15_rd : coverpoint FIQSTATCOEFF15.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF15");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF16
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF16 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF16)
    rand uvm_reg_field FIQSTATCOEFF16;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF16 = uvm_reg_field::type_id::create("FIQSTATCOEFF16");

        FIQSTATCOEFF16.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF16_rd_cg";
        FIQSTATCOEFF16_rd : coverpoint FIQSTATCOEFF16.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF16");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF17
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF17 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF17)
    rand uvm_reg_field FIQSTATCOEFF17;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF17 = uvm_reg_field::type_id::create("FIQSTATCOEFF17");

        FIQSTATCOEFF17.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF17_rd_cg";
        FIQSTATCOEFF17_rd : coverpoint FIQSTATCOEFF17.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF17");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF18
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF18 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF18)
    rand uvm_reg_field FIQSTATCOEFF18;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF18 = uvm_reg_field::type_id::create("FIQSTATCOEFF18");

        FIQSTATCOEFF18.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF18_rd_cg";
        FIQSTATCOEFF18_rd : coverpoint FIQSTATCOEFF18.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF18");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEFIQSTATCOEFF19
//--------------------------------------------------------------------
class RWNXFEFIQSTATCOEFF19 extends uvm_reg;
    `uvm_object_utils(RWNXFEFIQSTATCOEFF19)
    rand uvm_reg_field FIQSTATCOEFF19;

    //---build------------------------------------------------------------
    virtual function void build();
        FIQSTATCOEFF19 = uvm_reg_field::type_id::create("FIQSTATCOEFF19");

        FIQSTATCOEFF19.configure(this, 16, 0, "RO", 1, 'b000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEFIQSTATCOEFF19_rd_cg";
        FIQSTATCOEFF19_rd : coverpoint FIQSTATCOEFF19.value[15:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEFIQSTATCOEFF19");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCANTLOSS
//--------------------------------------------------------------------
class RWNXAGCANTLOSS extends uvm_reg;
    `uvm_object_utils(RWNXAGCANTLOSS)
    rand uvm_reg_field RFLOSSANT1DB;
    rand uvm_reg_field RFLOSSANT0DB;

    //---build------------------------------------------------------------
    virtual function void build();
        RFLOSSANT1DB = uvm_reg_field::type_id::create("RFLOSSANT1DB");
        RFLOSSANT0DB = uvm_reg_field::type_id::create("RFLOSSANT0DB");

        RFLOSSANT1DB.configure(this, 4, 8, "RW", 1, 'b000, 1, 1, 1);
        RFLOSSANT0DB.configure(this, 4, 0, "RW", 1, 'b000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCANTLOSS_wr_cg";
        RFLOSSANT1DB_wr : coverpoint RFLOSSANT1DB.value[3:0];
        RFLOSSANT0DB_wr : coverpoint RFLOSSANT0DB.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCANTLOSS_rd_cg";
        RFLOSSANT1DB_rd : coverpoint RFLOSSANT1DB.value[3:0];
        RFLOSSANT0DB_rd : coverpoint RFLOSSANT0DB.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCANTLOSS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCGAINRANGE
//--------------------------------------------------------------------
class RWNXAGCGAINRANGE extends uvm_reg;
    `uvm_object_utils(RWNXAGCGAINRANGE)
    rand uvm_reg_field RFGAINMAX4DETDB;
    rand uvm_reg_field RFGAINMIN4DETDB;
    rand uvm_reg_field RFGAINMAXDB;
    rand uvm_reg_field RFGAINMINDB;

    //---build------------------------------------------------------------
    virtual function void build();
        RFGAINMAX4DETDB = uvm_reg_field::type_id::create("RFGAINMAX4DETDB");
        RFGAINMIN4DETDB = uvm_reg_field::type_id::create("RFGAINMIN4DETDB");
        RFGAINMAXDB = uvm_reg_field::type_id::create("RFGAINMAXDB");
        RFGAINMINDB = uvm_reg_field::type_id::create("RFGAINMINDB");

        RFGAINMAX4DETDB.configure(this, 7, 24, "RW", 1, 'b1000010, 1, 1, 1);
        RFGAINMIN4DETDB.configure(this, 7, 16, "RW", 1, 'b000000, 1, 1, 1);
        RFGAINMAXDB.configure(this, 7, 8, "RW", 1, 'b1000010, 1, 1, 1);
        RFGAINMINDB.configure(this, 7, 0, "RW", 1, 'b000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCGAINRANGE_wr_cg";
        RFGAINMAX4DETDB_wr : coverpoint RFGAINMAX4DETDB.value[6:0];
        RFGAINMIN4DETDB_wr : coverpoint RFGAINMIN4DETDB.value[6:0];
        RFGAINMAXDB_wr : coverpoint RFGAINMAXDB.value[6:0];
        RFGAINMINDB_wr : coverpoint RFGAINMINDB.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCGAINRANGE_rd_cg";
        RFGAINMAX4DETDB_rd : coverpoint RFGAINMAX4DETDB.value[6:0];
        RFGAINMIN4DETDB_rd : coverpoint RFGAINMIN4DETDB.value[6:0];
        RFGAINMAXDB_rd : coverpoint RFGAINMAXDB.value[6:0];
        RFGAINMINDB_rd : coverpoint RFGAINMINDB.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCGAINRANGE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCDIGGAINCONF
//--------------------------------------------------------------------
class RWNXAGCDIGGAINCONF extends uvm_reg;
    `uvm_object_utils(RWNXAGCDIGGAINCONF)
    rand uvm_reg_field DIGGAIN80VS20;
    rand uvm_reg_field DIGGAIN40VS20;

    //---build------------------------------------------------------------
    virtual function void build();
        DIGGAIN80VS20 = uvm_reg_field::type_id::create("DIGGAIN80VS20");
        DIGGAIN40VS20 = uvm_reg_field::type_id::create("DIGGAIN40VS20");

        DIGGAIN80VS20.configure(this, 4, 16, "RW", 1, 'b000, 1, 1, 1);
        DIGGAIN40VS20.configure(this, 4, 0, "RW", 1, 'b000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDIGGAINCONF_wr_cg";
        DIGGAIN80VS20_wr : coverpoint DIGGAIN80VS20.value[3:0];
        DIGGAIN40VS20_wr : coverpoint DIGGAIN40VS20.value[3:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDIGGAINCONF_rd_cg";
        DIGGAIN80VS20_rd : coverpoint DIGGAIN80VS20.value[3:0];
        DIGGAIN40VS20_rd : coverpoint DIGGAIN40VS20.value[3:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCDIGGAINCONF");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCNOISECONF
//--------------------------------------------------------------------
class RWNXAGCNOISECONF extends uvm_reg;
    `uvm_object_utils(RWNXAGCNOISECONF)
    rand uvm_reg_field SNRMEASSEL;

    //---build------------------------------------------------------------
    virtual function void build();
        SNRMEASSEL = uvm_reg_field::type_id::create("SNRMEASSEL");

        SNRMEASSEL.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCNOISECONF_wr_cg";
        SNRMEASSEL_wr : coverpoint SNRMEASSEL.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCNOISECONF_rd_cg";
        SNRMEASSEL_rd : coverpoint SNRMEASSEL.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCNOISECONF");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCACI20MARG0
//--------------------------------------------------------------------
class RWNXAGCACI20MARG0 extends uvm_reg;
    `uvm_object_utils(RWNXAGCACI20MARG0)
    rand uvm_reg_field ACI20MARGMCS3;
    rand uvm_reg_field ACI20MARGMCS2;
    rand uvm_reg_field ACI20MARGMCS1;
    rand uvm_reg_field ACI20MARGMCS0;

    //---build------------------------------------------------------------
    virtual function void build();
        ACI20MARGMCS3 = uvm_reg_field::type_id::create("ACI20MARGMCS3");
        ACI20MARGMCS2 = uvm_reg_field::type_id::create("ACI20MARGMCS2");
        ACI20MARGMCS1 = uvm_reg_field::type_id::create("ACI20MARGMCS1");
        ACI20MARGMCS0 = uvm_reg_field::type_id::create("ACI20MARGMCS0");

        ACI20MARGMCS3.configure(this, 6, 24, "RW", 1, 'b00010, 1, 1, 1);
        ACI20MARGMCS2.configure(this, 6, 16, "RW", 1, 'b00100, 1, 1, 1);
        ACI20MARGMCS1.configure(this, 6, 8, "RW", 1, 'b00101, 1, 1, 1);
        ACI20MARGMCS0.configure(this, 6, 0, "RW", 1, 'b00111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI20MARG0_wr_cg";
        ACI20MARGMCS3_wr : coverpoint ACI20MARGMCS3.value[5:0];
        ACI20MARGMCS2_wr : coverpoint ACI20MARGMCS2.value[5:0];
        ACI20MARGMCS1_wr : coverpoint ACI20MARGMCS1.value[5:0];
        ACI20MARGMCS0_wr : coverpoint ACI20MARGMCS0.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI20MARG0_rd_cg";
        ACI20MARGMCS3_rd : coverpoint ACI20MARGMCS3.value[5:0];
        ACI20MARGMCS2_rd : coverpoint ACI20MARGMCS2.value[5:0];
        ACI20MARGMCS1_rd : coverpoint ACI20MARGMCS1.value[5:0];
        ACI20MARGMCS0_rd : coverpoint ACI20MARGMCS0.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCACI20MARG0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCACI20MARG1
//--------------------------------------------------------------------
class RWNXAGCACI20MARG1 extends uvm_reg;
    `uvm_object_utils(RWNXAGCACI20MARG1)
    rand uvm_reg_field ACI20MARGMCS7;
    rand uvm_reg_field ACI20MARGMCS6;
    rand uvm_reg_field ACI20MARGMCS5;
    rand uvm_reg_field ACI20MARGMCS4;

    //---build------------------------------------------------------------
    virtual function void build();
        ACI20MARGMCS7 = uvm_reg_field::type_id::create("ACI20MARGMCS7");
        ACI20MARGMCS6 = uvm_reg_field::type_id::create("ACI20MARGMCS6");
        ACI20MARGMCS5 = uvm_reg_field::type_id::create("ACI20MARGMCS5");
        ACI20MARGMCS4 = uvm_reg_field::type_id::create("ACI20MARGMCS4");

        ACI20MARGMCS7.configure(this, 6, 24, "RW", 1, 'b00000, 1, 1, 1);
        ACI20MARGMCS6.configure(this, 6, 16, "RW", 1, 'b00000, 1, 1, 1);
        ACI20MARGMCS5.configure(this, 6, 8, "RW", 1, 'b00000, 1, 1, 1);
        ACI20MARGMCS4.configure(this, 6, 0, "RW", 1, 'b00001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI20MARG1_wr_cg";
        ACI20MARGMCS7_wr : coverpoint ACI20MARGMCS7.value[5:0];
        ACI20MARGMCS6_wr : coverpoint ACI20MARGMCS6.value[5:0];
        ACI20MARGMCS5_wr : coverpoint ACI20MARGMCS5.value[5:0];
        ACI20MARGMCS4_wr : coverpoint ACI20MARGMCS4.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI20MARG1_rd_cg";
        ACI20MARGMCS7_rd : coverpoint ACI20MARGMCS7.value[5:0];
        ACI20MARGMCS6_rd : coverpoint ACI20MARGMCS6.value[5:0];
        ACI20MARGMCS5_rd : coverpoint ACI20MARGMCS5.value[5:0];
        ACI20MARGMCS4_rd : coverpoint ACI20MARGMCS4.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCACI20MARG1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCACI20MARG2
//--------------------------------------------------------------------
class RWNXAGCACI20MARG2 extends uvm_reg;
    `uvm_object_utils(RWNXAGCACI20MARG2)
    rand uvm_reg_field ACI20MARGMCS9;
    rand uvm_reg_field ACI20MARGMCS8;

    //---build------------------------------------------------------------
    virtual function void build();
        ACI20MARGMCS9 = uvm_reg_field::type_id::create("ACI20MARGMCS9");
        ACI20MARGMCS8 = uvm_reg_field::type_id::create("ACI20MARGMCS8");

        ACI20MARGMCS9.configure(this, 6, 8, "RW", 1, 'b00000, 1, 1, 1);
        ACI20MARGMCS8.configure(this, 6, 0, "RW", 1, 'b00000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI20MARG2_wr_cg";
        ACI20MARGMCS9_wr : coverpoint ACI20MARGMCS9.value[5:0];
        ACI20MARGMCS8_wr : coverpoint ACI20MARGMCS8.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI20MARG2_rd_cg";
        ACI20MARGMCS9_rd : coverpoint ACI20MARGMCS9.value[5:0];
        ACI20MARGMCS8_rd : coverpoint ACI20MARGMCS8.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCACI20MARG2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCACI40MARG0
//--------------------------------------------------------------------
class RWNXAGCACI40MARG0 extends uvm_reg;
    `uvm_object_utils(RWNXAGCACI40MARG0)
    rand uvm_reg_field ACI40MARGMCS3;
    rand uvm_reg_field ACI40MARGMCS2;
    rand uvm_reg_field ACI40MARGMCS1;
    rand uvm_reg_field ACI40MARGMCS0;

    //---build------------------------------------------------------------
    virtual function void build();
        ACI40MARGMCS3 = uvm_reg_field::type_id::create("ACI40MARGMCS3");
        ACI40MARGMCS2 = uvm_reg_field::type_id::create("ACI40MARGMCS2");
        ACI40MARGMCS1 = uvm_reg_field::type_id::create("ACI40MARGMCS1");
        ACI40MARGMCS0 = uvm_reg_field::type_id::create("ACI40MARGMCS0");

        ACI40MARGMCS3.configure(this, 6, 24, "RW", 1, 'b01001, 1, 1, 1);
        ACI40MARGMCS2.configure(this, 6, 16, "RW", 1, 'b01011, 1, 1, 1);
        ACI40MARGMCS1.configure(this, 6, 8, "RW", 1, 'b01101, 1, 1, 1);
        ACI40MARGMCS0.configure(this, 6, 0, "RW", 1, 'b10000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI40MARG0_wr_cg";
        ACI40MARGMCS3_wr : coverpoint ACI40MARGMCS3.value[5:0];
        ACI40MARGMCS2_wr : coverpoint ACI40MARGMCS2.value[5:0];
        ACI40MARGMCS1_wr : coverpoint ACI40MARGMCS1.value[5:0];
        ACI40MARGMCS0_wr : coverpoint ACI40MARGMCS0.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI40MARG0_rd_cg";
        ACI40MARGMCS3_rd : coverpoint ACI40MARGMCS3.value[5:0];
        ACI40MARGMCS2_rd : coverpoint ACI40MARGMCS2.value[5:0];
        ACI40MARGMCS1_rd : coverpoint ACI40MARGMCS1.value[5:0];
        ACI40MARGMCS0_rd : coverpoint ACI40MARGMCS0.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCACI40MARG0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCACI40MARG1
//--------------------------------------------------------------------
class RWNXAGCACI40MARG1 extends uvm_reg;
    `uvm_object_utils(RWNXAGCACI40MARG1)
    rand uvm_reg_field ACI40MARGMCS7;
    rand uvm_reg_field ACI40MARGMCS6;
    rand uvm_reg_field ACI40MARGMCS5;
    rand uvm_reg_field ACI40MARGMCS4;

    //---build------------------------------------------------------------
    virtual function void build();
        ACI40MARGMCS7 = uvm_reg_field::type_id::create("ACI40MARGMCS7");
        ACI40MARGMCS6 = uvm_reg_field::type_id::create("ACI40MARGMCS6");
        ACI40MARGMCS5 = uvm_reg_field::type_id::create("ACI40MARGMCS5");
        ACI40MARGMCS4 = uvm_reg_field::type_id::create("ACI40MARGMCS4");

        ACI40MARGMCS7.configure(this, 6, 24, "RW", 1, 'b00010, 1, 1, 1);
        ACI40MARGMCS6.configure(this, 6, 16, "RW", 1, 'b00011, 1, 1, 1);
        ACI40MARGMCS5.configure(this, 6, 8, "RW", 1, 'b00011, 1, 1, 1);
        ACI40MARGMCS4.configure(this, 6, 0, "RW", 1, 'b00101, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI40MARG1_wr_cg";
        ACI40MARGMCS7_wr : coverpoint ACI40MARGMCS7.value[5:0];
        ACI40MARGMCS6_wr : coverpoint ACI40MARGMCS6.value[5:0];
        ACI40MARGMCS5_wr : coverpoint ACI40MARGMCS5.value[5:0];
        ACI40MARGMCS4_wr : coverpoint ACI40MARGMCS4.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI40MARG1_rd_cg";
        ACI40MARGMCS7_rd : coverpoint ACI40MARGMCS7.value[5:0];
        ACI40MARGMCS6_rd : coverpoint ACI40MARGMCS6.value[5:0];
        ACI40MARGMCS5_rd : coverpoint ACI40MARGMCS5.value[5:0];
        ACI40MARGMCS4_rd : coverpoint ACI40MARGMCS4.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCACI40MARG1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCACI40MARG2
//--------------------------------------------------------------------
class RWNXAGCACI40MARG2 extends uvm_reg;
    `uvm_object_utils(RWNXAGCACI40MARG2)
    rand uvm_reg_field ACI40MARGMCS9;
    rand uvm_reg_field ACI40MARGMCS8;

    //---build------------------------------------------------------------
    virtual function void build();
        ACI40MARGMCS9 = uvm_reg_field::type_id::create("ACI40MARGMCS9");
        ACI40MARGMCS8 = uvm_reg_field::type_id::create("ACI40MARGMCS8");

        ACI40MARGMCS9.configure(this, 6, 8, "RW", 1, 'b00001, 1, 1, 1);
        ACI40MARGMCS8.configure(this, 6, 0, "RW", 1, 'b00001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI40MARG2_wr_cg";
        ACI40MARGMCS9_wr : coverpoint ACI40MARGMCS9.value[5:0];
        ACI40MARGMCS8_wr : coverpoint ACI40MARGMCS8.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI40MARG2_rd_cg";
        ACI40MARGMCS9_rd : coverpoint ACI40MARGMCS9.value[5:0];
        ACI40MARGMCS8_rd : coverpoint ACI40MARGMCS8.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCACI40MARG2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCACI80MARG0
//--------------------------------------------------------------------
class RWNXAGCACI80MARG0 extends uvm_reg;
    `uvm_object_utils(RWNXAGCACI80MARG0)
    rand uvm_reg_field ACI80MARGMCS3;
    rand uvm_reg_field ACI80MARGMCS2;
    rand uvm_reg_field ACI80MARGMCS1;
    rand uvm_reg_field ACI80MARGMCS0;

    //---build------------------------------------------------------------
    virtual function void build();
        ACI80MARGMCS3 = uvm_reg_field::type_id::create("ACI80MARGMCS3");
        ACI80MARGMCS2 = uvm_reg_field::type_id::create("ACI80MARGMCS2");
        ACI80MARGMCS1 = uvm_reg_field::type_id::create("ACI80MARGMCS1");
        ACI80MARGMCS0 = uvm_reg_field::type_id::create("ACI80MARGMCS0");

        ACI80MARGMCS3.configure(this, 6, 24, "RW", 1, 'b11000, 1, 1, 1);
        ACI80MARGMCS2.configure(this, 6, 16, "RW", 1, 'b11011, 1, 1, 1);
        ACI80MARGMCS1.configure(this, 6, 8, "RW", 1, 'b11101, 1, 1, 1);
        ACI80MARGMCS0.configure(this, 6, 0, "RW", 1, 'b100000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI80MARG0_wr_cg";
        ACI80MARGMCS3_wr : coverpoint ACI80MARGMCS3.value[5:0];
        ACI80MARGMCS2_wr : coverpoint ACI80MARGMCS2.value[5:0];
        ACI80MARGMCS1_wr : coverpoint ACI80MARGMCS1.value[5:0];
        ACI80MARGMCS0_wr : coverpoint ACI80MARGMCS0.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI80MARG0_rd_cg";
        ACI80MARGMCS3_rd : coverpoint ACI80MARGMCS3.value[5:0];
        ACI80MARGMCS2_rd : coverpoint ACI80MARGMCS2.value[5:0];
        ACI80MARGMCS1_rd : coverpoint ACI80MARGMCS1.value[5:0];
        ACI80MARGMCS0_rd : coverpoint ACI80MARGMCS0.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCACI80MARG0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCACI80MARG1
//--------------------------------------------------------------------
class RWNXAGCACI80MARG1 extends uvm_reg;
    `uvm_object_utils(RWNXAGCACI80MARG1)
    rand uvm_reg_field ACI80MARGMCS7;
    rand uvm_reg_field ACI80MARGMCS6;
    rand uvm_reg_field ACI80MARGMCS5;
    rand uvm_reg_field ACI80MARGMCS4;

    //---build------------------------------------------------------------
    virtual function void build();
        ACI80MARGMCS7 = uvm_reg_field::type_id::create("ACI80MARGMCS7");
        ACI80MARGMCS6 = uvm_reg_field::type_id::create("ACI80MARGMCS6");
        ACI80MARGMCS5 = uvm_reg_field::type_id::create("ACI80MARGMCS5");
        ACI80MARGMCS4 = uvm_reg_field::type_id::create("ACI80MARGMCS4");

        ACI80MARGMCS7.configure(this, 6, 24, "RW", 1, 'b01110, 1, 1, 1);
        ACI80MARGMCS6.configure(this, 6, 16, "RW", 1, 'b01111, 1, 1, 1);
        ACI80MARGMCS5.configure(this, 6, 8, "RW", 1, 'b10000, 1, 1, 1);
        ACI80MARGMCS4.configure(this, 6, 0, "RW", 1, 'b10100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI80MARG1_wr_cg";
        ACI80MARGMCS7_wr : coverpoint ACI80MARGMCS7.value[5:0];
        ACI80MARGMCS6_wr : coverpoint ACI80MARGMCS6.value[5:0];
        ACI80MARGMCS5_wr : coverpoint ACI80MARGMCS5.value[5:0];
        ACI80MARGMCS4_wr : coverpoint ACI80MARGMCS4.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI80MARG1_rd_cg";
        ACI80MARGMCS7_rd : coverpoint ACI80MARGMCS7.value[5:0];
        ACI80MARGMCS6_rd : coverpoint ACI80MARGMCS6.value[5:0];
        ACI80MARGMCS5_rd : coverpoint ACI80MARGMCS5.value[5:0];
        ACI80MARGMCS4_rd : coverpoint ACI80MARGMCS4.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCACI80MARG1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCACI80MARG2
//--------------------------------------------------------------------
class RWNXAGCACI80MARG2 extends uvm_reg;
    `uvm_object_utils(RWNXAGCACI80MARG2)
    rand uvm_reg_field ACI80MARGMCS9;
    rand uvm_reg_field ACI80MARGMCS8;

    //---build------------------------------------------------------------
    virtual function void build();
        ACI80MARGMCS9 = uvm_reg_field::type_id::create("ACI80MARGMCS9");
        ACI80MARGMCS8 = uvm_reg_field::type_id::create("ACI80MARGMCS8");

        ACI80MARGMCS9.configure(this, 6, 8, "RW", 1, 'b01000, 1, 1, 1);
        ACI80MARGMCS8.configure(this, 6, 0, "RW", 1, 'b01010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI80MARG2_wr_cg";
        ACI80MARGMCS9_wr : coverpoint ACI80MARGMCS9.value[5:0];
        ACI80MARGMCS8_wr : coverpoint ACI80MARGMCS8.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCACI80MARG2_rd_cg";
        ACI80MARGMCS9_rd : coverpoint ACI80MARGMCS9.value[5:0];
        ACI80MARGMCS8_rd : coverpoint ACI80MARGMCS8.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCACI80MARG2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCSAT
//--------------------------------------------------------------------
class RWNXAGCSAT extends uvm_reg;
    `uvm_object_utils(RWNXAGCSAT)
    rand uvm_reg_field SATDELAY50NS;
    rand uvm_reg_field SATHIGHTHRDBV;
    rand uvm_reg_field SATLOWTHRDBV;
    rand uvm_reg_field SATTHRDBV;

    //---build------------------------------------------------------------
    virtual function void build();
        SATDELAY50NS = uvm_reg_field::type_id::create("SATDELAY50NS");
        SATHIGHTHRDBV = uvm_reg_field::type_id::create("SATHIGHTHRDBV");
        SATLOWTHRDBV = uvm_reg_field::type_id::create("SATLOWTHRDBV");
        SATTHRDBV = uvm_reg_field::type_id::create("SATTHRDBV");

        SATDELAY50NS.configure(this, 5, 24, "RW", 1, 'b1000, 1, 1, 1);
        SATHIGHTHRDBV.configure(this, 6, 16, "RW", 1, 'b111001, 1, 1, 1);
        SATLOWTHRDBV.configure(this, 6, 8, "RW", 1, 'b110101, 1, 1, 1);
        SATTHRDBV.configure(this, 6, 0, "RW", 1, 'b110110, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCSAT_wr_cg";
        SATDELAY50NS_wr : coverpoint SATDELAY50NS.value[4:0];
        SATHIGHTHRDBV_wr : coverpoint SATHIGHTHRDBV.value[5:0];
        SATLOWTHRDBV_wr : coverpoint SATLOWTHRDBV.value[5:0];
        SATTHRDBV_wr : coverpoint SATTHRDBV.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCSAT_rd_cg";
        SATDELAY50NS_rd : coverpoint SATDELAY50NS.value[4:0];
        SATHIGHTHRDBV_rd : coverpoint SATHIGHTHRDBV.value[5:0];
        SATLOWTHRDBV_rd : coverpoint SATLOWTHRDBV.value[5:0];
        SATTHRDBV_rd : coverpoint SATTHRDBV.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCSAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCROSS
//--------------------------------------------------------------------
class RWNXAGCCROSS extends uvm_reg;
    `uvm_object_utils(RWNXAGCCROSS)
    rand uvm_reg_field CROSSDNTHRQDBM;
    rand uvm_reg_field CROSSUPTHRQDBM;

    //---build------------------------------------------------------------
    virtual function void build();
        CROSSDNTHRQDBM = uvm_reg_field::type_id::create("CROSSDNTHRQDBM");
        CROSSUPTHRQDBM = uvm_reg_field::type_id::create("CROSSUPTHRQDBM");

        CROSSDNTHRQDBM.configure(this, 10, 12, "RW", 1, 'b1010001000, 1, 1, 1);
        CROSSUPTHRQDBM.configure(this, 10, 0, "RW", 1, 'b1010001000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCROSS_wr_cg";
        CROSSDNTHRQDBM_wr : coverpoint CROSSDNTHRQDBM.value[9:0];
        CROSSUPTHRQDBM_wr : coverpoint CROSSUPTHRQDBM.value[9:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCROSS_rd_cg";
        CROSSDNTHRQDBM_rd : coverpoint CROSSDNTHRQDBM.value[9:0];
        CROSSUPTHRQDBM_rd : coverpoint CROSSUPTHRQDBM.value[9:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCROSS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCRAMP
//--------------------------------------------------------------------
class RWNXAGCRAMP extends uvm_reg;
    `uvm_object_utils(RWNXAGCRAMP)
    rand uvm_reg_field RAMPDNNDLINDEX;
    rand uvm_reg_field RAMPDNGAPQDB;
    rand uvm_reg_field RAMPUPNDLINDEX;
    rand uvm_reg_field RAMPUPGAPQDB;

    //---build------------------------------------------------------------
    virtual function void build();
        RAMPDNNDLINDEX = uvm_reg_field::type_id::create("RAMPDNNDLINDEX");
        RAMPDNGAPQDB = uvm_reg_field::type_id::create("RAMPDNGAPQDB");
        RAMPUPNDLINDEX = uvm_reg_field::type_id::create("RAMPUPNDLINDEX");
        RAMPUPGAPQDB = uvm_reg_field::type_id::create("RAMPUPGAPQDB");

        RAMPDNNDLINDEX.configure(this, 3, 24, "RW", 1, 'b101, 1, 1, 1);
        RAMPDNGAPQDB.configure(this, 8, 16, "RW", 1, 'b0100000, 1, 1, 1);
        RAMPUPNDLINDEX.configure(this, 3, 8, "RW", 1, 'b111, 1, 1, 1);
        RAMPUPGAPQDB.configure(this, 8, 0, "RW", 1, 'b0010000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCRAMP_wr_cg";
        RAMPDNNDLINDEX_wr : coverpoint RAMPDNNDLINDEX.value[2:0];
        RAMPDNGAPQDB_wr : coverpoint RAMPDNGAPQDB.value[7:0];
        RAMPUPNDLINDEX_wr : coverpoint RAMPUPNDLINDEX.value[2:0];
        RAMPUPGAPQDB_wr : coverpoint RAMPUPGAPQDB.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCRAMP_rd_cg";
        RAMPDNNDLINDEX_rd : coverpoint RAMPDNNDLINDEX.value[2:0];
        RAMPDNGAPQDB_rd : coverpoint RAMPDNGAPQDB.value[7:0];
        RAMPUPNDLINDEX_rd : coverpoint RAMPUPNDLINDEX.value[2:0];
        RAMPUPGAPQDB_rd : coverpoint RAMPUPGAPQDB.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCRAMP");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCSTABDIS
//--------------------------------------------------------------------
class RWNXAGCSTABDIS extends uvm_reg;
    `uvm_object_utils(RWNXAGCSTABDIS)
    rand uvm_reg_field ADCPOWDISNDL;
    rand uvm_reg_field ADCPOWDISTHRDBV;
    rand uvm_reg_field PLATNDLINDEX;
    rand uvm_reg_field PLATDPQDB;

    //---build------------------------------------------------------------
    virtual function void build();
        ADCPOWDISNDL = uvm_reg_field::type_id::create("ADCPOWDISNDL");
        ADCPOWDISTHRDBV = uvm_reg_field::type_id::create("ADCPOWDISTHRDBV");
        PLATNDLINDEX = uvm_reg_field::type_id::create("PLATNDLINDEX");
        PLATDPQDB = uvm_reg_field::type_id::create("PLATDPQDB");

        ADCPOWDISNDL.configure(this, 4, 24, "RW", 1, 'b1000, 1, 1, 1);
        ADCPOWDISTHRDBV.configure(this, 7, 16, "RW", 1, 'b1010100, 1, 1, 1);
        PLATNDLINDEX.configure(this, 3, 8, "RW", 1, 'b11, 1, 1, 1);
        PLATDPQDB.configure(this, 5, 0, "RW", 1, 'b1000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCSTABDIS_wr_cg";
        ADCPOWDISNDL_wr : coverpoint ADCPOWDISNDL.value[3:0];
        ADCPOWDISTHRDBV_wr : coverpoint ADCPOWDISTHRDBV.value[6:0];
        PLATNDLINDEX_wr : coverpoint PLATNDLINDEX.value[2:0];
        PLATDPQDB_wr : coverpoint PLATDPQDB.value[4:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCSTABDIS_rd_cg";
        ADCPOWDISNDL_rd : coverpoint ADCPOWDISNDL.value[3:0];
        ADCPOWDISTHRDBV_rd : coverpoint ADCPOWDISTHRDBV.value[6:0];
        PLATNDLINDEX_rd : coverpoint PLATNDLINDEX.value[2:0];
        PLATDPQDB_rd : coverpoint PLATDPQDB.value[4:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCSTABDIS");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCDCCOMP0
//--------------------------------------------------------------------
class RWNXAGCDCCOMP0 extends uvm_reg;
    `uvm_object_utils(RWNXAGCDCCOMP0)
    rand uvm_reg_field DCDSSSTYPE;
    rand uvm_reg_field DCCENTEREDTYPE;
    rand uvm_reg_field DCAGC20TYPE;
    rand uvm_reg_field DCADCTYPE;
    rand uvm_reg_field DCADCHOLDTIME50NS;
    rand uvm_reg_field DCADCZEROTIME50NS;

    //---build------------------------------------------------------------
    virtual function void build();
        DCDSSSTYPE = uvm_reg_field::type_id::create("DCDSSSTYPE");
        DCCENTEREDTYPE = uvm_reg_field::type_id::create("DCCENTEREDTYPE");
        DCAGC20TYPE = uvm_reg_field::type_id::create("DCAGC20TYPE");
        DCADCTYPE = uvm_reg_field::type_id::create("DCADCTYPE");
        DCADCHOLDTIME50NS = uvm_reg_field::type_id::create("DCADCHOLDTIME50NS");
        DCADCZEROTIME50NS = uvm_reg_field::type_id::create("DCADCZEROTIME50NS");

        DCDSSSTYPE.configure(this, 2, 28, "RW", 1, 'b1, 1, 1, 1);
        DCCENTEREDTYPE.configure(this, 2, 24, "RW", 1, 'b11, 1, 1, 1);
        DCAGC20TYPE.configure(this, 2, 20, "RW", 1, 'b1, 1, 1, 1);
        DCADCTYPE.configure(this, 2, 16, "RW", 1, 'b1, 1, 1, 1);
        DCADCHOLDTIME50NS.configure(this, 7, 8, "RW", 1, 'b010100, 1, 1, 1);
        DCADCZEROTIME50NS.configure(this, 7, 0, "RW", 1, 'b000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDCCOMP0_wr_cg";
        DCDSSSTYPE_wr : coverpoint DCDSSSTYPE.value[1:0];
        DCCENTEREDTYPE_wr : coverpoint DCCENTEREDTYPE.value[1:0];
        DCAGC20TYPE_wr : coverpoint DCAGC20TYPE.value[1:0];
        DCADCTYPE_wr : coverpoint DCADCTYPE.value[1:0];
        DCADCHOLDTIME50NS_wr : coverpoint DCADCHOLDTIME50NS.value[6:0];
        DCADCZEROTIME50NS_wr : coverpoint DCADCZEROTIME50NS.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDCCOMP0_rd_cg";
        DCDSSSTYPE_rd : coverpoint DCDSSSTYPE.value[1:0];
        DCCENTEREDTYPE_rd : coverpoint DCCENTEREDTYPE.value[1:0];
        DCAGC20TYPE_rd : coverpoint DCAGC20TYPE.value[1:0];
        DCADCTYPE_rd : coverpoint DCADCTYPE.value[1:0];
        DCADCHOLDTIME50NS_rd : coverpoint DCADCHOLDTIME50NS.value[6:0];
        DCADCZEROTIME50NS_rd : coverpoint DCADCZEROTIME50NS.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCDCCOMP0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCDCCOMP1
//--------------------------------------------------------------------
class RWNXAGCDCCOMP1 extends uvm_reg;
    `uvm_object_utils(RWNXAGCDCCOMP1)
    rand uvm_reg_field DCCENTEREDHOLDTIME50NS;
    rand uvm_reg_field DCCENTEREDZEROTIME50NS;
    rand uvm_reg_field DCAGC20HOLDTIME50NS;
    rand uvm_reg_field DCAGC20ZEROTIME50NS;

    //---build------------------------------------------------------------
    virtual function void build();
        DCCENTEREDHOLDTIME50NS = uvm_reg_field::type_id::create("DCCENTEREDHOLDTIME50NS");
        DCCENTEREDZEROTIME50NS = uvm_reg_field::type_id::create("DCCENTEREDZEROTIME50NS");
        DCAGC20HOLDTIME50NS = uvm_reg_field::type_id::create("DCAGC20HOLDTIME50NS");
        DCAGC20ZEROTIME50NS = uvm_reg_field::type_id::create("DCAGC20ZEROTIME50NS");

        DCCENTEREDHOLDTIME50NS.configure(this, 7, 24, "RW", 1, 'b001000, 1, 1, 1);
        DCCENTEREDZEROTIME50NS.configure(this, 7, 16, "RW", 1, 'b000010, 1, 1, 1);
        DCAGC20HOLDTIME50NS.configure(this, 7, 8, "RW", 1, 'b000000, 1, 1, 1);
        DCAGC20ZEROTIME50NS.configure(this, 7, 0, "RW", 1, 'b000010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDCCOMP1_wr_cg";
        DCCENTEREDHOLDTIME50NS_wr : coverpoint DCCENTEREDHOLDTIME50NS.value[6:0];
        DCCENTEREDZEROTIME50NS_wr : coverpoint DCCENTEREDZEROTIME50NS.value[6:0];
        DCAGC20HOLDTIME50NS_wr : coverpoint DCAGC20HOLDTIME50NS.value[6:0];
        DCAGC20ZEROTIME50NS_wr : coverpoint DCAGC20ZEROTIME50NS.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDCCOMP1_rd_cg";
        DCCENTEREDHOLDTIME50NS_rd : coverpoint DCCENTEREDHOLDTIME50NS.value[6:0];
        DCCENTEREDZEROTIME50NS_rd : coverpoint DCCENTEREDZEROTIME50NS.value[6:0];
        DCAGC20HOLDTIME50NS_rd : coverpoint DCAGC20HOLDTIME50NS.value[6:0];
        DCAGC20ZEROTIME50NS_rd : coverpoint DCAGC20ZEROTIME50NS.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCDCCOMP1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCDCCOMP2
//--------------------------------------------------------------------
class RWNXAGCDCCOMP2 extends uvm_reg;
    `uvm_object_utils(RWNXAGCDCCOMP2)
    rand uvm_reg_field DCDSSSHOLDTIME50NS;
    rand uvm_reg_field DCDSSSZEROTIME50NS;
    rand uvm_reg_field DELDCSTABLECC;

    //---build------------------------------------------------------------
    virtual function void build();
        DCDSSSHOLDTIME50NS = uvm_reg_field::type_id::create("DCDSSSHOLDTIME50NS");
        DCDSSSZEROTIME50NS = uvm_reg_field::type_id::create("DCDSSSZEROTIME50NS");
        DELDCSTABLECC = uvm_reg_field::type_id::create("DELDCSTABLECC");

        DCDSSSHOLDTIME50NS.configure(this, 7, 24, "RW", 1, 'b000000, 1, 1, 1);
        DCDSSSZEROTIME50NS.configure(this, 7, 16, "RW", 1, 'b000010, 1, 1, 1);
        DELDCSTABLECC.configure(this, 7, 0, "RW", 1, 'b000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDCCOMP2_wr_cg";
        DCDSSSHOLDTIME50NS_wr : coverpoint DCDSSSHOLDTIME50NS.value[6:0];
        DCDSSSZEROTIME50NS_wr : coverpoint DCDSSSZEROTIME50NS.value[6:0];
        DELDCSTABLECC_wr : coverpoint DELDCSTABLECC.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDCCOMP2_rd_cg";
        DCDSSSHOLDTIME50NS_rd : coverpoint DCDSSSHOLDTIME50NS.value[6:0];
        DCDSSSZEROTIME50NS_rd : coverpoint DCDSSSZEROTIME50NS.value[6:0];
        DELDCSTABLECC_rd : coverpoint DELDCSTABLECC.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCDCCOMP2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCEVT0
//--------------------------------------------------------------------
class RWNXAGCEVT0 extends uvm_reg;
    `uvm_object_utils(RWNXAGCEVT0)
    rand uvm_reg_field EVT0OP1;
    rand uvm_reg_field EVT0OP2;
    rand uvm_reg_field EVT0OP3;
    rand uvm_reg_field EVT0PATHCOMB;
    rand uvm_reg_field EVT0OPCOMB;
    rand uvm_reg_field EVT0TGTADD;

    //---build------------------------------------------------------------
    virtual function void build();
        EVT0OP1 = uvm_reg_field::type_id::create("EVT0OP1");
        EVT0OP2 = uvm_reg_field::type_id::create("EVT0OP2");
        EVT0OP3 = uvm_reg_field::type_id::create("EVT0OP3");
        EVT0PATHCOMB = uvm_reg_field::type_id::create("EVT0PATHCOMB");
        EVT0OPCOMB = uvm_reg_field::type_id::create("EVT0OPCOMB");
        EVT0TGTADD = uvm_reg_field::type_id::create("EVT0TGTADD");

        EVT0OP1.configure(this, 6, 26, "RW", 1, 'b10100, 1, 1, 1);
        EVT0OP2.configure(this, 6, 20, "RW", 1, 'b10000, 1, 1, 1);
        EVT0OP3.configure(this, 6, 14, "RW", 1, 'b00001, 1, 1, 1);
        EVT0PATHCOMB.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        EVT0OPCOMB.configure(this, 3, 10, "RW", 1, 'b01, 1, 1, 1);
        EVT0TGTADD.configure(this, 9, 0, "RW", 1, 'b00000010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCEVT0_wr_cg";
        EVT0OP1_wr : coverpoint EVT0OP1.value[5:0];
        EVT0OP2_wr : coverpoint EVT0OP2.value[5:0];
        EVT0OP3_wr : coverpoint EVT0OP3.value[5:0];
        EVT0PATHCOMB_wr : coverpoint EVT0PATHCOMB.value[0:0];
        EVT0OPCOMB_wr : coverpoint EVT0OPCOMB.value[2:0];
        EVT0TGTADD_wr : coverpoint EVT0TGTADD.value[8:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCEVT0_rd_cg";
        EVT0OP1_rd : coverpoint EVT0OP1.value[5:0];
        EVT0OP2_rd : coverpoint EVT0OP2.value[5:0];
        EVT0OP3_rd : coverpoint EVT0OP3.value[5:0];
        EVT0PATHCOMB_rd : coverpoint EVT0PATHCOMB.value[0:0];
        EVT0OPCOMB_rd : coverpoint EVT0OPCOMB.value[2:0];
        EVT0TGTADD_rd : coverpoint EVT0TGTADD.value[8:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCEVT0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCEVT1
//--------------------------------------------------------------------
class RWNXAGCEVT1 extends uvm_reg;
    `uvm_object_utils(RWNXAGCEVT1)
    rand uvm_reg_field EVT1OP1;
    rand uvm_reg_field EVT1OP2;
    rand uvm_reg_field EVT1OP3;
    rand uvm_reg_field EVT1PATHCOMB;
    rand uvm_reg_field EVT1OPCOMB;
    rand uvm_reg_field EVT1TGTADD;

    //---build------------------------------------------------------------
    virtual function void build();
        EVT1OP1 = uvm_reg_field::type_id::create("EVT1OP1");
        EVT1OP2 = uvm_reg_field::type_id::create("EVT1OP2");
        EVT1OP3 = uvm_reg_field::type_id::create("EVT1OP3");
        EVT1PATHCOMB = uvm_reg_field::type_id::create("EVT1PATHCOMB");
        EVT1OPCOMB = uvm_reg_field::type_id::create("EVT1OPCOMB");
        EVT1TGTADD = uvm_reg_field::type_id::create("EVT1TGTADD");

        EVT1OP1.configure(this, 6, 26, "RW", 1, 'b10101, 1, 1, 1);
        EVT1OP2.configure(this, 6, 20, "RW", 1, 'b10111, 1, 1, 1);
        EVT1OP3.configure(this, 6, 14, "RW", 1, 'b01111, 1, 1, 1);
        EVT1PATHCOMB.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        EVT1OPCOMB.configure(this, 3, 10, "RW", 1, 'b10, 1, 1, 1);
        EVT1TGTADD.configure(this, 9, 0, "RW", 1, 'b00000101, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCEVT1_wr_cg";
        EVT1OP1_wr : coverpoint EVT1OP1.value[5:0];
        EVT1OP2_wr : coverpoint EVT1OP2.value[5:0];
        EVT1OP3_wr : coverpoint EVT1OP3.value[5:0];
        EVT1PATHCOMB_wr : coverpoint EVT1PATHCOMB.value[0:0];
        EVT1OPCOMB_wr : coverpoint EVT1OPCOMB.value[2:0];
        EVT1TGTADD_wr : coverpoint EVT1TGTADD.value[8:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCEVT1_rd_cg";
        EVT1OP1_rd : coverpoint EVT1OP1.value[5:0];
        EVT1OP2_rd : coverpoint EVT1OP2.value[5:0];
        EVT1OP3_rd : coverpoint EVT1OP3.value[5:0];
        EVT1PATHCOMB_rd : coverpoint EVT1PATHCOMB.value[0:0];
        EVT1OPCOMB_rd : coverpoint EVT1OPCOMB.value[2:0];
        EVT1TGTADD_rd : coverpoint EVT1TGTADD.value[8:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCEVT1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCEVT2
//--------------------------------------------------------------------
class RWNXAGCEVT2 extends uvm_reg;
    `uvm_object_utils(RWNXAGCEVT2)
    rand uvm_reg_field EVT2OP1;
    rand uvm_reg_field EVT2OP2;
    rand uvm_reg_field EVT2OP3;
    rand uvm_reg_field EVT2PATHCOMB;
    rand uvm_reg_field EVT2OPCOMB;
    rand uvm_reg_field EVT2TGTADD;

    //---build------------------------------------------------------------
    virtual function void build();
        EVT2OP1 = uvm_reg_field::type_id::create("EVT2OP1");
        EVT2OP2 = uvm_reg_field::type_id::create("EVT2OP2");
        EVT2OP3 = uvm_reg_field::type_id::create("EVT2OP3");
        EVT2PATHCOMB = uvm_reg_field::type_id::create("EVT2PATHCOMB");
        EVT2OPCOMB = uvm_reg_field::type_id::create("EVT2OPCOMB");
        EVT2TGTADD = uvm_reg_field::type_id::create("EVT2TGTADD");

        EVT2OP1.configure(this, 6, 26, "RW", 1, 'b11001, 1, 1, 1);
        EVT2OP2.configure(this, 6, 20, "RW", 1, 'b00000, 1, 1, 1);
        EVT2OP3.configure(this, 6, 14, "RW", 1, 'b01110, 1, 1, 1);
        EVT2PATHCOMB.configure(this, 1, 13, "RW", 1, 'b1, 1, 1, 1);
        EVT2OPCOMB.configure(this, 3, 10, "RW", 1, 'b10, 1, 1, 1);
        EVT2TGTADD.configure(this, 9, 0, "RW", 1, 'b00001000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCEVT2_wr_cg";
        EVT2OP1_wr : coverpoint EVT2OP1.value[5:0];
        EVT2OP2_wr : coverpoint EVT2OP2.value[5:0];
        EVT2OP3_wr : coverpoint EVT2OP3.value[5:0];
        EVT2PATHCOMB_wr : coverpoint EVT2PATHCOMB.value[0:0];
        EVT2OPCOMB_wr : coverpoint EVT2OPCOMB.value[2:0];
        EVT2TGTADD_wr : coverpoint EVT2TGTADD.value[8:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCEVT2_rd_cg";
        EVT2OP1_rd : coverpoint EVT2OP1.value[5:0];
        EVT2OP2_rd : coverpoint EVT2OP2.value[5:0];
        EVT2OP3_rd : coverpoint EVT2OP3.value[5:0];
        EVT2PATHCOMB_rd : coverpoint EVT2PATHCOMB.value[0:0];
        EVT2OPCOMB_rd : coverpoint EVT2OPCOMB.value[2:0];
        EVT2TGTADD_rd : coverpoint EVT2TGTADD.value[8:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCEVT2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCEVT3
//--------------------------------------------------------------------
class RWNXAGCEVT3 extends uvm_reg;
    `uvm_object_utils(RWNXAGCEVT3)
    rand uvm_reg_field EVT3OP1;
    rand uvm_reg_field EVT3OP2;
    rand uvm_reg_field EVT3OP3;
    rand uvm_reg_field EVT3PATHCOMB;
    rand uvm_reg_field EVT3OPCOMB;
    rand uvm_reg_field EVT3TGTADD;

    //---build------------------------------------------------------------
    virtual function void build();
        EVT3OP1 = uvm_reg_field::type_id::create("EVT3OP1");
        EVT3OP2 = uvm_reg_field::type_id::create("EVT3OP2");
        EVT3OP3 = uvm_reg_field::type_id::create("EVT3OP3");
        EVT3PATHCOMB = uvm_reg_field::type_id::create("EVT3PATHCOMB");
        EVT3OPCOMB = uvm_reg_field::type_id::create("EVT3OPCOMB");
        EVT3TGTADD = uvm_reg_field::type_id::create("EVT3TGTADD");

        EVT3OP1.configure(this, 6, 26, "RW", 1, 'b00001, 1, 1, 1);
        EVT3OP2.configure(this, 6, 20, "RW", 1, 'b01111, 1, 1, 1);
        EVT3OP3.configure(this, 6, 14, "RW", 1, 'b111111, 1, 1, 1);
        EVT3PATHCOMB.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        EVT3OPCOMB.configure(this, 3, 10, "RW", 1, 'b01, 1, 1, 1);
        EVT3TGTADD.configure(this, 9, 0, "RW", 1, 'b00001011, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCEVT3_wr_cg";
        EVT3OP1_wr : coverpoint EVT3OP1.value[5:0];
        EVT3OP2_wr : coverpoint EVT3OP2.value[5:0];
        EVT3OP3_wr : coverpoint EVT3OP3.value[5:0];
        EVT3PATHCOMB_wr : coverpoint EVT3PATHCOMB.value[0:0];
        EVT3OPCOMB_wr : coverpoint EVT3OPCOMB.value[2:0];
        EVT3TGTADD_wr : coverpoint EVT3TGTADD.value[8:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCEVT3_rd_cg";
        EVT3OP1_rd : coverpoint EVT3OP1.value[5:0];
        EVT3OP2_rd : coverpoint EVT3OP2.value[5:0];
        EVT3OP3_rd : coverpoint EVT3OP3.value[5:0];
        EVT3PATHCOMB_rd : coverpoint EVT3PATHCOMB.value[0:0];
        EVT3OPCOMB_rd : coverpoint EVT3OPCOMB.value[2:0];
        EVT3TGTADD_rd : coverpoint EVT3TGTADD.value[8:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCEVT3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCNTL
//--------------------------------------------------------------------
class RWNXAGCCNTL extends uvm_reg;
    `uvm_object_utils(RWNXAGCCNTL)
    rand uvm_reg_field HTSTFGAINEN;
    rand uvm_reg_field AGCFSMRESET;
    rand uvm_reg_field RADARDETEN;
    rand uvm_reg_field RIFSDETEN;
    rand uvm_reg_field DSSSONLY;
    rand uvm_reg_field OFDMONLY;
    rand uvm_reg_field GPSTATUS;
    rand uvm_reg_field COMBPATHSEL;

    //---build------------------------------------------------------------
    virtual function void build();
        HTSTFGAINEN = uvm_reg_field::type_id::create("HTSTFGAINEN");
        AGCFSMRESET = uvm_reg_field::type_id::create("AGCFSMRESET");
        RADARDETEN = uvm_reg_field::type_id::create("RADARDETEN");
        RIFSDETEN = uvm_reg_field::type_id::create("RIFSDETEN");
        DSSSONLY = uvm_reg_field::type_id::create("DSSSONLY");
        OFDMONLY = uvm_reg_field::type_id::create("OFDMONLY");
        GPSTATUS = uvm_reg_field::type_id::create("GPSTATUS");
        COMBPATHSEL = uvm_reg_field::type_id::create("COMBPATHSEL");

        HTSTFGAINEN.configure(this, 1, 16, "RW", 1, 'b1, 1, 1, 1);
        AGCFSMRESET.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        RADARDETEN.configure(this, 1, 11, "RW", 1, 'b0, 1, 1, 1);
        RIFSDETEN.configure(this, 1, 10, "RW", 1, 'b1, 1, 1, 1);
        DSSSONLY.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        OFDMONLY.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        GPSTATUS.configure(this, 4, 4, "RW", 1, 'b000, 1, 1, 1);
        COMBPATHSEL.configure(this, 2, 0, "RW", 1, 'b11, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCNTL_wr_cg";
        HTSTFGAINEN_wr : coverpoint HTSTFGAINEN.value[0:0];
        AGCFSMRESET_wr : coverpoint AGCFSMRESET.value[0:0];
        RADARDETEN_wr : coverpoint RADARDETEN.value[0:0];
        RIFSDETEN_wr : coverpoint RIFSDETEN.value[0:0];
        DSSSONLY_wr : coverpoint DSSSONLY.value[0:0];
        OFDMONLY_wr : coverpoint OFDMONLY.value[0:0];
        GPSTATUS_wr : coverpoint GPSTATUS.value[3:0];
        COMBPATHSEL_wr : coverpoint COMBPATHSEL.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCNTL_rd_cg";
        HTSTFGAINEN_rd : coverpoint HTSTFGAINEN.value[0:0];
        AGCFSMRESET_rd : coverpoint AGCFSMRESET.value[0:0];
        RADARDETEN_rd : coverpoint RADARDETEN.value[0:0];
        RIFSDETEN_rd : coverpoint RIFSDETEN.value[0:0];
        DSSSONLY_rd : coverpoint DSSSONLY.value[0:0];
        OFDMONLY_rd : coverpoint OFDMONLY.value[0:0];
        GPSTATUS_rd : coverpoint GPSTATUS.value[3:0];
        COMBPATHSEL_rd : coverpoint COMBPATHSEL.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCDSP0
//--------------------------------------------------------------------
class RWNXAGCDSP0 extends uvm_reg;
    `uvm_object_utils(RWNXAGCDSP0)
    rand uvm_reg_field NBITADC;
    rand uvm_reg_field VPEAKADCQDBV;
    rand uvm_reg_field ADCPOWMINDBV;
    rand uvm_reg_field ADCPOWBIASQDBV;

    //---build------------------------------------------------------------
    virtual function void build();
        NBITADC = uvm_reg_field::type_id::create("NBITADC");
        VPEAKADCQDBV = uvm_reg_field::type_id::create("VPEAKADCQDBV");
        ADCPOWMINDBV = uvm_reg_field::type_id::create("ADCPOWMINDBV");
        ADCPOWBIASQDBV = uvm_reg_field::type_id::create("ADCPOWBIASQDBV");

        NBITADC.configure(this, 4, 24, "RW", 1, 'b1100, 1, 1, 1);
        VPEAKADCQDBV.configure(this, 8, 16, "RW", 1, 'b11101000, 1, 1, 1);
        ADCPOWMINDBV.configure(this, 8, 8, "RW", 1, 'b10110101, 1, 1, 1);
        ADCPOWBIASQDBV.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDSP0_wr_cg";
        NBITADC_wr : coverpoint NBITADC.value[3:0];
        VPEAKADCQDBV_wr : coverpoint VPEAKADCQDBV.value[7:0];
        ADCPOWMINDBV_wr : coverpoint ADCPOWMINDBV.value[7:0];
        ADCPOWBIASQDBV_wr : coverpoint ADCPOWBIASQDBV.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDSP0_rd_cg";
        NBITADC_rd : coverpoint NBITADC.value[3:0];
        VPEAKADCQDBV_rd : coverpoint VPEAKADCQDBV.value[7:0];
        ADCPOWMINDBV_rd : coverpoint ADCPOWMINDBV.value[7:0];
        ADCPOWBIASQDBV_rd : coverpoint ADCPOWBIASQDBV.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCDSP0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCDSP1
//--------------------------------------------------------------------
class RWNXAGCDSP1 extends uvm_reg;
    `uvm_object_utils(RWNXAGCDSP1)
    rand uvm_reg_field ADCPOWMINDBM;
    rand uvm_reg_field ADCPOWBIASQDBM;

    //---build------------------------------------------------------------
    virtual function void build();
        ADCPOWMINDBM = uvm_reg_field::type_id::create("ADCPOWMINDBM");
        ADCPOWBIASQDBM = uvm_reg_field::type_id::create("ADCPOWBIASQDBM");

        ADCPOWMINDBM.configure(this, 8, 8, "RW", 1, 'b10011100, 1, 1, 1);
        ADCPOWBIASQDBM.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDSP1_wr_cg";
        ADCPOWMINDBM_wr : coverpoint ADCPOWMINDBM.value[7:0];
        ADCPOWBIASQDBM_wr : coverpoint ADCPOWBIASQDBM.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDSP1_rd_cg";
        ADCPOWMINDBM_rd : coverpoint ADCPOWMINDBM.value[7:0];
        ADCPOWBIASQDBM_rd : coverpoint ADCPOWBIASQDBM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCDSP1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCDSP2
//--------------------------------------------------------------------
class RWNXAGCDSP2 extends uvm_reg;
    `uvm_object_utils(RWNXAGCDSP2)
    rand uvm_reg_field INBDPOW40SBIASQDB;
    rand uvm_reg_field INBDPOW20SBIASQDB;
    rand uvm_reg_field INBDPOW20PBIASQDB;

    //---build------------------------------------------------------------
    virtual function void build();
        INBDPOW40SBIASQDB = uvm_reg_field::type_id::create("INBDPOW40SBIASQDB");
        INBDPOW20SBIASQDB = uvm_reg_field::type_id::create("INBDPOW20SBIASQDB");
        INBDPOW20PBIASQDB = uvm_reg_field::type_id::create("INBDPOW20PBIASQDB");

        INBDPOW40SBIASQDB.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        INBDPOW20SBIASQDB.configure(this, 8, 8, "RW", 1, 'b0000000, 1, 1, 1);
        INBDPOW20PBIASQDB.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDSP2_wr_cg";
        INBDPOW40SBIASQDB_wr : coverpoint INBDPOW40SBIASQDB.value[7:0];
        INBDPOW20SBIASQDB_wr : coverpoint INBDPOW20SBIASQDB.value[7:0];
        INBDPOW20PBIASQDB_wr : coverpoint INBDPOW20PBIASQDB.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDSP2_rd_cg";
        INBDPOW40SBIASQDB_rd : coverpoint INBDPOW40SBIASQDB.value[7:0];
        INBDPOW20SBIASQDB_rd : coverpoint INBDPOW20SBIASQDB.value[7:0];
        INBDPOW20PBIASQDB_rd : coverpoint INBDPOW20PBIASQDB.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCDSP2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCDSP3
//--------------------------------------------------------------------
class RWNXAGCDSP3 extends uvm_reg;
    `uvm_object_utils(RWNXAGCDSP3)
    rand uvm_reg_field INBDPOWMINDBV;
    rand uvm_reg_field INBDRND;
    rand uvm_reg_field INBDPOWMINDBM;

    //---build------------------------------------------------------------
    virtual function void build();
        INBDPOWMINDBV = uvm_reg_field::type_id::create("INBDPOWMINDBV");
        INBDRND = uvm_reg_field::type_id::create("INBDRND");
        INBDPOWMINDBM = uvm_reg_field::type_id::create("INBDPOWMINDBM");

        INBDPOWMINDBV.configure(this, 8, 20, "RW", 1, 'b10111111, 1, 1, 1);
        INBDRND.configure(this, 2, 16, "RW", 1, 'b11, 1, 1, 1);
        INBDPOWMINDBM.configure(this, 8, 0, "RW", 1, 'b10011100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDSP3_wr_cg";
        INBDPOWMINDBV_wr : coverpoint INBDPOWMINDBV.value[7:0];
        INBDRND_wr : coverpoint INBDRND.value[1:0];
        INBDPOWMINDBM_wr : coverpoint INBDPOWMINDBM.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDSP3_rd_cg";
        INBDPOWMINDBV_rd : coverpoint INBDPOWMINDBV.value[7:0];
        INBDRND_rd : coverpoint INBDRND.value[1:0];
        INBDPOWMINDBM_rd : coverpoint INBDPOWMINDBM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCDSP3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCDSP4
//--------------------------------------------------------------------
class RWNXAGCDSP4 extends uvm_reg;
    `uvm_object_utils(RWNXAGCDSP4)
    rand uvm_reg_field FE40GAIN;
    rand uvm_reg_field FE20GAIN;

    //---build------------------------------------------------------------
    virtual function void build();
        FE40GAIN = uvm_reg_field::type_id::create("FE40GAIN");
        FE20GAIN = uvm_reg_field::type_id::create("FE20GAIN");

        FE40GAIN.configure(this, 8, 8, "RW", 1, 'b0000010, 1, 1, 1);
        FE20GAIN.configure(this, 8, 0, "RW", 1, 'b0000010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDSP4_wr_cg";
        FE40GAIN_wr : coverpoint FE40GAIN.value[7:0];
        FE20GAIN_wr : coverpoint FE20GAIN.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDSP4_rd_cg";
        FE40GAIN_rd : coverpoint FE40GAIN.value[7:0];
        FE20GAIN_rd : coverpoint FE20GAIN.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCDSP4");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCCA0
//--------------------------------------------------------------------
class RWNXAGCCCA0 extends uvm_reg;
    `uvm_object_utils(RWNXAGCCCA0)
    rand uvm_reg_field DELCCARAMPDNTAP;
    rand uvm_reg_field DELCCARAMPUPTAP;
    rand uvm_reg_field CCADETRAMPDN;
    rand uvm_reg_field CCADETRAMPUP;

    //---build------------------------------------------------------------
    virtual function void build();
        DELCCARAMPDNTAP = uvm_reg_field::type_id::create("DELCCARAMPDNTAP");
        DELCCARAMPUPTAP = uvm_reg_field::type_id::create("DELCCARAMPUPTAP");
        CCADETRAMPDN = uvm_reg_field::type_id::create("CCADETRAMPDN");
        CCADETRAMPUP = uvm_reg_field::type_id::create("CCADETRAMPUP");

        DELCCARAMPDNTAP.configure(this, 3, 20, "RW", 1, 'b101, 1, 1, 1);
        DELCCARAMPUPTAP.configure(this, 3, 16, "RW", 1, 'b101, 1, 1, 1);
        CCADETRAMPDN.configure(this, 6, 8, "RW", 1, 'b01001, 1, 1, 1);
        CCADETRAMPUP.configure(this, 6, 0, "RW", 1, 'b01001, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCA0_wr_cg";
        DELCCARAMPDNTAP_wr : coverpoint DELCCARAMPDNTAP.value[2:0];
        DELCCARAMPUPTAP_wr : coverpoint DELCCARAMPUPTAP.value[2:0];
        CCADETRAMPDN_wr : coverpoint CCADETRAMPDN.value[5:0];
        CCADETRAMPUP_wr : coverpoint CCADETRAMPUP.value[5:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCA0_rd_cg";
        DELCCARAMPDNTAP_rd : coverpoint DELCCARAMPDNTAP.value[2:0];
        DELCCARAMPUPTAP_rd : coverpoint DELCCARAMPUPTAP.value[2:0];
        CCADETRAMPDN_rd : coverpoint CCADETRAMPDN.value[5:0];
        CCADETRAMPUP_rd : coverpoint CCADETRAMPUP.value[5:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCCA0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCCA1
//--------------------------------------------------------------------
class RWNXAGCCCA1 extends uvm_reg;
    `uvm_object_utils(RWNXAGCCCA1)
    rand uvm_reg_field INBDCCA20PPOWMINDBM;
    rand uvm_reg_field CCA20PFALLTHRDBM;
    rand uvm_reg_field DISCCAEN;
    rand uvm_reg_field SATCCAEN;
    rand uvm_reg_field CCA20PRISETHRDBM;

    //---build------------------------------------------------------------
    virtual function void build();
        INBDCCA20PPOWMINDBM = uvm_reg_field::type_id::create("INBDCCA20PPOWMINDBM");
        CCA20PFALLTHRDBM = uvm_reg_field::type_id::create("CCA20PFALLTHRDBM");
        DISCCAEN = uvm_reg_field::type_id::create("DISCCAEN");
        SATCCAEN = uvm_reg_field::type_id::create("SATCCAEN");
        CCA20PRISETHRDBM = uvm_reg_field::type_id::create("CCA20PRISETHRDBM");

        INBDCCA20PPOWMINDBM.configure(this, 9, 20, "RW", 1, 'b110110101, 1, 1, 1);
        CCA20PFALLTHRDBM.configure(this, 8, 12, "RW", 1, 'b10111111, 1, 1, 1);
        DISCCAEN.configure(this, 1, 9, "RW", 1, 'b1, 1, 1, 1);
        SATCCAEN.configure(this, 1, 8, "RW", 1, 'b1, 1, 1, 1);
        CCA20PRISETHRDBM.configure(this, 8, 0, "RW", 1, 'b11000010, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCA1_wr_cg";
        INBDCCA20PPOWMINDBM_wr : coverpoint INBDCCA20PPOWMINDBM.value[8:0];
        CCA20PFALLTHRDBM_wr : coverpoint CCA20PFALLTHRDBM.value[7:0];
        DISCCAEN_wr : coverpoint DISCCAEN.value[0:0];
        SATCCAEN_wr : coverpoint SATCCAEN.value[0:0];
        CCA20PRISETHRDBM_wr : coverpoint CCA20PRISETHRDBM.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCA1_rd_cg";
        INBDCCA20PPOWMINDBM_rd : coverpoint INBDCCA20PPOWMINDBM.value[8:0];
        CCA20PFALLTHRDBM_rd : coverpoint CCA20PFALLTHRDBM.value[7:0];
        DISCCAEN_rd : coverpoint DISCCAEN.value[0:0];
        SATCCAEN_rd : coverpoint SATCCAEN.value[0:0];
        CCA20PRISETHRDBM_rd : coverpoint CCA20PRISETHRDBM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCCA1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCCACTRL
//--------------------------------------------------------------------
class RWNXAGCCCACTRL extends uvm_reg;
    `uvm_object_utils(RWNXAGCCCACTRL)
    rand uvm_reg_field CCAFLAG3CTRL;
    rand uvm_reg_field CCAFLAG2CTRL;
    rand uvm_reg_field CCAFLAG1CTRL;
    rand uvm_reg_field CCAFLAG0CTRL;
    rand uvm_reg_field ANTSELCCA40S;
    rand uvm_reg_field ANTSELCCA20S;
    rand uvm_reg_field CCADEMOD;
    rand uvm_reg_field CCACSEN;
    rand uvm_reg_field CCARAMPUDEN;
    rand uvm_reg_field CCAENERGYEN;

    //---build------------------------------------------------------------
    virtual function void build();
        CCAFLAG3CTRL = uvm_reg_field::type_id::create("CCAFLAG3CTRL");
        CCAFLAG2CTRL = uvm_reg_field::type_id::create("CCAFLAG2CTRL");
        CCAFLAG1CTRL = uvm_reg_field::type_id::create("CCAFLAG1CTRL");
        CCAFLAG0CTRL = uvm_reg_field::type_id::create("CCAFLAG0CTRL");
        ANTSELCCA40S = uvm_reg_field::type_id::create("ANTSELCCA40S");
        ANTSELCCA20S = uvm_reg_field::type_id::create("ANTSELCCA20S");
        CCADEMOD = uvm_reg_field::type_id::create("CCADEMOD");
        CCACSEN = uvm_reg_field::type_id::create("CCACSEN");
        CCARAMPUDEN = uvm_reg_field::type_id::create("CCARAMPUDEN");
        CCAENERGYEN = uvm_reg_field::type_id::create("CCAENERGYEN");

        CCAFLAG3CTRL.configure(this, 4, 28, "RW", 1, 'b1010, 1, 1, 1);
        CCAFLAG2CTRL.configure(this, 4, 24, "RW", 1, 'b1010, 1, 1, 1);
        CCAFLAG1CTRL.configure(this, 4, 20, "RW", 1, 'b1010, 1, 1, 1);
        CCAFLAG0CTRL.configure(this, 4, 16, "RW", 1, 'b1010, 1, 1, 1);
        ANTSELCCA40S.configure(this, 2, 14, "RW", 1, 'b0, 1, 1, 1);
        ANTSELCCA20S.configure(this, 2, 12, "RW", 1, 'b0, 1, 1, 1);
        CCADEMOD.configure(this, 1, 9, "RW", 1, 'b1, 1, 1, 1);
        CCACSEN.configure(this, 1, 8, "RW", 1, 'b1, 1, 1, 1);
        CCARAMPUDEN.configure(this, 3, 4, "RW", 1, 'b111, 1, 1, 1);
        CCAENERGYEN.configure(this, 3, 0, "RW", 1, 'b111, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCACTRL_wr_cg";
        CCAFLAG3CTRL_wr : coverpoint CCAFLAG3CTRL.value[3:0];
        CCAFLAG2CTRL_wr : coverpoint CCAFLAG2CTRL.value[3:0];
        CCAFLAG1CTRL_wr : coverpoint CCAFLAG1CTRL.value[3:0];
        CCAFLAG0CTRL_wr : coverpoint CCAFLAG0CTRL.value[3:0];
        ANTSELCCA40S_wr : coverpoint ANTSELCCA40S.value[1:0];
        ANTSELCCA20S_wr : coverpoint ANTSELCCA20S.value[1:0];
        CCADEMOD_wr : coverpoint CCADEMOD.value[0:0];
        CCACSEN_wr : coverpoint CCACSEN.value[0:0];
        CCARAMPUDEN_wr : coverpoint CCARAMPUDEN.value[2:0];
        CCAENERGYEN_wr : coverpoint CCAENERGYEN.value[2:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCACTRL_rd_cg";
        CCAFLAG3CTRL_rd : coverpoint CCAFLAG3CTRL.value[3:0];
        CCAFLAG2CTRL_rd : coverpoint CCAFLAG2CTRL.value[3:0];
        CCAFLAG1CTRL_rd : coverpoint CCAFLAG1CTRL.value[3:0];
        CCAFLAG0CTRL_rd : coverpoint CCAFLAG0CTRL.value[3:0];
        ANTSELCCA40S_rd : coverpoint ANTSELCCA40S.value[1:0];
        ANTSELCCA20S_rd : coverpoint ANTSELCCA20S.value[1:0];
        CCADEMOD_rd : coverpoint CCADEMOD.value[0:0];
        CCACSEN_rd : coverpoint CCACSEN.value[0:0];
        CCARAMPUDEN_rd : coverpoint CCARAMPUDEN.value[2:0];
        CCAENERGYEN_rd : coverpoint CCAENERGYEN.value[2:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCCACTRL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCCASTATE0
//--------------------------------------------------------------------
class RWNXAGCCCASTATE0 extends uvm_reg;
    `uvm_object_utils(RWNXAGCCCASTATE0)
    rand uvm_reg_field RXSTATECCA20SSEL;
    rand uvm_reg_field RXSTATECCA20PSEL;

    //---build------------------------------------------------------------
    virtual function void build();
        RXSTATECCA20SSEL = uvm_reg_field::type_id::create("RXSTATECCA20SSEL");
        RXSTATECCA20PSEL = uvm_reg_field::type_id::create("RXSTATECCA20PSEL");

        RXSTATECCA20SSEL.configure(this, 11, 16, "RW", 1, 'b0011010100, 1, 1, 1);
        RXSTATECCA20PSEL.configure(this, 11, 0, "RW", 1, 'b11011111110, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCASTATE0_wr_cg";
        RXSTATECCA20SSEL_wr : coverpoint RXSTATECCA20SSEL.value[10:0];
        RXSTATECCA20PSEL_wr : coverpoint RXSTATECCA20PSEL.value[10:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCASTATE0_rd_cg";
        RXSTATECCA20SSEL_rd : coverpoint RXSTATECCA20SSEL.value[10:0];
        RXSTATECCA20PSEL_rd : coverpoint RXSTATECCA20PSEL.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCCASTATE0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCCASTATE1
//--------------------------------------------------------------------
class RWNXAGCCCASTATE1 extends uvm_reg;
    `uvm_object_utils(RWNXAGCCCASTATE1)
    rand uvm_reg_field RXSTATECCA40SSEL;

    //---build------------------------------------------------------------
    virtual function void build();
        RXSTATECCA40SSEL = uvm_reg_field::type_id::create("RXSTATECCA40SSEL");

        RXSTATECCA40SSEL.configure(this, 11, 0, "RW", 1, 'b0010000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCASTATE1_wr_cg";
        RXSTATECCA40SSEL_wr : coverpoint RXSTATECCA40SSEL.value[10:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCASTATE1_rd_cg";
        RXSTATECCA40SSEL_rd : coverpoint RXSTATECCA40SSEL.value[10:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCCASTATE1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCCATIMEOUT
//--------------------------------------------------------------------
class RWNXAGCCCATIMEOUT extends uvm_reg;
    `uvm_object_utils(RWNXAGCCCATIMEOUT)
    rand uvm_reg_field CCATIMEOUT;

    //---build------------------------------------------------------------
    virtual function void build();
        CCATIMEOUT = uvm_reg_field::type_id::create("CCATIMEOUT");

        CCATIMEOUT.configure(this, 32, 0, "RW", 1, 'b0000000000010001000101110000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCATIMEOUT_wr_cg";
        CCATIMEOUT_wr : coverpoint CCATIMEOUT.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCATIMEOUT_rd_cg";
        CCATIMEOUT_rd : coverpoint CCATIMEOUT.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCCATIMEOUT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCOMP0
//--------------------------------------------------------------------
class RWNXAGCCOMP0 extends uvm_reg;
    `uvm_object_utils(RWNXAGCCOMP0)
    rand uvm_reg_field IDINBDPOWGAPDNQDBM;
    rand uvm_reg_field IDINBDPOWGAPUPQDBM;
    rand uvm_reg_field INBDPOWINFTHRDBM;
    rand uvm_reg_field INBDPOWSUPTHRDBM;

    //---build------------------------------------------------------------
    virtual function void build();
        IDINBDPOWGAPDNQDBM = uvm_reg_field::type_id::create("IDINBDPOWGAPDNQDBM");
        IDINBDPOWGAPUPQDBM = uvm_reg_field::type_id::create("IDINBDPOWGAPUPQDBM");
        INBDPOWINFTHRDBM = uvm_reg_field::type_id::create("INBDPOWINFTHRDBM");
        INBDPOWSUPTHRDBM = uvm_reg_field::type_id::create("INBDPOWSUPTHRDBM");

        IDINBDPOWGAPDNQDBM.configure(this, 8, 24, "RW", 1, 'b0101000, 1, 1, 1);
        IDINBDPOWGAPUPQDBM.configure(this, 8, 16, "RW", 1, 'b0101000, 1, 1, 1);
        INBDPOWINFTHRDBM.configure(this, 8, 8, "RW", 1, 'b10110000, 1, 1, 1);
        INBDPOWSUPTHRDBM.configure(this, 8, 0, "RW", 1, 'b11000100, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCOMP0_wr_cg";
        IDINBDPOWGAPDNQDBM_wr : coverpoint IDINBDPOWGAPDNQDBM.value[7:0];
        IDINBDPOWGAPUPQDBM_wr : coverpoint IDINBDPOWGAPUPQDBM.value[7:0];
        INBDPOWINFTHRDBM_wr : coverpoint INBDPOWINFTHRDBM.value[7:0];
        INBDPOWSUPTHRDBM_wr : coverpoint INBDPOWSUPTHRDBM.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCOMP0_rd_cg";
        IDINBDPOWGAPDNQDBM_rd : coverpoint IDINBDPOWGAPDNQDBM.value[7:0];
        IDINBDPOWGAPUPQDBM_rd : coverpoint IDINBDPOWGAPUPQDBM.value[7:0];
        INBDPOWINFTHRDBM_rd : coverpoint INBDPOWINFTHRDBM.value[7:0];
        INBDPOWSUPTHRDBM_rd : coverpoint INBDPOWSUPTHRDBM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCOMP0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCOMP1
//--------------------------------------------------------------------
class RWNXAGCCOMP1 extends uvm_reg;
    `uvm_object_utils(RWNXAGCCOMP1)
    rand uvm_reg_field ADCPOWINFTHRDBV;
    rand uvm_reg_field ADCPOWSUPTHRDBV;
    rand uvm_reg_field ADCPOWINFTHRDBM;
    rand uvm_reg_field ADCPOWSUPTHRDBM;

    //---build------------------------------------------------------------
    virtual function void build();
        ADCPOWINFTHRDBV = uvm_reg_field::type_id::create("ADCPOWINFTHRDBV");
        ADCPOWSUPTHRDBV = uvm_reg_field::type_id::create("ADCPOWSUPTHRDBV");
        ADCPOWINFTHRDBM = uvm_reg_field::type_id::create("ADCPOWINFTHRDBM");
        ADCPOWSUPTHRDBM = uvm_reg_field::type_id::create("ADCPOWSUPTHRDBM");

        ADCPOWINFTHRDBV.configure(this, 8, 24, "RW", 1, 'b11011101, 1, 1, 1);
        ADCPOWSUPTHRDBV.configure(this, 8, 16, "RW", 1, 'b11011011, 1, 1, 1);
        ADCPOWINFTHRDBM.configure(this, 8, 8, "RW", 1, 'b10111111, 1, 1, 1);
        ADCPOWSUPTHRDBM.configure(this, 8, 0, "RW", 1, 'b10111110, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCOMP1_wr_cg";
        ADCPOWINFTHRDBV_wr : coverpoint ADCPOWINFTHRDBV.value[7:0];
        ADCPOWSUPTHRDBV_wr : coverpoint ADCPOWSUPTHRDBV.value[7:0];
        ADCPOWINFTHRDBM_wr : coverpoint ADCPOWINFTHRDBM.value[7:0];
        ADCPOWSUPTHRDBM_wr : coverpoint ADCPOWSUPTHRDBM.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCOMP1_rd_cg";
        ADCPOWINFTHRDBV_rd : coverpoint ADCPOWINFTHRDBV.value[7:0];
        ADCPOWSUPTHRDBV_rd : coverpoint ADCPOWSUPTHRDBV.value[7:0];
        ADCPOWINFTHRDBM_rd : coverpoint ADCPOWINFTHRDBM.value[7:0];
        ADCPOWSUPTHRDBM_rd : coverpoint ADCPOWSUPTHRDBM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCOMP1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCRADAR
//--------------------------------------------------------------------
class RWNXAGCRADAR extends uvm_reg;
    `uvm_object_utils(RWNXAGCRADAR)
    rand uvm_reg_field ANTSELRADAR;
    rand uvm_reg_field FREQSINGGAP;
    rand uvm_reg_field FREQSING;
    rand uvm_reg_field FOMSINGGAP;
    rand uvm_reg_field FOMSING;

    //---build------------------------------------------------------------
    virtual function void build();
        ANTSELRADAR = uvm_reg_field::type_id::create("ANTSELRADAR");
        FREQSINGGAP = uvm_reg_field::type_id::create("FREQSINGGAP");
        FREQSING = uvm_reg_field::type_id::create("FREQSING");
        FOMSINGGAP = uvm_reg_field::type_id::create("FOMSINGGAP");
        FOMSING = uvm_reg_field::type_id::create("FOMSING");

        ANTSELRADAR.configure(this, 2, 28, "RW", 1, 'b0, 1, 1, 1);
        FREQSINGGAP.configure(this, 4, 24, "RW", 1, 'b000, 1, 1, 1);
        FREQSING.configure(this, 8, 16, "RW", 1, 'b0000000, 1, 1, 1);
        FOMSINGGAP.configure(this, 4, 8, "RW", 1, 'b000, 1, 1, 1);
        FOMSING.configure(this, 8, 0, "RW", 1, 'b0000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCRADAR_wr_cg";
        ANTSELRADAR_wr : coverpoint ANTSELRADAR.value[1:0];
        FREQSINGGAP_wr : coverpoint FREQSINGGAP.value[3:0];
        FREQSING_wr : coverpoint FREQSING.value[7:0];
        FOMSINGGAP_wr : coverpoint FOMSINGGAP.value[3:0];
        FOMSING_wr : coverpoint FOMSING.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCRADAR_rd_cg";
        ANTSELRADAR_rd : coverpoint ANTSELRADAR.value[1:0];
        FREQSINGGAP_rd : coverpoint FREQSINGGAP.value[3:0];
        FREQSING_rd : coverpoint FREQSING.value[7:0];
        FOMSINGGAP_rd : coverpoint FOMSINGGAP.value[3:0];
        FOMSING_rd : coverpoint FOMSING.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCRADAR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCRADARTIM
//--------------------------------------------------------------------
class RWNXAGCRADARTIM extends uvm_reg;
    `uvm_object_utils(RWNXAGCRADARTIM)
    rand uvm_reg_field PULSETIMERCLEAR;
    rand uvm_reg_field PULSEIRQFIFOTHR;
    rand uvm_reg_field PULSEIRQTIMEOUT;

    //---build------------------------------------------------------------
    virtual function void build();
        PULSETIMERCLEAR = uvm_reg_field::type_id::create("PULSETIMERCLEAR");
        PULSEIRQFIFOTHR = uvm_reg_field::type_id::create("PULSEIRQFIFOTHR");
        PULSEIRQTIMEOUT = uvm_reg_field::type_id::create("PULSEIRQTIMEOUT");

        PULSETIMERCLEAR.configure(this, 1, 31, "W1S", 1, 'b0, 1, 1, 1);
        PULSEIRQFIFOTHR.configure(this, 3, 16, "RW", 1, 'b11, 1, 1, 1);
        PULSEIRQTIMEOUT.configure(this, 8, 0, "RW", 1, 'b0001000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCRADARTIM_wr_cg";
        PULSETIMERCLEAR_wr : coverpoint PULSETIMERCLEAR.value[0:0];
        PULSEIRQFIFOTHR_wr : coverpoint PULSEIRQFIFOTHR.value[2:0];
        PULSEIRQTIMEOUT_wr : coverpoint PULSEIRQTIMEOUT.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCRADARTIM_rd_cg";
        PULSEIRQFIFOTHR_rd : coverpoint PULSEIRQFIFOTHR.value[2:0];
        PULSEIRQTIMEOUT_rd : coverpoint PULSEIRQTIMEOUT.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCRADARTIM");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCDCCOMPRADAR
//--------------------------------------------------------------------
class RWNXAGCDCCOMPRADAR extends uvm_reg;
    `uvm_object_utils(RWNXAGCDCCOMPRADAR)
    rand uvm_reg_field DCRADARTYPE;
    rand uvm_reg_field DCRADARHOLDTIME50NS;
    rand uvm_reg_field DCRADARZEROTIME50NS;

    //---build------------------------------------------------------------
    virtual function void build();
        DCRADARTYPE = uvm_reg_field::type_id::create("DCRADARTYPE");
        DCRADARHOLDTIME50NS = uvm_reg_field::type_id::create("DCRADARHOLDTIME50NS");
        DCRADARZEROTIME50NS = uvm_reg_field::type_id::create("DCRADARZEROTIME50NS");

        DCRADARTYPE.configure(this, 2, 28, "RW", 1, 'b0, 1, 1, 1);
        DCRADARHOLDTIME50NS.configure(this, 7, 16, "RW", 1, 'b001000, 1, 1, 1);
        DCRADARZEROTIME50NS.configure(this, 7, 8, "RW", 1, 'b000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDCCOMPRADAR_wr_cg";
        DCRADARTYPE_wr : coverpoint DCRADARTYPE.value[1:0];
        DCRADARHOLDTIME50NS_wr : coverpoint DCRADARHOLDTIME50NS.value[6:0];
        DCRADARZEROTIME50NS_wr : coverpoint DCRADARZEROTIME50NS.value[6:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCDCCOMPRADAR_rd_cg";
        DCRADARTYPE_rd : coverpoint DCRADARTYPE.value[1:0];
        DCRADARHOLDTIME50NS_rd : coverpoint DCRADARHOLDTIME50NS.value[6:0];
        DCRADARZEROTIME50NS_rd : coverpoint DCRADARZEROTIME50NS.value[6:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCDCCOMPRADAR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCCA2
//--------------------------------------------------------------------
class RWNXAGCCCA2 extends uvm_reg;
    `uvm_object_utils(RWNXAGCCCA2)
    rand uvm_reg_field INBDCCA20SPOWMINDBM;
    rand uvm_reg_field CCA20SFALLTHRDBM;
    rand uvm_reg_field CCA20SRISETHRDBM;

    //---build------------------------------------------------------------
    virtual function void build();
        INBDCCA20SPOWMINDBM = uvm_reg_field::type_id::create("INBDCCA20SPOWMINDBM");
        CCA20SFALLTHRDBM = uvm_reg_field::type_id::create("CCA20SFALLTHRDBM");
        CCA20SRISETHRDBM = uvm_reg_field::type_id::create("CCA20SRISETHRDBM");

        INBDCCA20SPOWMINDBM.configure(this, 9, 20, "RW", 1, 'b110110000, 1, 1, 1);
        CCA20SFALLTHRDBM.configure(this, 8, 12, "RW", 1, 'b10110101, 1, 1, 1);
        CCA20SRISETHRDBM.configure(this, 8, 0, "RW", 1, 'b10111000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCA2_wr_cg";
        INBDCCA20SPOWMINDBM_wr : coverpoint INBDCCA20SPOWMINDBM.value[8:0];
        CCA20SFALLTHRDBM_wr : coverpoint CCA20SFALLTHRDBM.value[7:0];
        CCA20SRISETHRDBM_wr : coverpoint CCA20SRISETHRDBM.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCA2_rd_cg";
        INBDCCA20SPOWMINDBM_rd : coverpoint INBDCCA20SPOWMINDBM.value[8:0];
        CCA20SFALLTHRDBM_rd : coverpoint CCA20SFALLTHRDBM.value[7:0];
        CCA20SRISETHRDBM_rd : coverpoint CCA20SRISETHRDBM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCCA2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXAGCCCA3
//--------------------------------------------------------------------
class RWNXAGCCCA3 extends uvm_reg;
    `uvm_object_utils(RWNXAGCCCA3)
    rand uvm_reg_field INBDCCA40SPOWMINDBM;
    rand uvm_reg_field CCA40SFALLTHRDBM;
    rand uvm_reg_field CCA40SRISETHRDBM;

    //---build------------------------------------------------------------
    virtual function void build();
        INBDCCA40SPOWMINDBM = uvm_reg_field::type_id::create("INBDCCA40SPOWMINDBM");
        CCA40SFALLTHRDBM = uvm_reg_field::type_id::create("CCA40SFALLTHRDBM");
        CCA40SRISETHRDBM = uvm_reg_field::type_id::create("CCA40SRISETHRDBM");

        INBDCCA40SPOWMINDBM.configure(this, 9, 20, "RW", 1, 'b110110000, 1, 1, 1);
        CCA40SFALLTHRDBM.configure(this, 8, 12, "RW", 1, 'b10110101, 1, 1, 1);
        CCA40SRISETHRDBM.configure(this, 8, 0, "RW", 1, 'b10111000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCA3_wr_cg";
        INBDCCA40SPOWMINDBM_wr : coverpoint INBDCCA40SPOWMINDBM.value[8:0];
        CCA40SFALLTHRDBM_wr : coverpoint CCA40SFALLTHRDBM.value[7:0];
        CCA40SRISETHRDBM_wr : coverpoint CCA40SRISETHRDBM.value[7:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXAGCCCA3_rd_cg";
        INBDCCA40SPOWMINDBM_rd : coverpoint INBDCCA40SPOWMINDBM.value[8:0];
        CCA40SFALLTHRDBM_rd : coverpoint CCA40SFALLTHRDBM.value[7:0];
        CCA40SRISETHRDBM_rd : coverpoint CCA40SRISETHRDBM.value[7:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXAGCCCA3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXMACINTEN
//--------------------------------------------------------------------
class RWNXMACINTEN extends uvm_reg;
    `uvm_object_utils(RWNXMACINTEN)
    rand uvm_reg_field IRQMACRADARDETEN;
    rand uvm_reg_field IRQMACCCATIMEOUTEN;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQMACRADARDETEN = uvm_reg_field::type_id::create("IRQMACRADARDETEN");
        IRQMACCCATIMEOUTEN = uvm_reg_field::type_id::create("IRQMACCCATIMEOUTEN");

        IRQMACRADARDETEN.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        IRQMACCCATIMEOUTEN.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXMACINTEN_wr_cg";
        IRQMACRADARDETEN_wr : coverpoint IRQMACRADARDETEN.value[0:0];
        IRQMACCCATIMEOUTEN_wr : coverpoint IRQMACCCATIMEOUTEN.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXMACINTEN_rd_cg";
        IRQMACRADARDETEN_rd : coverpoint IRQMACRADARDETEN.value[0:0];
        IRQMACCCATIMEOUTEN_rd : coverpoint IRQMACCCATIMEOUTEN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXMACINTEN");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXMACINTSTATRAW
//--------------------------------------------------------------------
class RWNXMACINTSTATRAW extends uvm_reg;
    `uvm_object_utils(RWNXMACINTSTATRAW)
    rand uvm_reg_field IRQMACRADARDETRAW;
    rand uvm_reg_field IRQMACCCATIMEOUTRAW;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQMACRADARDETRAW = uvm_reg_field::type_id::create("IRQMACRADARDETRAW");
        IRQMACCCATIMEOUTRAW = uvm_reg_field::type_id::create("IRQMACCCATIMEOUTRAW");

        IRQMACRADARDETRAW.configure(this, 1, 12, "RO", 1, 'b0, 1, 1, 1);
        IRQMACCCATIMEOUTRAW.configure(this, 1, 8, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXMACINTSTATRAW_rd_cg";
        IRQMACRADARDETRAW_rd : coverpoint IRQMACRADARDETRAW.value[0:0];
        IRQMACCCATIMEOUTRAW_rd : coverpoint IRQMACCCATIMEOUTRAW.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXMACINTSTATRAW");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXMACINTSTATMASKED
//--------------------------------------------------------------------
class RWNXMACINTSTATMASKED extends uvm_reg;
    `uvm_object_utils(RWNXMACINTSTATMASKED)
    rand uvm_reg_field IRQMACRADARDETMASKED;
    rand uvm_reg_field IRQMACCCATIMEOUTMASKED;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQMACRADARDETMASKED = uvm_reg_field::type_id::create("IRQMACRADARDETMASKED");
        IRQMACCCATIMEOUTMASKED = uvm_reg_field::type_id::create("IRQMACCCATIMEOUTMASKED");

        IRQMACRADARDETMASKED.configure(this, 1, 12, "RO", 1, 'b0, 1, 1, 1);
        IRQMACCCATIMEOUTMASKED.configure(this, 1, 8, "RO", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXMACINTSTATMASKED_rd_cg";
        IRQMACRADARDETMASKED_rd : coverpoint IRQMACRADARDETMASKED.value[0:0];
        IRQMACCCATIMEOUTMASKED_rd : coverpoint IRQMACCCATIMEOUTMASKED.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXMACINTSTATMASKED");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXMACINTACK
//--------------------------------------------------------------------
class RWNXMACINTACK extends uvm_reg;
    `uvm_object_utils(RWNXMACINTACK)
    rand uvm_reg_field IRQMACRADARDETACK;
    rand uvm_reg_field IRQMACCCATIMEOUTACK;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQMACRADARDETACK = uvm_reg_field::type_id::create("IRQMACRADARDETACK");
        IRQMACCCATIMEOUTACK = uvm_reg_field::type_id::create("IRQMACCCATIMEOUTACK");

        IRQMACRADARDETACK.configure(this, 1, 12, "W1C", 1, 'b0, 1, 1, 1);
        IRQMACCCATIMEOUTACK.configure(this, 1, 8, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXMACINTACK_wr_cg";
        IRQMACRADARDETACK_wr : coverpoint IRQMACRADARDETACK.value[0:0];
        IRQMACCCATIMEOUTACK_wr : coverpoint IRQMACCCATIMEOUTACK.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXMACINTACK");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXMACINTGEN
//--------------------------------------------------------------------
class RWNXMACINTGEN extends uvm_reg;
    `uvm_object_utils(RWNXMACINTGEN)
    rand uvm_reg_field IRQMACRADARDETGEN;
    rand uvm_reg_field IRQMACCCATIMEOUTGEN;

    //---build------------------------------------------------------------
    virtual function void build();
        IRQMACRADARDETGEN = uvm_reg_field::type_id::create("IRQMACRADARDETGEN");
        IRQMACCCATIMEOUTGEN = uvm_reg_field::type_id::create("IRQMACCCATIMEOUTGEN");

        IRQMACRADARDETGEN.configure(this, 1, 12, "W1S", 1, 'b0, 1, 1, 1);
        IRQMACCCATIMEOUTGEN.configure(this, 1, 8, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXMACINTGEN_wr_cg";
        IRQMACRADARDETGEN_wr : coverpoint IRQMACRADARDETGEN.value[0:0];
        IRQMACCCATIMEOUTGEN_wr : coverpoint IRQMACCCATIMEOUTGEN.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXMACINTGEN");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// RWNXFEDSSSCCKCNTL
//--------------------------------------------------------------------
class RWNXFEDSSSCCKCNTL extends uvm_reg;
    `uvm_object_utils(RWNXFEDSSSCCKCNTL)
    rand uvm_reg_field RXSHIFT4044;
    rand uvm_reg_field TXSHIFT4044;
    rand uvm_reg_field BRXPATHSELREG;
    rand uvm_reg_field RXPATHSELFROMREG;

    //---build------------------------------------------------------------
    virtual function void build();
        RXSHIFT4044 = uvm_reg_field::type_id::create("RXSHIFT4044");
        TXSHIFT4044 = uvm_reg_field::type_id::create("TXSHIFT4044");
        BRXPATHSELREG = uvm_reg_field::type_id::create("BRXPATHSELREG");
        RXPATHSELFROMREG = uvm_reg_field::type_id::create("RXPATHSELFROMREG");

        RXSHIFT4044.configure(this, 3, 16, "RW", 1, 'b100, 1, 1, 1);
        TXSHIFT4044.configure(this, 2, 12, "RW", 1, 'b1, 1, 1, 1);
        BRXPATHSELREG.configure(this, 2, 5, "RW", 1, 'b0, 1, 1, 1);
        RXPATHSELFROMREG.configure(this, 1, 4, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEDSSSCCKCNTL_wr_cg";
        RXSHIFT4044_wr : coverpoint RXSHIFT4044.value[2:0];
        TXSHIFT4044_wr : coverpoint TXSHIFT4044.value[1:0];
        BRXPATHSELREG_wr : coverpoint BRXPATHSELREG.value[1:0];
        RXPATHSELFROMREG_wr : coverpoint RXPATHSELFROMREG.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="RIUKARST_RWNXFEDSSSCCKCNTL_rd_cg";
        RXSHIFT4044_rd : coverpoint RXSHIFT4044.value[2:0];
        TXSHIFT4044_rd : coverpoint TXSHIFT4044.value[1:0];
        BRXPATHSELREG_rd : coverpoint BRXPATHSELREG.value[1:0];
        RXPATHSELFROMREG_rd : coverpoint RXPATHSELFROMREG.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "RWNXFEDSSSCCKCNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class RIUKARST_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(RIUKARST_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins RWNXVERSION              = {'h0};
        bins RWNXSTATICCONFIG              = {'h4};
        bins RWNXDYNAMICCONFIG              = {'h8};
        bins RWNXIQCTRL              = {'h1C};
        bins RWNXMACSTATICCONFIG              = {'h80};
        bins RWNXFECTRL0              = {'h100};
        bins RWNXFECTRL1              = {'h104};
        bins RWNXFETXIQCOMP0              = {'h108};
        bins RWNXFETXIQCOMP1              = {'h10C};
        bins RWNXFERXIQESTCTRL              = {'h110};
        bins RWNXFERXIQESTLOOP              = {'h114};
        bins RWNXFERXIQESTCLR              = {'h118};
        bins RWNXFERXIQCOMP0              = {'h11C};
        bins RWNXFERXIQCOMP1              = {'h120};
        bins RWNXFEFIQCTRL              = {'h124};
        bins RWNXFEFIQCOLL              = {'h128};
        bins RWNXFEFIQEST0              = {'h12C};
        bins RWNXFEFIQEST1              = {'h130};
        bins RWNXFEFIQDEL              = {'h134};
        bins RWNXFEFIQCOEFF0              = {'h138};
        bins RWNXFEFIQCOEFF1              = {'h13C};
        bins RWNXFEFIQCOEFF2              = {'h140};
        bins RWNXFEFIQCOEFF3              = {'h144};
        bins RWNXFEFIQCOEFF4              = {'h148};
        bins RWNXFEFIQCOEFF5              = {'h14C};
        bins RWNXFEFIQCOEFF6              = {'h150};
        bins RWNXFEFIQCOEFF7              = {'h154};
        bins RWNXFEFIQCOEFF8              = {'h158};
        bins RWNXFEFIQCOEFF9              = {'h15C};
        bins RWNXFEFIQCOEFF10              = {'h160};
        bins RWNXFEFIQCOEFF11              = {'h164};
        bins RWNXFEFIQCOEFF12              = {'h168};
        bins RWNXFEFIQCOEFF13              = {'h16C};
        bins RWNXFEFIQCOEFF14              = {'h170};
        bins RWNXFEFIQCOEFF15              = {'h174};
        bins RWNXFEFIQCOEFF16              = {'h178};
        bins RWNXFEFIQCOEFF17              = {'h17C};
        bins RWNXFEFIQCOEFF18              = {'h180};
        bins RWNXFEFIQCOEFF19              = {'h184};
        bins RWNXFEFIQCOEFFUPDATE              = {'h188};
        bins RWNXFEFIQCOEFFREQ              = {'h18C};
        bins RWNXFEFIQSTART              = {'h190};
        bins AGCGAINSTAT              = {'h200};
        bins AGCADCPOWSTAT              = {'h208};
        bins AGCINBDPOW20PSTAT              = {'h20C};
        bins AGCDIGGAIN0STAT              = {'h210};
        bins AGCDIGGAIN1STAT              = {'h214};
        bins RADARFIFOSTAT              = {'h220};
        bins AGCINBDPOW20PNOISESTAT              = {'h228};
        bins AGCINBDPOWSECSTAT              = {'h22C};
        bins AGCINBDPOWSECNOISESTAT              = {'h230};
        bins RWNXFERXIQSTATVARI0              = {'h240};
        bins RWNXFERXIQSTATVARQ0              = {'h244};
        bins RWNXFERXIQSTATMIQ0              = {'h248};
        bins RWNXFERXIQSTAT0              = {'h24C};
        bins RWNXFERXIQSTATVARI1              = {'h250};
        bins RWNXFERXIQSTATVARQ1              = {'h254};
        bins RWNXFERXIQSTATMIQ1              = {'h258};
        bins RWNXFERXIQSTAT1              = {'h25C};
        bins RWNXFEFIQDONE              = {'h260};
        bins RWNXFEFIQSTAT0              = {'h264};
        bins RWNXFEFIQSTAT1              = {'h268};
        bins RWNXFEFIQSTATCOEFF0              = {'h26C};
        bins RWNXFEFIQSTATCOEFF1              = {'h270};
        bins RWNXFEFIQSTATCOEFF2              = {'h274};
        bins RWNXFEFIQSTATCOEFF3              = {'h278};
        bins RWNXFEFIQSTATCOEFF4              = {'h27C};
        bins RWNXFEFIQSTATCOEFF5              = {'h280};
        bins RWNXFEFIQSTATCOEFF6              = {'h284};
        bins RWNXFEFIQSTATCOEFF7              = {'h288};
        bins RWNXFEFIQSTATCOEFF8              = {'h28C};
        bins RWNXFEFIQSTATCOEFF9              = {'h290};
        bins RWNXFEFIQSTATCOEFF10              = {'h294};
        bins RWNXFEFIQSTATCOEFF11              = {'h298};
        bins RWNXFEFIQSTATCOEFF12              = {'h29C};
        bins RWNXFEFIQSTATCOEFF13              = {'h2A0};
        bins RWNXFEFIQSTATCOEFF14              = {'h2A4};
        bins RWNXFEFIQSTATCOEFF15              = {'h2A8};
        bins RWNXFEFIQSTATCOEFF16              = {'h2AC};
        bins RWNXFEFIQSTATCOEFF17              = {'h2B0};
        bins RWNXFEFIQSTATCOEFF18              = {'h2B4};
        bins RWNXFEFIQSTATCOEFF19              = {'h2B8};
        bins RWNXAGCANTLOSS              = {'h300};
        bins RWNXAGCGAINRANGE              = {'h304};
        bins RWNXAGCDIGGAINCONF              = {'h308};
        bins RWNXAGCNOISECONF              = {'h30C};
        bins RWNXAGCACI20MARG0              = {'h340};
        bins RWNXAGCACI20MARG1              = {'h344};
        bins RWNXAGCACI20MARG2              = {'h348};
        bins RWNXAGCACI40MARG0              = {'h34C};
        bins RWNXAGCACI40MARG1              = {'h350};
        bins RWNXAGCACI40MARG2              = {'h354};
        bins RWNXAGCACI80MARG0              = {'h358};
        bins RWNXAGCACI80MARG1              = {'h35C};
        bins RWNXAGCACI80MARG2              = {'h360};
        bins RWNXAGCSAT              = {'h364};
        bins RWNXAGCCROSS              = {'h368};
        bins RWNXAGCRAMP              = {'h36C};
        bins RWNXAGCSTABDIS              = {'h370};
        bins RWNXAGCDCCOMP0              = {'h374};
        bins RWNXAGCDCCOMP1              = {'h378};
        bins RWNXAGCDCCOMP2              = {'h37C};
        bins RWNXAGCEVT0              = {'h380};
        bins RWNXAGCEVT1              = {'h384};
        bins RWNXAGCEVT2              = {'h388};
        bins RWNXAGCEVT3              = {'h38C};
        bins RWNXAGCCNTL              = {'h390};
        bins RWNXAGCDSP0              = {'h394};
        bins RWNXAGCDSP1              = {'h398};
        bins RWNXAGCDSP2              = {'h39C};
        bins RWNXAGCDSP3              = {'h3A0};
        bins RWNXAGCDSP4              = {'h3A4};
        bins RWNXAGCCCA0              = {'h3A8};
        bins RWNXAGCCCA1              = {'h3AC};
        bins RWNXAGCCCACTRL              = {'h3B0};
        bins RWNXAGCCCASTATE0              = {'h3B4};
        bins RWNXAGCCCASTATE1              = {'h3B8};
        bins RWNXAGCCCATIMEOUT              = {'h3BC};
        bins RWNXAGCCOMP0              = {'h3C0};
        bins RWNXAGCCOMP1              = {'h3C4};
        bins RWNXAGCRADAR              = {'h3C8};
        bins RWNXAGCRADARTIM              = {'h3CC};
        bins RWNXAGCDCCOMPRADAR              = {'h3D0};
        bins RWNXAGCCCA2              = {'h3D4};
        bins RWNXAGCCCA3              = {'h3D8};
        bins RWNXMACINTEN              = {'h414};
        bins RWNXMACINTSTATRAW              = {'h418};
        bins RWNXMACINTSTATMASKED              = {'h41C};
        bins RWNXMACINTACK              = {'h420};
        bins RWNXMACINTGEN              = {'h424};
        bins RWNXFEDSSSCCKCNTL              = {'h500};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "RIUKARST_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: RIUKARST_reg_access_wrapper

//-------------------------------------------------------------------
// RIUKARST_register_block
//--------------------------------------------------------------------
class RIUKARST_register_block extends uvm_reg_block;
    `uvm_object_utils(RIUKARST_register_block)

    rand RWNXVERSION RWNXVERSION_reg;
    rand RWNXSTATICCONFIG RWNXSTATICCONFIG_reg;
    rand RWNXDYNAMICCONFIG RWNXDYNAMICCONFIG_reg;
    rand RWNXIQCTRL RWNXIQCTRL_reg;
    rand RWNXMACSTATICCONFIG RWNXMACSTATICCONFIG_reg;
    rand RWNXFECTRL0 RWNXFECTRL0_reg;
    rand RWNXFECTRL1 RWNXFECTRL1_reg;
    rand RWNXFETXIQCOMP0 RWNXFETXIQCOMP0_reg;
    rand RWNXFETXIQCOMP1 RWNXFETXIQCOMP1_reg;
    rand RWNXFERXIQESTCTRL RWNXFERXIQESTCTRL_reg;
    rand RWNXFERXIQESTLOOP RWNXFERXIQESTLOOP_reg;
    rand RWNXFERXIQESTCLR RWNXFERXIQESTCLR_reg;
    rand RWNXFERXIQCOMP0 RWNXFERXIQCOMP0_reg;
    rand RWNXFERXIQCOMP1 RWNXFERXIQCOMP1_reg;
    rand RWNXFEFIQCTRL RWNXFEFIQCTRL_reg;
    rand RWNXFEFIQCOLL RWNXFEFIQCOLL_reg;
    rand RWNXFEFIQEST0 RWNXFEFIQEST0_reg;
    rand RWNXFEFIQEST1 RWNXFEFIQEST1_reg;
    rand RWNXFEFIQDEL RWNXFEFIQDEL_reg;
    rand RWNXFEFIQCOEFF0 RWNXFEFIQCOEFF0_reg;
    rand RWNXFEFIQCOEFF1 RWNXFEFIQCOEFF1_reg;
    rand RWNXFEFIQCOEFF2 RWNXFEFIQCOEFF2_reg;
    rand RWNXFEFIQCOEFF3 RWNXFEFIQCOEFF3_reg;
    rand RWNXFEFIQCOEFF4 RWNXFEFIQCOEFF4_reg;
    rand RWNXFEFIQCOEFF5 RWNXFEFIQCOEFF5_reg;
    rand RWNXFEFIQCOEFF6 RWNXFEFIQCOEFF6_reg;
    rand RWNXFEFIQCOEFF7 RWNXFEFIQCOEFF7_reg;
    rand RWNXFEFIQCOEFF8 RWNXFEFIQCOEFF8_reg;
    rand RWNXFEFIQCOEFF9 RWNXFEFIQCOEFF9_reg;
    rand RWNXFEFIQCOEFF10 RWNXFEFIQCOEFF10_reg;
    rand RWNXFEFIQCOEFF11 RWNXFEFIQCOEFF11_reg;
    rand RWNXFEFIQCOEFF12 RWNXFEFIQCOEFF12_reg;
    rand RWNXFEFIQCOEFF13 RWNXFEFIQCOEFF13_reg;
    rand RWNXFEFIQCOEFF14 RWNXFEFIQCOEFF14_reg;
    rand RWNXFEFIQCOEFF15 RWNXFEFIQCOEFF15_reg;
    rand RWNXFEFIQCOEFF16 RWNXFEFIQCOEFF16_reg;
    rand RWNXFEFIQCOEFF17 RWNXFEFIQCOEFF17_reg;
    rand RWNXFEFIQCOEFF18 RWNXFEFIQCOEFF18_reg;
    rand RWNXFEFIQCOEFF19 RWNXFEFIQCOEFF19_reg;
    rand RWNXFEFIQCOEFFUPDATE RWNXFEFIQCOEFFUPDATE_reg;
    rand RWNXFEFIQCOEFFREQ RWNXFEFIQCOEFFREQ_reg;
    rand RWNXFEFIQSTART RWNXFEFIQSTART_reg;
    rand AGCGAINSTAT AGCGAINSTAT_reg;
    rand AGCADCPOWSTAT AGCADCPOWSTAT_reg;
    rand AGCINBDPOW20PSTAT AGCINBDPOW20PSTAT_reg;
    rand AGCDIGGAIN0STAT AGCDIGGAIN0STAT_reg;
    rand AGCDIGGAIN1STAT AGCDIGGAIN1STAT_reg;
    rand RADARFIFOSTAT RADARFIFOSTAT_reg;
    rand AGCINBDPOW20PNOISESTAT AGCINBDPOW20PNOISESTAT_reg;
    rand AGCINBDPOWSECSTAT AGCINBDPOWSECSTAT_reg;
    rand AGCINBDPOWSECNOISESTAT AGCINBDPOWSECNOISESTAT_reg;
    rand RWNXFERXIQSTATVARI0 RWNXFERXIQSTATVARI0_reg;
    rand RWNXFERXIQSTATVARQ0 RWNXFERXIQSTATVARQ0_reg;
    rand RWNXFERXIQSTATMIQ0 RWNXFERXIQSTATMIQ0_reg;
    rand RWNXFERXIQSTAT0 RWNXFERXIQSTAT0_reg;
    rand RWNXFERXIQSTATVARI1 RWNXFERXIQSTATVARI1_reg;
    rand RWNXFERXIQSTATVARQ1 RWNXFERXIQSTATVARQ1_reg;
    rand RWNXFERXIQSTATMIQ1 RWNXFERXIQSTATMIQ1_reg;
    rand RWNXFERXIQSTAT1 RWNXFERXIQSTAT1_reg;
    rand RWNXFEFIQDONE RWNXFEFIQDONE_reg;
    rand RWNXFEFIQSTAT0 RWNXFEFIQSTAT0_reg;
    rand RWNXFEFIQSTAT1 RWNXFEFIQSTAT1_reg;
    rand RWNXFEFIQSTATCOEFF0 RWNXFEFIQSTATCOEFF0_reg;
    rand RWNXFEFIQSTATCOEFF1 RWNXFEFIQSTATCOEFF1_reg;
    rand RWNXFEFIQSTATCOEFF2 RWNXFEFIQSTATCOEFF2_reg;
    rand RWNXFEFIQSTATCOEFF3 RWNXFEFIQSTATCOEFF3_reg;
    rand RWNXFEFIQSTATCOEFF4 RWNXFEFIQSTATCOEFF4_reg;
    rand RWNXFEFIQSTATCOEFF5 RWNXFEFIQSTATCOEFF5_reg;
    rand RWNXFEFIQSTATCOEFF6 RWNXFEFIQSTATCOEFF6_reg;
    rand RWNXFEFIQSTATCOEFF7 RWNXFEFIQSTATCOEFF7_reg;
    rand RWNXFEFIQSTATCOEFF8 RWNXFEFIQSTATCOEFF8_reg;
    rand RWNXFEFIQSTATCOEFF9 RWNXFEFIQSTATCOEFF9_reg;
    rand RWNXFEFIQSTATCOEFF10 RWNXFEFIQSTATCOEFF10_reg;
    rand RWNXFEFIQSTATCOEFF11 RWNXFEFIQSTATCOEFF11_reg;
    rand RWNXFEFIQSTATCOEFF12 RWNXFEFIQSTATCOEFF12_reg;
    rand RWNXFEFIQSTATCOEFF13 RWNXFEFIQSTATCOEFF13_reg;
    rand RWNXFEFIQSTATCOEFF14 RWNXFEFIQSTATCOEFF14_reg;
    rand RWNXFEFIQSTATCOEFF15 RWNXFEFIQSTATCOEFF15_reg;
    rand RWNXFEFIQSTATCOEFF16 RWNXFEFIQSTATCOEFF16_reg;
    rand RWNXFEFIQSTATCOEFF17 RWNXFEFIQSTATCOEFF17_reg;
    rand RWNXFEFIQSTATCOEFF18 RWNXFEFIQSTATCOEFF18_reg;
    rand RWNXFEFIQSTATCOEFF19 RWNXFEFIQSTATCOEFF19_reg;
    rand RWNXAGCANTLOSS RWNXAGCANTLOSS_reg;
    rand RWNXAGCGAINRANGE RWNXAGCGAINRANGE_reg;
    rand RWNXAGCDIGGAINCONF RWNXAGCDIGGAINCONF_reg;
    rand RWNXAGCNOISECONF RWNXAGCNOISECONF_reg;
    rand RWNXAGCACI20MARG0 RWNXAGCACI20MARG0_reg;
    rand RWNXAGCACI20MARG1 RWNXAGCACI20MARG1_reg;
    rand RWNXAGCACI20MARG2 RWNXAGCACI20MARG2_reg;
    rand RWNXAGCACI40MARG0 RWNXAGCACI40MARG0_reg;
    rand RWNXAGCACI40MARG1 RWNXAGCACI40MARG1_reg;
    rand RWNXAGCACI40MARG2 RWNXAGCACI40MARG2_reg;
    rand RWNXAGCACI80MARG0 RWNXAGCACI80MARG0_reg;
    rand RWNXAGCACI80MARG1 RWNXAGCACI80MARG1_reg;
    rand RWNXAGCACI80MARG2 RWNXAGCACI80MARG2_reg;
    rand RWNXAGCSAT RWNXAGCSAT_reg;
    rand RWNXAGCCROSS RWNXAGCCROSS_reg;
    rand RWNXAGCRAMP RWNXAGCRAMP_reg;
    rand RWNXAGCSTABDIS RWNXAGCSTABDIS_reg;
    rand RWNXAGCDCCOMP0 RWNXAGCDCCOMP0_reg;
    rand RWNXAGCDCCOMP1 RWNXAGCDCCOMP1_reg;
    rand RWNXAGCDCCOMP2 RWNXAGCDCCOMP2_reg;
    rand RWNXAGCEVT0 RWNXAGCEVT0_reg;
    rand RWNXAGCEVT1 RWNXAGCEVT1_reg;
    rand RWNXAGCEVT2 RWNXAGCEVT2_reg;
    rand RWNXAGCEVT3 RWNXAGCEVT3_reg;
    rand RWNXAGCCNTL RWNXAGCCNTL_reg;
    rand RWNXAGCDSP0 RWNXAGCDSP0_reg;
    rand RWNXAGCDSP1 RWNXAGCDSP1_reg;
    rand RWNXAGCDSP2 RWNXAGCDSP2_reg;
    rand RWNXAGCDSP3 RWNXAGCDSP3_reg;
    rand RWNXAGCDSP4 RWNXAGCDSP4_reg;
    rand RWNXAGCCCA0 RWNXAGCCCA0_reg;
    rand RWNXAGCCCA1 RWNXAGCCCA1_reg;
    rand RWNXAGCCCACTRL RWNXAGCCCACTRL_reg;
    rand RWNXAGCCCASTATE0 RWNXAGCCCASTATE0_reg;
    rand RWNXAGCCCASTATE1 RWNXAGCCCASTATE1_reg;
    rand RWNXAGCCCATIMEOUT RWNXAGCCCATIMEOUT_reg;
    rand RWNXAGCCOMP0 RWNXAGCCOMP0_reg;
    rand RWNXAGCCOMP1 RWNXAGCCOMP1_reg;
    rand RWNXAGCRADAR RWNXAGCRADAR_reg;
    rand RWNXAGCRADARTIM RWNXAGCRADARTIM_reg;
    rand RWNXAGCDCCOMPRADAR RWNXAGCDCCOMPRADAR_reg;
    rand RWNXAGCCCA2 RWNXAGCCCA2_reg;
    rand RWNXAGCCCA3 RWNXAGCCCA3_reg;
    rand RWNXMACINTEN RWNXMACINTEN_reg;
    rand RWNXMACINTSTATRAW RWNXMACINTSTATRAW_reg;
    rand RWNXMACINTSTATMASKED RWNXMACINTSTATMASKED_reg;
    rand RWNXMACINTACK RWNXMACINTACK_reg;
    rand RWNXMACINTGEN RWNXMACINTGEN_reg;
    rand RWNXFEDSSSCCKCNTL RWNXFEDSSSCCKCNTL_reg;

    uvm_reg_map RIUKARST_register_map; // Block map
    RIUKARST_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "RIUKARST_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = RIUKARST_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        RWNXVERSION_reg = RWNXVERSION::type_id::create("RWNXVERSION");
        RWNXVERSION_reg.configure(this);
        RWNXVERSION_reg.build();

        RWNXSTATICCONFIG_reg = RWNXSTATICCONFIG::type_id::create("RWNXSTATICCONFIG");
        RWNXSTATICCONFIG_reg.configure(this);
        RWNXSTATICCONFIG_reg.build();

        RWNXDYNAMICCONFIG_reg = RWNXDYNAMICCONFIG::type_id::create("RWNXDYNAMICCONFIG");
        RWNXDYNAMICCONFIG_reg.configure(this);
        RWNXDYNAMICCONFIG_reg.build();

        RWNXIQCTRL_reg = RWNXIQCTRL::type_id::create("RWNXIQCTRL");
        RWNXIQCTRL_reg.configure(this);
        RWNXIQCTRL_reg.build();

        RWNXMACSTATICCONFIG_reg = RWNXMACSTATICCONFIG::type_id::create("RWNXMACSTATICCONFIG");
        RWNXMACSTATICCONFIG_reg.configure(this);
        RWNXMACSTATICCONFIG_reg.build();

        RWNXFECTRL0_reg = RWNXFECTRL0::type_id::create("RWNXFECTRL0");
        RWNXFECTRL0_reg.configure(this);
        RWNXFECTRL0_reg.build();

        RWNXFECTRL1_reg = RWNXFECTRL1::type_id::create("RWNXFECTRL1");
        RWNXFECTRL1_reg.configure(this);
        RWNXFECTRL1_reg.build();

        RWNXFETXIQCOMP0_reg = RWNXFETXIQCOMP0::type_id::create("RWNXFETXIQCOMP0");
        RWNXFETXIQCOMP0_reg.configure(this);
        RWNXFETXIQCOMP0_reg.build();

        RWNXFETXIQCOMP1_reg = RWNXFETXIQCOMP1::type_id::create("RWNXFETXIQCOMP1");
        RWNXFETXIQCOMP1_reg.configure(this);
        RWNXFETXIQCOMP1_reg.build();

        RWNXFERXIQESTCTRL_reg = RWNXFERXIQESTCTRL::type_id::create("RWNXFERXIQESTCTRL");
        RWNXFERXIQESTCTRL_reg.configure(this);
        RWNXFERXIQESTCTRL_reg.build();

        RWNXFERXIQESTLOOP_reg = RWNXFERXIQESTLOOP::type_id::create("RWNXFERXIQESTLOOP");
        RWNXFERXIQESTLOOP_reg.configure(this);
        RWNXFERXIQESTLOOP_reg.build();

        RWNXFERXIQESTCLR_reg = RWNXFERXIQESTCLR::type_id::create("RWNXFERXIQESTCLR");
        RWNXFERXIQESTCLR_reg.configure(this);
        RWNXFERXIQESTCLR_reg.build();

        RWNXFERXIQCOMP0_reg = RWNXFERXIQCOMP0::type_id::create("RWNXFERXIQCOMP0");
        RWNXFERXIQCOMP0_reg.configure(this);
        RWNXFERXIQCOMP0_reg.build();

        RWNXFERXIQCOMP1_reg = RWNXFERXIQCOMP1::type_id::create("RWNXFERXIQCOMP1");
        RWNXFERXIQCOMP1_reg.configure(this);
        RWNXFERXIQCOMP1_reg.build();

        RWNXFEFIQCTRL_reg = RWNXFEFIQCTRL::type_id::create("RWNXFEFIQCTRL");
        RWNXFEFIQCTRL_reg.configure(this);
        RWNXFEFIQCTRL_reg.build();

        RWNXFEFIQCOLL_reg = RWNXFEFIQCOLL::type_id::create("RWNXFEFIQCOLL");
        RWNXFEFIQCOLL_reg.configure(this);
        RWNXFEFIQCOLL_reg.build();

        RWNXFEFIQEST0_reg = RWNXFEFIQEST0::type_id::create("RWNXFEFIQEST0");
        RWNXFEFIQEST0_reg.configure(this);
        RWNXFEFIQEST0_reg.build();

        RWNXFEFIQEST1_reg = RWNXFEFIQEST1::type_id::create("RWNXFEFIQEST1");
        RWNXFEFIQEST1_reg.configure(this);
        RWNXFEFIQEST1_reg.build();

        RWNXFEFIQDEL_reg = RWNXFEFIQDEL::type_id::create("RWNXFEFIQDEL");
        RWNXFEFIQDEL_reg.configure(this);
        RWNXFEFIQDEL_reg.build();

        RWNXFEFIQCOEFF0_reg = RWNXFEFIQCOEFF0::type_id::create("RWNXFEFIQCOEFF0");
        RWNXFEFIQCOEFF0_reg.configure(this);
        RWNXFEFIQCOEFF0_reg.build();

        RWNXFEFIQCOEFF1_reg = RWNXFEFIQCOEFF1::type_id::create("RWNXFEFIQCOEFF1");
        RWNXFEFIQCOEFF1_reg.configure(this);
        RWNXFEFIQCOEFF1_reg.build();

        RWNXFEFIQCOEFF2_reg = RWNXFEFIQCOEFF2::type_id::create("RWNXFEFIQCOEFF2");
        RWNXFEFIQCOEFF2_reg.configure(this);
        RWNXFEFIQCOEFF2_reg.build();

        RWNXFEFIQCOEFF3_reg = RWNXFEFIQCOEFF3::type_id::create("RWNXFEFIQCOEFF3");
        RWNXFEFIQCOEFF3_reg.configure(this);
        RWNXFEFIQCOEFF3_reg.build();

        RWNXFEFIQCOEFF4_reg = RWNXFEFIQCOEFF4::type_id::create("RWNXFEFIQCOEFF4");
        RWNXFEFIQCOEFF4_reg.configure(this);
        RWNXFEFIQCOEFF4_reg.build();

        RWNXFEFIQCOEFF5_reg = RWNXFEFIQCOEFF5::type_id::create("RWNXFEFIQCOEFF5");
        RWNXFEFIQCOEFF5_reg.configure(this);
        RWNXFEFIQCOEFF5_reg.build();

        RWNXFEFIQCOEFF6_reg = RWNXFEFIQCOEFF6::type_id::create("RWNXFEFIQCOEFF6");
        RWNXFEFIQCOEFF6_reg.configure(this);
        RWNXFEFIQCOEFF6_reg.build();

        RWNXFEFIQCOEFF7_reg = RWNXFEFIQCOEFF7::type_id::create("RWNXFEFIQCOEFF7");
        RWNXFEFIQCOEFF7_reg.configure(this);
        RWNXFEFIQCOEFF7_reg.build();

        RWNXFEFIQCOEFF8_reg = RWNXFEFIQCOEFF8::type_id::create("RWNXFEFIQCOEFF8");
        RWNXFEFIQCOEFF8_reg.configure(this);
        RWNXFEFIQCOEFF8_reg.build();

        RWNXFEFIQCOEFF9_reg = RWNXFEFIQCOEFF9::type_id::create("RWNXFEFIQCOEFF9");
        RWNXFEFIQCOEFF9_reg.configure(this);
        RWNXFEFIQCOEFF9_reg.build();

        RWNXFEFIQCOEFF10_reg = RWNXFEFIQCOEFF10::type_id::create("RWNXFEFIQCOEFF10");
        RWNXFEFIQCOEFF10_reg.configure(this);
        RWNXFEFIQCOEFF10_reg.build();

        RWNXFEFIQCOEFF11_reg = RWNXFEFIQCOEFF11::type_id::create("RWNXFEFIQCOEFF11");
        RWNXFEFIQCOEFF11_reg.configure(this);
        RWNXFEFIQCOEFF11_reg.build();

        RWNXFEFIQCOEFF12_reg = RWNXFEFIQCOEFF12::type_id::create("RWNXFEFIQCOEFF12");
        RWNXFEFIQCOEFF12_reg.configure(this);
        RWNXFEFIQCOEFF12_reg.build();

        RWNXFEFIQCOEFF13_reg = RWNXFEFIQCOEFF13::type_id::create("RWNXFEFIQCOEFF13");
        RWNXFEFIQCOEFF13_reg.configure(this);
        RWNXFEFIQCOEFF13_reg.build();

        RWNXFEFIQCOEFF14_reg = RWNXFEFIQCOEFF14::type_id::create("RWNXFEFIQCOEFF14");
        RWNXFEFIQCOEFF14_reg.configure(this);
        RWNXFEFIQCOEFF14_reg.build();

        RWNXFEFIQCOEFF15_reg = RWNXFEFIQCOEFF15::type_id::create("RWNXFEFIQCOEFF15");
        RWNXFEFIQCOEFF15_reg.configure(this);
        RWNXFEFIQCOEFF15_reg.build();

        RWNXFEFIQCOEFF16_reg = RWNXFEFIQCOEFF16::type_id::create("RWNXFEFIQCOEFF16");
        RWNXFEFIQCOEFF16_reg.configure(this);
        RWNXFEFIQCOEFF16_reg.build();

        RWNXFEFIQCOEFF17_reg = RWNXFEFIQCOEFF17::type_id::create("RWNXFEFIQCOEFF17");
        RWNXFEFIQCOEFF17_reg.configure(this);
        RWNXFEFIQCOEFF17_reg.build();

        RWNXFEFIQCOEFF18_reg = RWNXFEFIQCOEFF18::type_id::create("RWNXFEFIQCOEFF18");
        RWNXFEFIQCOEFF18_reg.configure(this);
        RWNXFEFIQCOEFF18_reg.build();

        RWNXFEFIQCOEFF19_reg = RWNXFEFIQCOEFF19::type_id::create("RWNXFEFIQCOEFF19");
        RWNXFEFIQCOEFF19_reg.configure(this);
        RWNXFEFIQCOEFF19_reg.build();

        RWNXFEFIQCOEFFUPDATE_reg = RWNXFEFIQCOEFFUPDATE::type_id::create("RWNXFEFIQCOEFFUPDATE");
        RWNXFEFIQCOEFFUPDATE_reg.configure(this);
        RWNXFEFIQCOEFFUPDATE_reg.build();

        RWNXFEFIQCOEFFREQ_reg = RWNXFEFIQCOEFFREQ::type_id::create("RWNXFEFIQCOEFFREQ");
        RWNXFEFIQCOEFFREQ_reg.configure(this);
        RWNXFEFIQCOEFFREQ_reg.build();

        RWNXFEFIQSTART_reg = RWNXFEFIQSTART::type_id::create("RWNXFEFIQSTART");
        RWNXFEFIQSTART_reg.configure(this);
        RWNXFEFIQSTART_reg.build();

        AGCGAINSTAT_reg = AGCGAINSTAT::type_id::create("AGCGAINSTAT");
        AGCGAINSTAT_reg.configure(this);
        AGCGAINSTAT_reg.build();

        AGCADCPOWSTAT_reg = AGCADCPOWSTAT::type_id::create("AGCADCPOWSTAT");
        AGCADCPOWSTAT_reg.configure(this);
        AGCADCPOWSTAT_reg.build();

        AGCINBDPOW20PSTAT_reg = AGCINBDPOW20PSTAT::type_id::create("AGCINBDPOW20PSTAT");
        AGCINBDPOW20PSTAT_reg.configure(this);
        AGCINBDPOW20PSTAT_reg.build();

        AGCDIGGAIN0STAT_reg = AGCDIGGAIN0STAT::type_id::create("AGCDIGGAIN0STAT");
        AGCDIGGAIN0STAT_reg.configure(this);
        AGCDIGGAIN0STAT_reg.build();

        AGCDIGGAIN1STAT_reg = AGCDIGGAIN1STAT::type_id::create("AGCDIGGAIN1STAT");
        AGCDIGGAIN1STAT_reg.configure(this);
        AGCDIGGAIN1STAT_reg.build();

        RADARFIFOSTAT_reg = RADARFIFOSTAT::type_id::create("RADARFIFOSTAT");
        RADARFIFOSTAT_reg.configure(this);
        RADARFIFOSTAT_reg.build();

        AGCINBDPOW20PNOISESTAT_reg = AGCINBDPOW20PNOISESTAT::type_id::create("AGCINBDPOW20PNOISESTAT");
        AGCINBDPOW20PNOISESTAT_reg.configure(this);
        AGCINBDPOW20PNOISESTAT_reg.build();

        AGCINBDPOWSECSTAT_reg = AGCINBDPOWSECSTAT::type_id::create("AGCINBDPOWSECSTAT");
        AGCINBDPOWSECSTAT_reg.configure(this);
        AGCINBDPOWSECSTAT_reg.build();

        AGCINBDPOWSECNOISESTAT_reg = AGCINBDPOWSECNOISESTAT::type_id::create("AGCINBDPOWSECNOISESTAT");
        AGCINBDPOWSECNOISESTAT_reg.configure(this);
        AGCINBDPOWSECNOISESTAT_reg.build();

        RWNXFERXIQSTATVARI0_reg = RWNXFERXIQSTATVARI0::type_id::create("RWNXFERXIQSTATVARI0");
        RWNXFERXIQSTATVARI0_reg.configure(this);
        RWNXFERXIQSTATVARI0_reg.build();

        RWNXFERXIQSTATVARQ0_reg = RWNXFERXIQSTATVARQ0::type_id::create("RWNXFERXIQSTATVARQ0");
        RWNXFERXIQSTATVARQ0_reg.configure(this);
        RWNXFERXIQSTATVARQ0_reg.build();

        RWNXFERXIQSTATMIQ0_reg = RWNXFERXIQSTATMIQ0::type_id::create("RWNXFERXIQSTATMIQ0");
        RWNXFERXIQSTATMIQ0_reg.configure(this);
        RWNXFERXIQSTATMIQ0_reg.build();

        RWNXFERXIQSTAT0_reg = RWNXFERXIQSTAT0::type_id::create("RWNXFERXIQSTAT0");
        RWNXFERXIQSTAT0_reg.configure(this);
        RWNXFERXIQSTAT0_reg.build();

        RWNXFERXIQSTATVARI1_reg = RWNXFERXIQSTATVARI1::type_id::create("RWNXFERXIQSTATVARI1");
        RWNXFERXIQSTATVARI1_reg.configure(this);
        RWNXFERXIQSTATVARI1_reg.build();

        RWNXFERXIQSTATVARQ1_reg = RWNXFERXIQSTATVARQ1::type_id::create("RWNXFERXIQSTATVARQ1");
        RWNXFERXIQSTATVARQ1_reg.configure(this);
        RWNXFERXIQSTATVARQ1_reg.build();

        RWNXFERXIQSTATMIQ1_reg = RWNXFERXIQSTATMIQ1::type_id::create("RWNXFERXIQSTATMIQ1");
        RWNXFERXIQSTATMIQ1_reg.configure(this);
        RWNXFERXIQSTATMIQ1_reg.build();

        RWNXFERXIQSTAT1_reg = RWNXFERXIQSTAT1::type_id::create("RWNXFERXIQSTAT1");
        RWNXFERXIQSTAT1_reg.configure(this);
        RWNXFERXIQSTAT1_reg.build();

        RWNXFEFIQDONE_reg = RWNXFEFIQDONE::type_id::create("RWNXFEFIQDONE");
        RWNXFEFIQDONE_reg.configure(this);
        RWNXFEFIQDONE_reg.build();

        RWNXFEFIQSTAT0_reg = RWNXFEFIQSTAT0::type_id::create("RWNXFEFIQSTAT0");
        RWNXFEFIQSTAT0_reg.configure(this);
        RWNXFEFIQSTAT0_reg.build();

        RWNXFEFIQSTAT1_reg = RWNXFEFIQSTAT1::type_id::create("RWNXFEFIQSTAT1");
        RWNXFEFIQSTAT1_reg.configure(this);
        RWNXFEFIQSTAT1_reg.build();

        RWNXFEFIQSTATCOEFF0_reg = RWNXFEFIQSTATCOEFF0::type_id::create("RWNXFEFIQSTATCOEFF0");
        RWNXFEFIQSTATCOEFF0_reg.configure(this);
        RWNXFEFIQSTATCOEFF0_reg.build();

        RWNXFEFIQSTATCOEFF1_reg = RWNXFEFIQSTATCOEFF1::type_id::create("RWNXFEFIQSTATCOEFF1");
        RWNXFEFIQSTATCOEFF1_reg.configure(this);
        RWNXFEFIQSTATCOEFF1_reg.build();

        RWNXFEFIQSTATCOEFF2_reg = RWNXFEFIQSTATCOEFF2::type_id::create("RWNXFEFIQSTATCOEFF2");
        RWNXFEFIQSTATCOEFF2_reg.configure(this);
        RWNXFEFIQSTATCOEFF2_reg.build();

        RWNXFEFIQSTATCOEFF3_reg = RWNXFEFIQSTATCOEFF3::type_id::create("RWNXFEFIQSTATCOEFF3");
        RWNXFEFIQSTATCOEFF3_reg.configure(this);
        RWNXFEFIQSTATCOEFF3_reg.build();

        RWNXFEFIQSTATCOEFF4_reg = RWNXFEFIQSTATCOEFF4::type_id::create("RWNXFEFIQSTATCOEFF4");
        RWNXFEFIQSTATCOEFF4_reg.configure(this);
        RWNXFEFIQSTATCOEFF4_reg.build();

        RWNXFEFIQSTATCOEFF5_reg = RWNXFEFIQSTATCOEFF5::type_id::create("RWNXFEFIQSTATCOEFF5");
        RWNXFEFIQSTATCOEFF5_reg.configure(this);
        RWNXFEFIQSTATCOEFF5_reg.build();

        RWNXFEFIQSTATCOEFF6_reg = RWNXFEFIQSTATCOEFF6::type_id::create("RWNXFEFIQSTATCOEFF6");
        RWNXFEFIQSTATCOEFF6_reg.configure(this);
        RWNXFEFIQSTATCOEFF6_reg.build();

        RWNXFEFIQSTATCOEFF7_reg = RWNXFEFIQSTATCOEFF7::type_id::create("RWNXFEFIQSTATCOEFF7");
        RWNXFEFIQSTATCOEFF7_reg.configure(this);
        RWNXFEFIQSTATCOEFF7_reg.build();

        RWNXFEFIQSTATCOEFF8_reg = RWNXFEFIQSTATCOEFF8::type_id::create("RWNXFEFIQSTATCOEFF8");
        RWNXFEFIQSTATCOEFF8_reg.configure(this);
        RWNXFEFIQSTATCOEFF8_reg.build();

        RWNXFEFIQSTATCOEFF9_reg = RWNXFEFIQSTATCOEFF9::type_id::create("RWNXFEFIQSTATCOEFF9");
        RWNXFEFIQSTATCOEFF9_reg.configure(this);
        RWNXFEFIQSTATCOEFF9_reg.build();

        RWNXFEFIQSTATCOEFF10_reg = RWNXFEFIQSTATCOEFF10::type_id::create("RWNXFEFIQSTATCOEFF10");
        RWNXFEFIQSTATCOEFF10_reg.configure(this);
        RWNXFEFIQSTATCOEFF10_reg.build();

        RWNXFEFIQSTATCOEFF11_reg = RWNXFEFIQSTATCOEFF11::type_id::create("RWNXFEFIQSTATCOEFF11");
        RWNXFEFIQSTATCOEFF11_reg.configure(this);
        RWNXFEFIQSTATCOEFF11_reg.build();

        RWNXFEFIQSTATCOEFF12_reg = RWNXFEFIQSTATCOEFF12::type_id::create("RWNXFEFIQSTATCOEFF12");
        RWNXFEFIQSTATCOEFF12_reg.configure(this);
        RWNXFEFIQSTATCOEFF12_reg.build();

        RWNXFEFIQSTATCOEFF13_reg = RWNXFEFIQSTATCOEFF13::type_id::create("RWNXFEFIQSTATCOEFF13");
        RWNXFEFIQSTATCOEFF13_reg.configure(this);
        RWNXFEFIQSTATCOEFF13_reg.build();

        RWNXFEFIQSTATCOEFF14_reg = RWNXFEFIQSTATCOEFF14::type_id::create("RWNXFEFIQSTATCOEFF14");
        RWNXFEFIQSTATCOEFF14_reg.configure(this);
        RWNXFEFIQSTATCOEFF14_reg.build();

        RWNXFEFIQSTATCOEFF15_reg = RWNXFEFIQSTATCOEFF15::type_id::create("RWNXFEFIQSTATCOEFF15");
        RWNXFEFIQSTATCOEFF15_reg.configure(this);
        RWNXFEFIQSTATCOEFF15_reg.build();

        RWNXFEFIQSTATCOEFF16_reg = RWNXFEFIQSTATCOEFF16::type_id::create("RWNXFEFIQSTATCOEFF16");
        RWNXFEFIQSTATCOEFF16_reg.configure(this);
        RWNXFEFIQSTATCOEFF16_reg.build();

        RWNXFEFIQSTATCOEFF17_reg = RWNXFEFIQSTATCOEFF17::type_id::create("RWNXFEFIQSTATCOEFF17");
        RWNXFEFIQSTATCOEFF17_reg.configure(this);
        RWNXFEFIQSTATCOEFF17_reg.build();

        RWNXFEFIQSTATCOEFF18_reg = RWNXFEFIQSTATCOEFF18::type_id::create("RWNXFEFIQSTATCOEFF18");
        RWNXFEFIQSTATCOEFF18_reg.configure(this);
        RWNXFEFIQSTATCOEFF18_reg.build();

        RWNXFEFIQSTATCOEFF19_reg = RWNXFEFIQSTATCOEFF19::type_id::create("RWNXFEFIQSTATCOEFF19");
        RWNXFEFIQSTATCOEFF19_reg.configure(this);
        RWNXFEFIQSTATCOEFF19_reg.build();

        RWNXAGCANTLOSS_reg = RWNXAGCANTLOSS::type_id::create("RWNXAGCANTLOSS");
        RWNXAGCANTLOSS_reg.configure(this);
        RWNXAGCANTLOSS_reg.build();

        RWNXAGCGAINRANGE_reg = RWNXAGCGAINRANGE::type_id::create("RWNXAGCGAINRANGE");
        RWNXAGCGAINRANGE_reg.configure(this);
        RWNXAGCGAINRANGE_reg.build();

        RWNXAGCDIGGAINCONF_reg = RWNXAGCDIGGAINCONF::type_id::create("RWNXAGCDIGGAINCONF");
        RWNXAGCDIGGAINCONF_reg.configure(this);
        RWNXAGCDIGGAINCONF_reg.build();

        RWNXAGCNOISECONF_reg = RWNXAGCNOISECONF::type_id::create("RWNXAGCNOISECONF");
        RWNXAGCNOISECONF_reg.configure(this);
        RWNXAGCNOISECONF_reg.build();

        RWNXAGCACI20MARG0_reg = RWNXAGCACI20MARG0::type_id::create("RWNXAGCACI20MARG0");
        RWNXAGCACI20MARG0_reg.configure(this);
        RWNXAGCACI20MARG0_reg.build();

        RWNXAGCACI20MARG1_reg = RWNXAGCACI20MARG1::type_id::create("RWNXAGCACI20MARG1");
        RWNXAGCACI20MARG1_reg.configure(this);
        RWNXAGCACI20MARG1_reg.build();

        RWNXAGCACI20MARG2_reg = RWNXAGCACI20MARG2::type_id::create("RWNXAGCACI20MARG2");
        RWNXAGCACI20MARG2_reg.configure(this);
        RWNXAGCACI20MARG2_reg.build();

        RWNXAGCACI40MARG0_reg = RWNXAGCACI40MARG0::type_id::create("RWNXAGCACI40MARG0");
        RWNXAGCACI40MARG0_reg.configure(this);
        RWNXAGCACI40MARG0_reg.build();

        RWNXAGCACI40MARG1_reg = RWNXAGCACI40MARG1::type_id::create("RWNXAGCACI40MARG1");
        RWNXAGCACI40MARG1_reg.configure(this);
        RWNXAGCACI40MARG1_reg.build();

        RWNXAGCACI40MARG2_reg = RWNXAGCACI40MARG2::type_id::create("RWNXAGCACI40MARG2");
        RWNXAGCACI40MARG2_reg.configure(this);
        RWNXAGCACI40MARG2_reg.build();

        RWNXAGCACI80MARG0_reg = RWNXAGCACI80MARG0::type_id::create("RWNXAGCACI80MARG0");
        RWNXAGCACI80MARG0_reg.configure(this);
        RWNXAGCACI80MARG0_reg.build();

        RWNXAGCACI80MARG1_reg = RWNXAGCACI80MARG1::type_id::create("RWNXAGCACI80MARG1");
        RWNXAGCACI80MARG1_reg.configure(this);
        RWNXAGCACI80MARG1_reg.build();

        RWNXAGCACI80MARG2_reg = RWNXAGCACI80MARG2::type_id::create("RWNXAGCACI80MARG2");
        RWNXAGCACI80MARG2_reg.configure(this);
        RWNXAGCACI80MARG2_reg.build();

        RWNXAGCSAT_reg = RWNXAGCSAT::type_id::create("RWNXAGCSAT");
        RWNXAGCSAT_reg.configure(this);
        RWNXAGCSAT_reg.build();

        RWNXAGCCROSS_reg = RWNXAGCCROSS::type_id::create("RWNXAGCCROSS");
        RWNXAGCCROSS_reg.configure(this);
        RWNXAGCCROSS_reg.build();

        RWNXAGCRAMP_reg = RWNXAGCRAMP::type_id::create("RWNXAGCRAMP");
        RWNXAGCRAMP_reg.configure(this);
        RWNXAGCRAMP_reg.build();

        RWNXAGCSTABDIS_reg = RWNXAGCSTABDIS::type_id::create("RWNXAGCSTABDIS");
        RWNXAGCSTABDIS_reg.configure(this);
        RWNXAGCSTABDIS_reg.build();

        RWNXAGCDCCOMP0_reg = RWNXAGCDCCOMP0::type_id::create("RWNXAGCDCCOMP0");
        RWNXAGCDCCOMP0_reg.configure(this);
        RWNXAGCDCCOMP0_reg.build();

        RWNXAGCDCCOMP1_reg = RWNXAGCDCCOMP1::type_id::create("RWNXAGCDCCOMP1");
        RWNXAGCDCCOMP1_reg.configure(this);
        RWNXAGCDCCOMP1_reg.build();

        RWNXAGCDCCOMP2_reg = RWNXAGCDCCOMP2::type_id::create("RWNXAGCDCCOMP2");
        RWNXAGCDCCOMP2_reg.configure(this);
        RWNXAGCDCCOMP2_reg.build();

        RWNXAGCEVT0_reg = RWNXAGCEVT0::type_id::create("RWNXAGCEVT0");
        RWNXAGCEVT0_reg.configure(this);
        RWNXAGCEVT0_reg.build();

        RWNXAGCEVT1_reg = RWNXAGCEVT1::type_id::create("RWNXAGCEVT1");
        RWNXAGCEVT1_reg.configure(this);
        RWNXAGCEVT1_reg.build();

        RWNXAGCEVT2_reg = RWNXAGCEVT2::type_id::create("RWNXAGCEVT2");
        RWNXAGCEVT2_reg.configure(this);
        RWNXAGCEVT2_reg.build();

        RWNXAGCEVT3_reg = RWNXAGCEVT3::type_id::create("RWNXAGCEVT3");
        RWNXAGCEVT3_reg.configure(this);
        RWNXAGCEVT3_reg.build();

        RWNXAGCCNTL_reg = RWNXAGCCNTL::type_id::create("RWNXAGCCNTL");
        RWNXAGCCNTL_reg.configure(this);
        RWNXAGCCNTL_reg.build();

        RWNXAGCDSP0_reg = RWNXAGCDSP0::type_id::create("RWNXAGCDSP0");
        RWNXAGCDSP0_reg.configure(this);
        RWNXAGCDSP0_reg.build();

        RWNXAGCDSP1_reg = RWNXAGCDSP1::type_id::create("RWNXAGCDSP1");
        RWNXAGCDSP1_reg.configure(this);
        RWNXAGCDSP1_reg.build();

        RWNXAGCDSP2_reg = RWNXAGCDSP2::type_id::create("RWNXAGCDSP2");
        RWNXAGCDSP2_reg.configure(this);
        RWNXAGCDSP2_reg.build();

        RWNXAGCDSP3_reg = RWNXAGCDSP3::type_id::create("RWNXAGCDSP3");
        RWNXAGCDSP3_reg.configure(this);
        RWNXAGCDSP3_reg.build();

        RWNXAGCDSP4_reg = RWNXAGCDSP4::type_id::create("RWNXAGCDSP4");
        RWNXAGCDSP4_reg.configure(this);
        RWNXAGCDSP4_reg.build();

        RWNXAGCCCA0_reg = RWNXAGCCCA0::type_id::create("RWNXAGCCCA0");
        RWNXAGCCCA0_reg.configure(this);
        RWNXAGCCCA0_reg.build();

        RWNXAGCCCA1_reg = RWNXAGCCCA1::type_id::create("RWNXAGCCCA1");
        RWNXAGCCCA1_reg.configure(this);
        RWNXAGCCCA1_reg.build();

        RWNXAGCCCACTRL_reg = RWNXAGCCCACTRL::type_id::create("RWNXAGCCCACTRL");
        RWNXAGCCCACTRL_reg.configure(this);
        RWNXAGCCCACTRL_reg.build();

        RWNXAGCCCASTATE0_reg = RWNXAGCCCASTATE0::type_id::create("RWNXAGCCCASTATE0");
        RWNXAGCCCASTATE0_reg.configure(this);
        RWNXAGCCCASTATE0_reg.build();

        RWNXAGCCCASTATE1_reg = RWNXAGCCCASTATE1::type_id::create("RWNXAGCCCASTATE1");
        RWNXAGCCCASTATE1_reg.configure(this);
        RWNXAGCCCASTATE1_reg.build();

        RWNXAGCCCATIMEOUT_reg = RWNXAGCCCATIMEOUT::type_id::create("RWNXAGCCCATIMEOUT");
        RWNXAGCCCATIMEOUT_reg.configure(this);
        RWNXAGCCCATIMEOUT_reg.build();

        RWNXAGCCOMP0_reg = RWNXAGCCOMP0::type_id::create("RWNXAGCCOMP0");
        RWNXAGCCOMP0_reg.configure(this);
        RWNXAGCCOMP0_reg.build();

        RWNXAGCCOMP1_reg = RWNXAGCCOMP1::type_id::create("RWNXAGCCOMP1");
        RWNXAGCCOMP1_reg.configure(this);
        RWNXAGCCOMP1_reg.build();

        RWNXAGCRADAR_reg = RWNXAGCRADAR::type_id::create("RWNXAGCRADAR");
        RWNXAGCRADAR_reg.configure(this);
        RWNXAGCRADAR_reg.build();

        RWNXAGCRADARTIM_reg = RWNXAGCRADARTIM::type_id::create("RWNXAGCRADARTIM");
        RWNXAGCRADARTIM_reg.configure(this);
        RWNXAGCRADARTIM_reg.build();

        RWNXAGCDCCOMPRADAR_reg = RWNXAGCDCCOMPRADAR::type_id::create("RWNXAGCDCCOMPRADAR");
        RWNXAGCDCCOMPRADAR_reg.configure(this);
        RWNXAGCDCCOMPRADAR_reg.build();

        RWNXAGCCCA2_reg = RWNXAGCCCA2::type_id::create("RWNXAGCCCA2");
        RWNXAGCCCA2_reg.configure(this);
        RWNXAGCCCA2_reg.build();

        RWNXAGCCCA3_reg = RWNXAGCCCA3::type_id::create("RWNXAGCCCA3");
        RWNXAGCCCA3_reg.configure(this);
        RWNXAGCCCA3_reg.build();

        RWNXMACINTEN_reg = RWNXMACINTEN::type_id::create("RWNXMACINTEN");
        RWNXMACINTEN_reg.configure(this);
        RWNXMACINTEN_reg.build();

        RWNXMACINTSTATRAW_reg = RWNXMACINTSTATRAW::type_id::create("RWNXMACINTSTATRAW");
        RWNXMACINTSTATRAW_reg.configure(this);
        RWNXMACINTSTATRAW_reg.build();

        RWNXMACINTSTATMASKED_reg = RWNXMACINTSTATMASKED::type_id::create("RWNXMACINTSTATMASKED");
        RWNXMACINTSTATMASKED_reg.configure(this);
        RWNXMACINTSTATMASKED_reg.build();

        RWNXMACINTACK_reg = RWNXMACINTACK::type_id::create("RWNXMACINTACK");
        RWNXMACINTACK_reg.configure(this);
        RWNXMACINTACK_reg.build();

        RWNXMACINTGEN_reg = RWNXMACINTGEN::type_id::create("RWNXMACINTGEN");
        RWNXMACINTGEN_reg.configure(this);
        RWNXMACINTGEN_reg.build();

        RWNXFEDSSSCCKCNTL_reg = RWNXFEDSSSCCKCNTL::type_id::create("RWNXFEDSSSCCKCNTL");
        RWNXFEDSSSCCKCNTL_reg.configure(this);
        RWNXFEDSSSCCKCNTL_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        RIUKARST_register_map = create_map("RIUKARST_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        RIUKARST_register_map.add_reg(RWNXVERSION_reg, 'h0, "RO");
        RIUKARST_register_map.add_reg(RWNXSTATICCONFIG_reg, 'h4, "RW");
        RIUKARST_register_map.add_reg(RWNXDYNAMICCONFIG_reg, 'h8, "RW");
        RIUKARST_register_map.add_reg(RWNXIQCTRL_reg, 'h1C, "RW");
        RIUKARST_register_map.add_reg(RWNXMACSTATICCONFIG_reg, 'h80, "RW");
        RIUKARST_register_map.add_reg(RWNXFECTRL0_reg, 'h100, "RW");
        RIUKARST_register_map.add_reg(RWNXFECTRL1_reg, 'h104, "RW");
        RIUKARST_register_map.add_reg(RWNXFETXIQCOMP0_reg, 'h108, "RW");
        RIUKARST_register_map.add_reg(RWNXFETXIQCOMP1_reg, 'h10C, "RW");
        RIUKARST_register_map.add_reg(RWNXFERXIQESTCTRL_reg, 'h110, "RW");
        RIUKARST_register_map.add_reg(RWNXFERXIQESTLOOP_reg, 'h114, "RW");
        RIUKARST_register_map.add_reg(RWNXFERXIQESTCLR_reg, 'h118, "RW");
        RIUKARST_register_map.add_reg(RWNXFERXIQCOMP0_reg, 'h11C, "RW");
        RIUKARST_register_map.add_reg(RWNXFERXIQCOMP1_reg, 'h120, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCTRL_reg, 'h124, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOLL_reg, 'h128, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQEST0_reg, 'h12C, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQEST1_reg, 'h130, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQDEL_reg, 'h134, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF0_reg, 'h138, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF1_reg, 'h13C, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF2_reg, 'h140, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF3_reg, 'h144, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF4_reg, 'h148, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF5_reg, 'h14C, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF6_reg, 'h150, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF7_reg, 'h154, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF8_reg, 'h158, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF9_reg, 'h15C, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF10_reg, 'h160, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF11_reg, 'h164, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF12_reg, 'h168, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF13_reg, 'h16C, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF14_reg, 'h170, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF15_reg, 'h174, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF16_reg, 'h178, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF17_reg, 'h17C, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF18_reg, 'h180, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFF19_reg, 'h184, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFFUPDATE_reg, 'h188, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQCOEFFREQ_reg, 'h18C, "RW");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTART_reg, 'h190, "RW");
        RIUKARST_register_map.add_reg(AGCGAINSTAT_reg, 'h200, "RO");
        RIUKARST_register_map.add_reg(AGCADCPOWSTAT_reg, 'h208, "RO");
        RIUKARST_register_map.add_reg(AGCINBDPOW20PSTAT_reg, 'h20C, "RO");
        RIUKARST_register_map.add_reg(AGCDIGGAIN0STAT_reg, 'h210, "RO");
        RIUKARST_register_map.add_reg(AGCDIGGAIN1STAT_reg, 'h214, "RO");
        RIUKARST_register_map.add_reg(RADARFIFOSTAT_reg, 'h220, "RO");
        RIUKARST_register_map.add_reg(AGCINBDPOW20PNOISESTAT_reg, 'h228, "RO");
        RIUKARST_register_map.add_reg(AGCINBDPOWSECSTAT_reg, 'h22C, "RO");
        RIUKARST_register_map.add_reg(AGCINBDPOWSECNOISESTAT_reg, 'h230, "RO");
        RIUKARST_register_map.add_reg(RWNXFERXIQSTATVARI0_reg, 'h240, "RO");
        RIUKARST_register_map.add_reg(RWNXFERXIQSTATVARQ0_reg, 'h244, "RO");
        RIUKARST_register_map.add_reg(RWNXFERXIQSTATMIQ0_reg, 'h248, "RO");
        RIUKARST_register_map.add_reg(RWNXFERXIQSTAT0_reg, 'h24C, "RO");
        RIUKARST_register_map.add_reg(RWNXFERXIQSTATVARI1_reg, 'h250, "RO");
        RIUKARST_register_map.add_reg(RWNXFERXIQSTATVARQ1_reg, 'h254, "RO");
        RIUKARST_register_map.add_reg(RWNXFERXIQSTATMIQ1_reg, 'h258, "RO");
        RIUKARST_register_map.add_reg(RWNXFERXIQSTAT1_reg, 'h25C, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQDONE_reg, 'h260, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTAT0_reg, 'h264, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTAT1_reg, 'h268, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF0_reg, 'h26C, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF1_reg, 'h270, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF2_reg, 'h274, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF3_reg, 'h278, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF4_reg, 'h27C, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF5_reg, 'h280, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF6_reg, 'h284, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF7_reg, 'h288, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF8_reg, 'h28C, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF9_reg, 'h290, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF10_reg, 'h294, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF11_reg, 'h298, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF12_reg, 'h29C, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF13_reg, 'h2A0, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF14_reg, 'h2A4, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF15_reg, 'h2A8, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF16_reg, 'h2AC, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF17_reg, 'h2B0, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF18_reg, 'h2B4, "RO");
        RIUKARST_register_map.add_reg(RWNXFEFIQSTATCOEFF19_reg, 'h2B8, "RO");
        RIUKARST_register_map.add_reg(RWNXAGCANTLOSS_reg, 'h300, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCGAINRANGE_reg, 'h304, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCDIGGAINCONF_reg, 'h308, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCNOISECONF_reg, 'h30C, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCACI20MARG0_reg, 'h340, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCACI20MARG1_reg, 'h344, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCACI20MARG2_reg, 'h348, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCACI40MARG0_reg, 'h34C, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCACI40MARG1_reg, 'h350, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCACI40MARG2_reg, 'h354, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCACI80MARG0_reg, 'h358, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCACI80MARG1_reg, 'h35C, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCACI80MARG2_reg, 'h360, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCSAT_reg, 'h364, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCROSS_reg, 'h368, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCRAMP_reg, 'h36C, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCSTABDIS_reg, 'h370, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCDCCOMP0_reg, 'h374, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCDCCOMP1_reg, 'h378, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCDCCOMP2_reg, 'h37C, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCEVT0_reg, 'h380, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCEVT1_reg, 'h384, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCEVT2_reg, 'h388, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCEVT3_reg, 'h38C, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCNTL_reg, 'h390, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCDSP0_reg, 'h394, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCDSP1_reg, 'h398, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCDSP2_reg, 'h39C, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCDSP3_reg, 'h3A0, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCDSP4_reg, 'h3A4, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCCA0_reg, 'h3A8, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCCA1_reg, 'h3AC, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCCACTRL_reg, 'h3B0, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCCASTATE0_reg, 'h3B4, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCCASTATE1_reg, 'h3B8, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCCATIMEOUT_reg, 'h3BC, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCOMP0_reg, 'h3C0, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCOMP1_reg, 'h3C4, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCRADAR_reg, 'h3C8, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCRADARTIM_reg, 'h3CC, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCDCCOMPRADAR_reg, 'h3D0, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCCA2_reg, 'h3D4, "RW");
        RIUKARST_register_map.add_reg(RWNXAGCCCA3_reg, 'h3D8, "RW");
        RIUKARST_register_map.add_reg(RWNXMACINTEN_reg, 'h414, "RW");
        RIUKARST_register_map.add_reg(RWNXMACINTSTATRAW_reg, 'h418, "RO");
        RIUKARST_register_map.add_reg(RWNXMACINTSTATMASKED_reg, 'h41C, "RO");
        RIUKARST_register_map.add_reg(RWNXMACINTACK_reg, 'h420, "RW");
        RIUKARST_register_map.add_reg(RWNXMACINTGEN_reg, 'h424, "RW");
        RIUKARST_register_map.add_reg(RWNXFEDSSSCCKCNTL_reg, 'h500, "RW");

        // Lock the register model and build the map
        lock_model();
        RIUKARST_register_map.set_check_on_read();
    endfunction

endclass
`endif // __RIUKARST_REG_BLOCK_SV__
