//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : rblanc
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35564 $
// $Date: 2018-10-08 14:33:27 +0200 (Mon, 08 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : UVM RAL register block for SYSCTRL
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
///////////////////////////////////////////////////////////////////////////////

`ifndef __SYSCTRL_REG_BLOCK_SV__
`define __SYSCTRL_REG_BLOCK_SV__

//--------------------------------------------------------------------
// SIGNATURE
//--------------------------------------------------------------------
class SIGNATURE extends uvm_reg;
    `uvm_object_utils(SIGNATURE)
    rand uvm_reg_field fpga_signature;

    //---build------------------------------------------------------------
    virtual function void build();
        fpga_signature = uvm_reg_field::type_id::create("fpga_signature");

        fpga_signature.configure(this, 32, 0, "RO", 1, `RW_FPGA_SIGNATURE, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_SIGNATURE_rd_cg";
        fpga_signature_rd : coverpoint fpga_signature.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SIGNATURE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DATE
//--------------------------------------------------------------------
class DATE extends uvm_reg;
    `uvm_object_utils(DATE)
    rand uvm_reg_field fpga_date;

    //---build------------------------------------------------------------
    virtual function void build();
        fpga_date = uvm_reg_field::type_id::create("fpga_date");

        fpga_date.configure(this, 32, 0, "RO", 1, `RW_FPGA_DATE, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DATE_rd_cg";
        fpga_date_rd : coverpoint fpga_date.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DATE");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIME
//--------------------------------------------------------------------
class TIME extends uvm_reg;
    `uvm_object_utils(TIME)
    rand uvm_reg_field fpga_time;

    //---build------------------------------------------------------------
    virtual function void build();
        fpga_time = uvm_reg_field::type_id::create("fpga_time");

        fpga_time.configure(this, 32, 0, "RO", 1, `RW_FPGA_TIME, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TIME_rd_cg";
        fpga_time_rd : coverpoint fpga_time.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIME");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SVNREV_MAC
//--------------------------------------------------------------------
class SVNREV_MAC extends uvm_reg;
    `uvm_object_utils(SVNREV_MAC)
    rand uvm_reg_field svnrev_mac;

    //---build------------------------------------------------------------
    virtual function void build();
        svnrev_mac = uvm_reg_field::type_id::create("svnrev_mac");

        svnrev_mac.configure(this, 32, 0, "RO", 1, `RW_MAC_SVNREV, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_SVNREV_MAC_rd_cg";
        svnrev_mac_rd : coverpoint svnrev_mac.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SVNREV_MAC");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SVNREV_FPGAA
//--------------------------------------------------------------------
class SVNREV_FPGAA extends uvm_reg;
    `uvm_object_utils(SVNREV_FPGAA)
    rand uvm_reg_field svnrev_fpgaa;

    //---build------------------------------------------------------------
    virtual function void build();
        svnrev_fpgaa = uvm_reg_field::type_id::create("svnrev_fpgaa");

        svnrev_fpgaa.configure(this, 32, 0, "RO", 1, `RW_FPGA_SVNREV, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_SVNREV_FPGAA_rd_cg";
        svnrev_fpgaa_rd : coverpoint svnrev_fpgaa.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SVNREV_FPGAA");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TIMER
//--------------------------------------------------------------------
class TIMER extends uvm_reg;
    `uvm_object_utils(TIMER)
    rand uvm_reg_field timer_value;

    //---build------------------------------------------------------------
    virtual function void build();
        timer_value = uvm_reg_field::type_id::create("timer_value");

        timer_value.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TIMER_wr_cg";
        timer_value_wr : coverpoint timer_value.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TIMER_rd_cg";
        timer_value_rd : coverpoint timer_value.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TIMER");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TICK_TIMER_CNT
//--------------------------------------------------------------------
class TICK_TIMER_CNT extends uvm_reg;
    `uvm_object_utils(TICK_TIMER_CNT)
    rand uvm_reg_field tick_timer_cnt;

    //---build------------------------------------------------------------
    virtual function void build();
        tick_timer_cnt = uvm_reg_field::type_id::create("tick_timer_cnt");

        tick_timer_cnt.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TICK_TIMER_CNT_wr_cg";
        tick_timer_cnt_wr : coverpoint tick_timer_cnt.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TICK_TIMER_CNT_rd_cg";
        tick_timer_cnt_rd : coverpoint tick_timer_cnt.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TICK_TIMER_CNT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TICK_TIMER_DURATION
//--------------------------------------------------------------------
class TICK_TIMER_DURATION extends uvm_reg;
    `uvm_object_utils(TICK_TIMER_DURATION)
    rand uvm_reg_field tick_timer_duration;

    //---build------------------------------------------------------------
    virtual function void build();
        tick_timer_duration = uvm_reg_field::type_id::create("tick_timer_duration");

        tick_timer_duration.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TICK_TIMER_DURATION_wr_cg";
        tick_timer_duration_wr : coverpoint tick_timer_duration.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TICK_TIMER_DURATION_rd_cg";
        tick_timer_duration_rd : coverpoint tick_timer_duration.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TICK_TIMER_DURATION");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TICK_TIMER_IRQ_SET
//--------------------------------------------------------------------
class TICK_TIMER_IRQ_SET extends uvm_reg;
    `uvm_object_utils(TICK_TIMER_IRQ_SET)
    rand uvm_reg_field tick_timer_irq;

    //---build------------------------------------------------------------
    virtual function void build();
        tick_timer_irq = uvm_reg_field::type_id::create("tick_timer_irq");

        tick_timer_irq.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TICK_TIMER_IRQ_SET_wr_cg";
        tick_timer_irq_wr : coverpoint tick_timer_irq.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TICK_TIMER_IRQ_SET");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TICK_TIMER_IRQ_CLEAR
//--------------------------------------------------------------------
class TICK_TIMER_IRQ_CLEAR extends uvm_reg;
    `uvm_object_utils(TICK_TIMER_IRQ_CLEAR)
    rand uvm_reg_field tick_timer_irq;

    //---build------------------------------------------------------------
    virtual function void build();
        tick_timer_irq = uvm_reg_field::type_id::create("tick_timer_irq");

        tick_timer_irq.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TICK_TIMER_IRQ_CLEAR_wr_cg";
        tick_timer_irq_wr : coverpoint tick_timer_irq.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TICK_TIMER_IRQ_CLEAR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// TICK_TIMER_IRQ_CONTROL
//--------------------------------------------------------------------
class TICK_TIMER_IRQ_CONTROL extends uvm_reg;
    `uvm_object_utils(TICK_TIMER_IRQ_CONTROL)
    rand uvm_reg_field tick_timer_en;
    rand uvm_reg_field tick_timer_irq_en;

    //---build------------------------------------------------------------
    virtual function void build();
        tick_timer_en = uvm_reg_field::type_id::create("tick_timer_en");
        tick_timer_irq_en = uvm_reg_field::type_id::create("tick_timer_irq_en");

        tick_timer_en.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        tick_timer_irq_en.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TICK_TIMER_IRQ_CONTROL_wr_cg";
        tick_timer_en_wr : coverpoint tick_timer_en.value[0:0];
        tick_timer_irq_en_wr : coverpoint tick_timer_irq_en.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_TICK_TIMER_IRQ_CONTROL_rd_cg";
        tick_timer_en_rd : coverpoint tick_timer_en.value[0:0];
        tick_timer_irq_en_rd : coverpoint tick_timer_irq_en.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "TICK_TIMER_IRQ_CONTROL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SOFT_IRQ_SET
//--------------------------------------------------------------------
class SOFT_IRQ_SET extends uvm_reg;
    `uvm_object_utils(SOFT_IRQ_SET)
    rand uvm_reg_field soft_irq;

    //---build------------------------------------------------------------
    virtual function void build();
        soft_irq = uvm_reg_field::type_id::create("soft_irq");

        soft_irq.configure(this, 1, 0, "W1S", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_SOFT_IRQ_SET_wr_cg";
        soft_irq_wr : coverpoint soft_irq.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SOFT_IRQ_SET");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// SOFT_IRQ_CLEAR
//--------------------------------------------------------------------
class SOFT_IRQ_CLEAR extends uvm_reg;
    `uvm_object_utils(SOFT_IRQ_CLEAR)
    rand uvm_reg_field soft_irq;

    //---build------------------------------------------------------------
    virtual function void build();
        soft_irq = uvm_reg_field::type_id::create("soft_irq");

        soft_irq.configure(this, 1, 0, "W1C", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_SOFT_IRQ_CLEAR_wr_cg";
        soft_irq_wr : coverpoint soft_irq.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "SOFT_IRQ_CLEAR");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DIAG_CONF0
//--------------------------------------------------------------------
class DIAG_CONF0 extends uvm_reg;
    `uvm_object_utils(DIAG_CONF0)
    rand uvm_reg_field diag_presel1;
    rand uvm_reg_field diag_sel1;
    rand uvm_reg_field diag_presel0;
    rand uvm_reg_field diag_sel0;

    //---build------------------------------------------------------------
    virtual function void build();
        diag_presel1 = uvm_reg_field::type_id::create("diag_presel1");
        diag_sel1 = uvm_reg_field::type_id::create("diag_sel1");
        diag_presel0 = uvm_reg_field::type_id::create("diag_presel0");
        diag_sel0 = uvm_reg_field::type_id::create("diag_sel0");

        diag_presel1.configure(this, 6, 24, "RW", 1, 'b100001, 1, 1, 1);
        diag_sel1.configure(this, 2, 16, "RW", 1, 'b0, 1, 1, 1);
        diag_presel0.configure(this, 6, 8, "RW", 1, 'b100000, 1, 1, 1);
        diag_sel0.configure(this, 2, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_CONF0_wr_cg";
        diag_presel1_wr : coverpoint diag_presel1.value[5:0];
        diag_sel1_wr : coverpoint diag_sel1.value[1:0];
        diag_presel0_wr : coverpoint diag_presel0.value[5:0];
        diag_sel0_wr : coverpoint diag_sel0.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_CONF0_rd_cg";
        diag_presel1_rd : coverpoint diag_presel1.value[5:0];
        diag_sel1_rd : coverpoint diag_sel1.value[1:0];
        diag_presel0_rd : coverpoint diag_presel0.value[5:0];
        diag_sel0_rd : coverpoint diag_sel0.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DIAG_CONF0");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DIAG_CONF1
//--------------------------------------------------------------------
class DIAG_CONF1 extends uvm_reg;
    `uvm_object_utils(DIAG_CONF1)
    rand uvm_reg_field diag_sel_en;
    rand uvm_reg_field diag_presel3;
    rand uvm_reg_field diag_sel3;
    rand uvm_reg_field diag_mux;
    rand uvm_reg_field diag_presel2;
    rand uvm_reg_field diag_sel2;

    //---build------------------------------------------------------------
    virtual function void build();
        diag_sel_en = uvm_reg_field::type_id::create("diag_sel_en");
        diag_presel3 = uvm_reg_field::type_id::create("diag_presel3");
        diag_sel3 = uvm_reg_field::type_id::create("diag_sel3");
        diag_mux = uvm_reg_field::type_id::create("diag_mux");
        diag_presel2 = uvm_reg_field::type_id::create("diag_presel2");
        diag_sel2 = uvm_reg_field::type_id::create("diag_sel2");

        diag_sel_en.configure(this, 1, 31, "RW", 1, 'b0, 1, 1, 1);
        diag_presel3.configure(this, 6, 24, "RW", 1, 'b100101, 1, 1, 1);
        diag_sel3.configure(this, 2, 16, "RW", 1, 'b1, 1, 1, 1);
        diag_mux.configure(this, 1, 15, "RW", 1, 'b0, 1, 1, 1);
        diag_presel2.configure(this, 6, 8, "RW", 1, 'b11100, 1, 1, 1);
        diag_sel2.configure(this, 2, 0, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_CONF1_wr_cg";
        diag_sel_en_wr : coverpoint diag_sel_en.value[0:0];
        diag_presel3_wr : coverpoint diag_presel3.value[5:0];
        diag_sel3_wr : coverpoint diag_sel3.value[1:0];
        diag_mux_wr : coverpoint diag_mux.value[0:0];
        diag_presel2_wr : coverpoint diag_presel2.value[5:0];
        diag_sel2_wr : coverpoint diag_sel2.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_CONF1_rd_cg";
        diag_sel_en_rd : coverpoint diag_sel_en.value[0:0];
        diag_presel3_rd : coverpoint diag_presel3.value[5:0];
        diag_sel3_rd : coverpoint diag_sel3.value[1:0];
        diag_mux_rd : coverpoint diag_mux.value[0:0];
        diag_presel2_rd : coverpoint diag_presel2.value[5:0];
        diag_sel2_rd : coverpoint diag_sel2.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DIAG_CONF1");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DIAG_STAT
//--------------------------------------------------------------------
class DIAG_STAT extends uvm_reg;
    `uvm_object_utils(DIAG_STAT)
    rand uvm_reg_field diag_value;

    //---build------------------------------------------------------------
    virtual function void build();
        diag_value = uvm_reg_field::type_id::create("diag_value");

        diag_value.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_STAT_rd_cg";
        diag_value_rd : coverpoint diag_value.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DIAG_STAT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DIAG_TRIGGER
//--------------------------------------------------------------------
class DIAG_TRIGGER extends uvm_reg;
    `uvm_object_utils(DIAG_TRIGGER)
    rand uvm_reg_field diag_trigger;

    //---build------------------------------------------------------------
    virtual function void build();
        diag_trigger = uvm_reg_field::type_id::create("diag_trigger");

        diag_trigger.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_TRIGGER_wr_cg";
        diag_trigger_wr : coverpoint diag_trigger.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_TRIGGER_rd_cg";
        diag_trigger_rd : coverpoint diag_trigger.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DIAG_TRIGGER");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DIAG_CONF2
//--------------------------------------------------------------------
class DIAG_CONF2 extends uvm_reg;
    `uvm_object_utils(DIAG_CONF2)
    rand uvm_reg_field diag_presel5;
    rand uvm_reg_field diag_sel5;
    rand uvm_reg_field diag_presel4;
    rand uvm_reg_field diag_sel4;

    //---build------------------------------------------------------------
    virtual function void build();
        diag_presel5 = uvm_reg_field::type_id::create("diag_presel5");
        diag_sel5 = uvm_reg_field::type_id::create("diag_sel5");
        diag_presel4 = uvm_reg_field::type_id::create("diag_presel4");
        diag_sel4 = uvm_reg_field::type_id::create("diag_sel4");

        diag_presel5.configure(this, 6, 24, "RW", 1, 'b11111, 1, 1, 1);
        diag_sel5.configure(this, 2, 16, "RW", 1, 'b1, 1, 1, 1);
        diag_presel4.configure(this, 6, 8, "RW", 1, 'b11110, 1, 1, 1);
        diag_sel4.configure(this, 2, 0, "RW", 1, 'b1, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_CONF2_wr_cg";
        diag_presel5_wr : coverpoint diag_presel5.value[5:0];
        diag_sel5_wr : coverpoint diag_sel5.value[1:0];
        diag_presel4_wr : coverpoint diag_presel4.value[5:0];
        diag_sel4_wr : coverpoint diag_sel4.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_CONF2_rd_cg";
        diag_presel5_rd : coverpoint diag_presel5.value[5:0];
        diag_sel5_rd : coverpoint diag_sel5.value[1:0];
        diag_presel4_rd : coverpoint diag_presel4.value[5:0];
        diag_sel4_rd : coverpoint diag_sel4.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DIAG_CONF2");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DIAG_CONF3
//--------------------------------------------------------------------
class DIAG_CONF3 extends uvm_reg;
    `uvm_object_utils(DIAG_CONF3)
    rand uvm_reg_field diag_presel6;
    rand uvm_reg_field diag_sel6;

    //---build------------------------------------------------------------
    virtual function void build();
        diag_presel6 = uvm_reg_field::type_id::create("diag_presel6");
        diag_sel6 = uvm_reg_field::type_id::create("diag_sel6");

        diag_presel6.configure(this, 6, 8, "RW", 1, 'b100110, 1, 1, 1);
        diag_sel6.configure(this, 2, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_CONF3_wr_cg";
        diag_presel6_wr : coverpoint diag_presel6.value[5:0];
        diag_sel6_wr : coverpoint diag_sel6.value[1:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_CONF3_rd_cg";
        diag_presel6_rd : coverpoint diag_presel6.value[5:0];
        diag_sel6_rd : coverpoint diag_sel6.value[1:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DIAG_CONF3");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// DIAG_MPIF_CONF
//--------------------------------------------------------------------
class DIAG_MPIF_CONF extends uvm_reg;
    `uvm_object_utils(DIAG_MPIF_CONF)
    rand uvm_reg_field diag_mpif_hdr_nbr;
    rand uvm_reg_field diag_mpif_mask_en;

    //---build------------------------------------------------------------
    virtual function void build();
        diag_mpif_hdr_nbr = uvm_reg_field::type_id::create("diag_mpif_hdr_nbr");
        diag_mpif_mask_en = uvm_reg_field::type_id::create("diag_mpif_mask_en");

        diag_mpif_hdr_nbr.configure(this, 6, 4, "RW", 1, 'b00000, 1, 1, 1);
        diag_mpif_mask_en.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_MPIF_CONF_wr_cg";
        diag_mpif_hdr_nbr_wr : coverpoint diag_mpif_hdr_nbr.value[5:0];
        diag_mpif_mask_en_wr : coverpoint diag_mpif_mask_en.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_DIAG_MPIF_CONF_rd_cg";
        diag_mpif_hdr_nbr_rd : coverpoint diag_mpif_hdr_nbr.value[5:0];
        diag_mpif_mask_en_rd : coverpoint diag_mpif_mask_en.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "DIAG_MPIF_CONF");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// GPIO_OEN
//--------------------------------------------------------------------
class GPIO_OEN extends uvm_reg;
    `uvm_object_utils(GPIO_OEN)
    rand uvm_reg_field gpio_oen;

    //---build------------------------------------------------------------
    virtual function void build();
        gpio_oen = uvm_reg_field::type_id::create("gpio_oen");

        gpio_oen.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_GPIO_OEN_wr_cg";
        gpio_oen_wr : coverpoint gpio_oen.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_GPIO_OEN_rd_cg";
        gpio_oen_rd : coverpoint gpio_oen.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "GPIO_OEN");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// GPIO_OUT
//--------------------------------------------------------------------
class GPIO_OUT extends uvm_reg;
    `uvm_object_utils(GPIO_OUT)
    rand uvm_reg_field gpio_out;

    //---build------------------------------------------------------------
    virtual function void build();
        gpio_out = uvm_reg_field::type_id::create("gpio_out");

        gpio_out.configure(this, 32, 0, "RW", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_GPIO_OUT_wr_cg";
        gpio_out_wr : coverpoint gpio_out.value[31:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_GPIO_OUT_rd_cg";
        gpio_out_rd : coverpoint gpio_out.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "GPIO_OUT");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// GPIO_IN
//--------------------------------------------------------------------
class GPIO_IN extends uvm_reg;
    `uvm_object_utils(GPIO_IN)
    rand uvm_reg_field gpio_in;

    //---build------------------------------------------------------------
    virtual function void build();
        gpio_in = uvm_reg_field::type_id::create("gpio_in");

        gpio_in.configure(this, 32, 0, "RO", 1, 'b0000000000000000000000000000000, 1, 1, 1);

    endfunction

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_GPIO_IN_rd_cg";
        gpio_in_rd : coverpoint gpio_in.value[31:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "GPIO_IN");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        rd_cg=new;
    endfunction
endclass

//--------------------------------------------------------------------
// MISC_CNTL
//--------------------------------------------------------------------
class MISC_CNTL extends uvm_reg;
    `uvm_object_utils(MISC_CNTL)
    rand uvm_reg_field nmb_io_busy;
    rand uvm_reg_field sec_mac_pi_tx_clk_gating_en;
    rand uvm_reg_field sec_mac_crypt_clk_gating_en;
    rand uvm_reg_field sec_mac_core_tx_clk_gating_en;
    rand uvm_reg_field sec_mpif_clk_gating_en;
    rand uvm_reg_field mac_pi_clk_gating_en;
    rand uvm_reg_field mac_pi_tx_clk_gating_en;
    rand uvm_reg_field mac_pi_rx_clk_gating_en;
    rand uvm_reg_field mac_core_clk_gating_en;
    rand uvm_reg_field mac_crypt_clk_gating_en;
    rand uvm_reg_field mac_core_tx_clk_gating_en;
    rand uvm_reg_field mac_core_rx_clk_gating_en;
    rand uvm_reg_field mac_wt_clk_gating_en;
    rand uvm_reg_field mpif_clk_gating_en;
    rand uvm_reg_field bootrom_enable;
    rand uvm_reg_field fpgab_reset_req;
    rand uvm_reg_field soft_reset_req;

    //---build------------------------------------------------------------
    virtual function void build();
        nmb_io_busy = uvm_reg_field::type_id::create("nmb_io_busy");
        sec_mac_pi_tx_clk_gating_en = uvm_reg_field::type_id::create("sec_mac_pi_tx_clk_gating_en");
        sec_mac_crypt_clk_gating_en = uvm_reg_field::type_id::create("sec_mac_crypt_clk_gating_en");
        sec_mac_core_tx_clk_gating_en = uvm_reg_field::type_id::create("sec_mac_core_tx_clk_gating_en");
        sec_mpif_clk_gating_en = uvm_reg_field::type_id::create("sec_mpif_clk_gating_en");
        mac_pi_clk_gating_en = uvm_reg_field::type_id::create("mac_pi_clk_gating_en");
        mac_pi_tx_clk_gating_en = uvm_reg_field::type_id::create("mac_pi_tx_clk_gating_en");
        mac_pi_rx_clk_gating_en = uvm_reg_field::type_id::create("mac_pi_rx_clk_gating_en");
        mac_core_clk_gating_en = uvm_reg_field::type_id::create("mac_core_clk_gating_en");
        mac_crypt_clk_gating_en = uvm_reg_field::type_id::create("mac_crypt_clk_gating_en");
        mac_core_tx_clk_gating_en = uvm_reg_field::type_id::create("mac_core_tx_clk_gating_en");
        mac_core_rx_clk_gating_en = uvm_reg_field::type_id::create("mac_core_rx_clk_gating_en");
        mac_wt_clk_gating_en = uvm_reg_field::type_id::create("mac_wt_clk_gating_en");
        mpif_clk_gating_en = uvm_reg_field::type_id::create("mpif_clk_gating_en");
        bootrom_enable = uvm_reg_field::type_id::create("bootrom_enable");
        fpgab_reset_req = uvm_reg_field::type_id::create("fpgab_reset_req");
        soft_reset_req = uvm_reg_field::type_id::create("soft_reset_req");

        nmb_io_busy.configure(this, 1, 31, "RO", 1, 'b0, 1, 1, 1);
        sec_mac_pi_tx_clk_gating_en.configure(this, 1, 20, "RW", 1, 'b0, 1, 1, 1);
        sec_mac_crypt_clk_gating_en.configure(this, 1, 19, "RW", 1, 'b0, 1, 1, 1);
        sec_mac_core_tx_clk_gating_en.configure(this, 1, 18, "RW", 1, 'b0, 1, 1, 1);
        sec_mpif_clk_gating_en.configure(this, 1, 17, "RW", 1, 'b0, 1, 1, 1);
        mac_pi_clk_gating_en.configure(this, 1, 16, "RW", 1, 'b0, 1, 1, 1);
        mac_pi_tx_clk_gating_en.configure(this, 1, 15, "RW", 1, 'b0, 1, 1, 1);
        mac_pi_rx_clk_gating_en.configure(this, 1, 14, "RW", 1, 'b0, 1, 1, 1);
        mac_core_clk_gating_en.configure(this, 1, 13, "RW", 1, 'b0, 1, 1, 1);
        mac_crypt_clk_gating_en.configure(this, 1, 12, "RW", 1, 'b0, 1, 1, 1);
        mac_core_tx_clk_gating_en.configure(this, 1, 11, "RW", 1, 'b0, 1, 1, 1);
        mac_core_rx_clk_gating_en.configure(this, 1, 10, "RW", 1, 'b0, 1, 1, 1);
        mac_wt_clk_gating_en.configure(this, 1, 9, "RW", 1, 'b0, 1, 1, 1);
        mpif_clk_gating_en.configure(this, 1, 8, "RW", 1, 'b0, 1, 1, 1);
        bootrom_enable.configure(this, 1, 4, "RW", 1, 'b0, 1, 1, 1);
        fpgab_reset_req.configure(this, 1, 1, "RW", 1, 'b0, 1, 1, 1);
        soft_reset_req.configure(this, 1, 0, "RW", 1, 'b0, 1, 1, 1);

    endfunction

    covergroup wr_cg;
        option.per_instance=1;
        option.name="SYSCTRL_MISC_CNTL_wr_cg";
        sec_mac_pi_tx_clk_gating_en_wr : coverpoint sec_mac_pi_tx_clk_gating_en.value[0:0];
        sec_mac_crypt_clk_gating_en_wr : coverpoint sec_mac_crypt_clk_gating_en.value[0:0];
        sec_mac_core_tx_clk_gating_en_wr : coverpoint sec_mac_core_tx_clk_gating_en.value[0:0];
        sec_mpif_clk_gating_en_wr : coverpoint sec_mpif_clk_gating_en.value[0:0];
        mac_pi_clk_gating_en_wr : coverpoint mac_pi_clk_gating_en.value[0:0];
        mac_pi_tx_clk_gating_en_wr : coverpoint mac_pi_tx_clk_gating_en.value[0:0];
        mac_pi_rx_clk_gating_en_wr : coverpoint mac_pi_rx_clk_gating_en.value[0:0];
        mac_core_clk_gating_en_wr : coverpoint mac_core_clk_gating_en.value[0:0];
        mac_crypt_clk_gating_en_wr : coverpoint mac_crypt_clk_gating_en.value[0:0];
        mac_core_tx_clk_gating_en_wr : coverpoint mac_core_tx_clk_gating_en.value[0:0];
        mac_core_rx_clk_gating_en_wr : coverpoint mac_core_rx_clk_gating_en.value[0:0];
        mac_wt_clk_gating_en_wr : coverpoint mac_wt_clk_gating_en.value[0:0];
        mpif_clk_gating_en_wr : coverpoint mpif_clk_gating_en.value[0:0];
        bootrom_enable_wr : coverpoint bootrom_enable.value[0:0];
        fpgab_reset_req_wr : coverpoint fpgab_reset_req.value[0:0];
        soft_reset_req_wr : coverpoint soft_reset_req.value[0:0];

    endgroup

    covergroup rd_cg;
        option.per_instance=1;
        option.name="SYSCTRL_MISC_CNTL_rd_cg";
        nmb_io_busy_rd : coverpoint nmb_io_busy.value[0:0];
        sec_mac_pi_tx_clk_gating_en_rd : coverpoint sec_mac_pi_tx_clk_gating_en.value[0:0];
        sec_mac_crypt_clk_gating_en_rd : coverpoint sec_mac_crypt_clk_gating_en.value[0:0];
        sec_mac_core_tx_clk_gating_en_rd : coverpoint sec_mac_core_tx_clk_gating_en.value[0:0];
        sec_mpif_clk_gating_en_rd : coverpoint sec_mpif_clk_gating_en.value[0:0];
        mac_pi_clk_gating_en_rd : coverpoint mac_pi_clk_gating_en.value[0:0];
        mac_pi_tx_clk_gating_en_rd : coverpoint mac_pi_tx_clk_gating_en.value[0:0];
        mac_pi_rx_clk_gating_en_rd : coverpoint mac_pi_rx_clk_gating_en.value[0:0];
        mac_core_clk_gating_en_rd : coverpoint mac_core_clk_gating_en.value[0:0];
        mac_crypt_clk_gating_en_rd : coverpoint mac_crypt_clk_gating_en.value[0:0];
        mac_core_tx_clk_gating_en_rd : coverpoint mac_core_tx_clk_gating_en.value[0:0];
        mac_core_rx_clk_gating_en_rd : coverpoint mac_core_rx_clk_gating_en.value[0:0];
        mac_wt_clk_gating_en_rd : coverpoint mac_wt_clk_gating_en.value[0:0];
        mpif_clk_gating_en_rd : coverpoint mpif_clk_gating_en.value[0:0];
        bootrom_enable_rd : coverpoint bootrom_enable.value[0:0];
        fpgab_reset_req_rd : coverpoint fpgab_reset_req.value[0:0];
        soft_reset_req_rd : coverpoint soft_reset_req.value[0:0];

    endgroup


    //---sample-----------------------------------------------------------
    protected virtual function void sample(uvm_reg_data_t  data, byte_en, bit is_read, uvm_reg_map map);
        super.sample(data, byte_en, is_read, map);
        if(!is_read) wr_cg.sample();
        if(is_read) rd_cg.sample();
    endfunction

    //---new--------------------------------------------------------------
    function new(string name = "MISC_CNTL");
        super.new(name, 32, build_coverage(UVM_CVR_FIELD_VALS));
        wr_cg=new;
        rd_cg=new;
    endfunction
endclass

/* ACCESS WRAPPER CLASS */
class SYSCTRL_reg_access_wrapper extends uvm_object;
    `uvm_object_utils(SYSCTRL_reg_access_wrapper)

    covergroup ra_cov(string name) with function sample(uvm_reg_addr_t addr, bit is_read);
      option.per_instance = 1;
      option.name = name;

      address_cov : coverpoint addr {
        bins SIGNATURE              = {'h0};
        bins DATE              = {'h4};
        bins TIME              = {'h8};
        bins SVNREV_MAC              = {'hC};
        bins SVNREV_FPGAA              = {'h10};
        bins TIMER              = {'h40};
        bins TICK_TIMER_CNT              = {'h44};
        bins TICK_TIMER_DURATION              = {'h48};
        bins TICK_TIMER_IRQ_SET              = {'h4C};
        bins TICK_TIMER_IRQ_CLEAR              = {'h50};
        bins TICK_TIMER_IRQ_CONTROL              = {'h54};
        bins SOFT_IRQ_SET              = {'h58};
        bins SOFT_IRQ_CLEAR              = {'h5C};
        bins DIAG_CONF0              = {'h64};
        bins DIAG_CONF1              = {'h68};
        bins DIAG_STAT              = {'h6C};
        bins DIAG_TRIGGER              = {'h70};
        bins DIAG_CONF2              = {'h74};
        bins DIAG_CONF3              = {'h78};
        bins DIAG_MPIF_CONF              = {'h7C};
        bins GPIO_OEN              = {'h80};
        bins GPIO_OUT              = {'h84};
        bins GPIO_IN              = {'h88};
        bins MISC_CNTL              = {'hE0};      }

      read_write_cov : coverpoint is_read {
        bins RD = {1};
        bins WR = {0};
      }

      cross__address__read_write : cross address_cov, read_write_cov;
    endgroup: ra_cov

    function new(string name = "SYSCTRL_reg_access_wrapper");
      ra_cov = new(name);
    endfunction

    function void sample(uvm_reg_addr_t offset, bit is_read);
      ra_cov.sample(offset, is_read);
    endfunction: sample

endclass: SYSCTRL_reg_access_wrapper

//-------------------------------------------------------------------
// SYSCTRL_register_block
//--------------------------------------------------------------------
class SYSCTRL_register_block extends uvm_reg_block;
    `uvm_object_utils(SYSCTRL_register_block)

    rand SIGNATURE SIGNATURE_reg;
    rand DATE DATE_reg;
    rand TIME TIME_reg;
    rand SVNREV_MAC SVNREV_MAC_reg;
    rand SVNREV_FPGAA SVNREV_FPGAA_reg;
    rand TIMER TIMER_reg;
    rand TICK_TIMER_CNT TICK_TIMER_CNT_reg;
    rand TICK_TIMER_DURATION TICK_TIMER_DURATION_reg;
    rand TICK_TIMER_IRQ_SET TICK_TIMER_IRQ_SET_reg;
    rand TICK_TIMER_IRQ_CLEAR TICK_TIMER_IRQ_CLEAR_reg;
    rand TICK_TIMER_IRQ_CONTROL TICK_TIMER_IRQ_CONTROL_reg;
    rand SOFT_IRQ_SET SOFT_IRQ_SET_reg;
    rand SOFT_IRQ_CLEAR SOFT_IRQ_CLEAR_reg;
    rand DIAG_CONF0 DIAG_CONF0_reg;
    rand DIAG_CONF1 DIAG_CONF1_reg;
    rand DIAG_STAT DIAG_STAT_reg;
    rand DIAG_TRIGGER DIAG_TRIGGER_reg;
    rand DIAG_CONF2 DIAG_CONF2_reg;
    rand DIAG_CONF3 DIAG_CONF3_reg;
    rand DIAG_MPIF_CONF DIAG_MPIF_CONF_reg;
    rand GPIO_OEN GPIO_OEN_reg;
    rand GPIO_OUT GPIO_OUT_reg;
    rand GPIO_IN GPIO_IN_reg;
    rand MISC_CNTL MISC_CNTL_reg;

    uvm_reg_map SYSCTRL_register_map; // Block map
    SYSCTRL_reg_access_wrapper access_cg;  // Wrapped register access covergroup

    //---new--------------------------------------------------------------
    function new(string name = "SYSCTRL_register_block");
        super.new(name, build_coverage(UVM_CVR_ADDR_MAP));
    endfunction

    //---build------------------------------------------------------------
    virtual function void build();
        if(has_coverage(UVM_CVR_ADDR_MAP)) begin
             access_cg = SYSCTRL_reg_access_wrapper::type_id::create("access_cg");
             void'(set_coverage(UVM_CVR_ADDR_MAP));
        end

        SIGNATURE_reg = SIGNATURE::type_id::create("SIGNATURE");
        SIGNATURE_reg.configure(this);
        SIGNATURE_reg.build();

        DATE_reg = DATE::type_id::create("DATE");
        DATE_reg.configure(this);
        DATE_reg.build();

        TIME_reg = TIME::type_id::create("TIME");
        TIME_reg.configure(this);
        TIME_reg.build();

        SVNREV_MAC_reg = SVNREV_MAC::type_id::create("SVNREV_MAC");
        SVNREV_MAC_reg.configure(this);
        SVNREV_MAC_reg.build();

        SVNREV_FPGAA_reg = SVNREV_FPGAA::type_id::create("SVNREV_FPGAA");
        SVNREV_FPGAA_reg.configure(this);
        SVNREV_FPGAA_reg.build();

        TIMER_reg = TIMER::type_id::create("TIMER");
        TIMER_reg.configure(this);
        TIMER_reg.build();

        TICK_TIMER_CNT_reg = TICK_TIMER_CNT::type_id::create("TICK_TIMER_CNT");
        TICK_TIMER_CNT_reg.configure(this);
        TICK_TIMER_CNT_reg.build();

        TICK_TIMER_DURATION_reg = TICK_TIMER_DURATION::type_id::create("TICK_TIMER_DURATION");
        TICK_TIMER_DURATION_reg.configure(this);
        TICK_TIMER_DURATION_reg.build();

        TICK_TIMER_IRQ_SET_reg = TICK_TIMER_IRQ_SET::type_id::create("TICK_TIMER_IRQ_SET");
        TICK_TIMER_IRQ_SET_reg.configure(this);
        TICK_TIMER_IRQ_SET_reg.build();

        TICK_TIMER_IRQ_CLEAR_reg = TICK_TIMER_IRQ_CLEAR::type_id::create("TICK_TIMER_IRQ_CLEAR");
        TICK_TIMER_IRQ_CLEAR_reg.configure(this);
        TICK_TIMER_IRQ_CLEAR_reg.build();

        TICK_TIMER_IRQ_CONTROL_reg = TICK_TIMER_IRQ_CONTROL::type_id::create("TICK_TIMER_IRQ_CONTROL");
        TICK_TIMER_IRQ_CONTROL_reg.configure(this);
        TICK_TIMER_IRQ_CONTROL_reg.build();

        SOFT_IRQ_SET_reg = SOFT_IRQ_SET::type_id::create("SOFT_IRQ_SET");
        SOFT_IRQ_SET_reg.configure(this);
        SOFT_IRQ_SET_reg.build();

        SOFT_IRQ_CLEAR_reg = SOFT_IRQ_CLEAR::type_id::create("SOFT_IRQ_CLEAR");
        SOFT_IRQ_CLEAR_reg.configure(this);
        SOFT_IRQ_CLEAR_reg.build();

        DIAG_CONF0_reg = DIAG_CONF0::type_id::create("DIAG_CONF0");
        DIAG_CONF0_reg.configure(this);
        DIAG_CONF0_reg.build();

        DIAG_CONF1_reg = DIAG_CONF1::type_id::create("DIAG_CONF1");
        DIAG_CONF1_reg.configure(this);
        DIAG_CONF1_reg.build();

        DIAG_STAT_reg = DIAG_STAT::type_id::create("DIAG_STAT");
        DIAG_STAT_reg.configure(this);
        DIAG_STAT_reg.build();

        DIAG_TRIGGER_reg = DIAG_TRIGGER::type_id::create("DIAG_TRIGGER");
        DIAG_TRIGGER_reg.configure(this);
        DIAG_TRIGGER_reg.build();

        DIAG_CONF2_reg = DIAG_CONF2::type_id::create("DIAG_CONF2");
        DIAG_CONF2_reg.configure(this);
        DIAG_CONF2_reg.build();

        DIAG_CONF3_reg = DIAG_CONF3::type_id::create("DIAG_CONF3");
        DIAG_CONF3_reg.configure(this);
        DIAG_CONF3_reg.build();

        DIAG_MPIF_CONF_reg = DIAG_MPIF_CONF::type_id::create("DIAG_MPIF_CONF");
        DIAG_MPIF_CONF_reg.configure(this);
        DIAG_MPIF_CONF_reg.build();

        GPIO_OEN_reg = GPIO_OEN::type_id::create("GPIO_OEN");
        GPIO_OEN_reg.configure(this);
        GPIO_OEN_reg.build();

        GPIO_OUT_reg = GPIO_OUT::type_id::create("GPIO_OUT");
        GPIO_OUT_reg.configure(this);
        GPIO_OUT_reg.build();

        GPIO_IN_reg = GPIO_IN::type_id::create("GPIO_IN");
        GPIO_IN_reg.configure(this);
        GPIO_IN_reg.build();

        MISC_CNTL_reg = MISC_CNTL::type_id::create("MISC_CNTL");
        MISC_CNTL_reg.configure(this);
        MISC_CNTL_reg.build();

        // Map name, Offset, Number of bytes, Endianess)
        SYSCTRL_register_map = create_map("SYSCTRL_register_map", 0, 4, UVM_LITTLE_ENDIAN);

        SYSCTRL_register_map.add_reg(SIGNATURE_reg, 'h0, "RO");
        SYSCTRL_register_map.add_reg(DATE_reg, 'h4, "RO");
        SYSCTRL_register_map.add_reg(TIME_reg, 'h8, "RO");
        SYSCTRL_register_map.add_reg(SVNREV_MAC_reg, 'hC, "RO");
        SYSCTRL_register_map.add_reg(SVNREV_FPGAA_reg, 'h10, "RO");
        SYSCTRL_register_map.add_reg(TIMER_reg, 'h40, "RW");
        SYSCTRL_register_map.add_reg(TICK_TIMER_CNT_reg, 'h44, "RW");
        SYSCTRL_register_map.add_reg(TICK_TIMER_DURATION_reg, 'h48, "RW");
        SYSCTRL_register_map.add_reg(TICK_TIMER_IRQ_SET_reg, 'h4C, "RW");
        SYSCTRL_register_map.add_reg(TICK_TIMER_IRQ_CLEAR_reg, 'h50, "RW");
        SYSCTRL_register_map.add_reg(TICK_TIMER_IRQ_CONTROL_reg, 'h54, "RW");
        SYSCTRL_register_map.add_reg(SOFT_IRQ_SET_reg, 'h58, "RW");
        SYSCTRL_register_map.add_reg(SOFT_IRQ_CLEAR_reg, 'h5C, "RW");
        SYSCTRL_register_map.add_reg(DIAG_CONF0_reg, 'h64, "RW");
        SYSCTRL_register_map.add_reg(DIAG_CONF1_reg, 'h68, "RW");
        SYSCTRL_register_map.add_reg(DIAG_STAT_reg, 'h6C, "RO");
        SYSCTRL_register_map.add_reg(DIAG_TRIGGER_reg, 'h70, "RW");
        SYSCTRL_register_map.add_reg(DIAG_CONF2_reg, 'h74, "RW");
        SYSCTRL_register_map.add_reg(DIAG_CONF3_reg, 'h78, "RW");
        SYSCTRL_register_map.add_reg(DIAG_MPIF_CONF_reg, 'h7C, "RW");
        SYSCTRL_register_map.add_reg(GPIO_OEN_reg, 'h80, "RW");
        SYSCTRL_register_map.add_reg(GPIO_OUT_reg, 'h84, "RW");
        SYSCTRL_register_map.add_reg(GPIO_IN_reg, 'h88, "RO");
        SYSCTRL_register_map.add_reg(MISC_CNTL_reg, 'hE0, "RW");

        // Lock the register model and build the map
        lock_model();
        SYSCTRL_register_map.set_check_on_read();
    endfunction

endclass
`endif // __SYSCTRL_REG_BLOCK_SV__
