//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_CORE_COEX_BT_SEQ_SV
`define MAC_CORE_COEX_BT_SEQ_SV

class mac_core_coex_bt_seq extends wlan_seq_base;

  `uvm_object_utils(mac_core_coex_bt_seq)

  coex_bt_set_seq  seq;

  function new (string name = "mac_core_coex_bt_seq");
    super.new (name);
  endfunction : new


  virtual function bit check_bt_coex_if_presence();
`ifndef RW_WLAN_COEX_EN
   `uvm_info(get_type_name(), "NO BT COEXISTANCE I/F to check...", UVM_HIGH)
`endif
  endfunction : check_bt_coex_if_presence


  virtual task body();
    uvm_reg_data_t data;
    super.body();

/*
    BT_SET_TX,
    BT_SET_RX,
    BT_SET_EVENT,
    BT_SET_PTI,
    BT_SET_CHANNEL,
    BT_SET_BW,
    BT_RESET
*/

//    m_regmodel.set_reg_value(32'h00000001, "COEXCONTROLREG"); // Enable coex
    m_regmodel.set_reg_value(32'h0000003f, "COEXCONTROLREG"); // Enable coex

    seq = coex_bt_set_seq::type_id::create("seq");
    seq.command = BT_SET_TX;
    seq.value   = 15'h0001;
    seq.start(m_vsqr.m_coex_bt_sqr);

    #1000;

    seq = coex_bt_set_seq::type_id::create("seq");
    seq.command = BT_RESET;
    seq.value   = 15'h0000;
    seq.start(m_vsqr.m_coex_bt_sqr);


     m_regmodel.get_reg_value(data, "COEXSTATREG");
     `uvm_info(get_type_name(), $sformatf("COEXSTATREG = %b.", data), UVM_HIGH)

    #1000;


    `uvm_info(get_type_name(), "Platform AXI debug test is completed.", UVM_LOW)
  endtask : body

endclass : mac_core_coex_bt_seq


`endif // MAC_CORE_COEX_BT_SEQ_SV
