//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_CORE_RX_MGMNT_HE_SU_SEQ_SV
`define MAC_CORE_RX_MGMNT_HE_SU_SEQ_SV


class mac_core_rx_mgmnt_he_su_seq extends mac_core_seq_base;

  `uvm_object_utils(mac_core_rx_mgmnt_he_su_seq)

  PPDU_frame                 mgmnt_frame;
  bit [31:0]                 rx_buff_rd_ptr;
  int                        ksr_index;
  int                        frame_num;

  function new (string name = "mac_core_rx_mgmnt_he_su_seq");
    super.new (name);

  endfunction : new

  virtual task body();
    super.body();

    //--------------------------------------------
    // determine device and BSS address
    //--------------------------------------------
    create_keystorageRAM();

    create_dev_and_bss_addr();

    // set Rx interrupt masks
    m_regmodel.set_field_value(1'b1, "maskrxBuffer1Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masktimerRxTrigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "maskrxBuffer2Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masterTxRxIntEn", "TXRXINTUNMASKREG"); // Enables interrupt generation

    // put MAC core to active state
    change_mac_core_state(`ACTIVE_STATE);

    frame_num = $urandom_range(10,20);
    for (int loop=0; loop < frame_num; loop++) begin
      `uvm_info(get_type_name(),$sformatf("Receive Frame number: %0d / %0d",
      loop+1,frame_num),UVM_LOW)

      mgmnt_frame = new("mgmnt_frame");
      // after MAC received 10 frames, once again prepare SRAM for Rx
      // because RHDs are filled
      if ((loop % 10) == 0) begin
        prepare_sram_for_rx(10000);
        m_regmodel.get_reg_value(rdata, "RXBUF1RDPTRREG");
        rx_buff_rd_ptr = rdata + rhd_header;
      end

      //--------------------------------
      // create data frame for Rx
      //--------------------------------
      assert (mgmnt_frame.randomize() with {
        kind == SINGLETON;
        ppdu_format == HE_SU;
        tx_frame == 0;
      });

      mgmnt_frame.ampdu_frame[0].clear_all_arrays();
      assert (mgmnt_frame.ampdu_frame[0].randomize() with {
        mgmnt_frame.ampdu_frame[0].ppdu_format == mgmnt_frame.ppdu_format;
        mgmnt_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
        mgmnt_frame.ampdu_frame[0].mpdu_frame_type[0] == ACTION;
        mgmnt_frame.ampdu_frame[0].aggregated == 0;
      });

      ksr_index = get_random_ksr_index(mgmnt_frame);

      mgmnt_frame.ampdu_frame[0].set_MAC_addr(
        .RA    (dev_addr),
        .TA    (m_ksr.keyRAM[ksr_index].mac_addr_ram_f),
        .BSSID (bss_addr)
      );

      mgmnt_frame.setup_rx_encrypted_data();
      mgmnt_frame.calc_leg_ht_length();

      `uvm_info(get_type_name(),
      $sformatf("PPDU_frame:\n%s", mgmnt_frame.sprint()), UVM_LOW)

      // receive ACK and wait for interrupt Rx trigger
      fork
        // if frames if going to be received trigger will occur,
        // if frames if filtered event will occur
        fork
          wait_mac_rx_trigger();
          rx_frame_filtered();
        join_any

        // if there is no response from MAC wait for sync
        if (responde_to_frame(mgmnt_frame, dev_addr)) begin
          // PHY sends frame to MAC core
          phy_core_rx(mgmnt_frame);
          phy_core_tx();// RX ACK
        end
        else begin
          // PHY sends frame to MAC core
          phy_core_rx(mgmnt_frame);
          no_resp_trigger.wait_trigger();
        end
      join

      // only if frame was stored in SRAM do read
      if (!stop_pooling) begin
        `uvm_info(get_type_name(),
        "MAC core received frame and stored it to SRAM", UVM_LOW)
        rd_frame_from_sram(rx_buff_rd_ptr);
        insert_idle_cycles(5);
        get_next_rhd_ptr(1, rx_buff_rd_ptr, rx_buff_rd_ptr);
      end

      // clear interrupt flag
      m_regmodel.set_field_value(1'b1, "clearrxBuffer1Trigger", "TXRXINTEVENTCLEARREG");
      m_regmodel.set_field_value(1'b1, "cleartimerRxTrigger", "TXRXINTEVENTCLEARREG");
      m_regmodel.set_field_value(1'b1, "clearrxBuffer2Trigger", "TXRXINTEVENTCLEARREG");

      // To give a time for interrupt comparison
      insert_idle_cycles(10);

    end //for

  endtask : body


endclass : mac_core_rx_mgmnt_he_su_seq

`endif // MAC_CORE_RX_MGMNT_HE_SU_SEQ_SV
