//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_CORE_RX_RANDOM_FRAME_SEQ_SV
`define MAC_CORE_RX_RANDOM_FRAME_SEQ_SV


class mac_core_rx_random_frame_seq extends mac_core_seq_base;

  `uvm_object_utils(mac_core_rx_random_frame_seq)

  PPDU_frame                 rx_frame;
  bit [47:0]                 ta_address;
  bit [31:0]                 rx_buff_rd_ptr;
  int                        ksr_index;
  int                        frame_num;
  int                        rhd_cnt;
  int                        rpd_cnt;
  bit [3:0]                  TID;
  bit [11:0]                 SSN;


  function new (string name = "mac_core_rx_random_frame_seq");
    super.new (name);

  endfunction : new

  virtual task body();
    super.body();

    //--------------------------------------------
    // determine device and BSS address
    //--------------------------------------------
    create_keystorageRAM();

    create_dev_and_bss_addr();

    // set Rx interrupt masks
    m_regmodel.set_field_value(1'b1, "maskrxBuffer1Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masktimerRxTrigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "maskrxBuffer2Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masterTxRxIntEn", "TXRXINTUNMASKREG"); // Enables interrupt generation

    // put MAC core to active state
    change_mac_core_state(`ACTIVE_STATE);
    //disable reception of Multicast frames
    m_regmodel.set_reg_value(32'h7FC7_FFD8, "RXCNTRLREG");

    frame_num = $urandom_range(10,20);
    for (int loop=0; loop < frame_num; loop++) begin
      `uvm_info(get_type_name(),$sformatf("Receive Frame number: %0d / %0d",
      loop+1,frame_num),UVM_LOW)

      rx_frame = new("rx_frame");

      //--------------------------------
      // create data frame for Rx
      //--------------------------------
      assert (rx_frame.randomize() with {
        kind == SINGLETON;
        tx_frame == 0;
      });

      rx_frame.ampdu_frame[0].clear_all_arrays();
      assert (rx_frame.ampdu_frame[0].randomize() with {
        rx_frame.ampdu_frame[0].ppdu_format == rx_frame.ppdu_format;
        rx_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
        rx_frame.ampdu_frame[0].mpdu_frame_type[0][5:4] != `MANAGEMENT_MPDU;
        rx_frame.ampdu_frame[0].aggregated == 0;
      });

      rx_frame.setup_rx_encrypted_data();
      rx_frame.calc_leg_ht_length();

      rhd_cnt = rx_frame.ampdu_frame[0].mpdu_frame_type.size()*4*`RHD_LEN;
      rpd_cnt = rx_frame.ampdu_frame[0].size();
      // prepare SRAM for Rx
      prepare_sram_for_rx(rhd_cnt + rpd_cnt);
      m_regmodel.get_reg_value(rdata, "RXBUF1RDPTRREG");
      rx_buff_rd_ptr = rdata + rhd_header;

      `uvm_info(get_type_name(),
      $sformatf("PPDU_frame:\n%s", rx_frame.sprint()), UVM_LOW)

      // receive ACK and wait for interrupt Rx trigger
      fork
        // if frames if going to be received trigger will occur,
        // if frames if filtered event will occur
        fork
          wait_mac_rx_trigger();
          rx_frame_filtered();
        join_any

        // if there is no response from MAC wait for sync
        if (responde_to_frame(rx_frame, dev_addr)) begin
          // PHY sends frame to MAC core
          phy_core_rx(rx_frame);
          phy_core_tx();// RX ACK
        end
        else begin
          // PHY sends frame to MAC core
          phy_core_rx(rx_frame);
          no_resp_trigger.wait_trigger();
        end
      join

      // only if frame was stored in SRAM do read
      if (!stop_pooling) begin
        `uvm_info(get_type_name(),
        "MAC core received frame and stored it to SRAM", UVM_LOW)
        rd_frame_from_sram(rx_buff_rd_ptr);
        insert_idle_cycles(5);
        get_next_rhd_ptr(1, rx_buff_rd_ptr, rx_buff_rd_ptr);
      end

      // clear interrupt flag
      m_regmodel.set_field_value(1'b1, "clearrxBuffer1Trigger", "TXRXINTEVENTCLEARREG");
      m_regmodel.set_field_value(1'b1, "cleartimerRxTrigger", "TXRXINTEVENTCLEARREG");
      m_regmodel.set_field_value(1'b1, "clearrxBuffer2Trigger", "TXRXINTEVENTCLEARREG");

      // To give a time for interrupt comparison
      insert_idle_cycles(10);

    end //for

  endtask : body


endclass : mac_core_rx_random_frame_seq

`endif // MAC_CORE_RX_RANDOM_FRAME_SEQ_SV
