//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_CORE_RX_TRIGGER_FRAME_BUSY_CHANNEL_SEQ_SV
`define MAC_CORE_RX_TRIGGER_FRAME_BUSY_CHANNEL_SEQ_SV


class mac_core_rx_trigger_frame_busy_channel_seq extends mac_core_seq_base;

  `uvm_object_utils(mac_core_rx_trigger_frame_busy_channel_seq)

  PPDU_frame                 trigger_frame;
  PPDU_frame                 tb_resp_frame;
  TRIGGER_frame              trig_frame;
  PPDU_frame                 ack_frame;
  PPDU_frame                 ba_frame;
  BLOCK_ACK_frame            ba_mpdu;
  bit [31:0]                 rx_buff_rd_ptr;
  int                        ksr_index;
  int                        frame_num;
  int                        tx_int_loop;

  mac_ctrl_info_1_s          mac_ctrl_info_1;
  mac_ctrl_info_2_s          mac_ctrl_info_2;

  rand nav_prot_frm_e        prot;
  rand expect_ack_e          expect_ack;
  rand access_category_e     ac;

  rand bit [15:0]            AID;
  int                        max_he_length;
  bit                        disableRxBuffer2;

  trigger_type_e             custom_trigger_type;
  bit                        custom_test;

  function new (string name = "mac_core_rx_trigger_frame_busy_channel_seq");
    super.new (name);
  endfunction : new

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_prot_ack {
    prot == NO_PROT;
    ac == AC_TB;
    expect_ack inside {NORMAL_ACK,COMPRESSED_BA,NO_ACK};
  }

  // AID 1 to 2007 indicates the AID of the STA
  constraint c_aid {
    AID inside {[1:2007]};
  }

  virtual task body();
    super.body();
    m_regmodel.set_field_value(1'b1, "coexEnable", "COEXCONTROLREG");
    //--------------------------------------------
    // determine device and BSS address
    //--------------------------------------------
    create_keystorageRAM();

    create_dev_and_bss_addr();

    // set Rx interrupt masks
    m_regmodel.set_field_value(1'b1, "maskrxBuffer1Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masktimerRxTrigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "maskrxBuffer2Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masktbProtTrigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masterTxRxIntEn", "TXRXINTUNMASKREG"); // Enables interrupt generation
    m_regmodel.set_field_value(1'b1, "acceptTriggerSWFrames", "HECONFIGREG");
    m_regmodel.set_field_value(1'b1, "acceptTriggerHWFrames", "HECONFIGREG");

    // randomize fields in sequence
    assert (this.randomize());

    m_regmodel.set_field_value(AID, "aid", "BCNCNTRL2REG");

    `uvm_info(get_type_name(),$sformatf("AID12 is = 0x%0h", AID[11:0]), UVM_LOW)

    // put MAC core to active state
    change_mac_core_state(`ACTIVE_STATE);

    trigger_frame = new("trigger_frame");
    tb_resp_frame = new("tb_resp_frame");
    trig_frame    = new("trig_frame");
    ack_frame     = new("ack_frame");
    ba_frame      = new("ba_frame");
    ba_mpdu       = new("ba_mpdu");

    prepare_sram_for_rx(5000);
    prepare_sram_priority_rx(5000);

    //--------------------------------
    // create data frame for Rx
    //--------------------------------
    assert (trig_frame.randomize() with {
      if (custom_test) {
        trig_frame.trigger_type == custom_trigger_type;
      }
      trig_frame.user_info[0].aid12_f == AID[11:0];
    });

    // set maximum MCS supported
    m_regmodel.set_field_value(trig_frame.MAX_MCS, "maxMCSInHETB");

    assert (trigger_frame.randomize() with {
      kind == SINGLETON;
      tx_frame == 0;
      ppdu_format == HE_SU;
    });

    trigger_frame.ampdu_frame[0].clear_all_arrays();
    assert (trigger_frame.ampdu_frame[0].randomize() with {
      trigger_frame.ampdu_frame[0].ppdu_format == trigger_frame.ppdu_format;
      trigger_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
      trigger_frame.ampdu_frame[0].mpdu_frame_type[0] == TRIGGER;
      trigger_frame.ampdu_frame[0].aggregated == 0;
    });
    trigger_frame.ampdu_frame[0].mpdu_frame[0] = trig_frame;
    trigger_frame.ampdu_frame[0].create_delimiter();
    trigger_frame.ampdu_frame[0].add_padding();

    ksr_index = get_random_ksr_index(trigger_frame);
    // set MAC addresses
    trigger_frame.ampdu_frame[0].set_MAC_addr(
      .RA    (dev_addr),
      .TA    (m_ksr.keyRAM[ksr_index].mac_addr_ram_f)
    );
    //trigger_frame.setup_rx_encrypted_data();
    trigger_frame.calc_leg_ht_length();

    if (custom_trigger_type == MU_RTS && trig_frame.user_info[0].ru_allocation_f[7:1] == 62)
      m_regmodel.set_field_value(3'b001, "primaryChPosition", "SCANCNTRLREG");
    else if (custom_trigger_type == MU_RTS)
      m_regmodel.set_field_value(3'b000, "primaryChPosition", "SCANCNTRLREG");

    `uvm_info(get_type_name(),
    $sformatf("PPDU_frame:\n%s", trigger_frame.sprint()), UVM_LOW)

    // receive ACK and wait for interrupt Rx trigger
    fork
      // if frames if going to be received trigger will occur,
      // if frames if filtered event will occur
      fork
        if (custom_trigger_type inside {BASIC_TRIGGER,BUFFER_STATUS_REPORT_POLL})
          wait_mac_tb_trigger();
        else
          wait_mac_rx_trigger();
        rx_frame_filtered();
      join_any
      begin
        phy_core_rx(trigger_frame); // Reception of the Trigger frame
        if (custom_trigger_type inside {MU_RTS,MU_BAR,BANDWIDTH_QUERY_REPORT_POLL}
            && responde_to_frame(trigger_frame, dev_addr)
            && !m_cfg.m_mac_phy_cfg.m_phy_cfg.set_cca_to_busy) begin

          // MAC sends response
          phy_core_tx();            // Tx of CTS in case of MU_RTS
                                    // and BACK in case of MU_BAR
        end
        else if (custom_trigger_type == MU_RTS) begin
          no_resp_trigger.wait_trigger();
        end
      end
    join

    // disable for in case of correct reception to kill rx_frame_filtered task
    // and by that prevet it to set stop_pooling flag
    disable fork;

    // only if frame was stored in SRAM do read
    if (!stop_pooling) begin
      `uvm_info(get_type_name(),
      "MAC core received frame and stored it to SRAM", UVM_LOW)

      m_regmodel.get_field_value(rdata, "disableRxBuffer2");
      disableRxBuffer2 = rdata[0];
      if (disableRxBuffer2)
        m_regmodel.get_reg_value(rdata, "RXBUF1RDPTRREG");
      else
        m_regmodel.get_reg_value(rdata, "RXBUF2RDPTRREG");

      rx_buff_rd_ptr = rdata + rhd_header;
      rd_frame_from_sram(rx_buff_rd_ptr);
      insert_idle_cycles(5);

      if (disableRxBuffer2)
        get_next_rhd_ptr(1, rx_buff_rd_ptr, rx_buff_rd_ptr);
      else
        get_next_rhd_ptr(2, rx_buff_rd_ptr, rx_buff_rd_ptr);
    end

    // prepare SRAM for Rx, with smaller Rx segment
    prepare_sram_for_rx(1000, 1);
    prepare_sram_priority_rx(1000);

    //-----------------------------------
    // create HE_TB as a response to the
    // received Trigger frame
    //-----------------------------------
    if (!(custom_trigger_type inside {MU_RTS, MU_BAR, BANDWIDTH_QUERY_REPORT_POLL})) begin
      // get the maximum he_length, based on the Trigger frame
      max_he_length = get_max_he_length(trigger_frame);

      assert (tb_resp_frame.randomize() with {
        kind inside {SINGLETON, AGGREGATED};
        tx_frame == 1;
        ppdu_format == HE_TB;
        if (kind == AGGREGATED) {
          max_he_tb_length == max_he_length;
          set_tb_length == 1;
        }
      });
      // in case of singleton create data frame
      if (tb_resp_frame.kind == SINGLETON) begin
        tb_resp_frame.ampdu_frame[0].clear_all_arrays();
        tb_resp_frame.ampdu_frame[0].payload_size = max_he_length;
        assert (tb_resp_frame.ampdu_frame[0].randomize() with {
          tb_resp_frame.ampdu_frame[0].ppdu_format == tb_resp_frame.ppdu_format;
          tb_resp_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
          tb_resp_frame.ampdu_frame[0].mpdu_frame_type[0][5:4] == `DATA_MPDU;
          tb_resp_frame.ampdu_frame[0].mpdu_frame_type[0][2]   == 0;// frame with payload
          tb_resp_frame.ampdu_frame[0].aggregated == 0;
        });
        tb_resp_frame.ampdu_frame[0].create_delimiter();
        tb_resp_frame.ampdu_frame[0].add_padding();
      end

      ksr_index = get_random_ksr_index(tb_resp_frame);
      // set MAC addresses
      tb_resp_frame.ampdu_frame[0].set_MAC_addr(
        .TA    (dev_addr),
        .RA    (m_ksr.keyRAM[ksr_index].mac_addr_ram_f),
        .BSSID (bss_addr)
      );
      // encrypt frame if protection bit is set
      tb_resp_frame.encrypt(.ra(1));
      tb_resp_frame.preamble_header.user_header_he[0].he_length_f = tb_resp_frame.size();


      // configure MAC control 1 field for THD
      mac_ctrl_info_1.prot_frm_dur_f   = 16'd0;
      mac_ctrl_info_1.write_ack_f      = 0;
      mac_ctrl_info_1.low_rate_retry_f = 0;
      mac_ctrl_info_1.lstp_prot_f      = 0;
      mac_ctrl_info_1.lstp_f           = 0;
      // overwrite COMPRESSED_BA is singleton frame is transmitted
      if (expect_ack == COMPRESSED_BA && tb_resp_frame.kind == SINGLETON)
        expect_ack = NORMAL_ACK; //normal ACK
      mac_ctrl_info_1.expect_ack_f     = expect_ack;

      // configure MAC control 2 field for THD
      mac_ctrl_info_2.dont_generate_mh_f = 0;
      mac_ctrl_info_2.dont_encrypt_f     = 0;
      mac_ctrl_info_2.dont_touch_fc_f    = 0;
      mac_ctrl_info_2.dont_touch_dur_f   = 0;
      mac_ctrl_info_2.dont_touch_qos_f   = 0;
      mac_ctrl_info_2.dont_touch_htc_f   = 0;
      mac_ctrl_info_2.dont_touch_tsf_f   = 0;
      mac_ctrl_info_2.dont_touch_dtim_f  = 0;
      mac_ctrl_info_2.dont_touch_fcs_f   = 0;
      mac_ctrl_info_2.under_ba_setup_f   = 0;
      mac_ctrl_info_2.num_blank_delimit_f = 0;
      mac_ctrl_info_2.int_en_f            = 1;

      // trigger based frame doesn't set PHY Control information field
      m_cfg.m_sram_cfg.trigger_based_frame = 1;
      
      // determine type of NAV protection frame exchange
      `uvm_info(get_type_name(),$sformatf("NAV protection %s",prot.name()),UVM_LOW)
      // expected ACK
      `uvm_info(get_type_name(),$sformatf("Expected ACK: %s",expect_ack.name()),UVM_LOW)
      // access category
      `uvm_info(get_type_name(),$sformatf("Access category %s",ac.name()),UVM_LOW)

      // Store PPDU frame in SRAM for trasmit
      if (!(custom_trigger_type inside {MU_RTS, MU_BAR, BANDWIDTH_QUERY_REPORT_POLL})
      &&  !(m_cfg.m_mac_phy_cfg.m_phy_cfg.set_cca_to_busy == 1 && trig_frame.common_info.cs_required_f == 1)) begin
        wr_frame_to_sram(tb_resp_frame,
                         mac_ctrl_info_1,
                         mac_ctrl_info_2,
                         prot,
                         32'h200);
          `uvm_info(get_type_name(), $sformatf("HE_TB response frame:%s", tb_resp_frame.sprint()), UVM_LOW)
      end

      //--------------------------------
      // create ACK frame for Rx
      //--------------------------------
      assert (ack_frame.randomize() with {
        kind == SINGLETON;
        ppdu_format == NON_HT;
        tx_frame == 0;
      });

      ack_frame.ampdu_frame[0].clear_all_arrays();
      assert (ack_frame.ampdu_frame[0].randomize() with {
        ack_frame.ampdu_frame[0].ppdu_format == ack_frame.ppdu_format;
        ack_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
        ack_frame.ampdu_frame[0].mpdu_frame_type[0] == ACK;
        ack_frame.ampdu_frame[0].aggregated == 0;
      });
      ack_frame.calc_leg_ht_length();

      // set MAC addresses
      ack_frame.ampdu_frame[0].set_MAC_addr(
        .RA    (dev_addr)
      );

      //--------------------------------
      // create BLOCK_ACK frame for Rx
      //--------------------------------
      assert (ba_mpdu.randomize() with {
        ba_variant inside {COMP_BA,MULTI_STA_BA};
        starting_seq_num == tb_resp_frame.ampdu_frame[0].get_MAC_seq_num();
      });
      assert (ba_frame.randomize() with {
        kind == SINGLETON;
        ppdu_format == NON_HT;
        tx_frame == 0;
      });

      ba_frame.ampdu_frame[0].clear_all_arrays();
      assert (ba_frame.ampdu_frame[0].randomize() with {
        ba_frame.ampdu_frame[0].ppdu_format == ba_frame.ppdu_format;
        ba_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
        ba_frame.ampdu_frame[0].mpdu_frame_type[0] == BLOCK_ACK;
        ba_frame.ampdu_frame[0].aggregated == 0;
      });
      ba_frame.ampdu_frame[0].mpdu_frame[0] = ba_mpdu;
      ba_frame.calc_leg_ht_length();

      // set MAC addresses
      ba_frame.ampdu_frame[0].set_MAC_addr(
        .RA    (dev_addr)
      );

      // prepare response frame to basic trigger in AC-TB
      fork
        // TX trigger respons frame
        if (custom_trigger_type inside {BASIC_TRIGGER,BUFFER_STATUS_REPORT_POLL} &&
          !(m_cfg.m_mac_phy_cfg.m_phy_cfg.set_cca_to_busy == 1 && trig_frame.common_info.cs_required_f == 1)) begin
          //------------------------------------------------
          // collect Tx data frame
          //------------------------------------------------
          phy_core_tx();
          //------------------------------------------------
          // send ACK or BLOCK ACK or receive BLOCK ACK REQ
          //------------------------------------------------
          if (expect_ack == NORMAL_ACK) begin
            create_ppdu_response_frame(ack_frame);
            phy_core_rx(ack_frame);
          end
          else if (expect_ack == COMPRESSED_BA) begin
            create_ppdu_response_frame(ba_frame);
            phy_core_rx(ba_frame);
          end
        end// BASIC_TRIGGER, BUFFER_STATUS_REPORT_POLL

        if (custom_trigger_type inside {BASIC_TRIGGER,BUFFER_STATUS_REPORT_POLL} &&
          !(m_cfg.m_mac_phy_cfg.m_phy_cfg.set_cca_to_busy == 1 && trig_frame.common_info.cs_required_f == 1)) begin
          // Insert delay between the tbProtTrigger
          // and txTBNewHead
          insert_idle_cycles(`MAX_TB_RESP_DELAY);

          // set Tx interrupt masks for AC
          set_ac_interrupts(AC_TB);

          set_DMA_for_tx(AC_TB);

          //loop and wait for every MPDU in AMPDU
          if (tb_resp_frame.kind == SINGLETON)
            tx_int_loop = 1;
          else
            tx_int_loop = tb_resp_frame.ampdu_frame[0].mpdu_frame.size()-1;//subtract BAR frame

          repeat (tx_int_loop) begin
            wait_mac_tx_trigger(AC_TB);
            clear_ac_interrupts(AC_TB);
          end

          // read THD status from SRAM
          rd_tx_status_from_sram(
            .head     (m_cfg.m_sram_cfg.thd_head_ptr),
            .skip_athd((expect_ack == NO_ACK || tb_resp_frame.kind == SINGLETON) ? 0 : 1) // read A-THD if BAR is sent
          );

          m_regmodel.get_reg_value(rdata, "RXHETRIGUSERINFOREG");
          m_regmodel.get_reg_value(rdata, "RXHETRIGCOMMONINFOREG");

          insert_idle_cycles(20);
          // clear interrupt flag
          clear_ac_interrupts(AC_TB);
        end
      join
      
      // clear interrupt flag
      m_regmodel.set_field_value(1'b1, "clearrxBuffer1Trigger", "TXRXINTEVENTCLEARREG");
      m_regmodel.set_field_value(1'b1, "cleartimerRxTrigger", "TXRXINTEVENTCLEARREG");
      m_regmodel.set_field_value(1'b1, "clearrxBuffer2Trigger", "TXRXINTEVENTCLEARREG");
    end

    insert_idle_cycles(20);

  endtask : body


endclass : mac_core_rx_trigger_frame_busy_channel_seq

`endif // MAC_CORE_RX_TRIGGER_FRAME_BUSY_CHANNEL_SEQ_SV

