//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_CORE_SEQ_BASE_SV
`define MAC_CORE_SEQ_BASE_SV


class mac_core_seq_base extends wlan_seq_base;

  `uvm_object_utils(mac_core_seq_base)

  function new (string name = "mac_core_seq_base");
    super.new (name);
  endfunction : new

  virtual task pre_body();
  endtask : pre_body

  virtual task body();
    super.body();
  endtask : body

  virtual task post_body();
  endtask : post_body

//---------------------------------------------
// common functions and tasks
//---------------------------------------------

  //---------------------------------------------------
  // emulate PHY behavioural when Rx occur
  //---------------------------------------------------
  task phy_core_rx(ref PPDU_frame frm);
    phy_rx = phy_rx_frame_seq::type_id::create("phy_rx");
    phy_rx.frame = frm;
    phy_rx.start(m_vsqr.m_mac_phy_vsqr.m_phy_sqr);
  endtask : phy_core_rx

  //---------------------------------------------------
  // emulate PHY behavioural when Rx error occur
  //---------------------------------------------------
  task phy_core_rx_error(ref PPDU_frame frm);
    phy_rx_err = phy_rx_frame_err_seq::type_id::create("phy_rx_err");
    phy_rx_err.frame = frm;
    phy_rx_err.start(m_vsqr.m_mac_phy_vsqr.m_phy_sqr);
  endtask : phy_core_rx_error

  //---------------------------------------------------
  // emulate PHY behavioural when Tx occur
  //---------------------------------------------------
  task phy_core_tx();
    phy_tx = phy_tx_frame_seq::type_id::create("phy_tx");
    phy_tx.start(m_vsqr.m_mac_phy_vsqr.m_phy_sqr);
  endtask : phy_core_tx

  //---------------------------------------------------
  // emulate PHY beh that will create BFM report data
  // for MAC when beamforming report is sent as response
  //---------------------------------------------------
  task phy_bfm_report_gen();
    phy_bf_gen_report_seq  bfm_gen_seq;

    bfm_gen_seq = phy_bf_gen_report_seq::type_id::create("bfm_gen_seq");
    fork
      bfm_gen_seq.start(m_vsqr.m_bf_vsqr.m_phy_bf_sqr);
    join_none
    `uvm_info(get_type_name(),"BFM report generation sequnece started",UVM_LOW)
  endtask : phy_bfm_report_gen

endclass : mac_core_seq_base

`endif // MAC_CORE_SEQ_BASE_SV
