//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_CORE_SW_KEYSEARCH_SEQ_SV
`define MAC_CORE_SW_KEYSEARCH_SEQ_SV


class mac_core_sw_keysearch_seq extends mac_core_seq_base;

  `uvm_object_utils(mac_core_sw_keysearch_seq)

  bit                     search_err;
  bit [47:0]              random_mac_addr;
  int                     loop_num;

  function new (string name = "mac_core_sw_keysearch_seq");
    super.new (name);
  endfunction : new

  virtual task body();
    super.body();

    //--------------------------------------------
    // create keystorageRAM
    //--------------------------------------------
    create_keystorageRAM();

    // put MAC core to active state
    change_mac_core_state(`ACTIVE_STATE);

    // Search in KeyStorage RAM for MAC addresses, which
    // are placed in the model of KeyStorage RAM
    for (int i = `KEYRAM_DEV_START_ADDR; i < `KEYRAM_DEV_START_ADDR + m_ksr.num_of_dev; i++)begin
      search_keystorageRAM(m_ksr.keyRAM[i].mac_addr_ram_f, search_err);
      if (search_err == 1)
        `uvm_error(get_type_name(), "The requested MAC is not in KSR, although it should be")
      else
        `uvm_info(get_type_name(), $sformatf("The MAC address %h is in the KeyStorageRAM", m_ksr.keyRAM[i].mac_addr_ram_f), UVM_LOW)
    end

    // Generate random MAC addresses, if the address isn't
    // in the KeyRAM, search_err should be set to 1
    loop_num = $urandom_range(50,100);
    for (int i = 0; i < loop_num; i++) begin
      random_mac_addr[31:0] = $urandom();
      random_mac_addr[47:32] = $urandom();
      search_keystorageRAM(random_mac_addr, search_err);
      foreach(m_ksr.keyRAM[i]) begin
        if (m_ksr.keyRAM[i].mac_addr_ram_f != random_mac_addr) begin
          if (search_err != 1)
            `uvm_error(get_type_name(), "The requested MAC address is not in KSR, error should be reported")
        end
      end
    end

  endtask : body


endclass : mac_core_sw_keysearch_seq

`endif // MAC_CORE_SW_KEYSEARCH_SEQ_SV

