//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_CORE_SW_TIME_ON_AIR_CALCULATION_SEQ_SV
`define MAC_CORE_SW_TIME_ON_AIR_CALCULATION_SEQ_SV


class mac_core_sw_time_on_air_calculation_seq extends mac_core_seq_base;

  `uvm_object_utils(mac_core_sw_time_on_air_calculation_seq)

  PPDU_frame                 data_frame;
  int                        frame_num;
  bit [15:0]                 time_on_air;
  bit [15:0]                 time_on_air_expected;


  function new (string name = "mac_core_sw_time_on_air_calculation_seq");
    super.new (name);
  endfunction : new

  virtual task body();
    super.body();

    // put MAC core to active state
    change_mac_core_state(`ACTIVE_STATE);

    frame_num = $urandom_range(50,100);
    for (int loop=0; loop < frame_num; loop++) begin
      `uvm_info(get_type_name(),$sformatf("Loop number: %0d / %0d",
      loop+1,frame_num),UVM_LOW)

      data_frame = new("data_frame");

      //--------------------------------
      // create data frame for Tx
      //--------------------------------

      assert (data_frame.randomize() with {
        kind == SINGLETON;
        ppdu_format != HE_TB;
        tx_frame == 1;
      });

      data_frame.ampdu_frame[0].clear_all_arrays();
      assert (data_frame.ampdu_frame[0].randomize() with {
        data_frame.ampdu_frame[0].ppdu_format == data_frame.ppdu_format;
        data_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
        data_frame.ampdu_frame[0].mpdu_frame_type[0][5:4] == `DATA_MPDU;
        data_frame.ampdu_frame[0].aggregated == 0;
      });
      data_frame.calc_leg_ht_length();
      `uvm_info(get_type_name(),
      $sformatf("PPDU_frame:\n%s", data_frame.sprint()), UVM_LOW)

      sw_time_on_air_calculation(data_frame, time_on_air);

      time_on_air_expected = get_ppdu_duration(data_frame, 1);

      if (time_on_air_expected != time_on_air)
        `uvm_error(get_type_name(), $sformatf("Expected Time On Air value: %d[us], received Time On Air value is %d[us]", time_on_air_expected, time_on_air))
      else
        `uvm_info(get_type_name(), "The expected and received time on air calculation MATCH", UVM_LOW)

      insert_idle_cycles(3);

    end // for loop

  endtask : body


endclass : mac_core_sw_time_on_air_calculation_seq

`endif // MAC_CORE_SW_TIME_ON_AIR_CALCULATION_SEQ_SV

