//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_CORE_TX_BEACON_FRAME_SEQ_SV
`define MAC_CORE_TX_BEACON_FRAME_SEQ_SV


class mac_core_tx_beacon_frame_seq extends mac_core_seq_base;

  `uvm_object_utils(mac_core_tx_beacon_frame_seq)

  PPDU_frame                 bcn_frame;
  PPDU_frame                 data_frame, data_frame_q[$];

  mac_ctrl_info_1_s          mac_ctrl_info_1;
  mac_ctrl_info_2_s          mac_ctrl_info_2;

  int                        ksr_index;
  int                        frame_num;
  bit [31:0]                 thd_addr_q[$]; // save THD address
  rand nav_prot_frm_e        prot;
  rand expect_ack_e          expect_ack;
  rand access_category_e     ac;


  function new (string name = "mac_core_tx_beacon_frame_seq");
    super.new (name);
  endfunction : new

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_prot_ack {
    prot == NO_PROT;
    ac   == AC_BEACON;
    expect_ack == NO_ACK;
  }
  //---------------------------------------------

  virtual task body();
    super.body();

    //--------------------------------------------
    // determine device and BSS address
    //--------------------------------------------
    create_keystorageRAM();

    create_dev_and_bss_addr();

    // prepare SRAM for Rx, with smaller Rx segment
    prepare_sram_for_rx(1000, 1);
    // don't accept control frames
    m_regmodel.set_field_value(1'b0, "acceptBA",  "RXCNTRLREG");
    m_regmodel.set_field_value(1'b0, "acceptBAR", "RXCNTRLREG");
    m_regmodel.set_field_value(1'b0, "acceptRTS", "RXCNTRLREG");
    m_regmodel.set_field_value(1'b0, "acceptCTS", "RXCNTRLREG");
    m_regmodel.set_field_value(1'b0, "acceptACK", "RXCNTRLREG");

    // configure Beacon register
    m_regmodel.set_field_value( 1'b1, "ap", "MACCNTRL1REG");
    m_regmodel.set_field_value(16'h2, "beaconInt", "BCNCNTRL1REG");
    m_regmodel.set_field_value( 7'h5, "impTBTTPeriod", "BCNCNTRL1REG");
    m_regmodel.set_field_value( 1'b0, "impTBTTIn128Us", "BCNCNTRL1REG");
    m_regmodel.set_field_value( 8'h1B, "noBcnTxTime", "BCNCNTRL1REG");

    // put MAC core to active state
    change_mac_core_state(`ACTIVE_STATE);

    frame_num = $urandom_range(3,5);
    for (int loop=0; loop < frame_num; loop++) begin
      `uvm_info(get_type_name(),$sformatf("Transmit Frame number: %0d / %0d",
      loop+1,frame_num),UVM_LOW)

      bcn_frame  = new("bcn_frame");

      // randomize fields in sequence
      assert (this.randomize());

      //--------------------------------
      // create Beacon frame for Tx
      //--------------------------------

      assert (bcn_frame.randomize() with {
        kind == SINGLETON;
        ppdu_format == NON_HT;
        tx_frame == 1;
      });

      bcn_frame.ampdu_frame[0].clear_all_arrays();
      assert (bcn_frame.ampdu_frame[0].randomize() with {
        bcn_frame.ampdu_frame[0].ppdu_format == bcn_frame.ppdu_format;
        bcn_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
        bcn_frame.ampdu_frame[0].mpdu_frame_type[0] == BEACON;
        bcn_frame.ampdu_frame[0].aggregated == 0;
      });

      // set MAC addresses
      bcn_frame.ampdu_frame[0].set_MAC_addr(
        .TA    (dev_addr),
        .RA    (`BROADCAST_ADDR),
        .BSSID (bss_addr)
      );
      bcn_frame.calc_leg_ht_length();

      `uvm_info(get_type_name(),
      $sformatf("Management frame:%s", bcn_frame.sprint()), UVM_LOW)

      //--------------------------------
      // create data frames for Tx
      //--------------------------------
      repeat (3) begin
        data_frame = new("data_frame");

        assert (data_frame.randomize() with {
          kind == SINGLETON;
          ppdu_format == NON_HT;
          tx_frame == 1;
        });

        data_frame.ampdu_frame[0].clear_all_arrays();
        assert (data_frame.ampdu_frame[0].randomize() with {
          data_frame.ampdu_frame[0].ppdu_format == data_frame.ppdu_format;
          data_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
          data_frame.ampdu_frame[0].mpdu_frame_type[0][5:4] == `DATA_MPDU;
          data_frame.ampdu_frame[0].aggregated == 0;
        });

        // set MAC addresses
        data_frame.ampdu_frame[0].set_MAC_addr(
          .TA    (dev_addr),
          .RA    (`BROADCAST_ADDR),
          .BSSID (bss_addr)
        );
        // encrypt frame if protection bit is set
        data_frame.encrypt(.ra(1));
        data_frame.calc_leg_ht_length();

        // store to queue
        data_frame_q.push_front(data_frame);
        `uvm_info(get_type_name(),
        $sformatf("Data frame:%s", data_frame.sprint()), UVM_LOW)
      end// repeat

      // configure MAC control 1 field for THD
      mac_ctrl_info_1.prot_frm_dur_f   = 16'd0;
      mac_ctrl_info_1.write_ack_f      = 0;
      mac_ctrl_info_1.low_rate_retry_f = 0;
      mac_ctrl_info_1.lstp_prot_f      = 0;
      mac_ctrl_info_1.lstp_f           = 0;
      mac_ctrl_info_1.expect_ack_f     = expect_ack; //normal ACK

      // configure MAC control 2 field for THD
      mac_ctrl_info_2.dont_generate_mh_f = 0;
      mac_ctrl_info_2.dont_encrypt_f     = 0;
      mac_ctrl_info_2.dont_touch_fc_f    = 0;
      mac_ctrl_info_2.dont_touch_dur_f   = 0;
      mac_ctrl_info_2.dont_touch_qos_f   = 0;
      mac_ctrl_info_2.dont_touch_htc_f   = 0;
      mac_ctrl_info_2.dont_touch_tsf_f   = 0;
      mac_ctrl_info_2.dont_touch_dtim_f  = 0;
      mac_ctrl_info_2.dont_touch_fcs_f   = 0;
      mac_ctrl_info_2.under_ba_setup_f   = 0;
      mac_ctrl_info_2.num_blank_delimit_f = 0;
      mac_ctrl_info_2.int_en_f            = 1;

      // determine type of NAV protection frame exchange
      `uvm_info(get_type_name(),$sformatf("NAV protection %s",prot.name()),UVM_LOW)
      // expected ACK
      `uvm_info(get_type_name(),$sformatf("Expected ACK: %s",expect_ack.name()),UVM_LOW)
      // access category
      `uvm_info(get_type_name(),$sformatf("Access category %s",ac.name()),UVM_LOW)

      m_cfg.m_sram_cfg.use_cfg_pt_ptr = 0;

      // Store PPDU frame in SRAM for trasmit
      wr_frame_to_sram(bcn_frame,
                       mac_ctrl_info_1,
                       mac_ctrl_info_2,
                       prot,
                       32'h80);

      // save THD address for future read of status information
      thd_addr_q.push_front(m_cfg.m_sram_cfg.thd_head_ptr);

      // set Tx interrupt masks for AC
      set_ac_interrupts(ac);
      set_DMA_for_tx(ac);

      // link data frame to Beacon frame
      repeat (3) begin
        write_word_sram(
          m_cfg.m_sram_cfg.thd_head_ptr+`NEXT_ATOMIC_FRAME_OFFSET,
          m_cfg.m_sram_cfg.thd_curr_ptr
        );

        m_cfg.m_sram_cfg.use_cfg_pt_ptr = 1;

        // Store PPDU frame in SRAM for trasmit
        wr_frame_to_sram(data_frame_q.pop_back(),
                         mac_ctrl_info_1,
                         mac_ctrl_info_2,
                         prot,
                         m_cfg.m_sram_cfg.thd_curr_ptr);

        // save THD address for future read of status information
        thd_addr_q.push_front(m_cfg.m_sram_cfg.thd_head_ptr);
      end//repeat

      fork
        begin : RST_CTS_DATA_TX
          //------------------------------------------------
          // collect Tx Beacon frame
          //------------------------------------------------
          phy_core_tx();

          //------------------------------------------------
          // collect Tx data frame
          //------------------------------------------------
          repeat (3) phy_core_tx();

        end

        wait_mac_tx_trigger(ac);
      join

      insert_idle_cycles(20);
      // read THD status from SRAM
      while (thd_addr_q.size() != 0)
        rd_tx_status_from_sram(thd_addr_q.pop_back());

      // clear interrupt flag
      clear_ac_interrupts(ac);

    end // for loop

  endtask : body


endclass : mac_core_tx_beacon_frame_seq

`endif // MAC_CORE_TX_BEACON_FRAME_SEQ_SV
