//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_BF_TX_SEQ_SV
`define MODEM_BF_TX_SEQ_SV


class modem_bf_tx_seq extends modem_seq_base;

  `uvm_object_utils(modem_bf_tx_seq)

  //--------------------------------------------------------------------
  // variables for NDP
  //--------------------------------------------------------------------
  rand bit  [2:0] Nr;                         // Nr Value To Test
  rand bit  [2:0] Nc[`NB_STA_MAX];            // Nc Value To Test
  rand bit  [1:0] Grouping[`NB_STA_MAX];      // Grouping Value To Test
  rand bit        FeedbackType[`NB_STA_MAX];  // Feedback Type Value To Test
  rand bit        Codebook[`NB_STA_MAX];      // Codebook Value To Test

  rand int        STA_id;
  rand bit [2:0]  num_of_stations;   // number of stations, used for BF Tx test
  rand bit [1:0]  ch_bw;

  PPDU_frame      ndp;

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------

  constraint c_Nr {
    Nr == 1;
  }
  constraint c_FeedbackType {
    foreach (FeedbackType[i]) FeedbackType[i] inside {0,1};
    foreach (Codebook[i]) Codebook[i] inside  {0,1};
  }

  constraint c_Nc {
    solve Nr before Nc;
    foreach (Nc[i]) Nc[i] == 0;
  }

  constraint c_Grouping {
    foreach (Grouping[i]) Grouping[i] inside {0,1,2};
  }

  constraint c_channel_bw {
    ch_bw == channel_bw_func(VHT);
  }

  constraint c_num_of_stations {
    num_of_stations inside {[1:4]};
  }

  constraint c_staid {
    STA_id < num_of_stations;
  }

  function new (string name = "modem_mu_tx_seq");
    super.new (name);
  endfunction : new

  function void print_ndp_params(int i=0);
   `uvm_info(get_type_name(), $sformatf("*******************************************************"), UVM_LOW)
   `uvm_info(get_type_name(), $sformatf("Transmition of VHT NDP Sounding procedure user %0d", i), UVM_LOW)
   `uvm_info(get_type_name(), $sformatf("   Nr                : %2d", (Nr+1)        ), UVM_LOW)
   `uvm_info(get_type_name(), $sformatf("   Nc                : %2d", (Nc[i]+1)        ), UVM_LOW)
   `uvm_info(get_type_name(), $sformatf("   Grouping          : %2d", Grouping[i]      ), UVM_LOW)
   `uvm_info(get_type_name(), $sformatf("   Feedback type     : %s" , (FeedbackType[i]==1'b0)? "SU" : "MU"), UVM_LOW)
   `uvm_info(get_type_name(), $sformatf("   Codebook          : %2d", Codebook[i]   ), UVM_LOW)
   `uvm_info(get_type_name(), $sformatf("   Channel BW        : %2d", ch_bw   ), UVM_LOW)
   `uvm_info(get_type_name(), $sformatf("*******************************************************"), UVM_LOW)
  endfunction: print_ndp_params

  function void set_ndp_params();
    m_mdm_cfg.Nr = Nr;
    m_mdm_cfg.STAIDList[0] = STA_id;
    m_mdm_cfg.nBeamformingSTA = num_of_stations;

    for (int i=0; i<num_of_stations; i++) begin
      m_mdm_cfg.Nc[i]       = Nc[i];
      m_mdm_cfg.Grouping[i] = Grouping[i];
      m_mdm_cfg.Feedback[i] = FeedbackType[i];
      m_mdm_cfg.Codebook[i] = Codebook[i];
      print_ndp_params(i);
    end
   `uvm_info(get_type_name(), $sformatf("Station ID: %2d", STA_id+1), UVM_LOW)
  endfunction : set_ndp_params

  virtual task body();
    super.body();

    frame_num = $urandom_range(10, 20);

    for (int loop_num=1; loop_num <= frame_num; loop_num++) begin
      `uvm_info(get_type_name(), $sformatf("Sending frame number %0d of %0d",loop_num, frame_num ), UVM_LOW)

      // randomize NDP parameters and set them in mdm_data_model class
      assert (this.randomize());
      set_ndp_params();

      // set random control channel
      riu_set_control_channel();

      `uvm_info(get_type_name(), $sformatf("Start SU calibration"),UVM_LOW)

      //-----------------------------------------------------------------------
      // create NDP frame
      //-----------------------------------------------------------------------
      ndp = PPDU_frame::type_id::create("ndp");
      assert (ndp.randomize() with { kind == NDP; tx_frame == 1;});
      ndp.preamble_header.ch_bw = ch_bw;
      `uvm_info(get_type_name(), $sformatf("NDP frame :\n%s", ndp.sprint()), UVM_LOW)

      // transmit ndp
      tx_ppdu_frame(ndp);
      // wait
      insert_idle_cycles(30);

      //-----------------------------------------------------------------------
      // create rame for Tx
      //-----------------------------------------------------------------------
      frame = PPDU_frame::type_id::create("frame");
      assert (frame.randomize() with { kind inside {SINGLETON,AGGREGATED};
                                       ppdu_format == VHT;
                                       tx_frame == 1; });
      frame.preamble_header.ch_bw = ch_bw;
      // prevent incorrect MCS value
      if (ch_bw == 0 && frame.preamble_header.user_header[0].mcs_f == 7'd9) begin
        frame.preamble_header.user_header[0].mcs_f = $urandom_range(0,8);
      end
      frame.calc_leg_ht_length();

      `uvm_info(get_type_name(), $sformatf("Beamformed frame :\n%s", frame.sprint()), UVM_LOW)

      // store beamforming report to memory
      store_bfmer_report_ahb(frame, 0, STA_id);

      // transmit frame
      tx_ppdu_frame(frame);

      insert_idle_cycles(100);

    end
  endtask : body

endclass : modem_bf_tx_seq


`endif //MODEM_BF_TX_SEQ_SV
