//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_CUSTOM_RX_SEQ_SV
`define MODEM_CUSTOM_RX_SEQ_SV


class modem_custom_rx_seq extends modem_seq_base;

  `uvm_object_utils(modem_custom_rx_seq)

  PPDU_frame        frame;

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------

  function new (string name = "modem_custom_rx_seq");
    super.new (name);
    frame = PPDU_frame::type_id::create("frame");
  endfunction : new


  virtual task body();
    super.body();

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0)) refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    // start generating noise on ADC inputs
    drive_noise_adc();

    insert_idle_cycles(10);

    frame.calc_leg_ht_length();

    `uvm_info(get_type_name(), $sformatf("Frame configuration :\n%s", frame.sprint()), UVM_LOW)

    if (frame.ppdu_format == HE_MU)
      m_regmodel.set_reg_value(frame.preamble_header.user_header_he[0].staid_f,"HE_STAID_TAB0","PHYCONFIG");

    drive_phy_adc(frame);

    insert_idle_cycles(100);
  endtask : body

endclass : modem_custom_rx_seq


`endif //MODEM_CUSTOM_RX_SEQ_SV
