//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_MU_RX_SEQ_SV
`define MODEM_MU_RX_SEQ_SV


class modem_mu_rx_seq extends modem_seq_base;

  `uvm_object_utils(modem_mu_rx_seq)

  PPDU_frame                    ndp;
  PPDU_frame                    mu_mimo;
  bit                           is_he;
  int                           user;

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------

  function new (string name = "modem_mu_rx_seq");
    super.new (name);
  endfunction : new

  virtual task body();
    super.body();

    // setup DUT registers
    m_regmodel.set_field_value(0, "OFDMONLY", "RWNXAGCCNTL", "RIUKARST");
    // enable MUMIMO Rx
    m_regmodel.set_field_value(1, "RXHEMUMIMOEN");
    m_regmodel.set_field_value(1, "RXVHTMUMIMOEN");

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
         if ((`AGC_ON == 1) && (agcBypass == 0)) refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    // start generating noise on ADC inputs
    drive_noise_adc();

    frame_num = $urandom_range(10, 20);
    num_rx_frames = $urandom_range(2, 5);

    for (int loop_num=0; loop_num < frame_num; loop_num++) begin
      insert_idle_cycles(10);

      `uvm_info(get_type_name(), $sformatf("Receiving frame number %0d of %0d",loop_num+1, frame_num ), UVM_LOW)

      mu_mimo = PPDU_frame::type_id::create("mu_mimo");
      assert (mu_mimo.randomize() with {
        kind == MU_MIMO;
        if (is_he)
          ppdu_format == HE_MU;
        else
          ppdu_format == VHT;
        tx_frame == 0;
      });
      mu_mimo.calc_leg_ht_length();

      `uvm_info(get_type_name(), $sformatf("Frame configuration :\n%s", mu_mimo.sprint()), UVM_LOW)

      // set group membersip
      if (!is_he) begin
        phy_set_mu_group_memb(mu_mimo);
        phy_set_mu_userpos(mu_mimo);
      end
      else begin
        user = mu_mimo.preamble_header.mu_mimo_userid;
        m_regmodel.set_reg_value(mu_mimo.preamble_header.user_header_he[user].staid_f,"HE_STAID_TAB0","PHYCONFIG");
      end

      // Set the PRIMARYIND register
      m_regmodel.set_reg_value(mu_mimo.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

      // drive MUMIMO
      drive_phy_adc(mu_mimo);

      insert_idle_cycles(100);

    end // for loop_num
  endtask : body

endclass : modem_mu_rx_seq


`endif //MODEM_MU_RX_SEQ_SV
