//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_RX_ERR_SEQ_SV
`define MODEM_RX_ERR_SEQ_SV


class modem_rx_err_seq extends modem_seq_base;

  `uvm_object_utils(modem_rx_err_seq)

  format_mod_e        custom_format_mode;
  bit                 custom_test;
  rx_error_type_e     custom_error_injection = RANDOM_RX_ERROR;

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------

  function new (string name = "modem_rx_err_seq");
    super.new (name);
    custom_test = 0;
  endfunction : new


  virtual task body();
    super.body();

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0)) refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    // start generating noise on ADC inputs
    drive_noise_adc();

    frame_num = $urandom_range(10, 20);
    num_rx_frames = $urandom_range(2, 5);

    for (int loop_num=0; loop_num < frame_num; loop_num++) begin
      insert_idle_cycles(10);

      `uvm_info(get_type_name(), $sformatf("Receiving frame number %0d of %0d",loop_num+1, frame_num ), UVM_LOW)

      frame = PPDU_frame::type_id::create("frame");
      assert (frame.randomize() with {
        if (custom_test) {
          ppdu_format == custom_format_mode;
        }
        kind inside {SINGLETON, AGGREGATED, NDP};
        tx_frame == 0;
      });
      // when AGC OFF DSSS frames will not be received
      if (   (agcBypass == 1)
          && frame.ppdu_format inside {NON_HT,NON_HT_DUP_OFDM}
          && frame.preamble_header.leg_rate inside {[0:3]}
      ) begin
        frame.preamble_header.leg_rate = $urandom_range(8,15);
        frame.preamble_header.preamble_type = 0;
      end

      if (frame.ppdu_format == HE_MU) begin
        m_regmodel.set_reg_value(frame.preamble_header.user_header_he[0].staid_f,"HE_STAID_TAB0","PHYCONFIG");
      end

      // ----------------------------------------------------------------------
      // insert SIG error or not 70-30%
      // ----------------------------------------------------------------------
      if (custom_error_injection == RANDOM_RX_ERROR) begin
        randcase
          70: m_mdm_cfg.sig_error_injection = 1;
          30: m_mdm_cfg.sig_error_injection = 0;
        endcase
      end
      else if (custom_error_injection == CORRECT_INCORRECT) begin
        m_mdm_cfg.sig_error_injection = ~m_mdm_cfg.sig_error_injection;
      end
      else if (custom_error_injection == CONSECUTIVE_RX_ERROR) begin
        m_mdm_cfg.sig_error_injection = 1;
      end

      // ----------------------------------------------------------------------
      // create/inject specific error type in LSIG/HTSIG/VHTSIGA/HESIGA
      // ----------------------------------------------------------------------
      if (m_mdm_cfg.sig_error_injection == 1) begin
        case (frame.ppdu_format)
          NON_HT,NON_HT_DUP_OFDM: begin
            // set LSIG
            m_mdm_cfg.l_sig.tail_f     = 6'b000000;
            m_mdm_cfg.l_sig.length_f   = frame.preamble_header.leg_length;
            m_mdm_cfg.l_sig.reserved_f = 1'b0;
            m_mdm_cfg.l_sig.rate_f     = frame.preamble_header.leg_rate;
            m_mdm_cfg.l_sig.parity_f   = (($countones(m_mdm_cfg.l_sig[15:0]) % 2) == 0); //even parity
            //inject error in LSIG
            randcase
              1:/* bad LENGHT */ begin
                m_mdm_cfg.l_sig.length_f = $urandom_range(0, 13);
                m_mdm_cfg.l_sig.parity_f = (($countones(m_mdm_cfg.l_sig[15:0]) % 2) == 0); //even parity
              end
              1:/* bad RATE */ begin
                m_mdm_cfg.l_sig.rate_f   = $urandom_range(4, 7);
                m_mdm_cfg.l_sig.parity_f = (($countones(m_mdm_cfg.l_sig[15:0]) % 2) == 0); //even parity
              end
              1:/* bad RESERVED bit*/ begin
                m_mdm_cfg.l_sig.reserved_f = 1'b1;
                m_mdm_cfg.l_sig.parity_f   = (($countones(m_mdm_cfg.l_sig[15:0]) % 2) == 0); //even parity
              end
              1:/* bad PARITY bit */ begin
                m_mdm_cfg.l_sig.parity_f = ~m_mdm_cfg.l_sig.parity_f;
              end
            endcase
          end
          HT_MF,HT_GF: begin
            // set HTSIG
            m_mdm_cfg.ht_sig.tail_f         = 6'b000000;
            m_mdm_cfg.ht_sig.num_extn_ss_f  = frame.preamble_header.num_extn_ss;
            m_mdm_cfg.ht_sig.short_gi_f     = frame.preamble_header.gi_type[0];
            m_mdm_cfg.ht_sig.fec_coding_f   = frame.preamble_header.user_header[0].fec_coding_f;
            m_mdm_cfg.ht_sig.stbc_f         = frame.preamble_header.stbc;
            m_mdm_cfg.ht_sig.aggregation_f  = frame.preamble_header.aggregated;
            m_mdm_cfg.ht_sig.reserved_f     = 1'b1;
            m_mdm_cfg.ht_sig.not_sounding_f = ~frame.preamble_header.sounding;
            m_mdm_cfg.ht_sig.smoothing_f    = frame.preamble_header.smoothing;
            m_mdm_cfg.ht_sig.ht_length_f    = frame.preamble_header.user_header[0].ht_length_f;
            m_mdm_cfg.ht_sig.cbw_2040_f     = frame.preamble_header.ch_bw[0];
            m_mdm_cfg.ht_sig.mcs_f          = frame.preamble_header.user_header[0].mcs_f;
            m_mdm_cfg.ht_sig.crc_f          = sig_crc_func(m_mdm_cfg.ht_sig[33:0], 34);
            //inject error in HT-SIG
            if (frame.kind == NDP) begin
              randcase
                1:/* invalid STBC in NDP */ begin
                  m_mdm_cfg.ht_sig.stbc_f         = 1'b1;
                  m_mdm_cfg.ht_sig.crc_f          = sig_crc_func(m_mdm_cfg.ht_sig[33:0], 34);
                end
                1:/* invalid NSS in NDP */ begin
                  m_mdm_cfg.ht_sig.mcs_f          = $urandom_range(0, 7);
                  m_mdm_cfg.ht_sig.crc_f          = sig_crc_func(m_mdm_cfg.ht_sig[33:0], 34);
                end
              endcase
            end//if NDP
            else begin
              randcase
                1:/* bad RESERVED bit */ begin
                  m_mdm_cfg.ht_sig.reserved_f = 1'b0;
                  m_mdm_cfg.ht_sig.crc_f      = sig_crc_func(m_mdm_cfg.ht_sig[33:0], 34);
                end
                1:/* bad MCS */ begin
                  m_mdm_cfg.ht_sig.mcs_f = $urandom_range(77,127);
                  m_mdm_cfg.ht_sig.crc_f = sig_crc_func(m_mdm_cfg.ht_sig[33:0], 34);
                end
                1:/* bad LENGTH */ begin
                  m_mdm_cfg.ht_sig.ht_length_f = $urandom_range(0,16);
                  m_mdm_cfg.ht_sig.crc_f       = sig_crc_func(m_mdm_cfg.ht_sig[33:0], 34);
                end
                1:/* bad MCS32 BW */ begin
                  m_mdm_cfg.ht_sig.mcs_f      = 32;
                  m_mdm_cfg.ht_sig.cbw_2040_f = 0;
                  m_mdm_cfg.ht_sig.crc_f      = sig_crc_func(m_mdm_cfg.ht_sig[33:0], 34);
                end
                1:/* bad MCS32 STBC */ begin
                  m_mdm_cfg.ht_sig.mcs_f  = 32;
                  m_mdm_cfg.ht_sig.stbc_f = 1;
                  m_mdm_cfg.ht_sig.crc_f  = sig_crc_func(m_mdm_cfg.ht_sig[33:0], 34);
                end
                1:/* bad CRC */ begin
                  m_mdm_cfg.ht_sig.crc_f = ~m_mdm_cfg.ht_sig.crc_f;
                end
              endcase
            end//else
          end
          VHT: begin
            //TODO: add support for MU-MIMO invalid cases
            // set VHTSIGA
            m_mdm_cfg.vht_siga_su.tail_f                = 6'b000000;
            m_mdm_cfg.vht_siga_su.reserved3_f           = 1'b1;
            m_mdm_cfg.vht_siga_su.beamformed_f          = frame.preamble_header.beamformed;
            m_mdm_cfg.vht_siga_su.mcs_f                 = frame.preamble_header.user_header[0].mcs_f;
            m_mdm_cfg.vht_siga_su.ldpc_extra_symbol_f   = 1'b0;
            m_mdm_cfg.vht_siga_su.fec_coding_f          = frame.preamble_header.user_header[0].fec_coding_f;
            m_mdm_cfg.vht_siga_su.disambiguity_f        = 1'b0;
            m_mdm_cfg.vht_siga_su.short_gi_f            = frame.preamble_header.gi_type[0];
            m_mdm_cfg.vht_siga_su.reserved2_f           = 1'b1;
            m_mdm_cfg.vht_siga_su.txop_ps_not_allowed_f = 1'b0;
            m_mdm_cfg.vht_siga_su.partial_aid_f         = frame.preamble_header.partial_aid;
            m_mdm_cfg.vht_siga_su.nsts_f                = frame.preamble_header.user_header[0].num_sts_f;
            m_mdm_cfg.vht_siga_su.group_id_f            = frame.preamble_header.group_id;
            m_mdm_cfg.vht_siga_su.stbc_f                = frame.preamble_header.stbc;
            m_mdm_cfg.vht_siga_su.reserved1_f           = 1'b1;
            m_mdm_cfg.vht_siga_su.cbw_f                 = frame.preamble_header.ch_bw;
            m_mdm_cfg.vht_siga_su.crc_f                 = sig_crc_func(m_mdm_cfg.vht_siga_su[33:0], 34);
            //inject error in VHTSIGA
            if (frame.kind == NDP) begin
              // invalid NSS in NDP
              m_mdm_cfg.vht_siga_su.nsts_f                = 0;
              m_mdm_cfg.vht_siga_su.crc_f                 = sig_crc_func(m_mdm_cfg.vht_siga_su[33:0], 34);
            end//if NDP
            else begin
              randcase
                1:/* bad RESERVED 1 bit*/ begin
                  m_mdm_cfg.vht_siga_su.reserved1_f = 1'b0;
                  m_mdm_cfg.vht_siga_su.crc_f       = sig_crc_func(m_mdm_cfg.vht_siga_su[33:0], 34);
                end
                1:/* bad RESERVED 2 bit*/ begin
                  m_mdm_cfg.vht_siga_su.reserved2_f = 1'b0;
                  m_mdm_cfg.vht_siga_su.crc_f       = sig_crc_func(m_mdm_cfg.vht_siga_su[33:0], 34);
                end
                1:/* bad RESERVED 3 bit*/ begin
                  m_mdm_cfg.vht_siga_su.reserved3_f = 1'b0;
                  m_mdm_cfg.vht_siga_su.crc_f       = sig_crc_func(m_mdm_cfg.vht_siga_su[33:0], 34);
                end
                1:/* bad CRC */ begin
                  m_mdm_cfg.vht_siga_su.crc_f       = ~m_mdm_cfg.vht_siga_su.crc_f;
                end
                1:/* invalid FEC and LDPC extra symbol */ begin
                  m_mdm_cfg.vht_siga_su.ldpc_extra_symbol_f   = 1'b1;
                  m_mdm_cfg.vht_siga_su.fec_coding_f          = 1'b0;
                  m_mdm_cfg.vht_siga_su.crc_f                 = sig_crc_func(m_mdm_cfg.vht_siga_su[33:0], 34);
                end
                1:/* STBC and odd number of NSTS */ begin
                  m_mdm_cfg.vht_siga_su.stbc_f                = 1'b1;
                  m_mdm_cfg.vht_siga_su.nsts_f                = 3'd2;
                  m_mdm_cfg.vht_siga_su.crc_f                 = sig_crc_func(m_mdm_cfg.vht_siga_su[33:0], 34);
                end
              endcase
            end//else
          end
          HE_SU,HE_EXT_SU: begin
            m_mdm_cfg.he_siga_su.tail_f                      = 6'b000000;
            m_mdm_cfg.he_siga_su.doppler_f                   = frame.preamble_header.doppler;
            m_mdm_cfg.he_siga_su.reserved2_f                 = 1'b1;
            m_mdm_cfg.he_siga_su.pe_disambiguity_f           = frame.preamble_header.user_header_he[0].pkt_ext_f[2];
            m_mdm_cfg.he_siga_su.pre_fec_padding_factor_f    = frame.preamble_header.user_header_he[0].pkt_ext_f[1:0];
            m_mdm_cfg.he_siga_su.tx_bf_f                     = frame.preamble_header.beamformed;
            m_mdm_cfg.he_siga_su.stbc_f                      = frame.preamble_header.stbc;
            m_mdm_cfg.he_siga_su.ldpc_extra_symbol_f         = frame.preamble_header.ldpc_extra_symbol;
            m_mdm_cfg.he_siga_su.fec_coding_f                = frame.preamble_header.user_header_he[0].fec_coding_f;
            m_mdm_cfg.he_siga_su.txop_f                      = frame.preamble_header.txop_duration;
            if (frame.preamble_header.doppler == 0) begin
              m_mdm_cfg.he_siga_su.nsts_midamble_periodicity_f = frame.preamble_header.user_header_he[0].nss_f - 1;
            end
            else begin
              m_mdm_cfg.he_siga_su.nsts_midamble_periodicity_f[1:0] = frame.preamble_header.user_header_he[0].nss_f;
              m_mdm_cfg.he_siga_su.nsts_midamble_periodicity_f[2] = frame.preamble_header.midamble_periodicity;
            end
            if (frame.preamble_header.he_ltf_type == 0 && frame.preamble_header.gi_type == 0)
              m_mdm_cfg.he_siga_su.gi_ltf_size_f = 0;
            else if (frame.preamble_header.he_ltf_type == 1 && frame.preamble_header.gi_type == 0)
              m_mdm_cfg.he_siga_su.gi_ltf_size_f = 1;
            else if (frame.preamble_header.he_ltf_type == 1 && frame.preamble_header.gi_type == 1)
              m_mdm_cfg.he_siga_su.gi_ltf_size_f = 2;
            else
              m_mdm_cfg.he_siga_su.gi_ltf_size_f = 3;
            m_mdm_cfg.he_siga_su.bw_f                        = frame.preamble_header.ch_bw;
            m_mdm_cfg.he_siga_su.spatial_reuse_f             = frame.preamble_header.spatial_reuse[0];
            m_mdm_cfg.he_siga_su.reserved1_f                 = 1'b1;
            m_mdm_cfg.he_siga_su.bss_color_f                 = frame.preamble_header.bss_color;
            m_mdm_cfg.he_siga_su.dcm_f                       = frame.preamble_header.dcm;
            m_mdm_cfg.he_siga_su.mcs_f                       = frame.preamble_header.user_header_he[0].mcs_f;
            m_mdm_cfg.he_siga_su.ul_dl_f                     = frame.preamble_header.uplink_flag;
            m_mdm_cfg.he_siga_su.beam_change_f               = frame.preamble_header.beam_change;
            m_mdm_cfg.he_siga_su.format_f                    = 1'b1;
            m_mdm_cfg.he_siga_su.crc_f                       = sig_crc_func(m_mdm_cfg.he_siga_su[41:0], 42);
            if (frame.kind == NDP) begin
              // invalid NSS in NDP
              m_mdm_cfg.he_siga_su.nsts_midamble_periodicity_f[1:0] = 0;
              m_mdm_cfg.he_siga_su.crc_f                            = sig_crc_func(m_mdm_cfg.he_siga_su[41:0], 42);
            end//if NDP
            else begin
              // insert error in HE-SIGA
              randcase
                1:/* bad GI_TYPE and HE-LTF type */ begin
                  if (frame.preamble_header.stbc && frame.preamble_header.dcm)
                    m_mdm_cfg.he_siga_su.gi_ltf_size_f = $urandom_range(0,2);
                  m_mdm_cfg.he_siga_su.crc_f = sig_crc_func(m_mdm_cfg.he_siga_su[41:0], 42);
                end
                1:/* bad MCS */ begin
                  m_mdm_cfg.he_siga_su.mcs_f = $urandom_range(12,15);
                  m_mdm_cfg.he_siga_su.crc_f = sig_crc_func(m_mdm_cfg.he_siga_su[41:0], 42);
                end
                1:/* bad FEC and MCS */ begin
                  m_mdm_cfg.he_siga_su.mcs_f = $urandom_range(10,11);
                  m_mdm_cfg.he_siga_su.fec_coding_f = 0;
                  m_mdm_cfg.he_siga_su.crc_f = sig_crc_func(m_mdm_cfg.he_siga_su[41:0], 42);
                end
                1:/* bad FEC and NSTS */ begin
                  m_mdm_cfg.he_siga_su.doppler_f = 0;
                  m_mdm_cfg.he_siga_su.nsts_midamble_periodicity_f = $urandom_range(5,7);
                  m_mdm_cfg.he_siga_su.fec_coding_f = 1;
                  m_mdm_cfg.he_siga_su.crc_f = sig_crc_func(m_mdm_cfg.he_siga_su[41:0], 42);
                end
                1:/* bad DCM and MCS */ begin
                  m_mdm_cfg.he_siga_su.mcs_f = $urandom_range(5,11);
                  m_mdm_cfg.he_siga_su.dcm_f = 1;
                  m_mdm_cfg.he_siga_su.crc_f = sig_crc_func(m_mdm_cfg.he_siga_su[41:0], 42);
                end
                1:/* bad FEC and RU242 */ begin
                  m_mdm_cfg.he_siga_su.fec_coding_f = 0;
                  m_mdm_cfg.he_siga_su.bw_f = 1;
                  m_mdm_cfg.he_siga_su.crc_f = sig_crc_func(m_mdm_cfg.he_siga_su[41:0], 42);
                end
              endcase
            end
          end
          HE_MU: begin
            m_mdm_cfg.he_siga_mu.tail_f                             = 6'b000000;
            m_mdm_cfg.he_siga_mu.pe_disambiguity_f                  = frame.preamble_header.user_header_he[0].pkt_ext_f[2];
            m_mdm_cfg.he_siga_mu.pre_fec_padding_factor_f           = frame.preamble_header.user_header_he[0].pkt_ext_f[1:0];
            m_mdm_cfg.he_siga_mu.stbc_f                             = frame.preamble_header.stbc;
            m_mdm_cfg.he_siga_mu.ldpc_extra_symbol_f                = frame.preamble_header.ldpc_extra_symbol;
            if (frame.preamble_header.doppler == 0) begin
              m_mdm_cfg.he_siga_mu.num_he_ltf_midamble_periodicity_f      = frame.preamble_header.num_he_ltf;
            end
            else begin
              m_mdm_cfg.he_siga_mu.num_he_ltf_midamble_periodicity_f[1:0] = frame.preamble_header.num_he_ltf;
              m_mdm_cfg.he_siga_mu.num_he_ltf_midamble_periodicity_f[2]   = frame.preamble_header.midamble_periodicity;
            end
            m_mdm_cfg.he_siga_mu.reserved1_f                      = 1'b1;
            m_mdm_cfg.he_siga_mu.txop_f                           = frame.preamble_header.txop_duration;
            m_mdm_cfg.he_siga_mu.doppler_f                        = frame.preamble_header.doppler;
            if (frame.preamble_header.he_ltf_type == 2 && frame.preamble_header.gi_type == 0)
              m_mdm_cfg.he_siga_mu.gi_ltf_size_f = 0;
            else if (frame.preamble_header.he_ltf_type == 1 && frame.preamble_header.gi_type == 0)
              m_mdm_cfg.he_siga_mu.gi_ltf_size_f = 1;
            else if (frame.preamble_header.he_ltf_type == 1 && frame.preamble_header.gi_type == 1)
              m_mdm_cfg.he_siga_mu.gi_ltf_size_f = 2;
            else
              m_mdm_cfg.he_siga_mu.gi_ltf_size_f = 3;
            m_mdm_cfg.he_siga_mu.sigb_compression_f               = frame.preamble_header.sig_b_comp_mode;
            m_mdm_cfg.he_siga_mu.num_he_sigb_f                    = GetNSymbHESIGB(0,
                                                                                   get_ru_allocation_subfield_size(frame.preamble_header.ru_allocation),
                                                                                   (HESIGB_NDBPS[frame.preamble_header.mcs_sig_b] >> frame.preamble_header.dcm_sig_b));
            m_mdm_cfg.he_siga_mu.bw_f                             = frame.preamble_header.ch_bw;
            m_mdm_cfg.he_siga_mu.spatial_reuse_f                  = frame.preamble_header.spatial_reuse[0];
            m_mdm_cfg.he_siga_mu.bss_color_f                      = frame.preamble_header.bss_color;
            m_mdm_cfg.he_siga_mu.sigb_dcm_f                       = frame.preamble_header.dcm_sig_b;
            m_mdm_cfg.he_siga_mu.sigb_mcs_f                       = frame.preamble_header.mcs_sig_b;
            m_mdm_cfg.he_siga_mu.ul_dl_f                          = frame.preamble_header.uplink_flag;
            m_mdm_cfg.he_siga_mu.crc_f                            = sig_crc_func(m_mdm_cfg.he_siga_mu[41:0], 42);
          end
          default: begin
            `uvm_error(get_type_name(),$sformatf("Unsupported PPDU format %s",frame.ppdu_format.name()))
          end
        endcase
      end
      // ----------------------------------------------------------------------

      frame.calc_leg_ht_length();

      `uvm_info(get_type_name(), $sformatf("Frame configuration :\n%s", frame.sprint()), UVM_LOW)

      // Set the PRIMARYIND register
      m_regmodel.set_reg_value(frame.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

      drive_phy_adc(frame);
      insert_idle_cycles(16);

    end // for loop_num

    insert_idle_cycles(100);
  endtask : body

endclass : modem_rx_err_seq


`endif //MODEM_RX_ERR_SEQ_SV
