//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_RX_FROM_MATLAB_SEQ_SV
`define MODEM_RX_FROM_MATLAB_SEQ_SV


class modem_rx_from_matlab_seq extends modem_seq_base;

  ppdu_frame_kind_e   custom_kind;
  format_mod_e        custom_format;
  bit                 regmodel_init_done;

  `uvm_object_utils(modem_rx_from_matlab_seq)

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------

  function new (string name = "modem_rx_from_matlab_seq");
    super.new (name);
    regmodel_init_done = 0;
  endfunction : new

  virtual task body();
    super.body();

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0)) refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    // start generating noise on ADC inputs
    drive_noise_adc();

    for (int loop_num=0; loop_num < frame_num; loop_num++) begin
      insert_idle_cycles(10);

      `uvm_info(get_type_name(), $sformatf("Receiving frame number %0d of %0d",loop_num+1, frame_num ), UVM_LOW)

      frame = PPDU_frame::type_id::create("frame");
      assert (frame.randomize() with {
        kind == custom_kind;
        ppdu_format == custom_format;
        tx_frame == 0;
      });

      frame.calc_leg_ht_length();
      phy_set_mu_group_memb(frame);
      phy_set_mu_userpos(frame);

      //-------------------------------------------------------------
      // set register/field value if needed
      //-------------------------------------------------------------
      if (!regmodel_init_done) begin
        overwrite_regmodel();
        regmodel_init_done = 1;
      end
      //m_regmodel.set_reg_value(<VALUE>, <REGNAME/string>);
      //m_regmodel.set_field_value(<VALUE>, <FIELDNAME/string>, <REGNAME/string>);
      //-------------------------------------------------------------

      drive_phy_adc(frame);
      insert_idle_cycles(16);

    end // for loop_num

    insert_idle_cycles(20);
  endtask : body

endclass : modem_rx_from_matlab_seq


`endif //MODEM_RX_FROM_MATLAB_SEQ_SV
