//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_RX_RU_ALLOCATION_SEQ_SV
`define MODEM_RX_RU_ALLOCATION_SEQ_SV


class modem_rx_ru_allocation_seq extends modem_seq_base;

  `uvm_object_utils(modem_rx_ru_allocation_seq)

  format_mod_e        custom_format_mode;
  bit                 custom_test;
  int                 ru_array[];
  sta_list_t          sta_list;
  int                 counter;
  int                 total_frm_num;
  rand int            he_mu_length;
  int                 max_length;
  int                 dut_index;
  rand HE_MU_PPDU     ppdu_preamble;

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------
  constraint he_mu_length_c{
    he_mu_length inside {[50:100]};
  }

  function new (string name = "modem_rx_ru_allocation_seq");
    super.new (name);
  endfunction : new


  virtual task body();
    super.body();

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // For RU allocation testing
    ru_array = '{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,24,32,40,48,56,64,72,80,192};

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0)) refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    // start generating noise on ADC inputs
    drive_noise_adc();

    frame_num = ru_array.size();

    foreach(RU_ALLOCATION_TABLE[i])
      total_frm_num = total_frm_num + RU_ALLOCATION_TABLE[i].size();

    num_rx_frames = $urandom_range(2, 5);

    for (int loop_num=0; loop_num < frame_num; loop_num++) begin

        sta_list = get_sta_list(ru_array[loop_num],0);

      for (int num_of_ru=0; num_of_ru < sta_list.size(); num_of_ru++) begin
        insert_idle_cycles(10);
        counter++;

        `uvm_info(get_type_name(), $sformatf("Receiving frame number %0d of %0d",counter, total_frm_num ), UVM_LOW)

        frame = PPDU_frame::type_id::create("frame");
        assert (frame.randomize() with {
          ppdu_format == HE_MU;
          kind inside {SINGLETON, AGGREGATED};
          tx_frame == 0;
        });

        if (frame.ppdu_format == HE_MU)
          m_regmodel.set_reg_value(frame.preamble_header.user_header_he[0].staid_f,"HE_STAID_TAB0","PHYCONFIG");
        ppdu_preamble = HE_MU_PPDU::type_id::create("ppdu_preamble");

        // overwrite RU allocation, FEC and dut location
        assert(ppdu_preamble.randomize() with {
          user_header.size() == 0;
          user_header_he.size() == 1;
          ru_allocation == ru_array[loop_num];
          if(ru_array[loop_num][7:3] > 5'd24) {
            user_header_he[0].fec_coding_f == 1;
          }
          user_header_he[0].dut_location_f == num_of_ru;
        });

        //-----------------------------------------------------------------
        // there is limitation on HESIGB to not have more than 16 symbols
        //-----------------------------------------------------------------
        if (ppdu_preamble.ch_bw == 2'b00 && get_ru_allocation_subfield_size(ppdu_preamble.ru_allocation) > 7 && ppdu_preamble.dcm_sig_b == 1)
          ppdu_preamble.mcs_sig_b = 1;
        else if (ppdu_preamble.ch_bw == 2'b01 && ppdu_preamble.dcm_sig_b == 1)
          ppdu_preamble.mcs_sig_b = 3;
        else if (ppdu_preamble.ch_bw == 2'b01 && ppdu_preamble.dcm_sig_b == 0 && get_ru_allocation_subfield_size(ppdu_preamble.ru_allocation) > 6)
          ppdu_preamble.mcs_sig_b = 3;
        else if (ppdu_preamble.ch_bw == 2'b10 && ppdu_preamble.dcm_sig_b == 1 && get_ru_allocation_subfield_size(ppdu_preamble.ru_allocation) >= 3)
          ppdu_preamble.mcs_sig_b = 3;
        else if (ppdu_preamble.ch_bw == 2'b10 && ppdu_preamble.dcm_sig_b == 0 && get_ru_allocation_subfield_size(ppdu_preamble.ru_allocation) > 3)
          ppdu_preamble.mcs_sig_b = 4;

        frame.preamble_header.copy(ppdu_preamble);

`ifdef STANDALONE_PHY
        frame.ampdu_frame[0].clear_all_arrays();
        assert(frame.ampdu_frame[0].randomize() with {
          ampdu_payload.size() == he_mu_length;
        });
`endif // STANDALONE_PHY

        frame.calc_leg_ht_length();

        `uvm_info(get_type_name(), $sformatf("Frame configuration :\n%s", frame.sprint()), UVM_LOW)

        // set random control channel
        if (loop_num % num_rx_frames == 0)
          riu_set_control_channel();

        // Set the PRIMARYIND register
        m_regmodel.set_reg_value(frame.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

        drive_phy_adc(frame);
        insert_idle_cycles(16);
      end

    end // for loop_num

    insert_idle_cycles(100);
  endtask : body

endclass : modem_rx_ru_allocation_seq


`endif //MODEM_RX_RU_ALLOCATION_SEQ_SV

