//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_RX_SEQ_SV
`define MODEM_RX_SEQ_SV


class modem_rx_seq extends modem_seq_base;

  `uvm_object_utils(modem_rx_seq)

  format_mod_e        custom_format_mode;
  bit                 custom_test;
  bit                 force_20mhz = 0; // used in test case where configuration is 40MHZ but STA is set to 20MHZ

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------

  function new (string name = "modem_rx_seq");
    super.new (name);
  endfunction : new


  virtual task body();
    super.body();

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // force STA to be configured in BW20
    if (force_20mhz) begin
      m_regmodel.set_field_value(4'h0, "CONF_BW", "MDMCONF");
      m_regmodel.set_field_value(2'd0, "RXCBWMAX");
      m_regmodel.set_field_value(4'd2, "STARTDC");
      m_regmodel.set_field_value(7'd10, "DELAYSYNC");
      m_regmodel.set_field_value(7'd15, "WAITHTSTF");
      m_regmodel.set_field_value(8'd13, "TDSYNCOFF2040");
      m_regmodel.set_field_value(8'd25, "TDSYNCOFF20");
    end

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0)) refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    // start generating noise on ADC inputs
    drive_noise_adc();

    frame_num = $urandom_range(10, 20);
    num_rx_frames = $urandom_range(2, 5);

    for (int loop_num=0; loop_num < frame_num; loop_num++) begin
      insert_idle_cycles(10);

      `uvm_info(get_type_name(), $sformatf("Receiving frame number %0d of %0d",loop_num+1, frame_num ), UVM_LOW)

      frame = PPDU_frame::type_id::create("frame");
      assert (frame.randomize() with {
        if (custom_test) {
          ppdu_format == custom_format_mode;
          if (ppdu_format == HE_MU){
            kind == AGGREGATED;
          }
        }
        kind inside {SINGLETON, AGGREGATED};
        tx_frame == 0;
        ppdu_force_20mhz == force_20mhz;
      });
      // when AGC OFF DSSS frames will not be received
      if (   (agcBypass == 1)
          && frame.ppdu_format inside {NON_HT,NON_HT_DUP_OFDM}
          && frame.preamble_header.leg_rate inside {[0:3]}
      ) begin
        frame.preamble_header.leg_rate = $urandom_range(8,15);
        frame.preamble_header.preamble_type = 0;
      end

      if (frame.ppdu_format == HE_MU) begin
        m_regmodel.set_reg_value(frame.preamble_header.user_header_he[0].staid_f,"HE_STAID_TAB0","PHYCONFIG");
      end
      // in FD and TD testing prevent MCS32, because no internal checking is done
      else if (   frame.ppdu_format == HT_MF
               && (m_cfg.m_fft_in_cfg.is_active == UVM_ACTIVE || m_cfg.m_fft_out_cfg.is_active == UVM_ACTIVE)) begin

        if (frame.preamble_header.user_header[0].mcs_f == 32)
          frame.preamble_header.user_header[0].mcs_f = 0;
      end

      frame.calc_leg_ht_length();

      `uvm_info(get_type_name(), $sformatf("Frame configuration :\n%s", frame.sprint()), UVM_LOW)

      // Set the PRIMARYIND register
      m_regmodel.set_reg_value(frame.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

      drive_phy_adc(frame);
      insert_idle_cycles(16);

    end // for loop_num

    insert_idle_cycles(100);
  endtask : body

endclass : modem_rx_seq


`endif //MODEM_RX_SEQ_SV
