//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_RX_SNR_SEQ_SV
`define MODEM_RX_SNR_SEQ_SV


class modem_rx_snr_seq extends modem_seq_base;

  `uvm_object_utils(modem_rx_snr_seq)

  // SNR array
  int snr_values[12] = '{2, 3, 5, 8, 11, 15, 16, 18, 22, 23, 27, 29};

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------

  function new (string name = "modem_rx_snr_seq");
    super.new (name);
  endfunction : new


  virtual task body();
    super.body();

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0)) refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    // start generating noise on ADC inputs
    drive_noise_adc();

    frame_num = $urandom_range(10, 20);
    num_rx_frames = $urandom_range(2, 5);

    for (int loop_num=0; loop_num < frame_num; loop_num++) begin
      insert_idle_cycles(10);

      `uvm_info(get_type_name(), $sformatf("Receiving frame number %0d of %0d",loop_num+1, frame_num ), UVM_LOW)

      frame = PPDU_frame::type_id::create("frame");
      assert (frame.randomize() with {
        kind inside {SINGLETON, AGGREGATED};
        tx_frame == 0;
      });
      // when AGC OFF DSSS frames will not be received
      if (   (agcBypass == 1)
          && frame.ppdu_format inside {NON_HT,NON_HT_DUP_OFDM}
          && frame.preamble_header.leg_rate inside {[0:3]}
      ) begin
        frame.preamble_header.leg_rate = $urandom_range(8,15);
        frame.preamble_header.preamble_type = 0;
      end

      if (frame.ppdu_format == HE_MU)
        m_regmodel.set_reg_value(frame.preamble_header.user_header_he[0].staid_f,"HE_STAID_TAB0","PHYCONFIG");

      if (frame.ppdu_format inside {NON_HT, NON_HT_DUP_OFDM})
        m_mdm_cfg.snr_dB = snr_values[get_mcs_from_legacy_rate(frame.preamble_header.leg_rate)];
      else if (frame.ppdu_format inside {HT_MF,VHT})
        if (frame.preamble_header.user_header[0].mcs_f == 32)
          m_mdm_cfg.snr_dB = 29;
        else
          m_mdm_cfg.snr_dB = snr_values[frame.preamble_header.user_header[0].mcs_f];
      else
        m_mdm_cfg.snr_dB = snr_values[frame.preamble_header.user_header_he[0].mcs_f];

      frame.calc_leg_ht_length();

      `uvm_info(get_type_name(), $sformatf("Frame configuration :\n%s", frame.sprint()), UVM_LOW)

      // Set the PRIMARYIND register
      m_regmodel.set_reg_value(frame.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

      drive_phy_adc(frame);
      insert_idle_cycles(16);

    end // for loop_num

    insert_idle_cycles(100);
  endtask : body

endclass : modem_rx_snr_seq


`endif // MODEM_RX_SNR_SEQ_SV
