//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_RX_TX_DSSS_FRAME_SEQ_SV
`define MODEM_RX_TX_DSSS_FRAME_SEQ_SV


class modem_rx_tx_dsss_frame_seq extends modem_seq_base;

  `uvm_object_utils(modem_rx_tx_dsss_frame_seq)

  rand int     tx_frame_cnt;
  rand int     rx_frame_cnt;

  rand int     dsss_frame_length;
       real    invcarrierfreq;

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------
  constraint c_frame_cnt {
    tx_frame_cnt inside {[1:3]};
    rx_frame_cnt inside {[1:3]};
  }

  constraint c_dsss_frame_length {
    dsss_frame_length dist {
      [`MAX_MAC_HEADER_SIZE_DSSS : 300]  :/ 80,
      [301 : 1000]                       :/ 15,
      [1001:`MAX_MPDU_SIZE_DSSS]         :/ 5
    };
  }

  constraint c_carrier_freq {
    carrier_freq inside {2412, 2417, 2422, 2427, 2432, 2437, 2442,
                         2447, 2452, 2457, 2462, 2467, 2472, 2484};
  }

  function new (string name = "modem_rx_tx_dsss_frame_seq");
    super.new (name);
  endfunction : new


  virtual task body();
    super.body();

// NOTE:
// macro added to prevent compile error when compiling non Modem tests
// because ampdu_payload is only available when STANDALONE_PHY is defined
`ifdef STANDALONE_PHY
    // setup DUT registers
    m_regmodel.set_field_value(0, "OFDMONLY", "RWNXAGCCNTL", "RIUKARST");

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // Make sure to set 2.4GHz for DSSS
    invcarrierfreq = (2**26)/real'(carrier_freq);
    m_regmodel.set_field_value(int'(invcarrierfreq),"INVCARRIERFREQ");

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0)) refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    frame_num = $urandom_range(2,3);

    // set random control channel
    riu_set_control_channel();

    // start generating noise on ADC inputs
    drive_noise_adc();
    insert_idle_cycles(10);

    for (int loop_num=1; loop_num <= frame_num; loop_num++) begin

      `uvm_info(get_type_name(), $sformatf("Rx/Tx frame combo loop number %0d of %0d", loop_num, frame_num ), UVM_LOW)
      // randomize number of Rx and Tx frames
      assert (this.randomize());
      `uvm_info(get_type_name(), $sformatf("Number of Rx frames (%0d), number of Tx frames (%0d)",
      rx_frame_cnt,tx_frame_cnt), UVM_LOW)

      // set number of frames that MAC driver will receive/drive
      num_rx_frames = rx_frame_cnt;


      // receive frames
      for (int i=0; i<rx_frame_cnt; i++) begin
        insert_idle_cycles(10);

        frame = PPDU_frame::type_id::create("frame");
        assert (frame.randomize() with {
          kind == SINGLETON;
          ppdu_format == NON_HT;
          tx_frame == 0;
        });
        // force DSSS frames
        frame.preamble_header.leg_rate = $urandom_range(0,3);
        if (frame.preamble_header.leg_rate == 0) begin
          frame.preamble_header.preamble_type = 1;
        end
        frame.ampdu_frame[0].clear_all_arrays();
        assert (frame.ampdu_frame[0].randomize() with {
          ampdu_payload.size() == dsss_frame_length;
        });
        frame.calc_leg_ht_length();

        `uvm_info(get_type_name(), $sformatf("Rx frame (%0d/%0d) configuration :\n%s", i+1,rx_frame_cnt,frame.sprint()), UVM_LOW)

        drive_phy_adc(frame);
      end

      // if MAC driver hasn't finished unlock it
      wait (mac_seq_completed == 1'b1);

      // transmit frames
      for (int i=0; i<tx_frame_cnt; i++) begin
        insert_idle_cycles(20);

        frame = PPDU_frame::type_id::create("frame");
        assert (frame.randomize() with {
          kind == SINGLETON;
          ppdu_format == NON_HT;
          tx_frame == 1;
        });
        // force DSSS frames
        frame.preamble_header.leg_rate = $urandom_range(0,3);
        if (frame.preamble_header.leg_rate == 0) begin
          frame.preamble_header.preamble_type = 1;
        end
        frame.ampdu_frame[0].clear_all_arrays();
        assert (frame.ampdu_frame[0].randomize() with {
          ampdu_payload.size() == dsss_frame_length;
        });
        frame.calc_leg_ht_length();
        `uvm_info(get_type_name(), $sformatf("Tx frame (%0d/%0d) configuration :\n%s", i+1,tx_frame_cnt,frame.sprint()), UVM_LOW)

        // transmit frame
        tx_ppdu_frame(frame);
      end

    end // for loop_num

    insert_idle_cycles(10);

`endif//STANDALONE_PHY
  endtask : body

endclass : modem_rx_tx_dsss_frame_seq


`endif //MODEM_RX_TX_DSSS_FRAME_SEQ_SV
