//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_RX_TX_HE_TB_SEQ_SV
`define MODEM_RX_TX_HE_TB_SEQ_SV


class modem_rx_tx_he_tb_seq extends modem_seq_base;

  `uvm_object_utils(modem_rx_tx_he_tb_seq)

  rand int            rx_frame_cnt;
  int                 he_tb_length;
  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------
  constraint c_frame_cnt {
    rx_frame_cnt inside {[2:5]};
  }

  function new (string name = "modem_rx_tx_he_tb_seq");
    super.new (name);
  endfunction : new


  virtual task body();
    super.body();

    // setup DUT registers
    m_regmodel.set_field_value(0, "OFDMONLY", "RWNXAGCCNTL", "RIUKARST");

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0)) refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    frame_num = $urandom_range(2,5);

    // set random control channel
    riu_set_control_channel();

    // start generating noise on ADC inputs
    drive_noise_adc();
    insert_idle_cycles(10);

    for (int loop_num=1; loop_num <= frame_num; loop_num++) begin

      `uvm_info(get_type_name(), $sformatf("Rx/Tx frame combo loop number %0d of %0d", loop_num, frame_num ), UVM_LOW)
      // randomize number of Rx and Tx frames
      assert (this.randomize());
      `uvm_info(get_type_name(), $sformatf("Number of Rx frames (%0d)",
      rx_frame_cnt), UVM_LOW)

      // set number of frames that MAC driver will receive/drive
      num_rx_frames = rx_frame_cnt;

      // receive frames
      for (int i=0; i<rx_frame_cnt; i++) begin
        insert_idle_cycles(16);

        frame = PPDU_frame::type_id::create("frame");
        assert (frame.randomize() with { kind inside {SINGLETON,AGGREGATED}; tx_frame == 0; });
        frame.calc_leg_ht_length();
        `uvm_info(get_type_name(), $sformatf("Rx frame (%0d/%0d) configuration :\n%s", i+1,rx_frame_cnt,frame.sprint()), UVM_LOW)

        if (frame.ppdu_format == HE_MU) begin
          m_regmodel.set_reg_value(frame.preamble_header.user_header_he[0].staid_f,"HE_STAID_TAB0","PHYCONFIG");
        end

        // Set the PRIMARYIND register
        m_regmodel.set_reg_value(frame.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

        drive_phy_adc(frame);
      end

      // if MAC driver hasn't finished unlock it
      wait (mac_seq_completed == 1'b1);

      // transmit frames HE TB frame
      insert_idle_cycles(16);

      // --------------------------------------------------------------------
      // read precompensation status registers in order to mirror there value
      // since there values are used in MDM STA setup (to avoid backdoor
      // access)
      // --------------------------------------------------------------------
      m_regmodel.get_reg_value(rdata,"RXCFOEST");
      m_regmodel.get_reg_value(rdata,"RXSFOEST");
      // --------------------------------------------------------------------

      frame = PPDU_frame::type_id::create("frame");
      assert (frame.randomize() with {
              kind inside {SINGLETON,AGGREGATED};
              ppdu_format == HE_TB;
              tx_frame == 1; });

`ifdef STANDALONE_PHY
      he_tb_length = GetHeTbLength (.lsigLength_i           (frame.preamble_header.leg_length),
                                    .heLtfType_i            (frame.preamble_header.he_ltf_type),
                                    .giType_i               (frame.preamble_header.gi_type),
                                    .numHeLtf_i             (frame.preamble_header.num_he_ltf),
                                    .ruType_i               (get_ru_type(frame.preamble_header.ru_allocation)),
                                    .mcsIndex_i             (frame.preamble_header.user_header_he[0].mcs_f),
                                    .dcm_i                  (frame.preamble_header.dcm),
                                    .stbc_i                 (frame.preamble_header.stbc),
                                    .doppler_i              (frame.preamble_header.doppler),
                                    .fec_coding_i           (frame.preamble_header.user_header_he[0].fec_coding_f),
                                    .ldpc_extra_symbol_i    (frame.preamble_header.ldpc_extra_symbol),
                                    .pre_fec_padding_i      (frame.preamble_header.user_header_he[0].pkt_ext_f[1:0]),
                                    .midamble_periodicity_i (frame.preamble_header.midamble_periodicity),
                                    .bpe_dis_i              (frame.preamble_header.user_header_he[0].pkt_ext_f[2]),
                                    .debug_i                (0));

       frame.ampdu_frame[0].clear_all_arrays();
       assert (frame.ampdu_frame[0].randomize() with {
         ampdu_payload.size() ==  he_tb_length;
       });
`endif//STANDALONE_PHY

      frame.calc_leg_ht_length();
      `uvm_info(get_type_name(), $sformatf("HE-TB Tx frame configuration :\n%s",frame.sprint()), UVM_LOW)

      // Set the PRIMARYIND register
      m_regmodel.set_reg_value(frame.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

      // transmit frame
      tx_ppdu_frame(frame);

    end // for loop_num

    insert_idle_cycles(10);
  endtask : body

endclass : modem_rx_tx_he_tb_seq


`endif //MODEM_RX_TX_HE_TB_SEQ_SV

