//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_RX_TX_SEQ_SV
`define MODEM_RX_TX_SEQ_SV


class modem_rx_tx_seq extends modem_seq_base;

  `uvm_object_utils(modem_rx_tx_seq)

  rand int            tx_frame_cnt;
  rand int            rx_frame_cnt;
  bit [26:0]          txtdsfofsratio;
  bit [24:0]          txtdsfophase;
  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------
  constraint c_frame_cnt {
    tx_frame_cnt inside {[2:5]};
    rx_frame_cnt inside {[2:5]};
  }

  function new (string name = "modem_rx_tx_seq");
    super.new (name);
  endfunction : new


  virtual task body();
    super.body();

    // setup DUT registers
    m_regmodel.set_field_value(0, "OFDMONLY", "RWNXAGCCNTL", "RIUKARST");

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0)) refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    frame_num = $urandom_range(2, 5);

    // set random control channel
    riu_set_control_channel();

    // start generating noise on ADC inputs
    drive_noise_adc();
    insert_idle_cycles(10);

    for (int loop_num=1; loop_num <= frame_num; loop_num++) begin

      `uvm_info(get_type_name(), $sformatf("Rx/Tx frame combo loop number %0d of %0d", loop_num, frame_num ), UVM_LOW)
      // randomize number of Rx and Tx frames
      assert (this.randomize());
      `uvm_info(get_type_name(), $sformatf("Number of Rx frames (%0d), number of Tx frames (%0d)",
      rx_frame_cnt,tx_frame_cnt), UVM_LOW)

      // set number of frames that MAC driver will receive/drive
      num_rx_frames = rx_frame_cnt;

      // receive frames
      for (int i=0; i<rx_frame_cnt; i++) begin
        insert_idle_cycles(16);

        frame = PPDU_frame::type_id::create("frame");
        assert (frame.randomize() with {
          kind inside {SINGLETON,AGGREGATED};
          tx_frame == 0;
        });
        frame.calc_leg_ht_length();
        `uvm_info(get_type_name(), $sformatf("Rx frame (%0d/%0d) configuration :\n%s", i+1,rx_frame_cnt,frame.sprint()), UVM_LOW)

        if (frame.ppdu_format == HE_MU) begin
          m_regmodel.set_reg_value(frame.preamble_header.user_header_he[0].staid_f,"HE_STAID_TAB0","PHYCONFIG");
        end

        // Set the PRIMARYIND register
        m_regmodel.set_reg_value(frame.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

        drive_phy_adc(frame);
      end

      // if MAC driver hasn't finished unlock it
      wait (mac_seq_completed == 1'b1);

      // transmit frames
      for (int i=0; i<tx_frame_cnt; i++) begin

        randcase
          1:insert_idle_cycles(5);//rise TXREQ before SIFS
          1:insert_idle_cycles(16);//wait SIFS
        endcase

        frame = PPDU_frame::type_id::create("frame");
        assert (frame.randomize() with {
          kind inside {SINGLETON,AGGREGATED};
          ppdu_format != HE_TB;
          tx_frame == 1;
        });
        frame.calc_leg_ht_length();
        `uvm_info(get_type_name(), $sformatf("Tx frame (%0d/%0d) configuration :\n%s", i+1,tx_frame_cnt,frame.sprint()), UVM_LOW)

        if (frame.ppdu_format inside {NON_HT, NON_HT_DUP_OFDM} && frame.preamble_header.trigger_responding == 1'b1) begin
          // set TX FO precompensation in NON_HT & NON_HT_DUP_OFDM
          txtdsfofsratio = $urandom_range(67111548, 67106180);
          m_regmodel.set_field_value(1'b1, "TXTDSFOFSRATIOFORCE", "TXTDSFOCTRL");
          m_regmodel.set_field_value(1'b1, "TXTDSFOFSRATIOEN", "TXTDSFOCTRL");
          m_regmodel.set_field_value(txtdsfofsratio, "TXTDSFOFSRATIO", "TXTDSFOCTRL");

          txtdsfophase = $urandom_range(0, 33554431);
          m_regmodel.set_field_value(1'b1, "TXTDCFOPHASEFORCE", "TXTDCFOCTRL");
          m_regmodel.set_field_value(1'b1, "TXTDCFOPHASEEN", "TXTDCFOCTRL");
          m_regmodel.set_field_value(txtdsfophase, "TXTDCFOPHASE", "TXTDCFOCTRL");
        end
        else begin
          m_regmodel.set_field_value(1'b0, "TXTDSFOFSRATIOFORCE", "TXTDSFOCTRL");
          m_regmodel.set_field_value(1'b0, "TXTDCFOPHASEFORCE", "TXTDCFOCTRL");
        end
        // Set the PRIMARYIND register
        m_regmodel.set_reg_value(frame.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

        // transmit frame
        tx_ppdu_frame(frame);
      end

    end // for loop_num

    insert_idle_cycles(10);
  endtask : body

endclass : modem_rx_tx_seq


`endif //MODEM_RX_TX_SEQ_SV
