//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_TX_FROM_MATLAB_SEQ_SV
`define MODEM_TX_FROM_MATLAB_SEQ_SV


class modem_tx_from_matlab_seq extends modem_seq_base;

  `uvm_object_utils(modem_tx_from_matlab_seq)

  bit [26:0]          txtdsfofsratio;
  bit [24:0]          txtdsfophase;
  ppdu_frame_kind_e   custom_kind;
  bit                 regmodel_init_done;

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------

  function new (string name = "modem_tx_from_matlab_seq");
    super.new (name);
    regmodel_init_done = 0;
  endfunction : new

  virtual task body();
    super.body();

    for (int loop_num=1; loop_num <= frame_num; loop_num++) begin
      `uvm_info(get_type_name(), $sformatf("Sending frame number %0d of %0d",loop_num, frame_num ), UVM_LOW)

      frame = PPDU_frame::type_id::create("frame");
      assert (frame.randomize() with {
        kind == custom_kind;
        tx_frame == 1;
      });

      //-------------------------------------------------------------
      // set register/field value if needed
      //-------------------------------------------------------------
      if (!regmodel_init_done) begin
        overwrite_regmodel();
        regmodel_init_done = 1;
      end
      // Set the PRIMARYIND register
      //m_regmodel.set_reg_value(frame.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");
      //m_regmodel.set_field_value(1'b0,"FDDCCOMPEN","EQUALCTRL0","PHYCONFIG");
      //-------------------------------------------------------------

      // transmit frame
      tx_ppdu_frame(frame);

      insert_idle_cycles(100);

    end
  endtask : body

endclass : modem_tx_from_matlab_seq


`endif //MODEM_TX_FROM_MATLAB_SEQ_SV
