//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_TX_SEQ_SV
`define MODEM_TX_SEQ_SV


class modem_tx_seq extends modem_seq_base;

  `uvm_object_utils(modem_tx_seq)

  // if sequence needs to be customized, these variables are used
  format_mod_e        custom_format_mode;
  bit                 custom_test;
  int                 he_tb_length;
  bit [26:0]          txtdsfofsratio;
  bit [24:0]          txtdsfophase;

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------

  function new (string name = "modem_tx_seq");
    super.new (name);

    custom_test = 0;
  endfunction : new

  virtual task body();
    super.body();

    frame_num = $urandom_range(10, 20);

    for (int loop_num=1; loop_num <= frame_num; loop_num++) begin
      `uvm_info(get_type_name(), $sformatf("Sending frame number %0d of %0d",loop_num, frame_num ), UVM_LOW)


      frame = PPDU_frame::type_id::create("frame");
      assert (frame.randomize() with {
        kind inside {SINGLETON,AGGREGATED};
        if (custom_test) {
          ppdu_format == custom_format_mode;
        }
        tx_frame == 1;
      });

`ifdef STANDALONE_PHY
      // create payload if HE-TB is tested from legacy length
      if (frame.ppdu_format == HE_TB) begin
        he_tb_length = GetHeTbLength (.lsigLength_i           (frame.preamble_header.leg_length),
                                      .heLtfType_i            (frame.preamble_header.he_ltf_type),
                                      .giType_i               (frame.preamble_header.gi_type),
                                      .numHeLtf_i             (frame.preamble_header.num_he_ltf),
                                      .ruType_i               (get_ru_type(frame.preamble_header.ru_allocation)),
                                      .mcsIndex_i             (frame.preamble_header.user_header_he[0].mcs_f),
                                      .dcm_i                  (frame.preamble_header.dcm),
                                      .stbc_i                 (frame.preamble_header.stbc),
                                      .doppler_i              (frame.preamble_header.doppler),
                                      .fec_coding_i           (frame.preamble_header.user_header_he[0].fec_coding_f),
                                      .ldpc_extra_symbol_i    (frame.preamble_header.ldpc_extra_symbol),
                                      .pre_fec_padding_i      (frame.preamble_header.user_header_he[0].pkt_ext_f[1:0]),
                                      .midamble_periodicity_i (frame.preamble_header.midamble_periodicity),
                                      .bpe_dis_i              (frame.preamble_header.user_header_he[0].pkt_ext_f[2]),
                                      .debug_i                (0));
        frame.ampdu_frame[0].clear_all_arrays();
        assert (frame.ampdu_frame[0].randomize() with {
          ampdu_payload.size() ==  he_tb_length;
        });

      end
`endif//STANDALONE_PHY

      if (frame.ppdu_format == HE_TB) begin
        // set TX FO precompensation in HE_TB
        txtdsfofsratio = $urandom_range(67111548, 67106180);
        m_regmodel.set_field_value(1'b1, "TXTDSFOFSRATIOFORCE", "TXTDSFOCTRL");
        m_regmodel.set_field_value(1'b1, "TXTDSFOFSRATIOEN", "TXTDSFOCTRL");
        m_regmodel.set_field_value(txtdsfofsratio, "TXTDSFOFSRATIO", "TXTDSFOCTRL");

        txtdsfophase = $urandom_range(0, 33554431);
        m_regmodel.set_field_value(1'b1, "TXTDCFOPHASEFORCE", "TXTDCFOCTRL");
        m_regmodel.set_field_value(1'b1, "TXTDCFOPHASEEN", "TXTDCFOCTRL");
        m_regmodel.set_field_value(txtdsfophase, "TXTDCFOPHASE", "TXTDCFOCTRL");
      end
      else if (frame.ppdu_format inside {NON_HT, NON_HT_DUP_OFDM} && frame.preamble_header.trigger_responding == 1'b1) begin
        // set TX FO precompensation in NON_HT & NON_HT_DUP_OFDM
        txtdsfofsratio = $urandom_range(67111548, 67106180);
        m_regmodel.set_field_value(1'b1, "TXTDSFOFSRATIOFORCE", "TXTDSFOCTRL");
        m_regmodel.set_field_value(1'b1, "TXTDSFOFSRATIOEN", "TXTDSFOCTRL");
        m_regmodel.set_field_value(txtdsfofsratio, "TXTDSFOFSRATIO", "TXTDSFOCTRL");

        txtdsfophase = $urandom_range(0, 33554431);
        m_regmodel.set_field_value(1'b1, "TXTDCFOPHASEFORCE", "TXTDCFOCTRL");
        m_regmodel.set_field_value(1'b1, "TXTDCFOPHASEEN", "TXTDCFOCTRL");
        m_regmodel.set_field_value(txtdsfophase, "TXTDCFOPHASE", "TXTDCFOCTRL");
      end
      else begin
        m_regmodel.set_field_value(1'b0, "TXTDSFOFSRATIOFORCE", "TXTDSFOCTRL");
        m_regmodel.set_field_value(1'b0, "TXTDCFOPHASEFORCE", "TXTDCFOCTRL");
      end

      frame.calc_leg_ht_length();
      `uvm_info(get_type_name(), $sformatf("Frame configuration :\n%s", frame.sprint()), UVM_LOW)

      // Set the PRIMARYIND register
      m_regmodel.set_reg_value(frame.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

      // NOTE: non HE frames need to enable this field
      if (frame.ppdu_format < HE_SU)
        m_regmodel.set_field_value(1'b1,"FDDCCOMPEN","EQUALCTRL0","PHYCONFIG");
      else
        m_regmodel.set_field_value(1'b0,"FDDCCOMPEN","EQUALCTRL0","PHYCONFIG");

      // transmit frame
      tx_ppdu_frame(frame);

      insert_idle_cycles(100);

    end
  endtask : body

endclass : modem_tx_seq


`endif //MODEM_TX_SEQ_SV
