//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_CUSTOM_RX_SEQ_SV
`define WLAN_CUSTOM_RX_SEQ_SV


class wlan_custom_rx_seq extends wlan_seq_base;

  `uvm_object_utils(wlan_custom_rx_seq)

  PPDU_frame              data_frame;
  bit [31:0]              rx_buff_rd_ptr;
  int                     ksr_index;
  int                     rhd_cnt;
  int                     rpd_cnt;
  bit [31:0]              TID;
  bit [11:0]              SSN;


  function new (string name = "wlan_custom_rx_seq");
    super.new (name);
    data_frame = PPDU_frame::type_id::create("data_frame");
  endfunction : new


  virtual task body();
    super.body();

    // setup DUT registers
    m_regmodel.set_field_value(0, "OFDMONLY", "RWNXAGCCNTL", "RIUKARST");

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0))
          refresh_RF_data(); // call AGC update task only if necessary
      end

      drive_noise_adc();
    join_none

    create_keystorageRAM();

    create_dev_and_bss_addr();

    // set Rx interrupt masks
    m_regmodel.set_field_value(1'b1, "maskrxBuffer1Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masktimerRxTrigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "maskrxBuffer2Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masterTxRxIntEn", "TXRXINTUNMASKREG"); // Enables interrupt generation

    // put MAC core to active state
    change_mac_core_state(`ACTIVE_STATE);

    `uvm_info(get_type_name(), $sformatf("Simulation reception of one custom frame"), UVM_LOW)

    if (data_frame.ppdu_format == HE_MU)
      m_regmodel.set_reg_value(data_frame.preamble_header.user_header_he[0].dut_location_f,"HE_STAID_TAB0","PHYCONFIG");

    data_frame.ampdu_frame[0].clear_all_arrays();
    assert (data_frame.ampdu_frame[0].randomize() with {
      data_frame.ampdu_frame[0].ppdu_format == data_frame.ppdu_format;
      data_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
      data_frame.ampdu_frame[0].mpdu_frame_type[0][5:4] == `DATA_MPDU;
      data_frame.ampdu_frame[0].aggregated == 0;
      });

    ksr_index = get_random_ksr_index(data_frame);
    // set MAC address
    data_frame.ampdu_frame[0].set_MAC_addr(
      .TA   (dev_addr),
      .RA   (m_ksr.keyRAM[ksr_index].mac_addr_ram_f),
      .BSSID(bss_addr)
    );

    // get the TID for every frame and update TID table
    TID = data_frame.ampdu_frame[0].get_MAC_tid_num();
    SSN = data_frame.ampdu_frame[0].get_MAC_seq_num();
    for (int i = 0; i < m_cfg.TID_table.size(); i++) begin
      if (m_cfg.TID_table[i].TID == TID && m_cfg.TID_table[i].ksr_index == ksr_index) begin
        SSN = m_cfg.TID_table[i].SSN + `WINDOWSIZE + 2;
        data_frame.ampdu_frame[0].set_MAC_seq_num(SSN);
        break;
      end
    end

    // Write ksr_index into TID_table
    m_cfg.ksr_index = ksr_index;

    data_frame.setup_rx_encrypted_data;
    data_frame.calc_leg_ht_length();

    `uvm_info(get_type_name(), $sformatf("Frame configuration :\n%s", data_frame.sprint()), UVM_LOW)

    // get number of MPDUs in A-MPDU and byte size
    rhd_cnt = data_frame.ampdu_frame[0].mpdu_frame_type.size()*4*`RHD_LEN;
    rpd_cnt = data_frame.ampdu_frame[0].size();
    // prepare SRAM for Rx
    prepare_sram_for_rx(rhd_cnt + rpd_cnt);
    m_regmodel.get_reg_value(rdata, "RXBUF1RDPTRREG");
    rx_buff_rd_ptr = rdata + rhd_header;

    // receive ACK and wait for interrupt Rx trigger
    fork
      // if frames if going to be received trigger will occur,
      // if frames if filtered event will occur
      fork
        wait_mac_rx_trigger();
        rx_frame_filtered();
      join_any

      // if there is no response from MAC wait for sync
      if (responde_to_frame(data_frame, dev_addr)) begin
        // PHY sends frame to MAC core
        drive_phy_adc(data_frame);
        wait_tx_end();// wait ACK
        drive_noise_adc();
      end
      else begin
        // PHY sends frame to MAC core
        drive_phy_adc(data_frame);
        no_resp_trigger.wait_trigger();
      end
    join

    // only if frame was stored in SRAM do read
    if (!stop_pooling) begin
      `uvm_info(get_type_name(),
      "MAC core received frame and stored it to SRAM", UVM_LOW)
      rd_frame_from_sram(rx_buff_rd_ptr);
      insert_idle_cycles(5);
      get_next_rhd_ptr(1, rx_buff_rd_ptr, rx_buff_rd_ptr);
    end

    // clear interrupt flag
    m_regmodel.set_field_value(1'b1, "clearrxBuffer1Trigger", "TXRXINTEVENTCLEARREG");
    m_regmodel.set_field_value(1'b1, "cleartimerRxTrigger", "TXRXINTEVENTCLEARREG");
    m_regmodel.set_field_value(1'b1, "clearrxBuffer2Trigger", "TXRXINTEVENTCLEARREG");

    // To give a time for interrupt comparison
    insert_idle_cycles(10);

  endtask : body

endclass : wlan_custom_rx_seq


`endif //WLAN_CUSTOM_RX_SEQ_SV


