//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_CUSTOM_TX_SEQ_SV
`define WLAN_CUSTOM_TX_SEQ_SV


class wlan_custom_tx_seq extends wlan_seq_base;

  `uvm_object_utils(wlan_custom_tx_seq)

  PPDU_frame              data_frame;
  PPDU_frame              ack_frame;

  mac_ctrl_info_1_s       mac_ctrl_info_1;
  mac_ctrl_info_2_s       mac_ctrl_info_2;

  int                     ksr_index;
  rand nav_prot_frm_e     prot;
  rand expect_ack_e       expect_ack;
  rand access_category_e  ac;

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------
  constraint c_prot_ack {
    prot == NO_PROT;
    ac inside {AC_BE,AC_BK,AC_VI,AC_VO};
    expect_ack == NO_ACK;
  }

  function new (string name = "wlan_custom_tx_seq");
    super.new (name);
    data_frame = PPDU_frame::type_id::create("data_frame");
  endfunction : new


  virtual task body();
    super.body();

    // setup DUT registers
    m_regmodel.set_field_value(0, "OFDMONLY", "RWNXAGCCNTL", "RIUKARST");

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      begin  // thread 1
        if ((`AGC_ON == 1) && (agcBypass == 0))
          refresh_RF_data(); // call AGC update task only if necessary
      end
    join_none

    create_keystorageRAM();

    create_dev_and_bss_addr();

    //prepare SRAM for RX, with smaller RX segment
    prepare_sram_for_rx(1000, 1);
    // don't accept control frames
    m_regmodel.set_field_value(1'b0, "acceptBA",  "RXCNTRLREG");
    m_regmodel.set_field_value(1'b0, "acceptNotExpectedBA", "RXCNTRLREG");
    m_regmodel.set_field_value(1'b0, "acceptBAR", "RXCNTRLREG");
    m_regmodel.set_field_value(1'b0, "acceptRTS", "RXCNTRLREG");
    m_regmodel.set_field_value(1'b0, "acceptCTS", "RXCNTRLREG");
    m_regmodel.set_field_value(1'b0, "acceptACK", "RXCNTRLREG");

    // put MAC core to active state
    change_mac_core_state(`ACTIVE_STATE);

    `uvm_info(get_type_name(), $sformatf("Simulation reception of one custom frame"), UVM_LOW)

    data_frame.ampdu_frame[0].clear_all_arrays();
    assert (data_frame.ampdu_frame[0].randomize() with {
      data_frame.ampdu_frame[0].ppdu_format == data_frame.ppdu_format;
      data_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
      data_frame.ampdu_frame[0].mpdu_frame_type[0][5:4] == `DATA_MPDU;
      data_frame.ampdu_frame[0].aggregated == 0;
      });

    ksr_index = get_random_ksr_index(data_frame);
    // set MAC address
    data_frame.ampdu_frame[0].set_MAC_addr(
      .TA   (dev_addr),
      .RA   (m_ksr.keyRAM[ksr_index].mac_addr_ram_f),
      .BSSID(bss_addr)
    );
    data_frame.encrypt(.ra(1));
    data_frame.calc_leg_ht_length();

    `uvm_info(get_type_name(), $sformatf("Frame configuration :\n%s", data_frame.sprint()), UVM_LOW)

    // configure MAC control 1 field for THD
    mac_ctrl_info_1.prot_frm_dur_f   = 16'd0;
    mac_ctrl_info_1.write_ack_f      = 0;
    mac_ctrl_info_1.low_rate_retry_f = 0;
    mac_ctrl_info_1.lstp_prot_f      = 0;
    mac_ctrl_info_1.lstp_f           = 0;
    mac_ctrl_info_1.expect_ack_f     = NO_ACK; //normal ACK

    // configure MAC control 2 field for THD
    mac_ctrl_info_2.dont_generate_mh_f = 0;
    mac_ctrl_info_2.dont_encrypt_f     = 0;
    mac_ctrl_info_2.dont_touch_fc_f    = 0;
    mac_ctrl_info_2.dont_touch_dur_f   = 0;
    mac_ctrl_info_2.dont_touch_qos_f   = 0;
    mac_ctrl_info_2.dont_touch_htc_f   = 0;
    mac_ctrl_info_2.dont_touch_tsf_f   = 0;
    mac_ctrl_info_2.dont_touch_dtim_f  = 0;
    mac_ctrl_info_2.dont_touch_fcs_f   = 0;
    mac_ctrl_info_2.under_ba_setup_f   = 0;
    mac_ctrl_info_2.num_blank_delimit_f = 0;
    mac_ctrl_info_2.int_en_f            = 1;

    // determine type of NAV protection frame exchange
    `uvm_info(get_type_name(),$sformatf("NAV protection %s",prot.name()),UVM_LOW)
    // expected ACK
    `uvm_info(get_type_name(),$sformatf("Expected ACK: %s",expect_ack.name()),UVM_LOW)
    // access category
    `uvm_info(get_type_name(),$sformatf("Access category %s",ac.name()),UVM_LOW)

    // Store PPDU frame in SRAM for trasmit
    wr_frame_to_sram(data_frame,
                     mac_ctrl_info_1,
                     mac_ctrl_info_2,
                     prot,
                     32'h80);

    // set Tx interrupt masks for AC
    set_ac_interrupts(ac);
    set_DMA_for_tx(ac);

    // collect data frame
    wait_tx_end();
    drive_noise_adc();

    wait_mac_tx_trigger(ac);

    // read THD status from SRAM
    rd_tx_status_from_sram(
      .head     (m_cfg.m_sram_cfg.thd_head_ptr),
      .skip_athd((expect_ack == NO_ACK) ? 0 : 1) // read A-THD if BAR is sent
    );

    insert_idle_cycles(30);

    clear_ac_interrupts(ac);

  endtask : body

endclass : wlan_custom_tx_seq


`endif //WLAN_CUSTOM_TX_SEQ_SV

