
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_MAC_STATE_CHANGE_SEQ_SV
`define WLAN_MAC_STATE_CHANGE_SEQ_SV


class wlan_mac_state_change_seq extends wlan_seq_base;

  `uvm_object_utils(wlan_mac_state_change_seq)

  //--------------------------------------------------------------------
  // Constraints
  //--------------------------------------------------------------------

  function new (string name = "wlan_mac_state_change_seq");
    super.new (name);
  endfunction : new


  virtual task body();
    super.body();

    // put MAC core to ACTIVE state
    change_mac_core_state(`ACTIVE_STATE);
    insert_idle_cycles(10);
    wait_mac_core_state_movement(`ACTIVE_STATE);

    // put MAC core to IDLE state
    change_mac_core_state(`IDLE_STATE);
    insert_idle_cycles(35);
    wait_mac_core_state_movement(`IDLE_STATE);

    // put MAC core to ACTIVE state
    change_mac_core_state(`ACTIVE_STATE);
    insert_idle_cycles(25);
    wait_mac_core_state_movement(`ACTIVE_STATE);

    // put MAC core to IDLE state
    change_mac_core_state(`IDLE_STATE);
    insert_idle_cycles(300);
    wait_mac_core_state_movement(`IDLE_STATE);

    // put MAC core to DOZE state
    change_mac_core_state(`DOZE_STATE);
    insert_idle_cycles(300);
    wdata = 0;
    wdata[31] = 1;
    m_regmodel.set_reg_value(wdata, "DOZECNTRL2REG");

    // put MAC core to IDLE state
    change_mac_core_state(`IDLE_STATE);
    insert_idle_cycles(300);
    wait_mac_core_state_movement(`IDLE_STATE);

    // put MAC core to ACTIVE state
    change_mac_core_state(`ACTIVE_STATE);
    insert_idle_cycles(300);
    wait_mac_core_state_movement(`ACTIVE_STATE);

    // put MAC core to IDLE state
    change_mac_core_state(`IDLE_STATE);
    wait_mac_core_state_movement(`IDLE_STATE);

    insert_idle_cycles(30);

  endtask : body

endclass : wlan_mac_state_change_seq


`endif // WLAN_MAC_STATE_CHANGE_SEQ_SV

