//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_REGS_RESET_SEQ_SV
`define WLAN_REGS_RESET_SEQ_SV


class wlan_regs_reset_seq extends wlan_seq_base;

  `uvm_object_utils(wlan_regs_reset_seq)


  uvm_reg         reg_array[$];
  uvm_reg_data_t  reset_value;

  int     num_tested_regs;
  int     num_skipped_regs;
  int     num_wo_regs;

  function new (string name = "wlan_regs_reset_seq");
    super.new (name);
  endfunction : new

  task check_reset_value(uvm_reg dut_reg);
    if (dut_reg.has_reset() == 0) begin
      `uvm_warning(get_type_name(), $sformatf("Register %s.%s has no reset value in register model!", get_reg_parent(dut_reg), dut_reg.get_name()))
    end else if (dut_reg.get_rights == "WO") begin
        num_wo_regs++;
        `uvm_info(get_type_name(), $sformatf("Register %s.%s skipping as it is marked WO.",get_reg_parent(dut_reg), dut_reg.get_name()), UVM_LOW)
    end else begin
      reset_value = dut_reg.get_reset();
      dut_reg.read(status, rdata);
      if (rdata !== reset_value) begin
        `uvm_error(get_type_name(), $sformatf("Register %s.%s model reset value 0x%8x and DUT reset value 0x%8x differ!",get_reg_parent(dut_reg), dut_reg.get_name(), reset_value, rdata))
      end else begin
        `uvm_info(get_type_name(), $sformatf("Register %s.%s model reset value 0x%8x is correct.",get_reg_parent(dut_reg), dut_reg.get_name(), reset_value), UVM_LOW)
      end
    end
  endtask: check_reset_value

  virtual task body();
    super.body();

    num_tested_regs = 0;
    num_skipped_regs = 0;
    num_wo_regs = 0;

    m_regmodel.get_registers(reg_array); // get the names of all registers in the model in all sub blocks
    reg_array.shuffle();  // and shuffle the array

    foreach(reg_array[i]) begin
        num_tested_regs++;
        if (skip_reg(reg_array[i]) == 'b0) begin
          check_reset_value(reg_array[i]);
        end else begin
          num_skipped_regs++;
          `uvm_info(get_type_name(), $sformatf("Skipping register %s.%s",  get_reg_parent(reg_array[i]), reg_array[i].get_name()), UVM_LOW)
        end
    end

    insert_idle_cycles(5);

    `uvm_info(get_type_name(), "Register reset value test completed.", UVM_LOW)
    `uvm_info(get_type_name(), $sformatf("\n\n******************* Register test stats *******************\nTotal number of registers   : %4d\nNumber of WO registers      : %4d\nNumber of skipped registers : %4d", num_tested_regs, num_wo_regs, num_skipped_regs), UVM_LOW)

  endtask : body

endclass : wlan_regs_reset_seq


`endif //WLAN_REGS_RESET_SEQ_SV
