//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_REGS_RW_SEQ_SV
`define WLAN_REGS_RW_SEQ_SV


class wlan_regs_rw_seq extends wlan_seq_base;

  `uvm_object_utils(wlan_regs_rw_seq)

  localparam REG_DATA_WIDTH = 32;

  uvm_reg         reg_array[$];
  uvm_reg         register;
  uvm_reg_data_t  reset_value;

  int             num_tested_regs;
  int             num_skipped_regs;
  int             num_non_rw_regs;
  int             num_runs;
  int             iteration;

  function new (string name = "wlan_regs_rw_seq");
    super.new (name);
  endfunction : new

  task check_rw(uvm_reg dut_reg);
    uvm_reg_field field_array[$];
    int field_width;
    int lsb_pos;
    bit [REG_DATA_WIDTH-1:0] bit_mask;

    dut_reg.get_fields(field_array);
    bit_mask = 0;

    foreach(field_array[i]) begin
      if (   field_array[i].get_access() == "RW"
          && (field_array[i].get_name() != "softReset" && field_array[i].get_name() != "masterGenIntEn")
         ) begin // softReset field is exluded from test

        field_width = field_array[i].get_n_bits();
        lsb_pos = field_array[i].get_lsb_pos();
        bit_mask = bit_mask |  ( ((1'b1 << field_width) - 1) << lsb_pos);
      end else begin
          `uvm_info(get_type_name(), $sformatf("Register %s.%s field %s skipped as it doesn't have RW access.",
          get_reg_parent(dut_reg), dut_reg.get_name(), field_array[i].get_name()), UVM_LOW)
      end
    end //foreach

    `uvm_info(get_type_name(), $sformatf("Register %s.%s getting checked...", get_reg_parent(dut_reg), dut_reg.get_name()), UVM_LOW)

    // generate random value and mask it
    wdata = $urandom_range(0,((2**REG_DATA_WIDTH)-1)) & bit_mask;

    // write masked data to DUT
    dut_reg.write(status, wdata);

    //read back the data
    dut_reg.read(status, rdata);

    // now check if the read data matches the write data (all with applied bit-masks)
    if ((rdata & bit_mask) !== wdata && dut_reg.get_rights() == "RW") begin
      `uvm_error(get_type_name(), $sformatf("Register %s.%s write 0x%8x and read value 0x%8x differ (bit mask: 0x%x)!", get_reg_parent(dut_reg), dut_reg.get_name(), wdata, rdata, bit_mask))
    end else begin
      `uvm_info(get_type_name(), $sformatf("Register %s.%s read and write value 0x%8x match.", get_reg_parent(dut_reg), dut_reg.get_name(), wdata), UVM_LOW)
    end
  endtask: check_rw

  virtual task body();
    super.body();

    num_tested_regs = 0;
    num_skipped_regs = 0;
    num_non_rw_regs = 0;
    num_runs = $urandom_range(10,100);
    iteration = 0;

    m_regmodel.get_registers(reg_array); // get the names of all registers in the model in all sub blocks

    do begin
      reg_array.shuffle();  // and shuffle the array

      foreach(reg_array[i]) begin
        num_tested_regs++;
        if (skip_reg(reg_array[i]) == 'b0) begin
          check_rw(reg_array[i]);
        end else begin
          num_skipped_regs++;
          `uvm_info(get_type_name(), $sformatf("Skipping register %s.%s",  get_reg_parent(reg_array[i]), reg_array[i].get_name()), UVM_LOW)
        end
      end

      iteration++;
      `uvm_info(get_type_name(),
      $sformatf("\n\n******************* Register test stats (%2d of %2d)*******************\nTotal number of registers   : %4d\nNumber of WO/RO registers   : %4d\nNumber of skipped registers : %4d",
      iteration, num_runs, num_tested_regs, num_non_rw_regs, num_skipped_regs), UVM_LOW)

      insert_idle_cycles(5);
    end while ( iteration < num_runs);

    m_regmodel.set_field_value(1'b1, "macPHYIFFIFOReset", "MACERRRECCNTRLREG");
    m_regmodel.set_field_value(1'b1, "txFIFOReset", "MACERRRECCNTRLREG");
    m_regmodel.set_field_value(1'b1, "rxFIFOReset", "MACERRRECCNTRLREG");
    m_regmodel.set_field_value(1'b1, "hwFSMReset", "MACERRRECCNTRLREG");
    insert_idle_cycles(5);
    m_regmodel.set_field_value(1'b0, "macPHYIFFIFOReset", "MACERRRECCNTRLREG");
    m_regmodel.set_field_value(1'b0, "txFIFOReset", "MACERRRECCNTRLREG");
    m_regmodel.set_field_value(1'b0, "rxFIFOReset", "MACERRRECCNTRLREG");
    m_regmodel.set_field_value(1'b0, "hwFSMReset", "MACERRRECCNTRLREG");

    // SW reset MAC
    m_regmodel.set_field_value(1'b1, "softReset", "MACCNTRL2REG");
    insert_idle_cycles(5);
    m_regmodel.set_field_value(1'b0, "softReset", "MACCNTRL2REG");
    insert_idle_cycles(5);

    // stress DIAG registers
    reg_array.delete();
    register = m_regmodel.get_reg_by_name("DIAG_CONF0");
    reg_array.push_front(register);
    register = m_regmodel.get_reg_by_name("DIAG_CONF1");
    reg_array.push_front(register);
    register = m_regmodel.get_reg_by_name("DIAG_CONF2");
    reg_array.push_front(register);
    register = m_regmodel.get_reg_by_name("DIAG_CONF3");
    reg_array.push_front(register);
    register = m_regmodel.get_reg_by_name("DEBUGPORTVALUEREG");
    reg_array.push_front(register);

    iteration = 0;
    do begin
      reg_array.shuffle();  // and shuffle the array

      foreach(reg_array[i]) begin
        num_tested_regs++;
        if (skip_reg(reg_array[i]) == 'b0) begin
          check_rw(reg_array[i]);
        end else begin
          num_skipped_regs++;
          `uvm_info(get_type_name(), $sformatf("Skipping register %s.%s",  get_reg_parent(reg_array[i]), reg_array[i].get_name()), UVM_LOW)
        end
      end

      iteration++;
      `uvm_info(get_type_name(),
      $sformatf("\n\n******************* Diag register test stats (%2d of %2d)*******************\nTotal number of registers   : %4d\nNumber of WO/RO registers   : %4d\nNumber of skipped registers : %4d",
      iteration, num_runs, num_tested_regs, num_non_rw_regs, num_skipped_regs), UVM_LOW)

      insert_idle_cycles(5);
    end while ( iteration < num_runs);

  endtask : body

endclass : wlan_regs_rw_seq


`endif //WLAN_REGS_RW_SEQ_SV
