//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_RX_DSSS_FRAME_SEQ_SV
`define WLAN_RX_DSSS_FRAME_SEQ_SV


class wlan_rx_dsss_frame_seq extends wlan_seq_base;

  `uvm_object_utils(wlan_rx_dsss_frame_seq)

  PPDU_frame                 data_frame;
  bit [31:0]                 rx_buff_rd_ptr;
  int                        ksr_index;
  int                        frame_num;
  int                        rhd_cnt;
  int                        rpd_cnt;
  real                       invcarrierfreq;

  //---------------------------------------------
  // constraints
  //---------------------------------------------
  constraint c_carrier_freq {
    carrier_freq inside {2412, 2417, 2422, 2427, 2432, 2437, 2442,
                         2447, 2452, 2457, 2462, 2467, 2472, 2484};
  }

  function new (string name = "wlan_rx_dsss_frame_seq");
    super.new (name);

  endfunction : new

  virtual task body();
    super.body();

    // setup DUT registers
    m_regmodel.set_field_value(0, "OFDMONLY", "RWNXAGCCNTL", "RIUKARST");
    // Make sure to set 2.4GHz for DSSS
    invcarrierfreq = (2**26)/real'(carrier_freq);
    m_regmodel.set_field_value(int'(invcarrierfreq),"INVCARRIERFREQ");
    // set PSSELECT
    m_regmodel.set_field_value(2'b01, "PSSELECT", "RWNXMACSTATICCONFIG", "RIUKARST");
    // Set the PRIMARYIND register
    m_regmodel.set_reg_value(0, "PRIMARYIND","PHYCONFIG");

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      if ((`AGC_ON == 1) && (agcBypass == 0))
        refresh_RF_data(); // call AGC update task only if necessary

      drive_noise_adc();
    join_none

    //--------------------------------------------
    // determine device and BSS address
    //--------------------------------------------
    create_keystorageRAM();

    create_dev_and_bss_addr();

    // set Rx interrupt masks
    m_regmodel.set_field_value(1'b1, "maskrxBuffer1Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masktimerRxTrigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "maskrxBuffer2Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masterTxRxIntEn", "TXRXINTUNMASKREG"); // Enables interrupt generation

    // put MAC core to active state
    change_mac_core_state(`ACTIVE_STATE);

    // prepare SRAM for Rx
    prepare_sram_for_rx(10000);
    m_regmodel.get_reg_value(rdata, "RXBUF1RDPTRREG");
    rx_buff_rd_ptr = rdata + rhd_header;

    frame_num = $urandom_range(3,5);
    for (int loop=0; loop < frame_num; loop++) begin
      `uvm_info(get_type_name(),$sformatf("Receive Frame number: %0d / %0d",
      loop+1,frame_num),UVM_LOW)

      data_frame = new("data_frame");
      //--------------------------------
      // create data frame for Rx
      //--------------------------------
      assert (data_frame.randomize() with {
        kind == SINGLETON;
        ppdu_format == NON_HT;
        tx_frame == 0;
      });

      // force DSSS frames
      data_frame.preamble_header.leg_rate = $urandom_range(0,3);
      if (data_frame.preamble_header.leg_rate == 0) begin
        data_frame.preamble_header.preamble_type = 1;
      end

      data_frame.ampdu_frame[0].clear_all_arrays();
      data_frame.ampdu_frame[0].is_dsss = 1'b1;
      assert (data_frame.ampdu_frame[0].randomize() with {
        data_frame.ampdu_frame[0].ppdu_format == data_frame.ppdu_format;
        data_frame.ampdu_frame[0].mpdu_frame_type.size() == 1;
        data_frame.ampdu_frame[0].mpdu_frame_type[0] inside {DATA,
                                                             DATA_CF_ACK,
                                                             DATA_CF_POLL,
                                                             DATA_CF_ACK_CF_POLL};
        data_frame.ampdu_frame[0].aggregated == 0;
      });

      // generate one KSR entry
      ksr_index = get_random_ksr_index(data_frame);
      // set MAC addresses
      data_frame.ampdu_frame[0].set_MAC_addr(
        .RA    (dev_addr),
        .TA    (m_ksr.keyRAM[ksr_index].mac_addr_ram_f),
        .BSSID (bss_addr)
      );

      // Write ksr_index into TID_table
      m_cfg.ksr_index = ksr_index;

      data_frame.setup_rx_encrypted_data();
      data_frame.calc_leg_ht_length();

      `uvm_info(get_type_name(),
      $sformatf("PPDU_frame:\n%s", data_frame.sprint()), UVM_LOW)

      // receive ACK and wait for interrupt Rx trigger
      fork
        // if frames if going to be received trigger will occur,
        // if frames if filtered event will occur
        fork
          wait_mac_rx_trigger();
          rx_frame_filtered();
        join_any

        // if there is no response from MAC wait for sync
        if (responde_to_frame(data_frame, dev_addr)) begin
          // PHY sends frame to MAC core
          drive_phy_adc(data_frame);
          wait_tx_end();// wait ACK
          drive_noise_adc();
        end
        else begin
          // PHY sends frame to MAC core
          drive_phy_adc(data_frame);
          no_resp_trigger.wait_trigger();
        end
      join

      // only if frame was stored in SRAM do read
      if (!stop_pooling) begin
        `uvm_info(get_type_name(),
        "MAC core received frame and stored it to SRAM", UVM_LOW)
        rd_frame_from_sram(rx_buff_rd_ptr);
        insert_idle_cycles(5);
        get_next_rhd_ptr(1, rx_buff_rd_ptr, rx_buff_rd_ptr);
      end

      // clear interrupt flag
      m_regmodel.set_field_value(1'b1, "clearrxBuffer1Trigger", "TXRXINTEVENTCLEARREG");
      m_regmodel.set_field_value(1'b1, "cleartimerRxTrigger", "TXRXINTEVENTCLEARREG");
      m_regmodel.set_field_value(1'b1, "clearrxBuffer2Trigger", "TXRXINTEVENTCLEARREG");

      // To give a time for interrupt comparison
      insert_idle_cycles(10);

    end //for

  endtask : body


endclass : wlan_rx_dsss_frame_seq

`endif // WLAN_RX_DSSS_FRAME_SEQ_SV

