//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef WLAN_RX_MUMIMO_FRAME_SEQ_SV
`define WLAN_RX_MUMIMO_FRAME_SEQ_SV


class wlan_rx_mumimo_frame_seq extends wlan_seq_base;

  `uvm_object_utils(wlan_rx_mumimo_frame_seq)

  PPDU_frame                 mu_mimo;
  int                        index;
  bit [31:0]                 rx_buff_rd_ptr;
  int                        ksr_index;
  int                        frame_num;
  int                        rhd_cnt;
  int                        rpd_cnt;
  bit [3:0]                  TID;
  bit [11:0]                 SSN;
  bit [1:0]                  primary_channel;
  he_control_s               he_ctrl;

  function new (string name = "wlan_rx_mumimo_frame_seq");
    super.new (name);

  endfunction : new

  virtual task body();
    super.body();

    // setup DUT registers
    m_regmodel.set_field_value(0, "OFDMONLY", "RWNXAGCCNTL", "RIUKARST");
    // enable MUMIMO Rx
    m_regmodel.set_field_value(1, "RXHEMUMIMOEN");
    m_regmodel.set_field_value(1, "RXVHTMUMIMOEN");

    agcBypass = m_cfg.m_radio_cfg.m_rui_cfg.agcBypass; // set from testcase

    // fork off gain update task
    fork  : GAIN_UPDATE
      if ((`AGC_ON == 1) && (agcBypass == 0))
        refresh_RF_data(); // call AGC update task only if necessary

      drive_noise_adc();
    join_none

    //--------------------------------------------
    // determine device and BSS address
    //--------------------------------------------
    create_keystorageRAM();

    create_dev_and_bss_addr();

    // set Rx interrupt masks
    m_regmodel.set_field_value(1'b1, "maskrxBuffer1Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masktimerRxTrigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "maskrxBuffer2Trigger", "TXRXINTUNMASKREG");
    m_regmodel.set_field_value(1'b1, "masterTxRxIntEn", "TXRXINTUNMASKREG"); // Enables interrupt generation

    // put MAC core to active state
    change_mac_core_state(`ACTIVE_STATE);

    frame_num = $urandom_range(5,10);
    for (int loop=0; loop < frame_num; loop++) begin
      `uvm_info(get_type_name(),$sformatf("Receive Frame number: %0d / %0d",
      loop+1,frame_num),UVM_LOW)

      mu_mimo = new("mu_mimo");
      //--------------------------------
      // create data frame for Rx
      //--------------------------------
      assert (mu_mimo.randomize() with {
        kind == MU_MIMO;
        tx_frame == 0;
      });

      // index of A-MPDU frame that is being received
      index = mu_mimo.preamble_header.mu_mimo_userid;
      ksr_index = get_random_ksr_index(mu_mimo, index);
      // set MAC addresses
      mu_mimo.ampdu_frame[index].set_MAC_addr(
        .RA    (dev_addr),
        .TA    (m_ksr.keyRAM[ksr_index].mac_addr_ram_f),
        .BSSID (bss_addr)
      );

      // Set the PRIMARYIND register
      m_regmodel.set_reg_value(mu_mimo.preamble_header.primary_channel,"PRIMARYIND","PHYCONFIG");

      if (mu_mimo.ppdu_format == HE_MU) begin
        // set STAID for received station
        m_regmodel.set_reg_value(mu_mimo.preamble_header.user_header_he[index].staid_f,"HE_STAID_TAB0","PHYCONFIG");
        // find RU allocation from HE control
        he_ctrl = get_ht_control(mu_mimo, index);
        // set proper RU allocation
        set_he_ctrl_ru_allocation(mu_mimo, he_ctrl, index);
        // set primary channle in register
        primary_channel = get_primary_channel(he_ctrl.ctrl_info_f.ru_allocation_f);
        `uvm_info(get_type_name(),$sformatf("Primary channel set to %0d, for RU allocation %0d",
        primary_channel, he_ctrl.ctrl_info_f.ru_allocation_f),UVM_LOW)
      end

      // get the TID for every frame and update TID table
      TID = mu_mimo.ampdu_frame[index].get_MAC_tid_num();
      SSN = mu_mimo.ampdu_frame[index].get_MAC_seq_num();
      for (int i = 0; i < m_cfg.TID_table.size(); i++) begin
        if (m_cfg.TID_table[i].TID == TID && m_cfg.TID_table[i].ksr_index == ksr_index) begin
          SSN = m_cfg.TID_table[i].SSN + `WINDOWSIZE + 2;
          mu_mimo.ampdu_frame[index].set_MAC_seq_num(SSN);
          break;
        end
      end

      // Write ksr index into TID table
      m_cfg.ksr_index = ksr_index;

      mu_mimo.setup_rx_encrypted_data();
      mu_mimo.calc_leg_ht_length();

      `uvm_info(get_type_name(),
      $sformatf("PPDU_frame:\n%s", mu_mimo.sprint()), UVM_LOW)

      // get number of MPDUs in A-MPDU and byte size
      rhd_cnt = mu_mimo.ampdu_frame[index].mpdu_frame_type.size()*4*`RHD_LEN;
      rpd_cnt = mu_mimo.ampdu_frame[index].size();
      // prepare SRAM for Rx
      prepare_sram_for_rx(rhd_cnt + rpd_cnt);
      m_regmodel.get_reg_value(rdata, "RXBUF1RDPTRREG");
      rx_buff_rd_ptr = rdata + rhd_header;

      // set group membersip
      if (mu_mimo.ppdu_format == VHT) begin
        phy_set_mu_group_memb(mu_mimo);
        phy_set_mu_userpos(mu_mimo);
      end

      // receive ACK and wait for interrupt Rx trigger
      fork
        // if frames going to be received, trigger will occur,
        // if frames is filtered, event will occur
        begin
          fork
            wait_mac_rx_trigger();
            rx_frame_filtered();
          join_any
        end

        // if there is no response from MAC wait for sync
        if (responde_to_frame(mu_mimo, dev_addr)) begin
          //must fork-join because sometimens we will receive shorter user but
          //ADC samples will still be driven for other longer user(s) so we
          //could miss RX/TX END asserting
          fork
            // PHY sends frame to MAC core
            drive_phy_adc(mu_mimo);
            begin
              // --------------------------------------------------------------------
              // read precompensation status registers in order to mirror there value
              // since there values are used in MDM STA setup (to avoid backdoor
              // access)
              // --------------------------------------------------------------------
              if (mu_mimo.ppdu_format == HE_MU) begin
                wait_rx_end();
                m_regmodel.get_reg_value(rdata,"RXCFOEST");
                m_regmodel.get_reg_value(rdata,"RXSFOEST");
              end
              // --------------------------------------------------------------------
              wait_tx_end();// wait ACK
            end
          join
        end
        else begin
          // PHY sends frame to MAC core
          drive_phy_adc(mu_mimo);
          no_resp_trigger.wait_trigger();
        end
      join

      // only if frame was stored in SRAM do read
      if (!stop_pooling) begin
        `uvm_info(get_type_name(),
        "MAC core received frame and stored it to SRAM", UVM_LOW)
        rd_frame_from_sram(rx_buff_rd_ptr);
      end

      insert_idle_cycles(16);

      // clear interrupt flag
      m_regmodel.set_field_value(1'b1, "clearrxBuffer1Trigger", "TXRXINTEVENTCLEARREG");
      m_regmodel.set_field_value(1'b1, "cleartimerRxTrigger", "TXRXINTEVENTCLEARREG");
      m_regmodel.set_field_value(1'b1, "clearrxBuffer2Trigger", "TXRXINTEVENTCLEARREG");

      // To give a time for interrupt comparison
      insert_idle_cycles(10);

    end //for

  endtask : body


endclass : wlan_rx_mumimo_frame_seq

`endif // WLAN_RX_MUMIMO_FRAME_SEQ_SV
