//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_DMA_SCOREBOARD_SV
`define MAC_DMA_SCOREBOARD_SV

class mac_dma_scoreboard extends mac_scoreboard_base;

  `uvm_component_utils(mac_dma_scoreboard)

  uvm_tlm_analysis_fifo #(axi_slave_seq_item) axi_write_slave_fifo;
  uvm_tlm_analysis_fifo #(axi_slave_seq_item) axi_read_slave_fifo;
  uvm_tlm_analysis_fifo #(sram_bus_seq_item)  sram_bus_write_fifo;
  sram_bus_seq_item                           sram_bus_write_seq_q[$];
  sram_bus_seq_item                           sram_bus_read_seq_q[$];

  struct {
           int unsigned axi_wr_num;
           int unsigned axi_rd_num;
           int unsigned bus_wr_num;
           int unsigned bus_rd_num;
         } wr_rd_stat;


  function new(string name = "mac_dma_scoreboard", uvm_component parent = null);
    super.new(name, parent);

    axi_write_slave_fifo = new("axi_write_slave_fifo", this);
    axi_read_slave_fifo = new("axi_read_slave_fifo", this);
    sram_bus_write_fifo = new("sram_bus_write_fifo", this);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  virtual task sram_read_write_separator();
    sram_bus_seq_item  sram_bus_tmp;
    forever begin
      // Separate READ and WRITE transaction
      sram_bus_write_fifo.get(sram_bus_tmp);
      if(sram_bus_tmp.addra > m_cfg.m_sram_bus_cfg.sram_lli_boundary) begin
        if(sram_bus_tmp.rnw == 1) begin
          sram_bus_read_seq_q.push_back(sram_bus_tmp); // Put transaction in the read queue
        end
        else begin
          sram_bus_write_seq_q.push_back(sram_bus_tmp);  // Put transaction in the  write queue
        end
      end
    end // forever
 endtask : sram_read_write_separator


  virtual task compare_mem_transfers_read();
    axi_slave_seq_item axi_read_slave_tmp;
    sram_bus_seq_item  sram_bus_tmp;
    forever begin
      axi_read_slave_fifo.get(axi_read_slave_tmp); // Get whole AXI transfer -> arlen contains number of data beats
      wr_rd_stat.axi_rd_num += axi_read_slave_tmp.arlen + 1; // Statistic
      wait(sram_bus_write_seq_q.size() >= axi_read_slave_tmp.arlen + 1);
      // check when checking enabled
      wait (m_cfg.mac_dma_check_en == 1'b1);

      // WRITE queue contains enough data for the comparison
      foreach (sram_bus_write_seq_q[j]) begin
        wr_rd_stat.bus_wr_num++; // Statistic
        if(sram_bus_write_seq_q[j].data == axi_read_slave_tmp.rdata[j]) begin
          // Comparison passed
          `uvm_info(get_type_name(), $sformatf("Comparison passed. SRAM write. Offset %2d Data %8x Strobe %2x", j, sram_bus_write_seq_q[j].data, sram_bus_write_seq_q[j].wea), UVM_HIGH)
        end
        else begin
          // Comparison failed
          `uvm_error(get_type_name(), $sformatf("Comparison failed. SRAM write. Offset %2d Data %8x Ref data %2x", j, sram_bus_write_seq_q[j].data, axi_read_slave_tmp.rdata[j]))
        end
      end
      // Remove compared elements
      repeat(axi_read_slave_tmp.arlen + 1) begin
        sram_bus_tmp = sram_bus_write_seq_q.pop_front();
      end
    end
  endtask : compare_mem_transfers_read


  virtual task compare_mem_transfers_write();
    axi_slave_seq_item axi_read_slave_tmp;
    sram_bus_seq_item  sram_bus_tmp;
    forever begin
      axi_write_slave_fifo.get(axi_read_slave_tmp); // Get whole AXI transfer -> awlen contains number of data beats
      wait (sram_bus_read_seq_q.size() >= axi_read_slave_tmp.awlen + 1);
      // check when checking enabled
      wait (m_cfg.mac_dma_check_en == 1'b1);

      wr_rd_stat.axi_wr_num += axi_read_slave_tmp.awlen + 1; // Statistic
      // WRITE queue contains enough data for the comparison
      for(int j = 0; j < axi_read_slave_tmp.awlen + 1; j++) begin
        wr_rd_stat.bus_rd_num++; // Statistic
        if(sram_bus_read_seq_q[j].data == axi_read_slave_tmp.wdata[j]  && sram_bus_read_seq_q[j].wea == axi_read_slave_tmp.wstrb[j] ) begin
          // Comparison passed
          `uvm_info(get_type_name(), $sformatf("Comparison passed. SRAM read. Offset %2d Data %8x Strobe %2x", j, sram_bus_read_seq_q[j].data, sram_bus_read_seq_q[j].wea), UVM_HIGH)
        end
        else begin
          // Comparison failed
          `uvm_error(get_type_name(), $sformatf("Comparison failed. SRAM read. Offset %2d Data %8x Ref data %2x", j, sram_bus_read_seq_q[j].data, axi_read_slave_tmp.wdata[j]))
        end
      end
      // Remove compared elements
      repeat(axi_read_slave_tmp.awlen + 1) begin
        sram_bus_tmp = sram_bus_read_seq_q.pop_front();
      end
    end
  endtask : compare_mem_transfers_write

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
    `uvm_info(get_type_name(), $sformatf("Statistic Num.of AXI WRITE beats %1d Num.of BUS READs %1d. Num.of AXI READ beats %1d Num.of BUS WRITEs %1d", wr_rd_stat.axi_wr_num, wr_rd_stat.bus_rd_num, wr_rd_stat.axi_rd_num, wr_rd_stat.bus_wr_num ), UVM_HIGH)
  endfunction : report_phase

  virtual task run_phase(uvm_phase phase);
    super.run_phase(phase);
    fork
     sram_read_write_separator();
     compare_mem_transfers_read();
     compare_mem_transfers_write();
    join_none;
  endtask : run_phase

endclass : mac_dma_scoreboard

`endif // MAC_DMA_SCOREBOARD_SV
