//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_IRQ_SCOREBOARD_SV
`define MAC_IRQ_SCOREBOARD_SV

class mac_irq_scoreboard extends mac_scoreboard_base;

  `uvm_component_utils(mac_irq_scoreboard)

  uvm_tlm_analysis_fifo#(irq_raw_seq_item#(`MAC_IRQ_CTRL_IN_WIDTH))   mac_irq_in_fifo;
  uvm_tlm_analysis_fifo#(irq_raw_seq_item#(`MAC_IRQ_CTRL_OUT_WIDTH))  mac_irq_out_fifo;

  irq_raw_seq_item #(`MAC_IRQ_CTRL_IN_WIDTH)  mac_irq_in_item;
  irq_raw_seq_item #(`MAC_IRQ_CTRL_OUT_WIDTH) mac_irq_out_item;

  int         irq_index_positions[$];
  int         irq_index;

  bit [31:0]  geninterrupt_masked;
  bit [31:0]  txrxinterrupt_masked;
  bit [31:0]  timersinterrupt_masked;
  bit         check_gen_irq;
  bit         check_txrxmisc_irq;
  bit         check_prot_irq;
  bit         check_tx_irq;
  bit         check_rx_irq;
  bit         check_txrxtimer_irq;

  extern function new(string name = "mac_irq_scoreboard", uvm_component parent = null);
  extern virtual function void build_phase(uvm_phase phase);
  extern virtual function void connect_phase(uvm_phase phase);
  extern virtual task run_phase(uvm_phase phase);

endclass : mac_irq_scoreboard

  function mac_irq_scoreboard::new(string name = "mac_irq_scoreboard", uvm_component parent = null);
    super.new(name, parent);
    mac_irq_in_fifo   = new("mac_irq_in_fifo", this);
    mac_irq_out_fifo  = new("mac_irq_out_fifo", this);
  endfunction : new

  function void mac_irq_scoreboard::build_phase(uvm_phase phase);
    super.build_phase(phase);

  endfunction : build_phase

  function void mac_irq_scoreboard::connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  task mac_irq_scoreboard::run_phase(uvm_phase phase);
    super.run_phase(phase);

    forever begin

      mac_irq_in_fifo.get(mac_irq_in_item);
      fetch_register_values();


      // Search the bit positions of the interrupts
      for (int i = 0; i < $bits(mac_irq_in_item.irq_sig); i++)begin
        if (mac_irq_in_item.irq_sig[i] == 1) begin
          irq_index_positions.push_front(i);
        end
      end

      // Mask the interrupt registers
      geninterrupt_masked     = genint_set & genint_unmask;
      txrxinterrupt_masked    = txrx_int_event & txrx_int_unmask;
      timersinterrupt_masked  = timers_int_event & timers_int_unmask;

      while (irq_index_positions.size() > 0) begin
        irq_index = irq_index_positions.pop_back();
        // GENINTEVENTREG
        if (irq_index < 26) begin
          // Read the register, if the masterGenIntEn is set, the geninterrupt
          // (if it's not masked) should be issued
          case (irq_index)
            `MAC_IRQ_MACPHYIFOVERFLOW_BIT_POS : begin
                                                  `uvm_error(get_type_name(),$sformatf("MAC-PHY IF overflow appeared"))
                                                end
            `MAC_IRQ_RXFIFOOVERFLOW_BIT_POS :   begin
                                                  `uvm_error(get_type_name(),$sformatf("RX FIFO overflow appeared"))
                                                end
            `MAC_IRQ_HWERR_BIT_POS :            begin
                                                  `uvm_error(get_type_name(),$sformatf("HW ERR appeared"))
                                                end
            `MAC_IRQ_MACPHYIFUNDERRUN_BIT_POS : begin
                                                  `uvm_error(get_type_name(),$sformatf("MAC-PHY IF underrun appeared"))
                                                end
            `MAC_IRQ_PHYERR_BIT_POS :           begin
                                                  `uvm_warning(get_type_name(),$sformatf("PHY ERR appeared"))
                                                end
            `MAC_IRQ_RXHEADERDMADEAD_BIT_POS :  begin
                                                  `uvm_warning(get_type_name(),$sformatf("RX HEADER DMA DEAD appeared"))
                                                end
            `MAC_IRQ_RXPAYLOADDMADEAD_BIT_POS : begin
                                                  `uvm_warning(get_type_name(),$sformatf("RX PAYLOAD DMA DEAD appeared"))
                                                end
            `MAC_IRQ_TBTXDMADEAD_BIT_POS :      begin
                                                  `uvm_warning(get_type_name(),$sformatf("TB TX DMA DEAD appeared"))
                                                end
          endcase
          if (genint_unmask[31] == 1) begin
            case (irq_index)
              `MAC_IRQ_IMPPRITBTT_BIT_POS :       begin
                                                    if(geninterrupt_masked[`IMPRITBTT_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_IMPPRITBTT_BIT_POS :       begin
                                                    if(geninterrupt_masked[`IMSECTBTT_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_IDLEINTERRUPT_BIT_POS :    begin
                                                    if(geninterrupt_masked[`IDLEINT_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_ABSGENTIMERS_BIT_POS :     begin
                                                    if(geninterrupt_masked[`ABSGENTIMER_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_COEXEVENT_BIT_POS :        begin
                                                    if(geninterrupt_masked[`COEXEVENT_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_MACPHYIFOVERFLOW_BIT_POS : begin
                                                    if(geninterrupt_masked[`MACPHYOVERFLOW_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_RXDMAEMPTY_BIT_POS :       begin
                                                    if(geninterrupt_masked[`RXDMAEMPTY_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_RXFIFOOVERFLOW_BIT_POS :   begin
                                                    if(geninterrupt_masked[`RXFIFOOVERFLOW_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_OLBCOFDM_BIT_POS :         begin
                                                    if(geninterrupt_masked[`OLBCOFDM_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_OLBCDSSS_BIT_POS :         begin
                                                    if(geninterrupt_masked[`OLBCDSS_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_TIMSET_BIT_POS :           begin
                                                    if(geninterrupt_masked[`TIMSET_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_PTERROR_BIT_POS :          begin
                                                    if(geninterrupt_masked[`PTERROR_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC0TXDMADEAD_BIT_POS :     begin
                                                    if(geninterrupt_masked[`AC0TXDMADEAD_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC1TXDMADEAD_BIT_POS :     begin
                                                    if(geninterrupt_masked[`AC1TXDMADEAD_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC2TXDMADEAD_BIT_POS :     begin
                                                    if(geninterrupt_masked[`AC2TXDMADEAD_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC3TXDMADEAD_BIT_POS :     begin
                                                    if(geninterrupt_masked[`AC3TXDMADEAD_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_BCNTXDMADEAD_BIT_POS :     begin
                                                    if(geninterrupt_masked[`BCNTXDMADEAD_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_IMPPRIDTIM_BIT_POS :       begin
                                                    if(geninterrupt_masked[`IMPRIDTIM_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_IMPSECDTIM_BIT_POS :       begin
                                                    if(geninterrupt_masked[`IMPSECDTIM_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_HWERR_BIT_POS :            begin
                                                    if(geninterrupt_masked[`HWERR_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_MACPHYIFUNDERRUN_BIT_POS : begin
                                                    if(geninterrupt_masked[`AC1TXDMADEAD_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_PHYERR_BIT_POS :           begin
                                                    if(geninterrupt_masked[`PHYERR_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_PHYRXSTART_BIT_POS :       begin
                                                    if(geninterrupt_masked[`PHYRXSTART_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_RXHEADERDMADEAD_BIT_POS :  begin
                                                    if(geninterrupt_masked[`RXHEADERDMADEAD_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_RXPAYLOADDMADEAD_BIT_POS : begin
                                                    if(geninterrupt_masked[`RXPAYLOADDMADEAD_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
              `MAC_IRQ_TBTXDMADEAD_BIT_POS :      begin
                                                    if(geninterrupt_masked[`TBTXDMADEAD_POS] == 1)
                                                      check_gen_irq = 1'b1;
                                                  end
            endcase
            if (check_gen_irq == 1'b1) begin
              mac_irq_out_fifo.get(mac_irq_out_item);
            end
          end
          else begin
            check_gen_irq = 1'b0;
          end
        end
        // TXRXINTEVENTREG
        else if (irq_index >= 26 && irq_index < 55) begin
          // Read the register, if the masterTxRxIntEn is set, the txrx_irq
          // (if it's not masked) should be issued
          if (txrxinterrupt_masked[31] == 1) begin
            case (irq_index)
              `MAC_IRQ_AC0PROTTRIGGER_BIT_POS :   begin
                                                    if(txrxinterrupt_masked[`AC0PROTTRIGGER_POS] == 1)
                                                      check_prot_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC1PROTTRIGGER_BIT_POS :   begin
                                                    if(txrxinterrupt_masked[`AC1PROTTRIGGER_POS] == 1)
                                                      check_prot_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC2PROTTRIGGER_BIT_POS :   begin
                                                    if(txrxinterrupt_masked[`AC2PROTTRIGGER_POS] == 1)
                                                      check_prot_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC3PROTTRIGGER_BIT_POS :   begin
                                                    if(txrxinterrupt_masked[`AC3PROTTRIGGER_POS] == 1)
                                                      check_prot_irq = 1'b1;
                                                  end
              `MAC_IRQ_TBPROTTRIGGER_BIT_POS :    begin
                                                    if(txrxinterrupt_masked[`TBPROTTRIGGER_POS] == 1)
                                                      check_prot_irq = 1'b1;
                                                  end
              `MAC_IRQ_RDPROTTRIGGER_BIT_POS :    begin
                                                    if(txrxinterrupt_masked[`RDPROTTRIGGER_POS] == 1)
                                                      check_prot_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC0TXTRIGGER_BIT_POS :     begin
                                                    if(txrxinterrupt_masked[`AC0TXTRIGGER_POS] == 1)
                                                      check_tx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC1TXTRIGGER_BIT_POS :     begin
                                                    if(txrxinterrupt_masked[`AC1TXTRIGGER_POS] == 1)
                                                      check_tx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC2TXTRIGGER_BIT_POS :     begin
                                                    if(txrxinterrupt_masked[`AC2TXTRIGGER_POS] == 1)
                                                      check_tx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC3TXTRIGGER_BIT_POS :     begin
                                                    if(txrxinterrupt_masked[`AC3TXTRIGGER_POS] == 1)
                                                      check_tx_irq = 1'b1;
                                                  end
              `MAC_IRQ_BCNTXTRIGGER_BIT_POS :     begin
                                                    if(txrxinterrupt_masked[`BCNTXTRIGGER_POS] == 1)
                                                      check_tx_irq = 1'b1;
                                                  end
              `MAC_IRQ_TBTXTRIGGER_BIT_POS :      begin
                                                    if(txrxinterrupt_masked[`TBTXTRIGGER_POS] == 1)
                                                      check_tx_irq = 1'b1;
                                                  end
              `MAC_IRQ_RDTXTRIGGER_BIT_POS :      begin
                                                    if(txrxinterrupt_masked[`AC0PROTTRIGGER_POS] == 1)
                                                      check_tx_irq = 1'b1;
                                                  end
              `MAC_IRQ_TXOPCOMPLETE_BIT_POS :     begin
                                                    if(txrxinterrupt_masked[`TXOPCOMPLETE_POS] == 1)
                                                      check_txrxmisc_irq = 1'b1;
                                                  end
              `MAC_IRQ_TIMERTXTRIGGER_BIT_POS :   begin
                                                    if(txrxinterrupt_masked[`TIMERTXTRIGGER_POS] == 1)
                                                      check_txrxtimer_irq = 1'b1;
                                                  end
              `MAC_IRQ_SECUSERTXTRIGGER_BIT_POS : begin
                                                    if(txrxinterrupt_masked[`SECUSERTXTRIGGER_POS] == 1)
                                                      check_tx_irq = 1'b1;
                                                  end
              `MAC_IRQ_RXBUFFER1TRIGGER_BIT_POS : begin
                                                    if(txrxinterrupt_masked[`RXBUFFER1TRIGGER_POS] == 1)
                                                      check_rx_irq = 1'b1;
                                                  end
              `MAC_IRQ_TIMERRXTRIGGER_BIT_POS :   begin
                                                    if(txrxinterrupt_masked[`TIMERRXTRIGGER_POS] == 1)
                                                      check_txrxtimer_irq = 1'b1;
                                                  end
              `MAC_IRQ_RXBUFFER2TRIGGER_BIT_POS : begin
                                                    if(txrxinterrupt_masked[`RXBUFFER2TRIGGER_POS] == 1)
                                                      check_rx_irq = 1'b1;
                                                  end
              `MAC_IRQ_COUNTERRXTRIGGER_BIT_POS : begin
                                                    // if(txrxinterrupt_masked[`COUNTERRXTRIGGER_POS] == 1)
                                                      // check_txrx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC0BWDROPTRIGGER_BIT_POS : begin
                                                    // if(txrxinterrupt_masked[`AC0BWDROPTRIGGER_POS] == 1)
                                                      // check_txrx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC1BWDROPTRIGGER_BIT_POS : begin
                                                    // if(txrxinterrupt_masked[`AC1BWDROPTRIGGER_POS] == 1)
                                                      // check_txrx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC2BWDROPTRIGGER_BIT_POS : begin
                                                    // if(txrxinterrupt_masked[`AC2BWDROPTRIGGER_POS] == 1)
                                                      // check_txrx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC3BWDROPTRIGGER_BIT_POS : begin
                                                    // if(txrxinterrupt_masked[`AC3BWDROPTRIGGER_POS] == 1)
                                                      // check_txrx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC0TXBUFTRIGGER_BIT_POS :  begin
                                                    // if(txrxinterrupt_masked[`AC0TXBUFTRIGGER_POS] == 1)
                                                      // check_txrx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC1TXBUFTRIGGER_BIT_POS :  begin
                                                    // if(txrxinterrupt_masked[`AC1TXBUFTRIGGER_POS] == 1)
                                                      // check_txrx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC2TXBUFTRIGGER_BIT_POS :  begin
                                                    // if(txrxinterrupt_masked[`AC2TXBUFTRIGGER_POS] == 1)
                                                      // check_txrx_irq = 1'b1;
                                                  end
              `MAC_IRQ_AC3TXBUFTRIGGER_BIT_POS :  begin
                                                    // if(txrxinterrupt_masked[`AC3TXBUFTRIGGER_POS] == 1)
                                                      // check_txrx_irq = 1'b1;
                                                  end
              `MAC_IRQ_BCNTXBUFTRIGGER_BIT_POS :  begin
                                                    // if(txrxinterrupt_masked[`BCNTXBUFTRIGGER_POS] == 1)
                                                      // check_txrx_irq = 1'b1;
                                                  end
            endcase
            if (  check_txrxmisc_irq == 1'b1
              ||  check_prot_irq == 1'b1
              ||  check_tx_irq == 1'b1
              ||  check_rx_irq == 1'b1
              ||  check_txrxtimer_irq == 1'b1) begin
                `uvm_info(get_type_name(),$sformatf("Waiting for some interrupt"),UVM_LOW)
                mac_irq_out_fifo.get(mac_irq_out_item);
            end
          end
          else begin
            check_txrxmisc_irq = 1'b0;
            check_prot_irq = 1'b0;
            check_tx_irq = 1'b0;
            check_rx_irq = 1'b0;
            check_txrxtimer_irq = 1'b0;
          end
        end
      end

      if (check_gen_irq == 1'b1) begin
        check_gen_irq = 1'b0;
        if (mac_irq_out_item.irq_sig[`MAC_IRQ_OUT_INTGEN_N_BIT_POS] == 0) begin
          `uvm_error(get_type_name(),$sformatf("The GENINTEVENT interrupt didn't appeard!!!"))
        end
      end

      if (check_txrxmisc_irq == 1'b1)  begin
        check_txrxmisc_irq = 1'b0;
        if (mac_irq_out_item.irq_sig[`MAC_IRQ_OUT_INTTXRXMISC_N_BIT_POS] == 0) begin
          `uvm_error(get_type_name(),$sformatf("The TXRXMISC interrupt didn't appeared!!!"))
        end
      end

      if (check_prot_irq == 1'b1) begin
        check_prot_irq = 1'b0;
        if (mac_irq_out_item.irq_sig[`MAC_IRQ_OUT_INTPROTTRIGGER_N_BIT_POS] == 0) begin
          `uvm_error(get_type_name(),$sformatf("The PROTTRIGGER interrupt didn't appeared!!!"))
        end
      end

      if (check_tx_irq == 1'b1) begin
        check_tx_irq = 1'b0;
        if (mac_irq_out_item.irq_sig[`MAC_IRQ_OUT_INTTXTRIGGER_N_BIT_POS] == 0) begin
          `uvm_error(get_type_name(),$sformatf("The TXTRIGGER interrupt didn't appeared!!!"))
        end
      end

      if (check_rx_irq == 1'b1) begin
        check_rx_irq = 1'b0;
        if (mac_irq_out_item.irq_sig[`MAC_IRQ_OUT_INTRXTRIGGER_N_BIT_POS] == 0) begin
          `uvm_error(get_type_name(),$sformatf("The RXTRIGGER interrupt didn't appeared!!!"))
        end
      end

      if (check_txrxtimer_irq == 1'b1) begin
        check_rx_irq = 1'b0;
        if (mac_irq_out_item.irq_sig[`MAC_IRQ_OUT_INTTXRXTIMER_N_BIT_POS] == 0) begin
          `uvm_error(get_type_name(),$sformatf("The TXRXTIMER interrupt didn't appeared!!!"))
        end
      end

      if (mac_irq_out_fifo.size() > 0) begin
        mac_irq_out_fifo.get(mac_irq_out_item);
        `uvm_error(get_type_name(),$sformatf("An interrupt appeared, although it was masked (%b)",mac_irq_out_item.irq_sig))
      end

    end // forever

  endtask : run_phase

`endif // MAC_IRQ_SCOREBOARD_SV
