//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef _MODEM_BF_SCOREBOARD_SV_
`define _MODEM_BF_SCOREBOARD_SV_

`uvm_analysis_imp_decl(_mac_bf)
`uvm_analysis_imp_decl(_macphy_if_bf)

class modem_bf_scoreboard extends modem_scoreboard_base;

  `uvm_component_utils(modem_bf_scoreboard)

  uvm_analysis_imp_mac_bf#(mac_bf_seq_item, modem_bf_scoreboard)   mac_bf_export;
  uvm_analysis_imp_macphy_if_bf#(mac_phy_seq_item, modem_bf_scoreboard) mac_phy_if_bf_export;
  uvm_tlm_analysis_fifo#(mem_seq_item#(`HMEM_WIDTH)) h_mem_fifo;

  mac_phy_seq_item       mac_phy_q[$], mac_phy_item;
  mac_bf_seq_item        mac_bf_q[$], mac_bf_item;
  mem_seq_item#(`HMEM_WIDTH) h_mem_item;
  bit [1:0]              nc;
  bit [1:0]              nr;
  bit [1:0]              grouping;
  bit                    feedback;
  bit                    codebook;
  bit [1:0]              ch_bw;
  bit                    bfm_bits[];
  bit [7:0]              bfm_report[];
  hmem_array             matlab_hmem_ref;
  PPDU_frame             ppdu;

  function new(string name = "modem_bf_scoreboard", uvm_component parent = null);
    super.new(name, parent);

    mac_bf_export  = new("mac_bf_export", this);
    mac_phy_if_bf_export = new("mac_phy_if_bf_export", this);
    h_mem_fifo   = new("h_mem_fifo", this);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      compare_Hmem();
    join_none

    forever begin

      // wait to receive NDP PPDU frame
      wait (mac_phy_q.size() != 0);
      mac_phy_item = mac_phy_q.pop_back();
      ppdu = mac_phy_item.frame;

      // get referent HMEM data
      matlab_hmem_ref = m_modem_cfg.get_bfr_hmem();

      if (mac_phy_item.trans == RX) begin
        `uvm_info(get_type_name(), $sformatf("Cheking BFMEE report"), UVM_LOW)
        // wait for for configuring PHY BFM core and for
        // triggering beamforming report generation
        wait (mac_bf_q.size() != 0);
        mac_bf_item = mac_bf_q.pop_back();

        if (mac_bf_item.cmd == BFMEE_CTRL) begin
          // save collected configuration of BFMEE core
          nc       = mac_bf_item.Nc;
          nr       = mac_bf_item.Nr;
          grouping = mac_bf_item.grouping;
          feedback = mac_bf_item.feedback_type;
          codebook = mac_bf_item.codebook;
          ch_bw    = mac_bf_item.ch_bw;
        end
        else begin
          `uvm_error(get_type_name(),
            $sformatf("To get beamforming report first triggering start of BFM must be done!"))
        end

        // wait for read out beamforming report
        wait (mac_bf_q.size() != 0);
        mac_bf_item = mac_bf_q.pop_back();

        if (mac_bf_item.cmd == BFMEE_REPORT) begin

          m_modem_cfg.get_bf_report(bfm_bits);
          convert_bit_to_byte(bfm_report);

          // compare beamforming reports
          foreach (mac_bf_item.bfm_report[i]) begin
            if (mac_bf_item.bfm_report[i] != bfm_report[i])
              `uvm_error(get_type_name(),
              $sformatf("BFM report mismatch: item bfm_report[%0d]=%0h - ref bfm_report[%0d]=%0h",
              i, mac_bf_item.bfm_report[i], i, bfm_report[i]))
          end
          `uvm_info(get_type_name(),$sformatf("BFMEE report matches the referent one!"),UVM_LOW)
        end
        else begin
          `uvm_error(get_type_name(),
            $sformatf("BFMEE_REPORT command should be executed after BFM report is created (%s)",mac_bf_item.cmd.name()))
        end
      end// if trans = RX
    end//forever
  endtask : run_phase

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase

  //---------------------------------------------------------------------------
  // list of functions for checking
  //---------------------------------------------------------------------------
  extern function void write_mac_bf(mac_bf_seq_item i);
  extern function void write_macphy_if_bf(mac_phy_seq_item i);
  extern function void convert_bit_to_byte(ref bit [7:0] bfm[]);
  extern task          compare_Hmem();
  //---------------------------------------------------------------------------

endclass : modem_bf_scoreboard

  //---------------------------------------------------------------------------
  // write functions
  //---------------------------------------------------------------------------

  function void modem_bf_scoreboard::write_mac_bf(mac_bf_seq_item i);
    mac_bf_seq_item it;

    // command for starting beamforming report generation
    // and command read out of beamforming report are proccessed.
    // Configuration command is not proccessed because other two
    // also contain needed configuration fields.
    if (i.cmd inside {BFMEE_CTRL,BFMEE_REPORT}) begin
      it = new();
      it.copy(i);
      mac_bf_q.push_front(it);
      `uvm_info(get_type_name(), $sformatf("Received MAC BF item :\n%s", it.sprint()), UVM_HIGH)
    end
  endfunction : write_mac_bf

  function void modem_bf_scoreboard::write_macphy_if_bf(mac_phy_seq_item i);
    mac_phy_seq_item it;

    // for beamforming checking, only NDP frames are relevant
    if (i.frame.kind == NDP) begin
      it = new();
      it.copy(i);
      mac_phy_q.push_front(it);
      `uvm_info(get_type_name(), $sformatf("Received MAC_PHY item :\n%s", it.sprint()), UVM_HIGH)
    end
  endfunction : write_macphy_if_bf

  //---------------------------------------------------------------------------
  // convert beamforming report from bit representation to byte representation
  //---------------------------------------------------------------------------
  function void modem_bf_scoreboard::convert_bit_to_byte(ref bit [7:0] bfm[]);
    int byte_cnt;

    bfm = new[bfm_bits.size()/8];
    byte_cnt = 0;
    `uvm_info(get_type_name(),
      $sformatf("BFM size in bits: %0d, BFM size in bytes: %0d",
      bfm_bits.size(),bfm_bits.size()/8),UVM_LOW)

    for (int i=0; i<bfm_bits.size(); i=i+8) begin
      bfm[byte_cnt][0] = bfm_bits[i+0];
      bfm[byte_cnt][1] = bfm_bits[i+1];
      bfm[byte_cnt][2] = bfm_bits[i+2];
      bfm[byte_cnt][3] = bfm_bits[i+3];
      bfm[byte_cnt][4] = bfm_bits[i+4];
      bfm[byte_cnt][5] = bfm_bits[i+5];
      bfm[byte_cnt][6] = bfm_bits[i+6];
      bfm[byte_cnt][7] = bfm_bits[i+7];
      byte_cnt++;
    end
  endfunction : convert_bit_to_byte

  //---------------------------------------------------------------------------
  // compare content of H memory with Matlab reference data
  //---------------------------------------------------------------------------
  task modem_bf_scoreboard::compare_Hmem();
    forever begin
      h_mem_fifo.get(h_mem_item);
      `uvm_info(get_type_name(),$sformatf("HMEM item: %s",h_mem_item.sprint()),UVM_DEBUG)
    end
  endtask : compare_Hmem

`endif //_MODEM_BF_SCOREBOARD_SV_
