//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef _MODEM_RADAR_SCOREBOARD_SV_
`define _MODEM_RADAR_SCOREBOARD_SV_

`uvm_analysis_imp_decl(_ahb)
`uvm_analysis_imp_decl(_irq_raw)

class modem_radar_scoreboard extends modem_scoreboard_base;

  `uvm_component_utils(modem_radar_scoreboard)

  //TODO add correct irq_raw_seq_item
  uvm_analysis_imp_irq_raw#(irq_raw_seq_item, modem_radar_scoreboard) irq_raw_export;
  uvm_analysis_imp_ahb#(ahb_master_seq_item, modem_radar_scoreboard)  ahb_master_export;


  function new(string name = "modem_radar_scoreboard", uvm_component parent = null);
    super.new(name, parent);

    ahb_master_export  = new("ahb_master_export", this);
    irq_raw_export     = new("irq_raw_export", this);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
    join_none;
  endtask : run_phase

  virtual function void write_ahb(ahb_master_seq_item_seq_item i);
  endfunction : write_stream_a

  virtual function void write_irq_raw(irq_raw_seq_item i);
  endfunction : write_irq_raw

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : modem_radar_scoreboard

`endif //_MODEM_RADAR_SCOREBOARD_SV_
